'\"
'\" Generated from file 'mkdoc\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2019-2022, Detlef Groth <detlef(at)dgroth(dot)de>
'\"
.TH "mkdoc" n 0\&.7\&.0 tcllib "Source code documentation using Markdown"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
mkdoc \- Source code documentation extractor/converter application
.SH SYNOPSIS
\fBmkdoc\fR \fB--help\fR
.sp
\fBmkdoc\fR \fB--version\fR
.sp
\fBmkdoc\fR \fB--license\fR
.sp
\fBmkdoc\fR \fIinput\fR \fIoutput\fR ?\fB--css\fR \fIcssfile\fR?
.sp
.BE
.SH DESCRIPTION
This document describes \fBmkdoc\fR, an application to extract documentation embedded in
source code files, be they "\fI\&.tcl\fR", or other\&.
.SH "COMMAND LINE"
.TP
\fBmkdoc\fR \fB--help\fR
The application prints a short help to standard output and exits\&.
.TP
\fBmkdoc\fR \fB--version\fR
The application prints its version number to standard output and exits\&.
.TP
\fBmkdoc\fR \fB--license\fR
The application prints its license to standard output and exits\&.
.TP
\fBmkdoc\fR \fIinput\fR \fIoutput\fR ?\fB--css\fR \fIcssfile\fR?
The application reads the \fIinput\fR file, extracts the embedded documentation, and
writes it to the \fIoutput\fR file\&.
.sp
If the output file is not a "\fI\&.md\fR" file the extracted documentation is
converted to HTML before being written\&.
.sp
When generating and writing HTML the default CSS stylesheet can be overridden by
specifying the path to a custom stylesheet via option \fB--css\fR\&.
.sp
If the input file is a "\fI\&.md\fR" file it is expected to contain Markdown as-is,
instead of Markdown embedded into code\&.
.sp
On the other side, when the file is considered code then the documentation is
expected to be contained in all lines starting with the marker \fB#'\fR\&.
For script languages like Tcl the \fB#\fR character of this marker means that the
documentation is contained in the so-flagged comments\&.
For other languages the marker and documentation may have to be embedded into multi-line
comments\&.
.PP
.SH EXAMPLES
.CS


    # Create HTML manual for a CPP file using a custom style sheet
    mkdoc sample\&.cpp sample\&.html --css manual\&.css

    # Extract the documentation from code as simple Markdown, ready to be processed
    # further, for example with pandoc, or similar
    mkdoc sample\&.cpp sample\&.md

    # Convert a Markdown file to HTML
    mkdoc sample\&.md sample\&.html

.CE
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain bugs and
other problems\&. Please report such to the author of this package\&. Please also report any ideas for enhancements you may have for
either package and/or documentation\&.
.SH "CODE COPYRIGHT"
BSD License type:
.PP
The following terms apply to all files a ssociated with the software unless
explicitly disclaimed in individual files\&.
.PP
The authors hereby grant permission to use, copy, modify, distribute, and license
this software and its documentation for any purpose, provided that existing copyright
notices are retained in all copies and that this notice is included verbatim in any
distributions\&. No written agreement, license, or royalty fee is required for any of the
authorized uses\&.  Modifications to this software may be copyrighted by their authors and
need not follow the licensing terms described here, provided that the new terms are
clearly indicated on the first page of each file where they apply\&.
.PP
In no event shall the authors or distributors be liable to any party for direct,
indirect, special, incidental, or consequential damages arising out of the use of this
software, its documentation, or any derivatives thereof, even if the authors have been
advised of the possibility of such damage\&.
.PP
The authors and distributors specifically disclaim any warranties, including, but
not limited to, the implied warranties of merchantability, fitness for a particular
purpose, and non-infringement\&.
This software is provided on an "as is" basis, and the authors and distributors have no
obligation to provide maintenance, support, updates, enhancements, or modifications\&.
.PP
\fIRESTRICTED RIGHTS\fR: Use, duplication or disclosure by the government is
subject to the restrictions as set forth in subparagraph (c) (1) (ii) of the Rights in
Technical Data and Computer Software Clause as DFARS 252\&.227-7013 and FAR 52\&.227-19\&.
.SH CATEGORY
Text processing
.SH COPYRIGHT
.nf
Copyright (c) 2019-2022, Detlef Groth <detlef(at)dgroth(dot)de>

.fi
