require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_RISCV_CPU_H_)) {
    eval 'sub _RISCV_CPU_H_ () {1;}' unless defined(&_RISCV_CPU_H_);
    if(defined(&_KERNEL) || defined(&_KMEMUSER)) {
	eval 'sub CLKF_USERMODE {
	    my($cf) = @_;
    	    eval q(((($cf)-> &cf_status &  &SR_SPP) == 0));
	}' unless defined(&CLKF_USERMODE);
	eval 'sub CLKF_PC {
	    my($cf) = @_;
    	    eval q((($cf)-> &cf_epc));
	}' unless defined(&CLKF_PC);
	eval 'sub CLKF_INTR {
	    my($cf) = @_;
    	    eval q((($cf)-> &cf_intr_depth > 1));
	}' unless defined(&CLKF_INTR);
	require 'sys/cpu_data.ph';
	require 'sys/device_if.ph';
	require 'sys/evcnt.ph';
	require 'sys/intr.ph';
	if(defined(&_LP64)) {
	}
	if(defined(&MULTIPROCESSOR)) {
	    eval 'sub CPUF_PRIMARY () { &__BIT(0);}' unless defined(&CPUF_PRIMARY);
	    eval 'sub CPUF_PRESENT () { &__BIT(1);}' unless defined(&CPUF_PRESENT);
	    eval 'sub CPUF_RUNNING () { &__BIT(2);}' unless defined(&CPUF_RUNNING);
	    eval 'sub CPUF_PAUSED () { &__BIT(3);}' unless defined(&CPUF_PAUSED);
	}
	if(defined(&GPROF)  && defined(&MULTIPROCESSOR)) {
	}
    }
    if(defined(&_KERNEL)) {
	if(defined(&MULTIPROCESSOR)) {
	}
	eval 'sub curlwp () { &riscv_curlwp;}' unless defined(&curlwp);
	eval 'sub curcpu () {
	    eval q( &lwp_getcpu( &curlwp));
	}' unless defined(&curcpu);
	eval 'sub curpcb () {( &lwp_getpcb( &curlwp));}' unless defined(&curpcb);
# some #ifdef were dropped here -- fill in the blanks
	eval 'sub cpu_number {
	    my($void) = @_;
    	    eval q({ });
	}' unless defined(&cpu_number);
	eval 'sub CPU_INFO_ITERATOR () { &cpuid_t;}' unless defined(&CPU_INFO_ITERATOR);
	if(defined(&MULTIPROCESSOR)) {
	    eval 'sub CPU_IS_PRIMARY {
	        my($ci) = @_;
    		eval q((($ci)-> &ci_flags &  &CPUF_PRIMARY));
	    }' unless defined(&CPU_IS_PRIMARY);
	    eval 'sub CPU_INFO_FOREACH {
	        my($cii, $ci) = @_;
    		eval q($cii = 0, $ci =  $cpu_info_store[0]; $ci !=  &NULL; $cii++,  &ncpu ? ($ci =  $cpu_infos[$cii]) : ($ci =  &NULL));
	    }' unless defined(&CPU_INFO_FOREACH);
	} else {
	    eval 'sub CPU_IS_PRIMARY {
	        my($ci) = @_;
    		eval q( &true);
	    }' unless defined(&CPU_IS_PRIMARY);
	    eval 'sub CPU_INFO_FOREACH {
	        my($cii, $ci) = @_;
    		eval q(($cii) = 0, ($ci) =  &curcpu(); ($cii) == 0; ($cii)++);
	    }' unless defined(&CPU_INFO_FOREACH);
	}
	eval 'sub CPU_INFO_CURPMAP {
	    my($ci) = @_;
    	    eval q(( ($curlwp->{l_proc}->{p_vmspace}->{vm_map}->{pmap})));
	}' unless defined(&CPU_INFO_CURPMAP);
	eval 'sub cpu_dosoftints {
	    my($void) = @_;
    	    eval q({ $void  &dosoftints($void); \'struct cpu_info\' *  &const  &ci =  &curcpu();  &if ( ($ci->{ci_intr_depth}) == 0 && ( ($ci->{ci_data}->{cpu_softints}) >>  ($ci->{ci_cpl})) > 0)  &dosoftints(); });
	}' unless defined(&cpu_dosoftints);
	eval 'sub cpu_intr_p {
	    my($void) = @_;
    	    eval q({  &curcpu()-> &ci_intr_depth > 0; });
	}' unless defined(&cpu_intr_p);
	eval 'sub LWP_PC {
	    my($l) = @_;
    	    eval q( &cpu_lwp_pc($l));
	}' unless defined(&LWP_PC);
	eval 'sub cpu_idle {
	    my($void) = @_;
    	    eval q({  &asm  &volatile(\\"wfi\\" ::: \\"memory\\"); });
	}' unless defined(&cpu_idle);
    }
}
1;
