require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_RISCV_PARAM_H_)) {
    eval 'sub _RISCV_PARAM_H_ () {1;}' unless defined(&_RISCV_PARAM_H_);
    if(defined(&_KERNEL_OPT)) {
	require './riscv/opt_param.ph';
    }
    if(defined(&_LP64)) {
	eval 'sub _MACHINE_ARCH () { &riscv64;}' unless defined(&_MACHINE_ARCH);
	eval 'sub MACHINE_ARCH () {"riscv64";}' unless defined(&MACHINE_ARCH);
	eval 'sub _MACHINE_ARCH32 () { &riscv32;}' unless defined(&_MACHINE_ARCH32);
	eval 'sub MACHINE_ARCH32 () {"riscv32";}' unless defined(&MACHINE_ARCH32);
    } else {
	eval 'sub _MACHINE_ARCH () { &riscv32;}' unless defined(&_MACHINE_ARCH);
	eval 'sub MACHINE_ARCH () {"riscv32";}' unless defined(&MACHINE_ARCH);
    }
    eval 'sub _MACHINE () { &riscv;}' unless defined(&_MACHINE);
    eval 'sub MACHINE () {"riscv";}' unless defined(&MACHINE);
    eval 'sub MID_MACHINE () { &MID_RISCV;}' unless defined(&MID_MACHINE);
    eval 'sub STACK_ALIGNBYTES () {(16 - 1);}' unless defined(&STACK_ALIGNBYTES);
    eval 'sub ALIGNBYTES32 () { &__BIGGEST_ALIGNMENT__;}' unless defined(&ALIGNBYTES32);
    eval 'sub NKMEMPAGES_MIN_DEFAULT () {((128 * 1024* 1024) >>  &PAGE_SHIFT);}' unless defined(&NKMEMPAGES_MIN_DEFAULT);
    eval 'sub NKMEMPAGES_MAX_UNLIMITED () {1;}' unless defined(&NKMEMPAGES_MAX_UNLIMITED);
    eval 'sub PGSHIFT () {12;}' unless defined(&PGSHIFT);
    eval 'sub NBPG () {(1<<  &PGSHIFT);}' unless defined(&NBPG);
    eval 'sub PGOFSET () {( &NBPG - 1);}' unless defined(&PGOFSET);
    eval 'sub UPAGES () {2;}' unless defined(&UPAGES);
    eval 'sub USPACE () {( &UPAGES <<  &PGSHIFT);}' unless defined(&USPACE);
    eval 'sub USPACE_ALIGN () { &NBPG;}' unless defined(&USPACE_ALIGN);
    eval 'sub MSIZE () {512;}' unless defined(&MSIZE);
    unless(defined(&MCLSHIFT)) {
	eval 'sub MCLSHIFT () {11;}' unless defined(&MCLSHIFT);
    }
    eval 'sub MCLBYTES () {(1<<  &MCLSHIFT);}' unless defined(&MCLBYTES);
    unless(defined(&MSGBUFSIZE)) {
	eval 'sub MSGBUFSIZE () {65536;}' unless defined(&MSGBUFSIZE);
    }
    eval 'sub MAXCPUS () {32;}' unless defined(&MAXCPUS);
    if(defined(&_KERNEL)) {
	eval 'sub DELAY {
	    my($x) = @_;
    	    eval q( &delay($x));
	}' unless defined(&DELAY);
    }
    eval 'sub riscv_btop {
        my($x) = @_;
	    eval q((($x) >>  &PGSHIFT));
    }' unless defined(&riscv_btop);
    eval 'sub riscv_ptob {
        my($x) = @_;
	    eval q((($x) <<  &PGSHIFT));
    }' unless defined(&riscv_ptob);
}
1;
