/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.counts;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.io.FastByteArrayInputStream;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.campagnelab.goby.counts.CountsReader;
import org.campagnelab.goby.counts.compound.CompoundDataInput;
import org.campagnelab.goby.counts.compound.CompoundDirectoryEntry;
import org.campagnelab.goby.counts.compound.CompoundFileReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CountsArchiveReader
implements Closeable {
    protected final CompoundFileReader compoundReader;
    private final Int2ObjectMap<String> indexToIdentifierMap;
    private Object2IntMap<String> identifierToIndexMap;
    private long totalBasesSeen;
    private long totalSitesSeen;
    static final String COUNT_ARCHIVE_MODIFIER_DEFAULT = "counts";
    private static final Logger LOG = LoggerFactory.getLogger(CountsArchiveReader.class);

    public long getTotalBasesSeen() {
        return this.totalBasesSeen;
    }

    public long getTotalSitesSeen() {
        return this.totalSitesSeen;
    }

    public boolean isStatsParsed() {
        return this.totalBasesSeen != 0L && this.totalSitesSeen != 0L;
    }

    public CountsArchiveReader(String basename) throws IOException {
        this(basename, COUNT_ARCHIVE_MODIFIER_DEFAULT);
    }

    public CountsArchiveReader(String basename, String alternativeCountArchiveExtension) throws IOException {
        this.compoundReader = new CompoundFileReader(basename + "." + alternativeCountArchiveExtension);
        this.indexToIdentifierMap = new Int2ObjectOpenHashMap();
        this.identifierToIndexMap = new Object2IntOpenHashMap();
        this.scanDirectory();
    }

    public CountsReader getCountReader(String identifier) throws IOException {
        String name = this.makeFileIdentifier(identifier);
        CompoundDataInput input = this.compoundReader.readFile(name);
        byte[] bytes = new byte[(int)input.length()];
        input.readFully(bytes);
        FastByteArrayInputStream countStream = new FastByteArrayInputStream(bytes);
        String indexName = "#index:" + name;
        if (this.compoundReader.containsFile(indexName)) {
            CompoundDataInput indexInput = this.compoundReader.readFile(indexName);
            return new CountsReader((InputStream)countStream, indexInput);
        }
        return new CountsReader((InputStream)countStream);
    }

    public CountsReader getCountReader(int countInfoIndex) throws IOException {
        return this.getCountReader(this.makeFileIdentifier(countInfoIndex));
    }

    private String makeFileIdentifier(int countInfoIndex) {
        return countInfoIndex + "," + (String)this.indexToIdentifierMap.get(countInfoIndex);
    }

    public String getIdentifier(int index) {
        return (String)this.indexToIdentifierMap.get(index);
    }

    protected String makeFileIdentifier(String countId) {
        return countId.indexOf(44) == -1 ? this.identifierToIndexMap.get((Object)countId) + "," + countId : countId;
    }

    public int getNumberOfIndices() {
        return this.identifierToIndexMap.size();
    }

    public ObjectSet<String> getIdentifiers() {
        ObjectOpenHashSet result = new ObjectOpenHashSet();
        Collection<CompoundDirectoryEntry> directory = this.compoundReader.getDirectory();
        for (CompoundDirectoryEntry entry : directory) {
            String name = entry.getName();
            if (name.startsWith("#")) continue;
            String[] tokens = name.split(",");
            if (tokens.length < 2) {
                return null;
            }
            result.add((Object)tokens[1]);
        }
        return result;
    }

    private void scanDirectory() {
        Collection<CompoundDirectoryEntry> directory = this.compoundReader.getDirectory();
        for (CompoundDirectoryEntry entry : directory) {
            String name = entry.getName();
            if (!name.startsWith("#")) {
                String[] tokens = name.split(",");
                assert (tokens.length == 2) : "archive count filenames must be of the form int,String";
                int index = Integer.parseInt(tokens[0]);
                String id = tokens[1];
                this.indexToIdentifierMap.put(index, (Object)id);
                this.identifierToIndexMap.put((Object)id, index);
                continue;
            }
            this.parseSpecialFile(entry);
        }
    }

    private void parseSpecialFile(CompoundDirectoryEntry entry) {
        if ("#stats".equals(entry.getName())) {
            try {
                CompoundDataInput input = this.compoundReader.readFile("#stats");
                boolean done = false;
                while (!done) {
                    String key = input.readUTF();
                    if ("totalBasesSeen".equals(key)) {
                        this.totalBasesSeen = input.readLong();
                    } else if ("totalSitesSeen".equals(key)) {
                        this.totalSitesSeen = input.readLong();
                    }
                    if (!"END".equals(key)) continue;
                    done = true;
                }
            }
            catch (IOException e) {
                LOG.error("could not access special file #stats in counts archive");
            }
        }
    }

    public IntSet getIndices() {
        IntArraySet result = new IntArraySet();
        Collection<CompoundDirectoryEntry> directory = this.compoundReader.getDirectory();
        for (CompoundDirectoryEntry entry : directory) {
            String name = entry.getName();
            if (name.startsWith("#")) continue;
            String[] tokens = name.split(",");
            if (tokens.length < 1) {
                return null;
            }
            result.add(Integer.parseInt(tokens[0]));
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        this.compoundReader.close();
    }
}

