/*
 * Decompiled with CFR 0.152.
 */
package net.bluecow.spectro;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import net.bluecow.spectro.Clip;
import net.bluecow.spectro.ClipDataChangeEvent;
import net.bluecow.spectro.ClipDataChangeListener;
import net.bluecow.spectro.Frame;
import net.bluecow.spectro.LogarithmicColorizer;
import net.bluecow.spectro.PlaybackPositionEvent;
import net.bluecow.spectro.PlaybackPositionListener;
import net.bluecow.spectro.PlayerThread;
import net.bluecow.spectro.ValueColorizer;

public class ClipPanel
extends JPanel
implements Scrollable {
    private static final Logger logger = Logger.getLogger(ClipPanel.class.getName());
    private final Clip clip;
    private final BufferedImage img;
    private final int[] imgPixels;
    private Rectangle region;
    private Rectangle oldRegion;
    private boolean regionMode;
    private final RegionMouseHandler mouseHandler = new RegionMouseHandler();
    private final ClipPositionHeader clipPositionHeader = new ClipPositionHeader();
    private boolean undoing;
    private ValueColorizer colorizer = new LogarithmicColorizer(this);
    private ClipDataChangeListener clipDataChangeHandler = new ClipDataChangeListener(){

        public void clipDataChanged(ClipDataChangeEvent e) {
            Rectangle r = ClipPanel.this.toScreenCoords(e.getRegion());
            ClipPanel.this.updateImage(r);
            ClipPanel.this.repaint(r);
        }
    };
    private final UndoableEditSupport undoSupport = new UndoableEditSupport(this);

    public static ClipPanel newInstance(Clip clip, PlayerThread playerThread) {
        ClipPanel cp = new ClipPanel(clip);
        clip.addClipDataChangeListener(cp.clipDataChangeHandler);
        playerThread.addPlaybackPositionListener(cp.clipPositionHeader);
        cp.clipPositionHeader.setPlayerThread(playerThread);
        return cp;
    }

    private ClipPanel(Clip clip) {
        this.clip = clip;
        this.setPreferredSize(new Dimension(clip.getFrameCount(), clip.getFrameFreqSamples()));
        this.img = new BufferedImage(clip.getFrameCount(), clip.getFrameFreqSamples(), 1);
        this.imgPixels = ((DataBufferInt)this.img.getRaster().getDataBuffer()).getData();
        this.updateImage(null);
        this.setBackground(Color.BLACK);
    }

    public Point toClipCoords(Point p) {
        p.y = this.clip.getFrameFreqSamples() - p.y;
        return p;
    }

    public Rectangle toClipCoords(Rectangle r) {
        r.y = this.clip.getFrameFreqSamples() - (r.y + r.height);
        return r;
    }

    public Point toScreenCoords(Point p) {
        p.y = this.clip.getFrameFreqSamples() - p.y;
        return p;
    }

    public Rectangle toScreenCoords(Rectangle r) {
        return this.toClipCoords(r);
    }

    public ValueColorizer getColorizer() {
        return this.colorizer;
    }

    void updateImage(Rectangle region) {
        if (this.clip == null) {
            return;
        }
        region = region == null ? new Rectangle(0, 0, this.clip.getFrameCount(), this.clip.getFrameFreqSamples()) : new Rectangle(region);
        this.toClipCoords(region);
        int endCol = region.x + region.width;
        int endRow = region.y + region.height;
        for (int col = region.x; col < endCol; ++col) {
            Frame f = this.clip.getFrame(col);
            for (int row = region.y; row < endRow; ++row) {
                this.imgPixels[col + row * this.img.getWidth()] = this.colorizer.colorFor(f.getReal(row));
            }
        }
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform backupTransform = g2.getTransform();
        g2.translate(0, this.img.getHeight());
        g2.scale(1.0, -1.0);
        Rectangle clipBounds = g2.getClipBounds();
        logger.finer(String.format("Clip bounds: (%d, %d) %dx%d", clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height));
        if (clipBounds.x + clipBounds.width > this.img.getWidth()) {
            clipBounds.width = this.img.getWidth() - clipBounds.x;
        }
        if (clipBounds != null) {
            g2.drawImage(this.img, clipBounds.x, clipBounds.y, clipBounds.x + clipBounds.width, clipBounds.y + clipBounds.height, clipBounds.x, clipBounds.y, clipBounds.x + clipBounds.width, clipBounds.y + clipBounds.height, Color.BLACK, null);
        } else {
            g2.drawImage((Image)this.img, 0, 0, null);
        }
        g2.setTransform(backupTransform);
        if (this.region != null) {
            g2.setColor(Color.YELLOW);
            g2.drawRect(this.region.x, this.region.y, this.region.width, this.region.height);
        }
    }

    public Clip getClip() {
        return this.clip;
    }

    private void repaintRegion() {
        Rectangle newRegion;
        Rectangle rectangle = newRegion = this.region == null ? null : new Rectangle(this.region);
        if (this.oldRegion != null && newRegion == null) {
            this.repaint(this.oldRegion.x, this.oldRegion.y, this.oldRegion.width + 1, this.oldRegion.height + 1);
        } else if (this.oldRegion == null && newRegion != null) {
            this.repaint(newRegion.x, newRegion.y, newRegion.width + 1, newRegion.height + 1);
        } else if (this.oldRegion != null && newRegion != null) {
            this.oldRegion.add(newRegion);
            this.repaint(this.oldRegion.x, this.oldRegion.y, this.oldRegion.width + 1, this.oldRegion.height + 1);
        }
        this.oldRegion = newRegion;
    }

    public void setRegionMode(boolean on) {
        if (on != this.regionMode) {
            if (on) {
                this.regionMode = true;
                this.addMouseListener(this.mouseHandler);
                this.addMouseMotionListener(this.mouseHandler);
            } else {
                this.regionMode = false;
                this.setRegion(null);
                this.oldRegion = null;
                this.removeMouseListener(this.mouseHandler);
                this.removeMouseMotionListener(this.mouseHandler);
            }
        }
    }

    public Rectangle getRegion() {
        if (this.region == null) {
            return null;
        }
        return new Rectangle(this.region);
    }

    private void setRegion(Rectangle r) {
        Rectangle oldRegion = this.region;
        this.region = this.normalized(r);
        this.repaintRegion();
        this.firePropertyChange("region", oldRegion, this.region);
        if (!this.undoing) {
            this.undoSupport.postEdit(new RegionMoveEdit(oldRegion));
        }
    }

    private Rectangle normalized(Rectangle rect) {
        if (rect == null) {
            return null;
        }
        rect = new Rectangle(rect);
        if (rect.width < 0) {
            rect.x += rect.width;
            rect.width *= -1;
        }
        if (rect.height < 0) {
            rect.y += rect.height;
            rect.height *= -1;
        }
        return rect;
    }

    public void addNotify() {
        super.addNotify();
        Container p = this.getParent();
        if (p instanceof JViewport && p.getParent() instanceof JScrollPane) {
            JScrollPane sp = (JScrollPane)p.getParent();
            sp.setColumnHeaderView(this.clipPositionHeader);
        }
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return (int)((double)visibleRect.width * 0.9);
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 50;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public void addUndoableEditListener(UndoableEditListener l) {
        this.undoSupport.addUndoableEditListener(l);
    }

    public void removeUndoableEditListener(UndoableEditListener l) {
        this.undoSupport.removeUndoableEditListener(l);
    }

    private class ClipPositionHeader
    extends JPanel
    implements PlaybackPositionListener {
        private PlayerThread playerThread;
        volatile long playbackPosition;
        private final MouseListener repositionHandler = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                ClipPositionHeader.this.playerThread.setPlaybackPosition(e.getX() * ClipPanel.this.clip.getFrameTimeSamples());
            }
        };

        public ClipPositionHeader() {
            this.setPreferredSize(new Dimension(1, 20));
            this.addMouseListener(this.repositionHandler);
        }

        public void setPlayerThread(PlayerThread playerThread) {
            this.playerThread = playerThread;
        }

        public void playbackPositionUpdate(PlaybackPositionEvent e) {
            int oldPixelPosition = this.playbackPixelPosition();
            this.playbackPosition = e.getSamplePos();
            int newPixelPosition = this.playbackPixelPosition();
            if (newPixelPosition >= oldPixelPosition) {
                this.repaint(oldPixelPosition, 0, newPixelPosition - oldPixelPosition + 1, this.getHeight());
            } else {
                this.repaint(newPixelPosition, 0, oldPixelPosition - newPixelPosition + 1, this.getHeight());
            }
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.setColor(Color.BLACK);
            g.drawRect(this.playbackPixelPosition(), 0, 1, this.getHeight());
        }

        private int playbackPixelPosition() {
            return (int)(this.playbackPosition / (long)ClipPanel.this.clip.getFrameTimeSamples());
        }
    }

    private final class RegionMoveEdit
    extends AbstractUndoableEdit {
        private Rectangle oldr;
        private final Rectangle newr;

        private RegionMoveEdit(Rectangle oldRegion) {
            this.newr = ClipPanel.this.region;
            this.oldr = oldRegion;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            ClipPanel.this.undoing = true;
            ClipPanel.this.setRegion(this.oldr);
            ClipPanel.this.undoing = false;
        }

        public void redo() throws CannotRedoException {
            super.redo();
            ClipPanel.this.undoing = true;
            ClipPanel.this.setRegion(this.newr);
            ClipPanel.this.undoing = false;
        }

        public boolean isSignificant() {
            return false;
        }

        public boolean replaceEdit(UndoableEdit anEdit) {
            if (anEdit instanceof RegionMoveEdit) {
                RegionMoveEdit replaceMe = (RegionMoveEdit)anEdit;
                this.oldr = replaceMe.oldr;
                replaceMe.die();
                return true;
            }
            return false;
        }

        public String toString() {
            return "Region move: " + this.oldr + " -> " + this.newr;
        }
    }

    private class RegionMouseHandler
    implements MouseMotionListener,
    MouseListener {
        MouseMode mode = MouseMode.IDLE;
        Point moveHandle;
        Rectangle tempRegion;

        private RegionMouseHandler() {
        }

        public void mouseDragged(MouseEvent e) {
            switch (this.mode) {
                case IDLE: {
                    this.startRect(e.getPoint());
                    break;
                }
                case SIZING: {
                    this.resizeRect(e.getPoint());
                    break;
                }
                case MOVING: {
                    this.moveRect(e.getPoint());
                }
            }
            ClipPanel.this.setRegion(this.tempRegion);
        }

        public void mousePressed(MouseEvent e) {
            this.tempRegion = ClipPanel.this.normalized(ClipPanel.this.region);
            Point p = e.getPoint();
            if (this.tempRegion != null && this.tempRegion.contains(p)) {
                this.mode = MouseMode.MOVING;
                this.moveHandle = new Point(p.x - this.tempRegion.x, p.y - this.tempRegion.y);
            } else {
                this.startRect(p);
                this.mode = MouseMode.SIZING;
            }
            ClipPanel.this.setRegion(this.tempRegion);
        }

        public void mouseReleased(MouseEvent e) {
            this.mode = MouseMode.IDLE;
            ClipPanel.this.setRegion(this.tempRegion);
            this.tempRegion = null;
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        private void startRect(Point p) {
            this.tempRegion = new Rectangle(p.x, p.y, 0, 0);
        }

        private void resizeRect(Point p) {
            this.tempRegion.width = p.x - this.tempRegion.x;
            this.tempRegion.height = p.y - this.tempRegion.y;
            logger.finer("Resizing region to: " + this.tempRegion);
        }

        private void moveRect(Point p) {
            this.tempRegion.x = p.x - this.moveHandle.x;
            this.tempRegion.y = p.y - this.moveHandle.y;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum MouseMode {
        IDLE,
        SIZING,
        MOVING;

    }
}

