/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import blbutil.Filter;
import blbutil.Utilities;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import vcf.Marker;

public final class FilterUtil {
    private FilterUtil() {
    }

    public static Filter<Marker> markerFilter(File file) {
        if (file == null) {
            return Filter.acceptAllFilter();
        }
        Set<String> set = Utilities.idSet(file);
        return FilterUtil.idFilter(set);
    }

    public static Filter<String> sampleFilter(File file) {
        if (file == null) {
            return Filter.acceptAllFilter();
        }
        Set<String> set = Utilities.idSet(file);
        return Filter.excludeFilter(set);
    }

    public static boolean markerIsInSet(Marker marker, Set<String> set) {
        int n = marker.nIds();
        for (int i = 0; i < n; ++i) {
            if (!set.contains(marker.id(i))) continue;
            return true;
        }
        String string = marker.chrom() + ':' + marker.pos();
        return set.contains(string);
    }

    public static Filter<Marker> idFilter(Collection<String> collection) {
        HashSet<String> hashSet = new HashSet<String>(collection);
        if (hashSet.isEmpty()) {
            return marker -> true;
        }
        return marker -> !FilterUtil.markerIsInSet(marker, hashSet);
    }
}

