/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.igoweb.client.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;
import javax.swing.UIManager;

public class WorkingIcon
implements Icon {
    private final boolean isWorking;
    private final long CYCLE_LENGTH = 4000L;
    private final double ROTATION_SPEED = 0.0015707963267948967;

    public WorkingIcon(boolean isWorking) {
        this.isWorking = isWorking;
    }

    @Override
    public int getIconHeight() {
        return (UIManager.getInt("org.igoweb.fontH") * 3 + 2) / 4;
    }

    @Override
    public int getIconWidth() {
        return this.getIconHeight();
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setColor(this.isWorking && c.isEnabled() ? UIManager.getColor("Label.foreground") : UIManager.getColor("org.igoweb.stdBg").darker());
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        int size = this.getIconHeight();
        float fx = x;
        float fy = y;
        float fs = size;
        Area shape = new Area(new Ellipse2D.Float(fx, fy, fs, fs));
        shape.subtract(new Area(new Ellipse2D.Float(fx + fs * 0.05f, fy + fs * 0.05f, fs * 0.9f, fs * 0.9f)));
        if (this.isWorking) {
            shape.add(new Area(new Rectangle2D.Float(fx + fs * 0.049f, fy + fs * 0.475f, fs * 0.92f, fs * 0.05f)));
            shape.add(new Area(new Rectangle2D.Float(fx + fs * 0.475f, fy + fs * 0.049f, fs * 0.05f, fs * 0.92f)));
            shape = shape.createTransformedArea(AffineTransform.getRotateInstance((double)(System.currentTimeMillis() % 4000L) * 0.0015707963267948967, (double)fx + (double)fs * 0.5, (double)fy + (double)fs * 0.5));
        }
        g2d.fill(shape);
        g2d.dispose();
    }
}

