/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.protocol.ftp;

import gnu.java.net.protocol.ftp.DTP;
import gnu.java.net.protocol.ftp.DTPOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class CompressedOutputStream
extends DTPOutputStream {
    static final byte RECORD = -128;
    static final byte EOF = 64;

    public void write(int c) throws IOException {
        if (this.transferComplete) {
            return;
        }
        byte[] byArray = new byte[5];
        byArray[0] = -128;
        byArray[2] = 1;
        byArray[3] = 1;
        byArray[4] = (byte)c;
        byte[] buf = byArray;
        this.out.write(buf, 0, 5);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.transferComplete) {
            return;
        }
        byte[] buf = this.compress(b, off, len);
        len = buf.length;
        buf[0] = -128;
        buf[1] = (byte)((len & 0xFF) >> 8);
        buf[2] = (byte)(len & 0xFF00);
        this.out.write(buf, 0, len);
    }

    byte[] compress(byte[] b, int off, int len) {
        byte[] buf = new byte[len];
        byte last = 0;
        int pos = 0;
        int raw_count = 0;
        int rep_count = 1;
        int i = off;
        while (i < len) {
            byte c = b[i];
            if (i > off && c == last) {
                if (raw_count > 0) {
                    if (pos + (raw_count + 1) > buf.length) {
                        buf = this.realloc(buf, len);
                    }
                    pos = this.flush_raw(buf, pos, b, i - raw_count - 1, raw_count);
                    raw_count = 0;
                }
                ++rep_count;
            } else {
                if (rep_count > 1) {
                    if (pos + 2 > buf.length) {
                        buf = this.realloc(buf, len);
                    }
                    pos = this.flush_compressed(buf, pos, rep_count, last);
                    rep_count = 1;
                }
                ++raw_count;
            }
            if (rep_count == 127) {
                if (pos + 2 > buf.length) {
                    buf = this.realloc(buf, len);
                }
                pos = this.flush_compressed(buf, pos, rep_count, last);
                rep_count = 1;
            }
            if (raw_count == 127) {
                if (pos + (raw_count + 1) > buf.length) {
                    buf = this.realloc(buf, len);
                }
                pos = this.flush_raw(buf, pos, b, i - raw_count, raw_count);
                raw_count = 0;
            }
            last = c;
            ++i;
        }
        if (rep_count > 1) {
            if (pos + 2 > buf.length) {
                buf = this.realloc(buf, len);
            }
            pos = this.flush_compressed(buf, pos, rep_count, last);
            rep_count = 1;
        }
        if (raw_count > 0) {
            if (pos + (raw_count + 1) > buf.length) {
                buf = this.realloc(buf, len);
            }
            pos = this.flush_raw(buf, pos, b, len - raw_count, raw_count);
            raw_count = 0;
        }
        byte[] ret = new byte[pos + 3];
        System.arraycopy(buf, 0, ret, 3, pos);
        return ret;
    }

    int flush_compressed(byte[] buf, int pos, int count, byte c) {
        buf[pos++] = (byte)(0x80 | count);
        buf[pos++] = c;
        return pos;
    }

    int flush_raw(byte[] buf, int pos, byte[] src, int off, int len) {
        buf[pos++] = (byte)len;
        System.arraycopy(src, off, buf, pos, len);
        return pos + len;
    }

    byte[] realloc(byte[] buf, int len) {
        byte[] ret = new byte[buf.length + len];
        System.arraycopy(buf, 0, ret, 0, buf.length);
        return ret;
    }

    public void close() throws IOException {
        byte[] byArray = new byte[3];
        byArray[0] = 64;
        byte[] buf = byArray;
        this.out.write(buf, 0, 3);
        this.out.close();
    }

    CompressedOutputStream(DTP dtp, OutputStream out) {
        super(dtp, out);
    }
}

