/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.itadaki.bzip2.BZip2InputStream;

public class Decompress {
    public static void main(String[] args) throws IOException {
        int bytesRead;
        File outputFile;
        File inputFile;
        if (args.length == 0) {
            System.err.println("Demonstration BZip2 decompressor\n\nUsage:\n  java demo.Decompress <filename>\n");
            System.exit(1);
        }
        if (!((inputFile = new File(args[0])).exists() && inputFile.canRead() && args[0].endsWith(".bz2"))) {
            System.err.println("Cannot read file " + inputFile.getPath());
            System.exit(1);
        }
        if ((outputFile = new File(args[0].substring(0, args[0].length() - 4))).exists()) {
            System.err.println("File " + outputFile.getPath() + " already exists");
            System.exit(1);
        }
        BufferedInputStream fileInputStream = new BufferedInputStream(new FileInputStream(inputFile));
        BZip2InputStream inputStream = new BZip2InputStream(fileInputStream, false);
        BufferedOutputStream fileOutputStream = new BufferedOutputStream(new FileOutputStream(outputFile), 524288);
        byte[] decoded = new byte[524288];
        while ((bytesRead = inputStream.read(decoded)) != -1) {
            ((OutputStream)fileOutputStream).write(decoded, 0, bytesRead);
        }
        ((OutputStream)fileOutputStream).close();
    }
}

