/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util.blat;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.track.BlatTrack;
import org.broad.igv.track.SequenceTrack;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.LongRunningTask;
import org.broad.igv.util.NamedRunnable;
import org.broad.igv.util.blat.BlatQueryWindow;

public class BlatClient {
    private static Logger log = Logger.getLogger(BlatClient.class);
    public static final int MINIMUM_BLAT_LENGTH = 20;
    static int sleepTime = 15000;
    static String hgsid;
    static long lastQueryTime;

    public static void main(String[] args) throws IOException {
        if (args.length != 6) {
            BlatClient.Usage();
            System.exit(255);
        }
        String org = args[0];
        String db = args[1];
        String searchType = args[2];
        String sortOrder = args[3];
        String outputType = args[4];
        String userSeq = args[5];
        BlatClient.blat(org, db, searchType, sortOrder, outputType, userSeq);
    }

    static void Usage() {
        System.out.println("usage: BlatBot <organism> <db> <searchType> <sortOrder>");
        System.out.println(" <outputType> <querySequence>");
        System.out.println("\tSpecify organism using the common name with first letter");
        System.out.println("capitalized.");
        System.out.println("\te.g. Human, Mouse, Rat etc.");
        System.out.println("\tDb is database or assembly name e.g hg17, mm5, rn3 etc.");
        System.out.println("\tsearchType can be BLATGuess, DNA, RNA, transDNA or transRNA");
        System.out.println("\tsortOrder can be query,score; query,start; chrom,score");
        System.out.println("\tchrom,start; score.");
        System.out.println("\toutputType can be pslNoHeader, psl or hyperlink.");
        System.out.println("\tblats will be run in groups of $batchCount sequences, all");
    }

    public static List<String> blat(String org, String db, String userSeq) throws IOException {
        String searchType = "DNA";
        String sortOrder = "query,score";
        String outputType = "psl";
        List<String> blatRecords = BlatClient.blat(org, db, searchType, sortOrder, outputType, userSeq);
        return blatRecords;
    }

    public static List<String> blat(String org, String db, String searchType, String sortOrder, String outputType, String userSeq) throws IOException {
        String result;
        if (searchType.equals("BLATGuess")) {
            searchType = "Blat's Guess";
        } else if (searchType.equals("transDNA")) {
            searchType = "translated DNA";
        } else if (searchType.equals("transRNA")) {
            searchType = "translated RNA";
        } else if (!searchType.equals("DNA") && !searchType.equals("RNA")) {
            System.out.println("ERROR: have not specified an acceptable search type - it should be BLATGuess, transDNA, transRNA, DNA or RNA.");
            BlatClient.Usage();
            System.exit(255);
        }
        if (outputType.equals("pslNoHeader")) {
            outputType = "psl no header";
        } else if (!outputType.equals("psl") && !outputType.equals("hyperlink")) {
            System.out.println("ERROR: have not specified an acceptable output type - it should be pslNoHeader, psl or hyperlink.");
            BlatClient.Usage();
            System.exit(255);
        }
        String $url = PreferencesManager.getPreferences().get("BLAT_URL").trim();
        String serverType = PreferencesManager.getPreferences().get("BLAT_SERVER_TYPE");
        if (serverType.equalsIgnoreCase("web_blat")) {
            String urlString = $url + "?&wb_qtype=" + searchType + "&wb_sort=" + sortOrder + "&wb_output=" + outputType + "&wb_seq=" + userSeq;
            log.info((Object)("BLAT: " + urlString));
            result = HttpUtils.getInstance().getContentsAsString(new URL(urlString));
        } else {
            String urlString = $url + "?org=" + org + "&db=" + db + "&type=" + searchType + "&sort=" + sortOrder + "&output=" + outputType;
            if (hgsid != null) {
                urlString = urlString + "&hgsid=" + hgsid;
            }
            URL url = HttpUtils.createURL(urlString);
            long dt = System.currentTimeMillis() - lastQueryTime;
            if (dt < (long)sleepTime) {
                try {
                    Thread.sleep(dt);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            lastQueryTime = System.currentTimeMillis();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("userSeq", userSeq);
            result = HttpUtils.getInstance().doPost(url, params);
        }
        return BlatClient.parseResult(result);
    }

    static List<String> parseResult(String result) throws IOException {
        String l;
        ArrayList<String> records = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new StringReader(result));
        boolean pslSectionFound = false;
        boolean pslHeaderFound = false;
        while ((l = br.readLine()) != null) {
            String line = l.trim().toLowerCase();
            if (pslHeaderFound) {
                if (line.contains("</tt>")) break;
                String[] tokens = Globals.whitespacePattern.split(line);
                if (tokens.length == 21) {
                    records.add(line);
                }
            }
            if (line.contains("<tt>") && line.contains("<pre>") && line.contains("pslayout")) {
                pslSectionFound = true;
                continue;
            }
            if (!pslSectionFound || !line.startsWith("-----------------------------")) continue;
            pslHeaderFound = true;
        }
        return records;
    }

    public static void doBlatQuery(String chr, int start, int end, Strand strand) {
        BlatClient.doBlatQuery(chr, start, end, strand, "Blat");
    }

    public static void doBlatQuery(String chr, int start, int end, Strand strand, String trackLabel) {
        if (end - start > 8000) {
            MessageUtils.showMessage("BLAT searches are limited to 8kb.  Please try a shorter sequence.");
            return;
        }
        Genome genome = GenomeManager.getInstance().getCurrentGenome();
        byte[] seqBytes = genome.getSequence(chr, start, end);
        String userSeq = new String(seqBytes);
        if (strand == Strand.NEGATIVE) {
            userSeq = SequenceTrack.getReverseComplement(userSeq);
        }
        BlatClient.doBlatQuery(userSeq);
    }

    public static void doBlatQuery(String userSeq) {
        BlatClient.doBlatQuery(userSeq, "Blat");
    }

    public static void doBlatQuery(final String userSeq, final String trackLabel) {
        LongRunningTask.submit(new NamedRunnable(){

            @Override
            public String getName() {
                return "Blat sequence";
            }

            @Override
            public void run() {
                try {
                    Genome genome = IGV.hasInstance() ? GenomeManager.getInstance().getCurrentGenome() : null;
                    String db = genome.getId();
                    String species = genome.getSpecies();
                    if (species == null) {
                        MessageUtils.showMessage("Cannot determine species name for genome: " + genome.getDisplayName());
                        return;
                    }
                    List<String> tokensList = BlatClient.blat(species, db, userSeq);
                    if (tokensList.isEmpty()) {
                        MessageUtils.showMessage("No features found");
                    } else {
                        BlatTrack newTrack = new BlatTrack(userSeq, tokensList, trackLabel);
                        IGV.getInstance().getTrackPanel("FeaturePanel").addTrack(newTrack);
                        IGV.getInstance().repaint();
                        BlatQueryWindow win = new BlatQueryWindow(IGV.getMainFrame(), userSeq, newTrack.getFeatures());
                        win.setVisible(true);
                    }
                }
                catch (Exception e1) {
                    MessageUtils.showErrorMessage("Error running blat", e1);
                }
            }
        });
    }

    public static JMenuItem getMenuItem() {
        JMenuItem menuItem = new JMenuItem("BLAT ...");
        menuItem.addActionListener(e -> {
            String blatSequence = MessageUtils.showInputDialog("Enter sequence to blat:");
            if (blatSequence != null) {
                BlatClient.doBlatQuery(blatSequence);
            }
        });
        return menuItem;
    }

    static {
        lastQueryTime = 0L;
    }
}

