/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom;

import gnu.xml.dom.DomDOMException;
import gnu.xml.dom.DomDocument;
import gnu.xml.dom.DomNode;

public abstract class DomNsNode
extends DomNode {
    private String name;
    private String namespace;
    private String prefix;
    String localName;

    public final String getNodeName() {
        return this.name;
    }

    final void setNodeName(String string) {
        this.name = string.intern();
        int n = string.indexOf(58);
        if (n == -1) {
            this.prefix = null;
            this.localName = this.name;
        } else {
            this.prefix = string.substring(0, n).intern();
            this.localName = string.substring(n + 1).intern();
        }
    }

    public final String getNamespaceURI() {
        return this.namespace;
    }

    final void setNamespaceURI(String string) {
        if ("".equals(string)) {
            string = null;
        }
        this.namespace = string == null ? null : string.intern();
    }

    public final String getPrefix() {
        return this.prefix;
    }

    public final void setPrefix(String string) {
        if (this.readonly) {
            throw new DomDOMException(7);
        }
        if (string == null) {
            this.name = this.localName;
            return;
        }
        if (this.namespace == null) {
            throw new DomDOMException(14, "can't set prefix, node has no namespace URI", this, 0);
        }
        DomDocument.checkName(string, "1.1".equals(this.owner.getXmlVersion()));
        if (string.indexOf(58) != -1) {
            throw new DomDOMException(14, "illegal prefix " + string, this, 0);
        }
        if ("xml".equals(string) && !"http://www.w3.org/XML/1998/namespace".equals(this.namespace)) {
            throw new DomDOMException(14, "xml namespace is always http://www.w3.org/XML/1998/namespace", this, 0);
        }
        if ("xmlns".equals(string)) {
            if (this.namespace != null || this.getNodeType() != 2) {
                throw new DomDOMException(14, "xmlns attribute prefix is reserved", this, 0);
            }
        } else if (this.getNodeType() == 2 && ("xmlns".equals(this.name) || this.name.startsWith("xmlns:"))) {
            throw new DomDOMException(14, "namespace declarations can't change names", this, 0);
        }
        this.prefix = string.intern();
    }

    public final String getLocalName() {
        return this.localName;
    }

    DomNsNode(short s, DomDocument domDocument, String string, String string2) {
        super(s, domDocument);
        this.setNodeName(string2);
        this.setNamespaceURI(string);
    }
}

