/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio;

import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.List;
import javax.imageio.metadata.IIOMetadata;

public class IIOImage {
    protected RenderedImage image;
    protected IIOMetadata metadata;
    protected Raster raster;
    protected List thumbnails;

    public IIOMetadata getMetadata() {
        return this.metadata;
    }

    public int getNumThumbnails() {
        int n = 0;
        if (this.thumbnails != null) {
            n = this.thumbnails.size();
        }
        return n;
    }

    public Raster getRaster() {
        return this.raster;
    }

    public RenderedImage getRenderedImage() {
        return this.image;
    }

    public BufferedImage getThumbnail(int n) {
        return (BufferedImage)this.thumbnails.get(n);
    }

    public List getThumbnails() {
        return this.thumbnails;
    }

    public boolean hasRaster() {
        boolean bl = false;
        if (this.raster != null) {
            bl = true;
        }
        return bl;
    }

    public void setMetadata(IIOMetadata iIOMetadata) {
        this.metadata = iIOMetadata;
    }

    public void setRaster(Raster raster) {
        if (raster == null) {
            throw new IllegalArgumentException("raster may not be null");
        }
        this.image = null;
        this.raster = raster;
    }

    public void setRenderedImage(RenderedImage renderedImage) {
        if (renderedImage == null) {
            throw new IllegalArgumentException("image may not be null");
        }
        this.image = renderedImage;
        this.raster = null;
    }

    public void setThumbnails(List list2) {
        this.thumbnails = list2;
    }

    public IIOImage(Raster raster, List list2, IIOMetadata iIOMetadata) {
        if (raster == null) {
            throw new IllegalArgumentException("raster may not be null");
        }
        this.raster = raster;
        this.thumbnails = list2;
        this.metadata = iIOMetadata;
    }

    public IIOImage(RenderedImage renderedImage, List list2, IIOMetadata iIOMetadata) {
        if (renderedImage == null) {
            throw new IllegalArgumentException("image may not be null");
        }
        this.image = renderedImage;
        this.thumbnails = list2;
        this.metadata = iIOMetadata;
    }
}

