/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.callback;

import java.io.Serializable;
import javax.security.auth.callback.Callback;

public class ChoiceCallback
implements Callback,
Serializable {
    private String prompt;
    private String[] choices;
    private int defaultChoice;
    private boolean multipleSelectionsAllowed;
    private int[] selections;

    public String getPrompt() {
        return this.prompt;
    }

    public String[] getChoices() {
        return this.choices;
    }

    public int getDefaultChoice() {
        return this.defaultChoice;
    }

    public boolean allowMultipleSelections() {
        return this.multipleSelectionsAllowed;
    }

    public void setSelectedIndex(int n) {
        this.selections = new int[1];
        this.selections[0] = n;
    }

    public void setSelectedIndexes(int[] nArray) {
        if (!this.multipleSelectionsAllowed) {
            throw new UnsupportedOperationException("not allowed");
        }
        this.selections = nArray;
    }

    public int[] getSelectedIndexes() {
        return this.selections;
    }

    private final void setPrompt(String string) throws IllegalArgumentException {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("invalid prompt");
        }
        this.prompt = string;
    }

    private final void setChoices(String[] stringArray) throws IllegalArgumentException {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("invalid choices");
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] == null || stringArray[n].length() == 0) {
                throw new IllegalArgumentException("invalid choice at index #" + n);
            }
            ++n;
        }
        this.choices = stringArray;
    }

    public ChoiceCallback(String string, String[] stringArray, int n, boolean bl) {
        this.setPrompt(string);
        this.setChoices(stringArray);
        if (n < 0 || n >= this.choices.length) {
            throw new IllegalArgumentException("default choice is out of bounds");
        }
        this.defaultChoice = n;
        this.multipleSelectionsAllowed = bl;
    }
}

