/*
 * Decompiled with CFR 0.152.
 */
package org.kaffe.security.provider;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandomSpi;
import org.kaffe.security.Randomness;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SHA1PRNG
extends SecureRandomSpi {
    private static final String[] RANDOMNESS_IMPLS = new String[]{"org.kaffe.security.UnixRandomness", "org.kaffe.security.LameRandomness"};
    private static final Randomness impl;
    private static final int SEED_SIZE = 8;
    private static final int DATA_SIZE = 16;
    private MessageDigest md;
    private byte[] seed;
    private int seedPos;
    private byte[] data;
    private int dataPos;
    private long counter;

    protected synchronized void engineSetSeed(byte[] byArray) {
        try {
            int n = 0;
            while (n < byArray.length) {
                int n2 = this.seedPos++ % 8;
                this.seed[n2] = (byte)(this.seed[n2] ^ byArray[n]);
                ++n;
            }
            this.seedPos %= 8;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected synchronized void engineNextBytes(byte[] byArray) {
        if (byArray.length < 8 - this.dataPos) {
            System.arraycopy(this.data, this.dataPos, byArray, 0, byArray.length);
            this.dataPos += byArray.length;
        } else {
            int n = byArray.length;
            int n2 = 0;
            while (n2 < n) {
                int n3 = 8 - this.dataPos;
                int n4 = n - n2;
                if (n3 < n4) {
                    n4 = n3;
                }
                System.arraycopy(this.data, this.dataPos, byArray, n2, n4);
                n2 += n4;
                this.dataPos += n4;
                if (this.dataPos < 8) continue;
                System.arraycopy(this.seed, 0, this.data, 0, 8);
                ++this.counter;
                this.data[8] = (byte)this.counter;
                this.data[9] = (byte)(this.counter >> 8);
                this.data[10] = (byte)(this.counter >> 16);
                this.data[11] = (byte)(this.counter >> 24);
                this.data[12] = (byte)(this.counter >> 32);
                this.data[13] = (byte)(this.counter >> 40);
                this.data[14] = (byte)(this.counter >> 48);
                this.data[15] = (byte)(this.counter >> 56);
                byte[] byArray2 = this.md.digest(this.data);
                System.arraycopy(byArray2, 0, this.data, 0, 8);
                this.dataPos = 0;
            }
        }
    }

    protected byte[] engineGenerateSeed(int n) {
        byte[] byArray = new byte[n];
        this.engineNextBytes(byArray);
        return byArray;
    }

    private final /* synthetic */ void this() {
        this.seed = new byte[8];
        this.seedPos = 0;
        this.data = new byte[16];
        this.dataPos = 0;
        this.counter = 0L;
    }

    public SHA1PRNG() {
        this.this();
        impl.fill(this.seed);
        try {
            this.md = MessageDigest.getInstance("SHA-1");
            byte[] byArray = this.md.digest(this.seed);
            System.arraycopy(byArray, 0, this.data, 0, 8);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    static {
        Randomness randomness = null;
        int n = 0;
        while (n < RANDOMNESS_IMPLS.length && randomness == null) {
            try {
                ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                Class clazz = classLoader.loadClass(RANDOMNESS_IMPLS[n]);
                randomness = (Randomness)clazz.newInstance();
                System.setProperty("org.kaffe.randomness", clazz.getName());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new InternalError(illegalAccessException.toString());
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NullPointerException nullPointerException) {
                throw nullPointerException;
            }
            catch (Exception exception) {}
            ++n;
        }
        if (randomness == null) {
            throw new UnsatisfiedLinkError("Cannot find working Randomness");
        }
        impl = randomness;
    }
}

