/*
 * Decompiled with CFR 0.152.
 */
package org.kaffe.util;

import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.kaffe.util.DateScanner;

public class DateParser {
    public static int getDayIdx(String string, DateFormatSymbols dateFormatSymbols) {
        String[] stringArray = dateFormatSymbols.getWeekdays();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                return n;
            }
            ++n;
        }
        stringArray = dateFormatSymbols.getShortWeekdays();
        n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static int getMonthIdx(String string, DateFormatSymbols dateFormatSymbols) {
        String[] stringArray = dateFormatSymbols.getMonths();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                return n;
            }
            ++n;
        }
        stringArray = dateFormatSymbols.getShortMonths();
        n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static void main(String[] stringArray) {
        try {
            Date date = DateParser.parse(stringArray[0]);
            System.out.println(date);
        }
        catch (ParseException parseException) {
            System.out.println(parseException + " near: " + parseException.getErrorOffset());
        }
    }

    public static Date parse(String string) throws ParseException {
        return DateParser.parse(string, new DateFormatSymbols());
    }

    public static Date parse(String string, DateFormatSymbols dateFormatSymbols) throws ParseException {
        int n;
        Calendar calendar = Calendar.getInstance();
        DateScanner dateScanner = new DateScanner(string, dateFormatSymbols);
        block14: while ((n = dateScanner.nextToken()) != -1) {
            switch (n) {
                case -2: {
                    throw new ParseException(string, dateScanner.si1);
                }
                case 0: 
                case 9: {
                    int n2 = Integer.parseInt(dateScanner.stringToken());
                    calendar.set(5, n2);
                    break;
                }
                case 1: {
                    int n3 = Integer.parseInt(dateScanner.stringToken()) - 1;
                    calendar.set(2, n3);
                    break;
                }
                case 2: {
                    int n4 = Integer.parseInt(dateScanner.stringToken());
                    if (n4 < 100) {
                        n4 += 1900;
                    }
                    calendar.set(1, n4);
                    break;
                }
                case 3: {
                    int n5 = Integer.parseInt(dateScanner.stringToken());
                    calendar.set(11, n5);
                    break;
                }
                case 4: {
                    int n6 = Integer.parseInt(dateScanner.stringToken());
                    calendar.set(12, n6);
                    break;
                }
                case 5: {
                    int n7 = Integer.parseInt(dateScanner.stringToken());
                    calendar.set(13, n7);
                    break;
                }
                case 6: {
                    int n8 = DateParser.getDayIdx(dateScanner.stringToken(), dateFormatSymbols);
                    calendar.set(7, n8);
                    break;
                }
                case 7: {
                    String string2 = dateScanner.stringToken();
                    calendar.setTimeZone(TimeZone.getTimeZone(string2));
                    break;
                }
                case 8: {
                    int n9 = Integer.parseInt(dateScanner.stringToken());
                    int n10 = n9 % 100 * 60000 + n9 / 100 * 3600000;
                    if (dateScanner.src[dateScanner.si0 - 1] == '-') {
                        n10 *= -1;
                    }
                    calendar.set(15, n10);
                    break;
                }
                case 10: {
                    int n11 = DateParser.getMonthIdx(dateScanner.stringToken(), dateFormatSymbols);
                    calendar.set(2, n11);
                    break;
                }
                case 11: {
                    String string3 = dateScanner.stringToken();
                    if (!string3.equals("PM")) continue block14;
                    int n12 = calendar.get(11);
                    if (n12 < 12) {
                        n12 += 12;
                    }
                    calendar.set(11, n12);
                    break;
                }
            }
        }
        return calendar.getTime();
    }
}

