/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.midi.device.alsa;

import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;
import org.tritonus.lowlevel.alsa.AlsaSeq;
import org.tritonus.lowlevel.alsa.AlsaSeqEvent;
import org.tritonus.share.TDebug;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AlsaMidiOut {
    private AlsaSeq m_alsaSeq;
    private int m_nSourcePort;
    private int m_nQueue;
    private boolean m_bImmediately;
    private boolean m_bHandleMetaMessages;
    private AlsaSeqEvent m_event;

    private final AlsaSeq getAlsaSeq() {
        return this.m_alsaSeq;
    }

    private final int getSourcePort() {
        return this.m_nSourcePort;
    }

    private final int getQueue() {
        return this.m_nQueue;
    }

    private final boolean getImmediately() {
        return this.m_bImmediately;
    }

    public boolean getHandleMetaMessages() {
        return this.m_bHandleMetaMessages;
    }

    public void setHandleMetaMessages(boolean bl) {
        this.m_bHandleMetaMessages = bl;
    }

    public synchronized void enqueueMessage(MidiMessage midiMessage, long l) {
        if (TDebug.TraceAlsaMidiOut) {
            TDebug.out("AlsaMidiOut.enqueueMessage(): begin");
        }
        if (midiMessage instanceof ShortMessage) {
            this.enqueueShortMessage((ShortMessage)midiMessage, l);
        } else if (midiMessage instanceof SysexMessage) {
            this.enqueueSysexMessage((SysexMessage)midiMessage, l);
        } else if (midiMessage instanceof MetaMessage && this.getHandleMetaMessages()) {
            this.enqueueMetaMessage((MetaMessage)midiMessage, l);
        }
        if (TDebug.TraceAlsaMidiOut) {
            TDebug.out("AlsaMidiOut.enqueueMessage(): end");
        }
    }

    private final void enqueueShortMessage(ShortMessage shortMessage, long l) {
        int n = shortMessage.getChannel();
        block0 : switch (shortMessage.getCommand()) {
            case 128: {
                this.sendNoteOffEvent(l, n, shortMessage.getData1(), shortMessage.getData2());
                break;
            }
            case 144: {
                this.sendNoteOnEvent(l, n, shortMessage.getData1(), shortMessage.getData2());
                break;
            }
            case 160: {
                this.sendKeyPressureEvent(l, n, shortMessage.getData1(), shortMessage.getData2());
                break;
            }
            case 176: {
                this.sendControlChangeEvent(l, n, shortMessage.getData1(), shortMessage.getData2());
                break;
            }
            case 192: {
                this.sendProgramChangeEvent(l, n, shortMessage.getData1());
                break;
            }
            case 208: {
                this.sendChannelPressureEvent(l, n, shortMessage.getData1());
                break;
            }
            case 224: {
                this.sendPitchBendEvent(l, n, AlsaMidiOut.get14bitValue(shortMessage.getData1(), shortMessage.getData2()));
                break;
            }
            case 240: {
                switch (shortMessage.getStatus()) {
                    case 241: {
                        this.sendMTCEvent(l, shortMessage.getData1());
                        break block0;
                    }
                    case 242: {
                        this.sendSongPositionPointerEvent(l, AlsaMidiOut.get14bitValue(shortMessage.getData1(), shortMessage.getData2()));
                        break block0;
                    }
                    case 243: {
                        this.sendSongSelectEvent(l, shortMessage.getData1());
                        break block0;
                    }
                    case 246: {
                        this.sendTuneRequestEvent(l);
                        break block0;
                    }
                    case 248: {
                        this.sendMidiClockEvent(l);
                        break block0;
                    }
                    case 250: {
                        this.sendStartEvent(l);
                        break block0;
                    }
                    case 251: {
                        this.sendContinueEvent(l);
                        break block0;
                    }
                    case 252: {
                        this.sendStopEvent(l);
                        break block0;
                    }
                    case 254: {
                        this.sendActiveSensingEvent(l);
                        break block0;
                    }
                    case 255: {
                        this.sendSystemResetEvent(l);
                        break block0;
                    }
                }
                TDebug.out("AlsaMidiOut.enqueueShortMessage(): UNKNOWN EVENT TYPE: " + shortMessage.getStatus());
                break;
            }
            default: {
                TDebug.out("AlsaMidiOut.enqueueShortMessage(): UNKNOWN EVENT TYPE: " + shortMessage.getStatus());
            }
        }
    }

    private static final int get14bitValue(int n, int n2) {
        return n & 0x7F | (n2 & 0x7F) << 7;
    }

    private final void sendNoteOffEvent(long l, int n, int n2, int n3) {
        this.sendNoteEvent(7, l, n, n2, n3);
    }

    private final void sendNoteOnEvent(long l, int n, int n2, int n3) {
        this.sendNoteEvent(6, l, n, n2, n3);
    }

    private final void sendNoteEvent(int n, long l, int n2, int n3, int n4) {
        this.setCommon(n, 0, l);
        this.m_event.setNote(n2, n3, n4, 0, 0);
        this.sendEvent();
    }

    private final void sendKeyPressureEvent(long l, int n, int n2, int n3) {
        this.sendControlEvent(8, l, n, n2, n3);
    }

    private final void sendControlChangeEvent(long l, int n, int n2, int n3) {
        this.sendControlEvent(10, l, n, n2, n3);
    }

    private final void sendProgramChangeEvent(long l, int n, int n2) {
        this.sendControlEvent(11, l, n, 0, n2);
    }

    private final void sendChannelPressureEvent(long l, int n, int n2) {
        this.sendControlEvent(12, l, n, 0, n2);
    }

    private final void sendPitchBendEvent(long l, int n, int n2) {
        this.sendControlEvent(13, l, n, 0, n2);
    }

    private final void sendControlEvent(int n, long l, int n2, int n3, int n4) {
        this.setCommon(n, 0, l);
        this.m_event.setControl(n2, n3, n4);
        this.sendEvent();
    }

    private final void sendMTCEvent(long l, int n) {
        this.sendControlEvent(22, l, 0, 0, n);
    }

    private final void sendSongPositionPointerEvent(long l, int n) {
        this.sendControlEvent(20, l, 0, 0, n);
    }

    private final void sendSongSelectEvent(long l, int n) {
        this.sendControlEvent(21, l, 0, 0, n);
    }

    private final void sendTuneRequestEvent(long l) {
        this.sendEvent(40, l);
    }

    private final void sendMidiClockEvent(long l) {
        this.sendQueueControlEvent(36, l, 0, 0, 0L);
    }

    private final void sendStartEvent(long l) {
        this.sendQueueControlEvent(30, l, 0, 0, 0L);
    }

    private final void sendContinueEvent(long l) {
        this.sendQueueControlEvent(31, l, 0, 0, 0L);
    }

    private final void sendStopEvent(long l) {
        this.sendQueueControlEvent(32, l, 0, 0, 0L);
    }

    private final void sendActiveSensingEvent(long l) {
        this.sendEvent(42, l);
    }

    private final void sendSystemResetEvent(long l) {
        this.sendEvent(41, l);
    }

    private final void sendQueueControlEvent(int n, long l, int n2, int n3, long l2) {
        this.setCommon(n, 0, l);
        this.m_event.setQueueControl(n2, n3, l2);
        this.sendEvent();
    }

    private final void sendEvent(int n, long l) {
        this.setCommon(n, 0, l);
        this.sendEvent();
    }

    private final void enqueueSysexMessage(SysexMessage sysexMessage, long l) {
        byte[] byArray = sysexMessage.getMessage();
        int n = sysexMessage.getLength();
        if ((byArray[0] & 0xFF) == 240) {
            this.sendVarEvent(130, l, byArray, 0, n);
        } else {
            this.sendVarEvent(130, l, byArray, 1, n - 1);
        }
    }

    private final void enqueueMetaMessage(MetaMessage metaMessage, long l) {
        byte[] byArray = metaMessage.getData();
        byte[] byArray2 = new byte[byArray.length + 1];
        byArray2[0] = (byte)metaMessage.getType();
        System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
        this.sendVarEvent(139, l, byArray2, 0, byArray2.length);
    }

    private final void sendVarEvent(int n, long l, byte[] byArray, int n2, int n3) {
        this.setCommon(n, 4, l);
        this.m_event.setVar(byArray, 0, n3);
        this.sendEvent();
    }

    private final void setCommon(int n, int n2, long l) {
        if (this.getImmediately()) {
            if (TDebug.TraceAlsaMidiOut) {
                TDebug.out("AlsaMidiOut.enqueueShortMessage(): sending noteoff message (immediately)");
            }
            this.m_event.setCommon(n, 3 | n2, 0, 253, 0L, 0, this.getSourcePort(), 254, 253);
        } else {
            if (TDebug.TraceAlsaMidiOut) {
                TDebug.out("AlsaMidiOut.enqueueShortMessage(): sending noteoff message (timed)");
            }
            this.m_event.setCommon(n, n2, 0, this.getQueue(), l, 0, this.getSourcePort(), 254, 253);
        }
    }

    private final void sendEvent() {
        this.getAlsaSeq().eventOutput(this.m_event);
        this.getAlsaSeq().drainOutput();
    }

    private final /* synthetic */ void this() {
        this.m_event = new AlsaSeqEvent();
    }

    public AlsaMidiOut(AlsaSeq alsaSeq, int n, int n2) {
        this(alsaSeq, n, n2, false);
    }

    public AlsaMidiOut(AlsaSeq alsaSeq, int n) {
        this(alsaSeq, n, -1, true);
    }

    private AlsaMidiOut(AlsaSeq alsaSeq, int n, int n2, boolean bl) {
        this.this();
        if (TDebug.TraceAlsaMidiOut) {
            TDebug.out("AlsaMidiOut.<init>(AlsaSeq, int, int, boolean): begin");
        }
        this.m_alsaSeq = alsaSeq;
        this.m_nSourcePort = n;
        this.m_nQueue = n2;
        this.m_bImmediately = bl;
        this.m_bHandleMetaMessages = false;
        if (TDebug.TraceAlsaMidiOut) {
            TDebug.out("AlsaMidiOut.<init>(AlsaSeq, int, int, boolean): end");
        }
    }
}

