/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.Record;
import org.xbill.DNS.Tokenizer;

public class SOARecord
extends Record {
    private Name host;
    private Name admin;
    private long serial;
    private long refresh;
    private long retry;
    private long expire;
    private long minimum;

    Record getObject() {
        return new SOARecord();
    }

    void rrFromWire(DNSInput dNSInput) throws IOException {
        this.host = new Name(dNSInput);
        this.admin = new Name(dNSInput);
        this.serial = dNSInput.readU32();
        this.refresh = dNSInput.readU32();
        this.retry = dNSInput.readU32();
        this.expire = dNSInput.readU32();
        this.minimum = dNSInput.readU32();
    }

    void rdataFromString(Tokenizer tokenizer, Name name) throws IOException {
        this.host = tokenizer.getName(name);
        this.admin = tokenizer.getName(name);
        this.serial = tokenizer.getUInt32();
        this.refresh = tokenizer.getTTLLike();
        this.retry = tokenizer.getTTLLike();
        this.expire = tokenizer.getTTLLike();
        this.minimum = tokenizer.getTTLLike();
    }

    String rrToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.host);
        stringBuffer.append(" ");
        stringBuffer.append(this.admin);
        if (Options.check("multiline")) {
            stringBuffer.append(" (\n\t\t\t\t\t");
            stringBuffer.append(this.serial);
            stringBuffer.append("\t; serial\n\t\t\t\t\t");
            stringBuffer.append(this.refresh);
            stringBuffer.append("\t; refresh\n\t\t\t\t\t");
            stringBuffer.append(this.retry);
            stringBuffer.append("\t; retry\n\t\t\t\t\t");
            stringBuffer.append(this.expire);
            stringBuffer.append("\t; expire\n\t\t\t\t\t");
            stringBuffer.append(this.minimum);
            stringBuffer.append(" )\t; minimum");
        } else {
            stringBuffer.append(" ");
            stringBuffer.append(this.serial);
            stringBuffer.append(" ");
            stringBuffer.append(this.refresh);
            stringBuffer.append(" ");
            stringBuffer.append(this.retry);
            stringBuffer.append(" ");
            stringBuffer.append(this.expire);
            stringBuffer.append(" ");
            stringBuffer.append(this.minimum);
        }
        return stringBuffer.toString();
    }

    public Name getHost() {
        return this.host;
    }

    public Name getAdmin() {
        return this.admin;
    }

    public long getSerial() {
        return this.serial;
    }

    public long getRefresh() {
        return this.refresh;
    }

    public long getRetry() {
        return this.retry;
    }

    public long getExpire() {
        return this.expire;
    }

    public long getMinimum() {
        return this.minimum;
    }

    void rrToWire(DNSOutput dNSOutput, Compression compression, boolean bl) {
        this.host.toWire(dNSOutput, compression, bl);
        this.admin.toWire(dNSOutput, compression, bl);
        dNSOutput.writeU32(this.serial);
        dNSOutput.writeU32(this.refresh);
        dNSOutput.writeU32(this.retry);
        dNSOutput.writeU32(this.expire);
        dNSOutput.writeU32(this.minimum);
    }

    SOARecord() {
    }

    public SOARecord(Name name, int n, long l, Name name2, Name name3, long l2, long l3, long l4, long l5, long l6) {
        super(name, 6, n, l);
        this.host = SOARecord.checkName("host", name2);
        this.admin = SOARecord.checkName("admin", name3);
        this.serial = SOARecord.checkU32("serial", l2);
        this.refresh = SOARecord.checkU32("refresh", l3);
        this.retry = SOARecord.checkU32("retry", l4);
        this.expire = SOARecord.checkU32("expire", l5);
        this.minimum = SOARecord.checkU32("minimum", l6);
    }
}

