---
title: Quality Assurance
layout: page
---

Quality Assurance
=================

Testing and Continuous Integration
----------------------------------

[![GitHub Workflow Status](https://img.shields.io/github/workflow/status/xtaran/unburden-home-dir/CI?style=plastic)](https://github.com/xtaran/unburden-home-dir/actions/workflows/actions.yml)
[![Documentation Status](https://readthedocs.org/projects/unburden-home-dir/badge/?version=latest)](https://readthedocs.org/projects/unburden-home-dir/?badge=latest)
[![Coverage by Coveralls](https://img.shields.io/coveralls/xtaran/unburden-home-dir.svg)](https://coveralls.io/r/xtaran/unburden-home-dir)
[![Coverage by Codecov](https://codecov.io/gh/xtaran/unburden-home-dir/branch/master/graph/badge.svg)](https://codecov.io/gh/xtaran/unburden-home-dir)

* [GitHub Workflow Build Status](https://github.com/xtaran/unburden-home-dir/actions/workflows/actions.yml)
  (after each `git push`)
* [Debian CI Automatic As-Installed Tests](https://ci.debian.net/packages/u/unburden-home-dir/)
  (at least after each upload to Debian; and after uploads of dependencies)
* [Piuparts](https://piuparts.debian.org/sid/source/u/unburden-home-dir.html)
  (package installation, upgrading and removal testing; at least after
  each upload to Debian)
* [Debcheck](https://qa.debian.org/debcheck.php?dist=unstable&package=unburden-home-dir)
  (mostly dependency checking; at least after each upload to Debian)
* [Read the Docs Documentation Builds](https://readthedocs.org/builds/unburden-home-dir/)
  (after each `git push`)
* [Gitbook Documentation Builds](https://www.gitbook.com/book/xtaran/unburden-home-dir/activity)
  (after each `git push`)

Code Statistics and Coverage
----------------------------

<!--
* [Coveralls.io Statement Coverage Status](https://coveralls.io/r/xtaran/unburden-home-dir)
  (after each `git push`)
-->
* [Codecove Coverage Status](https://codecov.io/gh/xtaran/unburden-home-dir)
  (after each `git push`)
* [Code Statistics on OpenHub (formerly Ohloh)](https://www.openhub.net/p/unburden-home-dir)
  (every few days)

General Quality Assurance
-------------------------

* [CII Best Practices Coverage](https://bestpractices.coreinfrastructure.org/projects/1116)
