/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import $ from"jquery";import{DateTime}from"luxon";import Md5 from"@typo3/backend/hashing/md5.js";import Modal from"@typo3/backend/modal.js";import Severity from"@typo3/backend/severity.js";import Utility from"@typo3/backend/utility.js";import RegularEvent from"@typo3/core/event/regular-event.js";import DomHelper from"@typo3/backend/utility/dom-helper.js";import{selector}from"@typo3/core/literals.js";import SubmitInterceptor from"@typo3/backend/form/submit-interceptor.js";import{FormEngineReview}from"@typo3/backend/form-engine-review.js";let formEngineInstance,validationSuspended=!1;const customEvaluations=new Map;class FormEngineValidation{static{this.rulesSelector="[data-formengine-validation-rules]"}static{this.inputSelector="[data-formengine-input-params]"}static{this.markerSelector=".t3js-formengine-validation-marker"}static{this.labelSelector=".t3js-formengine-label"}static{this.errorClass="has-error"}static{this.validationErrorClass="has-validation-error"}static{this.passwordDummy="********"}static initialize(t){formEngineInstance=t,formEngineInstance.formElement.querySelectorAll("."+FormEngineValidation.errorClass).forEach(e=>e.classList.remove(FormEngineValidation.errorClass)),FormEngineValidation.initializeInputFields(),new FormEngineReview(formEngineInstance.formElement),new RegularEvent("change",(e,n)=>{FormEngineValidation.validateField(n),FormEngineValidation.markFieldAsChanged(n)}).delegateTo(formEngineInstance.formElement,FormEngineValidation.rulesSelector),FormEngineValidation.registerSubmitCallback(),FormEngineValidation.validate()}static initializeInputFields(){formEngineInstance.formElement.querySelectorAll(FormEngineValidation.inputSelector).forEach(t=>{if("formengineInputInitialized"in t.dataset)return;const n=JSON.parse(t.dataset.formengineInputParams).field,a=formEngineInstance.formElement.querySelector(selector`[name="${n}"]`);a.dataset.config=t.dataset.formengineInputParams,FormEngineValidation.initializeInputField(n)})}static initializeInputField(t){const e=formEngineInstance.formElement.querySelector(selector`[name="${t}"]`),n=formEngineInstance.formElement.querySelector(selector`[data-formengine-input-name="${t}"]`);if(e.dataset.config!==void 0){const a=JSON.parse(e.dataset.config),i=FormEngineValidation.formatByEvals(a,e.value);i.length&&(n.value=i)}new RegularEvent("change",()=>{FormEngineValidation.updateInputField(n.dataset.formengineInputName)}).bindTo(n),n.dataset.formengineInputInitialized="true"}static registerCustomEvaluation(t,e){customEvaluations.has(t)||customEvaluations.set(t,e)}static formatByEvals(t,e){if(t.evalList!==void 0){const n=Utility.trimExplode(",",t.evalList);for(const a of n)e=FormEngineValidation.formatValue(a,e)}return e}static formatValue(t,e){switch(t){case"date":case"datetime":case"time":case"timesec":if(e==="")return"";const n=DateTime.fromISO(String(e),{zone:"utc"});if(!n.isValid)throw new Error("Invalid ISO8601 DateTime string: "+e);return n.toISO({suppressMilliseconds:!0});case"password":return e?FormEngineValidation.passwordDummy:"";default:return e.toString()}}static updateInputField(t){const e=formEngineInstance.formElement.querySelector(selector`[name="${t}"]`),n=formEngineInstance.formElement.querySelector(selector`[data-formengine-input-name="${t}"]`);if(e.dataset.config!==void 0){const a=JSON.parse(e.dataset.config),i=FormEngineValidation.processByEvals(a,n.value),l=FormEngineValidation.formatByEvals(a,i);e.value!==i&&(e.disabled&&e.dataset.enableOnModification&&(e.disabled=!1),e.value=i,e.dispatchEvent(new Event("change"))),n.value!==l&&(n.value=l)}}static validateField(t,e){if(t instanceof $&&(console.warn("Passing a jQuery element to FormEngineValidation.validateField() is deprecated and will be removed in TYPO3 v14."),console.trace(),t=t.get(0)),!(t instanceof HTMLElement)||(e=e||t.value||"",typeof t.dataset.formengineValidationRules>"u"))return e;const n=JSON.parse(t.dataset.formengineValidationRules);let a=!1,i=0;const l=e;let s,o,m;Array.isArray(e)||(e=e.trimStart());for(const r of n){if(a)break;switch(r.type){case"required":e===""&&(a=!0,t.classList.add(FormEngineValidation.errorClass),t.closest(FormEngineValidation.markerSelector)?.querySelector(FormEngineValidation.labelSelector)?.classList.add(FormEngineValidation.errorClass));break;case"range":if(e!==""){if((r.minItems||r.maxItems)&&(s=formEngineInstance.formElement.querySelector(selector`[name="${t.dataset.relatedfieldname}"]`),s!==null?i=Utility.trimExplode(",",s.value).length:i=parseInt(t.value,10),r.minItems!==void 0&&(o=r.minItems*1,!isNaN(o)&&i<o&&(a=!0)),r.maxItems!==void 0&&(m=r.maxItems*1,!isNaN(m)&&i>m&&(a=!0))),r.lower!==void 0)if(t.dataset.inputType==="datetimepicker"){const c=DateTime.fromISO(e,{zone:"utc"}),f=DateTime.fromISO(r.lower,{zone:"utc"});(!c.isValid||c<f.minus(f.second*1e3))&&(a=!0)}else{const c=r.lower*1;!isNaN(c)&&parseInt(e,10)<c&&(a=!0)}if(r.upper!==void 0)if(t.dataset.inputType==="datetimepicker"){const c=DateTime.fromISO(e,{zone:"utc"}),f=DateTime.fromISO(r.upper,{zone:"utc"});(!c.isValid||c>f.plus((59-f.second)*1e3))&&(a=!0)}else{const c=r.upper*1;!isNaN(c)&&parseInt(e,10)>c&&(a=!0)}}break;case"select":case"category":(r.minItems||r.maxItems)&&(s=formEngineInstance.formElement.querySelector(selector`[name="${t.dataset.relatedfieldname}"]`),s!==null?i=Utility.trimExplode(",",s.value).length:t instanceof HTMLSelectElement?i=t.querySelectorAll("option:checked").length:i=t.querySelectorAll("input[value]:checked").length,r.minItems!==void 0&&(o=r.minItems*1,!isNaN(o)&&i<o&&(a=!0)),r.maxItems!==void 0&&(m=r.maxItems*1,!isNaN(m)&&i>m&&(a=!0)));break;case"group":case"folder":(r.minItems||r.maxItems)&&(i=Utility.trimExplode(",",t.value).length,r.minItems!==void 0&&(o=r.minItems*1,!isNaN(o)&&i<o&&(a=!0)),r.maxItems!==void 0&&(m=r.maxItems*1,!isNaN(m)&&i>m&&(a=!0)));break;case"inline":(r.minItems||r.maxItems)&&(i=Utility.trimExplode(",",t.value).length,r.minItems!==void 0&&(o=r.minItems*1,!isNaN(o)&&i<o&&(a=!0)),r.maxItems!==void 0&&(m=r.maxItems*1,!isNaN(m)&&i>m&&(a=!0)));break;case"min":(t instanceof HTMLInputElement||t instanceof HTMLTextAreaElement)&&t.value.length>0&&t.value.length<t.minLength&&(a=!0);break;case"null":break;default:break}}const d=!a;return t.classList.toggle(FormEngineValidation.errorClass,!d),t.closest(FormEngineValidation.markerSelector)?.querySelector(FormEngineValidation.labelSelector)?.classList.toggle(FormEngineValidation.errorClass,!d),FormEngineValidation.markParentTab(t,d),formEngineInstance.formElement.dispatchEvent(new CustomEvent("t3-formengine-postfieldvalidation",{detail:{field:t,isValid:d},cancelable:!1,bubbles:!0})),l}static processByEvals(t,e){if(t.evalList!==void 0){const n=Utility.trimExplode(",",t.evalList);for(const a of n)e=FormEngineValidation.processValue(a,e,t)}return e}static processValue(t,e,n){let a="",i="",l=0,s=e;switch(t){case"alpha":case"num":case"alphanum":case"alphanum_x":for(a="",l=0;l<e.length;l++){const o=e.substr(l,1);let m=o==="_"||o==="-",d=o>="a"&&o<="z"||o>="A"&&o<="Z",r=o>="0"&&o<="9";switch(t){case"alphanum":m=!1;break;case"alpha":r=!1,m=!1;break;case"num":d=!1,m=!1;break;default:break}(d||r||m)&&(a+=o)}a!==e&&(s=a);break;case"is_in":if(n.is_in){i=""+e,n.is_in=n.is_in.replace(/[-[\]{}()*+?.,\\^$|#\s]/g,"\\$&");const o=new RegExp("[^"+n.is_in+"]+","g");a=i.replace(o,"")}else a=i;s=a;break;case"nospace":s=(""+e).replace(/ /g,"");break;case"md5":e!==""&&(s=Md5.hash(e));break;case"upper":s=e.toUpperCase();break;case"lower":s=e.toLowerCase();break;case"integer":e!==""&&(s=FormEngineValidation.parseInt(e).toString());break;case"decimal":e!==""&&(s=FormEngineValidation.parseDouble(e));break;case"trim":s=String(e).trim();break;case"time":case"timesec":e!==""&&(s=DateTime.fromISO(e,{zone:"utc"}).set({year:1970,month:1,day:1}).toISO({suppressMilliseconds:!0}));break;case"year":if(e!==""){let o=parseInt(e,10);isNaN(o)&&(o=new Date().getUTCFullYear()),s=o.toString(10)}break;case"null":break;case"password":break;default:customEvaluations.has(t)?s=customEvaluations.get(t).call(null,e):typeof TBE_EDITOR=="object"&&TBE_EDITOR.customEvalFunctions!==void 0&&typeof TBE_EDITOR.customEvalFunctions[t]=="function"&&(s=TBE_EDITOR.customEvalFunctions[t](e))}return s}static validate(t){(typeof t>"u"||t instanceof Document)&&formEngineInstance.formElement.querySelectorAll(FormEngineValidation.markerSelector+", .t3js-tabmenu-item").forEach(n=>{n.classList.remove(FormEngineValidation.validationErrorClass)});const e=t||document;for(const n of e.querySelectorAll(FormEngineValidation.rulesSelector))if(n.closest(".t3js-flex-section-deleted, .t3js-inline-record-deleted, .t3js-file-reference-deleted")===null){let a=!1;const i=n.value,l=FormEngineValidation.validateField(n,i);if(Array.isArray(l)&&Array.isArray(i)){if(l.length!==i.length)a=!0;else for(let s=0;s<l.length;s++)if(l[s]!==i[s]){a=!0;break}}else l.length&&i!==l&&(a=!0);a&&(n.disabled&&n.dataset.enableOnModification&&(n.disabled=!1),n.value=l)}}static markFieldAsChanged(t){if(t instanceof $&&(console.warn("Passing a jQuery element to FormEngineValidation.markFieldAsChanged() is deprecated and will be removed in TYPO3 v14."),console.trace(),t=t.get(0)),!(t instanceof HTMLElement))return;t.classList.add("has-change");const e=t.closest(".t3js-formengine-palette-field")?.querySelector(".t3js-formengine-label");e!==null&&e.classList.add("has-change")}static parseInt(t){const e=""+t;if(!t)return 0;const n=parseInt(e,10);return isNaN(n)?0:n}static parseDouble(t,e=2){let n=""+t;n=n.replace(/[^0-9,.-]/g,"");const a=n.startsWith("-");n=n.replace(/-/g,""),n=n.replace(/,/g,"."),n.indexOf(".")===-1&&(n+=".0");const i=n.split("."),l=i.pop();let s=+(i.join("")+"."+l);return a&&(s*=-1),n=s.toFixed(e),n}static pol(foreign,value){return eval((foreign=="-"?"-":"")+value)}static markParentTab(t,e){DomHelper.parents(t,".tab-pane").forEach(a=>{e&&(e=a.querySelector(".has-error")===null);const i=a.id;formEngineInstance.formElement.querySelector('[data-bs-target="#'+i+'"]').closest(".t3js-tabmenu-item").classList.toggle(FormEngineValidation.validationErrorClass,!e)})}static suspend(){validationSuspended=!0}static resume(){validationSuspended=!1}static isValid(){return document.querySelector("."+FormEngineValidation.errorClass)===null}static showErrorModal(){const t=Modal.confirm(TYPO3.lang.alert||"Alert",TYPO3.lang["FormEngine.fieldsMissing"],Severity.error,[{text:TYPO3.lang["button.ok"]||"OK",active:!0,btnClass:"btn-default",name:"ok"}]);t.addEventListener("button.clicked",()=>t.hideModal())}static registerSubmitCallback(){new SubmitInterceptor(formEngineInstance.formElement).addPreSubmitCallback(()=>validationSuspended||FormEngineValidation.isValid()?!0:(FormEngineValidation.showErrorModal(),!1))}}export{FormEngineValidation as default};
