/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui;

import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import org.wiztools.restclient.bean.ReqResBean;
import org.wiztools.restclient.bean.Request;
import org.wiztools.restclient.bean.Response;
import org.wiztools.restclient.persistence.XMLException;
import org.wiztools.restclient.persistence.XmlPersistenceRead;
import org.wiztools.restclient.ui.RESTView;
import org.wiztools.restclient.util.Util;

public class FileOpenUtil {
    private FileOpenUtil() {
    }

    public static void openRequest(RESTView view, File f) {
        Exception e = null;
        try {
            XmlPersistenceRead p = new XmlPersistenceRead();
            Request request = p.getRequestFromFile(f);
            view.setUIFromRequest(request);
        }
        catch (IOException | XMLException ex) {
            e = ex;
        }
        if (e != null) {
            view.showError(Util.getStackTrace(e));
        }
    }

    public static void openResponse(RESTView view, File f) {
        Exception e = null;
        try {
            XmlPersistenceRead p = new XmlPersistenceRead();
            Response response = p.getResponseFromFile(f);
            view.setUIFromResponse(response);
        }
        catch (IOException | XMLException ex) {
            e = ex;
        }
        if (e != null) {
            view.showError(Util.getStackTrace(e));
        }
    }

    public static void openArchive(RESTView view, File f) {
        Exception e = null;
        try {
            ReqResBean encp = Util.getReqResArchive(f);
            Request request = encp.getRequestBean();
            Response response = encp.getResponseBean();
            if (request != null && response != null) {
                view.setUIFromRequest(request);
                view.setUIFromResponse(response);
            } else {
                view.showError("Unable to load archive! Check if valid archive!");
            }
        }
        catch (IOException | XMLException ex) {
            e = ex;
        }
        if (e != null) {
            view.showError(Util.getStackTrace(e));
        }
    }

    public static void open(RESTView view, File f) {
        String fileName = f.getName().toLowerCase();
        if (fileName.endsWith(".rcq")) {
            FileOpenUtil.openRequest(view, f);
        } else if (fileName.endsWith(".rcs")) {
            FileOpenUtil.openResponse(view, f);
        } else if (fileName.endsWith(".rcr")) {
            FileOpenUtil.openArchive(view, f);
        } else {
            JOptionPane.showMessageDialog(view.getContainer(), "File in unrecognized format!", "File in unrecognized format!", 0);
        }
    }
}

