/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui.resheader;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.HttpCookie;
import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.wiztools.commons.CollectionsUtil;
import org.wiztools.commons.MultiValueMap;
import org.wiztools.commons.MultiValueMapArrayList;
import org.wiztools.restclient.ui.RESTView;
import org.wiztools.restclient.ui.UIUtil;
import org.wiztools.restclient.ui.resheader.ResHeaderPanel;
import org.wiztools.restclient.ui.resheader.ResponseHeaderTableModel;

public class ResHeaderPanelImpl
extends JPanel
implements ResHeaderPanel {
    @Inject
    private RESTView view;
    private JTable jt_res_headers = new JTable();
    private ResponseHeaderTableModel resHeaderTableModel = new ResponseHeaderTableModel();

    @PostConstruct
    protected void init() {
        this.setLayout(new GridLayout());
        JPanel jp_headers = new JPanel();
        jp_headers.setLayout(new GridLayout(1, 1));
        this.jt_res_headers.addMouseListener(new MouseAdapter(){
            private JPopupMenu popup = new JPopupMenu();
            private JMenuItem jmi_copy = new JMenuItem("Copy Selected Header(s)");
            private JMenuItem jmi_copy_all = new JMenuItem("Copy All Headers");
            private JMenuItem jmi_copy_cookies = new JMenuItem("Copy Cookie Name-Value Pairs");
            {
                this.jmi_copy.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int[] rows = ResHeaderPanelImpl.this.jt_res_headers.getSelectedRows();
                        if (rows.length == 0) {
                            ResHeaderPanelImpl.this.view.setStatusMessage("No header(s) selected");
                            return;
                        }
                        Arrays.sort(rows);
                        StringBuilder sb = new StringBuilder();
                        for (int row : rows) {
                            String key = (String)ResHeaderPanelImpl.this.jt_res_headers.getValueAt(row, 0);
                            String value = (String)ResHeaderPanelImpl.this.jt_res_headers.getValueAt(row, 1);
                            sb.append(key).append(": ").append(value).append("\r\n");
                        }
                        UIUtil.clipboardCopy(sb.toString());
                        ResHeaderPanelImpl.this.view.setStatusMessage("Copied selected headers to clipboard");
                    }
                });
                this.popup.add(this.jmi_copy);
                this.jmi_copy_all.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int totalRows = ResHeaderPanelImpl.this.jt_res_headers.getRowCount();
                        StringBuilder sb = new StringBuilder();
                        for (int i = 0; i < totalRows; ++i) {
                            String key = (String)ResHeaderPanelImpl.this.jt_res_headers.getValueAt(i, 0);
                            String value = (String)ResHeaderPanelImpl.this.jt_res_headers.getValueAt(i, 1);
                            sb.append(key).append(": ").append(value).append("\r\n");
                        }
                        UIUtil.clipboardCopy(sb.toString());
                        ResHeaderPanelImpl.this.view.setStatusMessage("Copied ALL headers to clipboard");
                    }
                });
                this.popup.add(this.jmi_copy_all);
                this.jmi_copy_cookies.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int totalRows = ResHeaderPanelImpl.this.jt_res_headers.getRowCount();
                        StringBuilder sb = new StringBuilder();
                        int cookieCount = 0;
                        for (int i = 0; i < totalRows; ++i) {
                            String key = (String)ResHeaderPanelImpl.this.jt_res_headers.getValueAt(i, 0);
                            String value = (String)ResHeaderPanelImpl.this.jt_res_headers.getValueAt(i, 1);
                            String headerLine = key + ": " + value;
                            if (!headerLine.toLowerCase().startsWith("set-cookie")) continue;
                            List<HttpCookie> cookies = HttpCookie.parse(headerLine);
                            for (HttpCookie cookie : cookies) {
                                sb.append(cookie.getName()).append(": ").append(cookie.getValue()).append("\r\n");
                                ++cookieCount;
                            }
                        }
                        if (sb.length() > 0) {
                            UIUtil.clipboardCopy(sb.toString());
                            ResHeaderPanelImpl.this.view.setStatusMessage(cookieCount + " cookie(s) copied to clipboard");
                        } else {
                            ResHeaderPanelImpl.this.view.setStatusMessage("No cookie header(s) found");
                        }
                    }
                });
                this.popup.add(this.jmi_copy_cookies);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.showPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.showPopup(e);
            }

            private void showPopup(MouseEvent e) {
                if (ResHeaderPanelImpl.this.jt_res_headers.getSelectedRowCount() == 0) {
                    this.jmi_copy.setEnabled(false);
                } else {
                    this.jmi_copy.setEnabled(true);
                }
                if (e.isPopupTrigger()) {
                    this.popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.jt_res_headers.setModel(this.resHeaderTableModel);
        JScrollPane jsp = new JScrollPane(this.jt_res_headers);
        Dimension d = jsp.getPreferredSize();
        d.height /= 2;
        jsp.setPreferredSize(d);
        jp_headers.add(jsp);
        this.add(jp_headers);
    }

    @Override
    public MultiValueMap<String, String> getHeaders() {
        String[][] arr = ((ResponseHeaderTableModel)this.jt_res_headers.getModel()).getHeaders();
        if (arr == null) {
            return CollectionsUtil.EMPTY_MULTI_VALUE_MAP;
        }
        MultiValueMapArrayList<String, String> out = new MultiValueMapArrayList<String, String>();
        for (int i = 0; i < arr.length; ++i) {
            out.put(arr[i][0], arr[i][1]);
        }
        return out;
    }

    @Override
    public void setHeaders(MultiValueMap<String, String> headers) {
        this.resHeaderTableModel.setHeaders(headers);
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void clear() {
        ResponseHeaderTableModel model = (ResponseHeaderTableModel)this.jt_res_headers.getModel();
        model.setHeaders(null);
    }
}

