/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.text.JTextComponent;

public class BasicBorders {
    private static MarginBorder sharedMarginBorder;

    public static Border getButtonBorder() {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        ButtonBorder outer = new ButtonBorder(defaults.getColor("Button.shadow"), defaults.getColor("Button.darkShadow"), defaults.getColor("Button.light"), defaults.getColor("Button.highlight"));
        return new BorderUIResource.CompoundBorderUIResource(outer, BasicBorders.getMarginBorder());
    }

    public static Border getRadioButtonBorder() {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        RadioButtonBorder outer = new RadioButtonBorder(defaults.getColor("RadioButton.shadow"), defaults.getColor("RadioButton.darkShadow"), defaults.getColor("RadioButton.light"), defaults.getColor("RadioButton.highlight"));
        return new BorderUIResource.CompoundBorderUIResource(outer, BasicBorders.getMarginBorder());
    }

    public static Border getToggleButtonBorder() {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        ToggleButtonBorder outer = new ToggleButtonBorder(defaults.getColor("ToggleButton.shadow"), defaults.getColor("ToggleButton.darkShadow"), defaults.getColor("ToggleButton.light"), defaults.getColor("ToggleButton.highlight"));
        return new BorderUIResource.CompoundBorderUIResource(outer, BasicBorders.getMarginBorder());
    }

    public static Border getMenuBarBorder() {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        return new MenuBarBorder(defaults.getColor("MenuBar.shadow"), defaults.getColor("MenuBar.highlight"));
    }

    public static Border getSplitPaneBorder() {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        return new SplitPaneBorder(defaults.getColor("SplitPane.highlight"), defaults.getColor("SplitPane.darkShadow"));
    }

    public static Border getSplitPaneDividerBorder() {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        return new SplitPaneDividerBorder(defaults.getColor("SplitPane.highlight"), defaults.getColor("SplitPane.darkShadow"));
    }

    public static Border getTextFieldBorder() {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        return new FieldBorder(defaults.getColor("TextField.shadow"), defaults.getColor("TextField.darkShadow"), defaults.getColor("TextField.light"), defaults.getColor("TextField.highlight"));
    }

    public static Border getProgressBarBorder() {
        return new BorderUIResource.LineBorderUIResource(Color.green, 2);
    }

    public static Border getInternalFrameBorder() {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        Color shadow = defaults.getColor("InternalFrame.borderShadow");
        Color darkShadow = defaults.getColor("InternalFrame.borderDarkShadow");
        Color highlight = defaults.getColor("InternalFrame.borderLight");
        Color lightHighlight = defaults.getColor("InternalFrame.borderHighlight");
        Color line = defaults.getColor("InternalFrame.borderColor");
        return new BorderUIResource.CompoundBorderUIResource(new BorderUIResource.BevelBorderUIResource(0, highlight != null ? highlight : Color.lightGray, lightHighlight != null ? lightHighlight : Color.white, darkShadow != null ? darkShadow : Color.black, shadow != null ? shadow : Color.gray), new BorderUIResource.LineBorderUIResource(line != null ? line : Color.lightGray));
    }

    static Border getMarginBorder() {
        if (sharedMarginBorder == null) {
            sharedMarginBorder = new MarginBorder();
        }
        return sharedMarginBorder;
    }

    public static class ButtonBorder
    extends AbstractBorder
    implements Serializable,
    UIResource {
        static final long serialVersionUID = -157053874580739687L;
        protected Color shadow;
        protected Color darkShadow;
        protected Color highlight;
        protected Color lightHighlight;

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            ButtonModel bmodel = null;
            if (c instanceof AbstractButton) {
                bmodel = ((AbstractButton)c).getModel();
            }
            boolean bl = false;
            if (bmodel != null && bmodel.isPressed() && bmodel.isArmed()) {
                bl = true;
            }
            boolean bl2 = false;
            if (c instanceof JButton && ((JButton)c).isDefaultButton()) {
                bl2 = true;
            }
            BasicGraphicsUtils.drawBezel(g, x, y, width, height, bl, bl2, this.shadow, this.darkShadow, this.highlight, this.lightHighlight);
        }

        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, null);
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            if (insets == null) {
                return new Insets(2, 3, 3, 3);
            }
            insets.top = 2;
            insets.right = 3;
            insets.left = 3;
            insets.bottom = 3;
            return insets;
        }

        public ButtonBorder(Color shadow, Color darkShadow, Color highlight, Color lightHighlight) {
            this.shadow = shadow != null ? shadow : Color.gray;
            this.darkShadow = darkShadow != null ? darkShadow : Color.black;
            this.highlight = highlight != null ? highlight : Color.lightGray;
            this.lightHighlight = lightHighlight != null ? lightHighlight : Color.white;
        }
    }

    public static class RadioButtonBorder
    extends ButtonBorder {
        static final long serialVersionUID = 1596945751743747369L;

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            AbstractButton button = null;
            ButtonModel bmodel = null;
            boolean lowered = false;
            boolean focused = false;
            if (c instanceof AbstractButton) {
                button = (AbstractButton)c;
                bmodel = button.getModel();
            }
            if (bmodel != null) {
                boolean bl = false;
                if (button.isSelected() || bmodel.isArmed() && bmodel.isPressed()) {
                    bl = true;
                }
                lowered = bl;
                boolean bl2 = false;
                if (button.hasFocus() && button.isFocusPainted()) {
                    bl2 = focused = true;
                }
            }
            if (lowered) {
                BasicGraphicsUtils.drawLoweredBezel(g, x, y, width, height, this.shadow, this.darkShadow, this.highlight, this.lightHighlight);
            } else {
                BasicGraphicsUtils.drawBezel(g, x, y, width, height, false, focused, this.shadow, this.darkShadow, this.highlight, this.lightHighlight);
            }
        }

        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, null);
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            if (insets == null) {
                return new Insets(2, 2, 2, 2);
            }
            insets.bottom = 2;
            insets.top = 2;
            insets.right = 2;
            insets.left = 2;
            return insets;
        }

        public RadioButtonBorder(Color shadow, Color darkShadow, Color highlight, Color lightHighlight) {
            super(shadow, darkShadow, highlight, lightHighlight);
        }
    }

    public static class ToggleButtonBorder
    extends ButtonBorder {
        static final long serialVersionUID = -3528666548001058394L;

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            BasicGraphicsUtils.drawBezel(g, x, y, width, height, false, false, this.shadow, this.darkShadow, this.highlight, this.lightHighlight);
        }

        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, null);
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            if (insets == null) {
                return new Insets(2, 2, 2, 2);
            }
            insets.bottom = 2;
            insets.top = 2;
            insets.right = 2;
            insets.left = 2;
            return insets;
        }

        public ToggleButtonBorder(Color shadow, Color darkShadow, Color highlight, Color lightHighlight) {
            super(shadow, darkShadow, highlight, lightHighlight);
        }
    }

    public static class MenuBarBorder
    extends AbstractBorder
    implements UIResource {
        static final long serialVersionUID = -6909056571935227506L;
        private Color shadow;
        private Color highlight;

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Color oldColor = g.getColor();
            y = y + height - 2;
            try {
                g.setColor(this.shadow);
                g.drawLine(x, y, x + width - 2, y);
                g.drawLine(x, y + 1, x, y + 1);
                g.drawLine(x + width - 2, y + 1, x + width - 2, y + 1);
                g.setColor(this.highlight);
                g.drawLine(x + 1, y + 1, x + width - 3, y + 1);
                g.drawLine(x + width - 1, y, x + width - 1, y + 1);
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                g.setColor(oldColor);
                throw throwable;
            }
            {
                Object var9_10 = null;
                g.setColor(oldColor);
                return;
            }
        }

        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, null);
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            if (insets == null) {
                return new Insets(0, 0, 2, 0);
            }
            insets.top = 0;
            insets.right = 0;
            insets.left = 0;
            insets.bottom = 2;
            return insets;
        }

        public MenuBarBorder(Color shadow, Color highlight) {
            this.shadow = shadow != null ? shadow : Color.gray;
            this.highlight = highlight != null ? highlight : Color.white;
        }
    }

    public static class SplitPaneBorder
    implements Border,
    UIResource {
        private static final int SUPPRESS_TOP = 1;
        private static final int SUPPRESS_LEFT = 2;
        private static final int SUPPRESS_BOTTOM = 4;
        private static final int SUPPRESS_RIGHT = 8;
        protected Color highlight;
        protected Color shadow;

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (!(c instanceof JSplitPane)) {
                return;
            }
            JSplitPane splitPane = (JSplitPane)c;
            switch (splitPane.getOrientation()) {
                case 1: {
                    Component content = splitPane.getLeftComponent();
                    if (content != null) {
                        this.paintRect(g, 8, true, x, y, content.getBounds());
                    }
                    if ((content = splitPane.getRightComponent()) == null) break;
                    this.paintRect(g, 2, true, x, y, content.getBounds());
                    break;
                }
                case 0: {
                    Component content = splitPane.getTopComponent();
                    if (content != null) {
                        this.paintRect(g, 4, false, x, y, content.getBounds());
                    }
                    if ((content = splitPane.getBottomComponent()) == null) break;
                    this.paintRect(g, 1, false, x, y, content.getBounds());
                    break;
                }
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private final void paintRect(Graphics g, int suppress, boolean shadeBottomLeftPixel, int x, int y, Rectangle rect) {
            if (rect == null) {
                return;
            }
            int right = (x += rect.x - 1) + rect.width + 1;
            int bottom = (y += rect.y - 1) + rect.height + 1;
            Color oldColor = g.getColor();
            try {
                g.setColor(this.shadow);
                if ((suppress & 1) == 0) {
                    g.drawLine(x, y, right, y);
                }
                if ((suppress & 2) == 0) {
                    g.drawLine(x, y, x, bottom);
                } else {
                    g.drawLine(x, bottom, x, bottom);
                }
                g.setColor(this.highlight);
                if ((suppress & 4) == 0) {
                    g.drawLine(x + shadeBottomLeftPixel, bottom, right, bottom);
                } else if (!shadeBottomLeftPixel) {
                    g.drawLine(x, bottom, x, bottom);
                }
                if ((suppress & 8) == 0) {
                    g.drawLine(right, y, right, bottom);
                }
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                g.setColor(oldColor);
                throw throwable;
            }
            {
                Object var11_12 = null;
                g.setColor(oldColor);
                return;
            }
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(1, 1, 1, 1);
        }

        public boolean isBorderOpaque() {
            return false;
        }

        public SplitPaneBorder(Color highlight, Color shadow) {
            this.shadow = shadow != null ? shadow : Color.black;
            this.highlight = highlight != null ? highlight : Color.white;
        }
    }

    private static class SplitPaneDividerBorder
    implements Border,
    UIResource,
    Serializable {
        protected Color highlight;
        protected Color shadow;

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            JSplitPane sp = this.getSplitPane(c);
            if (sp == null) {
                return;
            }
            int x2 = x + width - 1;
            int y2 = y + height - 1;
            Color oldColor = g.getColor();
            Color dcol = c.getBackground();
            try {
                switch (sp.getOrientation()) {
                    case 1: {
                        g.setColor(dcol);
                        g.drawLine(x + 1, y, x2 - 1, y);
                        g.drawLine(x + 1, y2, x2 - 1, y2);
                        g.setColor(sp.getLeftComponent() != null ? this.highlight : dcol);
                        g.drawLine(x, y, x, y2);
                        g.setColor(sp.getRightComponent() != null ? this.shadow : dcol);
                        g.drawLine(x2, y, x2, y2);
                        break;
                    }
                    case 0: {
                        g.setColor(dcol);
                        g.drawLine(x, y + 1, x, y2 - 1);
                        g.drawLine(x2, y + 1, x2, y2 - 1);
                        g.setColor(sp.getTopComponent() != null ? this.highlight : dcol);
                        g.drawLine(x, y, x2, y);
                        g.setColor(sp.getBottomComponent() != null ? this.shadow : dcol);
                        g.drawLine(x, y2, x2, y2);
                        break;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var13_13 = null;
                g.setColor(oldColor);
                throw throwable;
            }
            {
                Object var13_14 = null;
                g.setColor(oldColor);
                return;
            }
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(1, 1, 1, 1);
        }

        public boolean isBorderOpaque() {
            boolean bl = false;
            if (this.highlight.getAlpha() == 255 && this.shadow.getAlpha() == 255) {
                bl = true;
            }
            return bl;
        }

        private final JSplitPane getSplitPane(Component c) {
            if (c instanceof BasicSplitPaneDivider) {
                return ((BasicSplitPaneDivider)c).getBasicSplitPaneUI().getSplitPane();
            }
            return null;
        }

        public SplitPaneDividerBorder(Color highlight, Color shadow) {
            this.highlight = highlight != null ? highlight : Color.white;
            this.shadow = shadow != null ? shadow : Color.black;
        }
    }

    public static class FieldBorder
    extends AbstractBorder
    implements UIResource {
        static final long serialVersionUID = 949220756998454908L;
        protected Color shadow;
        protected Color darkShadow;
        protected Color highlight;
        protected Color lightHighlight;

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            BasicGraphicsUtils.drawEtchedRect(g, x, y, width, height, this.shadow, this.darkShadow, this.highlight, this.lightHighlight);
        }

        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, null);
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            if (insets == null) {
                insets = new Insets(2, 2, 2, 2);
            } else {
                insets.right = 2;
                insets.bottom = 2;
                insets.left = 2;
                insets.top = 2;
            }
            if (c instanceof JTextComponent) {
                Insets margin = ((JTextComponent)c).getMargin();
                insets.top += margin.top;
                insets.left += margin.left;
                insets.bottom += margin.bottom;
                insets.right += margin.right;
            }
            return insets;
        }

        public FieldBorder(Color shadow, Color darkShadow, Color highlight, Color lightHighlight) {
            this.shadow = shadow != null ? shadow : Color.gray;
            this.darkShadow = darkShadow != null ? darkShadow : Color.black;
            this.highlight = highlight != null ? highlight : Color.lightGray;
            this.lightHighlight = lightHighlight != null ? lightHighlight : Color.white;
        }
    }

    public static class MarginBorder
    extends AbstractBorder
    implements Serializable,
    UIResource {
        static final long serialVersionUID = -3035848353448896090L;

        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            Insets margin = null;
            if (c instanceof AbstractButton) {
                margin = ((AbstractButton)c).getMargin();
            } else if (c instanceof JPopupMenu) {
                margin = ((JPopupMenu)c).getMargin();
            } else if (c instanceof JToolBar) {
                margin = ((JToolBar)c).getMargin();
            } else if (c instanceof JTextComponent) {
                margin = ((JTextComponent)c).getMargin();
            }
            if (margin == null) {
                insets.right = 0;
                insets.bottom = 0;
                insets.left = 0;
                insets.top = 0;
            } else {
                insets.top = margin.top;
                insets.left = margin.left;
                insets.bottom = margin.bottom;
                insets.right = margin.right;
            }
            return insets;
        }
    }

    public static class RolloverButtonBorder
    extends ButtonBorder {
        static final long serialVersionUID = 1976364864896996846L;

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            ButtonModel bmodel = null;
            Color oldColor = g.getColor();
            if (c instanceof AbstractButton) {
                bmodel = ((AbstractButton)c).getModel();
            }
            if (bmodel == null) return;
            if (!bmodel.isRollover()) {
                return;
            }
            if (bmodel.isPressed() && !bmodel.isArmed()) {
                return;
            }
            boolean bl = false;
            if (bmodel.isSelected() || bmodel.isPressed()) {
                bl = true;
            }
            boolean drawPressed = bl;
            int x2 = x + width - 1;
            int y2 = y + height - 1;
            try {
                g.setColor(drawPressed ? this.shadow : this.lightHighlight);
                g.drawLine(x, y, x2 - 1, y);
                g.drawLine(x, y + 1, x, y2 - 1);
                g.setColor(drawPressed ? this.lightHighlight : this.shadow);
                g.drawLine(x, y2, x2, y2);
                g.drawLine(x2, y, x2, y2 - 1);
            }
            catch (Throwable throwable) {
                Object var13_13 = null;
                g.setColor(oldColor);
                throw throwable;
            }
            {
                Object var13_14 = null;
                g.setColor(oldColor);
                return;
            }
        }

        public RolloverButtonBorder(Color shadow, Color darkShadow, Color highlight, Color lightHighlight) {
            super(shadow, darkShadow, highlight, lightHighlight);
        }
    }
}

