/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.xhtml;

import java.text.Collator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Stack;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import writer2latex.office.IndexMark;
import writer2latex.office.ListCounter;
import writer2latex.office.ParStyle;
import writer2latex.office.PropertySet;
import writer2latex.office.StyleWithProperties;
import writer2latex.office.WriterStyleCollection;
import writer2latex.util.Config;
import writer2latex.util.Misc;
import writer2latex.xhtml.AlphabeticalEntry;
import writer2latex.xhtml.ConverterHelper;
import writer2latex.xhtml.DocumentSerializerImpl;
import writer2latex.xhtml.XhtmlStyleMap;

public class TextConverter
extends ConverterHelper {
    int nSplit = 0;
    private int nTocIndex = -1;
    private int nAlphabeticalIndex = -1;
    private int nDontSplitLevel = 0;
    private ListCounter outlineNumbering;
    private int nHeadingCount = 0;
    protected Stack sections = new Stack();
    private boolean bInToc = false;
    Vector index = new Vector();
    int nIndexIndex = -1;
    private String sFntCitBodyStyle = null;
    private String sFntCitStyle = null;
    private String sEntCitBodyStyle = null;
    private String sEntCitStyle = null;
    NodeList headings = null;
    private LinkedList footnotes = new LinkedList();
    private LinkedList endnotes = new LinkedList();
    private Node asapNode = null;

    public TextConverter(WriterStyleCollection wsc, Config config, DocumentSerializerImpl converter) {
        super(wsc, config, converter);
        this.nSplit = config.getXhtmlSplitLevel();
        this.outlineNumbering = new ListCounter(wsc.getOutlineStyle());
        PropertySet notes = wsc.getFootnotesConfiguration();
        if (notes != null) {
            this.sFntCitBodyStyle = notes.getProperty("text:citation-body-style-name");
            this.sFntCitStyle = notes.getProperty("text:citation-style-name");
        }
        if ((notes = wsc.getEndnotesConfiguration()) != null) {
            this.sEntCitBodyStyle = notes.getProperty("text:citation-body-style-name");
            this.sEntCitStyle = notes.getProperty("text:citation-style-name");
        }
    }

    public void convertTextContent(Element onode) {
        this.headings = onode.getElementsByTagName("text:h");
        this.traverseBlockText(onode, this.converter.nextOutFile());
    }

    protected int getTocIndex() {
        return this.nTocIndex;
    }

    protected int getAlphabeticalIndex() {
        return this.nAlphabeticalIndex;
    }

    public Node traverseBlockText(Node onode, Node hnode) {
        return this.traverseBlockText(onode, 0, null, hnode);
    }

    private Node traverseBlockText(Node onode, int nLevel, String styleName, Node hnode) {
        if (!onode.hasChildNodes()) {
            return hnode;
        }
        boolean bAfterHeading = false;
        NodeList nList = onode.getChildNodes();
        int nLen = nList.getLength();
        int i = 0;
        while (i < nLen) {
            Node child = nList.item(i);
            if (child.getNodeType() == 1) {
                String nodeName = child.getNodeName();
                if (!nodeName.equals("text:section")) {
                    ++this.nDontSplitLevel;
                }
                if (nodeName.startsWith("draw:")) {
                    this.getDrawCv().handleDrawElement(child, hnode);
                } else if (nodeName.equals("text:p")) {
                    String sStyleName = Misc.getAttribute(child, "text:style-name");
                    XhtmlStyleMap xpar = this.config.getXParStyleMap();
                    if (sStyleName != null && xpar.contains(sStyleName)) {
                        Node curHnode = hnode;
                        String sBlockElement = xpar.getBlockElement(sStyleName);
                        String sBlockCss = xpar.getBlockCss(sStyleName);
                        if (xpar.getBlockElement(sStyleName).length() > 0) {
                            Element block = this.converter.createElement(xpar.getBlockElement(sStyleName));
                            if (!"(none)".equals(xpar.getBlockCss(sStyleName))) {
                                block.setAttribute("class", xpar.getBlockCss(sStyleName));
                            }
                            hnode.appendChild(block);
                            curHnode = block;
                        }
                        boolean bMoreParagraphs = true;
                        do {
                            String sCurStyleName;
                            this.handleParagraph(child, curHnode);
                            bMoreParagraphs = false;
                            if (++i >= nLen || !(nodeName = (child = nList.item(i)).getNodeName()).equals("text:p") || (sCurStyleName = Misc.getAttribute(child, "text:style-name")) == null || !xpar.contains(sCurStyleName) || !sBlockElement.equals(xpar.getBlockElement(sCurStyleName)) || !sBlockCss.equals(xpar.getBlockCss(sCurStyleName))) continue;
                            bMoreParagraphs = true;
                        } while (bMoreParagraphs);
                        --i;
                    } else {
                        this.handleParagraph(child, hnode);
                    }
                } else if (nodeName.equals("text:h")) {
                    int nOutlineLevel = Misc.getPosInteger(Misc.getAttribute(child, "text:level"), 1);
                    hnode = this.maybeSplit(hnode, nOutlineLevel, bAfterHeading);
                    this.handleHeading(child, hnode);
                } else if (nodeName.equals("text:unordered-list")) {
                    this.handleUL(child, nLevel + 1, null, hnode);
                } else if (nodeName.equals("text:ordered-list")) {
                    this.handleOL(child, nLevel + 1, null, hnode);
                } else if (nodeName.equals("table:table")) {
                    this.getTableCv().handleTable(child, hnode);
                } else if (nodeName.equals("table:sub-table")) {
                    this.getTableCv().handleTable(child, hnode);
                } else if (nodeName.equals("text:section")) {
                    hnode = this.handleSection(child, hnode);
                } else if (nodeName.equals("text:table-of-content")) {
                    hnode = this.maybeSplit(hnode, 1, bAfterHeading);
                    this.handleTOC(child, hnode);
                } else if (nodeName.equals("text:illustration-index")) {
                    this.handleLOF(child, hnode);
                } else if (nodeName.equals("text:table-index")) {
                    this.handleLOT(child, hnode);
                } else if (nodeName.equals("text:object-index")) {
                    this.handleObjectIndex(child, hnode);
                } else if (nodeName.equals("text:user-index")) {
                    this.handleUserIndex(child, hnode);
                } else if (nodeName.equals("text:alphabetical-index")) {
                    hnode = this.maybeSplit(hnode, 1, bAfterHeading);
                    this.handleAlphabeticalIndex(child, hnode);
                } else if (nodeName.equals("text:bibliography")) {
                    hnode = this.maybeSplit(hnode, 1, bAfterHeading);
                    this.handleBibliography(child, hnode);
                } else if (nodeName.equals("text:sequence_decls")) {
                    // empty if block
                }
                if (!nodeName.equals("text:section")) {
                    --this.nDontSplitLevel;
                }
                bAfterHeading = nodeName.equals("text:h");
            }
            ++i;
        }
        return hnode;
    }

    private Node maybeSplit(Node node, int nLevel, boolean bAfterHeading) {
        if (bAfterHeading || this.nDontSplitLevel > 1) {
            return node;
        }
        if (this.nSplit >= nLevel) {
            return this.converter.nextOutFile();
        }
        return node;
    }

    private Node handleSection(Node onode, Node hnode) {
        String sName = Misc.getAttribute(onode, "text:name");
        String sStyleName = Misc.getAttribute(onode, "text:style-name");
        Element div = this.converter.createElement("div");
        hnode.appendChild(div);
        this.converter.addTarget(div, sName + "%7Cregion");
        this.getStyleCv().applySectionStyle(sStyleName, div);
        this.sections.push(onode);
        Node newhnode = this.traverseBlockText(onode, div);
        this.sections.pop();
        return newhnode.getParentNode();
    }

    private void handleHeading(Node onode, Node hnode) {
        int nLevel = Misc.getPosInteger(Misc.getAttribute(onode, "text:level"), 1);
        if (nLevel <= 6) {
            Element heading = this.converter.createElement("h" + nLevel);
            hnode.appendChild(heading);
            String sStyleName = Misc.getAttribute(onode, "text:style-name");
            ParStyle style = this.wsc.getParStyle(sStyleName);
            if (style != null) {
                this.getStyleCv().applyDirection(style, heading);
            }
            this.getStyleCv().setHeadingStyle(nLevel, sStyleName);
            if (!this.bInToc) {
                this.converter.addTarget(heading, "heading" + ++this.nHeadingCount);
            }
            this.prependAsapNode(heading);
            heading.appendChild(this.converter.createTextNode(this.outlineNumbering.step(nLevel).getLabel()));
            this.traverseInlineText(onode, heading);
        } else {
            this.handleParagraph(onode, hnode);
        }
    }

    private void handleParagraph(Node onode, Node hnode) {
        Element par;
        if (this.config.ignoreEmptyParagraphs() && !onode.hasChildNodes()) {
            return;
        }
        if (this.converter.isCalc()) {
            par = (Element)hnode;
        } else {
            String sStyleName = Misc.getAttribute(onode, "text:style-name");
            par = this.createParagraph((Element)hnode, sStyleName);
        }
        this.prependAsapNode(par);
        if (onode.hasChildNodes()) {
            this.traverseInlineText(onode, par);
        } else {
            par.appendChild(this.converter.createTextNode("\u00a0"));
        }
    }

    private void prependAsapNode(Node node) {
        if (this.asapNode != null) {
            if (this.asapNode.getOwnerDocument() != node.getOwnerDocument()) {
                this.asapNode = this.converter.importNode(this.asapNode, true);
            }
            node.appendChild(this.asapNode);
            this.asapNode = null;
        }
    }

    private void handleOL(Node onode, int nLevel, String sStyleName, Node hnode) {
        String sStyleName1 = Misc.getAttribute(onode, "text:style-name");
        if (sStyleName1 != null) {
            sStyleName = sStyleName1;
        }
        Element list = this.converter.createElement("ol");
        this.applyListStyle(nLevel, sStyleName, list);
        hnode.appendChild(list);
        this.traverseList(onode, nLevel, sStyleName, list);
    }

    private void handleUL(Node onode, int nLevel, String sStyleName, Node hnode) {
        String sStyleName1 = Misc.getAttribute(onode, "text:style-name");
        if (sStyleName1 != null) {
            sStyleName = sStyleName1;
        }
        Element list = this.converter.createElement("ul");
        this.applyListStyle(nLevel, sStyleName, list);
        hnode.appendChild(list);
        this.traverseList(onode, nLevel, sStyleName, list);
    }

    private void traverseList(Node onode, int nLevel, String styleName, Node hnode) {
        if (onode.hasChildNodes()) {
            NodeList nList = onode.getChildNodes();
            int len = nList.getLength();
            int i = 0;
            while (i < len) {
                Node child = nList.item(i);
                if (child.getNodeType() == 1) {
                    Element item;
                    String nodeName = child.getNodeName();
                    if (nodeName.equals("text:list-item")) {
                        item = this.converter.createElement("li");
                        hnode.appendChild(item);
                        boolean bRestart = "true".equals(Misc.getAttribute(child, "text:restart-numbering"));
                        int nStartValue = Misc.getPosInteger(Misc.getAttribute(child, "text:start-value"), 1);
                        if (bRestart) {
                            item.setAttribute("value", Integer.toString(nStartValue));
                        }
                        this.traverseListItem(child, nLevel, styleName, item);
                    }
                    if (nodeName.equals("text:list-header")) {
                        item = this.converter.createElement("li");
                        hnode.appendChild(item);
                        item.setAttribute("style", "list-style-type:none");
                        this.traverseListItem(child, nLevel, styleName, item);
                    }
                }
                ++i;
            }
        }
    }

    private void traverseListItem(Node onode, int nLevel, String styleName, Node hnode) {
        if (this.config.xhtmlIgnoreStyles() && onode.hasChildNodes()) {
            NodeList list = onode.getChildNodes();
            int nLen = list.getLength();
            boolean nParCount = false;
            boolean bNoPTag = true;
            int i = 0;
            while (i < nLen) {
                if (list.item(i).getNodeType() == 1) {
                    if (list.item(i).getNodeName().equals("text:p") && bNoPTag) {
                        String sStyleName = Misc.getAttribute(list.item(0), "text:style-name");
                        if (this.config.getXParStyleMap().contains(sStyleName)) {
                            bNoPTag = false;
                        }
                    } else {
                        bNoPTag = false;
                    }
                }
                ++i;
            }
            if (bNoPTag) {
                int i2 = 0;
                while (i2 < nLen) {
                    Node child = list.item(i2);
                    if (child.getNodeType() == 1) {
                        String nodeName = child.getNodeName();
                        if (nodeName.equals("text:p")) {
                            this.traverseInlineText(child, hnode);
                        }
                        if (nodeName.equals("text:ordered-list")) {
                            this.handleOL(child, nLevel + 1, styleName, hnode);
                        }
                        if (nodeName.equals("text:unordered-list")) {
                            this.handleUL(child, nLevel + 1, styleName, hnode);
                        }
                    }
                    ++i2;
                }
                return;
            }
        }
        this.traverseBlockText(onode, nLevel, styleName, hnode);
    }

    private void handleTOC(Node onode, Node hnode) {
        if (this.headings == null) {
            return;
        }
        this.nTocIndex = this.converter.getOutFileIndex();
        this.bInToc = true;
        Element source = Misc.getChildByTagName(onode, "text:table-of-content-source");
        if (source != null && !"chapter".equals(Misc.getAttribute(source, "text:index-source"))) {
            Element div = this.converter.createElement("div");
            this.converter.addTarget(div, "tableofcontents");
            hnode.appendChild(div);
            Element title = Misc.getChildByTagName(source, "text:index-title-template");
            if (title != null) {
                String sStyleName = Misc.getAttribute(title, "text:style-name");
                Element p = this.createParagraph(div, sStyleName);
                this.traversePCDATA(title, p);
            }
            String[] sEntryStyleName = new String[11];
            if (source.hasChildNodes()) {
                NodeList nl = source.getChildNodes();
                int nLen = nl.getLength();
                int i = 0;
                while (i < nLen) {
                    int nLevel;
                    Node child = nl.item(i);
                    if (child.getNodeType() == 1 && child.getNodeName().equals("text:table-of-content-entry-template") && (nLevel = Misc.getPosInteger(Misc.getAttribute(child, "text:outline-level"), 1)) <= 10) {
                        sEntryStyleName[nLevel] = Misc.getAttribute(child, "text:style-name");
                    }
                    ++i;
                }
            }
            int nMaxLevel = Misc.getPosInteger(Misc.getAttribute(source, "text:outline-level"), 1);
            ListCounter counter = new ListCounter(this.wsc.getOutlineStyle());
            int nHeadingCount = 0;
            int nLen = this.headings.getLength();
            int i = 0;
            while (i < nLen) {
                Node heading = this.headings.item(i);
                int nLevel = Misc.getPosInteger(Misc.getAttribute(heading, "text:level"), 1);
                ++nHeadingCount;
                counter.step(nLevel);
                if (nLevel <= nMaxLevel) {
                    Element p = this.createParagraph(div, sEntryStyleName[nLevel]);
                    p.appendChild(this.converter.createTextNode(counter.getLabel()));
                    Element a = this.converter.createLink("heading" + nHeadingCount);
                    p.appendChild(a);
                    this.traverseInlineText(heading, a);
                }
                ++i;
            }
        }
        this.bInToc = false;
    }

    private void handleLOF(Node onode, Node hnode) {
    }

    private void handleLOT(Node onode, Node hnode) {
    }

    private void handleObjectIndex(Node onode, Node hnode) {
    }

    private void handleUserIndex(Node onode, Node hnode) {
    }

    private void handleAlphabeticalIndex(Node onode, Node hnode) {
        this.nAlphabeticalIndex = this.converter.getOutFileIndex();
        Element source = Misc.getChildByTagName(onode, "text:alphabetical-index-source");
        if (source != null) {
            Collator collator;
            String sLanguage;
            Element div = this.converter.createElement("div");
            this.converter.addTarget(div, "alphabeticalindex");
            hnode.appendChild(div);
            Element title = Misc.getChildByTagName(source, "text:index-title-template");
            if (title != null) {
                String sStyleName = Misc.getAttribute(title, "text:style-name");
                Element p = this.createParagraph(div, sStyleName);
                this.traversePCDATA(title, p);
            }
            String sEntryStyleName = null;
            if (source.hasChildNodes()) {
                NodeList nl = source.getChildNodes();
                int nLen = nl.getLength();
                int i = 0;
                while (i < nLen) {
                    int nLevel;
                    Node child = nl.item(i);
                    if (child.getNodeType() == 1 && child.getNodeName().equals("text:alphabetical-index-entry-template") && (nLevel = Misc.getPosInteger(Misc.getAttribute(child, "text:outline-level"), 1)) == 1) {
                        sEntryStyleName = Misc.getAttribute(child, "text:style-name");
                    }
                    ++i;
                }
            }
            if ((sLanguage = Misc.getAttribute(source, "fo:language")) == null) {
                collator = Collator.getInstance();
            } else {
                String sCountry = Misc.getAttribute(source, "fo:country");
                if (sCountry == null) {
                    sCountry = "";
                }
                collator = Collator.getInstance(new Locale(sLanguage, sCountry));
            }
            int i = 0;
            while (i <= this.nIndexIndex) {
                int j = i + 1;
                while (j <= this.nIndexIndex) {
                    AlphabeticalEntry entryi = (AlphabeticalEntry)this.index.get(i);
                    AlphabeticalEntry entryj = (AlphabeticalEntry)this.index.get(j);
                    if (collator.compare(entryi.sWord, entryj.sWord) > 0) {
                        this.index.set(i, entryj);
                        this.index.set(j, entryi);
                    }
                    ++j;
                }
                ++i;
            }
            Element table = this.converter.createElement("table");
            table.setAttribute("style", "width:100%");
            div.appendChild(table);
            Element tr = this.converter.createElement("tr");
            table.appendChild(tr);
            Element[] td = new Element[4];
            int i2 = 0;
            while (i2 < 4) {
                td[i2] = this.converter.createElement("td");
                td[i2].setAttribute("style", "vertical-align:top");
                tr.appendChild(td[i2]);
                ++i2;
            }
            int nColEntries = this.nIndexIndex / 4 + 1;
            int nColIndex = -1;
            int i3 = 0;
            while (i3 <= this.nIndexIndex) {
                if (i3 % nColEntries == 0) {
                    ++nColIndex;
                }
                AlphabeticalEntry entry = (AlphabeticalEntry)this.index.get(i3);
                Element p = this.createParagraph(td[nColIndex], sEntryStyleName);
                Element a = this.converter.createLink("idx" + entry.nIndex);
                p.appendChild(a);
                a.appendChild(this.converter.createTextNode(entry.sWord));
                ++i3;
            }
        }
    }

    private void handleBibliography(Node onode, Node hnode) {
        Element body = Misc.getChildByTagName(onode, "text:index-body");
        if (body != null) {
            Element div = this.converter.createElement("div");
            this.converter.addTarget(div, "bibliography");
            hnode.appendChild(div);
            Element title = Misc.getChildByTagName(body, "text:index-title");
            if (title != null) {
                this.traverseBlockText(title, div);
            }
            this.traverseBlockText(body, div);
        }
    }

    private void traverseInlineText(Node onode, Node hnode) {
        String styleName = Misc.getAttribute(onode, "text:style-name");
        if (onode.hasChildNodes()) {
            NodeList nList = onode.getChildNodes();
            int nLen = nList.getLength();
            int i = 0;
            while (i < nLen) {
                Node child = nList.item(i);
                short nodeType = child.getNodeType();
                switch (nodeType) {
                    case 3: {
                        String s = child.getNodeValue();
                        if (s.length() <= 0) break;
                        hnode.appendChild(this.converter.createTextNode(s));
                        break;
                    }
                    case 1: {
                        String sName = child.getNodeName();
                        if (child.getNodeName().startsWith("draw:")) {
                            this.getDrawCv().handleDrawElement(child, hnode);
                            break;
                        }
                        if (child.getNodeName().equals("text:s")) {
                            if (this.config.ignoreDoubleSpaces()) {
                                hnode.appendChild(this.converter.createTextNode(" "));
                                break;
                            }
                            int count = Misc.getPosInteger(Misc.getAttribute(child, "text:c"), 1);
                            while (count > 0) {
                                hnode.appendChild(this.converter.createTextNode("\u00a0"));
                                --count;
                            }
                            break;
                        }
                        if (sName.equals("text:tab-stop")) {
                            hnode.appendChild(this.converter.createTextNode(" "));
                            break;
                        }
                        if (sName.equals("text:line-break")) {
                            if (this.config.ignoreHardLineBreaks()) break;
                            hnode.appendChild(this.converter.createElement("br"));
                            break;
                        }
                        if (sName.equals("text:span")) {
                            this.handleSpan(child, hnode);
                            break;
                        }
                        if (sName.equals("text:a")) {
                            this.handleAnchor(child, hnode);
                            break;
                        }
                        if (sName.equals("text:footnote")) {
                            this.handleFootnote(child, hnode);
                            break;
                        }
                        if (sName.equals("text:endnote")) {
                            this.handleEndnote(child, hnode);
                            break;
                        }
                        if (sName.equals("text:sequence")) {
                            this.handleSequence(child, hnode);
                            break;
                        }
                        if (sName.equals("text:page-number")) {
                            this.handlePageNumber(child, hnode);
                            break;
                        }
                        if (sName.equals("text:page-count")) {
                            this.handlePageCount(child, hnode);
                            break;
                        }
                        if (sName.equals("text:sequence-ref")) {
                            this.handleSequenceRef(child, hnode);
                            break;
                        }
                        if (sName.equals("text:footnote-ref")) {
                            this.handleFootnoteRef(child, hnode);
                            break;
                        }
                        if (sName.equals("text:endnote-ref")) {
                            this.handleEndnoteRef(child, hnode);
                            break;
                        }
                        if (sName.equals("text:reference-mark")) {
                            this.handleReferenceMark(child, hnode);
                            break;
                        }
                        if (sName.equals("text:reference-mark-start")) {
                            this.handleReferenceMark(child, hnode);
                            break;
                        }
                        if (sName.equals("text:reference-ref")) {
                            this.handleReferenceRef(child, hnode);
                            break;
                        }
                        if (sName.equals("text:bookmark")) {
                            this.handleBookmark(child, hnode);
                            break;
                        }
                        if (sName.equals("text:bookmark-start")) {
                            this.handleBookmark(child, hnode);
                            break;
                        }
                        if (sName.equals("text:bookmark-ref")) {
                            this.handleBookmarkRef(child, hnode);
                            break;
                        }
                        if (sName.equals("text:alphabetical-index-mark")) {
                            this.handleAlphabeticalIndexMark(child, hnode);
                            break;
                        }
                        if (sName.equals("text:alphabetical-index-mark-start")) {
                            this.handleAlphabeticalIndexMarkStart(child, hnode);
                            break;
                        }
                        if (sName.equals("text:bibliography-mark")) {
                            this.handleBibliographyMark(child, hnode);
                            break;
                        }
                        if (sName.equals("office:annotation")) {
                            this.converter.handleOfficeAnnotation(child, hnode);
                            break;
                        }
                        if (!sName.startsWith("text:")) break;
                        this.traverseInlineText(child, hnode);
                        break;
                    }
                }
                ++i;
            }
        }
    }

    private void handleSpan(Node onode, Node hnode) {
        String sStyleName = Misc.getAttribute(onode, "text:style-name");
        Element span = this.createInline((Element)hnode, sStyleName);
        this.traverseInlineText(onode, span);
    }

    private void traversePCDATA(Node onode, Node hnode) {
        if (onode.hasChildNodes()) {
            NodeList nl = onode.getChildNodes();
            int nLen = nl.getLength();
            int i = 0;
            while (i < nLen) {
                if (nl.item(i).getNodeType() == 3) {
                    hnode.appendChild(this.converter.createTextNode(nl.item(i).getNodeValue()));
                }
                ++i;
            }
        }
    }

    protected void handleAnchor(Node onode, Node hnode) {
        String sStyleName = Misc.getAttribute(onode, "text:style-name");
        String sVisitedStyleName = Misc.getAttribute(onode, "text:visited-style-name");
        this.getStyleCv().setAnchorStyle(sStyleName, sVisitedStyleName);
        String sHref = Misc.getAttribute(onode, "xlink:href");
        if (sHref != null) {
            Element anchor;
            if (sHref.startsWith("#")) {
                anchor = this.converter.createLink(sHref.substring(1));
            } else {
                int n3F;
                anchor = this.converter.createElement("a");
                if (sHref.indexOf("?") == -1 && (n3F = sHref.indexOf("%3F")) > 0) {
                    sHref = sHref.substring(0, n3F) + "?" + sHref.substring(n3F + 3);
                }
                anchor.setAttribute("href", sHref);
            }
            hnode.appendChild(anchor);
            this.traverseInlineText(onode, anchor);
        } else {
            this.traverseInlineText(onode, hnode);
        }
    }

    private void handleFootnote(Node onode, Node hnode) {
        String sId = Misc.getAttribute(onode, "text:id");
        Element span = this.createInline((Element)hnode, this.sFntCitBodyStyle);
        Element link = this.converter.createLink(sId);
        this.converter.addTarget(link, "body" + sId);
        span.appendChild(link);
        Element citation = Misc.getChildByTagName(onode, "text:footnote-citation");
        this.traversePCDATA(citation, link);
        this.footnotes.add(onode);
    }

    public void insertFootnotes(Node hnode) {
        int n = this.footnotes.size();
        int i = 0;
        while (i < n) {
            Node footnote = (Node)this.footnotes.get(i);
            String sId = Misc.getAttribute(footnote, "text:id");
            Element citation = Misc.getChildByTagName(footnote, "text:footnote-citation");
            Element body = Misc.getChildByTagName(footnote, "text:footnote-body");
            this.traverseNoteBody(sId, this.sFntCitStyle, citation, body, hnode);
            ++i;
        }
        this.footnotes.clear();
    }

    private void handleEndnote(Node onode, Node hnode) {
        String sId = Misc.getAttribute(onode, "text:id");
        Element span = this.createInline((Element)hnode, this.sEntCitBodyStyle);
        Element link = this.converter.createLink(sId);
        this.converter.addTarget(link, "body" + sId);
        span.appendChild(link);
        Element citation = Misc.getChildByTagName(onode, "text:endnote-citation");
        this.traversePCDATA(citation, link);
        this.endnotes.add(onode);
    }

    public void insertEndnotes(Node hnode) {
        int n = this.endnotes.size();
        if (this.nSplit > 0 && n > 0) {
            hnode = this.converter.nextOutFile();
        }
        int i = 0;
        while (i < n) {
            Node endnote = (Node)this.endnotes.get(i);
            String sId = Misc.getAttribute(endnote, "text:id");
            Element citation = Misc.getChildByTagName(endnote, "text:endnote-citation");
            Element body = Misc.getChildByTagName(endnote, "text:endnote-body");
            this.traverseNoteBody(sId, this.sEntCitStyle, citation, body, hnode);
            ++i;
        }
    }

    private void traverseNoteBody(String sId, String sCitStyle, Node citation, Node onode, Node hnode) {
        Element link = this.converter.createLink("body" + sId);
        this.converter.addTarget(link, sId);
        if (!this.config.xhtmlIgnoreStyles()) {
            this.getStyleCv().applyTextStyle(sCitStyle, link);
        }
        this.traversePCDATA(citation, link);
        Element span = this.converter.createElement("span");
        span.appendChild(link);
        span.appendChild(this.converter.createTextNode(" "));
        this.asapNode = span;
        this.traverseBlockText(onode, hnode);
    }

    private void handlePageNumber(Node onode, Node hnode) {
        hnode.appendChild(this.converter.createTextNode("(Page number)"));
    }

    private void handlePageCount(Node onode, Node hnode) {
        hnode.appendChild(this.converter.createTextNode("(Page count)"));
    }

    private void handleSequence(Node onode, Node hnode) {
        String sName = Misc.getAttribute(onode, "text:ref-name");
        if (sName != null && !this.bInToc) {
            Element anchor = this.converter.createTarget("seq" + sName);
            hnode.appendChild(anchor);
            this.traversePCDATA(onode, anchor);
        } else {
            this.traversePCDATA(onode, hnode);
        }
    }

    private void createReference(Node onode, Node hnode, String sPrefix) {
        String sFormat = Misc.getAttribute(onode, "text:reference-format");
        String sName = Misc.getAttribute(onode, "text:ref-name");
        Element anchor = this.converter.createLink(sPrefix + sName);
        hnode.appendChild(anchor);
        if ("page".equals(sFormat)) {
            anchor.appendChild(this.converter.createTextNode("1"));
        } else {
            this.traversePCDATA(onode, anchor);
        }
    }

    private void handleSequenceRef(Node onode, Node hnode) {
        this.createReference(onode, hnode, "seq");
    }

    private void handleFootnoteRef(Node onode, Node hnode) {
        this.createReference(onode, hnode, "");
    }

    private void handleEndnoteRef(Node onode, Node hnode) {
        this.createReference(onode, hnode, "");
    }

    private void handleReferenceMark(Node onode, Node hnode) {
        String sName = Misc.getAttribute(onode, "text:name");
        if (sName != null && !this.bInToc) {
            hnode.appendChild(this.converter.createTarget("ref" + sName));
        }
    }

    private void handleReferenceRef(Node onode, Node hnode) {
        this.createReference(onode, hnode, "ref");
    }

    private void handleBookmark(Node onode, Node hnode) {
        String sName = Misc.getAttribute(onode, "text:name");
        if (sName != null && !this.bInToc) {
            hnode.appendChild(this.converter.createTarget(sName));
            hnode.appendChild(this.converter.createTarget("bkm" + sName));
        }
    }

    private void handleBookmarkRef(Node onode, Node hnode) {
        this.createReference(onode, hnode, "bkm");
    }

    private void handleAlphabeticalIndexMark(Node onode, Node hnode) {
        if (this.bInToc) {
            return;
        }
        String sWord = Misc.getAttribute(onode, "text:string-value");
        if (sWord == null) {
            return;
        }
        AlphabeticalEntry entry = new AlphabeticalEntry();
        entry.sWord = sWord;
        entry.nIndex = ++this.nIndexIndex;
        this.index.add(entry);
        hnode.appendChild(this.converter.createTarget("idx" + this.nIndexIndex));
    }

    private void handleAlphabeticalIndexMarkStart(Node onode, Node hnode) {
        if (this.bInToc) {
            return;
        }
        String sWord = IndexMark.getIndexValue(onode);
        if (sWord == null) {
            return;
        }
        AlphabeticalEntry entry = new AlphabeticalEntry();
        entry.sWord = sWord;
        entry.nIndex = ++this.nIndexIndex;
        this.index.add(entry);
        hnode.appendChild(this.converter.createTarget("idx" + this.nIndexIndex));
    }

    private void handleBibliographyMark(Node onode, Node hnode) {
        if (this.bInToc) {
            this.traversePCDATA(onode, hnode);
        } else {
            Element anchor = this.converter.createLink("bibliography");
            hnode.appendChild(anchor);
            this.traversePCDATA(onode, anchor);
        }
    }

    private Element applyAttributes(Element node, StyleWithProperties style) {
        if (!this.config.xhtmlIgnoreStyles()) {
            return node;
        }
        if (style == null) {
            return node;
        }
        node = this.applyAttribute(node, "bold", this.getStyleCv().isBold(style));
        node = this.applyAttribute(node, "italics", this.getStyleCv().isItalics(style));
        node = this.applyAttribute(node, "fixed", this.getStyleCv().isFixed(style));
        node = this.applyAttribute(node, "superscript", this.getStyleCv().isSuperscript(style));
        node = this.applyAttribute(node, "subscript", this.getStyleCv().isSubscript(style));
        return node;
    }

    private Element applyAttribute(Element node, String sAttr, boolean bApply) {
        if (!bApply) {
            return node;
        }
        XhtmlStyleMap xattr = this.config.getXAttrStyleMap();
        if (!xattr.contains(sAttr)) {
            return node;
        }
        Element attr = this.converter.createElement(xattr.getElement(sAttr));
        if (!"(none)".equals(xattr.getCss(sAttr))) {
            attr.setAttribute("class", xattr.getCss(sAttr));
        }
        node.appendChild(attr);
        return attr;
    }

    private Element createParagraph(Element node, String sStyleName) {
        String sParentName;
        XhtmlStyleMap xpar = this.config.getXParStyleMap();
        if (xpar.contains(sStyleName)) {
            Element par = this.converter.createElement(xpar.getElement(sStyleName));
            if (!"(none)".equals(xpar.getCss(sStyleName))) {
                par.setAttribute("class", xpar.getCss(sStyleName));
            }
            node.appendChild(par);
            return par;
        }
        ParStyle style = this.wsc.getParStyle(sStyleName);
        if (style != null && style.isAutomatic() && style.getParentName() != null && xpar.contains(sParentName = style.getParentName())) {
            Element par = this.converter.createElement(xpar.getElement(sParentName));
            if (!"(none)".equals(xpar.getCss(sParentName))) {
                par.setAttribute("class", xpar.getCss(sParentName));
            }
            node.appendChild(par);
            return this.applyAttributes(par, style);
        }
        Element par = this.converter.createElement("p");
        this.getStyleCv().applyParStyle(sStyleName, par, !this.config.xhtmlIgnoreStyles());
        node.appendChild(par);
        return this.applyAttributes(par, style);
    }

    private Element createInline(Element node, String sStyleName) {
        XhtmlStyleMap xtext = this.config.getXTextStyleMap();
        if (xtext.contains(sStyleName)) {
            Element inline = this.converter.createElement(xtext.getElement(sStyleName));
            if (!"(none)".equals(xtext.getCss(sStyleName))) {
                inline.setAttribute("class", xtext.getCss(sStyleName));
            }
            node.appendChild(inline);
            return inline;
        }
        if (this.config.xhtmlIgnoreStyles()) {
            StyleWithProperties style = this.wsc.getTextStyle(sStyleName);
            if (style != null && style.isAutomatic()) {
                node = this.createInline(node, style.getParentName());
                return this.applyAttributes(node, style);
            }
            return node;
        }
        Element inline = this.converter.createElement("span");
        this.getStyleCv().applyTextStyle(sStyleName, inline);
        node.appendChild(inline);
        return inline;
    }

    private void applyListStyle(int nLevel, String sStyleName, Element list) {
        XhtmlStyleMap xlist = this.config.getXListStyleMap();
        if (xlist.contains(sStyleName)) {
            if (!"(none)".equals(xlist.getCss(sStyleName))) {
                list.setAttribute("class", xlist.getCss(sStyleName));
            }
        } else {
            this.getStyleCv().applyListStyle(nLevel, sStyleName, list, !this.config.xhtmlIgnoreStyles());
        }
    }
}

