/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp;

import gnu.regexp.CharIndexed;
import gnu.regexp.REMatch;
import gnu.regexp.REToken;

final class RETokenPOSIX
extends REToken {
    static final int ALNUM = 0;
    static final int ALPHA = 1;
    static final int BLANK = 2;
    static final int CNTRL = 3;
    static final int DIGIT = 4;
    static final int GRAPH = 5;
    static final int LOWER = 6;
    static final int PRINT = 7;
    static final int PUNCT = 8;
    static final int SPACE = 9;
    static final int UPPER = 10;
    static final int XDIGIT = 11;
    static final String[] s_nameTable = new String[]{"alnum", "alpha", "blank", "cntrl", "digit", "graph", "lower", "print", "punct", "space", "upper", "xdigit"};
    int type;
    boolean insens;
    boolean negated;

    static final int intValue(String string) {
        int n = 0;
        while (n < s_nameTable.length) {
            if (s_nameTable[n].equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    final int getMinimumLength() {
        return 1;
    }

    final int getMaximumLength() {
        return 1;
    }

    final REMatch matchThis(CharIndexed charIndexed, REMatch rEMatch) {
        char c = charIndexed.charAt(rEMatch.index);
        boolean bl = this.matchOneChar(c);
        if (bl) {
            ++rEMatch.index;
            return rEMatch;
        }
        return null;
    }

    final boolean matchOneChar(char c) {
        if (c == (char)-1) {
            return false;
        }
        boolean bl = false;
        switch (this.type) {
            case 0: {
                boolean bl2 = false;
                if (Character.isLetterOrDigit(c) || c == '_') {
                    bl2 = true;
                }
                bl = bl2;
                break;
            }
            case 1: {
                bl = Character.isLetter(c);
                break;
            }
            case 2: {
                boolean bl3 = false;
                if (c == ' ' || c == '\t') {
                    bl3 = true;
                }
                bl = bl3;
                break;
            }
            case 3: {
                bl = Character.isISOControl(c);
                break;
            }
            case 4: {
                bl = Character.isDigit(c);
                break;
            }
            case 5: {
                boolean bl4 = false;
                if (Character.isWhitespace(c) || Character.isISOControl(c)) {
                    bl4 = true;
                }
                bl = bl4 ^ true;
                break;
            }
            case 6: {
                boolean bl5 = false;
                if (this.insens && Character.isLetter(c) || Character.isLowerCase(c)) {
                    bl5 = true;
                }
                bl = bl5;
                break;
            }
            case 7: {
                boolean bl6 = false;
                if (!Character.isWhitespace(c) && !Character.isISOControl(c) || c == ' ') {
                    bl6 = true;
                }
                bl = bl6;
                break;
            }
            case 8: {
                boolean bl7 = false;
                if ("`~!@#$%^&*()-_=+[]{}\\|;:'\"/?,.<>".indexOf(c) != -1) {
                    bl7 = true;
                }
                bl = bl7;
                break;
            }
            case 9: {
                bl = Character.isWhitespace(c);
                break;
            }
            case 10: {
                boolean bl8 = false;
                if (this.insens && Character.isLetter(c) || Character.isUpperCase(c)) {
                    bl8 = true;
                }
                bl = bl8;
                break;
            }
            case 11: {
                boolean bl9 = false;
                if (Character.isDigit(c) || "abcdefABCDEF".indexOf(c) != -1) {
                    bl9 = true;
                }
                bl = bl9;
                break;
            }
        }
        if (this.negated) {
            bl ^= true;
        }
        return bl;
    }

    final boolean returnsFixedLengthMatches() {
        return true;
    }

    final int findFixedLengthMatches(CharIndexed charIndexed, REMatch rEMatch, int n) {
        char c;
        int n2;
        int n3 = rEMatch.index;
        for (n2 = 0; n2 < n && this.matchOneChar(c = charIndexed.charAt(n3++)); ++n2) {
        }
        return n2;
    }

    final void dump(StringBuffer stringBuffer) {
        if (this.negated) {
            stringBuffer.append('^');
        }
        stringBuffer.append("[:" + s_nameTable[this.type] + ":]");
    }

    RETokenPOSIX(int n, int n2, boolean bl, boolean bl2) {
        super(n);
        this.type = n2;
        this.insens = bl;
        this.negated = bl2;
    }
}

