/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;

public class BandCombineOp
implements RasterOp {
    private RenderingHints hints;
    private float[][] matrix;

    public WritableRaster filter(Raster raster, WritableRaster writableRaster) {
        if (writableRaster == null) {
            writableRaster = this.createCompatibleDestRaster(raster);
        }
        float[] fArray = new float[this.matrix[0].length];
        float[] fArray2 = new float[this.matrix.length];
        int n = raster.getMinY();
        while (n < raster.getHeight() + raster.getMinY()) {
            int n2 = raster.getMinX();
            while (n2 < raster.getWidth() + raster.getMinX()) {
                fArray[fArray.length - 1] = 1.0f;
                raster.getPixel(n2, n, fArray);
                int n3 = 0;
                while (n3 < this.matrix.length) {
                    fArray2[n3] = 0.0f;
                    int n4 = 0;
                    while (n4 < this.matrix[0].length) {
                        int n5 = n3;
                        fArray2[n5] = fArray2[n5] + fArray[n4] * this.matrix[n3][n4];
                        ++n4;
                    }
                    ++n3;
                }
                writableRaster.setPixel(n2, n, fArray2);
                ++n2;
            }
            ++n;
        }
        return writableRaster;
    }

    public final Rectangle2D getBounds2D(Raster raster) {
        return raster.getBounds();
    }

    public WritableRaster createCompatibleDestRaster(Raster raster) {
        return Raster.createBandedRaster(4, raster.getWidth(), raster.getHeight(), this.matrix.length, new Point(raster.getMinX(), raster.getMinY()));
    }

    public final Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            return (Point2D)point2D.clone();
        }
        point2D2.setLocation(point2D);
        return point2D2;
    }

    public final RenderingHints getRenderingHints() {
        return this.hints;
    }

    public final float[][] getMatrix() {
        return this.matrix;
    }

    public BandCombineOp(float[][] fArray, RenderingHints renderingHints) {
        this.matrix = fArray;
        this.hints = renderingHints;
    }
}

