/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FileHandler
extends StreamHandler {
    private final int limit;
    private final int count;
    private final String pattern;
    private final boolean append;
    long written;
    private LinkedList logFiles;
    static /* synthetic */ Class class$java$util$logging$XMLFormatter;

    private final OutputStream createFileStream(String string, int n, int n2, boolean bl, int n3) {
        int n4 = 0;
        LogManager.getLogManager().checkAccess();
        if (string == null) {
            string = LogManager.getLogManager().getProperty("java.util.logging.FileHandler.pattern");
        }
        if (string == null) {
            string = "%h/java%u.log";
        }
        if (n2 > 1 && !FileHandler.has(string, 'g')) {
            string = string + ".%g";
        }
        while (true) {
            String string2 = FileHandler.replaceFileNameEscapes(string, n3, n4, n2);
            try {
                File file = new File(string2);
                if (!file.exists() || bl) {
                    FileOutputStream fileOutputStream = new FileOutputStream(file, bl);
                    if (this.logFiles.isEmpty()) {
                        this.logFiles.addFirst(string2);
                    }
                    return new ostr(fileOutputStream);
                }
            }
            catch (Exception exception) {
                this.reportError(null, exception, 4);
            }
            ++n4;
            if (FileHandler.has(string, 'u')) continue;
            string = string + ".%u";
        }
    }

    private static final String replaceFileNameEscapes(String string, int n, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer(string);
        boolean bl = false;
        int n4 = 0;
        do {
            String string2;
            if (stringBuffer.charAt(n4) == '/') {
                string2 = System.getProperty("file.separator");
                stringBuffer.replace(n4, n4 + 1, string2);
                n4 = n4 + string2.length() - 1;
                continue;
            }
            if (stringBuffer.charAt(n4) != '%') continue;
            switch (stringBuffer.charAt(n4 + 1)) {
                case 't': {
                    string2 = System.getProperty("java.io.tmpdir");
                    break;
                }
                case 'h': {
                    string2 = System.getProperty("user.home");
                    break;
                }
                case 'g': {
                    string2 = Integer.toString(n);
                    bl = true;
                    break;
                }
                case 'u': {
                    string2 = Integer.toString(n2);
                    break;
                }
                case '%': {
                    string2 = "%";
                    break;
                }
                default: {
                    string2 = "??";
                }
            }
            stringBuffer.replace(n4, n4 + 2, string2);
            n4 = n4 + string2.length() - 1;
        } while (++n4 < stringBuffer.length() - 1);
        if (!bl && n3 > 1) {
            stringBuffer.append('.');
            stringBuffer.append(n);
        }
        return stringBuffer.toString();
    }

    public void publish(LogRecord logRecord) {
        if (this.limit > 0 && this.written >= (long)this.limit) {
            this.rotate();
        }
        super.publish(logRecord);
        this.flush();
    }

    private final synchronized void rotate() {
        if (this.logFiles.size() > 0) {
            String string;
            File file = null;
            ListIterator listIterator = null;
            if (this.logFiles.size() == this.count) {
                file = new File((String)this.logFiles.getLast());
                file.delete();
                listIterator = this.logFiles.listIterator(this.logFiles.size() - 1);
            } else {
                string = FileHandler.replaceFileNameEscapes(this.pattern, this.logFiles.size(), 0, this.count);
                file = new File(string);
                this.logFiles.addLast(string);
                listIterator = this.logFiles.listIterator(this.logFiles.size() - 1);
            }
            while (listIterator.hasPrevious()) {
                string = (String)listIterator.previous();
                File file2 = new File(string);
                file2.renameTo(file);
                file = file2;
            }
        }
        this.setOutputStream(this.createFileStream(this.pattern, this.limit, this.count, this.append, 0));
        this.written = 0L;
    }

    /*
     * Unable to fully structure code
     */
    private static final boolean has(String var0, char var1_1) {
        var2_2 = var0.length();
        var3_3 = false;
        var4_4 = 0;
        while (var4_4 < var2_2) {
            var5_5 = var0.charAt(var4_4);
            if (!var3_3) ** GOTO lbl-1000
            if (var5_5 == var1_1) {
                return true;
            }
            if (var5_5 == '%') {
                var3_3 = false;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
                if (var5_5 == '%') {
                    v0 = true;
                }
                var3_3 = v0;
            }
            ++var4_4;
        }
        return false;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public FileHandler() throws IOException, SecurityException {
        this(null, LogManager.getIntProperty("java.util.logging.FileHandler.limit", 0), LogManager.getIntProperty("java.util.logging.FileHandler.count", 1), LogManager.getBooleanProperty("java.util.logging.FileHandler.append", false));
    }

    public FileHandler(String string) throws IOException, SecurityException {
        this(string, 0, 1, false);
    }

    public FileHandler(String string, boolean bl) throws IOException, SecurityException {
        this(string, 0, 1, bl);
    }

    public FileHandler(String string, int n, int n2) throws IOException, SecurityException {
        this(string, n, n2, LogManager.getBooleanProperty("java.util.logging.FileHandler.append", false));
    }

    public FileHandler(String string, int n, int n2, boolean bl) throws IOException, SecurityException {
        Class clazz = class$java$util$logging$XMLFormatter;
        if (clazz == null) {
            clazz = class$java$util$logging$XMLFormatter = FileHandler.class("[Ljava.util.logging.XMLFormatter;", false);
        }
        super(null, "java.util.logging.FileHandler", Level.ALL, null, clazz);
        if (n < 0 || n2 < 1) {
            throw new IllegalArgumentException();
        }
        this.pattern = string;
        this.limit = n;
        this.count = n2;
        this.append = bl;
        this.written = 0L;
        this.logFiles = new LinkedList();
        this.setOutputStream(this.createFileStream(string, n, n2, bl, 0));
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private final class ostr
    extends FilterOutputStream {
        public final void write(int n) throws IOException {
            this.out.write(n);
            ++FileHandler.this.written;
        }

        public final void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        public final void write(byte[] byArray, int n, int n2) throws IOException {
            this.out.write(byArray, n, n2);
            FileHandler.this.written += (long)n2;
        }

        private ostr(OutputStream outputStream) {
            super(outputStream);
        }
    }
}

