/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;

public class ShortMessage
extends MidiMessage {
    public static final int MIDI_TIME_CODE = 241;
    public static final int SONG_POSITION_POINTER = 242;
    public static final int SONG_SELECT = 243;
    public static final int TUNE_REQUEST = 246;
    public static final int END_OF_EXCLUSIVE = 247;
    public static final int TIMING_CLOCK = 248;
    public static final int START = 250;
    public static final int CONTINUE = 251;
    public static final int STOP = 252;
    public static final int ACTIVE_SENSING = 254;
    public static final int SYSTEM_RESET = 255;
    public static final int NOTE_OFF = 128;
    public static final int NOTE_ON = 144;
    public static final int POLY_PRESSURE = 160;
    public static final int CONTROL_CHANGE = 176;
    public static final int PROGRAM_CHANGE = 192;
    public static final int CHANNEL_PRESSURE = 208;
    public static final int PITCH_BEND = 224;
    private static byte[] defaultMessage = new byte[1];

    public void setMessage(int n, int n2, int n3) throws InvalidMidiDataException {
        this.length = this.getDataLength(n);
        ++this.length;
        if (this.data == null || this.data.length < this.length) {
            this.data = new byte[this.length];
        }
        this.data[0] = (byte)n;
        if (this.length > 1) {
            if (n2 < 0 || n2 > 127) {
                throw new InvalidMidiDataException("data1 (" + n2 + ") must be between 0 and 127.");
            }
            this.data[1] = (byte)n2;
            if (this.length > 2) {
                if (n3 < 0 || n3 > 127) {
                    throw new InvalidMidiDataException("data2 (" + n3 + ") must be between 0 and 127.");
                }
                this.data[2] = (byte)n3;
            }
        }
    }

    public void setMessage(int n, int n2, int n3, int n4) throws InvalidMidiDataException {
        this.setMessage(n + n2, n3, n4);
    }

    public void setMessage(int n) throws InvalidMidiDataException {
        int n2 = this.getDataLength(n);
        if (n2 != 0) {
            throw new InvalidMidiDataException("Status byte 0x" + Integer.toHexString(n) + " requires " + n2 + " bytes of data.");
        }
        this.setMessage(n, 0, 0);
    }

    protected final int getDataLength(int n) throws InvalidMidiDataException {
        int n2 = n;
        if ((n & 0xF0) != 240) {
            n &= 0xF0;
        }
        switch (n) {
            case 128: 
            case 144: 
            case 160: 
            case 176: 
            case 224: 
            case 242: {
                return 2;
            }
            case 192: 
            case 208: 
            case 243: 
            case 245: {
                return 1;
            }
            case 246: 
            case 247: 
            case 248: 
            case 250: 
            case 251: 
            case 252: 
            case 254: 
            case 255: {
                return 0;
            }
        }
        throw new InvalidMidiDataException("Invalid status: 0x" + Integer.toHexString(n2));
    }

    public int getChannel() {
        return this.data[0] & 0xF;
    }

    public int getCommand() {
        return this.data[0] & 0xF0;
    }

    public int getData1() {
        if (this.length > 1) {
            return this.data[1];
        }
        return 0;
    }

    public int getData2() {
        if (this.length > 2) {
            return this.data[2];
        }
        return 0;
    }

    public Object clone() {
        byte[] byArray = new byte[this.length];
        System.arraycopy(this.data, 0, byArray, 0, this.length);
        return new ShortMessage(byArray);
    }

    public ShortMessage() {
        this(defaultMessage);
    }

    protected ShortMessage(byte[] byArray) {
        super(byArray);
    }

    static {
        ShortMessage.defaultMessage[0] = -4;
    }
}

