/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleExtendedComponent;
import javax.accessibility.AccessibleText;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.plaf.LabelUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JLabel
extends JComponent
implements Accessible,
SwingConstants {
    private static final long serialVersionUID = 5496508283662221534L;
    protected Component labelFor;
    transient String text;
    private transient int horizontalAlignment;
    private transient int horizontalTextPosition;
    private transient int verticalAlignment;
    private transient int verticalTextPosition;
    private transient Icon icon;
    private transient Icon disabledIcon;
    private transient int displayedMnemonic;
    private transient int displayedMnemonicIndex;
    private transient int iconTextGap;

    public LabelUI getUI() {
        return (LabelUI)this.ui;
    }

    public void setUI(LabelUI labelUI) {
        super.setUI(labelUI);
    }

    public void updateUI() {
        this.setUI((LabelUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "LabelUI";
    }

    protected String paramString() {
        return "JLabel";
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        if (this.text != string) {
            String string2 = this.text;
            this.text = string;
            this.firePropertyChange("text", string2, string);
            if (this.text != null && this.text.length() <= this.displayedMnemonicIndex) {
                this.setDisplayedMnemonicIndex(this.text.length() - 1);
            }
            this.revalidate();
            this.repaint();
        }
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        if (this.icon != icon) {
            Icon icon2 = this.icon;
            this.icon = icon;
            this.firePropertyChange("icon", icon2, icon);
        }
    }

    public Icon getDisabledIcon() {
        if (this.disabledIcon == null && this.icon instanceof ImageIcon) {
            this.disabledIcon = new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)this.icon).getImage()));
        }
        return this.disabledIcon;
    }

    public void setDisabledIcon(Icon icon) {
        if (this.disabledIcon != icon) {
            Icon icon2 = this.disabledIcon;
            this.disabledIcon = icon;
            this.firePropertyChange("disabledIcon", icon2, icon);
        }
    }

    public void setDisplayedMnemonic(int n) {
        if (this.displayedMnemonic != n) {
            this.firePropertyChange("displayedMnemonic", this.displayedMnemonic, n);
            this.displayedMnemonic = n;
            if (this.text != null) {
                this.setDisplayedMnemonicIndex(this.text.toUpperCase().indexOf(n));
            }
        }
    }

    public void setDisplayedMnemonic(char c) {
        this.setDisplayedMnemonic((int)Character.toUpperCase(c));
    }

    public int getDisplayedMnemonic() {
        return this.displayedMnemonic;
    }

    public void setDisplayedMnemonicIndex(int n) throws IllegalArgumentException {
        if (n < -1 || this.text != null && n >= this.text.length()) {
            throw new IllegalArgumentException();
        }
        if (n == -1 || this.text == null || this.text.charAt(n) != this.displayedMnemonic) {
            n = -1;
        }
        if (n != this.displayedMnemonicIndex) {
            int n2 = this.displayedMnemonicIndex;
            this.displayedMnemonicIndex = n;
            this.firePropertyChange("displayedMnemonicIndex", n2, n);
        }
    }

    public int getDisplayedMnemonicIndex() {
        return this.displayedMnemonicIndex;
    }

    protected int checkHorizontalKey(int n, String string) {
        if (n != 2 && n != 0 && n != 4 && n != 10 && n != 11) {
            throw new IllegalArgumentException(string);
        }
        return n;
    }

    protected int checkVerticalKey(int n, String string) {
        if (n != 1 && n != 3 && n != 0) {
            throw new IllegalArgumentException(string);
        }
        return n;
    }

    public int getIconTextGap() {
        return this.iconTextGap;
    }

    public void setIconTextGap(int n) {
        if (this.iconTextGap != n) {
            this.firePropertyChange("iconTextGap", this.iconTextGap, n);
            this.iconTextGap = n;
        }
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int n) {
        if (n == this.verticalAlignment) {
            return;
        }
        int n2 = this.verticalAlignment;
        this.verticalAlignment = this.checkVerticalKey(n, "verticalAlignment");
        this.firePropertyChange("verticalAlignment", n2, this.verticalAlignment);
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int n) {
        if (this.horizontalAlignment == n) {
            return;
        }
        int n2 = this.horizontalAlignment;
        this.horizontalAlignment = this.checkHorizontalKey(n, "horizontalAlignment");
        this.firePropertyChange("horizontalAlignment", n2, this.horizontalAlignment);
    }

    public int getVerticalTextPosition() {
        return this.verticalTextPosition;
    }

    public void setVerticalTextPosition(int n) {
        if (n != this.verticalTextPosition) {
            int n2 = this.verticalTextPosition;
            this.verticalTextPosition = this.checkVerticalKey(n, "verticalTextPosition");
            this.firePropertyChange("verticalTextPosition", n2, this.verticalTextPosition);
        }
    }

    public int getHorizontalTextPosition() {
        return this.horizontalTextPosition;
    }

    public void setHorizontalTextPosition(int n) {
        if (n != this.horizontalTextPosition) {
            int n2 = this.horizontalTextPosition;
            this.horizontalTextPosition = this.checkHorizontalKey(n, "horizontalTextPosition");
            this.firePropertyChange("horizontalTextPosition", n2, this.horizontalTextPosition);
        }
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        Icon icon;
        Icon icon2 = icon = this.isEnabled() ? this.icon : this.disabledIcon;
        if (icon != null && icon instanceof ImageIcon) {
            boolean bl = false;
            if (((ImageIcon)icon).getImage() == image) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public Component getLabelFor() {
        return this.labelFor;
    }

    public void setLabelFor(Component component) {
        if (component != this.labelFor) {
            Component component2 = this.labelFor;
            this.labelFor = component;
            this.firePropertyChange("labelFor", component2, this.labelFor);
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.repaint();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJLabel();
        }
        return this.accessibleContext;
    }

    private final /* synthetic */ void this() {
        this.horizontalAlignment = 10;
        this.horizontalTextPosition = 11;
        this.verticalAlignment = 0;
        this.verticalTextPosition = 0;
        this.displayedMnemonic = 0;
        this.displayedMnemonicIndex = -1;
        this.iconTextGap = 4;
    }

    public JLabel() {
        this(null, null, 10);
    }

    public JLabel(Icon icon) {
        this(null, icon, 0);
    }

    public JLabel(Icon icon, int n) {
        this(null, icon, n);
    }

    public JLabel(String string) {
        this(string, null, 10);
    }

    public JLabel(String string, int n) {
        this(string, null, n);
    }

    public JLabel(String string, Icon icon, int n) {
        this.this();
        this.text = string;
        this.icon = icon;
        this.horizontalAlignment = n;
        this.setAlignmentX(0.0f);
        this.updateUI();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class AccessibleJLabel
    extends JComponent.AccessibleJComponent
    implements AccessibleText,
    AccessibleExtendedComponent {
        public String getSelectedText() {
            return "";
        }

        public int getSelectionStart() {
            return -1;
        }

        public int getSelectionEnd() {
            return -1;
        }

        public AttributeSet getCharacterAttribute(int n) {
            return new SimpleAttributeSet();
        }

        public String getAtIndex(int n, int n2) {
            String string = "";
            int n3 = -1;
            int n4 = -1;
            switch (n) {
                case 1: {
                    string = String.valueOf(JLabel.this.text.charAt(n2));
                    break;
                }
                case 2: {
                    n3 = JLabel.this.text.lastIndexOf(32, n2);
                    n4 = JLabel.this.text.indexOf(32, n3 + 1);
                    if (n4 == -1) {
                        n4 = n3 + 1;
                    }
                    string = JLabel.this.text.substring(n3 + 1, n4);
                    break;
                }
                default: {
                    n3 = JLabel.this.text.lastIndexOf(46, n2);
                    n4 = JLabel.this.text.indexOf(46, n3 + 1);
                    if (n4 == -1) {
                        n4 = n3 + 1;
                    }
                    string = JLabel.this.text.substring(n3 + 1, n4);
                }
            }
            return string;
        }

        public String getAfterIndex(int n, int n2) {
            String string = "";
            int n3 = -1;
            int n4 = -1;
            switch (n) {
                case 1: {
                    string = String.valueOf(JLabel.this.text.charAt(n2 + 1));
                    break;
                }
                case 2: {
                    n3 = JLabel.this.text.indexOf(32, n2);
                    n4 = JLabel.this.text.indexOf(32, n3 + 1);
                    if (n4 == -1) {
                        n4 = n3 + 1;
                    }
                    string = JLabel.this.text.substring(n3 + 1, n4);
                    break;
                }
                default: {
                    n3 = JLabel.this.text.indexOf(46, n2);
                    n4 = JLabel.this.text.indexOf(46, n3 + 1);
                    if (n4 == -1) {
                        n4 = n3 + 1;
                    }
                    string = JLabel.this.text.substring(n3 + 1, n4);
                }
            }
            return string;
        }

        public String getBeforeIndex(int n, int n2) {
            String string = "";
            int n3 = -1;
            int n4 = -1;
            switch (n) {
                case 1: {
                    string = String.valueOf(JLabel.this.text.charAt(n2 - 1));
                    break;
                }
                case 2: {
                    n4 = JLabel.this.text.lastIndexOf(32, n2);
                    if (n4 == -1) {
                        n4 = 0;
                    }
                    n3 = JLabel.this.text.lastIndexOf(32, n4 - 1);
                    string = JLabel.this.text.substring(n3 + 1, n4);
                    break;
                }
                default: {
                    n4 = JLabel.this.text.lastIndexOf(46, n2);
                    if (n4 == -1) {
                        n4 = 0;
                    }
                    n3 = JLabel.this.text.lastIndexOf(46, n4 - 1);
                    string = JLabel.this.text.substring(n3 + 1, n4);
                }
            }
            return string;
        }

        public int getCaretPosition() {
            return -1;
        }

        public int getCharCount() {
            return JLabel.this.text.length();
        }

        public Rectangle getCharacterBounds(int n) {
            return new Rectangle();
        }

        public int getIndexAtPoint(Point point) {
            return 0;
        }

        protected AccessibleJLabel() {
        }
    }
}

