/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Container;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleHyperlink;
import javax.accessibility.AccessibleHypertext;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.WrappedPlainView;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JEditorPane
extends JTextComponent {
    private static final long serialVersionUID = 3140472492599046285L;
    static HashMap registerMap;
    private URL page;
    private EditorKit editorKit;
    boolean focus_root;
    HashMap editorMap;
    static /* synthetic */ Class class$javax$swing$event$HyperlinkListener;
    private static final /* synthetic */ boolean assert;

    void init() {
        this.editorMap = new HashMap();
        registerMap = new HashMap();
        JEditorPane.registerEditorKitForContentType("application/rtf", "javax.swing.text.rtf.RTFEditorKit");
        JEditorPane.registerEditorKitForContentType("text/plain", "javax.swing.JEditorPane$PlainEditorKit");
        JEditorPane.registerEditorKitForContentType("text/html", "javax.swing.text.html.HTMLEditorKit");
        JEditorPane.registerEditorKitForContentType("text/rtf", "javax.swing.text.rtf.RTFEditorKit");
    }

    protected EditorKit createDefaultEditorKit() {
        return new PlainEditorKit();
    }

    public static EditorKit createEditorKitForContentType(String string) {
        EditorKit editorKit = null;
        String string2 = (String)registerMap.get(string);
        if (string2 != null) {
            try {
                editorKit = (EditorKit)Class.forName(string2).newInstance();
            }
            catch (Exception exception) {}
        }
        return editorKit;
    }

    public void fireHyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        HyperlinkListener[] hyperlinkListenerArray = this.getHyperlinkListeners();
        int n = 0;
        while (n < hyperlinkListenerArray.length) {
            hyperlinkListenerArray[n].hyperlinkUpdate(hyperlinkEvent);
            ++n;
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = this.getEditorKit() instanceof HTMLEditorKit ? new AccessibleJEditorPaneHTML() : new AccessibleJEditorPane();
        }
        return this.accessibleContext;
    }

    public final String getContentType() {
        return this.getEditorKit().getContentType();
    }

    public EditorKit getEditorKit() {
        if (this.editorKit == null) {
            this.setEditorKit(this.createDefaultEditorKit());
        }
        return this.editorKit;
    }

    public static String getEditorKitClassNameForContentType(String string) {
        return (String)registerMap.get(string);
    }

    public EditorKit getEditorKitForContentType(String string) {
        EditorKit editorKit = (EditorKit)this.editorMap.get(string);
        if (editorKit == null) {
            editorKit = JEditorPane.createEditorKitForContentType(string);
        }
        if (editorKit == null) {
            editorKit = new PlainEditorKit();
        }
        return editorKit;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.getScrollableTracksViewportWidth()) {
            dimension.width = this.getUI().getMinimumSize((JComponent)this).width;
        }
        if (this.getScrollableTracksViewportHeight()) {
            dimension.height = this.getUI().getMinimumSize((JComponent)this).height;
        }
        return dimension;
    }

    public boolean getScrollableTracksViewportHeight() {
        Container container = this.getParent();
        boolean bl = false;
        if (container instanceof JViewport && container.getHeight() > this.getUI().getMinimumSize((JComponent)this).height) {
            bl = true;
        }
        return bl;
    }

    public boolean getScrollableTracksViewportWidth() {
        Container container = this.getParent();
        boolean bl = false;
        if (container != null && container instanceof JViewport && container.getWidth() > this.getUI().getMinimumSize((JComponent)this).width) {
            bl = true;
        }
        return bl;
    }

    public URL getPage() {
        return this.page;
    }

    protected InputStream getStream(URL uRL) throws IOException {
        return uRL.openStream();
    }

    public String getText() {
        return super.getText();
    }

    public String getUIClassID() {
        return "EditorPaneUI";
    }

    public boolean isFocusCycleRoot() {
        return this.focus_root;
    }

    protected String paramString() {
        return "JEditorPane";
    }

    public void read(InputStream inputStream, Object object) throws IOException {
        EditorKit editorKit = this.getEditorKit();
        if (editorKit instanceof HTMLEditorKit && object instanceof HTMLDocument) {
            Document document = (Document)object;
            try {
                editorKit.read(inputStream, document, 0);
            }
            catch (BadLocationException badLocationException) {
                if (!assert) {
                    throw new AssertionError((Object)"BadLocationException must not be thrown here.");
                }
            }
        } else {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            super.read(inputStreamReader, object);
        }
    }

    public static void registerEditorKitForContentType(String string, String string2) {
        registerMap.put(string, string2);
    }

    public static void registerEditorKitForContentType(String string, String string2, ClassLoader classLoader) {
    }

    public void replaceSelection(String string) {
        super.replaceSelection(string);
    }

    public void scrollToReference(String string) {
    }

    public final void setContentType(String string) {
        if (this.editorKit != null && this.editorKit.getContentType().equals(string)) {
            return;
        }
        EditorKit editorKit = this.getEditorKitForContentType(string);
        if (editorKit != null) {
            this.setEditorKit(editorKit);
        }
    }

    public void setEditorKit(EditorKit editorKit) {
        if (this.editorKit == editorKit) {
            return;
        }
        if (this.editorKit != null) {
            this.editorKit.deinstall(this);
        }
        EditorKit editorKit2 = this.editorKit;
        this.editorKit = editorKit;
        if (this.editorKit != null) {
            this.editorKit.install(this);
            this.setDocument(this.editorKit.createDefaultDocument());
        }
        this.firePropertyChange("editorKit", editorKit2, editorKit);
        this.invalidate();
        this.repaint();
        this.accessibleContext = null;
    }

    public void setEditorKitForContentType(String string, EditorKit editorKit) {
        this.editorMap.put(string, editorKit);
    }

    public void setPage(String string) throws IOException {
        this.setPage(new URL(string));
    }

    public void setPage(URL uRL) throws IOException {
        if (uRL == null) {
            throw new IOException("invalid url");
        }
        try {
            this.page = uRL;
            this.getEditorKit().read(uRL.openStream(), this.getDocument(), 0);
        }
        catch (BadLocationException badLocationException) {}
    }

    public void setText(String string) {
        try {
            Document document = this.getDocument();
            document.remove(0, document.getLength());
            if (string == null || string.equals("")) {
                return;
            }
            this.getEditorKit().read(new StringReader(string), document, 0);
        }
        catch (BadLocationException badLocationException) {
        }
        catch (IOException iOException) {}
    }

    public void addHyperlinkListener(HyperlinkListener hyperlinkListener) {
        Class clazz = class$javax$swing$event$HyperlinkListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$HyperlinkListener = JEditorPane.class("[Ljavax.swing.event.HyperlinkListener;", false);
        }
        this.listenerList.add(clazz, hyperlinkListener);
    }

    public void removeHyperlinkListener(HyperlinkListener hyperlinkListener) {
        Class clazz = class$javax$swing$event$HyperlinkListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$HyperlinkListener = JEditorPane.class("[Ljavax.swing.event.HyperlinkListener;", false);
        }
        this.listenerList.remove(clazz, hyperlinkListener);
    }

    public HyperlinkListener[] getHyperlinkListeners() {
        Class clazz = class$javax$swing$event$HyperlinkListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$HyperlinkListener = JEditorPane.class("[Ljavax.swing.event.HyperlinkListener;", false);
        }
        return (HyperlinkListener[])this.getListeners(clazz);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public JEditorPane() {
        this.init();
        this.setEditorKit(this.createDefaultEditorKit());
    }

    public JEditorPane(String string) throws IOException {
        this(new URL(string));
    }

    public JEditorPane(String string, String string2) {
        this.init();
        this.setEditorKit(JEditorPane.createEditorKitForContentType(string));
        this.setText(string2);
    }

    public JEditorPane(URL uRL) throws IOException {
        this.init();
        this.setEditorKit(JEditorPane.createEditorKitForContentType("text/html"));
        this.setPage(uRL);
    }

    static {
        assert = Class.forName("[Ljavax.swing.JEditorPane;").getComponentType().desiredAssertionStatus() ^ true;
    }

    private static class PlainEditorKit
    extends DefaultEditorKit {
        public ViewFactory getViewFactory() {
            return new ViewFactory(){

                public final View create(Element element) {
                    return new WrappedPlainView(element);
                }
            };
        }

        private PlainEditorKit() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class AccessibleJEditorPaneHTML
    extends AccessibleJEditorPane {
        public AccessibleText getAccessibleText() {
            return new JEditorPaneAccessibleHypertextSupport();
        }

        protected AccessibleJEditorPaneHTML() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class AccessibleJEditorPane
    extends JTextComponent.AccessibleJTextComponent {
        public String getAccessibleDescription() {
            String string = super.getAccessibleDescription();
            if (string == null) {
                return JEditorPane.this.getContentType();
            }
            return string;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            return accessibleStateSet;
        }

        protected AccessibleJEditorPane() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class JEditorPaneAccessibleHypertextSupport
    extends AccessibleJEditorPane
    implements AccessibleHypertext {
        public int getLinkCount() {
            HTMLDocument hTMLDocument = (HTMLDocument)JEditorPane.this.getDocument();
            HTMLDocument.Iterator iterator = hTMLDocument.getIterator(HTML.Tag.A);
            int n = 0;
            while (iterator.isValid()) {
                ++n;
                iterator.next();
            }
            return n;
        }

        public AccessibleHyperlink getLink(int n) {
            HTMLDocument hTMLDocument = (HTMLDocument)JEditorPane.this.getDocument();
            HTMLDocument.Iterator iterator = hTMLDocument.getIterator(HTML.Tag.A);
            int n2 = 0;
            while (iterator.isValid()) {
                if (++n2 == n) break;
                iterator.next();
            }
            if (iterator.isValid()) {
                int n3 = iterator.getStartOffset();
                Element element = hTMLDocument.getCharacterElement(n3);
                HTMLLink hTMLLink = new HTMLLink(element);
                return hTMLLink;
            }
            return null;
        }

        public int getLinkIndex(int n) {
            HTMLDocument hTMLDocument = (HTMLDocument)JEditorPane.this.getDocument();
            HTMLDocument.Iterator iterator = hTMLDocument.getIterator(HTML.Tag.A);
            int n2 = 0;
            while (iterator.isValid()) {
                if (iterator.getStartOffset() <= n && iterator.getEndOffset() > n) break;
                ++n2;
                iterator.next();
            }
            if (iterator.isValid()) {
                return n2;
            }
            return -1;
        }

        public String getLinkText(int n) {
            HTMLDocument hTMLDocument = (HTMLDocument)JEditorPane.this.getDocument();
            HTMLDocument.Iterator iterator = hTMLDocument.getIterator(HTML.Tag.A);
            int n2 = 0;
            while (iterator.isValid()) {
                if (++n2 == n) break;
                iterator.next();
            }
            if (iterator.isValid()) {
                int n3 = iterator.getStartOffset();
                Element element = hTMLDocument.getCharacterElement(n3);
                try {
                    String string = hTMLDocument.getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset());
                    return string;
                }
                catch (BadLocationException badLocationException) {
                    throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"BadLocationException must not be thrown here."))).initCause(badLocationException));
                }
            }
            return null;
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        public class HTMLLink
        extends AccessibleHyperlink {
            Element element;

            public boolean isValid() {
                HTMLDocument hTMLDocument = (HTMLDocument)JEditorPane.this.getDocument();
                boolean bl = false;
                if (hTMLDocument.getCharacterElement(this.element.getStartOffset()) == this.element) {
                    bl = true;
                }
                return bl;
            }

            public int getAccessibleActionCount() {
                return 1;
            }

            public boolean doAccessibleAction(int n) {
                String string = (String)this.element.getAttributes().getAttribute("href");
                HTMLDocument hTMLDocument = (HTMLDocument)JEditorPane.this.getDocument();
                try {
                    URL uRL = new URL(hTMLDocument.getBase(), string);
                    JEditorPane.this.setPage(uRL);
                    String string2 = hTMLDocument.getText(this.element.getStartOffset(), this.element.getEndOffset() - this.element.getStartOffset());
                    HyperlinkEvent hyperlinkEvent = new HyperlinkEvent(JEditorPane.this, HyperlinkEvent.EventType.ACTIVATED, uRL, string2, this.element);
                    JEditorPane.this.fireHyperlinkUpdate(hyperlinkEvent);
                    return true;
                }
                catch (Exception exception) {
                    return false;
                }
            }

            public String getAccessibleActionDescription(int n) {
                HTMLDocument hTMLDocument = (HTMLDocument)JEditorPane.this.getDocument();
                try {
                    return hTMLDocument.getText(this.element.getStartOffset(), this.element.getEndOffset() - this.element.getStartOffset());
                }
                catch (BadLocationException badLocationException) {
                    throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"BadLocationException must not be thrown here."))).initCause(badLocationException));
                }
            }

            public Object getAccessibleActionObject(int n) {
                String string = (String)this.element.getAttributes().getAttribute("href");
                HTMLDocument hTMLDocument = (HTMLDocument)JEditorPane.this.getDocument();
                try {
                    URL uRL = new URL(hTMLDocument.getBase(), string);
                    return uRL;
                }
                catch (MalformedURLException malformedURLException) {
                    return null;
                }
            }

            public Object getAccessibleActionAnchor(int n) {
                return this.getAccessibleActionDescription(n);
            }

            public int getStartIndex() {
                return this.element.getStartOffset();
            }

            public int getEndIndex() {
                return this.element.getEndOffset();
            }

            public HTMLLink(Element element) {
                this.element = element;
            }
        }
    }
}

