/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.editor.client.adapters;

import com.google.gwt.editor.client.CompositeEditor;
import com.google.gwt.editor.client.Editor;
import com.google.gwt.editor.client.EditorDelegate;
import com.google.gwt.editor.client.LeafValueEditor;

public class OptionalFieldEditor<T, E extends Editor<? super T>>
implements CompositeEditor<T, T, E>,
LeafValueEditor<T> {
    private CompositeEditor.EditorChain<T, E> chain;
    private T currentValue;
    private final E subEditor;

    public static <T, E extends Editor<? super T>> OptionalFieldEditor<T, E> of(E subEditor) {
        return new OptionalFieldEditor<T, E>(subEditor);
    }

    protected OptionalFieldEditor(E subEditor) {
        this.subEditor = subEditor;
    }

    @Override
    public E createEditorForTraversal() {
        return this.subEditor;
    }

    @Override
    public void flush() {
        this.currentValue = this.chain.getValue(this.subEditor);
    }

    @Override
    public String getPathElement(E subEditor) {
        return "";
    }

    @Override
    public T getValue() {
        return this.currentValue;
    }

    @Override
    public void onPropertyChange(String ... paths) {
    }

    @Override
    public void setDelegate(EditorDelegate<T> delegate) {
    }

    @Override
    public void setEditorChain(CompositeEditor.EditorChain<T, E> chain) {
        this.chain = chain;
    }

    @Override
    public void setValue(T value) {
        if (this.currentValue != null && value == null) {
            this.chain.detach(this.subEditor);
        }
        this.currentValue = value;
        if (value != null) {
            this.chain.attach(value, this.subEditor);
        }
    }
}

