/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.gss;

import com.google.gwt.resources.gss.ast.CssRuntimeConditionalRuleNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssAtRuleNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssBooleanExpressionNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssCompilerPass;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssConditionalBlockNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssConditionalRuleNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssTreeVisitor;
import com.google.gwt.thirdparty.common.css.compiler.ast.MutatingVisitController;
import com.google.gwt.thirdparty.common.css.compiler.passes.BooleanExpressionEvaluator;
import com.google.gwt.thirdparty.common.css.compiler.passes.EliminateConditionalNodes;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class ExtendedEliminateConditionalNodes
extends EliminateConditionalNodes
implements CssCompilerPass {
    private final MutatingVisitController visitController;
    private final Set<String> trueConditions;
    private final Set<CssConditionalBlockNode> runtimeConditionalNodes;
    private final Set<CssConditionalBlockNode> alreadyTreatedNode = new HashSet<CssConditionalBlockNode>();

    public ExtendedEliminateConditionalNodes(MutatingVisitController visitController, Set<String> trueConditions, Set<CssConditionalBlockNode> runtimeConditionalNodes) {
        super(visitController, trueConditions);
        this.visitController = visitController;
        this.trueConditions = trueConditions;
        this.runtimeConditionalNodes = runtimeConditionalNodes;
    }

    public boolean enterConditionalBlock(CssConditionalBlockNode block) {
        if (this.alreadyTreatedNode.contains(block)) {
            return true;
        }
        if (this.runtimeConditionalNodes.contains(block)) {
            return this.enterRuntimeConditionalBlock(block);
        }
        return super.enterConditionalBlock(block);
    }

    private boolean enterRuntimeConditionalBlock(CssConditionalBlockNode block) {
        boolean runtimeEvaluationNodeFound = false;
        ArrayList<CssConditionalRuleNode> newChildren = new ArrayList<CssConditionalRuleNode>(block.numChildren());
        for (CssConditionalRuleNode currentConditional : block.childIterable()) {
            if (currentConditional.getType() == CssAtRuleNode.Type.ELSE) {
                newChildren.add(currentConditional);
                break;
            }
            if (currentConditional instanceof CssRuntimeConditionalRuleNode) {
                runtimeEvaluationNodeFound = true;
                newChildren.add(currentConditional);
                continue;
            }
            BooleanExpressionEvaluator evaluator = new BooleanExpressionEvaluator(currentConditional.getCondition(), this.trueConditions);
            CssBooleanExpressionNode result = evaluator.evaluate();
            boolean isTrue = "TRUE".equals(result.getValue());
            if (!isTrue) continue;
            if (!runtimeEvaluationNodeFound) {
                this.visitController.replaceCurrentBlockChildWith(currentConditional.getBlock().getChildren(), true);
                return true;
            }
            CssConditionalRuleNode newNode = new CssConditionalRuleNode(CssAtRuleNode.Type.ELSE, currentConditional.getName(), null, currentConditional.getBlock());
            newChildren.add(newNode);
            break;
        }
        CssConditionalBlockNode newNode = new CssConditionalBlockNode();
        for (CssConditionalRuleNode child : newChildren) {
            newNode.addChildToBack((CssNode)child);
        }
        this.visitController.replaceCurrentBlockChildWith(Lists.newArrayList(newNode), true);
        this.alreadyTreatedNode.add(newNode);
        return true;
    }

    public void runPass() {
        this.alreadyTreatedNode.clear();
        this.visitController.startVisit((CssTreeVisitor)this);
    }
}

