/*
 * Decompiled with CFR 0.152.
 */
package free.jin;

import free.jin.ConnectionManager;
import free.jin.I18n;
import free.jin.JinContext;
import free.jin.Preferences;
import free.jin.Resource;
import free.jin.Server;
import free.jin.User;
import free.jin.action.ActionInfo;
import free.jin.plugin.Plugin;
import free.jin.plugin.PluginInfo;
import free.jin.ui.MdiUiProvider;
import free.jin.ui.OptionPanel;
import free.jin.ui.SdiUiProvider;
import free.jin.ui.UIProvider;
import free.util.IOUtilities;
import free.util.Pair;
import free.util.PlatformUtils;
import free.util.TextUtilities;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.swing.DefaultListModel;
import javax.swing.JOptionPane;
import javax.swing.ListModel;
import javax.swing.UIManager;

public class Jin {
    private static volatile Jin instance = null;
    private final JinContext context;
    private final Properties appProps;
    private final Map resourceCache = new HashMap();
    private final DefaultListModel users;
    private final UIProvider uiProvider;
    private final ConnectionManager connManager;

    private Jin(JinContext jinContext) {
        this.context = jinContext;
        try {
            this.appProps = IOUtilities.loadPropertiesAndClose(Jin.class.getResourceAsStream("resources/app.props"));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new IllegalStateException("Unable to load application properties from resources/app.props");
        }
        this.users = new DefaultListModel();
        User[] userArray = jinContext.getUsers();
        for (int i = 0; i < userArray.length; ++i) {
            this.users.addElement(userArray[i]);
        }
        this.restoreLookAndFeel();
        Jin.fixSwing();
        this.uiProvider = this.createUiProvider();
        this.connManager = new ConnectionManager();
    }

    public static synchronized void createInstance(JinContext jinContext) {
        if (instance != null) {
            throw new IllegalStateException("Jin instance already exists");
        }
        instance = new Jin(jinContext);
    }

    public static synchronized Jin getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Jin instance doesn't yet exist");
        }
        return instance;
    }

    public void start() {
        this.uiProvider.start();
    }

    private void restoreLookAndFeel() {
        block5: {
            String string = UIManager.getSystemLookAndFeelClassName();
            if ("com.sun.java.swing.plaf.gtk.GTKLookAndFeel".equals(string)) {
                string = UIManager.getCrossPlatformLookAndFeelClassName();
            }
            String string2 = this.getPrefs().getString("lookAndFeel.classname", null);
            try {
                if (string2 != null) {
                    UIManager.setLookAndFeel(string2);
                } else {
                    UIManager.setLookAndFeel(string);
                }
            }
            catch (Exception exception) {
                if (string2 == null) break block5;
                JOptionPane.showMessageDialog(null, "Unable to use the specified look and feel: \n" + TextUtilities.breakIntoLines(exception.getMessage(), 60), "Jin Error", 0);
            }
        }
        this.getPrefs().setString("lookAndFeel.classname", UIManager.getLookAndFeel().getClass().getName());
    }

    private static void fixSwing() {
        try {
            Class.forName("free.workarounds.SwingFix");
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
    }

    private UIProvider createUiProvider() {
        String string = PlatformUtils.isMacOS() ? SdiUiProvider.class.getName() : MdiUiProvider.class.getName();
        string = this.getPrefs().getString("uiProvider.classname", string);
        this.getPrefs().setString("uiProvider.classname", string);
        try {
            return (UIProvider)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IllegalStateException("Unable to instantiate UIProvider");
        }
    }

    public String getAppName() {
        return this.appProps.getProperty("app.name");
    }

    public String getAppVersion() {
        return this.appProps.getProperty("app.version");
    }

    public String getAppProperty(String string, String string2) {
        return this.appProps.getProperty(string, string2);
    }

    public String getParameter(String string) {
        return this.context.getParameter(string);
    }

    public Preferences getPrefs() {
        return this.context.getPrefs();
    }

    public Locale getLocale() {
        return this.context.getLocale();
    }

    public Server[] getServers() {
        return (Server[])this.context.getServers().clone();
    }

    public ActionInfo[] getActions(Server server) {
        return (ActionInfo[])this.context.getActions(server).clone();
    }

    public PluginInfo[] getPlugins(Server server) {
        return (PluginInfo[])this.context.getPlugins(server).clone();
    }

    public Map getResources(String string, Plugin plugin) {
        Map map;
        Pair pair = new Pair(string, plugin);
        Pair pair2 = (Pair)this.resourceCache.get(pair);
        if (pair2 == null || !((Boolean)pair2.getSecond()).booleanValue()) {
            map = this.context.getResources(string, plugin);
            if (map == null) {
                return null;
            }
            this.resourceCache.put(pair, new Pair(map, Boolean.TRUE));
        } else {
            map = (Map)pair2.getFirst();
        }
        return Collections.unmodifiableMap(map);
    }

    public Resource getResource(String string, String string2, Plugin plugin) {
        Resource resource;
        Pair pair = new Pair(string, plugin);
        Pair pair2 = (Pair)this.resourceCache.get(pair);
        if (pair2 == null || (resource = (Resource)((Map)pair2.getFirst()).get(string2)) == null) {
            resource = this.context.getResource(string, string2, plugin);
        }
        if (pair2 == null) {
            HashMap<String, Resource> hashMap = new HashMap<String, Resource>();
            hashMap.put(string2, resource);
            this.resourceCache.put(pair, new Pair(hashMap, Boolean.FALSE));
        } else {
            Map map = (Map)pair2.getFirst();
            map.put(string2, resource);
        }
        return resource;
    }

    public ListModel getUsers() {
        return this.users;
    }

    public void addUser(User user) {
        if (user == null) {
            throw new IllegalArgumentException("user may not be null");
        }
        if (user.isGuest()) {
            throw new IllegalArgumentException("user may not be a guest");
        }
        this.users.addElement(user);
    }

    public void removeUser(User user) {
        if (user == null) {
            throw new IllegalArgumentException("user may not be null");
        }
        if (user.isGuest()) {
            throw new IllegalArgumentException("user may not be a guest");
        }
        this.users.removeElement(user);
    }

    public boolean isKnownUser(User user) {
        for (int i = 0; i < this.users.getSize(); ++i) {
            if (!this.users.getElementAt(i).equals(user)) continue;
            return true;
        }
        return false;
    }

    public UIProvider getUIProvider() {
        return this.uiProvider;
    }

    public ConnectionManager getConnManager() {
        return this.connManager;
    }

    public Server getServerById(String string) {
        Server[] serverArray = this.context.getServers();
        for (int i = 0; i < serverArray.length; ++i) {
            if (!serverArray[i].getId().equals(string)) continue;
            return serverArray[i];
        }
        return null;
    }

    public List getUsers(Server server) {
        LinkedList<User> linkedList = new LinkedList<User>();
        for (int i = 0; i < this.users.getSize(); ++i) {
            User user = (User)this.users.getElementAt(i);
            if (user.getServer() != server) continue;
            linkedList.add(user);
        }
        return linkedList;
    }

    public User getUser(Server server, String string) {
        for (int i = 0; i < this.users.getSize(); ++i) {
            User user = (User)this.users.getElementAt(i);
            if (user.getServer() != server || !server.getUsernamePolicy().isSame(string, user.getUsername())) continue;
            return user;
        }
        return null;
    }

    public boolean isSavePrefsCapable() {
        return this.context.isSavePrefsCapable();
    }

    public String getPasswordSaveWarning() {
        return this.context.getPasswordSaveWarning();
    }

    public boolean isUserExtensible() {
        return this.context.isUserExtensible();
    }

    public void quitIfNoUiVisible() {
        if (!this.getUIProvider().isUiVisible()) {
            this.quit(false);
        }
    }

    public void quit(boolean bl) {
        Object object;
        I18n i18n = I18n.get(Jin.class);
        Object object2 = object = bl ? i18n.confirm(OptionPanel.OK, "quitConfirmationDialog") : OptionPanel.OK;
        if (object == OptionPanel.OK) {
            this.connManager.closeSession();
            this.uiProvider.stop();
            Object[] objectArray = new User[this.users.size()];
            this.users.copyInto(objectArray);
            this.context.setUsers((User[])objectArray);
            this.context.shutdown();
            instance = null;
        }
    }
}

