/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.util;

import java.util.Timer;
import java.util.TimerTask;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;

public abstract class ExpirableObject
implements Destroyable {
    public static final long DEFAULT_TIMEOUT = 3600000L;
    private static final Timer EXPIRER = new Timer(true);
    private final Destroyer destroyer = new Destroyer(this);

    public final void destroy() throws DestroyFailedException {
        this.doDestroy();
        this.destroyer.cancel();
    }

    protected abstract void doDestroy() throws DestroyFailedException;

    protected ExpirableObject() {
        this(3600000L);
    }

    protected ExpirableObject(long l) {
        EXPIRER.schedule((TimerTask)this.destroyer, l);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private final class Destroyer
    extends TimerTask {
        private final ExpirableObject target;

        public final void run() {
            try {
                if (!this.target.isDestroyed()) {
                    this.target.doDestroy();
                }
            }
            catch (DestroyFailedException destroyFailedException) {}
        }

        Destroyer(ExpirableObject expirableObject2) {
            this.target = expirableObject2;
        }
    }
}

