/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.key.srp6;

import gnu.java.security.util.Util;
import gnu.javax.crypto.key.IncomingMessage;
import gnu.javax.crypto.key.KeyAgreementException;
import gnu.javax.crypto.key.OutgoingMessage;
import gnu.javax.crypto.key.srp6.SRP6KeyAgreement;
import gnu.javax.crypto.key.srp6.SRPKeyPairGenerator;
import gnu.javax.crypto.key.srp6.SRPPrivateKey;
import gnu.javax.crypto.key.srp6.SRPPublicKey;
import gnu.javax.crypto.sasl.srp.SRP;
import gnu.javax.crypto.sasl.srp.SRPAuthInfoProvider;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;

public class SRP6TLSServer
extends SRP6KeyAgreement {
    private KeyPair hostKeyPair;
    private SRPAuthInfoProvider passwordDB;

    protected void engineInit(Map map) throws KeyAgreementException {
        this.rnd = (SecureRandom)map.get("gnu.crypto.srp6.ka.prng");
        String string = (String)map.get("gnu.crypto.srp6.ka.H");
        if (string == null || "".equals(string.trim())) {
            throw new KeyAgreementException("missing hash function");
        }
        this.srp = SRP.instance(string);
        this.passwordDB = (SRPAuthInfoProvider)map.get("gnu.crypto.srp6.ka.password.db");
        if (this.passwordDB == null) {
            throw new KeyAgreementException("missing SRP password database");
        }
    }

    protected OutgoingMessage engineProcessMessage(IncomingMessage incomingMessage) throws KeyAgreementException {
        switch (this.step) {
            case 0: {
                return this.sendParameters(incomingMessage);
            }
            case 1: {
                return this.computeSharedSecret(incomingMessage);
            }
        }
        throw new IllegalStateException("unexpected state");
    }

    protected void engineReset() {
        this.hostKeyPair = null;
        super.engineReset();
    }

    private final OutgoingMessage sendParameters(IncomingMessage incomingMessage) throws KeyAgreementException {
        Map map;
        Object object;
        Map map2;
        Serializable serializable;
        String string = incomingMessage.readString();
        try {
            serializable = new HashMap();
            serializable.put("gnu.crypto.sasl.username", string);
            serializable.put("srp.md.name", this.srp.getAlgorithm());
            map2 = this.passwordDB.lookup((Map)((Object)serializable));
        }
        catch (IOException iOException) {
            throw new KeyAgreementException("computeSharedSecret()", iOException);
        }
        serializable = new BigInteger(1, Util.fromBase64((String)map2.get("srp.salt")));
        BigInteger bigInteger = new BigInteger(1, Util.fromBase64((String)map2.get("srp.user.verifier")));
        try {
            object = (String)map2.get("srp.config.ndx");
            map = this.passwordDB.getConfiguration((String)object);
        }
        catch (IOException iOException) {
            throw new KeyAgreementException("computeSharedSecret()", iOException);
        }
        this.N = new BigInteger(1, Util.fromBase64((String)map.get("srp.N")));
        this.g = new BigInteger(1, Util.fromBase64((String)map.get("srp.g")));
        object = new SRPKeyPairGenerator();
        HashMap hashMap = new HashMap();
        if (this.rnd != null) {
            hashMap.put("gnu.crypto.srp.prng", this.rnd);
        }
        hashMap.put("gnu.crypto.srp.N", this.N);
        hashMap.put("gnu.crypto.srp.g", this.g);
        hashMap.put("gnu.crypto.srp.v", bigInteger);
        ((SRPKeyPairGenerator)object).setup(hashMap);
        this.hostKeyPair = ((SRPKeyPairGenerator)object).generate();
        BigInteger bigInteger2 = ((SRPPublicKey)this.hostKeyPair.getPublic()).getY();
        OutgoingMessage outgoingMessage = new OutgoingMessage();
        outgoingMessage.writeMPI(this.N);
        outgoingMessage.writeMPI(this.g);
        outgoingMessage.writeMPI((BigInteger)serializable);
        outgoingMessage.writeMPI(bigInteger2);
        return outgoingMessage;
    }

    protected OutgoingMessage computeSharedSecret(IncomingMessage incomingMessage) throws KeyAgreementException {
        BigInteger bigInteger;
        BigInteger bigInteger2 = incomingMessage.readMPI();
        BigInteger bigInteger3 = ((SRPPublicKey)this.hostKeyPair.getPublic()).getY();
        BigInteger bigInteger4 = this.uValue(bigInteger2, bigInteger3);
        BigInteger bigInteger5 = ((SRPPrivateKey)this.hostKeyPair.getPrivate()).getX();
        BigInteger bigInteger6 = ((SRPPrivateKey)this.hostKeyPair.getPrivate()).getV();
        this.K = bigInteger = bigInteger2.multiply(bigInteger6.modPow(bigInteger4, this.N)).modPow(bigInteger5, this.N);
        this.complete = true;
        return null;
    }
}

