/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.pipeline;

import gnu.xml.pipeline.EventConsumer;
import gnu.xml.pipeline.EventFilter;
import gnu.xml.pipeline.TeeConsumer;
import gnu.xml.pipeline.TextConsumer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.StringTokenizer;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public class PipelineFactory {
    private static final String[][] builtinStages = new String[][]{{"dom", "gnu.xml.dom.Consumer"}, {"nsfix", "gnu.xml.pipeline.NSFilter"}, {"null", "gnu.xml.pipeline.EventFilter"}, {"server", "gnu.xml.pipeline.CallFilter"}, {"tee", "gnu.xml.pipeline.TeeConsumer"}, {"validate", "gnu.xml.pipeline.ValidationConsumer"}, {"wf", "gnu.xml.pipeline.WellFormednessFilter"}, {"xinclude", "gnu.xml.pipeline.XIncludeFilter"}, {"xslt", "gnu.xml.pipeline.XsltFilter"}};
    private String[] tokens;
    private int index;

    public static EventConsumer createPipeline(String string) throws IOException {
        return PipelineFactory.createPipeline(string, null);
    }

    public static EventConsumer createPipeline(String string, EventConsumer eventConsumer) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        PipelineFactory pipelineFactory = new PipelineFactory();
        Pipeline pipeline = pipelineFactory.parsePipeline(stringArray, eventConsumer);
        return pipeline.createPipeline();
    }

    public static EventConsumer createPipeline(String[] stringArray, EventConsumer eventConsumer) throws IOException {
        PipelineFactory pipelineFactory = new PipelineFactory();
        Pipeline pipeline = pipelineFactory.parsePipeline(stringArray, eventConsumer);
        return pipeline.createPipeline();
    }

    private final Pipeline parsePipeline(String[] stringArray, EventConsumer eventConsumer) {
        this.tokens = stringArray;
        this.index = 0;
        Pipeline pipeline = this.parsePipeline(eventConsumer);
        if (this.index != stringArray.length) {
            throw new ArrayIndexOutOfBoundsException("extra token: " + this.tokens[this.index]);
        }
        return pipeline;
    }

    private final Pipeline parsePipeline(EventConsumer eventConsumer) {
        Pipeline pipeline = new Pipeline(this.parseStage());
        if (this.index > this.tokens.length - 2 || !"|".equals(this.tokens[this.index])) {
            pipeline.next = eventConsumer;
            return pipeline;
        }
        ++this.index;
        pipeline.rest = this.parsePipeline(eventConsumer);
        return pipeline;
    }

    private final Stage parseStage() {
        Stage stage = new Stage(this.tokens[this.index++]);
        if (this.index > this.tokens.length - 2 || !"(".equals(this.tokens[this.index])) {
            return stage;
        }
        ++this.index;
        stage.param = this.parsePipeline(null);
        if (this.index >= this.tokens.length) {
            throw new ArrayIndexOutOfBoundsException("missing right paren");
        }
        if (!")".equals(this.tokens[this.index++])) {
            throw new ArrayIndexOutOfBoundsException("required right paren, not: " + this.tokens[this.index - 1]);
        }
        return stage;
    }

    private PipelineFactory() {
    }

    private static class Pipeline {
        Stage stage;
        Pipeline rest;
        EventConsumer next;

        public String toString() {
            if (this.rest == null && this.next == null) {
                return this.stage.toString();
            }
            if (this.rest != null) {
                return this.stage + " | " + this.rest;
            }
            throw new IllegalArgumentException("next");
        }

        EventConsumer createPipeline() throws IOException {
            if (this.next == null) {
                this.next = this.rest == null ? this.stage.createStage(null) : this.stage.createStage(this.rest.createPipeline());
            }
            return this.next;
        }

        Pipeline(Stage stage) {
            this.stage = stage;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class Stage {
        String id;
        Pipeline param;
        static /* synthetic */ Class class$gnu$xml$pipeline$EventConsumer;
        static /* synthetic */ Class class$java$lang$String;

        public String toString() {
            if (this.param == null) {
                return this.id;
            }
            return this.id + " ( " + this.param + " )";
        }

        private final void fail(String string) throws IOException {
            throw new IOException("in '" + this.id + "' stage of pipeline, " + string);
        }

        EventConsumer createStage(EventConsumer eventConsumer) throws IOException {
            String string = this.id;
            int n = 0;
            while (n < builtinStages.length) {
                if (this.id.equals(builtinStages[n][0])) {
                    string = builtinStages[n][1];
                    break;
                }
                ++n;
            }
            if ("write".equals(string) || "xhtml".equals(string)) {
                String string2;
                boolean bl = "xhtml".equals(string);
                OutputStream outputStream = null;
                if (this.param == null) {
                    this.fail("parameter is required");
                }
                if ("stdout".equals(string2 = this.param.toString())) {
                    outputStream = System.out;
                } else if ("stderr".equals(string2)) {
                    outputStream = System.err;
                } else {
                    File file = new File(string2);
                    if (file.exists()) {
                        this.fail("file already exists: " + file.getName());
                    }
                    outputStream = new FileOutputStream(file);
                }
                TextConsumer textConsumer = !bl ? new TextConsumer(outputStream) : new TextConsumer((Writer)new OutputStreamWriter(outputStream, "8859_1"), true);
                textConsumer.setPrettyPrinting(true);
                if (eventConsumer == null) {
                    return textConsumer;
                }
                return new TeeConsumer(textConsumer, eventConsumer);
            }
            Object object = null;
            try {
                Object object2;
                Class clazz = Class.forName(string);
                Class[] classArray = null;
                Constructor constructor = null;
                boolean bl = false;
                Object[] objectArray = null;
                Object object3 = null;
                if (eventConsumer != null) {
                    if (this.param == null) {
                        classArray = new Class[1];
                        Class clazz2 = class$gnu$xml$pipeline$EventConsumer;
                        if (clazz2 == null) {
                            clazz2 = class$gnu$xml$pipeline$EventConsumer = Stage.class("[Lgnu.xml.pipeline.EventConsumer;", false);
                        }
                        classArray[0] = clazz2;
                        objectArray = new Object[]{eventConsumer};
                        object = "no-param filter";
                    } else {
                        Class clazz3;
                        classArray = new Class[2];
                        Class clazz4 = class$java$lang$String;
                        if (clazz4 == null) {
                            clazz4 = classArray[0] = (class$java$lang$String = Stage.class("[Ljava.lang.String;", false));
                        }
                        if ((clazz3 = class$gnu$xml$pipeline$EventConsumer) == null) {
                            clazz3 = class$gnu$xml$pipeline$EventConsumer = Stage.class("[Lgnu.xml.pipeline.EventConsumer;", false);
                        }
                        classArray[1] = clazz3;
                        objectArray = new Object[]{this.param.toString(), eventConsumer};
                        object = "one-param filter";
                    }
                    try {
                        constructor = clazz.getConstructor(classArray);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        bl = true;
                        object = (String)object + " built from ";
                    }
                }
                if (constructor == null) {
                    if (this.param == null) {
                        classArray = new Class[]{};
                        objectArray = new Object[]{};
                        object2 = "no-param terminus";
                    } else {
                        classArray = new Class[1];
                        Class clazz5 = class$java$lang$String;
                        if (clazz5 == null) {
                            clazz5 = class$java$lang$String = Stage.class("[Ljava.lang.String;", false);
                        }
                        classArray[0] = clazz5;
                        objectArray = new Object[]{this.param.toString()};
                        object2 = "one-param terminus";
                    }
                    object = object == null ? object2 : (String)object + (String)object2;
                    constructor = clazz.getConstructor(classArray);
                }
                if ((object3 = constructor.newInstance(objectArray)) instanceof EventConsumer) {
                    if (bl) {
                        return new TeeConsumer((EventConsumer)object3, eventConsumer);
                    }
                    return (EventConsumer)object3;
                }
                object2 = new EventFilter();
                boolean bl2 = false;
                if (object3 instanceof ContentHandler) {
                    ((EventFilter)object2).setContentHandler((ContentHandler)object3);
                    bl2 = true;
                }
                if (object3 instanceof DTDHandler) {
                    ((EventFilter)object2).setDTDHandler((DTDHandler)object3);
                    bl2 = true;
                }
                if (object3 instanceof LexicalHandler) {
                    ((EventFilter)object2).setProperty("http://xml.org/sax/properties/lexical-handler", object3);
                    bl2 = true;
                }
                if (object3 instanceof DeclHandler) {
                    ((EventFilter)object2).setProperty("http://xml.org/sax/properties/declaration-handler", object3);
                    bl2 = true;
                }
                if (!bl2) {
                    this.fail("class is neither Consumer nor Handler");
                }
                if (bl) {
                    return new TeeConsumer((EventConsumer)object2, eventConsumer);
                }
                return object2;
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.fail(string + " constructor missing -- " + object);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.fail(string + " class not found");
            }
            catch (Exception exception) {
                this.fail("stage not available: " + exception.getMessage());
            }
            return null;
        }

        static /* synthetic */ Class class(String string, boolean bl) {
            try {
                Class clazz = Class.forName(string);
                if (!bl) {
                    clazz = clazz.getComponentType();
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError().initCause(classNotFoundException);
            }
        }

        Stage(String string) {
            this.id = string;
        }
    }
}

