/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteOrder;
import java.nio.LongBuffer;

final class LongBufferImpl
extends LongBuffer {
    private boolean readOnly;

    public final boolean isReadOnly() {
        return this.readOnly;
    }

    public final LongBuffer slice() {
        return new LongBufferImpl(this.backing_buffer, this.array_offset + this.position(), this.remaining(), this.remaining(), 0, -1, this.isReadOnly());
    }

    public final LongBuffer duplicate() {
        return new LongBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, this.isReadOnly());
    }

    public final LongBuffer asReadOnlyBuffer() {
        return new LongBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, true);
    }

    public final LongBuffer compact() {
        this.checkIfReadOnly();
        this.mark = -1;
        int n = 0;
        while (this.remaining() > 0) {
            this.put(n, this.get());
            ++n;
        }
        this.position(n);
        this.limit(this.capacity());
        return this;
    }

    public final boolean isDirect() {
        return false;
    }

    public final long get() {
        this.checkForUnderflow();
        long l = this.backing_buffer[this.position()];
        this.position(this.position() + 1);
        return l;
    }

    public final LongBuffer put(long l) {
        this.checkIfReadOnly();
        this.checkForOverflow();
        this.backing_buffer[this.position()] = l;
        this.position(this.position() + 1);
        return this;
    }

    public final long get(int n) {
        this.checkIndex(n);
        return this.backing_buffer[n];
    }

    public final LongBuffer put(int n, long l) {
        this.checkIfReadOnly();
        this.checkIndex(n);
        this.backing_buffer[n] = l;
        return this;
    }

    public final ByteOrder order() {
        return ByteOrder.nativeOrder();
    }

    LongBufferImpl(int n) {
        this(new long[n], 0, n, n, 0, -1, false);
    }

    LongBufferImpl(long[] lArray, int n, int n2, int n3, int n4, int n5, boolean bl) {
        super(n2, n3, n4, n5);
        this.backing_buffer = lArray;
        this.array_offset = n;
        this.readOnly = bl;
    }
}

