/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels.spi;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.util.LinkedList;
import java.util.ListIterator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class AbstractSelectableChannel
extends SelectableChannel {
    private boolean blocking;
    private Object LOCK;
    private SelectorProvider provider;
    private LinkedList keys;

    public final Object blockingLock() {
        return this.LOCK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final SelectableChannel configureBlocking(boolean bl) throws IOException {
        Object object = this.blockingLock();
        synchronized (object) {
            if (this.blocking != bl) {
                this.implConfigureBlocking(bl);
                this.blocking = bl;
            }
            return this;
        }
    }

    protected final void implCloseChannel() throws IOException {
        this.implCloseSelectableChannel();
    }

    protected abstract void implCloseSelectableChannel() throws IOException;

    protected abstract void implConfigureBlocking(boolean var1) throws IOException;

    public final boolean isBlocking() {
        return this.blocking;
    }

    public final boolean isRegistered() {
        return this.keys.isEmpty() ^ true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final SelectionKey keyFor(Selector selector) {
        if (!this.isOpen()) {
            return null;
        }
        try {
            Object object = this.blockingLock();
            synchronized (object) {
                return this.locate(selector);
            }
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final SelectorProvider provider() {
        return this.provider;
    }

    private final SelectionKey locate(Selector selector) {
        ListIterator listIterator = this.keys.listIterator();
        while (listIterator.hasNext()) {
            SelectionKey selectionKey = (SelectionKey)listIterator.next();
            if (selectionKey.selector() != selector) continue;
            return selectionKey;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final SelectionKey register(Selector selector, int n, Object object) throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if ((n & ~this.validOps()) != 0) {
            throw new IllegalArgumentException();
        }
        SelectionKey selectionKey = null;
        AbstractSelector abstractSelector = (AbstractSelector)selector;
        Object object2 = this.blockingLock();
        synchronized (object2) {
            if (this.blocking) {
                throw new IllegalBlockingModeException();
            }
            selectionKey = this.locate(abstractSelector);
            if (selectionKey != null && selectionKey.isValid()) {
                if (object != null) {
                    selectionKey.attach(object);
                }
            } else {
                selectionKey = abstractSelector.register(this, n, object);
                if (selectionKey != null) {
                    this.addSelectionKey(selectionKey);
                }
            }
            return selectionKey;
        }
    }

    void addSelectionKey(SelectionKey selectionKey) {
        this.keys.add(selectionKey);
    }

    void removeSelectionKey(SelectionKey selectionKey) {
        this.keys.remove(selectionKey);
    }

    private final /* synthetic */ void this() {
        this.blocking = true;
        this.LOCK = new Object();
        this.keys = new LinkedList();
    }

    protected AbstractSelectableChannel(SelectorProvider selectorProvider) {
        this.this();
        this.provider = selectorProvider;
    }
}

