/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.trap;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.parosproxy.paros.common.AbstractParam;

public class TrapParam
extends AbstractParam {
    private static final String TRAP = "trap";
    private static final String INCLUSIVE_FILTER = "trap.inclusiveFilter";
    private static final String EXCLUSIVE_FILTER = "trap.exclusiveFilter";
    private String inclusiveFilter = "";
    private String exclusiveFilter = "";
    private Pattern patternInclusiveFilter = null;
    private Pattern patternExclusiveFilter = null;

    protected void parse() {
        this.setInclusiveFilter(this.getConfig().getString(INCLUSIVE_FILTER, ""));
        this.setExclusiveFilter(this.getConfig().getString(EXCLUSIVE_FILTER, ""));
    }

    private void parseInclusiveFilter(String string) {
        this.patternInclusiveFilter = null;
        if (string == null || string.equals("")) {
            return;
        }
        string = string.replaceAll("\\.", "\\\\.");
        string = string.replaceAll("\\*", ".*?").replaceAll("(;+$)|(^;+)", "");
        string = "(" + string.replaceAll(";+", "|") + ")$";
        this.patternInclusiveFilter = Pattern.compile(string, 2);
    }

    private void parseExclusiveFilter(String string) {
        this.patternExclusiveFilter = null;
        if (string == null || string.equals("")) {
            return;
        }
        string = string.replaceAll("\\.", "\\\\.");
        string = string.replaceAll("\\*", ".*?").replaceAll("(;+$)|(^;+)", "");
        string = "(" + string.replaceAll(";+", "|") + ")$";
        this.patternExclusiveFilter = Pattern.compile(string, 2);
    }

    public String getExclusiveFilter() {
        return this.exclusiveFilter;
    }

    public void setExclusiveFilter(String string) {
        this.exclusiveFilter = string;
        this.parseExclusiveFilter(this.exclusiveFilter);
        this.getConfig().setProperty(EXCLUSIVE_FILTER, this.exclusiveFilter);
    }

    public String getInclusiveFilter() {
        return this.inclusiveFilter;
    }

    public void setInclusiveFilter(String string) {
        this.inclusiveFilter = string;
        this.parseInclusiveFilter(this.inclusiveFilter);
        this.getConfig().setProperty(INCLUSIVE_FILTER, this.inclusiveFilter);
    }

    public boolean isInclude(String string) {
        boolean bl = true;
        Matcher matcher = null;
        if (this.patternInclusiveFilter != null) {
            try {
                matcher = this.patternInclusiveFilter.matcher(string);
                bl = matcher.find();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    public boolean isExclude(String string) {
        boolean bl = false;
        Matcher matcher = null;
        if (this.patternExclusiveFilter != null) {
            try {
                matcher = this.patternExclusiveFilter.matcher(string);
                bl = matcher.find();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }
}

