/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.model;

import java.sql.SQLException;
import java.text.DecimalFormat;
import org.parosproxy.paros.db.RecordHistory;
import org.parosproxy.paros.db.TableHistory;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;

public class HistoryReference {
    public static final int TYPE_TEMPORARY = 0;
    public static final int TYPE_MANUAL = 1;
    public static final int TYPE_SPIDER = 2;
    public static final int TYPE_SCANNER = 3;
    public static final int TYPE_SPIDER_SEED = 4;
    public static final int TYPE_SPIDER_VISITED = 5;
    public static final int TYPE_HIDDEN = 6;
    public static final int TYPE_SPIDER_UNSAVE = -2;
    private static DecimalFormat decimalFormat = new DecimalFormat("##0.###");
    private static TableHistory staticTableHistory = null;
    private int historyId = 0;
    private int historyType = 1;
    private SiteNode siteNode = null;
    private String display = null;
    private long sessionId = 0L;

    public long getSessionId() {
        return this.sessionId;
    }

    public HistoryReference(int n) throws HttpMalformedHeaderException, SQLException {
        RecordHistory recordHistory = null;
        recordHistory = staticTableHistory.read(n);
        HttpMessage httpMessage = recordHistory.getHttpMessage();
        this.build(recordHistory.getSessionId(), recordHistory.getHistoryId(), recordHistory.getHistoryType(), httpMessage);
    }

    public HistoryReference(Session session, int n, HttpMessage httpMessage) throws HttpMalformedHeaderException, SQLException {
        RecordHistory recordHistory = null;
        recordHistory = staticTableHistory.write(session.getSessionId(), n, httpMessage);
        this.build(session.getSessionId(), recordHistory.getHistoryId(), recordHistory.getHistoryType(), httpMessage);
    }

    private void build(long l, int n, int n2, HttpMessage httpMessage) {
        this.sessionId = l;
        this.historyId = n;
        this.historyType = n2;
        if (n2 == 1) {
            this.display = this.getDisplay(httpMessage);
        }
    }

    public static void setTableHistory(TableHistory tableHistory) {
        staticTableHistory = tableHistory;
    }

    public int getHistoryId() {
        return this.historyId;
    }

    public HttpMessage getHttpMessage() throws HttpMalformedHeaderException, SQLException {
        RecordHistory recordHistory = staticTableHistory.read(this.historyId);
        return recordHistory.getHttpMessage();
    }

    public String toString() {
        if (this.display != null) {
            return this.display;
        }
        HttpMessage httpMessage = null;
        try {
            httpMessage = this.getHttpMessage();
            this.display = this.getDisplay(httpMessage);
        }
        catch (HttpMalformedHeaderException httpMalformedHeaderException) {
            this.display = "";
        }
        catch (SQLException sQLException) {
            this.display = "";
        }
        return this.display;
    }

    public int getHistoryType() {
        return this.historyType;
    }

    public void delete() {
        if (this.historyId > 0) {
            try {
                staticTableHistory.delete(this.historyId);
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
    }

    public SiteNode getSiteNode() {
        return this.siteNode;
    }

    public void setSiteNode(SiteNode siteNode) {
        this.siteNode = siteNode;
    }

    private String getDisplay(HttpMessage httpMessage) {
        StringBuffer stringBuffer = new StringBuffer(Integer.toString(this.historyId) + " ");
        stringBuffer.append(httpMessage.getRequestHeader().getPrimeHeader());
        if (!httpMessage.getResponseHeader().isEmpty()) {
            stringBuffer.append(" \t=> " + httpMessage.getResponseHeader().getPrimeHeader());
            String string = "\t [" + decimalFormat.format((double)httpMessage.getTimeElapsedMillis() / 1000.0) + " s]";
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public void setTag(String string) {
        try {
            staticTableHistory.updateTag(this.historyId, string);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }
}

