# -*- encoding: utf-8 -*-

require "erb"
require "optparse"
require "rubygems"

libdir = File.join(File.dirname(__FILE__), "../lib")
$LOAD_PATH << libdir
require "color/rgb/jp"

def with_output_stream(output)
  if output == $stdout or output == "-"
    yield $stdout
  else
    open(output, "w"){|out| yield out }
  end
end


name = nil
output = $stdout
ARGV.options do |opt|
  opt.on("-p=PALLET"){|v| name = v}
  opt.on("-o=OUTPUT"){|v| output = v}
  opt.parse!
end

pallet = Color::RGB::JP.pallets.find{|e| e.name.split(/::/).last == name }
raise "unknown pallet `#{name}'" unless pallet

colors = pallet.colors
with_output_stream(output) do |out|
  out.puts ERB.new(DATA.read, 0, "%<>").result(binding)
end


__END__
% def trad(name)
%   Color::RGB::JP::Trad[name].rgb.html
% end
<html>
<head>
  <title>color-japanese: <%= pallet %></title>
  <meta http-equiv="Content-type" content="text/html; charset=UTF-8" />
  <style type="text/css">
    <!--
      body {
        color: <%= trad("暗黒色") %>;
        background: <%= trad("胡粉色") %>;
      }
      input {
        width: 10em;
      }
      table, th, td {
        border-collapse: collapse;
        border: 1px solid <%= trad("桜鼠") %>
      }
      th, td {
        padding: 4px;
      }
      #search {
        color: <%= trad("藍鉄") %>;
        width: 100%;
      }
      -->
  </style>
  <script type="text/javascript">
    <!--
      var cache = {};
      var colors = {};
<% colors.each_with_index do |c,i| %>
      colors["c<%= i %>"] = ["<%= c.name.const_name.downcase %>", "<%= c.name.kanji %>", "<%= c.name.hiragana %>", "<%= c.name.katakana %>", "<%= c.name.romaji.downcase %>"];
<% end %>

      function lookup(names, q) {
        var queries = q.toLowerCase().split(/\s+/);
        for (var i = 0; i < queries.length; i++) {
          if (!lookup1(names, queries[i])) {
            return false;
          }
        }
        return true;
      }

      function lookup1(names, query) {
        for (var i = 0; i < names.length; i++) {
          if (names[i].indexOf(query) > -1) {
            return true;
          }
        }
        return false;
      }

      function do_search(q) {
        for (var key in colors) {
          var names = colors[key];
          var e = cache[key] = cache[key] || document.getElementById(key);
          if (e != undefined && lookup(names, q)) {
            e.style.display = "";
          } else {
            e.style.display = "none";
          }
        }
      }

      function setup_event() {
        var input = document.getElementById("search");
        input.onfocus = function() {
          if (input.value == "search") {
            input.value = "";
            input.style.color = "black";
          }
        };
        input.onblur = function() {
          if (input.value == "") {
            input.value = "search";
            input.style.color = "<%= trad("藍鉄") %>";
          }
        };

        var form = document.getElementById("search_box");
        form.onsubmit = function() {
          var q = input.value;
          input.style.backgroundColor = "<%= trad("虹色") %>";
          window.setTimeout(function () {
            do_search(q);
            input.style.backgroundColor = "";
            input.focus();
          }, 100);

          return false;
        };
      }
      -->
  </script>

</head>
<body onload="setup_event();">
  <h1><%= pallet %></h1>

  <form id="search_box">
    <input accesskey="a" id="search" value="search"/>
  </form>

  <table style="width: 100%">
    <tr>
      <th style="width: 12%">const</th>
      <th style="width: 12%">color name (kanji/hiragana)</th>
      <th style="width: 12%">color name (romaji)</th>
      <th>RGB</th>
    </tr>
% colors.each_with_index do |c,i|
    <tr id="c<%= i %>">
      <td><%= c.name.const_name %></td>
      <td>
% if c.name.kanji.nil?
        <%= c.name.katakana %>
% else
        <ruby>
        <rb><%= c.name.kanji %></rb><rp>(</rp><rt><%= c.name.hiragana %></rt><rp>)</rp>
        </ruby>
% end
      </td>
      <td><%= c.name.romaji %></td>
      <td style="background: <%= c.rgb.html %>">
        <input onclick="this.select()" value="<%= c.rgb.html %>"/><br>
        <input onclick="this.select()" value="rgb(<%= (c.rgb.r * 255).round %>, <%= (c.rgb.g * 255).round %>, <%= (c.rgb.b * 255).round %>)"/>
      </td>
    </tr>
% end
  </table>
</body>
</html>
