/*
 * Decompiled with CFR 0.152.
 */
package org.sablecc.sablecc;

import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.sablecc.sablecc.Cast;
import org.sablecc.sablecc.NoCast;

public class TypedHashMap
extends HashMap {
    private Cast keyCast;
    private Cast valueCast;
    private Set entries;

    public TypedHashMap() {
        this.keyCast = NoCast.instance;
        this.valueCast = NoCast.instance;
    }

    public TypedHashMap(int initialCapacity, Cast keyCast, Cast valueCast) {
        super(initialCapacity);
        this.keyCast = keyCast;
        this.valueCast = valueCast;
    }

    public TypedHashMap(Map map) {
        this.keyCast = NoCast.instance;
        this.valueCast = NoCast.instance;
        Map.Entry[] entries = map.entrySet().toArray(new Map.Entry[0]);
        for (int i = 0; i < entries.length; ++i) {
            this.put(entries[i].getKey(), entries[i].getValue());
        }
    }

    public TypedHashMap(Cast keyCast, Cast valueCast) {
        this.keyCast = keyCast;
        this.valueCast = valueCast;
    }

    @Override
    public Object clone() {
        return new TypedHashMap(this, this.keyCast, this.valueCast);
    }

    public TypedHashMap(Map map, Cast keyCast, Cast valueCast) {
        this.keyCast = keyCast;
        this.valueCast = valueCast;
        Map.Entry[] entries = map.entrySet().toArray(new Map.Entry[0]);
        for (int i = 0; i < entries.length; ++i) {
            this.put(entries[i].getKey(), entries[i].getValue());
        }
    }

    public Cast getKeyCast() {
        return this.keyCast;
    }

    public Cast getValueCast() {
        return this.valueCast;
    }

    @Override
    public Set entrySet() {
        if (this.entries == null) {
            this.entries = new EntrySet(super.entrySet());
        }
        return this.entries;
    }

    @Override
    public Object put(Object key, Object value) {
        return super.put(this.keyCast.cast(key), this.valueCast.cast(value));
    }

    private class TypedEntry
    implements Map.Entry {
        private Map.Entry entry;

        TypedEntry(Map.Entry entry) {
            this.entry = entry;
        }

        public Object getKey() {
            return this.entry.getKey();
        }

        public Object getValue() {
            return this.entry.getValue();
        }

        public Object setValue(Object value) {
            return this.entry.setValue(TypedHashMap.this.valueCast.cast(value));
        }
    }

    private class EntryIterator
    implements Iterator {
        private Iterator iterator;

        EntryIterator(Iterator iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            return new TypedEntry((Map.Entry)this.iterator.next());
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    private class EntrySet
    extends AbstractSet {
        private Set set;

        EntrySet(Set set) {
            this.set = set;
        }

        @Override
        public int size() {
            return this.set.size();
        }

        @Override
        public Iterator iterator() {
            return new EntryIterator(this.set.iterator());
        }
    }
}

