/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.viewer;

import com.glavsoft.rfb.protocol.ProtocolSettings;
import com.glavsoft.utils.Strings;
import com.glavsoft.viewer.AbstractConnectionWorkerFactory;
import com.glavsoft.viewer.NetworkConnectionWorker;
import com.glavsoft.viewer.RfbConnectionWorker;
import com.glavsoft.viewer.UiSettings;
import com.glavsoft.viewer.mvp.Presenter;
import com.glavsoft.viewer.swing.ConnectionParams;
import com.glavsoft.viewer.swing.WrongParameterException;
import com.glavsoft.viewer.swing.gui.ConnectionView;
import com.glavsoft.viewer.swing.gui.ConnectionsHistory;
import java.net.Socket;
import java.util.logging.Logger;

public class ConnectionPresenter
extends Presenter {
    public static final String PROPERTY_HOST_NAME = "HostName";
    public static final String PROPERTY_RFB_PORT_NUMBER = "PortNumber";
    public static final String PROPERTY_USE_SSH = "UseSsh";
    private static final String PROPERTY_SSH_USER_NAME = "SshUserName";
    private static final String PROPERTY_SSH_HOST_NAME = "SshHostName";
    private static final String PROPERTY_SSH_PORT_NUMBER = "SshPortNumber";
    private static final String PROPERTY_STATUS_BAR_MESSAGE = "Message";
    private static final String PROPERTY_CONNECTION_IN_PROGRESS = "ConnectionInProgress";
    public static final String CONNECTION_PARAMS_MODEL = "ConnectionParamsModel";
    public static final String CONNECTIONS_HISTORY_MODEL = "ConnectionsHistoryModel";
    public static final String CONNECTION_VIEW = "ConnectionView";
    private final boolean hasSshSupport;
    private final boolean allowInteractive;
    private ConnectionsHistory connectionsHistory;
    private ProtocolSettings rfbSettings;
    private UiSettings uiSettings;
    private final Logger logger;
    private RfbConnectionWorker rfbConnectionWorker;
    private AbstractConnectionWorkerFactory connectionWorkerFactory;
    private NetworkConnectionWorker networkConnectionWorker;
    private boolean needReconnection = true;

    public ConnectionPresenter(boolean hasSshSupport, boolean allowInteractive) {
        this.hasSshSupport = hasSshSupport;
        this.allowInteractive = allowInteractive;
        this.logger = Logger.getLogger(this.getClass().getName());
    }

    public void startConnection(ProtocolSettings rfbSettings, UiSettings uiSettings, int paramSettingsMask) throws IllegalStateException {
        this.rfbSettings = rfbSettings;
        this.uiSettings = uiSettings;
        if (!this.isModelRegisteredByName(CONNECTION_PARAMS_MODEL)) {
            throw new IllegalStateException("No Connection Params model added.");
        }
        this.connectionsHistory = new ConnectionsHistory();
        this.addModel(CONNECTIONS_HISTORY_MODEL, this.connectionsHistory);
        this.syncModels(paramSettingsMask);
        if (this.allowInteractive) {
            this.show();
            this.populate();
        } else {
            this.connect();
        }
    }

    public void setUseSsh(boolean useSsh) {
        this.setModelProperty(PROPERTY_USE_SSH, useSsh, Boolean.TYPE);
    }

    public void submitConnection(String hostName) throws WrongParameterException {
        if (Strings.isTrimmedEmpty(hostName)) {
            throw new WrongParameterException("Host name is empty", PROPERTY_HOST_NAME);
        }
        this.setModelProperty(PROPERTY_HOST_NAME, hostName);
        String rfbPort = (String)this.getViewPropertyOrNull(PROPERTY_RFB_PORT_NUMBER);
        this.setModelProperty(PROPERTY_RFB_PORT_NUMBER, rfbPort);
        try {
            this.throwPossiblyHappenedException();
        }
        catch (Throwable e) {
            throw new WrongParameterException("Wrong Port", PROPERTY_HOST_NAME);
        }
        this.setSshOptions();
        this.saveHistory();
        this.populateFrom(CONNECTIONS_HISTORY_MODEL);
        this.connect();
    }

    public void saveHistory() {
        ConnectionParams cp = (ConnectionParams)this.getModel(CONNECTION_PARAMS_MODEL);
        this.connectionsHistory.reorder(cp, this.rfbSettings, this.uiSettings);
        this.connectionsHistory.save();
    }

    private void connect() {
        ConnectionParams connectionParams = (ConnectionParams)this.getModel(CONNECTION_PARAMS_MODEL);
        this.networkConnectionWorker = this.connectionWorkerFactory.createNetworkConnectionWorker();
        this.networkConnectionWorker.setConnectionParams(connectionParams);
        this.networkConnectionWorker.setPresenter(this);
        this.networkConnectionWorker.setHasSshSupport(this.hasSshSupport);
        this.networkConnectionWorker.execute();
    }

    public void connectionFailed() {
        this.cancelConnection();
        if (this.allowInteractive) {
            this.enableConnectionDialog();
        } else {
            this.connect();
        }
    }

    public void connectionCancelled() {
        this.cancelConnection();
        if (this.allowInteractive) {
            this.enableConnectionDialog();
        } else {
            ConnectionView connectionView = (ConnectionView)this.getView(CONNECTION_VIEW);
            if (connectionView != null) {
                connectionView.closeApp();
            }
        }
    }

    private void enableConnectionDialog() {
        this.setViewProperty(PROPERTY_CONNECTION_IN_PROGRESS, false, Boolean.TYPE);
    }

    public void successfulNetworkConnection(Socket workingSocket) {
        this.logger.info("Connected");
        this.showMessage("Connected");
        this.rfbConnectionWorker = this.connectionWorkerFactory.createRfbConnectionWorker();
        this.rfbConnectionWorker.setWorkingSocket(workingSocket);
        this.rfbConnectionWorker.setRfbSettings(this.rfbSettings);
        this.rfbConnectionWorker.setUiSettings(this.uiSettings);
        this.rfbConnectionWorker.setConnectionString(this.getModelProperty(PROPERTY_HOST_NAME) + ":" + this.getModelProperty(PROPERTY_RFB_PORT_NUMBER));
        this.rfbConnectionWorker.execute();
    }

    public void successfulRfbConnection() {
        this.enableConnectionDialog();
        this.getView(CONNECTION_VIEW).closeView();
    }

    public void cancelConnection() {
        if (this.networkConnectionWorker != null) {
            this.networkConnectionWorker.cancel();
        }
        if (this.rfbConnectionWorker != null) {
            this.rfbConnectionWorker.cancel();
        }
    }

    public void showConnectionErrorDialog(String message) {
        ConnectionView connectionView = (ConnectionView)this.getView(CONNECTION_VIEW);
        if (connectionView != null) {
            connectionView.showConnectionErrorDialog(message);
        }
    }

    public void showReconnectDialog(String errorTitle, String errorMessage) {
        ConnectionView connectionView = (ConnectionView)this.getView(CONNECTION_VIEW);
        if (connectionView != null) {
            connectionView.showReconnectDialog(errorTitle, errorMessage);
        }
    }

    private void setSshOptions() {
        if (this.hasSshSupport) {
            try {
                boolean useSsh = (Boolean)this.getViewProperty(PROPERTY_USE_SSH);
                this.setModelProperty(PROPERTY_USE_SSH, useSsh, Boolean.TYPE);
            }
            catch (Presenter.PropertyNotFoundException propertyNotFoundException) {
                // empty catch block
            }
            this.setModelProperty(PROPERTY_SSH_USER_NAME, this.getViewPropertyOrNull(PROPERTY_SSH_USER_NAME));
            this.setModelProperty(PROPERTY_SSH_HOST_NAME, this.getViewPropertyOrNull(PROPERTY_SSH_HOST_NAME));
            this.setModelProperty(PROPERTY_SSH_PORT_NUMBER, this.getViewPropertyOrNull(PROPERTY_SSH_PORT_NUMBER));
            this.setViewProperty(PROPERTY_SSH_PORT_NUMBER, this.getModelProperty(PROPERTY_SSH_PORT_NUMBER));
        }
    }

    private void syncModels(int paramSettingsMask) {
        ConnectionParams cp = (ConnectionParams)this.getModel(CONNECTION_PARAMS_MODEL);
        ConnectionParams mostSuitableConnection = this.connectionsHistory.getMostSuitableConnection(cp);
        cp.completeEmptyFieldsFrom(mostSuitableConnection);
        this.rfbSettings.copyDataFrom(this.connectionsHistory.getProtocolSettings(mostSuitableConnection), paramSettingsMask & 0xFFFF);
        this.uiSettings.copyDataFrom(this.connectionsHistory.getUiSettingsData(mostSuitableConnection), paramSettingsMask >> 16 & 0xFFFF);
        if (!cp.isHostNameEmpty()) {
            this.connectionsHistory.reorder(cp, this.rfbSettings, this.uiSettings);
        }
    }

    public void populateFromHistoryItem(ConnectionParams connectionParams) {
        this.setModelProperty(PROPERTY_HOST_NAME, connectionParams.hostName);
        this.setModelProperty(PROPERTY_RFB_PORT_NUMBER, connectionParams.getPortNumber(), Integer.TYPE);
        this.setModelProperty(PROPERTY_USE_SSH, connectionParams.useSsh(), Boolean.TYPE);
        this.setModelProperty(PROPERTY_SSH_HOST_NAME, connectionParams.sshHostName);
        this.setModelProperty(PROPERTY_SSH_PORT_NUMBER, connectionParams.getSshPortNumber(), Integer.TYPE);
        this.setModelProperty(PROPERTY_SSH_USER_NAME, connectionParams.sshUserName);
        this.populateFrom(CONNECTION_PARAMS_MODEL);
        this.rfbSettings.copyDataFrom(this.connectionsHistory.getProtocolSettings(connectionParams));
        this.uiSettings.copyDataFrom(this.connectionsHistory.getUiSettingsData(connectionParams));
    }

    public void clearHistory() {
        this.connectionsHistory.clear();
        this.connectionsHistory.reorder((ConnectionParams)this.getModel(CONNECTION_PARAMS_MODEL), this.rfbSettings, this.uiSettings);
        this.populateFrom(CONNECTIONS_HISTORY_MODEL);
        this.clearMessage();
    }

    public void showMessage(String message) {
        this.setViewProperty(PROPERTY_STATUS_BAR_MESSAGE, message);
    }

    public void clearMessage() {
        this.showMessage("");
    }

    public void setConnectionWorkerFactory(AbstractConnectionWorkerFactory connectionWorkerFactory) {
        this.connectionWorkerFactory = connectionWorkerFactory;
    }

    public void reconnect(String predefinedPassword) {
        this.connectionWorkerFactory.setPredefinedPassword(predefinedPassword);
        if (this.allowInteractive) {
            this.clearMessage();
            this.enableConnectionDialog();
            this.show();
            this.populate();
        } else if (this.needReconnection) {
            this.connect();
        }
    }

    public void clearPredefinedPassword() {
        this.connectionWorkerFactory.setPredefinedPassword(null);
    }

    public UiSettings getUiSettings() {
        return this.uiSettings;
    }

    public ProtocolSettings getRfbSettings() {
        return this.rfbSettings;
    }

    public boolean needReconnection() {
        return this.needReconnection;
    }

    public void setNeedReconnection(boolean need) {
        this.needReconnection = need;
    }

    public boolean allowInteractive() {
        return this.allowInteractive;
    }
}

