/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.io;

import java.util.StringTokenizer;

public class PlatformHelper {
    public static final boolean isWindows;
    public static final String separator;
    public static final char separatorChar;
    public static final String pathSeparator;
    public static final char pathSeparatorChar;
    public static final int INITIAL_MAX_PATH = 130;

    public static final int beginWithRootPathPrefix(String path) {
        if (path.startsWith("/") || path.startsWith("\\")) {
            return 1;
        }
        if (!isWindows) {
            return 0;
        }
        if (path.length() > 2 && Character.isLetter(path.charAt(0)) && path.charAt(1) == ':' && (path.charAt(2) == '/' || path.charAt(2) == '\\')) {
            return 3;
        }
        return 0;
    }

    public static final boolean isRootDirectory(String path) {
        int len = path.length();
        boolean bl = false;
        if (len > 0 && PlatformHelper.beginWithRootPathPrefix(path) == len) {
            bl = true;
        }
        return bl;
    }

    public static final String toCanonicalForm(String path) {
        int i;
        String tmppath = path.replace('/', separatorChar);
        if (isWindows) {
            tmppath = tmppath.toLowerCase();
        }
        if ((i = PlatformHelper.beginWithRootPathPrefix(tmppath)) == 0) {
            return path;
        }
        StringBuffer canonpath = new StringBuffer(130);
        canonpath.append(tmppath.substring(0, i));
        tmppath = tmppath.substring(i);
        int pathdepth = 0;
        StringTokenizer st = new StringTokenizer(tmppath, separator);
        if (st.hasMoreTokens()) {
            do {
                String s;
                if ((s = st.nextToken()).equals(".") || s.equals("")) continue;
                if (s.equals("..")) {
                    if (pathdepth == 0) continue;
                    canonpath.setLength(canonpath.length() - 1);
                    String tmpstr = canonpath.toString();
                    int idx = tmpstr.lastIndexOf(separator);
                    if (idx == -1 || idx + 1 > tmpstr.length()) {
                        return path;
                    }
                    canonpath.setLength(idx + 1);
                    --pathdepth;
                    continue;
                }
                canonpath.append(s);
                ++pathdepth;
                if (!st.hasMoreTokens()) continue;
                canonpath.append(separator);
            } while (st.hasMoreTokens());
        }
        if (PlatformHelper.endWithSeparator(path)) {
            canonpath.append(separator);
        }
        String tmpstr = canonpath.toString();
        return tmpstr;
    }

    public static final String toCanonicalForm(String path, char sepchar) {
        String tmpstr = PlatformHelper.toCanonicalForm(path);
        tmpstr = tmpstr.replace(separatorChar, sepchar);
        return tmpstr;
    }

    public static final boolean endWithSeparator(String path) {
        return path.endsWith("\\") || path.endsWith("/");
    }

    public static final String removeTailSeparator(String path) {
        if (PlatformHelper.endWithSeparator(path) && !PlatformHelper.isRootDirectory(path)) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static final int lastIndexOfSeparator(String path) {
        return Math.max(path.lastIndexOf("/"), path.lastIndexOf("\\"));
    }

    static {
        boolean bl = false;
        if (System.getProperty("os.name").indexOf("Windows") >= 0) {
            bl = true;
        }
        isWindows = bl;
        separator = System.getProperty("file.separator");
        separatorChar = separator.charAt(0);
        pathSeparator = System.getProperty("path.separator");
        pathSeparatorChar = pathSeparator.charAt(0);
    }
}

