#############################################################################
##
#W  grppclat.gd                GAP library                   Alexander Hulpke
##
#H  @(#)$Id: grppclat.gd,v 4.24 2002/04/15 10:04:51 sal Exp $
##
#Y  Copyright (C)  1997  
#Y  (C) 1998 School Math and Comp. Sci., University of St.  Andrews, Scotland
#Y  Copyright (C) 2002 The GAP Group
##
##  This  file contains declarations for the subgroup lattice functions for
##  pc groups.
##
Revision.grppclat_gd:=
  "@(#)$Id: grppclat.gd,v 4.24 2002/04/15 10:04:51 sal Exp $";

#############################################################################
##
#V  InfoPcSubgroup
##
##  Information function for the subgroup lattice functions using pcgs.
DeclareInfoClass("InfoPcSubgroup");

#############################################################################
##
#O  InvariantElementaryAbelianSeries( <G>, <morph>[, <N> [, <fine>]] )
##
##  For a (solvable) group <G> and a list of automorphisms <morph> of <G>,
##  this command finds a normal series of <G> with elementary abelian
##  factors such that every group in this series is invariant under every
##  automorphism in <morph>.
##
##  If a normal subgroup <N> of <G> which is invariant under <morph> is
##  given, this series is chosen to contain <N>. No tests are performed to
##  check the validity of the arguments.
##
##  The series obtained will be constructed to prefer large steps unless
##  <fine> is given as `true'.
##
DeclareGlobalFunction("InvariantElementaryAbelianSeries");

#############################################################################
##
#O  InducedAutomorphism( <epi>, <aut> )
##
##  Let <aut> be an automorphism of a group <G> and `<epi>: <G> -> <H>' an
##  homomorphism such that `ker <epi>' is fixed under <aut>.
##  Let <U> be the image of <epi>. This command returns the automorphism of
##  <U> induced by <aut> via <epi>, that is the automorphism of <U> which maps
##  `<g>^<epi>' to `(<g>^<aut>)^<epi>', for <g> $\in$ <G>.
##
DeclareGlobalFunction("InducedAutomorphism");

#############################################################################
##
#F  InvariantSubgroupsElementaryAbelianGroup(<G>,<homs>[,<dims>])  submodules
##
##  Let <G> be an elementary abelian group (that is a vector space) and <homs>
##  a set of automorphisms of <G>. Then this function computes all subspaces of
##  <G> which are invariant under all automorphisms in <homs>. When considering
##  <G> as a module for the algebra generated by <homs>, these are all
##  submodules.
##  If <homs> is empty, it computes all subspaces. 
##  If the optional parameter <dims> is given, only subspaces of this
##  dimension are computed.
##
DeclareGlobalFunction(
    "InvariantSubgroupsElementaryAbelianGroup");

#############################################################################
##
#F  ActionSubspacesElementaryAbelianGroup(<P>,<G>[,<dims>])  submodules
##
##  computes the permutation action of <P> on the subspaces of the
##  elementary abelian subgroup <G> of <P>. Returns
##  a list [<subspaces>,<action>], where <subspaces> is a list of all the
##  subspaces and <action> a homomorphism from <P> in a permutation group,
##  which is equal to the action homomrophism for the action of <P> on
##  <subspaces>. If <dims> is given, only subspaces of dimension <dims> are
##  considered.
DeclareGlobalFunction(
    "ActionSubspacesElementaryAbelianGroup");

#############################################################################
##
#F  SubgroupsSolvableGroup(<G>[,<opt>]) . classreps of subgrps of <G>,
##
##  This function (implementing the algorithm published in \cite{Hulpke99})
##  computes subgroups of a solvable group <G>, using the homomorphism
##  principle. It returns a list of representatives up to <G>-conjugacy.
##
##  The optional argument <opt> is a record, which may
##  be used to put restrictions on the subgroups computed. The following record
##  components of <opt> are recognized and have the following effects:
##  \beginitems
##  `actions'&must be a list of automorphisms of <G>. If given, only groups
##  which are invariant under all these automorphisms are computed. The
##  algorithm must know the normalizer in <G> of the group generated by
##  `actions' (defined formally by embedding in the semidirect product of
##  <G> with <actions>). This can be given in the component `funcnorm' and
##  will be computed if this component is not given.
##  
##  `normal'&if set to `true' only normal subgroups are guaranteed to be
##  returned (though some of the returned subgroups might still be not
##  normal).
##  
##  `consider'&a function to restrict the groups computed. This must be a
##  function of five parameters, <C>,<A>,<N>,<B>,<M>, that are interpreted
##  as follows: The arguments are subgroups of a factor $F$ of $G$ in the
##  relation $F\ge C>A>N>B>M$. $N$ and $M$ are normal subgroups. <C> is the
##  full preimage of the normalizer of <A>/<N> in <F>/<N>. When computing
##  modulo <M> and looking for subgroups <U> such that $U\cap N=B$ and
##  $\langle U,N\rangle=A$, this function is called. If it returns `false'
##  all potential groups <U> (and therefore all groups later arising from
##  them) are disregarded. This can be used for example to compute only
##  subgroups of certain sizes. 
##
##  (*This is just a restriction to speed up computations. The function may
##  still return (invariant) subgroups which don't fulfill this condition!*)
##  This parameter is used to permit calculations of some subgroups if the
##  set of all subgroups would be too large to handle.
##
##  The actual groups <C>, <A>, <N> and <B> which are passed to this
##  function are not necessarily subgroups of <G> but might be subgroups of
##  a proper factor group <F>=<G>/<H>. Therefore the `consider' function may
##  not relate the parameter groups to <G>.
##  
##  `retnorm'&if set to `true' the function not only returns a list <subs>
##  of subgroups but also a corresponding list <norms> of normalizers in the
##  form [<subs>,<norms>].
##
##  `series'&is an elementary abelian series of <G> which will be used for
##  the computation.
##
##  `groups'&is a list of groups to seed the calculation. Only subgroups of
##  these groups are constructed.
##  \enditems
##  
DeclareGlobalFunction("SubgroupsSolvableGroup");

#############################################################################
##
#F  SizeConsiderFunction(<size>)   returns `consider' function
##
##  This function returns a function <consider> of four arguments that can be
##  used in `SubgroupsSolvableGroup' (see "SubgroupsSolvableGroup") for
##  the option `consider' to compute subgroups whose sizes are divisible by
##  <size>.
##
DeclareGlobalFunction("SizeConsiderFunction");

#############################################################################
##
#F  ExactSizeConsiderFunction(<size>)  returns `consider' function
##
##  This function returns a function <consider> of four arguments that can be
##  used in `SubgroupsSolvableGroup' (see "SubgroupsSolvableGroup") for
##  the option `consider' to compute subgroups whose sizes are exactly
##  <size>.
##
DeclareGlobalFunction("ExactSizeConsiderFunction");

#############################################################################
##
#E

