;;; welsh.el --- Quail package for inputting Welsh characters  -*-coding: utf-8 -*-

;; Copyright (C) 2001, 2006 Free Software Foundation, Inc.

;; Author: Dave Love <fx@gnu.org>
;; Keywords: i18n

;; This file is part of GNU Emacs.

;; This file is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; This file is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to
;; the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
;; Boston, MA 02110-1301, USA.

;;; Synched up with: FSF 22.0.50.6

;;; Commentary:

;; Welsh input following the Yudit map by david@sheetmusic.org.uk.
;; This is set up to produce utf-8.  A Latin-8 version of most of it
;; is commented-out at the end.

;; XEmacs change; coding system is now UTF-8, the latin-8 entries at the end
;; are no longer latin-8.

;;; Code:

(require 'quail)

;; XEmacs change: This file breaks with 21.4 and early 21.5. 
(unless (and (fboundp 'decode-char) (decode-char 'ucs #x31C)
	     (eq #x31C (encode-char (decode-char 'ucs #x31C) 'ucs)))
  (error "Unicode support needed for this file not available!"))

(quail-define-package
 "welsh" "Welsh" "Ŵ" t
 "Welsh postfix input method, using Unicode"
 nil t nil nil nil nil nil nil nil nil t)

(quail-define-rules
 ("A\\" ?À)
 ("A/" ?Á)
 ("A^" ?Â)
 ("A+" ?Â)
 ("A\"" ?Ä)
 ("a\\" ?à)
 ("a/" ?á)
 ("a^" ?â)
 ("a+" ?â)
 ("a\"" ?ä)

 ("E\\" ?È)
 ("E/" ?É)
 ("E^" ?Ê)
 ("E+" ?Ê)
 ("E\"" ?Ë)
 ("e\\" ?è)
 ("e/" ?é)
 ("e^" ?ê)
 ("e+" ?ê)
 ("e\"" ?ë)

 ("I\\" ?Ì)
 ("I/" ?Í)
 ("I^" ?Î)
 ("I+" ?Î)
 ("I\"" ?Ï)
 ("i\\" ?ì)
 ("i/" ?í)
 ("i^" ?î)
 ("i+" ?î)
 ("i\"" ?ï)

 ("O\\" ?Ò)
 ("O/" ?Ó)
 ("O^" ?Ô)
 ("O+" ?Ô)
 ("O\"" ?Ö)
 ("o\\" ?ò)
 ("o/" ?ó)
 ("o^" ?ô)
 ("o+" ?ô)
 ("o\"" ?ö)

 ("U\\" ?Ù)
 ("U/" ?Ú)
 ("U^" ?Û)
 ("U+" ?Û)
 ("U\"" ?Ü)
 ("u\\" ?ù)
 ("u/" ?ú)
 ("u^" ?û)
 ("u+" ?û)
 ("u\"" ?ü)

 ("Y\\" ?Ỳ)
 ("Y/" ?Ý)
 ("Y^" ?Ŷ)
 ("Y+" ?Ŷ)
 ("Y\"" ?Ÿ)
 ("y\\" ?ỳ)
 ("y/" ?ý)
 ("y\"" ?ÿ)
 ("y^" ?ŷ)
 ("y+" ?ŷ)

 ("W\\" ?Ẁ)
 ("W/" ?Ẃ)
 ("W^" ?Ŵ)
 ("W+" ?Ŵ)
 ("W\"" ?Ẅ)
 ("w\\" ?ẁ)
 ("w/" ?ẃ)
 ("w^" ?ŵ)
 ("w+" ?ŵ)
 ("w\"" ?ẅ)

 ;; "hawlfraint" (copyright).  Dyma arwyddlun hawlfraint.
 ("(h)" ?ⓗ))

;; (quail-define-package
;;  "welsh" "Welsh" "Ŵ" t
;;  "Welsh postfix input method, using Latin-8"
;;  nil t nil nil nil nil nil nil nil nil t)

;; (quail-define-rules
;;  ("A\\" ?À)
;;  ("A/" ?Á)
;;  ("A^" ?Â)
;;  ("A+" ?Â)
;;  ("A\"" ?Ä)
;;  ("a\\" ?à)
;;  ("a/" ?á)
;;  ("a^" ?â)
;;  ("a+" ?â)
;;  ("a\"" ?ä)

;;  ("E\\" ?È)
;;  ("E/" ?É)
;;  ("E^" ?Ê)
;;  ("E+" ?Ê)
;;  ("E\"" ?Ë)
;;  ("e\\" ?è)
;;  ("e/" ?é)
;;  ("e^" ?ê)
;;  ("e+" ?ê)
;;  ("e\"" ?ë)

;;  ("I\\" ?Ì)
;;  ("I/" ?Í)
;;  ("I^" ?Î)
;;  ("I+" ?Î)
;;  ("I\"" ?Ï)
;;  ("i\\" ?ì)
;;  ("i/" ?í)
;;  ("i^" ?î)
;;  ("i+" ?î)
;;  ("i\"" ?ï)

;;  ("O\\" ?Ò)
;;  ("O/" ?Ó)
;;  ("O^" ?Ô)
;;  ("O+" ?Ô)
;;  ("O\"" ?Ö)
;;  ("o\\" ?ò)
;;  ("o/" ?ó)
;;  ("o^" ?ô)
;;  ("o+" ?ô)
;;  ("o\"" ?ö)

;;  ("U\\" ?Ù)
;;  ("U/" ?Ú)
;;  ("U^" ?Û)
;;  ("U+" ?Û)
;;  ("U\"" ?Ü)
;;  ("u\\" ?ù)
;;  ("u/" ?ú)
;;  ("u^" ?û)
;;  ("u+" ?û)
;;  ("u\"" ?ü)

;;  ("Y\\" ?¬)
;;  ("Y/" ?Ý)
;;  ("Y^" ?Þ)
;;  ("Y+" ?Þ)
;;  ("Y\"" ?¯)
;;  ("y\\" ?¼)
;;  ("y/" ?ý)
;;  ("y\"" ?ÿ)
;;  ("y^" ?þ)
;;  ("y+" ?þ)

;;  ("W\\" ?¨)
;;  ("W/" ?ª)
;;  ("W^" ?Ð)
;;  ("W+" ?Ð)
;;  ("W\"" ?½)
;;  ("w\\" ?¸)
;;  ("w/" ?º)
;;  ("w^" ?ð)
;;  ("w+" ?ð)
;;  ("w\"" ?¾))


;;; arch-tag: aeef0eae-0a50-4606-9120-020d59d5e208
;;; welsh.el ends here
