/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.pipeline;

import gnu.xml.pipeline.EventConsumer;
import gnu.xml.pipeline.EventFilter;
import java.io.IOException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public final class XsltFilter
extends EventFilter {
    public XsltFilter(String stylesheet, EventConsumer next) throws SAXException, IOException {
        TransformerHandler th;
        TransformerFactory tf = null;
        try {
            tf = TransformerFactory.newInstance();
            if (!(tf.getFeature("http://javax.xml.transform.sax.SAXTransformerFactory/feature") && tf.getFeature("http://javax.xml.transform.sax.SAXResult/feature") && tf.getFeature("http://javax.xml.transform.stream.StreamSource/feature"))) {
                throw new IOException("XSLT factory (" + tf.getClass().getName() + ") does not support SAX");
            }
            SAXTransformerFactory stf = (SAXTransformerFactory)tf;
            th = stf.newTransformerHandler(new StreamSource(stylesheet));
        }
        catch (TransformerConfigurationException e) {
            throw new IOException("XSLT factory (" + (tf == null ? "none available" : tf.getClass().getName()) + ") configuration error, " + e.getMessage());
        }
        SAXResult out = new SAXResult();
        out.setHandler(next.getContentHandler());
        try {
            LexicalHandler lh = (LexicalHandler)next.getProperty("http://xml.org/sax/properties/lexical-handler");
            out.setLexicalHandler(lh);
        }
        catch (Exception e) {
            // empty catch block
        }
        th.setResult(out);
        this.setContentHandler(th);
        this.setProperty("http://xml.org/sax/properties/lexical-handler", th);
    }
}

