/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.algorithmic.algorithm;

import it.unimi.dsi.lang.MutableString;
import org.campagnelab.goby.algorithmic.indels.EquivalentIndelRegion;
import org.campagnelab.goby.alignments.processors.ObservedIndel;
import org.campagnelab.goby.reads.RandomAccessSequenceInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EquivalentIndelRegionCalculator {
    RandomAccessSequenceInterface genome;
    private static final MutableString GAPS = new MutableString("----------------------------------------------------------------");
    private int flankRightSize = 4;
    public int flankLeftSize = 4;
    private static final Logger LOG = LoggerFactory.getLogger(EquivalentIndelRegionCalculator.class);
    private int[] alignmentToGenomeTargetIndices;
    MutableString p = new MutableString();
    final MutableString rollBuffer = new MutableString();
    final MutableString toFill = new MutableString();
    final MutableString gaps = new MutableString();
    MutableString from = new MutableString();
    MutableString to = new MutableString();
    MutableString flankingLeft = new MutableString();
    MutableString flankingRight = new MutableString();

    public void setReferenceIndexPermutation(int[] alignmentToGenomeTargetIndices) {
        this.alignmentToGenomeTargetIndices = alignmentToGenomeTargetIndices;
    }

    public void setFlankRightSize(int flankRightSize) {
        this.flankRightSize = flankRightSize;
    }

    public void setFlankLeftSize(int flankLeftSize) {
        this.flankLeftSize = flankLeftSize;
    }

    public int getFlankRightSize() {
        return this.flankRightSize;
    }

    public int getFlankLeftSize() {
        return this.flankLeftSize;
    }

    public EquivalentIndelRegionCalculator(RandomAccessSequenceInterface genome, int[] alignmentToGenomeTargetIndices) {
        this.init(genome, alignmentToGenomeTargetIndices);
    }

    public EquivalentIndelRegionCalculator(RandomAccessSequenceInterface genome) {
        int[] permutation = new int[genome.size()];
        for (int i = 0; i < genome.size(); ++i) {
            permutation[i] = i;
        }
        this.init(genome, permutation);
    }

    private void init(RandomAccessSequenceInterface genome, int[] alignmentToGenomeTargetIndices) {
        this.genome = genome;
        if (genome == null) {
            throw new IllegalArgumentException("genome cannot be null");
        }
        if (alignmentToGenomeTargetIndices == null) {
            throw new IllegalArgumentException("permutation cannot be null");
        }
        this.alignmentToGenomeTargetIndices = alignmentToGenomeTargetIndices;
    }

    public EquivalentIndelRegion determine(int referenceIndex, ObservedIndel indel) {
        assert (referenceIndex >= 0) : "reference index canot be negative";
        EquivalentIndelRegion result = new EquivalentIndelRegion();
        result.startPosition = indel.getStart();
        result.endPosition = indel.getEnd();
        result.referenceIndex = referenceIndex;
        if (indel.getMatchesForwardStrand()) {
            result.incrementForwardFrequency();
        } else {
            result.incrementReverseFrequency();
        }
        if (indel.getMatchesForwardStrand()) {
            result.forwardReadIndices.add(indel.readIndex);
            if (indel.hasQualityScores()) {
                result.forwardQualityScores.add(indel.getQualityScores());
            }
        } else {
            result.reverseReadIndices.add(indel.readIndex);
            if (indel.hasQualityScores()) {
                result.reverseQualityScores.add(indel.getQualityScores());
            }
        }
        this.p.setLength(0);
        boolean insertion = this.insertionInRead(indel);
        this.p.append(insertion ? indel.to() : indel.from());
        int genomeReferenceIndex = this.alignmentToGenomeTargetIndices[referenceIndex];
        int leftExtensions = 0;
        int indelSize = this.p.length();
        int lastBaseIndex = indelSize - 1;
        int rewindLeft = 0;
        if (result.startPosition > this.genome.getLength(genomeReferenceIndex)) {
            LOG.warn(String.format("Cannot determine sequence at position %d of reference-index %d ", result.startPosition, referenceIndex));
            return null;
        }
        while (result.startPosition >= 1 && this.p.charAt(lastBaseIndex - leftExtensions + rewindLeft) == this.genome.get(genomeReferenceIndex, result.startPosition)) {
            result.startPosition = indel.getStart() - ++leftExtensions;
            if (lastBaseIndex - leftExtensions + rewindLeft >= 0) continue;
            rewindLeft += indelSize;
        }
        int rightExtensions = 0;
        int rewindRight = 0;
        int chromosomeSize = this.genome.getLength(genomeReferenceIndex);
        while (result.endPosition < chromosomeSize && this.p.charAt(rightExtensions + rewindRight) == this.genome.get(genomeReferenceIndex, result.endPosition)) {
            result.endPosition = indel.getEnd() + ++rightExtensions;
            if (rightExtensions + rewindRight < indelSize) continue;
            rewindRight -= indelSize;
        }
        this.from.setLength(0);
        this.to.setLength(0);
        this.toFill.setLength(0);
        this.genome.getRange(genomeReferenceIndex, result.startPosition + 1, result.endPosition - result.startPosition - 1, this.from);
        if (insertion) {
            this.to.append(this.roll(leftExtensions, indel.to()));
            this.to.append(this.from);
            this.ensureGAPLongEnough(indelSize);
            this.from.insert(0, GAPS.subSequence(0, indelSize));
        } else {
            int length = this.from.length();
            this.ensureGAPLongEnough(indelSize);
            this.to.append(GAPS.subSequence(0, indelSize));
            this.to.append(this.from.subSequence(Math.min(indelSize, length), length));
        }
        result.from = this.from.toString();
        result.to = this.to.toString();
        this.flankingLeft.setLength(0);
        this.genome.getRange(genomeReferenceIndex, result.startPosition - this.flankLeftSize + 1, this.flankLeftSize, this.flankingLeft);
        result.flankLeft = this.flankingLeft.toString();
        this.flankingRight.setLength(0);
        this.genome.getRange(genomeReferenceIndex, result.endPosition, this.flankRightSize, this.flankingRight);
        int maxRefLength = this.genome.getLength(genomeReferenceIndex);
        result.flankRight = this.flankingRight.toString();
        return result;
    }

    private void ensureGAPLongEnough(int indelSize) {
        while (GAPS.length() < indelSize) {
            GAPS.append("-");
        }
    }

    private final MutableString roll(int leftExtensions, String from) {
        this.rollBuffer.setLength(0);
        this.rollBuffer.append(from);
        int length = from.length();
        int lastCharIndex = length - 1;
        for (int i = 0; i < leftExtensions; ++i) {
            this.rollBuffer.insert(0, this.rollBuffer.charAt(lastCharIndex));
            this.rollBuffer.setLength(length);
        }
        return this.rollBuffer;
    }

    private boolean insertionInRead(ObservedIndel indel) {
        String from = indel.from();
        String to = indel.to();
        if (from.indexOf(45) >= 0) {
            return true;
        }
        if (to.indexOf(45) >= 0) {
            return false;
        }
        LOG.error("indel must either be an insertionInRead or a deletion: " + indel);
        return false;
    }
}

