/// These are automatically generated templated C++ bindings for isl.
///
/// isl is a library for computing with integer sets and maps described by
/// Presburger formulas. On top of this, isl provides various tools for
/// polyhedral compilation, ranging from dependence analysis over scheduling
/// to AST generation.

#ifndef ISL_TYPED_CPP
#define ISL_TYPED_CPP

#include <type_traits>

#include <isl/cpp.h>

namespace isl {
namespace typed {

template <typename Domain, typename Range>
struct pair {};

struct Anonymous;


template <typename...>
struct aff;

template <typename...Ts>
using aff_on = aff<Ts..., Anonymous>;

template <typename...>
struct aff_list;

template <typename...Ts>
using aff_list_on = aff_list<Ts..., Anonymous>;

template <typename...>
struct basic_map;

template <typename...>
struct basic_set;

template <typename...>
struct fixed_box;

template <typename...>
struct id;

template <typename...>
struct id_list;

template <typename...>
struct map;

template <typename...>
struct map_list;

template <typename...>
struct multi_aff;

template <typename...>
struct multi_id;

template <typename...>
struct multi_pw_aff;

template <typename...>
struct multi_union_pw_aff;

template <typename...>
struct multi_val;

template <typename...>
struct point;

template <typename...>
struct pw_aff;

template <typename...Ts>
using pw_aff_on = pw_aff<Ts..., Anonymous>;

template <typename...>
struct pw_aff_list;

template <typename...Ts>
using pw_aff_list_on = pw_aff_list<Ts..., Anonymous>;

template <typename...>
struct pw_multi_aff;

template <typename...>
struct pw_multi_aff_list;

template <typename...>
struct set;

template <typename...>
struct set_list;

template <typename...>
struct space;

template <typename...>
struct union_map;

template <typename...>
struct union_pw_aff;

template <typename...Ts>
using union_pw_aff_on = union_pw_aff<Ts..., Anonymous>;

template <typename...>
struct union_pw_aff_list;

template <typename...Ts>
using union_pw_aff_list_on = union_pw_aff_list<Ts..., Anonymous>;

template <typename...>
struct union_pw_multi_aff;

template <typename...>
struct union_set;

template <typename...>
struct union_set_list;

template <typename...>
struct val;

template <typename...>
struct val_list;

template <>
struct aff<Anonymous> : public isl::aff {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  aff() = default;
  aff(const isl::aff &obj) : isl::aff(obj) {}
  static aff from(const isl::aff &obj) {
    return aff(obj);
  }
  inline explicit aff(const isl::ctx &ctx, const std::string &str);
  inline typed::aff<Anonymous> add(const typed::aff<Anonymous> &aff2) const;
  inline typed::multi_aff<Anonymous> add(const typed::multi_aff<Anonymous> &multi2) const;
  inline typed::multi_pw_aff<Anonymous> add(const typed::multi_pw_aff<Anonymous> &multi2) const;
  inline typed::multi_union_pw_aff<Anonymous> add(const typed::multi_union_pw_aff<Anonymous> &multi2) const;
  inline typed::pw_aff<Anonymous> add(const typed::pw_aff<Anonymous> &pwaff2) const;
  inline typed::pw_multi_aff<Anonymous> add(const typed::pw_multi_aff<Anonymous> &pma2) const;
  inline typed::union_pw_aff<Anonymous> add(const typed::union_pw_aff<Anonymous> &upa2) const;
  inline typed::union_pw_multi_aff<Anonymous> add(const typed::union_pw_multi_aff<Anonymous> &upma2) const;
  inline typed::aff<Anonymous> add_constant(const typed::val<Anonymous> &v) const;
  inline typed::aff<Anonymous> add_constant(long v) const;
  inline typed::multi_aff<Anonymous> add_constant(const typed::multi_val<Anonymous> &mv) const;
  template <typename Range>
  inline typed::union_pw_multi_aff<Range> apply(const typed::union_pw_multi_aff<Anonymous, Range> &upma2) const;
  inline typed::aff<Anonymous> as_aff() const;
  inline typed::map<Anonymous> as_map() const = delete;
  inline typed::multi_aff<Anonymous> as_multi_aff() const;
  inline typed::multi_union_pw_aff<Anonymous> as_multi_union_pw_aff() const;
  inline typed::pw_multi_aff<Anonymous> as_pw_multi_aff() const;
  inline typed::set<Anonymous> as_set() const;
  inline typed::union_map<Anonymous> as_union_map() const = delete;
  inline typed::aff<Anonymous> at(int pos) const;
  inline typed::basic_set<> bind(const typed::id<Anonymous> &id) const;
  inline typed::basic_set<> bind(const std::string &id) const;
  inline typed::basic_set<> bind(const typed::multi_id<Anonymous> &tuple) const;
  inline typed::pw_aff<Anonymous> bind_domain(const typed::multi_id<> &tuple) const = delete;
  inline typed::pw_aff<Anonymous> bind_domain_wrapped_domain(const typed::multi_id<> &tuple) const = delete;
  inline typed::aff<Anonymous> ceil() const;
  inline typed::pw_aff<Anonymous> coalesce() const;
  inline typed::pw_aff<Anonymous> cond(const typed::pw_aff<Anonymous> &pwaff_true, const typed::pw_aff<Anonymous> &pwaff_false) const;
  inline typed::multi_val<Anonymous> constant_multi_val() const;
  inline typed::val<Anonymous> constant_val() const;
  inline typed::val<Anonymous> get_constant_val() const = delete;
  inline typed::set<> domain() const;
  inline typed::aff<Anonymous> domain_reverse() const = delete;
  inline typed::pw_aff<Anonymous> drop_unused_params() const;
  inline typed::pw_multi_aff<Anonymous> extract_pw_multi_aff(const typed::space<Anonymous> &space) const;
  inline typed::aff<Anonymous> floor() const;
  inline typed::set<Anonymous> ge_set(const typed::aff<> &aff2) const = delete;
  inline typed::set<Anonymous> ge_set(const typed::pw_aff<> &pwaff2) const = delete;
  inline typed::aff<Anonymous> gist(const typed::set<> &context) const;
  inline typed::union_pw_aff<Anonymous> gist(const typed::union_set<> &context) const;
  inline typed::aff<Anonymous> gist(const typed::basic_set<> &context) const;
  inline typed::aff<Anonymous> gist(const typed::point<> &context) const;
  inline typed::aff<Anonymous> gist_params(const typed::set<> &context) const;
  inline typed::aff<Anonymous> gist_params(const typed::basic_set<> &context) const;
  inline typed::aff<Anonymous> gist_params(const typed::point<> &context) const;
  inline typed::set<Anonymous> gt_set(const typed::aff<> &aff2) const = delete;
  inline typed::set<Anonymous> gt_set(const typed::pw_aff<> &pwaff2) const = delete;
  inline typed::multi_aff<Anonymous, Anonymous> identity() const;
  template <typename Domain>
  inline typed::pw_aff<Domain, Anonymous> insert_domain(const typed::space<Domain> &domain) const;
  inline typed::pw_aff<Anonymous> intersect_domain(const typed::set<> &set) const = delete;
  inline typed::union_pw_aff<Anonymous> intersect_domain(const typed::space<> &space) const = delete;
  inline typed::union_pw_aff<Anonymous> intersect_domain(const typed::union_set<> &uset) const = delete;
  inline typed::union_pw_aff<Anonymous> intersect_domain_wrapped_domain(const typed::union_set<> &uset) const = delete;
  inline typed::pw_aff<Anonymous> intersect_params(const typed::set<> &set) const;
  inline typed::set<Anonymous> le_set(const typed::aff<> &aff2) const = delete;
  inline typed::set<Anonymous> le_set(const typed::pw_aff<> &pwaff2) const = delete;
  inline typed::aff_list<Anonymous> list() const;
  inline typed::set<Anonymous> lt_set(const typed::aff<> &aff2) const = delete;
  inline typed::set<Anonymous> lt_set(const typed::pw_aff<> &pwaff2) const = delete;
  inline typed::multi_pw_aff<Anonymous> max(const typed::multi_pw_aff<Anonymous> &multi2) const;
  inline typed::pw_aff<Anonymous> max(const typed::pw_aff<Anonymous> &pwaff2) const;
  inline typed::multi_val<Anonymous> max_multi_val() const;
  inline typed::val<Anonymous> max_val() const;
  inline typed::multi_pw_aff<Anonymous> min(const typed::multi_pw_aff<Anonymous> &multi2) const;
  inline typed::pw_aff<Anonymous> min(const typed::pw_aff<Anonymous> &pwaff2) const;
  inline typed::multi_val<Anonymous> min_multi_val() const;
  inline typed::val<Anonymous> min_val() const;
  inline typed::aff<Anonymous> mod(const typed::val<Anonymous> &mod) const;
  inline typed::aff<Anonymous> mod(long mod) const;
  inline typed::aff<Anonymous> neg() const;
  inline typed::set<> params() const;
  inline typed::pw_multi_aff<Anonymous> preimage_domain_wrapped_domain(const typed::pw_multi_aff<> &pma2) const = delete;
  inline typed::union_pw_multi_aff<Anonymous> preimage_domain_wrapped_domain(const typed::union_pw_multi_aff<> &upma2) const = delete;
  template <typename Range>
  inline typed::multi_aff<pair<Anonymous, Range>> product(const typed::multi_aff<Range> &multi2) const;
  template <typename Range>
  inline typed::multi_pw_aff<pair<Anonymous, Range>> product(const typed::multi_pw_aff<Range> &multi2) const;
  template <typename Range>
  inline typed::pw_multi_aff<pair<Anonymous, Range>> product(const typed::pw_multi_aff<Range> &pma2) const;
  inline typed::aff<Anonymous> pullback(const typed::multi_aff<> &ma) const = delete;
  inline typed::pw_aff<Anonymous> pullback(const typed::multi_pw_aff<> &mpa) const = delete;
  inline typed::pw_aff<Anonymous> pullback(const typed::pw_multi_aff<> &pma) const = delete;
  inline typed::union_pw_aff<Anonymous> pullback(const typed::union_pw_multi_aff<> &upma) const = delete;
  inline typed::aff<Anonymous> pullback(const typed::aff<> &ma) const = delete;
  inline typed::pw_multi_aff_list<Anonymous> pw_multi_aff_list() const;
  inline typed::pw_multi_aff<Anonymous> range_factor_domain() const = delete;
  inline typed::pw_multi_aff<Anonymous> range_factor_range() const = delete;
  inline typed::multi_aff<Anonymous> range_product(const typed::multi_aff<> &multi2) const = delete;
  inline typed::multi_pw_aff<Anonymous> range_product(const typed::multi_pw_aff<> &multi2) const = delete;
  inline typed::multi_union_pw_aff<Anonymous> range_product(const typed::multi_union_pw_aff<> &multi2) const = delete;
  inline typed::pw_multi_aff<Anonymous> range_product(const typed::pw_multi_aff<> &pma2) const = delete;
  inline typed::union_pw_multi_aff<Anonymous> range_product(const typed::union_pw_multi_aff<> &upma2) const = delete;
  inline typed::aff<Anonymous> scale(const typed::val<Anonymous> &v) const;
  inline typed::aff<Anonymous> scale(long v) const;
  inline typed::multi_aff<Anonymous> scale(const typed::multi_val<Anonymous> &mv) const;
  inline typed::aff<Anonymous> scale_down(const typed::val<Anonymous> &v) const;
  inline typed::aff<Anonymous> scale_down(long v) const;
  inline typed::multi_aff<Anonymous> scale_down(const typed::multi_val<Anonymous> &mv) const;
  inline typed::multi_aff<Anonymous> set_at(int pos, const typed::aff<Anonymous> &el) const;
  inline typed::multi_pw_aff<Anonymous> set_at(int pos, const typed::pw_aff<Anonymous> &el) const;
  inline typed::multi_union_pw_aff<Anonymous> set_at(int pos, const typed::union_pw_aff<Anonymous> &el) const;
  template <typename Domain2>
  inline typed::multi_aff<Domain2> set_range_tuple(const typed::id<Anonymous> &id) const;
  template <typename Domain2>
  inline typed::multi_aff<Domain2> set_range_tuple(const std::string &id) const;
  inline typed::space<Anonymous> space() const;
  inline typed::aff<Anonymous> sub(const typed::aff<Anonymous> &aff2) const;
  inline typed::multi_aff<Anonymous> sub(const typed::multi_aff<Anonymous> &multi2) const;
  inline typed::multi_pw_aff<Anonymous> sub(const typed::multi_pw_aff<Anonymous> &multi2) const;
  inline typed::multi_union_pw_aff<Anonymous> sub(const typed::multi_union_pw_aff<Anonymous> &multi2) const;
  inline typed::pw_aff<Anonymous> sub(const typed::pw_aff<Anonymous> &pwaff2) const;
  inline typed::pw_multi_aff<Anonymous> sub(const typed::pw_multi_aff<Anonymous> &pma2) const;
  inline typed::union_pw_aff<Anonymous> sub(const typed::union_pw_aff<Anonymous> &upa2) const;
  inline typed::union_pw_multi_aff<Anonymous> sub(const typed::union_pw_multi_aff<Anonymous> &upma2) const;
  inline typed::pw_aff<Anonymous> subtract_domain(const typed::set<> &set) const = delete;
  inline typed::union_pw_aff<Anonymous> subtract_domain(const typed::space<> &space) const = delete;
  inline typed::union_pw_aff<Anonymous> subtract_domain(const typed::union_set<> &uset) const = delete;
  inline typed::multi_pw_aff<Anonymous> to_multi_pw_aff() const;
  inline typed::multi_union_pw_aff<Anonymous> to_multi_union_pw_aff() const;
  inline typed::pw_multi_aff<Anonymous> to_pw_multi_aff() const;
  inline typed::union_pw_aff<Anonymous> to_union_pw_aff() const;
  inline typed::union_pw_multi_aff<Anonymous> to_union_pw_multi_aff() const;
  template <typename Domain>
  inline typed::aff<Domain, Anonymous> unbind_params_insert_domain(const typed::multi_id<Domain> &domain) const;
  inline typed::multi_pw_aff<Anonymous> union_add(const typed::multi_pw_aff<Anonymous> &mpa2) const;
  inline typed::multi_union_pw_aff<Anonymous> union_add(const typed::multi_union_pw_aff<Anonymous> &mupa2) const;
  inline typed::pw_aff<Anonymous> union_add(const typed::pw_aff<Anonymous> &pwaff2) const;
  inline typed::pw_multi_aff<Anonymous> union_add(const typed::pw_multi_aff<Anonymous> &pma2) const;
  inline typed::union_pw_aff<Anonymous> union_add(const typed::union_pw_aff<Anonymous> &upa2) const;
  inline typed::union_pw_multi_aff<Anonymous> union_add(const typed::union_pw_multi_aff<Anonymous> &upma2) const;
};

template <typename Domain>
struct aff<Domain, Anonymous> : public isl::aff {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  aff() = default;
  template <typename Arg1,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{},
            bool>::type = true>
  aff(const aff<Arg1, Anonymous> &obj) : isl::aff(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::aff>{}, bool>::type = true>
  aff(const base &obj) : isl::aff(obj) {}
 public:
  static aff from(const isl::aff &obj) {
    return aff(obj);
  }
  inline explicit aff(const isl::ctx &ctx, const std::string &str);
  inline typed::aff<Domain, Anonymous> add(const typed::aff<Domain, Anonymous> &aff2) const;
  inline typed::multi_aff<Domain, Anonymous> add(const typed::multi_aff<Domain, Anonymous> &multi2) const;
  inline typed::multi_pw_aff<Domain, Anonymous> add(const typed::multi_pw_aff<Domain, Anonymous> &multi2) const;
  inline typed::multi_union_pw_aff<Domain, Anonymous> add(const typed::multi_union_pw_aff<Domain, Anonymous> &multi2) const;
  inline typed::pw_aff<Domain, Anonymous> add(const typed::pw_aff<Domain, Anonymous> &pwaff2) const;
  inline typed::pw_multi_aff<Domain, Anonymous> add(const typed::pw_multi_aff<Domain, Anonymous> &pma2) const;
  inline typed::union_pw_aff<Domain, Anonymous> add(const typed::union_pw_aff<Domain, Anonymous> &upa2) const;
  inline typed::union_pw_multi_aff<Domain, Anonymous> add(const typed::union_pw_multi_aff<Domain, Anonymous> &upma2) const;
  inline typed::aff<Domain, Anonymous> add_constant(const typed::val<Anonymous> &v) const;
  inline typed::aff<Domain, Anonymous> add_constant(long v) const;
  inline typed::multi_aff<Domain, Anonymous> add_constant(const typed::multi_val<Anonymous> &mv) const;
  template <typename Range2>
  inline typed::union_pw_multi_aff<Domain, Range2> apply(const typed::union_pw_multi_aff<Anonymous, Range2> &upma2) const;
  inline typed::aff<Domain, Anonymous> as_aff() const;
  inline typed::map<Domain, Anonymous> as_map() const;
  inline typed::multi_aff<Domain, Anonymous> as_multi_aff() const;
  inline typed::multi_union_pw_aff<Domain, Anonymous> as_multi_union_pw_aff() const;
  inline typed::pw_multi_aff<Domain, Anonymous> as_pw_multi_aff() const;
  inline typed::set<Domain, Anonymous> as_set() const = delete;
  inline typed::union_map<Domain, Anonymous> as_union_map() const;
  inline typed::aff<Domain, Anonymous> at(int pos) const;
  inline typed::basic_set<Domain> bind(const typed::id<Anonymous> &id) const;
  inline typed::basic_set<Domain> bind(const std::string &id) const;
  inline typed::basic_set<Domain> bind(const typed::multi_id<Anonymous> &tuple) const;
  inline typed::pw_aff<Anonymous> bind_domain(const typed::multi_id<Domain> &tuple) const;
  inline typed::pw_aff<Domain, Anonymous> bind_domain_wrapped_domain(const typed::multi_id<> &tuple) const = delete;
  inline typed::aff<Domain, Anonymous> ceil() const;
  inline typed::pw_aff<Domain, Anonymous> coalesce() const;
  inline typed::pw_aff<Domain, Anonymous> cond(const typed::pw_aff<Domain, Anonymous> &pwaff_true, const typed::pw_aff<Domain, Anonymous> &pwaff_false) const;
  inline typed::multi_val<Anonymous> constant_multi_val() const;
  inline typed::val<Anonymous> constant_val() const;
  inline typed::val<Domain, Anonymous> get_constant_val() const = delete;
  inline typed::set<Domain> domain() const;
  inline typed::aff<Domain, Anonymous> domain_reverse() const = delete;
  inline typed::pw_aff<Domain, Anonymous> drop_unused_params() const;
  inline typed::pw_multi_aff<Domain, Anonymous> extract_pw_multi_aff(const typed::space<Domain, Anonymous> &space) const;
  inline typed::aff<Domain, Anonymous> floor() const;
  inline typed::set<Domain> ge_set(const typed::aff<Domain, Anonymous> &aff2) const;
  inline typed::set<Domain> ge_set(const typed::pw_aff<Domain, Anonymous> &pwaff2) const;
  inline typed::aff<Domain, Anonymous> gist(const typed::set<Domain> &context) const;
  inline typed::union_pw_aff<Domain, Anonymous> gist(const typed::union_set<Domain> &context) const;
  inline typed::aff<Domain, Anonymous> gist(const typed::basic_set<Domain> &context) const;
  inline typed::aff<Domain, Anonymous> gist(const typed::point<Domain> &context) const;
  inline typed::aff<Domain, Anonymous> gist_params(const typed::set<> &context) const;
  inline typed::aff<Domain, Anonymous> gist_params(const typed::basic_set<> &context) const;
  inline typed::aff<Domain, Anonymous> gist_params(const typed::point<> &context) const;
  inline typed::set<Domain> gt_set(const typed::aff<Domain, Anonymous> &aff2) const;
  inline typed::set<Domain> gt_set(const typed::pw_aff<Domain, Anonymous> &pwaff2) const;
  inline typed::multi_aff<Domain, Anonymous> identity() const;
  inline typed::pw_aff<Domain, Anonymous> insert_domain(const typed::space<> &domain) const = delete;
  inline typed::pw_aff<Domain, Anonymous> intersect_domain(const typed::set<Domain> &set) const;
  inline typed::union_pw_aff<Domain, Anonymous> intersect_domain(const typed::space<Domain> &space) const;
  inline typed::union_pw_aff<Domain, Anonymous> intersect_domain(const typed::union_set<Domain> &uset) const;
  inline typed::union_pw_aff<Domain, Anonymous> intersect_domain_wrapped_domain(const typed::union_set<> &uset) const = delete;
  inline typed::pw_aff<Domain, Anonymous> intersect_params(const typed::set<> &set) const;
  inline typed::set<Domain> le_set(const typed::aff<Domain, Anonymous> &aff2) const;
  inline typed::set<Domain> le_set(const typed::pw_aff<Domain, Anonymous> &pwaff2) const;
  inline typed::aff_list<Domain, Anonymous> list() const;
  inline typed::set<Domain> lt_set(const typed::aff<Domain, Anonymous> &aff2) const;
  inline typed::set<Domain> lt_set(const typed::pw_aff<Domain, Anonymous> &pwaff2) const;
  inline typed::multi_pw_aff<Domain, Anonymous> max(const typed::multi_pw_aff<Domain, Anonymous> &multi2) const;
  inline typed::pw_aff<Domain, Anonymous> max(const typed::pw_aff<Domain, Anonymous> &pwaff2) const;
  inline typed::multi_val<Anonymous> max_multi_val() const;
  inline typed::val<Anonymous> max_val() const;
  inline typed::multi_pw_aff<Domain, Anonymous> min(const typed::multi_pw_aff<Domain, Anonymous> &multi2) const;
  inline typed::pw_aff<Domain, Anonymous> min(const typed::pw_aff<Domain, Anonymous> &pwaff2) const;
  inline typed::multi_val<Anonymous> min_multi_val() const;
  inline typed::val<Anonymous> min_val() const;
  inline typed::aff<Domain, Anonymous> mod(const typed::val<Anonymous> &mod) const;
  inline typed::aff<Domain, Anonymous> mod(long mod) const;
  inline typed::aff<Domain, Anonymous> neg() const;
  inline typed::set<> params() const;
  inline typed::pw_multi_aff<Domain, Anonymous> preimage_domain_wrapped_domain(const typed::pw_multi_aff<> &pma2) const = delete;
  inline typed::union_pw_multi_aff<Domain, Anonymous> preimage_domain_wrapped_domain(const typed::union_pw_multi_aff<> &upma2) const = delete;
  template <typename Domain2, typename Range2>
  inline typed::multi_aff<pair<Domain, Domain2>, pair<Anonymous, Range2>> product(const typed::multi_aff<Domain2, Range2> &multi2) const;
  template <typename Domain2, typename Range2>
  inline typed::multi_pw_aff<pair<Domain, Domain2>, pair<Anonymous, Range2>> product(const typed::multi_pw_aff<Domain2, Range2> &multi2) const;
  template <typename Domain2, typename Range2>
  inline typed::pw_multi_aff<pair<Domain, Domain2>, pair<Anonymous, Range2>> product(const typed::pw_multi_aff<Domain2, Range2> &pma2) const;
  template <typename Domain2>
  inline typed::aff<Domain2, Anonymous> pullback(const typed::multi_aff<Domain2, Domain> &ma) const;
  inline typed::aff<Anonymous> pullback(const typed::multi_aff<Domain> &ma) const;
  template <typename Domain2>
  inline typed::pw_aff<Domain2, Anonymous> pullback(const typed::multi_pw_aff<Domain2, Domain> &mpa) const;
  inline typed::pw_aff<Anonymous> pullback(const typed::multi_pw_aff<Domain> &mpa) const;
  template <typename Domain2>
  inline typed::pw_aff<Domain2, Anonymous> pullback(const typed::pw_multi_aff<Domain2, Domain> &pma) const;
  inline typed::pw_aff<Anonymous> pullback(const typed::pw_multi_aff<Domain> &pma) const;
  template <typename Domain2>
  inline typed::union_pw_aff<Domain2, Anonymous> pullback(const typed::union_pw_multi_aff<Domain2, Domain> &upma) const;
  inline typed::union_pw_aff<Anonymous> pullback(const typed::union_pw_multi_aff<Domain> &upma) const;
  template <typename Domain2>
  inline typed::aff<Domain2, Anonymous> pullback(const typed::aff<Domain2, Domain> &ma) const;
  inline typed::aff<Anonymous> pullback(const typed::aff<Domain> &ma) const;
  inline typed::pw_multi_aff_list<Domain, Anonymous> pw_multi_aff_list() const;
  inline typed::pw_multi_aff<Domain, Anonymous> range_factor_domain() const = delete;
  inline typed::pw_multi_aff<Domain, Anonymous> range_factor_range() const = delete;
  template <typename Range2>
  inline typed::multi_aff<Domain, pair<Anonymous, Range2>> range_product(const typed::multi_aff<Domain, Range2> &multi2) const;
  template <typename Range2>
  inline typed::multi_pw_aff<Domain, pair<Anonymous, Range2>> range_product(const typed::multi_pw_aff<Domain, Range2> &multi2) const;
  template <typename Range2>
  inline typed::multi_union_pw_aff<Domain, pair<Anonymous, Range2>> range_product(const typed::multi_union_pw_aff<Domain, Range2> &multi2) const;
  template <typename Range2>
  inline typed::pw_multi_aff<Domain, pair<Anonymous, Range2>> range_product(const typed::pw_multi_aff<Domain, Range2> &pma2) const;
  template <typename Range2>
  inline typed::union_pw_multi_aff<Domain, pair<Anonymous, Range2>> range_product(const typed::union_pw_multi_aff<Domain, Range2> &upma2) const;
  inline typed::aff<Domain, Anonymous> scale(const typed::val<Anonymous> &v) const;
  inline typed::aff<Domain, Anonymous> scale(long v) const;
  inline typed::multi_aff<Domain, Anonymous> scale(const typed::multi_val<Anonymous> &mv) const;
  inline typed::aff<Domain, Anonymous> scale_down(const typed::val<Anonymous> &v) const;
  inline typed::aff<Domain, Anonymous> scale_down(long v) const;
  inline typed::multi_aff<Domain, Anonymous> scale_down(const typed::multi_val<Anonymous> &mv) const;
  inline typed::multi_aff<Domain, Anonymous> set_at(int pos, const typed::aff<Domain, Anonymous> &el) const;
  inline typed::multi_pw_aff<Domain, Anonymous> set_at(int pos, const typed::pw_aff<Domain, Anonymous> &el) const;
  inline typed::multi_union_pw_aff<Domain, Anonymous> set_at(int pos, const typed::union_pw_aff<Domain, Anonymous> &el) const;
  template <typename Range2>
  inline typed::multi_aff<Domain, Range2> set_range_tuple(const typed::id<Anonymous> &id) const;
  template <typename Range2>
  inline typed::multi_aff<Domain, Range2> set_range_tuple(const std::string &id) const;
  inline typed::space<Domain, Anonymous> space() const;
  inline typed::aff<Domain, Anonymous> sub(const typed::aff<Domain, Anonymous> &aff2) const;
  inline typed::multi_aff<Domain, Anonymous> sub(const typed::multi_aff<Domain, Anonymous> &multi2) const;
  inline typed::multi_pw_aff<Domain, Anonymous> sub(const typed::multi_pw_aff<Domain, Anonymous> &multi2) const;
  inline typed::multi_union_pw_aff<Domain, Anonymous> sub(const typed::multi_union_pw_aff<Domain, Anonymous> &multi2) const;
  inline typed::pw_aff<Domain, Anonymous> sub(const typed::pw_aff<Domain, Anonymous> &pwaff2) const;
  inline typed::pw_multi_aff<Domain, Anonymous> sub(const typed::pw_multi_aff<Domain, Anonymous> &pma2) const;
  inline typed::union_pw_aff<Domain, Anonymous> sub(const typed::union_pw_aff<Domain, Anonymous> &upa2) const;
  inline typed::union_pw_multi_aff<Domain, Anonymous> sub(const typed::union_pw_multi_aff<Domain, Anonymous> &upma2) const;
  inline typed::pw_aff<Domain, Anonymous> subtract_domain(const typed::set<Domain> &set) const;
  inline typed::union_pw_aff<Domain, Anonymous> subtract_domain(const typed::space<Domain> &space) const;
  inline typed::union_pw_aff<Domain, Anonymous> subtract_domain(const typed::union_set<Domain> &uset) const;
  inline typed::multi_pw_aff<Domain, Anonymous> to_multi_pw_aff() const;
  inline typed::multi_union_pw_aff<Domain, Anonymous> to_multi_union_pw_aff() const;
  inline typed::pw_multi_aff<Domain, Anonymous> to_pw_multi_aff() const;
  inline typed::union_pw_aff<Domain, Anonymous> to_union_pw_aff() const;
  inline typed::union_pw_multi_aff<Domain, Anonymous> to_union_pw_multi_aff() const;
  inline typed::aff<Domain, Anonymous> unbind_params_insert_domain(const typed::multi_id<> &domain) const = delete;
  inline typed::multi_pw_aff<Domain, Anonymous> union_add(const typed::multi_pw_aff<Domain, Anonymous> &mpa2) const;
  inline typed::multi_union_pw_aff<Domain, Anonymous> union_add(const typed::multi_union_pw_aff<Domain, Anonymous> &mupa2) const;
  inline typed::pw_aff<Domain, Anonymous> union_add(const typed::pw_aff<Domain, Anonymous> &pwaff2) const;
  inline typed::pw_multi_aff<Domain, Anonymous> union_add(const typed::pw_multi_aff<Domain, Anonymous> &pma2) const;
  inline typed::union_pw_aff<Domain, Anonymous> union_add(const typed::union_pw_aff<Domain, Anonymous> &upa2) const;
  inline typed::union_pw_multi_aff<Domain, Anonymous> union_add(const typed::union_pw_multi_aff<Domain, Anonymous> &upma2) const;
};

template <typename Domain2, typename Range2>
struct aff<pair<Domain2, Range2>, Anonymous> : public isl::aff {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  aff() = default;
  template <typename Arg1, typename Arg2,
            typename std::enable_if<
              std::is_base_of<Domain2, Arg1>{} &&
              std::is_base_of<Range2, Arg2>{},
            bool>::type = true>
  aff(const aff<pair<Arg1, Arg2>, Anonymous> &obj) : isl::aff(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::aff>{}, bool>::type = true>
  aff(const base &obj) : isl::aff(obj) {}
 public:
  static aff from(const isl::aff &obj) {
    return aff(obj);
  }
  inline explicit aff(const isl::ctx &ctx, const std::string &str);
  inline typed::aff<pair<Domain2, Range2>, Anonymous> add(const typed::aff<pair<Domain2, Range2>, Anonymous> &aff2) const;
  inline typed::multi_aff<pair<Domain2, Range2>, Anonymous> add(const typed::multi_aff<pair<Domain2, Range2>, Anonymous> &multi2) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Anonymous> add(const typed::multi_pw_aff<pair<Domain2, Range2>, Anonymous> &multi2) const;
  inline typed::multi_union_pw_aff<pair<Domain2, Range2>, Anonymous> add(const typed::multi_union_pw_aff<pair<Domain2, Range2>, Anonymous> &multi2) const;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> add(const typed::pw_aff<pair<Domain2, Range2>, Anonymous> &pwaff2) const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Anonymous> add(const typed::pw_multi_aff<pair<Domain2, Range2>, Anonymous> &pma2) const;
  inline typed::union_pw_aff<pair<Domain2, Range2>, Anonymous> add(const typed::union_pw_aff<pair<Domain2, Range2>, Anonymous> &upa2) const;
  inline typed::union_pw_multi_aff<pair<Domain2, Range2>, Anonymous> add(const typed::union_pw_multi_aff<pair<Domain2, Range2>, Anonymous> &upma2) const;
  inline typed::aff<pair<Domain2, Range2>, Anonymous> add_constant(const typed::val<Anonymous> &v) const;
  inline typed::aff<pair<Domain2, Range2>, Anonymous> add_constant(long v) const;
  inline typed::multi_aff<pair<Domain2, Range2>, Anonymous> add_constant(const typed::multi_val<Anonymous> &mv) const;
  template <typename Arg1>
  inline typed::union_pw_multi_aff<pair<Domain2, Range2>, Arg1> apply(const typed::union_pw_multi_aff<Anonymous, Arg1> &upma2) const;
  inline typed::aff<pair<Domain2, Range2>, Anonymous> as_aff() const;
  inline typed::map<pair<Domain2, Range2>, Anonymous> as_map() const;
  inline typed::multi_aff<pair<Domain2, Range2>, Anonymous> as_multi_aff() const;
  inline typed::multi_union_pw_aff<pair<Domain2, Range2>, Anonymous> as_multi_union_pw_aff() const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Anonymous> as_pw_multi_aff() const;
  inline typed::set<pair<Domain2, Range2>, Anonymous> as_set() const = delete;
  inline typed::union_map<pair<Domain2, Range2>, Anonymous> as_union_map() const;
  inline typed::aff<pair<Domain2, Range2>, Anonymous> at(int pos) const;
  inline typed::basic_set<pair<Domain2, Range2>> bind(const typed::id<Anonymous> &id) const;
  inline typed::basic_set<pair<Domain2, Range2>> bind(const std::string &id) const;
  inline typed::basic_set<pair<Domain2, Range2>> bind(const typed::multi_id<Anonymous> &tuple) const;
  inline typed::pw_aff<Anonymous> bind_domain(const typed::multi_id<pair<Domain2, Range2>> &tuple) const;
  inline typed::pw_aff<Range2, Anonymous> bind_domain_wrapped_domain(const typed::multi_id<Domain2> &tuple) const;
  inline typed::aff<pair<Domain2, Range2>, Anonymous> ceil() const;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> coalesce() const;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> cond(const typed::pw_aff<pair<Domain2, Range2>, Anonymous> &pwaff_true, const typed::pw_aff<pair<Domain2, Range2>, Anonymous> &pwaff_false) const;
  inline typed::multi_val<Anonymous> constant_multi_val() const;
  inline typed::val<Anonymous> constant_val() const;
  inline typed::val<pair<Domain2, Range2>, Anonymous> get_constant_val() const = delete;
  inline typed::set<pair<Domain2, Range2>> domain() const;
  inline typed::aff<pair<Range2, Domain2>, Anonymous> domain_reverse() const;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> drop_unused_params() const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Anonymous> extract_pw_multi_aff(const typed::space<pair<Domain2, Range2>, Anonymous> &space) const;
  inline typed::aff<pair<Domain2, Range2>, Anonymous> floor() const;
  inline typed::set<pair<Domain2, Range2>> ge_set(const typed::aff<pair<Domain2, Range2>, Anonymous> &aff2) const;
  inline typed::set<pair<Domain2, Range2>> ge_set(const typed::pw_aff<pair<Domain2, Range2>, Anonymous> &pwaff2) const;
  inline typed::aff<pair<Domain2, Range2>, Anonymous> gist(const typed::set<pair<Domain2, Range2>> &context) const;
  inline typed::union_pw_aff<pair<Domain2, Range2>, Anonymous> gist(const typed::union_set<pair<Domain2, Range2>> &context) const;
  inline typed::aff<pair<Domain2, Range2>, Anonymous> gist(const typed::basic_set<pair<Domain2, Range2>> &context) const;
  inline typed::aff<pair<Domain2, Range2>, Anonymous> gist(const typed::point<pair<Domain2, Range2>> &context) const;
  inline typed::aff<pair<Domain2, Range2>, Anonymous> gist_params(const typed::set<> &context) const;
  inline typed::aff<pair<Domain2, Range2>, Anonymous> gist_params(const typed::basic_set<> &context) const;
  inline typed::aff<pair<Domain2, Range2>, Anonymous> gist_params(const typed::point<> &context) const;
  inline typed::set<pair<Domain2, Range2>> gt_set(const typed::aff<pair<Domain2, Range2>, Anonymous> &aff2) const;
  inline typed::set<pair<Domain2, Range2>> gt_set(const typed::pw_aff<pair<Domain2, Range2>, Anonymous> &pwaff2) const;
  inline typed::multi_aff<pair<Domain2, Range2>, Anonymous> identity() const;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> insert_domain(const typed::space<> &domain) const = delete;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> intersect_domain(const typed::set<pair<Domain2, Range2>> &set) const;
  inline typed::union_pw_aff<pair<Domain2, Range2>, Anonymous> intersect_domain(const typed::space<pair<Domain2, Range2>> &space) const;
  inline typed::union_pw_aff<pair<Domain2, Range2>, Anonymous> intersect_domain(const typed::union_set<pair<Domain2, Range2>> &uset) const;
  inline typed::union_pw_aff<pair<Domain2, Range2>, Anonymous> intersect_domain_wrapped_domain(const typed::union_set<Domain2> &uset) const;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> intersect_params(const typed::set<> &set) const;
  inline typed::set<pair<Domain2, Range2>> le_set(const typed::aff<pair<Domain2, Range2>, Anonymous> &aff2) const;
  inline typed::set<pair<Domain2, Range2>> le_set(const typed::pw_aff<pair<Domain2, Range2>, Anonymous> &pwaff2) const;
  inline typed::aff_list<pair<Domain2, Range2>, Anonymous> list() const;
  inline typed::set<pair<Domain2, Range2>> lt_set(const typed::aff<pair<Domain2, Range2>, Anonymous> &aff2) const;
  inline typed::set<pair<Domain2, Range2>> lt_set(const typed::pw_aff<pair<Domain2, Range2>, Anonymous> &pwaff2) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Anonymous> max(const typed::multi_pw_aff<pair<Domain2, Range2>, Anonymous> &multi2) const;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> max(const typed::pw_aff<pair<Domain2, Range2>, Anonymous> &pwaff2) const;
  inline typed::multi_val<Anonymous> max_multi_val() const;
  inline typed::val<Anonymous> max_val() const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Anonymous> min(const typed::multi_pw_aff<pair<Domain2, Range2>, Anonymous> &multi2) const;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> min(const typed::pw_aff<pair<Domain2, Range2>, Anonymous> &pwaff2) const;
  inline typed::multi_val<Anonymous> min_multi_val() const;
  inline typed::val<Anonymous> min_val() const;
  inline typed::aff<pair<Domain2, Range2>, Anonymous> mod(const typed::val<Anonymous> &mod) const;
  inline typed::aff<pair<Domain2, Range2>, Anonymous> mod(long mod) const;
  inline typed::aff<pair<Domain2, Range2>, Anonymous> neg() const;
  inline typed::set<> params() const;
  template <typename Domain3>
  inline typed::pw_multi_aff<pair<Domain3, Range2>, Anonymous> preimage_domain_wrapped_domain(const typed::pw_multi_aff<Domain3, Domain2> &pma2) const;
  template <typename Domain3>
  inline typed::union_pw_multi_aff<pair<Domain3, Range2>, Anonymous> preimage_domain_wrapped_domain(const typed::union_pw_multi_aff<Domain3, Domain2> &upma2) const;
  template <typename Arg1, typename Arg2>
  inline typed::multi_aff<pair<pair<Domain2, Range2>, Arg1>, pair<Anonymous, Arg2>> product(const typed::multi_aff<Arg1, Arg2> &multi2) const;
  template <typename Arg1, typename Arg2>
  inline typed::multi_pw_aff<pair<pair<Domain2, Range2>, Arg1>, pair<Anonymous, Arg2>> product(const typed::multi_pw_aff<Arg1, Arg2> &multi2) const;
  template <typename Arg1, typename Arg2>
  inline typed::pw_multi_aff<pair<pair<Domain2, Range2>, Arg1>, pair<Anonymous, Arg2>> product(const typed::pw_multi_aff<Arg1, Arg2> &pma2) const;
  template <typename Arg1>
  inline typed::aff<Arg1, Anonymous> pullback(const typed::multi_aff<Arg1, pair<Domain2, Range2>> &ma) const;
  inline typed::aff<Anonymous> pullback(const typed::multi_aff<pair<Domain2, Range2>> &ma) const;
  template <typename Arg1>
  inline typed::pw_aff<Arg1, Anonymous> pullback(const typed::multi_pw_aff<Arg1, pair<Domain2, Range2>> &mpa) const;
  inline typed::pw_aff<Anonymous> pullback(const typed::multi_pw_aff<pair<Domain2, Range2>> &mpa) const;
  template <typename Arg1>
  inline typed::pw_aff<Arg1, Anonymous> pullback(const typed::pw_multi_aff<Arg1, pair<Domain2, Range2>> &pma) const;
  inline typed::pw_aff<Anonymous> pullback(const typed::pw_multi_aff<pair<Domain2, Range2>> &pma) const;
  template <typename Arg1>
  inline typed::union_pw_aff<Arg1, Anonymous> pullback(const typed::union_pw_multi_aff<Arg1, pair<Domain2, Range2>> &upma) const;
  inline typed::union_pw_aff<Anonymous> pullback(const typed::union_pw_multi_aff<pair<Domain2, Range2>> &upma) const;
  template <typename Arg1>
  inline typed::aff<Arg1, Anonymous> pullback(const typed::aff<Arg1, pair<Domain2, Range2>> &ma) const;
  inline typed::aff<Anonymous> pullback(const typed::aff<pair<Domain2, Range2>> &ma) const;
  inline typed::pw_multi_aff_list<pair<Domain2, Range2>, Anonymous> pw_multi_aff_list() const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Anonymous> range_factor_domain() const = delete;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Anonymous> range_factor_range() const = delete;
  template <typename Arg1>
  inline typed::multi_aff<pair<Domain2, Range2>, pair<Anonymous, Arg1>> range_product(const typed::multi_aff<pair<Domain2, Range2>, Arg1> &multi2) const;
  template <typename Arg1>
  inline typed::multi_pw_aff<pair<Domain2, Range2>, pair<Anonymous, Arg1>> range_product(const typed::multi_pw_aff<pair<Domain2, Range2>, Arg1> &multi2) const;
  template <typename Arg1>
  inline typed::multi_union_pw_aff<pair<Domain2, Range2>, pair<Anonymous, Arg1>> range_product(const typed::multi_union_pw_aff<pair<Domain2, Range2>, Arg1> &multi2) const;
  template <typename Arg1>
  inline typed::pw_multi_aff<pair<Domain2, Range2>, pair<Anonymous, Arg1>> range_product(const typed::pw_multi_aff<pair<Domain2, Range2>, Arg1> &pma2) const;
  template <typename Arg1>
  inline typed::union_pw_multi_aff<pair<Domain2, Range2>, pair<Anonymous, Arg1>> range_product(const typed::union_pw_multi_aff<pair<Domain2, Range2>, Arg1> &upma2) const;
  inline typed::aff<pair<Domain2, Range2>, Anonymous> scale(const typed::val<Anonymous> &v) const;
  inline typed::aff<pair<Domain2, Range2>, Anonymous> scale(long v) const;
  inline typed::multi_aff<pair<Domain2, Range2>, Anonymous> scale(const typed::multi_val<Anonymous> &mv) const;
  inline typed::aff<pair<Domain2, Range2>, Anonymous> scale_down(const typed::val<Anonymous> &v) const;
  inline typed::aff<pair<Domain2, Range2>, Anonymous> scale_down(long v) const;
  inline typed::multi_aff<pair<Domain2, Range2>, Anonymous> scale_down(const typed::multi_val<Anonymous> &mv) const;
  inline typed::multi_aff<pair<Domain2, Range2>, Anonymous> set_at(int pos, const typed::aff<pair<Domain2, Range2>, Anonymous> &el) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Anonymous> set_at(int pos, const typed::pw_aff<pair<Domain2, Range2>, Anonymous> &el) const;
  inline typed::multi_union_pw_aff<pair<Domain2, Range2>, Anonymous> set_at(int pos, const typed::union_pw_aff<pair<Domain2, Range2>, Anonymous> &el) const;
  template <typename Arg1>
  inline typed::multi_aff<pair<Domain2, Range2>, Arg1> set_range_tuple(const typed::id<Anonymous> &id) const;
  template <typename Arg1>
  inline typed::multi_aff<pair<Domain2, Range2>, Arg1> set_range_tuple(const std::string &id) const;
  inline typed::space<pair<Domain2, Range2>, Anonymous> space() const;
  inline typed::aff<pair<Domain2, Range2>, Anonymous> sub(const typed::aff<pair<Domain2, Range2>, Anonymous> &aff2) const;
  inline typed::multi_aff<pair<Domain2, Range2>, Anonymous> sub(const typed::multi_aff<pair<Domain2, Range2>, Anonymous> &multi2) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Anonymous> sub(const typed::multi_pw_aff<pair<Domain2, Range2>, Anonymous> &multi2) const;
  inline typed::multi_union_pw_aff<pair<Domain2, Range2>, Anonymous> sub(const typed::multi_union_pw_aff<pair<Domain2, Range2>, Anonymous> &multi2) const;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> sub(const typed::pw_aff<pair<Domain2, Range2>, Anonymous> &pwaff2) const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Anonymous> sub(const typed::pw_multi_aff<pair<Domain2, Range2>, Anonymous> &pma2) const;
  inline typed::union_pw_aff<pair<Domain2, Range2>, Anonymous> sub(const typed::union_pw_aff<pair<Domain2, Range2>, Anonymous> &upa2) const;
  inline typed::union_pw_multi_aff<pair<Domain2, Range2>, Anonymous> sub(const typed::union_pw_multi_aff<pair<Domain2, Range2>, Anonymous> &upma2) const;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> subtract_domain(const typed::set<pair<Domain2, Range2>> &set) const;
  inline typed::union_pw_aff<pair<Domain2, Range2>, Anonymous> subtract_domain(const typed::space<pair<Domain2, Range2>> &space) const;
  inline typed::union_pw_aff<pair<Domain2, Range2>, Anonymous> subtract_domain(const typed::union_set<pair<Domain2, Range2>> &uset) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Anonymous> to_multi_pw_aff() const;
  inline typed::multi_union_pw_aff<pair<Domain2, Range2>, Anonymous> to_multi_union_pw_aff() const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Anonymous> to_pw_multi_aff() const;
  inline typed::union_pw_aff<pair<Domain2, Range2>, Anonymous> to_union_pw_aff() const;
  inline typed::union_pw_multi_aff<pair<Domain2, Range2>, Anonymous> to_union_pw_multi_aff() const;
  inline typed::aff<pair<Domain2, Range2>, Anonymous> unbind_params_insert_domain(const typed::multi_id<> &domain) const = delete;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Anonymous> union_add(const typed::multi_pw_aff<pair<Domain2, Range2>, Anonymous> &mpa2) const;
  inline typed::multi_union_pw_aff<pair<Domain2, Range2>, Anonymous> union_add(const typed::multi_union_pw_aff<pair<Domain2, Range2>, Anonymous> &mupa2) const;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> union_add(const typed::pw_aff<pair<Domain2, Range2>, Anonymous> &pwaff2) const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Anonymous> union_add(const typed::pw_multi_aff<pair<Domain2, Range2>, Anonymous> &pma2) const;
  inline typed::union_pw_aff<pair<Domain2, Range2>, Anonymous> union_add(const typed::union_pw_aff<pair<Domain2, Range2>, Anonymous> &upa2) const;
  inline typed::union_pw_multi_aff<pair<Domain2, Range2>, Anonymous> union_add(const typed::union_pw_multi_aff<pair<Domain2, Range2>, Anonymous> &upma2) const;
};

template <>
struct aff_list<Anonymous> : public isl::aff_list {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  aff_list() = default;
  aff_list(const isl::aff_list &obj) : isl::aff_list(obj) {}
  static aff_list from(const isl::aff_list &obj) {
    return aff_list(obj);
  }
  inline explicit aff_list(const isl::ctx &ctx, int n);
  inline explicit aff_list(const typed::aff<Anonymous> &el);
  inline explicit aff_list(const isl::ctx &ctx, const std::string &str);
  inline typed::aff_list<Anonymous> add(const typed::aff<Anonymous> &el) const;
  inline typed::aff<Anonymous> at(int index) const;
  inline typed::aff<Anonymous> get_at(int index) const = delete;
  inline typed::aff_list<Anonymous> drop(unsigned int first, unsigned int n) const;
  inline void foreach(const std::function<void(typed::aff<Anonymous>)> &fn) const;
  inline void foreach_scc(const std::function<bool(typed::aff<Anonymous>, typed::aff<Anonymous>)> &follows, const std::function<void(typed::aff_list<Anonymous>)> &fn) const;
  inline typed::aff_list<Anonymous> set_at(int index, const typed::aff<Anonymous> &el) const;
};

template <typename Domain>
struct aff_list<Domain, Anonymous> : public isl::aff_list {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  aff_list() = default;
  template <typename Arg1,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{},
            bool>::type = true>
  aff_list(const aff_list<Arg1, Anonymous> &obj) : isl::aff_list(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::aff_list>{}, bool>::type = true>
  aff_list(const base &obj) : isl::aff_list(obj) {}
 public:
  static aff_list from(const isl::aff_list &obj) {
    return aff_list(obj);
  }
  inline explicit aff_list(const isl::ctx &ctx, int n);
  inline explicit aff_list(const typed::aff<Domain, Anonymous> &el);
  inline explicit aff_list(const isl::ctx &ctx, const std::string &str);
  inline typed::aff_list<Domain, Anonymous> add(const typed::aff<Domain, Anonymous> &el) const;
  inline typed::aff<Domain, Anonymous> at(int index) const;
  inline typed::aff<Domain, Anonymous> get_at(int index) const = delete;
  inline typed::aff_list<Domain, Anonymous> drop(unsigned int first, unsigned int n) const;
  inline void foreach(const std::function<void(typed::aff<Domain, Anonymous>)> &fn) const;
  inline void foreach_scc(const std::function<bool(typed::aff<Domain, Anonymous>, typed::aff<Domain, Anonymous>)> &follows, const std::function<void(typed::aff_list<Domain, Anonymous>)> &fn) const;
  inline typed::aff_list<Domain, Anonymous> set_at(int index, const typed::aff<Domain, Anonymous> &el) const;
};

template <typename Domain, typename Range>
struct basic_map<Domain, Range> : public isl::basic_map {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  basic_map() = default;
  template <typename Arg1, typename Arg2,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{} &&
              std::is_base_of<Range, Arg2>{},
            bool>::type = true>
  basic_map(const basic_map<Arg1, Arg2> &obj) : isl::basic_map(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::basic_map>{}, bool>::type = true>
  basic_map(const base &obj) : isl::basic_map(obj) {}
 public:
  static basic_map from(const isl::basic_map &obj) {
    return basic_map(obj);
  }
  inline explicit basic_map(const isl::ctx &ctx, const std::string &str);
  template <typename Domain2>
  inline typed::basic_map<Domain2, Range> apply_domain(const typed::basic_map<Domain, Domain2> &bmap2) const;
  template <typename Domain2>
  inline typed::map<Domain2, Range> apply_domain(const typed::map<Domain, Domain2> &map2) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, Range> apply_domain(const typed::union_map<Domain, Domain2> &umap2) const;
  template <typename Range2>
  inline typed::basic_map<Domain, Range2> apply_range(const typed::basic_map<Range, Range2> &bmap2) const;
  template <typename Range2>
  inline typed::map<Domain, Range2> apply_range(const typed::map<Range, Range2> &map2) const;
  template <typename Range2>
  inline typed::union_map<Domain, Range2> apply_range(const typed::union_map<Range, Range2> &umap2) const;
  inline typed::map<Domain, Range> as_map() const;
  inline typed::multi_union_pw_aff<Domain, Range> as_multi_union_pw_aff() const;
  inline typed::pw_multi_aff<Domain, Range> as_pw_multi_aff() const;
  inline typed::union_pw_multi_aff<Domain, Range> as_union_pw_multi_aff() const;
  inline typed::set<Range> bind_domain(const typed::multi_id<Domain> &tuple) const;
  inline typed::set<Domain> bind_range(const typed::multi_id<Range> &tuple) const;
  inline typed::map<Domain, Range> coalesce() const;
  inline typed::map<Domain, Range> curry() const = delete;
  inline typed::basic_set<Domain, Range> deltas() const = delete;
  inline typed::basic_map<Domain, Range> detect_equalities() const;
  inline typed::set<Domain> domain() const;
  inline typed::map<Domain, Range> domain_factor_domain() const = delete;
  inline typed::map<Domain, Range> domain_factor_range() const = delete;
  inline typed::union_map<pair<Domain, Range>, Domain> domain_map() const;
  inline typed::union_pw_multi_aff<pair<Domain, Range>, Domain> domain_map_union_pw_multi_aff() const;
  template <typename Domain2>
  inline typed::map<pair<Domain, Domain2>, Range> domain_product(const typed::map<Domain2, Range> &map2) const;
  template <typename Domain2>
  inline typed::union_map<pair<Domain, Domain2>, Range> domain_product(const typed::union_map<Domain2, Range> &umap2) const;
  inline typed::map<Domain, Range> domain_reverse() const = delete;
  inline typed::map<Domain, Range> drop_unused_params() const;
  inline typed::map<Domain, Range> eq_at(const typed::multi_pw_aff<> &mpa) const = delete;
  inline typed::union_map<Domain, Range> eq_at(const typed::multi_union_pw_aff<> &mupa) const = delete;
  inline bool every_map(const std::function<bool(typed::map<Domain, Range>)> &test) const;
  inline typed::map<Domain, Range> extract_map(const typed::space<Domain, Range> &space) const;
  inline typed::basic_map<Domain, Range> flatten_domain() const = delete;
  inline typed::basic_map<Domain, Range> flatten_range() const = delete;
  inline void foreach_basic_map(const std::function<void(typed::basic_map<Domain, Range>)> &fn) const;
  inline void foreach_map(const std::function<void(typed::map<Domain, Range>)> &fn) const;
  inline typed::basic_map<Domain, Range> gist(const typed::basic_map<Domain, Range> &context) const;
  inline typed::map<Domain, Range> gist(const typed::map<Domain, Range> &context) const;
  inline typed::union_map<Domain, Range> gist(const typed::union_map<Domain, Range> &context) const;
  inline typed::map<Domain, Range> gist_domain(const typed::set<Domain> &context) const;
  inline typed::union_map<Domain, Range> gist_domain(const typed::union_set<Domain> &uset) const;
  inline typed::map<Domain, Range> gist_params(const typed::set<> &context) const;
  inline typed::basic_map<Domain, Range> intersect(const typed::basic_map<Domain, Range> &bmap2) const;
  inline typed::map<Domain, Range> intersect(const typed::map<Domain, Range> &map2) const;
  inline typed::union_map<Domain, Range> intersect(const typed::union_map<Domain, Range> &umap2) const;
  inline typed::basic_map<Domain, Range> intersect_domain(const typed::basic_set<Domain> &bset) const;
  inline typed::map<Domain, Range> intersect_domain(const typed::set<Domain> &set) const;
  inline typed::union_map<Domain, Range> intersect_domain(const typed::space<Domain> &space) const;
  inline typed::union_map<Domain, Range> intersect_domain(const typed::union_set<Domain> &uset) const;
  inline typed::basic_map<Domain, Range> intersect_domain(const typed::point<Domain> &bset) const;
  inline typed::map<Domain, Range> intersect_domain_wrapped_domain(const typed::set<> &domain) const = delete;
  inline typed::union_map<Domain, Range> intersect_domain_wrapped_domain(const typed::union_set<> &domain) const = delete;
  inline typed::map<Domain, Range> intersect_params(const typed::set<> &params) const;
  inline typed::basic_map<Domain, Range> intersect_range(const typed::basic_set<Range> &bset) const;
  inline typed::map<Domain, Range> intersect_range(const typed::set<Range> &set) const;
  inline typed::union_map<Domain, Range> intersect_range(const typed::space<Range> &space) const;
  inline typed::union_map<Domain, Range> intersect_range(const typed::union_set<Range> &uset) const;
  inline typed::basic_map<Domain, Range> intersect_range(const typed::point<Range> &bset) const;
  inline typed::map<Domain, Range> intersect_range_wrapped_domain(const typed::set<> &domain) const = delete;
  inline typed::union_map<Domain, Range> intersect_range_wrapped_domain(const typed::union_set<> &domain) const = delete;
  inline typed::map<Domain, Range> lex_ge_at(const typed::multi_pw_aff<> &mpa) const = delete;
  inline typed::map<Domain, Range> lex_gt_at(const typed::multi_pw_aff<> &mpa) const = delete;
  inline typed::map<Domain, Range> lex_le_at(const typed::multi_pw_aff<> &mpa) const = delete;
  inline typed::map<Domain, Range> lex_lt_at(const typed::multi_pw_aff<> &mpa) const = delete;
  inline typed::map<Domain, Range> lexmax() const;
  inline typed::pw_multi_aff<Domain, Range> lexmax_pw_multi_aff() const;
  inline typed::map<Domain, Range> lexmin() const;
  inline typed::pw_multi_aff<Domain, Range> lexmin_pw_multi_aff() const;
  inline typed::map<Domain, Range> lower_bound(const typed::multi_pw_aff<Domain, Range> &lower) const;
  inline typed::map_list<Domain, Range> map_list() const;
  inline typed::multi_pw_aff<Domain, Range> max_multi_pw_aff() const;
  inline typed::multi_pw_aff<Domain, Range> min_multi_pw_aff() const;
  inline typed::set<> params() const;
  template <typename Domain2>
  inline typed::map<Domain2, Range> preimage_domain(const typed::multi_aff<Domain2, Domain> &ma) const;
  template <typename Domain2>
  inline typed::map<Domain2, Range> preimage_domain(const typed::multi_pw_aff<Domain2, Domain> &mpa) const;
  template <typename Domain2>
  inline typed::map<Domain2, Range> preimage_domain(const typed::pw_multi_aff<Domain2, Domain> &pma) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, Range> preimage_domain(const typed::union_pw_multi_aff<Domain2, Domain> &upma) const;
  template <typename Range2>
  inline typed::map<Domain, Range2> preimage_range(const typed::multi_aff<Range2, Range> &ma) const;
  template <typename Range2>
  inline typed::map<Domain, Range2> preimage_range(const typed::pw_multi_aff<Range2, Range> &pma) const;
  template <typename Range2>
  inline typed::union_map<Domain, Range2> preimage_range(const typed::union_pw_multi_aff<Range2, Range> &upma) const;
  template <typename Domain2, typename Range2>
  inline typed::map<pair<Domain, Domain2>, pair<Range, Range2>> product(const typed::map<Domain2, Range2> &map2) const;
  template <typename Domain2, typename Range2>
  inline typed::union_map<pair<Domain, Domain2>, pair<Range, Range2>> product(const typed::union_map<Domain2, Range2> &umap2) const;
  inline typed::map<Domain, Range> project_out_all_params() const;
  inline typed::map<Domain, Range> project_out_param(const typed::id<Anonymous> &id) const;
  inline typed::map<Domain, Range> project_out_param(const std::string &id) const;
  inline typed::map<Domain, Range> project_out_param(const typed::id_list<Anonymous> &list) const;
  inline typed::set<Range> range() const;
  inline typed::map<Domain, Range> range_factor_domain() const = delete;
  inline typed::map<Domain, Range> range_factor_range() const = delete;
  inline typed::fixed_box<Domain, Range> range_lattice_tile() const;
  inline typed::union_map<pair<Domain, Range>, Range> range_map() const;
  template <typename Range2>
  inline typed::map<Domain, pair<Range, Range2>> range_product(const typed::map<Domain, Range2> &map2) const;
  template <typename Range2>
  inline typed::union_map<Domain, pair<Range, Range2>> range_product(const typed::union_map<Domain, Range2> &umap2) const;
  inline typed::map<Domain, Range> range_reverse() const = delete;
  inline typed::fixed_box<Domain, Range> range_simple_fixed_box_hull() const;
  inline typed::basic_map<Range, Domain> reverse() const;
  template <typename Domain2>
  inline typed::map<Domain2, Range> set_domain_tuple(const typed::id<Anonymous> &id) const;
  template <typename Domain2>
  inline typed::map<Domain2, Range> set_domain_tuple(const std::string &id) const;
  template <typename Range2>
  inline typed::map<Domain, Range2> set_range_tuple(const typed::id<Anonymous> &id) const;
  template <typename Range2>
  inline typed::map<Domain, Range2> set_range_tuple(const std::string &id) const;
  inline typed::space<Domain, Range> space() const;
  inline typed::map<Domain, Range> subtract(const typed::map<Domain, Range> &map2) const;
  inline typed::union_map<Domain, Range> subtract(const typed::union_map<Domain, Range> &umap2) const;
  inline typed::union_map<Domain, Range> subtract_domain(const typed::union_set<Domain> &dom) const;
  inline typed::union_map<Domain, Range> subtract_range(const typed::union_set<Range> &dom) const;
  inline typed::union_map<Domain, Range> to_union_map() const;
  inline typed::map<Domain, Range> uncurry() const = delete;
  inline typed::map<Domain, Range> unite(const typed::basic_map<Domain, Range> &bmap2) const;
  inline typed::map<Domain, Range> unite(const typed::map<Domain, Range> &map2) const;
  inline typed::union_map<Domain, Range> unite(const typed::union_map<Domain, Range> &umap2) const;
  inline typed::map<Domain, Range> upper_bound(const typed::multi_pw_aff<Domain, Range> &upper) const;
  inline typed::set<pair<Domain, Range>> wrap() const;
};

template <typename Domain, typename Range, typename Range2>
struct basic_map<pair<Domain, Range>, Range2> : public isl::basic_map {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  basic_map() = default;
  template <typename Arg1, typename Arg2, typename Arg3,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{} &&
              std::is_base_of<Range, Arg2>{} &&
              std::is_base_of<Range2, Arg3>{},
            bool>::type = true>
  basic_map(const basic_map<pair<Arg1, Arg2>, Arg3> &obj) : isl::basic_map(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::basic_map>{}, bool>::type = true>
  basic_map(const base &obj) : isl::basic_map(obj) {}
 public:
  static basic_map from(const isl::basic_map &obj) {
    return basic_map(obj);
  }
  inline explicit basic_map(const isl::ctx &ctx, const std::string &str);
  template <typename Domain2>
  inline typed::basic_map<Domain2, Range2> apply_domain(const typed::basic_map<pair<Domain, Range>, Domain2> &bmap2) const;
  template <typename Domain2>
  inline typed::map<Domain2, Range2> apply_domain(const typed::map<pair<Domain, Range>, Domain2> &map2) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, Range2> apply_domain(const typed::union_map<pair<Domain, Range>, Domain2> &umap2) const;
  template <typename Arg3>
  inline typed::basic_map<pair<Domain, Range>, Arg3> apply_range(const typed::basic_map<Range2, Arg3> &bmap2) const;
  template <typename Arg3>
  inline typed::map<pair<Domain, Range>, Arg3> apply_range(const typed::map<Range2, Arg3> &map2) const;
  template <typename Arg3>
  inline typed::union_map<pair<Domain, Range>, Arg3> apply_range(const typed::union_map<Range2, Arg3> &umap2) const;
  inline typed::map<pair<Domain, Range>, Range2> as_map() const;
  inline typed::multi_union_pw_aff<pair<Domain, Range>, Range2> as_multi_union_pw_aff() const;
  inline typed::pw_multi_aff<pair<Domain, Range>, Range2> as_pw_multi_aff() const;
  inline typed::union_pw_multi_aff<pair<Domain, Range>, Range2> as_union_pw_multi_aff() const;
  inline typed::set<Range2> bind_domain(const typed::multi_id<pair<Domain, Range>> &tuple) const;
  inline typed::set<pair<Domain, Range>> bind_range(const typed::multi_id<Range2> &tuple) const;
  inline typed::map<pair<Domain, Range>, Range2> coalesce() const;
  inline typed::map<Domain, pair<Range, Range2>> curry() const;
  inline typed::basic_set<pair<Domain, Range>, Range2> deltas() const = delete;
  inline typed::basic_map<pair<Domain, Range>, Range2> detect_equalities() const;
  inline typed::set<pair<Domain, Range>> domain() const;
  inline typed::map<Domain, Range2> domain_factor_domain() const;
  inline typed::map<Range, Range2> domain_factor_range() const;
  inline typed::union_map<pair<pair<Domain, Range>, Range2>, pair<Domain, Range>> domain_map() const;
  inline typed::union_pw_multi_aff<pair<pair<Domain, Range>, Range2>, pair<Domain, Range>> domain_map_union_pw_multi_aff() const;
  template <typename Domain2>
  inline typed::map<pair<pair<Domain, Range>, Domain2>, Range2> domain_product(const typed::map<Domain2, Range2> &map2) const;
  template <typename Domain2>
  inline typed::union_map<pair<pair<Domain, Range>, Domain2>, Range2> domain_product(const typed::union_map<Domain2, Range2> &umap2) const;
  inline typed::map<pair<Range, Domain>, Range2> domain_reverse() const;
  inline typed::map<pair<Domain, Range>, Range2> drop_unused_params() const;
  inline typed::map<pair<Domain, Range>, Range2> eq_at(const typed::multi_pw_aff<> &mpa) const = delete;
  inline typed::union_map<pair<Domain, Range>, Range2> eq_at(const typed::multi_union_pw_aff<> &mupa) const = delete;
  inline bool every_map(const std::function<bool(typed::map<pair<Domain, Range>, Range2>)> &test) const;
  inline typed::map<pair<Domain, Range>, Range2> extract_map(const typed::space<pair<Domain, Range>, Range2> &space) const;
  inline typed::basic_map<Anonymous, Range2> flatten_domain() const;
  inline typed::basic_map<pair<Domain, Range>, Range2> flatten_range() const = delete;
  inline void foreach_basic_map(const std::function<void(typed::basic_map<pair<Domain, Range>, Range2>)> &fn) const;
  inline void foreach_map(const std::function<void(typed::map<pair<Domain, Range>, Range2>)> &fn) const;
  inline typed::basic_map<pair<Domain, Range>, Range2> gist(const typed::basic_map<pair<Domain, Range>, Range2> &context) const;
  inline typed::map<pair<Domain, Range>, Range2> gist(const typed::map<pair<Domain, Range>, Range2> &context) const;
  inline typed::union_map<pair<Domain, Range>, Range2> gist(const typed::union_map<pair<Domain, Range>, Range2> &context) const;
  inline typed::map<pair<Domain, Range>, Range2> gist_domain(const typed::set<pair<Domain, Range>> &context) const;
  inline typed::union_map<pair<Domain, Range>, Range2> gist_domain(const typed::union_set<pair<Domain, Range>> &uset) const;
  inline typed::map<pair<Domain, Range>, Range2> gist_params(const typed::set<> &context) const;
  inline typed::basic_map<pair<Domain, Range>, Range2> intersect(const typed::basic_map<pair<Domain, Range>, Range2> &bmap2) const;
  inline typed::map<pair<Domain, Range>, Range2> intersect(const typed::map<pair<Domain, Range>, Range2> &map2) const;
  inline typed::union_map<pair<Domain, Range>, Range2> intersect(const typed::union_map<pair<Domain, Range>, Range2> &umap2) const;
  inline typed::basic_map<pair<Domain, Range>, Range2> intersect_domain(const typed::basic_set<pair<Domain, Range>> &bset) const;
  inline typed::map<pair<Domain, Range>, Range2> intersect_domain(const typed::set<pair<Domain, Range>> &set) const;
  inline typed::union_map<pair<Domain, Range>, Range2> intersect_domain(const typed::space<pair<Domain, Range>> &space) const;
  inline typed::union_map<pair<Domain, Range>, Range2> intersect_domain(const typed::union_set<pair<Domain, Range>> &uset) const;
  inline typed::basic_map<pair<Domain, Range>, Range2> intersect_domain(const typed::point<pair<Domain, Range>> &bset) const;
  inline typed::map<pair<Domain, Range>, Range2> intersect_domain_wrapped_domain(const typed::set<Domain> &domain) const;
  inline typed::union_map<pair<Domain, Range>, Range2> intersect_domain_wrapped_domain(const typed::union_set<Domain> &domain) const;
  inline typed::map<pair<Domain, Range>, Range2> intersect_params(const typed::set<> &params) const;
  inline typed::basic_map<pair<Domain, Range>, Range2> intersect_range(const typed::basic_set<Range2> &bset) const;
  inline typed::map<pair<Domain, Range>, Range2> intersect_range(const typed::set<Range2> &set) const;
  inline typed::union_map<pair<Domain, Range>, Range2> intersect_range(const typed::space<Range2> &space) const;
  inline typed::union_map<pair<Domain, Range>, Range2> intersect_range(const typed::union_set<Range2> &uset) const;
  inline typed::basic_map<pair<Domain, Range>, Range2> intersect_range(const typed::point<Range2> &bset) const;
  inline typed::map<pair<Domain, Range>, Range2> intersect_range_wrapped_domain(const typed::set<> &domain) const = delete;
  inline typed::union_map<pair<Domain, Range>, Range2> intersect_range_wrapped_domain(const typed::union_set<> &domain) const = delete;
  inline typed::map<pair<Domain, Range>, Range2> lex_ge_at(const typed::multi_pw_aff<> &mpa) const = delete;
  inline typed::map<pair<Domain, Range>, Range2> lex_gt_at(const typed::multi_pw_aff<> &mpa) const = delete;
  inline typed::map<pair<Domain, Range>, Range2> lex_le_at(const typed::multi_pw_aff<> &mpa) const = delete;
  inline typed::map<pair<Domain, Range>, Range2> lex_lt_at(const typed::multi_pw_aff<> &mpa) const = delete;
  inline typed::map<pair<Domain, Range>, Range2> lexmax() const;
  inline typed::pw_multi_aff<pair<Domain, Range>, Range2> lexmax_pw_multi_aff() const;
  inline typed::map<pair<Domain, Range>, Range2> lexmin() const;
  inline typed::pw_multi_aff<pair<Domain, Range>, Range2> lexmin_pw_multi_aff() const;
  inline typed::map<pair<Domain, Range>, Range2> lower_bound(const typed::multi_pw_aff<pair<Domain, Range>, Range2> &lower) const;
  inline typed::map_list<pair<Domain, Range>, Range2> map_list() const;
  inline typed::multi_pw_aff<pair<Domain, Range>, Range2> max_multi_pw_aff() const;
  inline typed::multi_pw_aff<pair<Domain, Range>, Range2> min_multi_pw_aff() const;
  inline typed::set<> params() const;
  template <typename Domain2>
  inline typed::map<Domain2, Range2> preimage_domain(const typed::multi_aff<Domain2, pair<Domain, Range>> &ma) const;
  template <typename Domain2>
  inline typed::map<Domain2, Range2> preimage_domain(const typed::multi_pw_aff<Domain2, pair<Domain, Range>> &mpa) const;
  template <typename Domain2>
  inline typed::map<Domain2, Range2> preimage_domain(const typed::pw_multi_aff<Domain2, pair<Domain, Range>> &pma) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, Range2> preimage_domain(const typed::union_pw_multi_aff<Domain2, pair<Domain, Range>> &upma) const;
  template <typename Arg3>
  inline typed::map<pair<Domain, Range>, Arg3> preimage_range(const typed::multi_aff<Arg3, Range2> &ma) const;
  template <typename Arg3>
  inline typed::map<pair<Domain, Range>, Arg3> preimage_range(const typed::pw_multi_aff<Arg3, Range2> &pma) const;
  template <typename Arg3>
  inline typed::union_map<pair<Domain, Range>, Arg3> preimage_range(const typed::union_pw_multi_aff<Arg3, Range2> &upma) const;
  template <typename Domain2, typename Arg3>
  inline typed::map<pair<pair<Domain, Range>, Domain2>, pair<Range2, Arg3>> product(const typed::map<Domain2, Arg3> &map2) const;
  template <typename Domain2, typename Arg3>
  inline typed::union_map<pair<pair<Domain, Range>, Domain2>, pair<Range2, Arg3>> product(const typed::union_map<Domain2, Arg3> &umap2) const;
  inline typed::map<pair<Domain, Range>, Range2> project_out_all_params() const;
  inline typed::map<pair<Domain, Range>, Range2> project_out_param(const typed::id<Anonymous> &id) const;
  inline typed::map<pair<Domain, Range>, Range2> project_out_param(const std::string &id) const;
  inline typed::map<pair<Domain, Range>, Range2> project_out_param(const typed::id_list<Anonymous> &list) const;
  inline typed::set<Range2> range() const;
  inline typed::map<pair<Domain, Range>, Range2> range_factor_domain() const = delete;
  inline typed::map<pair<Domain, Range>, Range2> range_factor_range() const = delete;
  inline typed::fixed_box<pair<Domain, Range>, Range2> range_lattice_tile() const;
  inline typed::union_map<pair<pair<Domain, Range>, Range2>, Range2> range_map() const;
  template <typename Arg3>
  inline typed::map<pair<Domain, Range>, pair<Range2, Arg3>> range_product(const typed::map<pair<Domain, Range>, Arg3> &map2) const;
  template <typename Arg3>
  inline typed::union_map<pair<Domain, Range>, pair<Range2, Arg3>> range_product(const typed::union_map<pair<Domain, Range>, Arg3> &umap2) const;
  inline typed::map<pair<Domain, Range>, Range2> range_reverse() const = delete;
  inline typed::fixed_box<pair<Domain, Range>, Range2> range_simple_fixed_box_hull() const;
  inline typed::basic_map<Range2, pair<Domain, Range>> reverse() const;
  inline typed::map<pair<Domain, Range>, Range2> set_domain_tuple(const typed::id<> &id) const = delete;
  inline typed::map<pair<Domain, Range>, Range2> set_domain_tuple(const std::string &id) const = delete;
  template <typename Arg2>
  inline typed::map<pair<Domain, Range>, Arg2> set_range_tuple(const typed::id<Anonymous> &id) const;
  template <typename Arg2>
  inline typed::map<pair<Domain, Range>, Arg2> set_range_tuple(const std::string &id) const;
  inline typed::space<pair<Domain, Range>, Range2> space() const;
  inline typed::map<pair<Domain, Range>, Range2> subtract(const typed::map<pair<Domain, Range>, Range2> &map2) const;
  inline typed::union_map<pair<Domain, Range>, Range2> subtract(const typed::union_map<pair<Domain, Range>, Range2> &umap2) const;
  inline typed::union_map<pair<Domain, Range>, Range2> subtract_domain(const typed::union_set<pair<Domain, Range>> &dom) const;
  inline typed::union_map<pair<Domain, Range>, Range2> subtract_range(const typed::union_set<Range2> &dom) const;
  inline typed::union_map<pair<Domain, Range>, Range2> to_union_map() const;
  inline typed::map<pair<Domain, Range>, Range2> uncurry() const = delete;
  inline typed::map<pair<Domain, Range>, Range2> unite(const typed::basic_map<pair<Domain, Range>, Range2> &bmap2) const;
  inline typed::map<pair<Domain, Range>, Range2> unite(const typed::map<pair<Domain, Range>, Range2> &map2) const;
  inline typed::union_map<pair<Domain, Range>, Range2> unite(const typed::union_map<pair<Domain, Range>, Range2> &umap2) const;
  inline typed::map<pair<Domain, Range>, Range2> upper_bound(const typed::multi_pw_aff<pair<Domain, Range>, Range2> &upper) const;
  inline typed::set<pair<pair<Domain, Range>, Range2>> wrap() const;
};

template <typename Domain>
struct basic_map<Domain, Domain> : public isl::basic_map {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  basic_map() = default;
  template <typename Arg1,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{},
            bool>::type = true>
  basic_map(const basic_map<Arg1, Arg1> &obj) : isl::basic_map(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::basic_map>{}, bool>::type = true>
  basic_map(const base &obj) : isl::basic_map(obj) {}
 public:
  static basic_map from(const isl::basic_map &obj) {
    return basic_map(obj);
  }
  inline explicit basic_map(const isl::ctx &ctx, const std::string &str);
  template <typename Domain2>
  inline typed::basic_map<Domain2, Domain> apply_domain(const typed::basic_map<Domain, Domain2> &bmap2) const;
  template <typename Domain2>
  inline typed::map<Domain2, Domain> apply_domain(const typed::map<Domain, Domain2> &map2) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, Domain> apply_domain(const typed::union_map<Domain, Domain2> &umap2) const;
  template <typename Range2>
  inline typed::basic_map<Domain, Range2> apply_range(const typed::basic_map<Domain, Range2> &bmap2) const;
  template <typename Range2>
  inline typed::map<Domain, Range2> apply_range(const typed::map<Domain, Range2> &map2) const;
  template <typename Range2>
  inline typed::union_map<Domain, Range2> apply_range(const typed::union_map<Domain, Range2> &umap2) const;
  inline typed::map<Domain, Domain> as_map() const;
  inline typed::multi_union_pw_aff<Domain, Domain> as_multi_union_pw_aff() const;
  inline typed::pw_multi_aff<Domain, Domain> as_pw_multi_aff() const;
  inline typed::union_pw_multi_aff<Domain, Domain> as_union_pw_multi_aff() const;
  inline typed::set<Domain> bind_domain(const typed::multi_id<Domain> &tuple) const;
  inline typed::set<Domain> bind_range(const typed::multi_id<Domain> &tuple) const;
  inline typed::map<Domain, Domain> coalesce() const;
  inline typed::map<Domain, Domain> curry() const = delete;
  inline typed::basic_set<Domain> deltas() const;
  inline typed::basic_map<Domain, Domain> detect_equalities() const;
  inline typed::set<Domain> domain() const;
  inline typed::map<Domain, Domain> domain_factor_domain() const = delete;
  inline typed::map<Domain, Domain> domain_factor_range() const = delete;
  inline typed::union_map<pair<Domain, Domain>, Domain> domain_map() const;
  inline typed::union_pw_multi_aff<pair<Domain, Domain>, Domain> domain_map_union_pw_multi_aff() const;
  template <typename Domain2>
  inline typed::map<pair<Domain, Domain2>, Domain> domain_product(const typed::map<Domain2, Domain> &map2) const;
  template <typename Domain2>
  inline typed::union_map<pair<Domain, Domain2>, Domain> domain_product(const typed::union_map<Domain2, Domain> &umap2) const;
  inline typed::map<Domain, Domain> domain_reverse() const = delete;
  inline typed::map<Domain, Domain> drop_unused_params() const;
  template <typename Range>
  inline typed::map<Domain, Domain> eq_at(const typed::multi_pw_aff<Domain, Range> &mpa) const;
  template <typename Range>
  inline typed::union_map<Domain, Domain> eq_at(const typed::multi_union_pw_aff<Domain, Range> &mupa) const;
  inline bool every_map(const std::function<bool(typed::map<Domain, Domain>)> &test) const;
  inline typed::map<Domain, Domain> extract_map(const typed::space<Domain, Domain> &space) const;
  inline typed::basic_map<Domain, Domain> flatten_domain() const = delete;
  inline typed::basic_map<Domain, Domain> flatten_range() const = delete;
  inline void foreach_basic_map(const std::function<void(typed::basic_map<Domain, Domain>)> &fn) const;
  inline void foreach_map(const std::function<void(typed::map<Domain, Domain>)> &fn) const;
  inline typed::basic_map<Domain, Domain> gist(const typed::basic_map<Domain, Domain> &context) const;
  inline typed::map<Domain, Domain> gist(const typed::map<Domain, Domain> &context) const;
  inline typed::union_map<Domain, Domain> gist(const typed::union_map<Domain, Domain> &context) const;
  inline typed::map<Domain, Domain> gist_domain(const typed::set<Domain> &context) const;
  inline typed::union_map<Domain, Domain> gist_domain(const typed::union_set<Domain> &uset) const;
  inline typed::map<Domain, Domain> gist_params(const typed::set<> &context) const;
  inline typed::basic_map<Domain, Domain> intersect(const typed::basic_map<Domain, Domain> &bmap2) const;
  inline typed::map<Domain, Domain> intersect(const typed::map<Domain, Domain> &map2) const;
  inline typed::union_map<Domain, Domain> intersect(const typed::union_map<Domain, Domain> &umap2) const;
  inline typed::basic_map<Domain, Domain> intersect_domain(const typed::basic_set<Domain> &bset) const;
  inline typed::map<Domain, Domain> intersect_domain(const typed::set<Domain> &set) const;
  inline typed::union_map<Domain, Domain> intersect_domain(const typed::space<Domain> &space) const;
  inline typed::union_map<Domain, Domain> intersect_domain(const typed::union_set<Domain> &uset) const;
  inline typed::basic_map<Domain, Domain> intersect_domain(const typed::point<Domain> &bset) const;
  inline typed::map<Domain, Domain> intersect_domain_wrapped_domain(const typed::set<> &domain) const = delete;
  inline typed::union_map<Domain, Domain> intersect_domain_wrapped_domain(const typed::union_set<> &domain) const = delete;
  inline typed::map<Domain, Domain> intersect_params(const typed::set<> &params) const;
  inline typed::basic_map<Domain, Domain> intersect_range(const typed::basic_set<Domain> &bset) const;
  inline typed::map<Domain, Domain> intersect_range(const typed::set<Domain> &set) const;
  inline typed::union_map<Domain, Domain> intersect_range(const typed::space<Domain> &space) const;
  inline typed::union_map<Domain, Domain> intersect_range(const typed::union_set<Domain> &uset) const;
  inline typed::basic_map<Domain, Domain> intersect_range(const typed::point<Domain> &bset) const;
  inline typed::map<Domain, Domain> intersect_range_wrapped_domain(const typed::set<> &domain) const = delete;
  inline typed::union_map<Domain, Domain> intersect_range_wrapped_domain(const typed::union_set<> &domain) const = delete;
  template <typename Range>
  inline typed::map<Domain, Domain> lex_ge_at(const typed::multi_pw_aff<Domain, Range> &mpa) const;
  template <typename Range>
  inline typed::map<Domain, Domain> lex_gt_at(const typed::multi_pw_aff<Domain, Range> &mpa) const;
  template <typename Range>
  inline typed::map<Domain, Domain> lex_le_at(const typed::multi_pw_aff<Domain, Range> &mpa) const;
  template <typename Range>
  inline typed::map<Domain, Domain> lex_lt_at(const typed::multi_pw_aff<Domain, Range> &mpa) const;
  inline typed::map<Domain, Domain> lexmax() const;
  inline typed::pw_multi_aff<Domain, Domain> lexmax_pw_multi_aff() const;
  inline typed::map<Domain, Domain> lexmin() const;
  inline typed::pw_multi_aff<Domain, Domain> lexmin_pw_multi_aff() const;
  inline typed::map<Domain, Domain> lower_bound(const typed::multi_pw_aff<Domain, Domain> &lower) const;
  inline typed::map_list<Domain, Domain> map_list() const;
  inline typed::multi_pw_aff<Domain, Domain> max_multi_pw_aff() const;
  inline typed::multi_pw_aff<Domain, Domain> min_multi_pw_aff() const;
  inline typed::set<> params() const;
  template <typename Domain2>
  inline typed::map<Domain2, Domain> preimage_domain(const typed::multi_aff<Domain2, Domain> &ma) const;
  template <typename Domain2>
  inline typed::map<Domain2, Domain> preimage_domain(const typed::multi_pw_aff<Domain2, Domain> &mpa) const;
  template <typename Domain2>
  inline typed::map<Domain2, Domain> preimage_domain(const typed::pw_multi_aff<Domain2, Domain> &pma) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, Domain> preimage_domain(const typed::union_pw_multi_aff<Domain2, Domain> &upma) const;
  template <typename Range2>
  inline typed::map<Domain, Range2> preimage_range(const typed::multi_aff<Range2, Domain> &ma) const;
  template <typename Range2>
  inline typed::map<Domain, Range2> preimage_range(const typed::pw_multi_aff<Range2, Domain> &pma) const;
  template <typename Range2>
  inline typed::union_map<Domain, Range2> preimage_range(const typed::union_pw_multi_aff<Range2, Domain> &upma) const;
  template <typename Domain2, typename Range2>
  inline typed::map<pair<Domain, Domain2>, pair<Domain, Range2>> product(const typed::map<Domain2, Range2> &map2) const;
  template <typename Domain2, typename Range2>
  inline typed::union_map<pair<Domain, Domain2>, pair<Domain, Range2>> product(const typed::union_map<Domain2, Range2> &umap2) const;
  inline typed::map<Domain, Domain> project_out_all_params() const;
  inline typed::map<Domain, Domain> project_out_param(const typed::id<Anonymous> &id) const;
  inline typed::map<Domain, Domain> project_out_param(const std::string &id) const;
  inline typed::map<Domain, Domain> project_out_param(const typed::id_list<Anonymous> &list) const;
  inline typed::set<Domain> range() const;
  inline typed::map<Domain, Domain> range_factor_domain() const = delete;
  inline typed::map<Domain, Domain> range_factor_range() const = delete;
  inline typed::fixed_box<Domain, Domain> range_lattice_tile() const;
  inline typed::union_map<pair<Domain, Domain>, Domain> range_map() const;
  template <typename Range2>
  inline typed::map<Domain, pair<Domain, Range2>> range_product(const typed::map<Domain, Range2> &map2) const;
  template <typename Range2>
  inline typed::union_map<Domain, pair<Domain, Range2>> range_product(const typed::union_map<Domain, Range2> &umap2) const;
  inline typed::map<Domain, Domain> range_reverse() const = delete;
  inline typed::fixed_box<Domain, Domain> range_simple_fixed_box_hull() const;
  inline typed::basic_map<Domain, Domain> reverse() const;
  template <typename Domain2>
  inline typed::map<Domain2, Domain> set_domain_tuple(const typed::id<Anonymous> &id) const;
  template <typename Domain2>
  inline typed::map<Domain2, Domain> set_domain_tuple(const std::string &id) const;
  template <typename Range2>
  inline typed::map<Domain, Range2> set_range_tuple(const typed::id<Anonymous> &id) const;
  template <typename Range2>
  inline typed::map<Domain, Range2> set_range_tuple(const std::string &id) const;
  inline typed::space<Domain, Domain> space() const;
  inline typed::map<Domain, Domain> subtract(const typed::map<Domain, Domain> &map2) const;
  inline typed::union_map<Domain, Domain> subtract(const typed::union_map<Domain, Domain> &umap2) const;
  inline typed::union_map<Domain, Domain> subtract_domain(const typed::union_set<Domain> &dom) const;
  inline typed::union_map<Domain, Domain> subtract_range(const typed::union_set<Domain> &dom) const;
  inline typed::union_map<Domain, Domain> to_union_map() const;
  inline typed::map<Domain, Domain> uncurry() const = delete;
  inline typed::map<Domain, Domain> unite(const typed::basic_map<Domain, Domain> &bmap2) const;
  inline typed::map<Domain, Domain> unite(const typed::map<Domain, Domain> &map2) const;
  inline typed::union_map<Domain, Domain> unite(const typed::union_map<Domain, Domain> &umap2) const;
  inline typed::map<Domain, Domain> upper_bound(const typed::multi_pw_aff<Domain, Domain> &upper) const;
  inline typed::set<pair<Domain, Domain>> wrap() const;
};

template <typename Domain, typename Range, typename Range2>
struct basic_map<Domain, pair<Range, Range2>> : public isl::basic_map {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  basic_map() = default;
  template <typename Arg1, typename Arg2, typename Arg3,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{} &&
              std::is_base_of<Range, Arg2>{} &&
              std::is_base_of<Range2, Arg3>{},
            bool>::type = true>
  basic_map(const basic_map<Arg1, pair<Arg2, Arg3>> &obj) : isl::basic_map(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::basic_map>{}, bool>::type = true>
  basic_map(const base &obj) : isl::basic_map(obj) {}
 public:
  static basic_map from(const isl::basic_map &obj) {
    return basic_map(obj);
  }
  inline explicit basic_map(const isl::ctx &ctx, const std::string &str);
  template <typename Domain2>
  inline typed::basic_map<Domain2, pair<Range, Range2>> apply_domain(const typed::basic_map<Domain, Domain2> &bmap2) const;
  template <typename Domain2>
  inline typed::map<Domain2, pair<Range, Range2>> apply_domain(const typed::map<Domain, Domain2> &map2) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, pair<Range, Range2>> apply_domain(const typed::union_map<Domain, Domain2> &umap2) const;
  template <typename Arg3>
  inline typed::basic_map<Domain, Arg3> apply_range(const typed::basic_map<pair<Range, Range2>, Arg3> &bmap2) const;
  template <typename Arg3>
  inline typed::map<Domain, Arg3> apply_range(const typed::map<pair<Range, Range2>, Arg3> &map2) const;
  template <typename Arg3>
  inline typed::union_map<Domain, Arg3> apply_range(const typed::union_map<pair<Range, Range2>, Arg3> &umap2) const;
  inline typed::map<Domain, pair<Range, Range2>> as_map() const;
  inline typed::multi_union_pw_aff<Domain, pair<Range, Range2>> as_multi_union_pw_aff() const;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> as_pw_multi_aff() const;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> as_union_pw_multi_aff() const;
  inline typed::set<pair<Range, Range2>> bind_domain(const typed::multi_id<Domain> &tuple) const;
  inline typed::set<Domain> bind_range(const typed::multi_id<pair<Range, Range2>> &tuple) const;
  inline typed::map<Domain, pair<Range, Range2>> coalesce() const;
  inline typed::map<Domain, pair<Range, Range2>> curry() const = delete;
  inline typed::basic_set<Domain, pair<Range, Range2>> deltas() const = delete;
  inline typed::basic_map<Domain, pair<Range, Range2>> detect_equalities() const;
  inline typed::set<Domain> domain() const;
  inline typed::map<Domain, pair<Range, Range2>> domain_factor_domain() const = delete;
  inline typed::map<Domain, pair<Range, Range2>> domain_factor_range() const = delete;
  inline typed::union_map<pair<Domain, pair<Range, Range2>>, Domain> domain_map() const;
  inline typed::union_pw_multi_aff<pair<Domain, pair<Range, Range2>>, Domain> domain_map_union_pw_multi_aff() const;
  template <typename Domain2>
  inline typed::map<pair<Domain, Domain2>, pair<Range, Range2>> domain_product(const typed::map<Domain2, pair<Range, Range2>> &map2) const;
  template <typename Domain2>
  inline typed::union_map<pair<Domain, Domain2>, pair<Range, Range2>> domain_product(const typed::union_map<Domain2, pair<Range, Range2>> &umap2) const;
  inline typed::map<Domain, pair<Range, Range2>> domain_reverse() const = delete;
  inline typed::map<Domain, pair<Range, Range2>> drop_unused_params() const;
  inline typed::map<Domain, pair<Range, Range2>> eq_at(const typed::multi_pw_aff<> &mpa) const = delete;
  inline typed::union_map<Domain, pair<Range, Range2>> eq_at(const typed::multi_union_pw_aff<> &mupa) const = delete;
  inline bool every_map(const std::function<bool(typed::map<Domain, pair<Range, Range2>>)> &test) const;
  inline typed::map<Domain, pair<Range, Range2>> extract_map(const typed::space<Domain, pair<Range, Range2>> &space) const;
  inline typed::basic_map<Domain, pair<Range, Range2>> flatten_domain() const = delete;
  inline typed::basic_map<Domain, Anonymous> flatten_range() const;
  inline void foreach_basic_map(const std::function<void(typed::basic_map<Domain, pair<Range, Range2>>)> &fn) const;
  inline void foreach_map(const std::function<void(typed::map<Domain, pair<Range, Range2>>)> &fn) const;
  inline typed::basic_map<Domain, pair<Range, Range2>> gist(const typed::basic_map<Domain, pair<Range, Range2>> &context) const;
  inline typed::map<Domain, pair<Range, Range2>> gist(const typed::map<Domain, pair<Range, Range2>> &context) const;
  inline typed::union_map<Domain, pair<Range, Range2>> gist(const typed::union_map<Domain, pair<Range, Range2>> &context) const;
  inline typed::map<Domain, pair<Range, Range2>> gist_domain(const typed::set<Domain> &context) const;
  inline typed::union_map<Domain, pair<Range, Range2>> gist_domain(const typed::union_set<Domain> &uset) const;
  inline typed::map<Domain, pair<Range, Range2>> gist_params(const typed::set<> &context) const;
  inline typed::basic_map<Domain, pair<Range, Range2>> intersect(const typed::basic_map<Domain, pair<Range, Range2>> &bmap2) const;
  inline typed::map<Domain, pair<Range, Range2>> intersect(const typed::map<Domain, pair<Range, Range2>> &map2) const;
  inline typed::union_map<Domain, pair<Range, Range2>> intersect(const typed::union_map<Domain, pair<Range, Range2>> &umap2) const;
  inline typed::basic_map<Domain, pair<Range, Range2>> intersect_domain(const typed::basic_set<Domain> &bset) const;
  inline typed::map<Domain, pair<Range, Range2>> intersect_domain(const typed::set<Domain> &set) const;
  inline typed::union_map<Domain, pair<Range, Range2>> intersect_domain(const typed::space<Domain> &space) const;
  inline typed::union_map<Domain, pair<Range, Range2>> intersect_domain(const typed::union_set<Domain> &uset) const;
  inline typed::basic_map<Domain, pair<Range, Range2>> intersect_domain(const typed::point<Domain> &bset) const;
  inline typed::map<Domain, pair<Range, Range2>> intersect_domain_wrapped_domain(const typed::set<> &domain) const = delete;
  inline typed::union_map<Domain, pair<Range, Range2>> intersect_domain_wrapped_domain(const typed::union_set<> &domain) const = delete;
  inline typed::map<Domain, pair<Range, Range2>> intersect_params(const typed::set<> &params) const;
  inline typed::basic_map<Domain, pair<Range, Range2>> intersect_range(const typed::basic_set<pair<Range, Range2>> &bset) const;
  inline typed::map<Domain, pair<Range, Range2>> intersect_range(const typed::set<pair<Range, Range2>> &set) const;
  inline typed::union_map<Domain, pair<Range, Range2>> intersect_range(const typed::space<pair<Range, Range2>> &space) const;
  inline typed::union_map<Domain, pair<Range, Range2>> intersect_range(const typed::union_set<pair<Range, Range2>> &uset) const;
  inline typed::basic_map<Domain, pair<Range, Range2>> intersect_range(const typed::point<pair<Range, Range2>> &bset) const;
  inline typed::map<Domain, pair<Range, Range2>> intersect_range_wrapped_domain(const typed::set<Range> &domain) const;
  inline typed::union_map<Domain, pair<Range, Range2>> intersect_range_wrapped_domain(const typed::union_set<Range> &domain) const;
  inline typed::map<Domain, pair<Range, Range2>> lex_ge_at(const typed::multi_pw_aff<> &mpa) const = delete;
  inline typed::map<Domain, pair<Range, Range2>> lex_gt_at(const typed::multi_pw_aff<> &mpa) const = delete;
  inline typed::map<Domain, pair<Range, Range2>> lex_le_at(const typed::multi_pw_aff<> &mpa) const = delete;
  inline typed::map<Domain, pair<Range, Range2>> lex_lt_at(const typed::multi_pw_aff<> &mpa) const = delete;
  inline typed::map<Domain, pair<Range, Range2>> lexmax() const;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> lexmax_pw_multi_aff() const;
  inline typed::map<Domain, pair<Range, Range2>> lexmin() const;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> lexmin_pw_multi_aff() const;
  inline typed::map<Domain, pair<Range, Range2>> lower_bound(const typed::multi_pw_aff<Domain, pair<Range, Range2>> &lower) const;
  inline typed::map_list<Domain, pair<Range, Range2>> map_list() const;
  inline typed::multi_pw_aff<Domain, pair<Range, Range2>> max_multi_pw_aff() const;
  inline typed::multi_pw_aff<Domain, pair<Range, Range2>> min_multi_pw_aff() const;
  inline typed::set<> params() const;
  template <typename Domain2>
  inline typed::map<Domain2, pair<Range, Range2>> preimage_domain(const typed::multi_aff<Domain2, Domain> &ma) const;
  template <typename Domain2>
  inline typed::map<Domain2, pair<Range, Range2>> preimage_domain(const typed::multi_pw_aff<Domain2, Domain> &mpa) const;
  template <typename Domain2>
  inline typed::map<Domain2, pair<Range, Range2>> preimage_domain(const typed::pw_multi_aff<Domain2, Domain> &pma) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, pair<Range, Range2>> preimage_domain(const typed::union_pw_multi_aff<Domain2, Domain> &upma) const;
  template <typename Arg3>
  inline typed::map<Domain, Arg3> preimage_range(const typed::multi_aff<Arg3, pair<Range, Range2>> &ma) const;
  template <typename Arg3>
  inline typed::map<Domain, Arg3> preimage_range(const typed::pw_multi_aff<Arg3, pair<Range, Range2>> &pma) const;
  template <typename Arg3>
  inline typed::union_map<Domain, Arg3> preimage_range(const typed::union_pw_multi_aff<Arg3, pair<Range, Range2>> &upma) const;
  template <typename Domain2, typename Arg3>
  inline typed::map<pair<Domain, Domain2>, pair<pair<Range, Range2>, Arg3>> product(const typed::map<Domain2, Arg3> &map2) const;
  template <typename Domain2, typename Arg3>
  inline typed::union_map<pair<Domain, Domain2>, pair<pair<Range, Range2>, Arg3>> product(const typed::union_map<Domain2, Arg3> &umap2) const;
  inline typed::map<Domain, pair<Range, Range2>> project_out_all_params() const;
  inline typed::map<Domain, pair<Range, Range2>> project_out_param(const typed::id<Anonymous> &id) const;
  inline typed::map<Domain, pair<Range, Range2>> project_out_param(const std::string &id) const;
  inline typed::map<Domain, pair<Range, Range2>> project_out_param(const typed::id_list<Anonymous> &list) const;
  inline typed::set<pair<Range, Range2>> range() const;
  inline typed::map<Domain, Range> range_factor_domain() const;
  inline typed::map<Domain, Range2> range_factor_range() const;
  inline typed::fixed_box<Domain, pair<Range, Range2>> range_lattice_tile() const;
  inline typed::union_map<pair<Domain, pair<Range, Range2>>, pair<Range, Range2>> range_map() const;
  template <typename Arg3>
  inline typed::map<Domain, pair<pair<Range, Range2>, Arg3>> range_product(const typed::map<Domain, Arg3> &map2) const;
  template <typename Arg3>
  inline typed::union_map<Domain, pair<pair<Range, Range2>, Arg3>> range_product(const typed::union_map<Domain, Arg3> &umap2) const;
  inline typed::map<Domain, pair<Range2, Range>> range_reverse() const;
  inline typed::fixed_box<Domain, pair<Range, Range2>> range_simple_fixed_box_hull() const;
  inline typed::basic_map<pair<Range, Range2>, Domain> reverse() const;
  template <typename Domain2>
  inline typed::map<Domain2, pair<Range, Range2>> set_domain_tuple(const typed::id<Anonymous> &id) const;
  template <typename Domain2>
  inline typed::map<Domain2, pair<Range, Range2>> set_domain_tuple(const std::string &id) const;
  inline typed::map<Domain, pair<Range, Range2>> set_range_tuple(const typed::id<> &id) const = delete;
  inline typed::map<Domain, pair<Range, Range2>> set_range_tuple(const std::string &id) const = delete;
  inline typed::space<Domain, pair<Range, Range2>> space() const;
  inline typed::map<Domain, pair<Range, Range2>> subtract(const typed::map<Domain, pair<Range, Range2>> &map2) const;
  inline typed::union_map<Domain, pair<Range, Range2>> subtract(const typed::union_map<Domain, pair<Range, Range2>> &umap2) const;
  inline typed::union_map<Domain, pair<Range, Range2>> subtract_domain(const typed::union_set<Domain> &dom) const;
  inline typed::union_map<Domain, pair<Range, Range2>> subtract_range(const typed::union_set<pair<Range, Range2>> &dom) const;
  inline typed::union_map<Domain, pair<Range, Range2>> to_union_map() const;
  inline typed::map<pair<Domain, Range>, Range2> uncurry() const;
  inline typed::map<Domain, pair<Range, Range2>> unite(const typed::basic_map<Domain, pair<Range, Range2>> &bmap2) const;
  inline typed::map<Domain, pair<Range, Range2>> unite(const typed::map<Domain, pair<Range, Range2>> &map2) const;
  inline typed::union_map<Domain, pair<Range, Range2>> unite(const typed::union_map<Domain, pair<Range, Range2>> &umap2) const;
  inline typed::map<Domain, pair<Range, Range2>> upper_bound(const typed::multi_pw_aff<Domain, pair<Range, Range2>> &upper) const;
  inline typed::set<pair<Domain, pair<Range, Range2>>> wrap() const;
};

template <typename T1, typename T2>
struct basic_map<pair<T1, T2>, pair<T1, T2>> : public isl::basic_map {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  basic_map() = default;
  template <typename Arg1, typename Arg2,
            typename std::enable_if<
              std::is_base_of<T1, Arg1>{} &&
              std::is_base_of<T2, Arg2>{},
            bool>::type = true>
  basic_map(const basic_map<pair<Arg1, Arg2>, pair<Arg1, Arg2>> &obj) : isl::basic_map(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::basic_map>{}, bool>::type = true>
  basic_map(const base &obj) : isl::basic_map(obj) {}
 public:
  static basic_map from(const isl::basic_map &obj) {
    return basic_map(obj);
  }
  inline explicit basic_map(const isl::ctx &ctx, const std::string &str);
  template <typename Domain2>
  inline typed::basic_map<Domain2, pair<T1, T2>> apply_domain(const typed::basic_map<pair<T1, T2>, Domain2> &bmap2) const;
  template <typename Domain2>
  inline typed::map<Domain2, pair<T1, T2>> apply_domain(const typed::map<pair<T1, T2>, Domain2> &map2) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, pair<T1, T2>> apply_domain(const typed::union_map<pair<T1, T2>, Domain2> &umap2) const;
  template <typename Range2>
  inline typed::basic_map<pair<T1, T2>, Range2> apply_range(const typed::basic_map<pair<T1, T2>, Range2> &bmap2) const;
  template <typename Range2>
  inline typed::map<pair<T1, T2>, Range2> apply_range(const typed::map<pair<T1, T2>, Range2> &map2) const;
  template <typename Range2>
  inline typed::union_map<pair<T1, T2>, Range2> apply_range(const typed::union_map<pair<T1, T2>, Range2> &umap2) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> as_map() const;
  inline typed::multi_union_pw_aff<pair<T1, T2>, pair<T1, T2>> as_multi_union_pw_aff() const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<T1, T2>> as_pw_multi_aff() const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<T1, T2>> as_union_pw_multi_aff() const;
  inline typed::set<pair<T1, T2>> bind_domain(const typed::multi_id<pair<T1, T2>> &tuple) const;
  inline typed::set<pair<T1, T2>> bind_range(const typed::multi_id<pair<T1, T2>> &tuple) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> coalesce() const;
  inline typed::map<T1, pair<T2, pair<T1, T2>>> curry() const;
  inline typed::basic_set<pair<T1, T2>> deltas() const;
  inline typed::basic_map<pair<T1, T2>, pair<T1, T2>> detect_equalities() const;
  inline typed::set<pair<T1, T2>> domain() const;
  inline typed::map<T1, pair<T1, T2>> domain_factor_domain() const;
  inline typed::map<T2, pair<T1, T2>> domain_factor_range() const;
  inline typed::union_map<pair<pair<T1, T2>, pair<T1, T2>>, pair<T1, T2>> domain_map() const;
  inline typed::union_pw_multi_aff<pair<pair<T1, T2>, pair<T1, T2>>, pair<T1, T2>> domain_map_union_pw_multi_aff() const;
  template <typename Domain2>
  inline typed::map<pair<pair<T1, T2>, Domain2>, pair<T1, T2>> domain_product(const typed::map<Domain2, pair<T1, T2>> &map2) const;
  template <typename Domain2>
  inline typed::union_map<pair<pair<T1, T2>, Domain2>, pair<T1, T2>> domain_product(const typed::union_map<Domain2, pair<T1, T2>> &umap2) const;
  inline typed::map<pair<T2, T1>, pair<T1, T2>> domain_reverse() const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> drop_unused_params() const;
  template <typename Range>
  inline typed::map<pair<T1, T2>, pair<T1, T2>> eq_at(const typed::multi_pw_aff<pair<T1, T2>, Range> &mpa) const;
  template <typename Range>
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> eq_at(const typed::multi_union_pw_aff<pair<T1, T2>, Range> &mupa) const;
  inline bool every_map(const std::function<bool(typed::map<pair<T1, T2>, pair<T1, T2>>)> &test) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> extract_map(const typed::space<pair<T1, T2>, pair<T1, T2>> &space) const;
  inline typed::basic_map<Anonymous, pair<T1, T2>> flatten_domain() const;
  inline typed::basic_map<pair<T1, T2>, Anonymous> flatten_range() const;
  inline void foreach_basic_map(const std::function<void(typed::basic_map<pair<T1, T2>, pair<T1, T2>>)> &fn) const;
  inline void foreach_map(const std::function<void(typed::map<pair<T1, T2>, pair<T1, T2>>)> &fn) const;
  inline typed::basic_map<pair<T1, T2>, pair<T1, T2>> gist(const typed::basic_map<pair<T1, T2>, pair<T1, T2>> &context) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> gist(const typed::map<pair<T1, T2>, pair<T1, T2>> &context) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> gist(const typed::union_map<pair<T1, T2>, pair<T1, T2>> &context) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> gist_domain(const typed::set<pair<T1, T2>> &context) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> gist_domain(const typed::union_set<pair<T1, T2>> &uset) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> gist_params(const typed::set<> &context) const;
  inline typed::basic_map<pair<T1, T2>, pair<T1, T2>> intersect(const typed::basic_map<pair<T1, T2>, pair<T1, T2>> &bmap2) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> intersect(const typed::map<pair<T1, T2>, pair<T1, T2>> &map2) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> intersect(const typed::union_map<pair<T1, T2>, pair<T1, T2>> &umap2) const;
  inline typed::basic_map<pair<T1, T2>, pair<T1, T2>> intersect_domain(const typed::basic_set<pair<T1, T2>> &bset) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> intersect_domain(const typed::set<pair<T1, T2>> &set) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> intersect_domain(const typed::space<pair<T1, T2>> &space) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> intersect_domain(const typed::union_set<pair<T1, T2>> &uset) const;
  inline typed::basic_map<pair<T1, T2>, pair<T1, T2>> intersect_domain(const typed::point<pair<T1, T2>> &bset) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> intersect_domain_wrapped_domain(const typed::set<T1> &domain) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> intersect_domain_wrapped_domain(const typed::union_set<T1> &domain) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> intersect_params(const typed::set<> &params) const;
  inline typed::basic_map<pair<T1, T2>, pair<T1, T2>> intersect_range(const typed::basic_set<pair<T1, T2>> &bset) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> intersect_range(const typed::set<pair<T1, T2>> &set) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> intersect_range(const typed::space<pair<T1, T2>> &space) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> intersect_range(const typed::union_set<pair<T1, T2>> &uset) const;
  inline typed::basic_map<pair<T1, T2>, pair<T1, T2>> intersect_range(const typed::point<pair<T1, T2>> &bset) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> intersect_range_wrapped_domain(const typed::set<T1> &domain) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> intersect_range_wrapped_domain(const typed::union_set<T1> &domain) const;
  template <typename Range>
  inline typed::map<pair<T1, T2>, pair<T1, T2>> lex_ge_at(const typed::multi_pw_aff<pair<T1, T2>, Range> &mpa) const;
  template <typename Range>
  inline typed::map<pair<T1, T2>, pair<T1, T2>> lex_gt_at(const typed::multi_pw_aff<pair<T1, T2>, Range> &mpa) const;
  template <typename Range>
  inline typed::map<pair<T1, T2>, pair<T1, T2>> lex_le_at(const typed::multi_pw_aff<pair<T1, T2>, Range> &mpa) const;
  template <typename Range>
  inline typed::map<pair<T1, T2>, pair<T1, T2>> lex_lt_at(const typed::multi_pw_aff<pair<T1, T2>, Range> &mpa) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> lexmax() const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<T1, T2>> lexmax_pw_multi_aff() const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> lexmin() const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<T1, T2>> lexmin_pw_multi_aff() const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> lower_bound(const typed::multi_pw_aff<pair<T1, T2>, pair<T1, T2>> &lower) const;
  inline typed::map_list<pair<T1, T2>, pair<T1, T2>> map_list() const;
  inline typed::multi_pw_aff<pair<T1, T2>, pair<T1, T2>> max_multi_pw_aff() const;
  inline typed::multi_pw_aff<pair<T1, T2>, pair<T1, T2>> min_multi_pw_aff() const;
  inline typed::set<> params() const;
  template <typename Domain2>
  inline typed::map<Domain2, pair<T1, T2>> preimage_domain(const typed::multi_aff<Domain2, pair<T1, T2>> &ma) const;
  template <typename Domain2>
  inline typed::map<Domain2, pair<T1, T2>> preimage_domain(const typed::multi_pw_aff<Domain2, pair<T1, T2>> &mpa) const;
  template <typename Domain2>
  inline typed::map<Domain2, pair<T1, T2>> preimage_domain(const typed::pw_multi_aff<Domain2, pair<T1, T2>> &pma) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, pair<T1, T2>> preimage_domain(const typed::union_pw_multi_aff<Domain2, pair<T1, T2>> &upma) const;
  template <typename Range2>
  inline typed::map<pair<T1, T2>, Range2> preimage_range(const typed::multi_aff<Range2, pair<T1, T2>> &ma) const;
  template <typename Range2>
  inline typed::map<pair<T1, T2>, Range2> preimage_range(const typed::pw_multi_aff<Range2, pair<T1, T2>> &pma) const;
  template <typename Range2>
  inline typed::union_map<pair<T1, T2>, Range2> preimage_range(const typed::union_pw_multi_aff<Range2, pair<T1, T2>> &upma) const;
  template <typename Domain2, typename Range2>
  inline typed::map<pair<pair<T1, T2>, Domain2>, pair<pair<T1, T2>, Range2>> product(const typed::map<Domain2, Range2> &map2) const;
  template <typename Domain2, typename Range2>
  inline typed::union_map<pair<pair<T1, T2>, Domain2>, pair<pair<T1, T2>, Range2>> product(const typed::union_map<Domain2, Range2> &umap2) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> project_out_all_params() const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> project_out_param(const typed::id<Anonymous> &id) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> project_out_param(const std::string &id) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> project_out_param(const typed::id_list<Anonymous> &list) const;
  inline typed::set<pair<T1, T2>> range() const;
  inline typed::map<pair<T1, T2>, T1> range_factor_domain() const;
  inline typed::map<pair<T1, T2>, T2> range_factor_range() const;
  inline typed::fixed_box<pair<T1, T2>, pair<T1, T2>> range_lattice_tile() const;
  inline typed::union_map<pair<pair<T1, T2>, pair<T1, T2>>, pair<T1, T2>> range_map() const;
  template <typename Range2>
  inline typed::map<pair<T1, T2>, pair<pair<T1, T2>, Range2>> range_product(const typed::map<pair<T1, T2>, Range2> &map2) const;
  template <typename Range2>
  inline typed::union_map<pair<T1, T2>, pair<pair<T1, T2>, Range2>> range_product(const typed::union_map<pair<T1, T2>, Range2> &umap2) const;
  inline typed::map<pair<T1, T2>, pair<T2, T1>> range_reverse() const;
  inline typed::fixed_box<pair<T1, T2>, pair<T1, T2>> range_simple_fixed_box_hull() const;
  inline typed::basic_map<pair<T1, T2>, pair<T1, T2>> reverse() const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> set_domain_tuple(const typed::id<> &id) const = delete;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> set_domain_tuple(const std::string &id) const = delete;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> set_range_tuple(const typed::id<> &id) const = delete;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> set_range_tuple(const std::string &id) const = delete;
  inline typed::space<pair<T1, T2>, pair<T1, T2>> space() const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> subtract(const typed::map<pair<T1, T2>, pair<T1, T2>> &map2) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> subtract(const typed::union_map<pair<T1, T2>, pair<T1, T2>> &umap2) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> subtract_domain(const typed::union_set<pair<T1, T2>> &dom) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> subtract_range(const typed::union_set<pair<T1, T2>> &dom) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> to_union_map() const;
  inline typed::map<pair<pair<T1, T2>, T1>, T2> uncurry() const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> unite(const typed::basic_map<pair<T1, T2>, pair<T1, T2>> &bmap2) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> unite(const typed::map<pair<T1, T2>, pair<T1, T2>> &map2) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> unite(const typed::union_map<pair<T1, T2>, pair<T1, T2>> &umap2) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> upper_bound(const typed::multi_pw_aff<pair<T1, T2>, pair<T1, T2>> &upper) const;
  inline typed::set<pair<pair<T1, T2>, pair<T1, T2>>> wrap() const;
};

template <typename T1, typename T2, typename Range, typename Range2>
struct basic_map<pair<T1, T2>, pair<Range, Range2>> : public isl::basic_map {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  basic_map() = default;
  template <typename Arg1, typename Arg2, typename Arg3, typename Arg4,
            typename std::enable_if<
              std::is_base_of<T1, Arg1>{} &&
              std::is_base_of<T2, Arg2>{} &&
              std::is_base_of<Range, Arg3>{} &&
              std::is_base_of<Range2, Arg4>{},
            bool>::type = true>
  basic_map(const basic_map<pair<Arg1, Arg2>, pair<Arg3, Arg4>> &obj) : isl::basic_map(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::basic_map>{}, bool>::type = true>
  basic_map(const base &obj) : isl::basic_map(obj) {}
 public:
  static basic_map from(const isl::basic_map &obj) {
    return basic_map(obj);
  }
  inline explicit basic_map(const isl::ctx &ctx, const std::string &str);
  template <typename Domain2>
  inline typed::basic_map<Domain2, pair<Range, Range2>> apply_domain(const typed::basic_map<pair<T1, T2>, Domain2> &bmap2) const;
  template <typename Domain2>
  inline typed::map<Domain2, pair<Range, Range2>> apply_domain(const typed::map<pair<T1, T2>, Domain2> &map2) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, pair<Range, Range2>> apply_domain(const typed::union_map<pair<T1, T2>, Domain2> &umap2) const;
  template <typename Arg2>
  inline typed::basic_map<pair<T1, T2>, Arg2> apply_range(const typed::basic_map<pair<Range, Range2>, Arg2> &bmap2) const;
  template <typename Arg2>
  inline typed::map<pair<T1, T2>, Arg2> apply_range(const typed::map<pair<Range, Range2>, Arg2> &map2) const;
  template <typename Arg2>
  inline typed::union_map<pair<T1, T2>, Arg2> apply_range(const typed::union_map<pair<Range, Range2>, Arg2> &umap2) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> as_map() const;
  inline typed::multi_union_pw_aff<pair<T1, T2>, pair<Range, Range2>> as_multi_union_pw_aff() const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> as_pw_multi_aff() const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> as_union_pw_multi_aff() const;
  inline typed::set<pair<Range, Range2>> bind_domain(const typed::multi_id<pair<T1, T2>> &tuple) const;
  inline typed::set<pair<T1, T2>> bind_range(const typed::multi_id<pair<Range, Range2>> &tuple) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> coalesce() const;
  inline typed::map<T1, pair<T2, pair<Range, Range2>>> curry() const;
  inline typed::basic_set<pair<T1, T2>, pair<Range, Range2>> deltas() const = delete;
  inline typed::basic_map<pair<T1, T2>, pair<Range, Range2>> detect_equalities() const;
  inline typed::set<pair<T1, T2>> domain() const;
  inline typed::map<T1, pair<Range, Range2>> domain_factor_domain() const;
  inline typed::map<T2, pair<Range, Range2>> domain_factor_range() const;
  inline typed::union_map<pair<pair<T1, T2>, pair<Range, Range2>>, pair<T1, T2>> domain_map() const;
  inline typed::union_pw_multi_aff<pair<pair<T1, T2>, pair<Range, Range2>>, pair<T1, T2>> domain_map_union_pw_multi_aff() const;
  template <typename Domain2>
  inline typed::map<pair<pair<T1, T2>, Domain2>, pair<Range, Range2>> domain_product(const typed::map<Domain2, pair<Range, Range2>> &map2) const;
  template <typename Domain2>
  inline typed::union_map<pair<pair<T1, T2>, Domain2>, pair<Range, Range2>> domain_product(const typed::union_map<Domain2, pair<Range, Range2>> &umap2) const;
  inline typed::map<pair<T2, T1>, pair<Range, Range2>> domain_reverse() const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> drop_unused_params() const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> eq_at(const typed::multi_pw_aff<> &mpa) const = delete;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> eq_at(const typed::multi_union_pw_aff<> &mupa) const = delete;
  inline bool every_map(const std::function<bool(typed::map<pair<T1, T2>, pair<Range, Range2>>)> &test) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> extract_map(const typed::space<pair<T1, T2>, pair<Range, Range2>> &space) const;
  inline typed::basic_map<Anonymous, pair<Range, Range2>> flatten_domain() const;
  inline typed::basic_map<pair<T1, T2>, Anonymous> flatten_range() const;
  inline void foreach_basic_map(const std::function<void(typed::basic_map<pair<T1, T2>, pair<Range, Range2>>)> &fn) const;
  inline void foreach_map(const std::function<void(typed::map<pair<T1, T2>, pair<Range, Range2>>)> &fn) const;
  inline typed::basic_map<pair<T1, T2>, pair<Range, Range2>> gist(const typed::basic_map<pair<T1, T2>, pair<Range, Range2>> &context) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> gist(const typed::map<pair<T1, T2>, pair<Range, Range2>> &context) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> gist(const typed::union_map<pair<T1, T2>, pair<Range, Range2>> &context) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> gist_domain(const typed::set<pair<T1, T2>> &context) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> gist_domain(const typed::union_set<pair<T1, T2>> &uset) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> gist_params(const typed::set<> &context) const;
  inline typed::basic_map<pair<T1, T2>, pair<Range, Range2>> intersect(const typed::basic_map<pair<T1, T2>, pair<Range, Range2>> &bmap2) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> intersect(const typed::map<pair<T1, T2>, pair<Range, Range2>> &map2) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> intersect(const typed::union_map<pair<T1, T2>, pair<Range, Range2>> &umap2) const;
  inline typed::basic_map<pair<T1, T2>, pair<Range, Range2>> intersect_domain(const typed::basic_set<pair<T1, T2>> &bset) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> intersect_domain(const typed::set<pair<T1, T2>> &set) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> intersect_domain(const typed::space<pair<T1, T2>> &space) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> intersect_domain(const typed::union_set<pair<T1, T2>> &uset) const;
  inline typed::basic_map<pair<T1, T2>, pair<Range, Range2>> intersect_domain(const typed::point<pair<T1, T2>> &bset) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> intersect_domain_wrapped_domain(const typed::set<T1> &domain) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> intersect_domain_wrapped_domain(const typed::union_set<T1> &domain) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> intersect_params(const typed::set<> &params) const;
  inline typed::basic_map<pair<T1, T2>, pair<Range, Range2>> intersect_range(const typed::basic_set<pair<Range, Range2>> &bset) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> intersect_range(const typed::set<pair<Range, Range2>> &set) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> intersect_range(const typed::space<pair<Range, Range2>> &space) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> intersect_range(const typed::union_set<pair<Range, Range2>> &uset) const;
  inline typed::basic_map<pair<T1, T2>, pair<Range, Range2>> intersect_range(const typed::point<pair<Range, Range2>> &bset) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> intersect_range_wrapped_domain(const typed::set<Range> &domain) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> intersect_range_wrapped_domain(const typed::union_set<Range> &domain) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> lex_ge_at(const typed::multi_pw_aff<> &mpa) const = delete;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> lex_gt_at(const typed::multi_pw_aff<> &mpa) const = delete;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> lex_le_at(const typed::multi_pw_aff<> &mpa) const = delete;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> lex_lt_at(const typed::multi_pw_aff<> &mpa) const = delete;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> lexmax() const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> lexmax_pw_multi_aff() const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> lexmin() const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> lexmin_pw_multi_aff() const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> lower_bound(const typed::multi_pw_aff<pair<T1, T2>, pair<Range, Range2>> &lower) const;
  inline typed::map_list<pair<T1, T2>, pair<Range, Range2>> map_list() const;
  inline typed::multi_pw_aff<pair<T1, T2>, pair<Range, Range2>> max_multi_pw_aff() const;
  inline typed::multi_pw_aff<pair<T1, T2>, pair<Range, Range2>> min_multi_pw_aff() const;
  inline typed::set<> params() const;
  template <typename Domain2>
  inline typed::map<Domain2, pair<Range, Range2>> preimage_domain(const typed::multi_aff<Domain2, pair<T1, T2>> &ma) const;
  template <typename Domain2>
  inline typed::map<Domain2, pair<Range, Range2>> preimage_domain(const typed::multi_pw_aff<Domain2, pair<T1, T2>> &mpa) const;
  template <typename Domain2>
  inline typed::map<Domain2, pair<Range, Range2>> preimage_domain(const typed::pw_multi_aff<Domain2, pair<T1, T2>> &pma) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, pair<Range, Range2>> preimage_domain(const typed::union_pw_multi_aff<Domain2, pair<T1, T2>> &upma) const;
  template <typename Arg2>
  inline typed::map<pair<T1, T2>, Arg2> preimage_range(const typed::multi_aff<Arg2, pair<Range, Range2>> &ma) const;
  template <typename Arg2>
  inline typed::map<pair<T1, T2>, Arg2> preimage_range(const typed::pw_multi_aff<Arg2, pair<Range, Range2>> &pma) const;
  template <typename Arg2>
  inline typed::union_map<pair<T1, T2>, Arg2> preimage_range(const typed::union_pw_multi_aff<Arg2, pair<Range, Range2>> &upma) const;
  template <typename Domain2, typename Arg2>
  inline typed::map<pair<pair<T1, T2>, Domain2>, pair<pair<Range, Range2>, Arg2>> product(const typed::map<Domain2, Arg2> &map2) const;
  template <typename Domain2, typename Arg2>
  inline typed::union_map<pair<pair<T1, T2>, Domain2>, pair<pair<Range, Range2>, Arg2>> product(const typed::union_map<Domain2, Arg2> &umap2) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> project_out_all_params() const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> project_out_param(const typed::id<Anonymous> &id) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> project_out_param(const std::string &id) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> project_out_param(const typed::id_list<Anonymous> &list) const;
  inline typed::set<pair<Range, Range2>> range() const;
  inline typed::map<pair<T1, T2>, Range> range_factor_domain() const;
  inline typed::map<pair<T1, T2>, Range2> range_factor_range() const;
  inline typed::fixed_box<pair<T1, T2>, pair<Range, Range2>> range_lattice_tile() const;
  inline typed::union_map<pair<pair<T1, T2>, pair<Range, Range2>>, pair<Range, Range2>> range_map() const;
  template <typename Arg2>
  inline typed::map<pair<T1, T2>, pair<pair<Range, Range2>, Arg2>> range_product(const typed::map<pair<T1, T2>, Arg2> &map2) const;
  template <typename Arg2>
  inline typed::union_map<pair<T1, T2>, pair<pair<Range, Range2>, Arg2>> range_product(const typed::union_map<pair<T1, T2>, Arg2> &umap2) const;
  inline typed::map<pair<T1, T2>, pair<Range2, Range>> range_reverse() const;
  inline typed::fixed_box<pair<T1, T2>, pair<Range, Range2>> range_simple_fixed_box_hull() const;
  inline typed::basic_map<pair<Range, Range2>, pair<T1, T2>> reverse() const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> set_domain_tuple(const typed::id<> &id) const = delete;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> set_domain_tuple(const std::string &id) const = delete;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> set_range_tuple(const typed::id<> &id) const = delete;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> set_range_tuple(const std::string &id) const = delete;
  inline typed::space<pair<T1, T2>, pair<Range, Range2>> space() const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> subtract(const typed::map<pair<T1, T2>, pair<Range, Range2>> &map2) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> subtract(const typed::union_map<pair<T1, T2>, pair<Range, Range2>> &umap2) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> subtract_domain(const typed::union_set<pair<T1, T2>> &dom) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> subtract_range(const typed::union_set<pair<Range, Range2>> &dom) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> to_union_map() const;
  inline typed::map<pair<pair<T1, T2>, Range>, Range2> uncurry() const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> unite(const typed::basic_map<pair<T1, T2>, pair<Range, Range2>> &bmap2) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> unite(const typed::map<pair<T1, T2>, pair<Range, Range2>> &map2) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> unite(const typed::union_map<pair<T1, T2>, pair<Range, Range2>> &umap2) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> upper_bound(const typed::multi_pw_aff<pair<T1, T2>, pair<Range, Range2>> &upper) const;
  inline typed::set<pair<pair<T1, T2>, pair<Range, Range2>>> wrap() const;
};

template <>
struct basic_set<> : public isl::basic_set {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  basic_set() = default;
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::basic_set>{}, bool>::type = true>
  basic_set(const base &obj) : isl::basic_set(obj) {}
 public:
  static basic_set from(const isl::basic_set &obj) {
    return basic_set(obj);
  }
  inline /* implicit */ basic_set(const typed::point<> &pnt);
  inline explicit basic_set(const isl::ctx &ctx, const std::string &str);
  inline typed::basic_set<> apply(const typed::basic_map<> &bmap) const = delete;
  inline typed::set<> apply(const typed::map<> &map) const = delete;
  inline typed::union_set<> apply(const typed::union_map<> &umap) const = delete;
  inline typed::pw_multi_aff<> as_pw_multi_aff() const = delete;
  inline typed::set<> as_set() const = delete;
  inline typed::set<> bind(const typed::multi_id<> &tuple) const = delete;
  inline typed::set<> coalesce() const;
  inline typed::basic_set<> detect_equalities() const;
  inline typed::set<> drop_unused_params() const;
  inline bool every_set(const std::function<bool(typed::set<>)> &test) const;
  inline typed::set<> extract_set(const typed::space<> &space) const;
  inline void foreach_basic_set(const std::function<void(typed::basic_set<>)> &fn) const;
  inline void foreach_point(const std::function<void(typed::point<>)> &fn) const;
  inline void foreach_set(const std::function<void(typed::set<>)> &fn) const;
  inline typed::basic_set<> gist(const typed::basic_set<> &context) const;
  inline typed::set<> gist(const typed::set<> &context) const;
  inline typed::union_set<> gist(const typed::union_set<> &context) const;
  inline typed::basic_set<> gist(const typed::point<> &context) const;
  inline typed::set<> gist_params(const typed::set<> &context) const = delete;
  inline typed::map<> identity() const = delete;
  inline typed::pw_aff<Anonymous> indicator_function() const;
  inline typed::map<> insert_domain(const typed::space<> &domain) const = delete;
  inline typed::basic_set<> intersect(const typed::basic_set<> &bset2) const;
  inline typed::set<> intersect(const typed::set<> &set2) const;
  inline typed::union_set<> intersect(const typed::union_set<> &uset2) const;
  inline typed::basic_set<> intersect(const typed::point<> &bset2) const;
  inline typed::basic_set<> intersect_params(const typed::basic_set<> &bset2) const = delete;
  inline typed::set<> intersect_params(const typed::set<> &params) const = delete;
  inline typed::basic_set<> intersect_params(const typed::point<> &bset2) const = delete;
  inline typed::fixed_box<> lattice_tile() const = delete;
  inline typed::set<> lexmax() const = delete;
  inline typed::pw_multi_aff<> lexmax_pw_multi_aff() const = delete;
  inline typed::set<> lexmin() const = delete;
  inline typed::pw_multi_aff<> lexmin_pw_multi_aff() const = delete;
  inline typed::set<> lower_bound(const typed::multi_pw_aff<> &lower) const = delete;
  inline typed::set<> lower_bound(const typed::multi_val<> &lower) const = delete;
  inline typed::multi_pw_aff<> max_multi_pw_aff() const = delete;
  inline typed::val<> max_val(const typed::aff<> &obj) const = delete;
  inline typed::multi_pw_aff<> min_multi_pw_aff() const = delete;
  inline typed::val<> min_val(const typed::aff<> &obj) const = delete;
  inline typed::pw_aff<Anonymous> param_pw_aff_on_domain(const typed::id<Anonymous> &id) const;
  inline typed::pw_aff<Anonymous> param_pw_aff_on_domain(const std::string &id) const;
  inline typed::basic_set<> params() const = delete;
  inline typed::multi_val<> plain_multi_val_if_fixed() const = delete;
  inline typed::set<> preimage(const typed::multi_aff<> &ma) const = delete;
  inline typed::set<> preimage(const typed::multi_pw_aff<> &mpa) const = delete;
  inline typed::set<> preimage(const typed::pw_multi_aff<> &pma) const = delete;
  inline typed::union_set<> preimage(const typed::union_pw_multi_aff<> &upma) const = delete;
  inline typed::set<> product(const typed::set<> &set2) const = delete;
  inline typed::set<> project_out_all_params() const;
  inline typed::set<> project_out_param(const typed::id<Anonymous> &id) const;
  inline typed::set<> project_out_param(const std::string &id) const;
  inline typed::set<> project_out_param(const typed::id_list<Anonymous> &list) const;
  inline typed::pw_aff<Anonymous> pw_aff_on_domain(const typed::val<Anonymous> &v) const;
  inline typed::pw_aff<Anonymous> pw_aff_on_domain(long v) const;
  template <typename Domain>
  inline typed::pw_multi_aff<Domain> pw_multi_aff_on_domain(const typed::multi_val<Domain> &mv) const;
  inline typed::set_list<> set_list() const;
  inline typed::fixed_box<> simple_fixed_box_hull() const = delete;
  inline typed::space<> space() const;
  inline typed::set<> subtract(const typed::set<> &set2) const;
  inline typed::union_set<> subtract(const typed::union_set<> &uset2) const;
  inline typed::set<> to_set() const;
  inline typed::union_set<> to_union_set() const;
  inline typed::map<> translation() const = delete;
  template <typename Domain>
  inline typed::set<Domain> unbind_params(const typed::multi_id<Domain> &tuple) const;
  inline typed::map<> unbind_params_insert_domain(const typed::multi_id<> &domain) const = delete;
  inline typed::set<> unite(const typed::basic_set<> &bset2) const;
  inline typed::set<> unite(const typed::set<> &set2) const;
  inline typed::union_set<> unite(const typed::union_set<> &uset2) const;
  inline typed::set<> unite(const typed::point<> &bset2) const;
  inline typed::map<> unwrap() const = delete;
  inline typed::set<> upper_bound(const typed::multi_pw_aff<> &upper) const = delete;
  inline typed::set<> upper_bound(const typed::multi_val<> &upper) const = delete;
  inline typed::set<> wrapped_reverse() const = delete;
};

template <typename Domain>
struct basic_set<Domain> : public isl::basic_set {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  basic_set() = default;
  template <typename Arg1,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{},
            bool>::type = true>
  basic_set(const basic_set<Arg1> &obj) : isl::basic_set(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::basic_set>{}, bool>::type = true>
  basic_set(const base &obj) : isl::basic_set(obj) {}
 public:
  static basic_set from(const isl::basic_set &obj) {
    return basic_set(obj);
  }
  inline /* implicit */ basic_set(const typed::point<Domain> &pnt);
  inline explicit basic_set(const isl::ctx &ctx, const std::string &str);
  template <typename Range>
  inline typed::basic_set<Range> apply(const typed::basic_map<Domain, Range> &bmap) const;
  template <typename Range>
  inline typed::set<Range> apply(const typed::map<Domain, Range> &map) const;
  template <typename Range>
  inline typed::union_set<Range> apply(const typed::union_map<Domain, Range> &umap) const;
  inline typed::pw_multi_aff<Domain> as_pw_multi_aff() const;
  inline typed::set<Domain> as_set() const;
  inline typed::set<> bind(const typed::multi_id<Domain> &tuple) const;
  inline typed::set<Domain> coalesce() const;
  inline typed::basic_set<Domain> detect_equalities() const;
  inline typed::set<Domain> drop_unused_params() const;
  inline bool every_set(const std::function<bool(typed::set<Domain>)> &test) const;
  inline typed::set<Domain> extract_set(const typed::space<Domain> &space) const;
  inline void foreach_basic_set(const std::function<void(typed::basic_set<Domain>)> &fn) const;
  inline void foreach_point(const std::function<void(typed::point<Domain>)> &fn) const;
  inline void foreach_set(const std::function<void(typed::set<Domain>)> &fn) const;
  inline typed::basic_set<Domain> gist(const typed::basic_set<Domain> &context) const;
  inline typed::set<Domain> gist(const typed::set<Domain> &context) const;
  inline typed::union_set<Domain> gist(const typed::union_set<Domain> &context) const;
  inline typed::basic_set<Domain> gist(const typed::point<Domain> &context) const;
  inline typed::set<Domain> gist_params(const typed::set<> &context) const;
  inline typed::map<Domain, Domain> identity() const;
  inline typed::pw_aff<Domain, Anonymous> indicator_function() const;
  template <typename Arg1>
  inline typed::map<Arg1, Domain> insert_domain(const typed::space<Arg1> &domain) const;
  inline typed::basic_set<Domain> intersect(const typed::basic_set<Domain> &bset2) const;
  inline typed::set<Domain> intersect(const typed::set<Domain> &set2) const;
  inline typed::union_set<Domain> intersect(const typed::union_set<Domain> &uset2) const;
  inline typed::basic_set<Domain> intersect(const typed::point<Domain> &bset2) const;
  inline typed::basic_set<Domain> intersect_params(const typed::basic_set<> &bset2) const;
  inline typed::set<Domain> intersect_params(const typed::set<> &params) const;
  inline typed::basic_set<Domain> intersect_params(const typed::point<> &bset2) const;
  inline typed::fixed_box<Domain> lattice_tile() const;
  inline typed::set<Domain> lexmax() const;
  inline typed::pw_multi_aff<Domain> lexmax_pw_multi_aff() const;
  inline typed::set<Domain> lexmin() const;
  inline typed::pw_multi_aff<Domain> lexmin_pw_multi_aff() const;
  inline typed::set<Domain> lower_bound(const typed::multi_pw_aff<Domain> &lower) const;
  inline typed::set<Domain> lower_bound(const typed::multi_val<Domain> &lower) const;
  inline typed::multi_pw_aff<Domain> max_multi_pw_aff() const;
  inline typed::val<Domain> max_val(const typed::aff<> &obj) const = delete;
  inline typed::multi_pw_aff<Domain> min_multi_pw_aff() const;
  inline typed::val<Domain> min_val(const typed::aff<> &obj) const = delete;
  inline typed::pw_aff<Domain, Anonymous> param_pw_aff_on_domain(const typed::id<Anonymous> &id) const;
  inline typed::pw_aff<Domain, Anonymous> param_pw_aff_on_domain(const std::string &id) const;
  inline typed::basic_set<> params() const;
  inline typed::multi_val<Domain> plain_multi_val_if_fixed() const;
  template <typename Domain2>
  inline typed::set<Domain2> preimage(const typed::multi_aff<Domain2, Domain> &ma) const;
  template <typename Domain2>
  inline typed::set<Domain2> preimage(const typed::multi_pw_aff<Domain2, Domain> &mpa) const;
  template <typename Domain2>
  inline typed::set<Domain2> preimage(const typed::pw_multi_aff<Domain2, Domain> &pma) const;
  template <typename Domain2>
  inline typed::union_set<Domain2> preimage(const typed::union_pw_multi_aff<Domain2, Domain> &upma) const;
  template <typename Range>
  inline typed::set<pair<Domain, Range>> product(const typed::set<Range> &set2) const;
  inline typed::set<Domain> project_out_all_params() const;
  inline typed::set<Domain> project_out_param(const typed::id<Anonymous> &id) const;
  inline typed::set<Domain> project_out_param(const std::string &id) const;
  inline typed::set<Domain> project_out_param(const typed::id_list<Anonymous> &list) const;
  inline typed::pw_aff<Domain, Anonymous> pw_aff_on_domain(const typed::val<Anonymous> &v) const;
  inline typed::pw_aff<Domain, Anonymous> pw_aff_on_domain(long v) const;
  template <typename Range>
  inline typed::pw_multi_aff<Domain, Range> pw_multi_aff_on_domain(const typed::multi_val<Range> &mv) const;
  inline typed::set_list<Domain> set_list() const;
  inline typed::fixed_box<Domain> simple_fixed_box_hull() const;
  inline typed::space<Domain> space() const;
  inline typed::set<Domain> subtract(const typed::set<Domain> &set2) const;
  inline typed::union_set<Domain> subtract(const typed::union_set<Domain> &uset2) const;
  inline typed::set<Domain> to_set() const;
  inline typed::union_set<Domain> to_union_set() const;
  inline typed::map<Domain, Domain> translation() const;
  inline typed::set<Domain> unbind_params(const typed::multi_id<> &tuple) const = delete;
  template <typename Arg1>
  inline typed::map<Arg1, Domain> unbind_params_insert_domain(const typed::multi_id<Arg1> &domain) const;
  inline typed::set<Domain> unite(const typed::basic_set<Domain> &bset2) const;
  inline typed::set<Domain> unite(const typed::set<Domain> &set2) const;
  inline typed::union_set<Domain> unite(const typed::union_set<Domain> &uset2) const;
  inline typed::set<Domain> unite(const typed::point<Domain> &bset2) const;
  inline typed::map<Domain> unwrap() const = delete;
  inline typed::set<Domain> upper_bound(const typed::multi_pw_aff<Domain> &upper) const;
  inline typed::set<Domain> upper_bound(const typed::multi_val<Domain> &upper) const;
  inline typed::set<Domain> wrapped_reverse() const = delete;
};

template <typename Domain, typename Range>
struct basic_set<pair<Domain, Range>> : public isl::basic_set {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  basic_set() = default;
  template <typename Arg1, typename Arg2,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{} &&
              std::is_base_of<Range, Arg2>{},
            bool>::type = true>
  basic_set(const basic_set<pair<Arg1, Arg2>> &obj) : isl::basic_set(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::basic_set>{}, bool>::type = true>
  basic_set(const base &obj) : isl::basic_set(obj) {}
 public:
  static basic_set from(const isl::basic_set &obj) {
    return basic_set(obj);
  }
  inline /* implicit */ basic_set(const typed::point<pair<Domain, Range>> &pnt);
  inline explicit basic_set(const isl::ctx &ctx, const std::string &str);
  template <typename Arg2>
  inline typed::basic_set<Arg2> apply(const typed::basic_map<pair<Domain, Range>, Arg2> &bmap) const;
  template <typename Arg2>
  inline typed::set<Arg2> apply(const typed::map<pair<Domain, Range>, Arg2> &map) const;
  template <typename Arg2>
  inline typed::union_set<Arg2> apply(const typed::union_map<pair<Domain, Range>, Arg2> &umap) const;
  inline typed::pw_multi_aff<pair<Domain, Range>> as_pw_multi_aff() const;
  inline typed::set<pair<Domain, Range>> as_set() const;
  inline typed::set<> bind(const typed::multi_id<pair<Domain, Range>> &tuple) const;
  inline typed::set<pair<Domain, Range>> coalesce() const;
  inline typed::basic_set<pair<Domain, Range>> detect_equalities() const;
  inline typed::set<pair<Domain, Range>> drop_unused_params() const;
  inline bool every_set(const std::function<bool(typed::set<pair<Domain, Range>>)> &test) const;
  inline typed::set<pair<Domain, Range>> extract_set(const typed::space<pair<Domain, Range>> &space) const;
  inline void foreach_basic_set(const std::function<void(typed::basic_set<pair<Domain, Range>>)> &fn) const;
  inline void foreach_point(const std::function<void(typed::point<pair<Domain, Range>>)> &fn) const;
  inline void foreach_set(const std::function<void(typed::set<pair<Domain, Range>>)> &fn) const;
  inline typed::basic_set<pair<Domain, Range>> gist(const typed::basic_set<pair<Domain, Range>> &context) const;
  inline typed::set<pair<Domain, Range>> gist(const typed::set<pair<Domain, Range>> &context) const;
  inline typed::union_set<pair<Domain, Range>> gist(const typed::union_set<pair<Domain, Range>> &context) const;
  inline typed::basic_set<pair<Domain, Range>> gist(const typed::point<pair<Domain, Range>> &context) const;
  inline typed::set<pair<Domain, Range>> gist_params(const typed::set<> &context) const;
  inline typed::map<pair<Domain, Range>, pair<Domain, Range>> identity() const;
  inline typed::pw_aff<pair<Domain, Range>, Anonymous> indicator_function() const;
  template <typename Arg2>
  inline typed::map<Arg2, pair<Domain, Range>> insert_domain(const typed::space<Arg2> &domain) const;
  inline typed::basic_set<pair<Domain, Range>> intersect(const typed::basic_set<pair<Domain, Range>> &bset2) const;
  inline typed::set<pair<Domain, Range>> intersect(const typed::set<pair<Domain, Range>> &set2) const;
  inline typed::union_set<pair<Domain, Range>> intersect(const typed::union_set<pair<Domain, Range>> &uset2) const;
  inline typed::basic_set<pair<Domain, Range>> intersect(const typed::point<pair<Domain, Range>> &bset2) const;
  inline typed::basic_set<pair<Domain, Range>> intersect_params(const typed::basic_set<> &bset2) const;
  inline typed::set<pair<Domain, Range>> intersect_params(const typed::set<> &params) const;
  inline typed::basic_set<pair<Domain, Range>> intersect_params(const typed::point<> &bset2) const;
  inline typed::fixed_box<pair<Domain, Range>> lattice_tile() const;
  inline typed::set<pair<Domain, Range>> lexmax() const;
  inline typed::pw_multi_aff<pair<Domain, Range>> lexmax_pw_multi_aff() const;
  inline typed::set<pair<Domain, Range>> lexmin() const;
  inline typed::pw_multi_aff<pair<Domain, Range>> lexmin_pw_multi_aff() const;
  inline typed::set<pair<Domain, Range>> lower_bound(const typed::multi_pw_aff<pair<Domain, Range>> &lower) const;
  inline typed::set<pair<Domain, Range>> lower_bound(const typed::multi_val<pair<Domain, Range>> &lower) const;
  inline typed::multi_pw_aff<pair<Domain, Range>> max_multi_pw_aff() const;
  inline typed::val<pair<Domain, Range>> max_val(const typed::aff<> &obj) const = delete;
  inline typed::multi_pw_aff<pair<Domain, Range>> min_multi_pw_aff() const;
  inline typed::val<pair<Domain, Range>> min_val(const typed::aff<> &obj) const = delete;
  inline typed::pw_aff<pair<Domain, Range>, Anonymous> param_pw_aff_on_domain(const typed::id<Anonymous> &id) const;
  inline typed::pw_aff<pair<Domain, Range>, Anonymous> param_pw_aff_on_domain(const std::string &id) const;
  inline typed::basic_set<> params() const;
  inline typed::multi_val<pair<Domain, Range>> plain_multi_val_if_fixed() const;
  template <typename Domain2>
  inline typed::set<Domain2> preimage(const typed::multi_aff<Domain2, pair<Domain, Range>> &ma) const;
  template <typename Domain2>
  inline typed::set<Domain2> preimage(const typed::multi_pw_aff<Domain2, pair<Domain, Range>> &mpa) const;
  template <typename Domain2>
  inline typed::set<Domain2> preimage(const typed::pw_multi_aff<Domain2, pair<Domain, Range>> &pma) const;
  template <typename Domain2>
  inline typed::union_set<Domain2> preimage(const typed::union_pw_multi_aff<Domain2, pair<Domain, Range>> &upma) const;
  template <typename Arg2>
  inline typed::set<pair<pair<Domain, Range>, Arg2>> product(const typed::set<Arg2> &set2) const;
  inline typed::set<pair<Domain, Range>> project_out_all_params() const;
  inline typed::set<pair<Domain, Range>> project_out_param(const typed::id<Anonymous> &id) const;
  inline typed::set<pair<Domain, Range>> project_out_param(const std::string &id) const;
  inline typed::set<pair<Domain, Range>> project_out_param(const typed::id_list<Anonymous> &list) const;
  inline typed::pw_aff<pair<Domain, Range>, Anonymous> pw_aff_on_domain(const typed::val<Anonymous> &v) const;
  inline typed::pw_aff<pair<Domain, Range>, Anonymous> pw_aff_on_domain(long v) const;
  template <typename Arg2>
  inline typed::pw_multi_aff<pair<Domain, Range>, Arg2> pw_multi_aff_on_domain(const typed::multi_val<Arg2> &mv) const;
  inline typed::set_list<pair<Domain, Range>> set_list() const;
  inline typed::fixed_box<pair<Domain, Range>> simple_fixed_box_hull() const;
  inline typed::space<pair<Domain, Range>> space() const;
  inline typed::set<pair<Domain, Range>> subtract(const typed::set<pair<Domain, Range>> &set2) const;
  inline typed::union_set<pair<Domain, Range>> subtract(const typed::union_set<pair<Domain, Range>> &uset2) const;
  inline typed::set<pair<Domain, Range>> to_set() const;
  inline typed::union_set<pair<Domain, Range>> to_union_set() const;
  inline typed::map<pair<Domain, Range>, pair<Domain, Range>> translation() const;
  inline typed::set<pair<Domain, Range>> unbind_params(const typed::multi_id<> &tuple) const = delete;
  template <typename Arg2>
  inline typed::map<Arg2, pair<Domain, Range>> unbind_params_insert_domain(const typed::multi_id<Arg2> &domain) const;
  inline typed::set<pair<Domain, Range>> unite(const typed::basic_set<pair<Domain, Range>> &bset2) const;
  inline typed::set<pair<Domain, Range>> unite(const typed::set<pair<Domain, Range>> &set2) const;
  inline typed::union_set<pair<Domain, Range>> unite(const typed::union_set<pair<Domain, Range>> &uset2) const;
  inline typed::set<pair<Domain, Range>> unite(const typed::point<pair<Domain, Range>> &bset2) const;
  inline typed::map<Domain, Range> unwrap() const;
  inline typed::set<pair<Domain, Range>> upper_bound(const typed::multi_pw_aff<pair<Domain, Range>> &upper) const;
  inline typed::set<pair<Domain, Range>> upper_bound(const typed::multi_val<pair<Domain, Range>> &upper) const;
  inline typed::set<pair<Range, Domain>> wrapped_reverse() const;
};

template <typename Domain>
struct fixed_box<Domain> : public isl::fixed_box {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  fixed_box() = default;
  template <typename Arg1,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{},
            bool>::type = true>
  fixed_box(const fixed_box<Arg1> &obj) : isl::fixed_box(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::fixed_box>{}, bool>::type = true>
  fixed_box(const base &obj) : isl::fixed_box(obj) {}
 public:
  static fixed_box from(const isl::fixed_box &obj) {
    return fixed_box(obj);
  }
  inline explicit fixed_box(const isl::ctx &ctx, const std::string &str);
  inline typed::multi_aff<Domain> offset() const;
  inline typed::multi_aff<Domain> get_offset() const = delete;
  inline typed::multi_val<Domain> size() const;
  inline typed::multi_val<Domain> get_size() const = delete;
  inline typed::space<Domain> space() const;
  inline typed::space<Domain> get_space() const = delete;
};

template <typename Domain, typename Range>
struct fixed_box<Domain, Range> : public isl::fixed_box {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  fixed_box() = default;
  template <typename Arg1, typename Arg2,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{} &&
              std::is_base_of<Range, Arg2>{},
            bool>::type = true>
  fixed_box(const fixed_box<Arg1, Arg2> &obj) : isl::fixed_box(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::fixed_box>{}, bool>::type = true>
  fixed_box(const base &obj) : isl::fixed_box(obj) {}
 public:
  static fixed_box from(const isl::fixed_box &obj) {
    return fixed_box(obj);
  }
  inline explicit fixed_box(const isl::ctx &ctx, const std::string &str);
  inline typed::multi_aff<Domain, Range> offset() const;
  inline typed::multi_aff<Domain, Range> get_offset() const = delete;
  inline typed::multi_val<Range> size() const;
  inline typed::multi_val<Domain, Range> get_size() const = delete;
  inline typed::space<Domain, Range> space() const;
  inline typed::space<Domain, Range> get_space() const = delete;
};

template <>
struct id<Anonymous> : public isl::id {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  id() = default;
  id(const isl::id &obj) : isl::id(obj) {}
  static id from(const isl::id &obj) {
    return id(obj);
  }
  inline explicit id(const isl::ctx &ctx, const std::string &str);
  inline std::string get_name() const = delete;
};

template <>
struct id_list<Anonymous> : public isl::id_list {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  id_list() = default;
  id_list(const isl::id_list &obj) : isl::id_list(obj) {}
  static id_list from(const isl::id_list &obj) {
    return id_list(obj);
  }
  inline explicit id_list(const isl::ctx &ctx, int n);
  inline explicit id_list(const typed::id<Anonymous> &el);
  inline explicit id_list(const isl::ctx &ctx, const std::string &str);
  inline typed::id_list<Anonymous> add(const typed::id<Anonymous> &el) const;
  inline typed::id_list<Anonymous> add(const std::string &el) const;
  inline typed::id<Anonymous> at(int index) const;
  inline typed::id<Anonymous> get_at(int index) const = delete;
  inline typed::id_list<Anonymous> drop(unsigned int first, unsigned int n) const;
  inline void foreach(const std::function<void(typed::id<Anonymous>)> &fn) const;
  inline void foreach_scc(const std::function<bool(typed::id<Anonymous>, typed::id<Anonymous>)> &follows, const std::function<void(typed::id_list<Anonymous>)> &fn) const;
  inline typed::id_list<Anonymous> set_at(int index, const typed::id<Anonymous> &el) const;
  inline typed::id_list<Anonymous> set_at(int index, const std::string &el) const;
};

template <typename Domain, typename Range>
struct map<Domain, Range> : public isl::map {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  map() = default;
  template <typename Arg1, typename Arg2,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{} &&
              std::is_base_of<Range, Arg2>{},
            bool>::type = true>
  map(const map<Arg1, Arg2> &obj) : isl::map(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::map>{}, bool>::type = true>
  map(const base &obj) : isl::map(obj) {}
 public:
  static map from(const isl::map &obj) {
    return map(obj);
  }
  inline /* implicit */ map(const typed::basic_map<Domain, Range> &bmap);
  inline explicit map(const isl::ctx &ctx, const std::string &str);
  template <typename Domain2>
  inline typed::map<Domain2, Range> apply_domain(const typed::map<Domain, Domain2> &map2) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, Range> apply_domain(const typed::union_map<Domain, Domain2> &umap2) const;
  template <typename Domain2>
  inline typed::map<Domain2, Range> apply_domain(const typed::basic_map<Domain, Domain2> &map2) const;
  template <typename Range2>
  inline typed::map<Domain, Range2> apply_range(const typed::map<Range, Range2> &map2) const;
  template <typename Range2>
  inline typed::union_map<Domain, Range2> apply_range(const typed::union_map<Range, Range2> &umap2) const;
  template <typename Range2>
  inline typed::map<Domain, Range2> apply_range(const typed::basic_map<Range, Range2> &map2) const;
  inline typed::map<Domain, Range> as_map() const;
  inline typed::multi_union_pw_aff<Domain, Range> as_multi_union_pw_aff() const;
  inline typed::pw_multi_aff<Domain, Range> as_pw_multi_aff() const;
  inline typed::union_pw_multi_aff<Domain, Range> as_union_pw_multi_aff() const;
  inline typed::set<Range> bind_domain(const typed::multi_id<Domain> &tuple) const;
  inline typed::set<Domain> bind_range(const typed::multi_id<Range> &tuple) const;
  inline typed::map<Domain, Range> coalesce() const;
  inline typed::map<Domain, Range> curry() const = delete;
  inline typed::set<Domain, Range> deltas() const = delete;
  inline typed::map<Domain, Range> detect_equalities() const;
  inline typed::set<Domain> domain() const;
  inline typed::map<Domain, Range> domain_factor_domain() const = delete;
  inline typed::map<Domain, Range> domain_factor_range() const = delete;
  inline typed::union_map<pair<Domain, Range>, Domain> domain_map() const;
  inline typed::union_pw_multi_aff<pair<Domain, Range>, Domain> domain_map_union_pw_multi_aff() const;
  template <typename Domain2>
  inline typed::map<pair<Domain, Domain2>, Range> domain_product(const typed::map<Domain2, Range> &map2) const;
  template <typename Domain2>
  inline typed::union_map<pair<Domain, Domain2>, Range> domain_product(const typed::union_map<Domain2, Range> &umap2) const;
  template <typename Domain2>
  inline typed::map<pair<Domain, Domain2>, Range> domain_product(const typed::basic_map<Domain2, Range> &map2) const;
  inline typed::map<Domain, Range> domain_reverse() const = delete;
  inline typed::id<Domain, Range> get_domain_tuple_id() const = delete;
  inline typed::map<Domain, Range> drop_unused_params() const;
  inline typed::map<Domain, Range> eq_at(const typed::multi_pw_aff<> &mpa) const = delete;
  inline typed::union_map<Domain, Range> eq_at(const typed::multi_union_pw_aff<> &mupa) const = delete;
  inline typed::map<Domain, Range> eq_at(const typed::aff<> &mpa) const = delete;
  inline typed::map<Domain, Range> eq_at(const typed::multi_aff<> &mpa) const = delete;
  inline typed::map<Domain, Range> eq_at(const typed::pw_aff<> &mpa) const = delete;
  inline typed::map<Domain, Range> eq_at(const typed::pw_multi_aff<> &mpa) const = delete;
  inline bool every_map(const std::function<bool(typed::map<Domain, Range>)> &test) const;
  inline typed::map<Domain, Range> extract_map(const typed::space<Domain, Range> &space) const;
  inline typed::map<Domain, Range> flatten_domain() const = delete;
  inline typed::map<Domain, Range> flatten_range() const = delete;
  inline void foreach_basic_map(const std::function<void(typed::basic_map<Domain, Range>)> &fn) const;
  inline void foreach_map(const std::function<void(typed::map<Domain, Range>)> &fn) const;
  inline typed::map<Domain, Range> gist(const typed::map<Domain, Range> &context) const;
  inline typed::union_map<Domain, Range> gist(const typed::union_map<Domain, Range> &context) const;
  inline typed::map<Domain, Range> gist(const typed::basic_map<Domain, Range> &context) const;
  inline typed::map<Domain, Range> gist_domain(const typed::set<Domain> &context) const;
  inline typed::union_map<Domain, Range> gist_domain(const typed::union_set<Domain> &uset) const;
  inline typed::map<Domain, Range> gist_domain(const typed::basic_set<Domain> &context) const;
  inline typed::map<Domain, Range> gist_domain(const typed::point<Domain> &context) const;
  inline typed::map<Domain, Range> gist_params(const typed::set<> &context) const;
  inline typed::map<Domain, Range> gist_params(const typed::basic_set<> &context) const;
  inline typed::map<Domain, Range> gist_params(const typed::point<> &context) const;
  inline typed::map<Domain, Range> intersect(const typed::map<Domain, Range> &map2) const;
  inline typed::union_map<Domain, Range> intersect(const typed::union_map<Domain, Range> &umap2) const;
  inline typed::map<Domain, Range> intersect(const typed::basic_map<Domain, Range> &map2) const;
  inline typed::map<Domain, Range> intersect_domain(const typed::set<Domain> &set) const;
  inline typed::union_map<Domain, Range> intersect_domain(const typed::space<Domain> &space) const;
  inline typed::union_map<Domain, Range> intersect_domain(const typed::union_set<Domain> &uset) const;
  inline typed::map<Domain, Range> intersect_domain(const typed::basic_set<Domain> &set) const;
  inline typed::map<Domain, Range> intersect_domain(const typed::point<Domain> &set) const;
  inline typed::map<Domain, Range> intersect_domain_wrapped_domain(const typed::set<> &domain) const = delete;
  inline typed::union_map<Domain, Range> intersect_domain_wrapped_domain(const typed::union_set<> &domain) const = delete;
  inline typed::map<Domain, Range> intersect_domain_wrapped_domain(const typed::basic_set<> &domain) const = delete;
  inline typed::map<Domain, Range> intersect_domain_wrapped_domain(const typed::point<> &domain) const = delete;
  inline typed::map<Domain, Range> intersect_params(const typed::set<> &params) const;
  inline typed::map<Domain, Range> intersect_params(const typed::basic_set<> &params) const;
  inline typed::map<Domain, Range> intersect_params(const typed::point<> &params) const;
  inline typed::map<Domain, Range> intersect_range(const typed::set<Range> &set) const;
  inline typed::union_map<Domain, Range> intersect_range(const typed::space<Range> &space) const;
  inline typed::union_map<Domain, Range> intersect_range(const typed::union_set<Range> &uset) const;
  inline typed::map<Domain, Range> intersect_range(const typed::basic_set<Range> &set) const;
  inline typed::map<Domain, Range> intersect_range(const typed::point<Range> &set) const;
  inline typed::map<Domain, Range> intersect_range_wrapped_domain(const typed::set<> &domain) const = delete;
  inline typed::union_map<Domain, Range> intersect_range_wrapped_domain(const typed::union_set<> &domain) const = delete;
  inline typed::map<Domain, Range> intersect_range_wrapped_domain(const typed::basic_set<> &domain) const = delete;
  inline typed::map<Domain, Range> intersect_range_wrapped_domain(const typed::point<> &domain) const = delete;
  inline typed::map<Domain, Range> lex_ge_at(const typed::multi_pw_aff<> &mpa) const = delete;
  inline typed::map<Domain, Range> lex_ge_at(const typed::aff<> &mpa) const = delete;
  inline typed::map<Domain, Range> lex_ge_at(const typed::multi_aff<> &mpa) const = delete;
  inline typed::map<Domain, Range> lex_ge_at(const typed::pw_aff<> &mpa) const = delete;
  inline typed::map<Domain, Range> lex_ge_at(const typed::pw_multi_aff<> &mpa) const = delete;
  inline typed::map<Domain, Range> lex_gt_at(const typed::multi_pw_aff<> &mpa) const = delete;
  inline typed::map<Domain, Range> lex_gt_at(const typed::aff<> &mpa) const = delete;
  inline typed::map<Domain, Range> lex_gt_at(const typed::multi_aff<> &mpa) const = delete;
  inline typed::map<Domain, Range> lex_gt_at(const typed::pw_aff<> &mpa) const = delete;
  inline typed::map<Domain, Range> lex_gt_at(const typed::pw_multi_aff<> &mpa) const = delete;
  inline typed::map<Domain, Range> lex_le_at(const typed::multi_pw_aff<> &mpa) const = delete;
  inline typed::map<Domain, Range> lex_le_at(const typed::aff<> &mpa) const = delete;
  inline typed::map<Domain, Range> lex_le_at(const typed::multi_aff<> &mpa) const = delete;
  inline typed::map<Domain, Range> lex_le_at(const typed::pw_aff<> &mpa) const = delete;
  inline typed::map<Domain, Range> lex_le_at(const typed::pw_multi_aff<> &mpa) const = delete;
  inline typed::map<Domain, Range> lex_lt_at(const typed::multi_pw_aff<> &mpa) const = delete;
  inline typed::map<Domain, Range> lex_lt_at(const typed::aff<> &mpa) const = delete;
  inline typed::map<Domain, Range> lex_lt_at(const typed::multi_aff<> &mpa) const = delete;
  inline typed::map<Domain, Range> lex_lt_at(const typed::pw_aff<> &mpa) const = delete;
  inline typed::map<Domain, Range> lex_lt_at(const typed::pw_multi_aff<> &mpa) const = delete;
  inline typed::map<Domain, Range> lexmax() const;
  inline typed::pw_multi_aff<Domain, Range> lexmax_pw_multi_aff() const;
  inline typed::map<Domain, Range> lexmin() const;
  inline typed::pw_multi_aff<Domain, Range> lexmin_pw_multi_aff() const;
  inline typed::map<Domain, Range> lower_bound(const typed::multi_pw_aff<Domain, Range> &lower) const;
  inline typed::map<Domain, Range> lower_bound(const typed::aff<Domain, Range> &lower) const;
  inline typed::map<Domain, Range> lower_bound(const typed::multi_aff<Domain, Range> &lower) const;
  inline typed::map<Domain, Range> lower_bound(const typed::pw_aff<Domain, Range> &lower) const;
  inline typed::map<Domain, Range> lower_bound(const typed::pw_multi_aff<Domain, Range> &lower) const;
  inline typed::map_list<Domain, Range> map_list() const;
  inline typed::multi_pw_aff<Domain, Range> max_multi_pw_aff() const;
  inline typed::multi_pw_aff<Domain, Range> min_multi_pw_aff() const;
  inline typed::set<> params() const;
  template <typename Domain2>
  inline typed::map<Domain2, Range> preimage_domain(const typed::multi_aff<Domain2, Domain> &ma) const;
  template <typename Domain2>
  inline typed::map<Domain2, Range> preimage_domain(const typed::multi_pw_aff<Domain2, Domain> &mpa) const;
  template <typename Domain2>
  inline typed::map<Domain2, Range> preimage_domain(const typed::pw_multi_aff<Domain2, Domain> &pma) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, Range> preimage_domain(const typed::union_pw_multi_aff<Domain2, Domain> &upma) const;
  template <typename Range2>
  inline typed::map<Domain, Range2> preimage_range(const typed::multi_aff<Range2, Range> &ma) const;
  template <typename Range2>
  inline typed::map<Domain, Range2> preimage_range(const typed::pw_multi_aff<Range2, Range> &pma) const;
  template <typename Range2>
  inline typed::union_map<Domain, Range2> preimage_range(const typed::union_pw_multi_aff<Range2, Range> &upma) const;
  template <typename Domain2, typename Range2>
  inline typed::map<pair<Domain, Domain2>, pair<Range, Range2>> product(const typed::map<Domain2, Range2> &map2) const;
  template <typename Domain2, typename Range2>
  inline typed::union_map<pair<Domain, Domain2>, pair<Range, Range2>> product(const typed::union_map<Domain2, Range2> &umap2) const;
  template <typename Domain2, typename Range2>
  inline typed::map<pair<Domain, Domain2>, pair<Range, Range2>> product(const typed::basic_map<Domain2, Range2> &map2) const;
  inline typed::map<Domain, Range> project_out_all_params() const;
  inline typed::map<Domain, Range> project_out_param(const typed::id<Anonymous> &id) const;
  inline typed::map<Domain, Range> project_out_param(const std::string &id) const;
  inline typed::map<Domain, Range> project_out_param(const typed::id_list<Anonymous> &list) const;
  inline typed::set<Range> range() const;
  inline typed::map<Domain, Range> range_factor_domain() const = delete;
  inline typed::map<Domain, Range> range_factor_range() const = delete;
  inline typed::fixed_box<Domain, Range> range_lattice_tile() const;
  inline typed::fixed_box<Domain, Range> get_range_lattice_tile() const = delete;
  inline typed::union_map<pair<Domain, Range>, Range> range_map() const;
  template <typename Range2>
  inline typed::map<Domain, pair<Range, Range2>> range_product(const typed::map<Domain, Range2> &map2) const;
  template <typename Range2>
  inline typed::union_map<Domain, pair<Range, Range2>> range_product(const typed::union_map<Domain, Range2> &umap2) const;
  template <typename Range2>
  inline typed::map<Domain, pair<Range, Range2>> range_product(const typed::basic_map<Domain, Range2> &map2) const;
  inline typed::map<Domain, Range> range_reverse() const = delete;
  inline typed::fixed_box<Domain, Range> range_simple_fixed_box_hull() const;
  inline typed::fixed_box<Domain, Range> get_range_simple_fixed_box_hull() const = delete;
  inline typed::id<Domain, Range> get_range_tuple_id() const = delete;
  inline typed::map<Range, Domain> reverse() const;
  template <typename Domain2>
  inline typed::map<Domain2, Range> set_domain_tuple(const typed::id<Anonymous> &id) const;
  template <typename Domain2>
  inline typed::map<Domain2, Range> set_domain_tuple(const std::string &id) const;
  template <typename Range2>
  inline typed::map<Domain, Range2> set_range_tuple(const typed::id<Anonymous> &id) const;
  template <typename Range2>
  inline typed::map<Domain, Range2> set_range_tuple(const std::string &id) const;
  inline typed::space<Domain, Range> space() const;
  inline typed::space<Domain, Range> get_space() const = delete;
  inline typed::map<Domain, Range> subtract(const typed::map<Domain, Range> &map2) const;
  inline typed::union_map<Domain, Range> subtract(const typed::union_map<Domain, Range> &umap2) const;
  inline typed::map<Domain, Range> subtract(const typed::basic_map<Domain, Range> &map2) const;
  inline typed::union_map<Domain, Range> subtract_domain(const typed::union_set<Domain> &dom) const;
  inline typed::union_map<Domain, Range> subtract_range(const typed::union_set<Range> &dom) const;
  inline typed::union_map<Domain, Range> to_union_map() const;
  inline typed::map<Domain, Range> uncurry() const = delete;
  inline typed::map<Domain, Range> unite(const typed::map<Domain, Range> &map2) const;
  inline typed::union_map<Domain, Range> unite(const typed::union_map<Domain, Range> &umap2) const;
  inline typed::map<Domain, Range> unite(const typed::basic_map<Domain, Range> &map2) const;
  static inline typed::map<Domain, Range> universe(const typed::space<Domain, Range> &space);
  inline typed::map<Domain, Range> upper_bound(const typed::multi_pw_aff<Domain, Range> &upper) const;
  inline typed::map<Domain, Range> upper_bound(const typed::aff<Domain, Range> &upper) const;
  inline typed::map<Domain, Range> upper_bound(const typed::multi_aff<Domain, Range> &upper) const;
  inline typed::map<Domain, Range> upper_bound(const typed::pw_aff<Domain, Range> &upper) const;
  inline typed::map<Domain, Range> upper_bound(const typed::pw_multi_aff<Domain, Range> &upper) const;
  inline typed::set<pair<Domain, Range>> wrap() const;
};

template <typename Domain, typename Range, typename Range2>
struct map<pair<Domain, Range>, Range2> : public isl::map {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  map() = default;
  template <typename Arg1, typename Arg2, typename Arg3,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{} &&
              std::is_base_of<Range, Arg2>{} &&
              std::is_base_of<Range2, Arg3>{},
            bool>::type = true>
  map(const map<pair<Arg1, Arg2>, Arg3> &obj) : isl::map(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::map>{}, bool>::type = true>
  map(const base &obj) : isl::map(obj) {}
 public:
  static map from(const isl::map &obj) {
    return map(obj);
  }
  inline /* implicit */ map(const typed::basic_map<pair<Domain, Range>, Range2> &bmap);
  inline explicit map(const isl::ctx &ctx, const std::string &str);
  template <typename Domain2>
  inline typed::map<Domain2, Range2> apply_domain(const typed::map<pair<Domain, Range>, Domain2> &map2) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, Range2> apply_domain(const typed::union_map<pair<Domain, Range>, Domain2> &umap2) const;
  template <typename Domain2>
  inline typed::map<Domain2, Range2> apply_domain(const typed::basic_map<pair<Domain, Range>, Domain2> &map2) const;
  template <typename Arg3>
  inline typed::map<pair<Domain, Range>, Arg3> apply_range(const typed::map<Range2, Arg3> &map2) const;
  template <typename Arg3>
  inline typed::union_map<pair<Domain, Range>, Arg3> apply_range(const typed::union_map<Range2, Arg3> &umap2) const;
  template <typename Arg3>
  inline typed::map<pair<Domain, Range>, Arg3> apply_range(const typed::basic_map<Range2, Arg3> &map2) const;
  inline typed::map<pair<Domain, Range>, Range2> as_map() const;
  inline typed::multi_union_pw_aff<pair<Domain, Range>, Range2> as_multi_union_pw_aff() const;
  inline typed::pw_multi_aff<pair<Domain, Range>, Range2> as_pw_multi_aff() const;
  inline typed::union_pw_multi_aff<pair<Domain, Range>, Range2> as_union_pw_multi_aff() const;
  inline typed::set<Range2> bind_domain(const typed::multi_id<pair<Domain, Range>> &tuple) const;
  inline typed::set<pair<Domain, Range>> bind_range(const typed::multi_id<Range2> &tuple) const;
  inline typed::map<pair<Domain, Range>, Range2> coalesce() const;
  inline typed::map<Domain, pair<Range, Range2>> curry() const;
  inline typed::set<pair<Domain, Range>, Range2> deltas() const = delete;
  inline typed::map<pair<Domain, Range>, Range2> detect_equalities() const;
  inline typed::set<pair<Domain, Range>> domain() const;
  inline typed::map<Domain, Range2> domain_factor_domain() const;
  inline typed::map<Range, Range2> domain_factor_range() const;
  inline typed::union_map<pair<pair<Domain, Range>, Range2>, pair<Domain, Range>> domain_map() const;
  inline typed::union_pw_multi_aff<pair<pair<Domain, Range>, Range2>, pair<Domain, Range>> domain_map_union_pw_multi_aff() const;
  template <typename Domain2>
  inline typed::map<pair<pair<Domain, Range>, Domain2>, Range2> domain_product(const typed::map<Domain2, Range2> &map2) const;
  template <typename Domain2>
  inline typed::union_map<pair<pair<Domain, Range>, Domain2>, Range2> domain_product(const typed::union_map<Domain2, Range2> &umap2) const;
  template <typename Domain2>
  inline typed::map<pair<pair<Domain, Range>, Domain2>, Range2> domain_product(const typed::basic_map<Domain2, Range2> &map2) const;
  inline typed::map<pair<Range, Domain>, Range2> domain_reverse() const;
  inline typed::id<pair<Domain, Range>, Range2> get_domain_tuple_id() const = delete;
  inline typed::map<pair<Domain, Range>, Range2> drop_unused_params() const;
  inline typed::map<pair<Domain, Range>, Range2> eq_at(const typed::multi_pw_aff<> &mpa) const = delete;
  inline typed::union_map<pair<Domain, Range>, Range2> eq_at(const typed::multi_union_pw_aff<> &mupa) const = delete;
  inline typed::map<pair<Domain, Range>, Range2> eq_at(const typed::aff<> &mpa) const = delete;
  inline typed::map<pair<Domain, Range>, Range2> eq_at(const typed::multi_aff<> &mpa) const = delete;
  inline typed::map<pair<Domain, Range>, Range2> eq_at(const typed::pw_aff<> &mpa) const = delete;
  inline typed::map<pair<Domain, Range>, Range2> eq_at(const typed::pw_multi_aff<> &mpa) const = delete;
  inline bool every_map(const std::function<bool(typed::map<pair<Domain, Range>, Range2>)> &test) const;
  inline typed::map<pair<Domain, Range>, Range2> extract_map(const typed::space<pair<Domain, Range>, Range2> &space) const;
  inline typed::map<Anonymous, Range2> flatten_domain() const;
  inline typed::map<pair<Domain, Range>, Range2> flatten_range() const = delete;
  inline void foreach_basic_map(const std::function<void(typed::basic_map<pair<Domain, Range>, Range2>)> &fn) const;
  inline void foreach_map(const std::function<void(typed::map<pair<Domain, Range>, Range2>)> &fn) const;
  inline typed::map<pair<Domain, Range>, Range2> gist(const typed::map<pair<Domain, Range>, Range2> &context) const;
  inline typed::union_map<pair<Domain, Range>, Range2> gist(const typed::union_map<pair<Domain, Range>, Range2> &context) const;
  inline typed::map<pair<Domain, Range>, Range2> gist(const typed::basic_map<pair<Domain, Range>, Range2> &context) const;
  inline typed::map<pair<Domain, Range>, Range2> gist_domain(const typed::set<pair<Domain, Range>> &context) const;
  inline typed::union_map<pair<Domain, Range>, Range2> gist_domain(const typed::union_set<pair<Domain, Range>> &uset) const;
  inline typed::map<pair<Domain, Range>, Range2> gist_domain(const typed::basic_set<pair<Domain, Range>> &context) const;
  inline typed::map<pair<Domain, Range>, Range2> gist_domain(const typed::point<pair<Domain, Range>> &context) const;
  inline typed::map<pair<Domain, Range>, Range2> gist_params(const typed::set<> &context) const;
  inline typed::map<pair<Domain, Range>, Range2> gist_params(const typed::basic_set<> &context) const;
  inline typed::map<pair<Domain, Range>, Range2> gist_params(const typed::point<> &context) const;
  inline typed::map<pair<Domain, Range>, Range2> intersect(const typed::map<pair<Domain, Range>, Range2> &map2) const;
  inline typed::union_map<pair<Domain, Range>, Range2> intersect(const typed::union_map<pair<Domain, Range>, Range2> &umap2) const;
  inline typed::map<pair<Domain, Range>, Range2> intersect(const typed::basic_map<pair<Domain, Range>, Range2> &map2) const;
  inline typed::map<pair<Domain, Range>, Range2> intersect_domain(const typed::set<pair<Domain, Range>> &set) const;
  inline typed::union_map<pair<Domain, Range>, Range2> intersect_domain(const typed::space<pair<Domain, Range>> &space) const;
  inline typed::union_map<pair<Domain, Range>, Range2> intersect_domain(const typed::union_set<pair<Domain, Range>> &uset) const;
  inline typed::map<pair<Domain, Range>, Range2> intersect_domain(const typed::basic_set<pair<Domain, Range>> &set) const;
  inline typed::map<pair<Domain, Range>, Range2> intersect_domain(const typed::point<pair<Domain, Range>> &set) const;
  inline typed::map<pair<Domain, Range>, Range2> intersect_domain_wrapped_domain(const typed::set<Domain> &domain) const;
  inline typed::union_map<pair<Domain, Range>, Range2> intersect_domain_wrapped_domain(const typed::union_set<Domain> &domain) const;
  inline typed::map<pair<Domain, Range>, Range2> intersect_domain_wrapped_domain(const typed::basic_set<Domain> &domain) const;
  inline typed::map<pair<Domain, Range>, Range2> intersect_domain_wrapped_domain(const typed::point<Domain> &domain) const;
  inline typed::map<pair<Domain, Range>, Range2> intersect_params(const typed::set<> &params) const;
  inline typed::map<pair<Domain, Range>, Range2> intersect_params(const typed::basic_set<> &params) const;
  inline typed::map<pair<Domain, Range>, Range2> intersect_params(const typed::point<> &params) const;
  inline typed::map<pair<Domain, Range>, Range2> intersect_range(const typed::set<Range2> &set) const;
  inline typed::union_map<pair<Domain, Range>, Range2> intersect_range(const typed::space<Range2> &space) const;
  inline typed::union_map<pair<Domain, Range>, Range2> intersect_range(const typed::union_set<Range2> &uset) const;
  inline typed::map<pair<Domain, Range>, Range2> intersect_range(const typed::basic_set<Range2> &set) const;
  inline typed::map<pair<Domain, Range>, Range2> intersect_range(const typed::point<Range2> &set) const;
  inline typed::map<pair<Domain, Range>, Range2> intersect_range_wrapped_domain(const typed::set<> &domain) const = delete;
  inline typed::union_map<pair<Domain, Range>, Range2> intersect_range_wrapped_domain(const typed::union_set<> &domain) const = delete;
  inline typed::map<pair<Domain, Range>, Range2> intersect_range_wrapped_domain(const typed::basic_set<> &domain) const = delete;
  inline typed::map<pair<Domain, Range>, Range2> intersect_range_wrapped_domain(const typed::point<> &domain) const = delete;
  inline typed::map<pair<Domain, Range>, Range2> lex_ge_at(const typed::multi_pw_aff<> &mpa) const = delete;
  inline typed::map<pair<Domain, Range>, Range2> lex_ge_at(const typed::aff<> &mpa) const = delete;
  inline typed::map<pair<Domain, Range>, Range2> lex_ge_at(const typed::multi_aff<> &mpa) const = delete;
  inline typed::map<pair<Domain, Range>, Range2> lex_ge_at(const typed::pw_aff<> &mpa) const = delete;
  inline typed::map<pair<Domain, Range>, Range2> lex_ge_at(const typed::pw_multi_aff<> &mpa) const = delete;
  inline typed::map<pair<Domain, Range>, Range2> lex_gt_at(const typed::multi_pw_aff<> &mpa) const = delete;
  inline typed::map<pair<Domain, Range>, Range2> lex_gt_at(const typed::aff<> &mpa) const = delete;
  inline typed::map<pair<Domain, Range>, Range2> lex_gt_at(const typed::multi_aff<> &mpa) const = delete;
  inline typed::map<pair<Domain, Range>, Range2> lex_gt_at(const typed::pw_aff<> &mpa) const = delete;
  inline typed::map<pair<Domain, Range>, Range2> lex_gt_at(const typed::pw_multi_aff<> &mpa) const = delete;
  inline typed::map<pair<Domain, Range>, Range2> lex_le_at(const typed::multi_pw_aff<> &mpa) const = delete;
  inline typed::map<pair<Domain, Range>, Range2> lex_le_at(const typed::aff<> &mpa) const = delete;
  inline typed::map<pair<Domain, Range>, Range2> lex_le_at(const typed::multi_aff<> &mpa) const = delete;
  inline typed::map<pair<Domain, Range>, Range2> lex_le_at(const typed::pw_aff<> &mpa) const = delete;
  inline typed::map<pair<Domain, Range>, Range2> lex_le_at(const typed::pw_multi_aff<> &mpa) const = delete;
  inline typed::map<pair<Domain, Range>, Range2> lex_lt_at(const typed::multi_pw_aff<> &mpa) const = delete;
  inline typed::map<pair<Domain, Range>, Range2> lex_lt_at(const typed::aff<> &mpa) const = delete;
  inline typed::map<pair<Domain, Range>, Range2> lex_lt_at(const typed::multi_aff<> &mpa) const = delete;
  inline typed::map<pair<Domain, Range>, Range2> lex_lt_at(const typed::pw_aff<> &mpa) const = delete;
  inline typed::map<pair<Domain, Range>, Range2> lex_lt_at(const typed::pw_multi_aff<> &mpa) const = delete;
  inline typed::map<pair<Domain, Range>, Range2> lexmax() const;
  inline typed::pw_multi_aff<pair<Domain, Range>, Range2> lexmax_pw_multi_aff() const;
  inline typed::map<pair<Domain, Range>, Range2> lexmin() const;
  inline typed::pw_multi_aff<pair<Domain, Range>, Range2> lexmin_pw_multi_aff() const;
  inline typed::map<pair<Domain, Range>, Range2> lower_bound(const typed::multi_pw_aff<pair<Domain, Range>, Range2> &lower) const;
  inline typed::map<pair<Domain, Range>, Range2> lower_bound(const typed::aff<pair<Domain, Range>, Range2> &lower) const;
  inline typed::map<pair<Domain, Range>, Range2> lower_bound(const typed::multi_aff<pair<Domain, Range>, Range2> &lower) const;
  inline typed::map<pair<Domain, Range>, Range2> lower_bound(const typed::pw_aff<pair<Domain, Range>, Range2> &lower) const;
  inline typed::map<pair<Domain, Range>, Range2> lower_bound(const typed::pw_multi_aff<pair<Domain, Range>, Range2> &lower) const;
  inline typed::map_list<pair<Domain, Range>, Range2> map_list() const;
  inline typed::multi_pw_aff<pair<Domain, Range>, Range2> max_multi_pw_aff() const;
  inline typed::multi_pw_aff<pair<Domain, Range>, Range2> min_multi_pw_aff() const;
  inline typed::set<> params() const;
  template <typename Domain2>
  inline typed::map<Domain2, Range2> preimage_domain(const typed::multi_aff<Domain2, pair<Domain, Range>> &ma) const;
  template <typename Domain2>
  inline typed::map<Domain2, Range2> preimage_domain(const typed::multi_pw_aff<Domain2, pair<Domain, Range>> &mpa) const;
  template <typename Domain2>
  inline typed::map<Domain2, Range2> preimage_domain(const typed::pw_multi_aff<Domain2, pair<Domain, Range>> &pma) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, Range2> preimage_domain(const typed::union_pw_multi_aff<Domain2, pair<Domain, Range>> &upma) const;
  template <typename Arg3>
  inline typed::map<pair<Domain, Range>, Arg3> preimage_range(const typed::multi_aff<Arg3, Range2> &ma) const;
  template <typename Arg3>
  inline typed::map<pair<Domain, Range>, Arg3> preimage_range(const typed::pw_multi_aff<Arg3, Range2> &pma) const;
  template <typename Arg3>
  inline typed::union_map<pair<Domain, Range>, Arg3> preimage_range(const typed::union_pw_multi_aff<Arg3, Range2> &upma) const;
  template <typename Domain2, typename Arg3>
  inline typed::map<pair<pair<Domain, Range>, Domain2>, pair<Range2, Arg3>> product(const typed::map<Domain2, Arg3> &map2) const;
  template <typename Domain2, typename Arg3>
  inline typed::union_map<pair<pair<Domain, Range>, Domain2>, pair<Range2, Arg3>> product(const typed::union_map<Domain2, Arg3> &umap2) const;
  template <typename Domain2, typename Arg3>
  inline typed::map<pair<pair<Domain, Range>, Domain2>, pair<Range2, Arg3>> product(const typed::basic_map<Domain2, Arg3> &map2) const;
  inline typed::map<pair<Domain, Range>, Range2> project_out_all_params() const;
  inline typed::map<pair<Domain, Range>, Range2> project_out_param(const typed::id<Anonymous> &id) const;
  inline typed::map<pair<Domain, Range>, Range2> project_out_param(const std::string &id) const;
  inline typed::map<pair<Domain, Range>, Range2> project_out_param(const typed::id_list<Anonymous> &list) const;
  inline typed::set<Range2> range() const;
  inline typed::map<pair<Domain, Range>, Range2> range_factor_domain() const = delete;
  inline typed::map<pair<Domain, Range>, Range2> range_factor_range() const = delete;
  inline typed::fixed_box<pair<Domain, Range>, Range2> range_lattice_tile() const;
  inline typed::fixed_box<pair<Domain, Range>, Range2> get_range_lattice_tile() const = delete;
  inline typed::union_map<pair<pair<Domain, Range>, Range2>, Range2> range_map() const;
  template <typename Arg3>
  inline typed::map<pair<Domain, Range>, pair<Range2, Arg3>> range_product(const typed::map<pair<Domain, Range>, Arg3> &map2) const;
  template <typename Arg3>
  inline typed::union_map<pair<Domain, Range>, pair<Range2, Arg3>> range_product(const typed::union_map<pair<Domain, Range>, Arg3> &umap2) const;
  template <typename Arg3>
  inline typed::map<pair<Domain, Range>, pair<Range2, Arg3>> range_product(const typed::basic_map<pair<Domain, Range>, Arg3> &map2) const;
  inline typed::map<pair<Domain, Range>, Range2> range_reverse() const = delete;
  inline typed::fixed_box<pair<Domain, Range>, Range2> range_simple_fixed_box_hull() const;
  inline typed::fixed_box<pair<Domain, Range>, Range2> get_range_simple_fixed_box_hull() const = delete;
  inline typed::id<pair<Domain, Range>, Range2> get_range_tuple_id() const = delete;
  inline typed::map<Range2, pair<Domain, Range>> reverse() const;
  inline typed::map<pair<Domain, Range>, Range2> set_domain_tuple(const typed::id<> &id) const = delete;
  inline typed::map<pair<Domain, Range>, Range2> set_domain_tuple(const std::string &id) const = delete;
  template <typename Arg2>
  inline typed::map<pair<Domain, Range>, Arg2> set_range_tuple(const typed::id<Anonymous> &id) const;
  template <typename Arg2>
  inline typed::map<pair<Domain, Range>, Arg2> set_range_tuple(const std::string &id) const;
  inline typed::space<pair<Domain, Range>, Range2> space() const;
  inline typed::space<pair<Domain, Range>, Range2> get_space() const = delete;
  inline typed::map<pair<Domain, Range>, Range2> subtract(const typed::map<pair<Domain, Range>, Range2> &map2) const;
  inline typed::union_map<pair<Domain, Range>, Range2> subtract(const typed::union_map<pair<Domain, Range>, Range2> &umap2) const;
  inline typed::map<pair<Domain, Range>, Range2> subtract(const typed::basic_map<pair<Domain, Range>, Range2> &map2) const;
  inline typed::union_map<pair<Domain, Range>, Range2> subtract_domain(const typed::union_set<pair<Domain, Range>> &dom) const;
  inline typed::union_map<pair<Domain, Range>, Range2> subtract_range(const typed::union_set<Range2> &dom) const;
  inline typed::union_map<pair<Domain, Range>, Range2> to_union_map() const;
  inline typed::map<pair<Domain, Range>, Range2> uncurry() const = delete;
  inline typed::map<pair<Domain, Range>, Range2> unite(const typed::map<pair<Domain, Range>, Range2> &map2) const;
  inline typed::union_map<pair<Domain, Range>, Range2> unite(const typed::union_map<pair<Domain, Range>, Range2> &umap2) const;
  inline typed::map<pair<Domain, Range>, Range2> unite(const typed::basic_map<pair<Domain, Range>, Range2> &map2) const;
  static inline typed::map<pair<Domain, Range>, Range2> universe(const typed::space<pair<Domain, Range>, Range2> &space);
  inline typed::map<pair<Domain, Range>, Range2> upper_bound(const typed::multi_pw_aff<pair<Domain, Range>, Range2> &upper) const;
  inline typed::map<pair<Domain, Range>, Range2> upper_bound(const typed::aff<pair<Domain, Range>, Range2> &upper) const;
  inline typed::map<pair<Domain, Range>, Range2> upper_bound(const typed::multi_aff<pair<Domain, Range>, Range2> &upper) const;
  inline typed::map<pair<Domain, Range>, Range2> upper_bound(const typed::pw_aff<pair<Domain, Range>, Range2> &upper) const;
  inline typed::map<pair<Domain, Range>, Range2> upper_bound(const typed::pw_multi_aff<pair<Domain, Range>, Range2> &upper) const;
  inline typed::set<pair<pair<Domain, Range>, Range2>> wrap() const;
};

template <typename Domain>
struct map<Domain, Domain> : public isl::map {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  map() = default;
  template <typename Arg1,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{},
            bool>::type = true>
  map(const map<Arg1, Arg1> &obj) : isl::map(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::map>{}, bool>::type = true>
  map(const base &obj) : isl::map(obj) {}
 public:
  static map from(const isl::map &obj) {
    return map(obj);
  }
  inline /* implicit */ map(const typed::basic_map<Domain, Domain> &bmap);
  inline explicit map(const isl::ctx &ctx, const std::string &str);
  template <typename Domain2>
  inline typed::map<Domain2, Domain> apply_domain(const typed::map<Domain, Domain2> &map2) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, Domain> apply_domain(const typed::union_map<Domain, Domain2> &umap2) const;
  template <typename Domain2>
  inline typed::map<Domain2, Domain> apply_domain(const typed::basic_map<Domain, Domain2> &map2) const;
  template <typename Range2>
  inline typed::map<Domain, Range2> apply_range(const typed::map<Domain, Range2> &map2) const;
  template <typename Range2>
  inline typed::union_map<Domain, Range2> apply_range(const typed::union_map<Domain, Range2> &umap2) const;
  template <typename Range2>
  inline typed::map<Domain, Range2> apply_range(const typed::basic_map<Domain, Range2> &map2) const;
  inline typed::map<Domain, Domain> as_map() const;
  inline typed::multi_union_pw_aff<Domain, Domain> as_multi_union_pw_aff() const;
  inline typed::pw_multi_aff<Domain, Domain> as_pw_multi_aff() const;
  inline typed::union_pw_multi_aff<Domain, Domain> as_union_pw_multi_aff() const;
  inline typed::set<Domain> bind_domain(const typed::multi_id<Domain> &tuple) const;
  inline typed::set<Domain> bind_range(const typed::multi_id<Domain> &tuple) const;
  inline typed::map<Domain, Domain> coalesce() const;
  inline typed::map<Domain, Domain> curry() const = delete;
  inline typed::set<Domain> deltas() const;
  inline typed::map<Domain, Domain> detect_equalities() const;
  inline typed::set<Domain> domain() const;
  inline typed::map<Domain, Domain> domain_factor_domain() const = delete;
  inline typed::map<Domain, Domain> domain_factor_range() const = delete;
  inline typed::union_map<pair<Domain, Domain>, Domain> domain_map() const;
  inline typed::union_pw_multi_aff<pair<Domain, Domain>, Domain> domain_map_union_pw_multi_aff() const;
  template <typename Domain2>
  inline typed::map<pair<Domain, Domain2>, Domain> domain_product(const typed::map<Domain2, Domain> &map2) const;
  template <typename Domain2>
  inline typed::union_map<pair<Domain, Domain2>, Domain> domain_product(const typed::union_map<Domain2, Domain> &umap2) const;
  template <typename Domain2>
  inline typed::map<pair<Domain, Domain2>, Domain> domain_product(const typed::basic_map<Domain2, Domain> &map2) const;
  inline typed::map<Domain, Domain> domain_reverse() const = delete;
  inline typed::id<Domain, Domain> get_domain_tuple_id() const = delete;
  inline typed::map<Domain, Domain> drop_unused_params() const;
  template <typename Range>
  inline typed::map<Domain, Domain> eq_at(const typed::multi_pw_aff<Domain, Range> &mpa) const;
  template <typename Range>
  inline typed::union_map<Domain, Domain> eq_at(const typed::multi_union_pw_aff<Domain, Range> &mupa) const;
  inline typed::map<Domain, Domain> eq_at(const typed::aff<Domain, Anonymous> &mpa) const;
  template <typename Range>
  inline typed::map<Domain, Domain> eq_at(const typed::multi_aff<Domain, Range> &mpa) const;
  inline typed::map<Domain, Domain> eq_at(const typed::pw_aff<Domain, Anonymous> &mpa) const;
  template <typename Range>
  inline typed::map<Domain, Domain> eq_at(const typed::pw_multi_aff<Domain, Range> &mpa) const;
  inline bool every_map(const std::function<bool(typed::map<Domain, Domain>)> &test) const;
  inline typed::map<Domain, Domain> extract_map(const typed::space<Domain, Domain> &space) const;
  inline typed::map<Domain, Domain> flatten_domain() const = delete;
  inline typed::map<Domain, Domain> flatten_range() const = delete;
  inline void foreach_basic_map(const std::function<void(typed::basic_map<Domain, Domain>)> &fn) const;
  inline void foreach_map(const std::function<void(typed::map<Domain, Domain>)> &fn) const;
  inline typed::map<Domain, Domain> gist(const typed::map<Domain, Domain> &context) const;
  inline typed::union_map<Domain, Domain> gist(const typed::union_map<Domain, Domain> &context) const;
  inline typed::map<Domain, Domain> gist(const typed::basic_map<Domain, Domain> &context) const;
  inline typed::map<Domain, Domain> gist_domain(const typed::set<Domain> &context) const;
  inline typed::union_map<Domain, Domain> gist_domain(const typed::union_set<Domain> &uset) const;
  inline typed::map<Domain, Domain> gist_domain(const typed::basic_set<Domain> &context) const;
  inline typed::map<Domain, Domain> gist_domain(const typed::point<Domain> &context) const;
  inline typed::map<Domain, Domain> gist_params(const typed::set<> &context) const;
  inline typed::map<Domain, Domain> gist_params(const typed::basic_set<> &context) const;
  inline typed::map<Domain, Domain> gist_params(const typed::point<> &context) const;
  inline typed::map<Domain, Domain> intersect(const typed::map<Domain, Domain> &map2) const;
  inline typed::union_map<Domain, Domain> intersect(const typed::union_map<Domain, Domain> &umap2) const;
  inline typed::map<Domain, Domain> intersect(const typed::basic_map<Domain, Domain> &map2) const;
  inline typed::map<Domain, Domain> intersect_domain(const typed::set<Domain> &set) const;
  inline typed::union_map<Domain, Domain> intersect_domain(const typed::space<Domain> &space) const;
  inline typed::union_map<Domain, Domain> intersect_domain(const typed::union_set<Domain> &uset) const;
  inline typed::map<Domain, Domain> intersect_domain(const typed::basic_set<Domain> &set) const;
  inline typed::map<Domain, Domain> intersect_domain(const typed::point<Domain> &set) const;
  inline typed::map<Domain, Domain> intersect_domain_wrapped_domain(const typed::set<> &domain) const = delete;
  inline typed::union_map<Domain, Domain> intersect_domain_wrapped_domain(const typed::union_set<> &domain) const = delete;
  inline typed::map<Domain, Domain> intersect_domain_wrapped_domain(const typed::basic_set<> &domain) const = delete;
  inline typed::map<Domain, Domain> intersect_domain_wrapped_domain(const typed::point<> &domain) const = delete;
  inline typed::map<Domain, Domain> intersect_params(const typed::set<> &params) const;
  inline typed::map<Domain, Domain> intersect_params(const typed::basic_set<> &params) const;
  inline typed::map<Domain, Domain> intersect_params(const typed::point<> &params) const;
  inline typed::map<Domain, Domain> intersect_range(const typed::set<Domain> &set) const;
  inline typed::union_map<Domain, Domain> intersect_range(const typed::space<Domain> &space) const;
  inline typed::union_map<Domain, Domain> intersect_range(const typed::union_set<Domain> &uset) const;
  inline typed::map<Domain, Domain> intersect_range(const typed::basic_set<Domain> &set) const;
  inline typed::map<Domain, Domain> intersect_range(const typed::point<Domain> &set) const;
  inline typed::map<Domain, Domain> intersect_range_wrapped_domain(const typed::set<> &domain) const = delete;
  inline typed::union_map<Domain, Domain> intersect_range_wrapped_domain(const typed::union_set<> &domain) const = delete;
  inline typed::map<Domain, Domain> intersect_range_wrapped_domain(const typed::basic_set<> &domain) const = delete;
  inline typed::map<Domain, Domain> intersect_range_wrapped_domain(const typed::point<> &domain) const = delete;
  template <typename Range>
  inline typed::map<Domain, Domain> lex_ge_at(const typed::multi_pw_aff<Domain, Range> &mpa) const;
  inline typed::map<Domain, Domain> lex_ge_at(const typed::aff<Domain, Anonymous> &mpa) const;
  template <typename Range>
  inline typed::map<Domain, Domain> lex_ge_at(const typed::multi_aff<Domain, Range> &mpa) const;
  inline typed::map<Domain, Domain> lex_ge_at(const typed::pw_aff<Domain, Anonymous> &mpa) const;
  template <typename Range>
  inline typed::map<Domain, Domain> lex_ge_at(const typed::pw_multi_aff<Domain, Range> &mpa) const;
  template <typename Range>
  inline typed::map<Domain, Domain> lex_gt_at(const typed::multi_pw_aff<Domain, Range> &mpa) const;
  inline typed::map<Domain, Domain> lex_gt_at(const typed::aff<Domain, Anonymous> &mpa) const;
  template <typename Range>
  inline typed::map<Domain, Domain> lex_gt_at(const typed::multi_aff<Domain, Range> &mpa) const;
  inline typed::map<Domain, Domain> lex_gt_at(const typed::pw_aff<Domain, Anonymous> &mpa) const;
  template <typename Range>
  inline typed::map<Domain, Domain> lex_gt_at(const typed::pw_multi_aff<Domain, Range> &mpa) const;
  template <typename Range>
  inline typed::map<Domain, Domain> lex_le_at(const typed::multi_pw_aff<Domain, Range> &mpa) const;
  inline typed::map<Domain, Domain> lex_le_at(const typed::aff<Domain, Anonymous> &mpa) const;
  template <typename Range>
  inline typed::map<Domain, Domain> lex_le_at(const typed::multi_aff<Domain, Range> &mpa) const;
  inline typed::map<Domain, Domain> lex_le_at(const typed::pw_aff<Domain, Anonymous> &mpa) const;
  template <typename Range>
  inline typed::map<Domain, Domain> lex_le_at(const typed::pw_multi_aff<Domain, Range> &mpa) const;
  template <typename Range>
  inline typed::map<Domain, Domain> lex_lt_at(const typed::multi_pw_aff<Domain, Range> &mpa) const;
  inline typed::map<Domain, Domain> lex_lt_at(const typed::aff<Domain, Anonymous> &mpa) const;
  template <typename Range>
  inline typed::map<Domain, Domain> lex_lt_at(const typed::multi_aff<Domain, Range> &mpa) const;
  inline typed::map<Domain, Domain> lex_lt_at(const typed::pw_aff<Domain, Anonymous> &mpa) const;
  template <typename Range>
  inline typed::map<Domain, Domain> lex_lt_at(const typed::pw_multi_aff<Domain, Range> &mpa) const;
  inline typed::map<Domain, Domain> lexmax() const;
  inline typed::pw_multi_aff<Domain, Domain> lexmax_pw_multi_aff() const;
  inline typed::map<Domain, Domain> lexmin() const;
  inline typed::pw_multi_aff<Domain, Domain> lexmin_pw_multi_aff() const;
  inline typed::map<Domain, Domain> lower_bound(const typed::multi_pw_aff<Domain, Domain> &lower) const;
  inline typed::map<Domain, Domain> lower_bound(const typed::aff<Domain, Domain> &lower) const;
  inline typed::map<Domain, Domain> lower_bound(const typed::multi_aff<Domain, Domain> &lower) const;
  inline typed::map<Domain, Domain> lower_bound(const typed::pw_aff<Domain, Domain> &lower) const;
  inline typed::map<Domain, Domain> lower_bound(const typed::pw_multi_aff<Domain, Domain> &lower) const;
  inline typed::map_list<Domain, Domain> map_list() const;
  inline typed::multi_pw_aff<Domain, Domain> max_multi_pw_aff() const;
  inline typed::multi_pw_aff<Domain, Domain> min_multi_pw_aff() const;
  inline typed::set<> params() const;
  template <typename Domain2>
  inline typed::map<Domain2, Domain> preimage_domain(const typed::multi_aff<Domain2, Domain> &ma) const;
  template <typename Domain2>
  inline typed::map<Domain2, Domain> preimage_domain(const typed::multi_pw_aff<Domain2, Domain> &mpa) const;
  template <typename Domain2>
  inline typed::map<Domain2, Domain> preimage_domain(const typed::pw_multi_aff<Domain2, Domain> &pma) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, Domain> preimage_domain(const typed::union_pw_multi_aff<Domain2, Domain> &upma) const;
  template <typename Range2>
  inline typed::map<Domain, Range2> preimage_range(const typed::multi_aff<Range2, Domain> &ma) const;
  template <typename Range2>
  inline typed::map<Domain, Range2> preimage_range(const typed::pw_multi_aff<Range2, Domain> &pma) const;
  template <typename Range2>
  inline typed::union_map<Domain, Range2> preimage_range(const typed::union_pw_multi_aff<Range2, Domain> &upma) const;
  template <typename Domain2, typename Range2>
  inline typed::map<pair<Domain, Domain2>, pair<Domain, Range2>> product(const typed::map<Domain2, Range2> &map2) const;
  template <typename Domain2, typename Range2>
  inline typed::union_map<pair<Domain, Domain2>, pair<Domain, Range2>> product(const typed::union_map<Domain2, Range2> &umap2) const;
  template <typename Domain2, typename Range2>
  inline typed::map<pair<Domain, Domain2>, pair<Domain, Range2>> product(const typed::basic_map<Domain2, Range2> &map2) const;
  inline typed::map<Domain, Domain> project_out_all_params() const;
  inline typed::map<Domain, Domain> project_out_param(const typed::id<Anonymous> &id) const;
  inline typed::map<Domain, Domain> project_out_param(const std::string &id) const;
  inline typed::map<Domain, Domain> project_out_param(const typed::id_list<Anonymous> &list) const;
  inline typed::set<Domain> range() const;
  inline typed::map<Domain, Domain> range_factor_domain() const = delete;
  inline typed::map<Domain, Domain> range_factor_range() const = delete;
  inline typed::fixed_box<Domain, Domain> range_lattice_tile() const;
  inline typed::fixed_box<Domain, Domain> get_range_lattice_tile() const = delete;
  inline typed::union_map<pair<Domain, Domain>, Domain> range_map() const;
  template <typename Range2>
  inline typed::map<Domain, pair<Domain, Range2>> range_product(const typed::map<Domain, Range2> &map2) const;
  template <typename Range2>
  inline typed::union_map<Domain, pair<Domain, Range2>> range_product(const typed::union_map<Domain, Range2> &umap2) const;
  template <typename Range2>
  inline typed::map<Domain, pair<Domain, Range2>> range_product(const typed::basic_map<Domain, Range2> &map2) const;
  inline typed::map<Domain, Domain> range_reverse() const = delete;
  inline typed::fixed_box<Domain, Domain> range_simple_fixed_box_hull() const;
  inline typed::fixed_box<Domain, Domain> get_range_simple_fixed_box_hull() const = delete;
  inline typed::id<Domain, Domain> get_range_tuple_id() const = delete;
  inline typed::map<Domain, Domain> reverse() const;
  template <typename Domain2>
  inline typed::map<Domain2, Domain> set_domain_tuple(const typed::id<Anonymous> &id) const;
  template <typename Domain2>
  inline typed::map<Domain2, Domain> set_domain_tuple(const std::string &id) const;
  template <typename Range2>
  inline typed::map<Domain, Range2> set_range_tuple(const typed::id<Anonymous> &id) const;
  template <typename Range2>
  inline typed::map<Domain, Range2> set_range_tuple(const std::string &id) const;
  inline typed::space<Domain, Domain> space() const;
  inline typed::space<Domain, Domain> get_space() const = delete;
  inline typed::map<Domain, Domain> subtract(const typed::map<Domain, Domain> &map2) const;
  inline typed::union_map<Domain, Domain> subtract(const typed::union_map<Domain, Domain> &umap2) const;
  inline typed::map<Domain, Domain> subtract(const typed::basic_map<Domain, Domain> &map2) const;
  inline typed::union_map<Domain, Domain> subtract_domain(const typed::union_set<Domain> &dom) const;
  inline typed::union_map<Domain, Domain> subtract_range(const typed::union_set<Domain> &dom) const;
  inline typed::union_map<Domain, Domain> to_union_map() const;
  inline typed::map<Domain, Domain> uncurry() const = delete;
  inline typed::map<Domain, Domain> unite(const typed::map<Domain, Domain> &map2) const;
  inline typed::union_map<Domain, Domain> unite(const typed::union_map<Domain, Domain> &umap2) const;
  inline typed::map<Domain, Domain> unite(const typed::basic_map<Domain, Domain> &map2) const;
  static inline typed::map<Domain, Domain> universe(const typed::space<Domain, Domain> &space);
  inline typed::map<Domain, Domain> upper_bound(const typed::multi_pw_aff<Domain, Domain> &upper) const;
  inline typed::map<Domain, Domain> upper_bound(const typed::aff<Domain, Domain> &upper) const;
  inline typed::map<Domain, Domain> upper_bound(const typed::multi_aff<Domain, Domain> &upper) const;
  inline typed::map<Domain, Domain> upper_bound(const typed::pw_aff<Domain, Domain> &upper) const;
  inline typed::map<Domain, Domain> upper_bound(const typed::pw_multi_aff<Domain, Domain> &upper) const;
  inline typed::set<pair<Domain, Domain>> wrap() const;
};

template <typename Domain, typename Range, typename Range2>
struct map<Domain, pair<Range, Range2>> : public isl::map {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  map() = default;
  template <typename Arg1, typename Arg2, typename Arg3,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{} &&
              std::is_base_of<Range, Arg2>{} &&
              std::is_base_of<Range2, Arg3>{},
            bool>::type = true>
  map(const map<Arg1, pair<Arg2, Arg3>> &obj) : isl::map(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::map>{}, bool>::type = true>
  map(const base &obj) : isl::map(obj) {}
 public:
  static map from(const isl::map &obj) {
    return map(obj);
  }
  inline /* implicit */ map(const typed::basic_map<Domain, pair<Range, Range2>> &bmap);
  inline explicit map(const isl::ctx &ctx, const std::string &str);
  template <typename Domain2>
  inline typed::map<Domain2, pair<Range, Range2>> apply_domain(const typed::map<Domain, Domain2> &map2) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, pair<Range, Range2>> apply_domain(const typed::union_map<Domain, Domain2> &umap2) const;
  template <typename Domain2>
  inline typed::map<Domain2, pair<Range, Range2>> apply_domain(const typed::basic_map<Domain, Domain2> &map2) const;
  template <typename Arg3>
  inline typed::map<Domain, Arg3> apply_range(const typed::map<pair<Range, Range2>, Arg3> &map2) const;
  template <typename Arg3>
  inline typed::union_map<Domain, Arg3> apply_range(const typed::union_map<pair<Range, Range2>, Arg3> &umap2) const;
  template <typename Arg3>
  inline typed::map<Domain, Arg3> apply_range(const typed::basic_map<pair<Range, Range2>, Arg3> &map2) const;
  inline typed::map<Domain, pair<Range, Range2>> as_map() const;
  inline typed::multi_union_pw_aff<Domain, pair<Range, Range2>> as_multi_union_pw_aff() const;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> as_pw_multi_aff() const;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> as_union_pw_multi_aff() const;
  inline typed::set<pair<Range, Range2>> bind_domain(const typed::multi_id<Domain> &tuple) const;
  inline typed::set<Domain> bind_range(const typed::multi_id<pair<Range, Range2>> &tuple) const;
  inline typed::map<Domain, pair<Range, Range2>> coalesce() const;
  inline typed::map<Domain, pair<Range, Range2>> curry() const = delete;
  inline typed::set<Domain, pair<Range, Range2>> deltas() const = delete;
  inline typed::map<Domain, pair<Range, Range2>> detect_equalities() const;
  inline typed::set<Domain> domain() const;
  inline typed::map<Domain, pair<Range, Range2>> domain_factor_domain() const = delete;
  inline typed::map<Domain, pair<Range, Range2>> domain_factor_range() const = delete;
  inline typed::union_map<pair<Domain, pair<Range, Range2>>, Domain> domain_map() const;
  inline typed::union_pw_multi_aff<pair<Domain, pair<Range, Range2>>, Domain> domain_map_union_pw_multi_aff() const;
  template <typename Domain2>
  inline typed::map<pair<Domain, Domain2>, pair<Range, Range2>> domain_product(const typed::map<Domain2, pair<Range, Range2>> &map2) const;
  template <typename Domain2>
  inline typed::union_map<pair<Domain, Domain2>, pair<Range, Range2>> domain_product(const typed::union_map<Domain2, pair<Range, Range2>> &umap2) const;
  template <typename Domain2>
  inline typed::map<pair<Domain, Domain2>, pair<Range, Range2>> domain_product(const typed::basic_map<Domain2, pair<Range, Range2>> &map2) const;
  inline typed::map<Domain, pair<Range, Range2>> domain_reverse() const = delete;
  inline typed::id<Domain, pair<Range, Range2>> get_domain_tuple_id() const = delete;
  inline typed::map<Domain, pair<Range, Range2>> drop_unused_params() const;
  inline typed::map<Domain, pair<Range, Range2>> eq_at(const typed::multi_pw_aff<> &mpa) const = delete;
  inline typed::union_map<Domain, pair<Range, Range2>> eq_at(const typed::multi_union_pw_aff<> &mupa) const = delete;
  inline typed::map<Domain, pair<Range, Range2>> eq_at(const typed::aff<> &mpa) const = delete;
  inline typed::map<Domain, pair<Range, Range2>> eq_at(const typed::multi_aff<> &mpa) const = delete;
  inline typed::map<Domain, pair<Range, Range2>> eq_at(const typed::pw_aff<> &mpa) const = delete;
  inline typed::map<Domain, pair<Range, Range2>> eq_at(const typed::pw_multi_aff<> &mpa) const = delete;
  inline bool every_map(const std::function<bool(typed::map<Domain, pair<Range, Range2>>)> &test) const;
  inline typed::map<Domain, pair<Range, Range2>> extract_map(const typed::space<Domain, pair<Range, Range2>> &space) const;
  inline typed::map<Domain, pair<Range, Range2>> flatten_domain() const = delete;
  inline typed::map<Domain, Anonymous> flatten_range() const;
  inline void foreach_basic_map(const std::function<void(typed::basic_map<Domain, pair<Range, Range2>>)> &fn) const;
  inline void foreach_map(const std::function<void(typed::map<Domain, pair<Range, Range2>>)> &fn) const;
  inline typed::map<Domain, pair<Range, Range2>> gist(const typed::map<Domain, pair<Range, Range2>> &context) const;
  inline typed::union_map<Domain, pair<Range, Range2>> gist(const typed::union_map<Domain, pair<Range, Range2>> &context) const;
  inline typed::map<Domain, pair<Range, Range2>> gist(const typed::basic_map<Domain, pair<Range, Range2>> &context) const;
  inline typed::map<Domain, pair<Range, Range2>> gist_domain(const typed::set<Domain> &context) const;
  inline typed::union_map<Domain, pair<Range, Range2>> gist_domain(const typed::union_set<Domain> &uset) const;
  inline typed::map<Domain, pair<Range, Range2>> gist_domain(const typed::basic_set<Domain> &context) const;
  inline typed::map<Domain, pair<Range, Range2>> gist_domain(const typed::point<Domain> &context) const;
  inline typed::map<Domain, pair<Range, Range2>> gist_params(const typed::set<> &context) const;
  inline typed::map<Domain, pair<Range, Range2>> gist_params(const typed::basic_set<> &context) const;
  inline typed::map<Domain, pair<Range, Range2>> gist_params(const typed::point<> &context) const;
  inline typed::map<Domain, pair<Range, Range2>> intersect(const typed::map<Domain, pair<Range, Range2>> &map2) const;
  inline typed::union_map<Domain, pair<Range, Range2>> intersect(const typed::union_map<Domain, pair<Range, Range2>> &umap2) const;
  inline typed::map<Domain, pair<Range, Range2>> intersect(const typed::basic_map<Domain, pair<Range, Range2>> &map2) const;
  inline typed::map<Domain, pair<Range, Range2>> intersect_domain(const typed::set<Domain> &set) const;
  inline typed::union_map<Domain, pair<Range, Range2>> intersect_domain(const typed::space<Domain> &space) const;
  inline typed::union_map<Domain, pair<Range, Range2>> intersect_domain(const typed::union_set<Domain> &uset) const;
  inline typed::map<Domain, pair<Range, Range2>> intersect_domain(const typed::basic_set<Domain> &set) const;
  inline typed::map<Domain, pair<Range, Range2>> intersect_domain(const typed::point<Domain> &set) const;
  inline typed::map<Domain, pair<Range, Range2>> intersect_domain_wrapped_domain(const typed::set<> &domain) const = delete;
  inline typed::union_map<Domain, pair<Range, Range2>> intersect_domain_wrapped_domain(const typed::union_set<> &domain) const = delete;
  inline typed::map<Domain, pair<Range, Range2>> intersect_domain_wrapped_domain(const typed::basic_set<> &domain) const = delete;
  inline typed::map<Domain, pair<Range, Range2>> intersect_domain_wrapped_domain(const typed::point<> &domain) const = delete;
  inline typed::map<Domain, pair<Range, Range2>> intersect_params(const typed::set<> &params) const;
  inline typed::map<Domain, pair<Range, Range2>> intersect_params(const typed::basic_set<> &params) const;
  inline typed::map<Domain, pair<Range, Range2>> intersect_params(const typed::point<> &params) const;
  inline typed::map<Domain, pair<Range, Range2>> intersect_range(const typed::set<pair<Range, Range2>> &set) const;
  inline typed::union_map<Domain, pair<Range, Range2>> intersect_range(const typed::space<pair<Range, Range2>> &space) const;
  inline typed::union_map<Domain, pair<Range, Range2>> intersect_range(const typed::union_set<pair<Range, Range2>> &uset) const;
  inline typed::map<Domain, pair<Range, Range2>> intersect_range(const typed::basic_set<pair<Range, Range2>> &set) const;
  inline typed::map<Domain, pair<Range, Range2>> intersect_range(const typed::point<pair<Range, Range2>> &set) const;
  inline typed::map<Domain, pair<Range, Range2>> intersect_range_wrapped_domain(const typed::set<Range> &domain) const;
  inline typed::union_map<Domain, pair<Range, Range2>> intersect_range_wrapped_domain(const typed::union_set<Range> &domain) const;
  inline typed::map<Domain, pair<Range, Range2>> intersect_range_wrapped_domain(const typed::basic_set<Range> &domain) const;
  inline typed::map<Domain, pair<Range, Range2>> intersect_range_wrapped_domain(const typed::point<Range> &domain) const;
  inline typed::map<Domain, pair<Range, Range2>> lex_ge_at(const typed::multi_pw_aff<> &mpa) const = delete;
  inline typed::map<Domain, pair<Range, Range2>> lex_ge_at(const typed::aff<> &mpa) const = delete;
  inline typed::map<Domain, pair<Range, Range2>> lex_ge_at(const typed::multi_aff<> &mpa) const = delete;
  inline typed::map<Domain, pair<Range, Range2>> lex_ge_at(const typed::pw_aff<> &mpa) const = delete;
  inline typed::map<Domain, pair<Range, Range2>> lex_ge_at(const typed::pw_multi_aff<> &mpa) const = delete;
  inline typed::map<Domain, pair<Range, Range2>> lex_gt_at(const typed::multi_pw_aff<> &mpa) const = delete;
  inline typed::map<Domain, pair<Range, Range2>> lex_gt_at(const typed::aff<> &mpa) const = delete;
  inline typed::map<Domain, pair<Range, Range2>> lex_gt_at(const typed::multi_aff<> &mpa) const = delete;
  inline typed::map<Domain, pair<Range, Range2>> lex_gt_at(const typed::pw_aff<> &mpa) const = delete;
  inline typed::map<Domain, pair<Range, Range2>> lex_gt_at(const typed::pw_multi_aff<> &mpa) const = delete;
  inline typed::map<Domain, pair<Range, Range2>> lex_le_at(const typed::multi_pw_aff<> &mpa) const = delete;
  inline typed::map<Domain, pair<Range, Range2>> lex_le_at(const typed::aff<> &mpa) const = delete;
  inline typed::map<Domain, pair<Range, Range2>> lex_le_at(const typed::multi_aff<> &mpa) const = delete;
  inline typed::map<Domain, pair<Range, Range2>> lex_le_at(const typed::pw_aff<> &mpa) const = delete;
  inline typed::map<Domain, pair<Range, Range2>> lex_le_at(const typed::pw_multi_aff<> &mpa) const = delete;
  inline typed::map<Domain, pair<Range, Range2>> lex_lt_at(const typed::multi_pw_aff<> &mpa) const = delete;
  inline typed::map<Domain, pair<Range, Range2>> lex_lt_at(const typed::aff<> &mpa) const = delete;
  inline typed::map<Domain, pair<Range, Range2>> lex_lt_at(const typed::multi_aff<> &mpa) const = delete;
  inline typed::map<Domain, pair<Range, Range2>> lex_lt_at(const typed::pw_aff<> &mpa) const = delete;
  inline typed::map<Domain, pair<Range, Range2>> lex_lt_at(const typed::pw_multi_aff<> &mpa) const = delete;
  inline typed::map<Domain, pair<Range, Range2>> lexmax() const;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> lexmax_pw_multi_aff() const;
  inline typed::map<Domain, pair<Range, Range2>> lexmin() const;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> lexmin_pw_multi_aff() const;
  inline typed::map<Domain, pair<Range, Range2>> lower_bound(const typed::multi_pw_aff<Domain, pair<Range, Range2>> &lower) const;
  inline typed::map<Domain, pair<Range, Range2>> lower_bound(const typed::aff<Domain, pair<Range, Range2>> &lower) const;
  inline typed::map<Domain, pair<Range, Range2>> lower_bound(const typed::multi_aff<Domain, pair<Range, Range2>> &lower) const;
  inline typed::map<Domain, pair<Range, Range2>> lower_bound(const typed::pw_aff<Domain, pair<Range, Range2>> &lower) const;
  inline typed::map<Domain, pair<Range, Range2>> lower_bound(const typed::pw_multi_aff<Domain, pair<Range, Range2>> &lower) const;
  inline typed::map_list<Domain, pair<Range, Range2>> map_list() const;
  inline typed::multi_pw_aff<Domain, pair<Range, Range2>> max_multi_pw_aff() const;
  inline typed::multi_pw_aff<Domain, pair<Range, Range2>> min_multi_pw_aff() const;
  inline typed::set<> params() const;
  template <typename Domain2>
  inline typed::map<Domain2, pair<Range, Range2>> preimage_domain(const typed::multi_aff<Domain2, Domain> &ma) const;
  template <typename Domain2>
  inline typed::map<Domain2, pair<Range, Range2>> preimage_domain(const typed::multi_pw_aff<Domain2, Domain> &mpa) const;
  template <typename Domain2>
  inline typed::map<Domain2, pair<Range, Range2>> preimage_domain(const typed::pw_multi_aff<Domain2, Domain> &pma) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, pair<Range, Range2>> preimage_domain(const typed::union_pw_multi_aff<Domain2, Domain> &upma) const;
  template <typename Arg3>
  inline typed::map<Domain, Arg3> preimage_range(const typed::multi_aff<Arg3, pair<Range, Range2>> &ma) const;
  template <typename Arg3>
  inline typed::map<Domain, Arg3> preimage_range(const typed::pw_multi_aff<Arg3, pair<Range, Range2>> &pma) const;
  template <typename Arg3>
  inline typed::union_map<Domain, Arg3> preimage_range(const typed::union_pw_multi_aff<Arg3, pair<Range, Range2>> &upma) const;
  template <typename Domain2, typename Arg3>
  inline typed::map<pair<Domain, Domain2>, pair<pair<Range, Range2>, Arg3>> product(const typed::map<Domain2, Arg3> &map2) const;
  template <typename Domain2, typename Arg3>
  inline typed::union_map<pair<Domain, Domain2>, pair<pair<Range, Range2>, Arg3>> product(const typed::union_map<Domain2, Arg3> &umap2) const;
  template <typename Domain2, typename Arg3>
  inline typed::map<pair<Domain, Domain2>, pair<pair<Range, Range2>, Arg3>> product(const typed::basic_map<Domain2, Arg3> &map2) const;
  inline typed::map<Domain, pair<Range, Range2>> project_out_all_params() const;
  inline typed::map<Domain, pair<Range, Range2>> project_out_param(const typed::id<Anonymous> &id) const;
  inline typed::map<Domain, pair<Range, Range2>> project_out_param(const std::string &id) const;
  inline typed::map<Domain, pair<Range, Range2>> project_out_param(const typed::id_list<Anonymous> &list) const;
  inline typed::set<pair<Range, Range2>> range() const;
  inline typed::map<Domain, Range> range_factor_domain() const;
  inline typed::map<Domain, Range2> range_factor_range() const;
  inline typed::fixed_box<Domain, pair<Range, Range2>> range_lattice_tile() const;
  inline typed::fixed_box<Domain, pair<Range, Range2>> get_range_lattice_tile() const = delete;
  inline typed::union_map<pair<Domain, pair<Range, Range2>>, pair<Range, Range2>> range_map() const;
  template <typename Arg3>
  inline typed::map<Domain, pair<pair<Range, Range2>, Arg3>> range_product(const typed::map<Domain, Arg3> &map2) const;
  template <typename Arg3>
  inline typed::union_map<Domain, pair<pair<Range, Range2>, Arg3>> range_product(const typed::union_map<Domain, Arg3> &umap2) const;
  template <typename Arg3>
  inline typed::map<Domain, pair<pair<Range, Range2>, Arg3>> range_product(const typed::basic_map<Domain, Arg3> &map2) const;
  inline typed::map<Domain, pair<Range2, Range>> range_reverse() const;
  inline typed::fixed_box<Domain, pair<Range, Range2>> range_simple_fixed_box_hull() const;
  inline typed::fixed_box<Domain, pair<Range, Range2>> get_range_simple_fixed_box_hull() const = delete;
  inline typed::id<Domain, pair<Range, Range2>> get_range_tuple_id() const = delete;
  inline typed::map<pair<Range, Range2>, Domain> reverse() const;
  template <typename Domain2>
  inline typed::map<Domain2, pair<Range, Range2>> set_domain_tuple(const typed::id<Anonymous> &id) const;
  template <typename Domain2>
  inline typed::map<Domain2, pair<Range, Range2>> set_domain_tuple(const std::string &id) const;
  inline typed::map<Domain, pair<Range, Range2>> set_range_tuple(const typed::id<> &id) const = delete;
  inline typed::map<Domain, pair<Range, Range2>> set_range_tuple(const std::string &id) const = delete;
  inline typed::space<Domain, pair<Range, Range2>> space() const;
  inline typed::space<Domain, pair<Range, Range2>> get_space() const = delete;
  inline typed::map<Domain, pair<Range, Range2>> subtract(const typed::map<Domain, pair<Range, Range2>> &map2) const;
  inline typed::union_map<Domain, pair<Range, Range2>> subtract(const typed::union_map<Domain, pair<Range, Range2>> &umap2) const;
  inline typed::map<Domain, pair<Range, Range2>> subtract(const typed::basic_map<Domain, pair<Range, Range2>> &map2) const;
  inline typed::union_map<Domain, pair<Range, Range2>> subtract_domain(const typed::union_set<Domain> &dom) const;
  inline typed::union_map<Domain, pair<Range, Range2>> subtract_range(const typed::union_set<pair<Range, Range2>> &dom) const;
  inline typed::union_map<Domain, pair<Range, Range2>> to_union_map() const;
  inline typed::map<pair<Domain, Range>, Range2> uncurry() const;
  inline typed::map<Domain, pair<Range, Range2>> unite(const typed::map<Domain, pair<Range, Range2>> &map2) const;
  inline typed::union_map<Domain, pair<Range, Range2>> unite(const typed::union_map<Domain, pair<Range, Range2>> &umap2) const;
  inline typed::map<Domain, pair<Range, Range2>> unite(const typed::basic_map<Domain, pair<Range, Range2>> &map2) const;
  static inline typed::map<Domain, pair<Range, Range2>> universe(const typed::space<Domain, pair<Range, Range2>> &space);
  inline typed::map<Domain, pair<Range, Range2>> upper_bound(const typed::multi_pw_aff<Domain, pair<Range, Range2>> &upper) const;
  inline typed::map<Domain, pair<Range, Range2>> upper_bound(const typed::aff<Domain, pair<Range, Range2>> &upper) const;
  inline typed::map<Domain, pair<Range, Range2>> upper_bound(const typed::multi_aff<Domain, pair<Range, Range2>> &upper) const;
  inline typed::map<Domain, pair<Range, Range2>> upper_bound(const typed::pw_aff<Domain, pair<Range, Range2>> &upper) const;
  inline typed::map<Domain, pair<Range, Range2>> upper_bound(const typed::pw_multi_aff<Domain, pair<Range, Range2>> &upper) const;
  inline typed::set<pair<Domain, pair<Range, Range2>>> wrap() const;
};

template <typename T1, typename T2>
struct map<pair<T1, T2>, pair<T1, T2>> : public isl::map {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  map() = default;
  template <typename Arg1, typename Arg2,
            typename std::enable_if<
              std::is_base_of<T1, Arg1>{} &&
              std::is_base_of<T2, Arg2>{},
            bool>::type = true>
  map(const map<pair<Arg1, Arg2>, pair<Arg1, Arg2>> &obj) : isl::map(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::map>{}, bool>::type = true>
  map(const base &obj) : isl::map(obj) {}
 public:
  static map from(const isl::map &obj) {
    return map(obj);
  }
  inline /* implicit */ map(const typed::basic_map<pair<T1, T2>, pair<T1, T2>> &bmap);
  inline explicit map(const isl::ctx &ctx, const std::string &str);
  template <typename Domain2>
  inline typed::map<Domain2, pair<T1, T2>> apply_domain(const typed::map<pair<T1, T2>, Domain2> &map2) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, pair<T1, T2>> apply_domain(const typed::union_map<pair<T1, T2>, Domain2> &umap2) const;
  template <typename Domain2>
  inline typed::map<Domain2, pair<T1, T2>> apply_domain(const typed::basic_map<pair<T1, T2>, Domain2> &map2) const;
  template <typename Range2>
  inline typed::map<pair<T1, T2>, Range2> apply_range(const typed::map<pair<T1, T2>, Range2> &map2) const;
  template <typename Range2>
  inline typed::union_map<pair<T1, T2>, Range2> apply_range(const typed::union_map<pair<T1, T2>, Range2> &umap2) const;
  template <typename Range2>
  inline typed::map<pair<T1, T2>, Range2> apply_range(const typed::basic_map<pair<T1, T2>, Range2> &map2) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> as_map() const;
  inline typed::multi_union_pw_aff<pair<T1, T2>, pair<T1, T2>> as_multi_union_pw_aff() const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<T1, T2>> as_pw_multi_aff() const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<T1, T2>> as_union_pw_multi_aff() const;
  inline typed::set<pair<T1, T2>> bind_domain(const typed::multi_id<pair<T1, T2>> &tuple) const;
  inline typed::set<pair<T1, T2>> bind_range(const typed::multi_id<pair<T1, T2>> &tuple) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> coalesce() const;
  inline typed::map<T1, pair<T2, pair<T1, T2>>> curry() const;
  inline typed::set<pair<T1, T2>> deltas() const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> detect_equalities() const;
  inline typed::set<pair<T1, T2>> domain() const;
  inline typed::map<T1, pair<T1, T2>> domain_factor_domain() const;
  inline typed::map<T2, pair<T1, T2>> domain_factor_range() const;
  inline typed::union_map<pair<pair<T1, T2>, pair<T1, T2>>, pair<T1, T2>> domain_map() const;
  inline typed::union_pw_multi_aff<pair<pair<T1, T2>, pair<T1, T2>>, pair<T1, T2>> domain_map_union_pw_multi_aff() const;
  template <typename Domain2>
  inline typed::map<pair<pair<T1, T2>, Domain2>, pair<T1, T2>> domain_product(const typed::map<Domain2, pair<T1, T2>> &map2) const;
  template <typename Domain2>
  inline typed::union_map<pair<pair<T1, T2>, Domain2>, pair<T1, T2>> domain_product(const typed::union_map<Domain2, pair<T1, T2>> &umap2) const;
  template <typename Domain2>
  inline typed::map<pair<pair<T1, T2>, Domain2>, pair<T1, T2>> domain_product(const typed::basic_map<Domain2, pair<T1, T2>> &map2) const;
  inline typed::map<pair<T2, T1>, pair<T1, T2>> domain_reverse() const;
  inline typed::id<pair<T1, T2>, pair<T1, T2>> get_domain_tuple_id() const = delete;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> drop_unused_params() const;
  template <typename Range>
  inline typed::map<pair<T1, T2>, pair<T1, T2>> eq_at(const typed::multi_pw_aff<pair<T1, T2>, Range> &mpa) const;
  template <typename Range>
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> eq_at(const typed::multi_union_pw_aff<pair<T1, T2>, Range> &mupa) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> eq_at(const typed::aff<pair<T1, T2>, Anonymous> &mpa) const;
  template <typename Range>
  inline typed::map<pair<T1, T2>, pair<T1, T2>> eq_at(const typed::multi_aff<pair<T1, T2>, Range> &mpa) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> eq_at(const typed::pw_aff<pair<T1, T2>, Anonymous> &mpa) const;
  template <typename Range>
  inline typed::map<pair<T1, T2>, pair<T1, T2>> eq_at(const typed::pw_multi_aff<pair<T1, T2>, Range> &mpa) const;
  inline bool every_map(const std::function<bool(typed::map<pair<T1, T2>, pair<T1, T2>>)> &test) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> extract_map(const typed::space<pair<T1, T2>, pair<T1, T2>> &space) const;
  inline typed::map<Anonymous, pair<T1, T2>> flatten_domain() const;
  inline typed::map<pair<T1, T2>, Anonymous> flatten_range() const;
  inline void foreach_basic_map(const std::function<void(typed::basic_map<pair<T1, T2>, pair<T1, T2>>)> &fn) const;
  inline void foreach_map(const std::function<void(typed::map<pair<T1, T2>, pair<T1, T2>>)> &fn) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> gist(const typed::map<pair<T1, T2>, pair<T1, T2>> &context) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> gist(const typed::union_map<pair<T1, T2>, pair<T1, T2>> &context) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> gist(const typed::basic_map<pair<T1, T2>, pair<T1, T2>> &context) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> gist_domain(const typed::set<pair<T1, T2>> &context) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> gist_domain(const typed::union_set<pair<T1, T2>> &uset) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> gist_domain(const typed::basic_set<pair<T1, T2>> &context) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> gist_domain(const typed::point<pair<T1, T2>> &context) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> gist_params(const typed::set<> &context) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> gist_params(const typed::basic_set<> &context) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> gist_params(const typed::point<> &context) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> intersect(const typed::map<pair<T1, T2>, pair<T1, T2>> &map2) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> intersect(const typed::union_map<pair<T1, T2>, pair<T1, T2>> &umap2) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> intersect(const typed::basic_map<pair<T1, T2>, pair<T1, T2>> &map2) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> intersect_domain(const typed::set<pair<T1, T2>> &set) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> intersect_domain(const typed::space<pair<T1, T2>> &space) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> intersect_domain(const typed::union_set<pair<T1, T2>> &uset) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> intersect_domain(const typed::basic_set<pair<T1, T2>> &set) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> intersect_domain(const typed::point<pair<T1, T2>> &set) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> intersect_domain_wrapped_domain(const typed::set<T1> &domain) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> intersect_domain_wrapped_domain(const typed::union_set<T1> &domain) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> intersect_domain_wrapped_domain(const typed::basic_set<T1> &domain) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> intersect_domain_wrapped_domain(const typed::point<T1> &domain) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> intersect_params(const typed::set<> &params) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> intersect_params(const typed::basic_set<> &params) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> intersect_params(const typed::point<> &params) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> intersect_range(const typed::set<pair<T1, T2>> &set) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> intersect_range(const typed::space<pair<T1, T2>> &space) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> intersect_range(const typed::union_set<pair<T1, T2>> &uset) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> intersect_range(const typed::basic_set<pair<T1, T2>> &set) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> intersect_range(const typed::point<pair<T1, T2>> &set) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> intersect_range_wrapped_domain(const typed::set<T1> &domain) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> intersect_range_wrapped_domain(const typed::union_set<T1> &domain) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> intersect_range_wrapped_domain(const typed::basic_set<T1> &domain) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> intersect_range_wrapped_domain(const typed::point<T1> &domain) const;
  template <typename Range>
  inline typed::map<pair<T1, T2>, pair<T1, T2>> lex_ge_at(const typed::multi_pw_aff<pair<T1, T2>, Range> &mpa) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> lex_ge_at(const typed::aff<pair<T1, T2>, Anonymous> &mpa) const;
  template <typename Range>
  inline typed::map<pair<T1, T2>, pair<T1, T2>> lex_ge_at(const typed::multi_aff<pair<T1, T2>, Range> &mpa) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> lex_ge_at(const typed::pw_aff<pair<T1, T2>, Anonymous> &mpa) const;
  template <typename Range>
  inline typed::map<pair<T1, T2>, pair<T1, T2>> lex_ge_at(const typed::pw_multi_aff<pair<T1, T2>, Range> &mpa) const;
  template <typename Range>
  inline typed::map<pair<T1, T2>, pair<T1, T2>> lex_gt_at(const typed::multi_pw_aff<pair<T1, T2>, Range> &mpa) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> lex_gt_at(const typed::aff<pair<T1, T2>, Anonymous> &mpa) const;
  template <typename Range>
  inline typed::map<pair<T1, T2>, pair<T1, T2>> lex_gt_at(const typed::multi_aff<pair<T1, T2>, Range> &mpa) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> lex_gt_at(const typed::pw_aff<pair<T1, T2>, Anonymous> &mpa) const;
  template <typename Range>
  inline typed::map<pair<T1, T2>, pair<T1, T2>> lex_gt_at(const typed::pw_multi_aff<pair<T1, T2>, Range> &mpa) const;
  template <typename Range>
  inline typed::map<pair<T1, T2>, pair<T1, T2>> lex_le_at(const typed::multi_pw_aff<pair<T1, T2>, Range> &mpa) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> lex_le_at(const typed::aff<pair<T1, T2>, Anonymous> &mpa) const;
  template <typename Range>
  inline typed::map<pair<T1, T2>, pair<T1, T2>> lex_le_at(const typed::multi_aff<pair<T1, T2>, Range> &mpa) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> lex_le_at(const typed::pw_aff<pair<T1, T2>, Anonymous> &mpa) const;
  template <typename Range>
  inline typed::map<pair<T1, T2>, pair<T1, T2>> lex_le_at(const typed::pw_multi_aff<pair<T1, T2>, Range> &mpa) const;
  template <typename Range>
  inline typed::map<pair<T1, T2>, pair<T1, T2>> lex_lt_at(const typed::multi_pw_aff<pair<T1, T2>, Range> &mpa) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> lex_lt_at(const typed::aff<pair<T1, T2>, Anonymous> &mpa) const;
  template <typename Range>
  inline typed::map<pair<T1, T2>, pair<T1, T2>> lex_lt_at(const typed::multi_aff<pair<T1, T2>, Range> &mpa) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> lex_lt_at(const typed::pw_aff<pair<T1, T2>, Anonymous> &mpa) const;
  template <typename Range>
  inline typed::map<pair<T1, T2>, pair<T1, T2>> lex_lt_at(const typed::pw_multi_aff<pair<T1, T2>, Range> &mpa) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> lexmax() const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<T1, T2>> lexmax_pw_multi_aff() const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> lexmin() const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<T1, T2>> lexmin_pw_multi_aff() const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> lower_bound(const typed::multi_pw_aff<pair<T1, T2>, pair<T1, T2>> &lower) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> lower_bound(const typed::aff<pair<T1, T2>, pair<T1, T2>> &lower) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> lower_bound(const typed::multi_aff<pair<T1, T2>, pair<T1, T2>> &lower) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> lower_bound(const typed::pw_aff<pair<T1, T2>, pair<T1, T2>> &lower) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> lower_bound(const typed::pw_multi_aff<pair<T1, T2>, pair<T1, T2>> &lower) const;
  inline typed::map_list<pair<T1, T2>, pair<T1, T2>> map_list() const;
  inline typed::multi_pw_aff<pair<T1, T2>, pair<T1, T2>> max_multi_pw_aff() const;
  inline typed::multi_pw_aff<pair<T1, T2>, pair<T1, T2>> min_multi_pw_aff() const;
  inline typed::set<> params() const;
  template <typename Domain2>
  inline typed::map<Domain2, pair<T1, T2>> preimage_domain(const typed::multi_aff<Domain2, pair<T1, T2>> &ma) const;
  template <typename Domain2>
  inline typed::map<Domain2, pair<T1, T2>> preimage_domain(const typed::multi_pw_aff<Domain2, pair<T1, T2>> &mpa) const;
  template <typename Domain2>
  inline typed::map<Domain2, pair<T1, T2>> preimage_domain(const typed::pw_multi_aff<Domain2, pair<T1, T2>> &pma) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, pair<T1, T2>> preimage_domain(const typed::union_pw_multi_aff<Domain2, pair<T1, T2>> &upma) const;
  template <typename Range2>
  inline typed::map<pair<T1, T2>, Range2> preimage_range(const typed::multi_aff<Range2, pair<T1, T2>> &ma) const;
  template <typename Range2>
  inline typed::map<pair<T1, T2>, Range2> preimage_range(const typed::pw_multi_aff<Range2, pair<T1, T2>> &pma) const;
  template <typename Range2>
  inline typed::union_map<pair<T1, T2>, Range2> preimage_range(const typed::union_pw_multi_aff<Range2, pair<T1, T2>> &upma) const;
  template <typename Domain2, typename Range2>
  inline typed::map<pair<pair<T1, T2>, Domain2>, pair<pair<T1, T2>, Range2>> product(const typed::map<Domain2, Range2> &map2) const;
  template <typename Domain2, typename Range2>
  inline typed::union_map<pair<pair<T1, T2>, Domain2>, pair<pair<T1, T2>, Range2>> product(const typed::union_map<Domain2, Range2> &umap2) const;
  template <typename Domain2, typename Range2>
  inline typed::map<pair<pair<T1, T2>, Domain2>, pair<pair<T1, T2>, Range2>> product(const typed::basic_map<Domain2, Range2> &map2) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> project_out_all_params() const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> project_out_param(const typed::id<Anonymous> &id) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> project_out_param(const std::string &id) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> project_out_param(const typed::id_list<Anonymous> &list) const;
  inline typed::set<pair<T1, T2>> range() const;
  inline typed::map<pair<T1, T2>, T1> range_factor_domain() const;
  inline typed::map<pair<T1, T2>, T2> range_factor_range() const;
  inline typed::fixed_box<pair<T1, T2>, pair<T1, T2>> range_lattice_tile() const;
  inline typed::fixed_box<pair<T1, T2>, pair<T1, T2>> get_range_lattice_tile() const = delete;
  inline typed::union_map<pair<pair<T1, T2>, pair<T1, T2>>, pair<T1, T2>> range_map() const;
  template <typename Range2>
  inline typed::map<pair<T1, T2>, pair<pair<T1, T2>, Range2>> range_product(const typed::map<pair<T1, T2>, Range2> &map2) const;
  template <typename Range2>
  inline typed::union_map<pair<T1, T2>, pair<pair<T1, T2>, Range2>> range_product(const typed::union_map<pair<T1, T2>, Range2> &umap2) const;
  template <typename Range2>
  inline typed::map<pair<T1, T2>, pair<pair<T1, T2>, Range2>> range_product(const typed::basic_map<pair<T1, T2>, Range2> &map2) const;
  inline typed::map<pair<T1, T2>, pair<T2, T1>> range_reverse() const;
  inline typed::fixed_box<pair<T1, T2>, pair<T1, T2>> range_simple_fixed_box_hull() const;
  inline typed::fixed_box<pair<T1, T2>, pair<T1, T2>> get_range_simple_fixed_box_hull() const = delete;
  inline typed::id<pair<T1, T2>, pair<T1, T2>> get_range_tuple_id() const = delete;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> reverse() const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> set_domain_tuple(const typed::id<> &id) const = delete;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> set_domain_tuple(const std::string &id) const = delete;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> set_range_tuple(const typed::id<> &id) const = delete;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> set_range_tuple(const std::string &id) const = delete;
  inline typed::space<pair<T1, T2>, pair<T1, T2>> space() const;
  inline typed::space<pair<T1, T2>, pair<T1, T2>> get_space() const = delete;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> subtract(const typed::map<pair<T1, T2>, pair<T1, T2>> &map2) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> subtract(const typed::union_map<pair<T1, T2>, pair<T1, T2>> &umap2) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> subtract(const typed::basic_map<pair<T1, T2>, pair<T1, T2>> &map2) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> subtract_domain(const typed::union_set<pair<T1, T2>> &dom) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> subtract_range(const typed::union_set<pair<T1, T2>> &dom) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> to_union_map() const;
  inline typed::map<pair<pair<T1, T2>, T1>, T2> uncurry() const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> unite(const typed::map<pair<T1, T2>, pair<T1, T2>> &map2) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> unite(const typed::union_map<pair<T1, T2>, pair<T1, T2>> &umap2) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> unite(const typed::basic_map<pair<T1, T2>, pair<T1, T2>> &map2) const;
  static inline typed::map<pair<T1, T2>, pair<T1, T2>> universe(const typed::space<pair<T1, T2>, pair<T1, T2>> &space);
  inline typed::map<pair<T1, T2>, pair<T1, T2>> upper_bound(const typed::multi_pw_aff<pair<T1, T2>, pair<T1, T2>> &upper) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> upper_bound(const typed::aff<pair<T1, T2>, pair<T1, T2>> &upper) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> upper_bound(const typed::multi_aff<pair<T1, T2>, pair<T1, T2>> &upper) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> upper_bound(const typed::pw_aff<pair<T1, T2>, pair<T1, T2>> &upper) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> upper_bound(const typed::pw_multi_aff<pair<T1, T2>, pair<T1, T2>> &upper) const;
  inline typed::set<pair<pair<T1, T2>, pair<T1, T2>>> wrap() const;
};

template <typename T1, typename T2, typename Range, typename Range2>
struct map<pair<T1, T2>, pair<Range, Range2>> : public isl::map {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  map() = default;
  template <typename Arg1, typename Arg2, typename Arg3, typename Arg4,
            typename std::enable_if<
              std::is_base_of<T1, Arg1>{} &&
              std::is_base_of<T2, Arg2>{} &&
              std::is_base_of<Range, Arg3>{} &&
              std::is_base_of<Range2, Arg4>{},
            bool>::type = true>
  map(const map<pair<Arg1, Arg2>, pair<Arg3, Arg4>> &obj) : isl::map(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::map>{}, bool>::type = true>
  map(const base &obj) : isl::map(obj) {}
 public:
  static map from(const isl::map &obj) {
    return map(obj);
  }
  inline /* implicit */ map(const typed::basic_map<pair<T1, T2>, pair<Range, Range2>> &bmap);
  inline explicit map(const isl::ctx &ctx, const std::string &str);
  template <typename Domain2>
  inline typed::map<Domain2, pair<Range, Range2>> apply_domain(const typed::map<pair<T1, T2>, Domain2> &map2) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, pair<Range, Range2>> apply_domain(const typed::union_map<pair<T1, T2>, Domain2> &umap2) const;
  template <typename Domain2>
  inline typed::map<Domain2, pair<Range, Range2>> apply_domain(const typed::basic_map<pair<T1, T2>, Domain2> &map2) const;
  template <typename Arg2>
  inline typed::map<pair<T1, T2>, Arg2> apply_range(const typed::map<pair<Range, Range2>, Arg2> &map2) const;
  template <typename Arg2>
  inline typed::union_map<pair<T1, T2>, Arg2> apply_range(const typed::union_map<pair<Range, Range2>, Arg2> &umap2) const;
  template <typename Arg2>
  inline typed::map<pair<T1, T2>, Arg2> apply_range(const typed::basic_map<pair<Range, Range2>, Arg2> &map2) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> as_map() const;
  inline typed::multi_union_pw_aff<pair<T1, T2>, pair<Range, Range2>> as_multi_union_pw_aff() const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> as_pw_multi_aff() const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> as_union_pw_multi_aff() const;
  inline typed::set<pair<Range, Range2>> bind_domain(const typed::multi_id<pair<T1, T2>> &tuple) const;
  inline typed::set<pair<T1, T2>> bind_range(const typed::multi_id<pair<Range, Range2>> &tuple) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> coalesce() const;
  inline typed::map<T1, pair<T2, pair<Range, Range2>>> curry() const;
  inline typed::set<pair<T1, T2>, pair<Range, Range2>> deltas() const = delete;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> detect_equalities() const;
  inline typed::set<pair<T1, T2>> domain() const;
  inline typed::map<T1, pair<Range, Range2>> domain_factor_domain() const;
  inline typed::map<T2, pair<Range, Range2>> domain_factor_range() const;
  inline typed::union_map<pair<pair<T1, T2>, pair<Range, Range2>>, pair<T1, T2>> domain_map() const;
  inline typed::union_pw_multi_aff<pair<pair<T1, T2>, pair<Range, Range2>>, pair<T1, T2>> domain_map_union_pw_multi_aff() const;
  template <typename Domain2>
  inline typed::map<pair<pair<T1, T2>, Domain2>, pair<Range, Range2>> domain_product(const typed::map<Domain2, pair<Range, Range2>> &map2) const;
  template <typename Domain2>
  inline typed::union_map<pair<pair<T1, T2>, Domain2>, pair<Range, Range2>> domain_product(const typed::union_map<Domain2, pair<Range, Range2>> &umap2) const;
  template <typename Domain2>
  inline typed::map<pair<pair<T1, T2>, Domain2>, pair<Range, Range2>> domain_product(const typed::basic_map<Domain2, pair<Range, Range2>> &map2) const;
  inline typed::map<pair<T2, T1>, pair<Range, Range2>> domain_reverse() const;
  inline typed::id<pair<T1, T2>, pair<Range, Range2>> get_domain_tuple_id() const = delete;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> drop_unused_params() const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> eq_at(const typed::multi_pw_aff<> &mpa) const = delete;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> eq_at(const typed::multi_union_pw_aff<> &mupa) const = delete;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> eq_at(const typed::aff<> &mpa) const = delete;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> eq_at(const typed::multi_aff<> &mpa) const = delete;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> eq_at(const typed::pw_aff<> &mpa) const = delete;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> eq_at(const typed::pw_multi_aff<> &mpa) const = delete;
  inline bool every_map(const std::function<bool(typed::map<pair<T1, T2>, pair<Range, Range2>>)> &test) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> extract_map(const typed::space<pair<T1, T2>, pair<Range, Range2>> &space) const;
  inline typed::map<Anonymous, pair<Range, Range2>> flatten_domain() const;
  inline typed::map<pair<T1, T2>, Anonymous> flatten_range() const;
  inline void foreach_basic_map(const std::function<void(typed::basic_map<pair<T1, T2>, pair<Range, Range2>>)> &fn) const;
  inline void foreach_map(const std::function<void(typed::map<pair<T1, T2>, pair<Range, Range2>>)> &fn) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> gist(const typed::map<pair<T1, T2>, pair<Range, Range2>> &context) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> gist(const typed::union_map<pair<T1, T2>, pair<Range, Range2>> &context) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> gist(const typed::basic_map<pair<T1, T2>, pair<Range, Range2>> &context) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> gist_domain(const typed::set<pair<T1, T2>> &context) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> gist_domain(const typed::union_set<pair<T1, T2>> &uset) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> gist_domain(const typed::basic_set<pair<T1, T2>> &context) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> gist_domain(const typed::point<pair<T1, T2>> &context) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> gist_params(const typed::set<> &context) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> gist_params(const typed::basic_set<> &context) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> gist_params(const typed::point<> &context) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> intersect(const typed::map<pair<T1, T2>, pair<Range, Range2>> &map2) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> intersect(const typed::union_map<pair<T1, T2>, pair<Range, Range2>> &umap2) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> intersect(const typed::basic_map<pair<T1, T2>, pair<Range, Range2>> &map2) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> intersect_domain(const typed::set<pair<T1, T2>> &set) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> intersect_domain(const typed::space<pair<T1, T2>> &space) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> intersect_domain(const typed::union_set<pair<T1, T2>> &uset) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> intersect_domain(const typed::basic_set<pair<T1, T2>> &set) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> intersect_domain(const typed::point<pair<T1, T2>> &set) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> intersect_domain_wrapped_domain(const typed::set<T1> &domain) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> intersect_domain_wrapped_domain(const typed::union_set<T1> &domain) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> intersect_domain_wrapped_domain(const typed::basic_set<T1> &domain) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> intersect_domain_wrapped_domain(const typed::point<T1> &domain) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> intersect_params(const typed::set<> &params) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> intersect_params(const typed::basic_set<> &params) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> intersect_params(const typed::point<> &params) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> intersect_range(const typed::set<pair<Range, Range2>> &set) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> intersect_range(const typed::space<pair<Range, Range2>> &space) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> intersect_range(const typed::union_set<pair<Range, Range2>> &uset) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> intersect_range(const typed::basic_set<pair<Range, Range2>> &set) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> intersect_range(const typed::point<pair<Range, Range2>> &set) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> intersect_range_wrapped_domain(const typed::set<Range> &domain) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> intersect_range_wrapped_domain(const typed::union_set<Range> &domain) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> intersect_range_wrapped_domain(const typed::basic_set<Range> &domain) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> intersect_range_wrapped_domain(const typed::point<Range> &domain) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> lex_ge_at(const typed::multi_pw_aff<> &mpa) const = delete;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> lex_ge_at(const typed::aff<> &mpa) const = delete;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> lex_ge_at(const typed::multi_aff<> &mpa) const = delete;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> lex_ge_at(const typed::pw_aff<> &mpa) const = delete;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> lex_ge_at(const typed::pw_multi_aff<> &mpa) const = delete;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> lex_gt_at(const typed::multi_pw_aff<> &mpa) const = delete;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> lex_gt_at(const typed::aff<> &mpa) const = delete;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> lex_gt_at(const typed::multi_aff<> &mpa) const = delete;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> lex_gt_at(const typed::pw_aff<> &mpa) const = delete;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> lex_gt_at(const typed::pw_multi_aff<> &mpa) const = delete;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> lex_le_at(const typed::multi_pw_aff<> &mpa) const = delete;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> lex_le_at(const typed::aff<> &mpa) const = delete;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> lex_le_at(const typed::multi_aff<> &mpa) const = delete;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> lex_le_at(const typed::pw_aff<> &mpa) const = delete;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> lex_le_at(const typed::pw_multi_aff<> &mpa) const = delete;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> lex_lt_at(const typed::multi_pw_aff<> &mpa) const = delete;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> lex_lt_at(const typed::aff<> &mpa) const = delete;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> lex_lt_at(const typed::multi_aff<> &mpa) const = delete;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> lex_lt_at(const typed::pw_aff<> &mpa) const = delete;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> lex_lt_at(const typed::pw_multi_aff<> &mpa) const = delete;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> lexmax() const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> lexmax_pw_multi_aff() const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> lexmin() const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> lexmin_pw_multi_aff() const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> lower_bound(const typed::multi_pw_aff<pair<T1, T2>, pair<Range, Range2>> &lower) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> lower_bound(const typed::aff<pair<T1, T2>, pair<Range, Range2>> &lower) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> lower_bound(const typed::multi_aff<pair<T1, T2>, pair<Range, Range2>> &lower) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> lower_bound(const typed::pw_aff<pair<T1, T2>, pair<Range, Range2>> &lower) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> lower_bound(const typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> &lower) const;
  inline typed::map_list<pair<T1, T2>, pair<Range, Range2>> map_list() const;
  inline typed::multi_pw_aff<pair<T1, T2>, pair<Range, Range2>> max_multi_pw_aff() const;
  inline typed::multi_pw_aff<pair<T1, T2>, pair<Range, Range2>> min_multi_pw_aff() const;
  inline typed::set<> params() const;
  template <typename Domain2>
  inline typed::map<Domain2, pair<Range, Range2>> preimage_domain(const typed::multi_aff<Domain2, pair<T1, T2>> &ma) const;
  template <typename Domain2>
  inline typed::map<Domain2, pair<Range, Range2>> preimage_domain(const typed::multi_pw_aff<Domain2, pair<T1, T2>> &mpa) const;
  template <typename Domain2>
  inline typed::map<Domain2, pair<Range, Range2>> preimage_domain(const typed::pw_multi_aff<Domain2, pair<T1, T2>> &pma) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, pair<Range, Range2>> preimage_domain(const typed::union_pw_multi_aff<Domain2, pair<T1, T2>> &upma) const;
  template <typename Arg2>
  inline typed::map<pair<T1, T2>, Arg2> preimage_range(const typed::multi_aff<Arg2, pair<Range, Range2>> &ma) const;
  template <typename Arg2>
  inline typed::map<pair<T1, T2>, Arg2> preimage_range(const typed::pw_multi_aff<Arg2, pair<Range, Range2>> &pma) const;
  template <typename Arg2>
  inline typed::union_map<pair<T1, T2>, Arg2> preimage_range(const typed::union_pw_multi_aff<Arg2, pair<Range, Range2>> &upma) const;
  template <typename Domain2, typename Arg2>
  inline typed::map<pair<pair<T1, T2>, Domain2>, pair<pair<Range, Range2>, Arg2>> product(const typed::map<Domain2, Arg2> &map2) const;
  template <typename Domain2, typename Arg2>
  inline typed::union_map<pair<pair<T1, T2>, Domain2>, pair<pair<Range, Range2>, Arg2>> product(const typed::union_map<Domain2, Arg2> &umap2) const;
  template <typename Domain2, typename Arg2>
  inline typed::map<pair<pair<T1, T2>, Domain2>, pair<pair<Range, Range2>, Arg2>> product(const typed::basic_map<Domain2, Arg2> &map2) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> project_out_all_params() const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> project_out_param(const typed::id<Anonymous> &id) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> project_out_param(const std::string &id) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> project_out_param(const typed::id_list<Anonymous> &list) const;
  inline typed::set<pair<Range, Range2>> range() const;
  inline typed::map<pair<T1, T2>, Range> range_factor_domain() const;
  inline typed::map<pair<T1, T2>, Range2> range_factor_range() const;
  inline typed::fixed_box<pair<T1, T2>, pair<Range, Range2>> range_lattice_tile() const;
  inline typed::fixed_box<pair<T1, T2>, pair<Range, Range2>> get_range_lattice_tile() const = delete;
  inline typed::union_map<pair<pair<T1, T2>, pair<Range, Range2>>, pair<Range, Range2>> range_map() const;
  template <typename Arg2>
  inline typed::map<pair<T1, T2>, pair<pair<Range, Range2>, Arg2>> range_product(const typed::map<pair<T1, T2>, Arg2> &map2) const;
  template <typename Arg2>
  inline typed::union_map<pair<T1, T2>, pair<pair<Range, Range2>, Arg2>> range_product(const typed::union_map<pair<T1, T2>, Arg2> &umap2) const;
  template <typename Arg2>
  inline typed::map<pair<T1, T2>, pair<pair<Range, Range2>, Arg2>> range_product(const typed::basic_map<pair<T1, T2>, Arg2> &map2) const;
  inline typed::map<pair<T1, T2>, pair<Range2, Range>> range_reverse() const;
  inline typed::fixed_box<pair<T1, T2>, pair<Range, Range2>> range_simple_fixed_box_hull() const;
  inline typed::fixed_box<pair<T1, T2>, pair<Range, Range2>> get_range_simple_fixed_box_hull() const = delete;
  inline typed::id<pair<T1, T2>, pair<Range, Range2>> get_range_tuple_id() const = delete;
  inline typed::map<pair<Range, Range2>, pair<T1, T2>> reverse() const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> set_domain_tuple(const typed::id<> &id) const = delete;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> set_domain_tuple(const std::string &id) const = delete;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> set_range_tuple(const typed::id<> &id) const = delete;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> set_range_tuple(const std::string &id) const = delete;
  inline typed::space<pair<T1, T2>, pair<Range, Range2>> space() const;
  inline typed::space<pair<T1, T2>, pair<Range, Range2>> get_space() const = delete;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> subtract(const typed::map<pair<T1, T2>, pair<Range, Range2>> &map2) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> subtract(const typed::union_map<pair<T1, T2>, pair<Range, Range2>> &umap2) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> subtract(const typed::basic_map<pair<T1, T2>, pair<Range, Range2>> &map2) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> subtract_domain(const typed::union_set<pair<T1, T2>> &dom) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> subtract_range(const typed::union_set<pair<Range, Range2>> &dom) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> to_union_map() const;
  inline typed::map<pair<pair<T1, T2>, Range>, Range2> uncurry() const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> unite(const typed::map<pair<T1, T2>, pair<Range, Range2>> &map2) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> unite(const typed::union_map<pair<T1, T2>, pair<Range, Range2>> &umap2) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> unite(const typed::basic_map<pair<T1, T2>, pair<Range, Range2>> &map2) const;
  static inline typed::map<pair<T1, T2>, pair<Range, Range2>> universe(const typed::space<pair<T1, T2>, pair<Range, Range2>> &space);
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> upper_bound(const typed::multi_pw_aff<pair<T1, T2>, pair<Range, Range2>> &upper) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> upper_bound(const typed::aff<pair<T1, T2>, pair<Range, Range2>> &upper) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> upper_bound(const typed::multi_aff<pair<T1, T2>, pair<Range, Range2>> &upper) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> upper_bound(const typed::pw_aff<pair<T1, T2>, pair<Range, Range2>> &upper) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> upper_bound(const typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> &upper) const;
  inline typed::set<pair<pair<T1, T2>, pair<Range, Range2>>> wrap() const;
};

template <typename Domain, typename Range>
struct map_list<Domain, Range> : public isl::map_list {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  map_list() = default;
  template <typename Arg1, typename Arg2,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{} &&
              std::is_base_of<Range, Arg2>{},
            bool>::type = true>
  map_list(const map_list<Arg1, Arg2> &obj) : isl::map_list(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::map_list>{}, bool>::type = true>
  map_list(const base &obj) : isl::map_list(obj) {}
 public:
  static map_list from(const isl::map_list &obj) {
    return map_list(obj);
  }
  inline explicit map_list(const isl::ctx &ctx, int n);
  inline explicit map_list(const typed::map<Domain, Range> &el);
  inline explicit map_list(const isl::ctx &ctx, const std::string &str);
  inline typed::map_list<Domain, Range> add(const typed::map<Domain, Range> &el) const;
  inline typed::map_list<Domain, Range> add(const typed::basic_map<Domain, Range> &el) const;
  inline typed::map<Domain, Range> at(int index) const;
  inline typed::map<Domain, Range> get_at(int index) const = delete;
  inline typed::map_list<Domain, Range> drop(unsigned int first, unsigned int n) const;
  inline void foreach(const std::function<void(typed::map<Domain, Range>)> &fn) const;
  inline void foreach_scc(const std::function<bool(typed::map<Domain, Range>, typed::map<Domain, Range>)> &follows, const std::function<void(typed::map_list<Domain, Range>)> &fn) const;
  inline typed::map_list<Domain, Range> set_at(int index, const typed::map<Domain, Anonymous> &el) const;
};

template <typename Domain>
struct multi_aff<Domain> : public isl::multi_aff {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  multi_aff() = default;
  template <typename Arg1,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{},
            bool>::type = true>
  multi_aff(const multi_aff<Arg1> &obj) : isl::multi_aff(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::multi_aff>{}, bool>::type = true>
  multi_aff(const base &obj) : isl::multi_aff(obj) {}
 public:
  static multi_aff from(const isl::multi_aff &obj) {
    return multi_aff(obj);
  }
  inline /* implicit */ multi_aff(const typed::aff<Domain> &aff);
  inline explicit multi_aff(const typed::space<Domain> &space, const typed::aff_list<Anonymous> &list);
  inline explicit multi_aff(const isl::ctx &ctx, const std::string &str);
  inline typed::multi_aff<Domain> add(const typed::multi_aff<Domain> &multi2) const;
  inline typed::multi_pw_aff<Domain> add(const typed::multi_pw_aff<Domain> &multi2) const;
  inline typed::multi_union_pw_aff<Domain> add(const typed::multi_union_pw_aff<Domain> &multi2) const;
  inline typed::pw_multi_aff<Domain> add(const typed::pw_multi_aff<Domain> &pma2) const;
  inline typed::union_pw_multi_aff<Domain> add(const typed::union_pw_multi_aff<Domain> &upma2) const;
  inline typed::multi_aff<Domain> add(const typed::aff<Domain> &multi2) const;
  inline typed::multi_aff<Domain> add_constant(const typed::multi_val<Domain> &mv) const;
  inline typed::multi_aff<Domain> add_constant(const typed::val<Domain> &v) const;
  inline typed::multi_aff<Domain> add_constant(long v) const;
  template <typename Range>
  inline typed::union_pw_multi_aff<Range> apply(const typed::union_pw_multi_aff<Domain, Range> &upma2) const;
  inline typed::map<Domain> as_map() const = delete;
  inline typed::multi_aff<Domain> as_multi_aff() const;
  inline typed::multi_union_pw_aff<Domain> as_multi_union_pw_aff() const;
  inline typed::pw_multi_aff<Domain> as_pw_multi_aff() const;
  inline typed::set<Domain> as_set() const;
  inline typed::union_map<Domain> as_union_map() const = delete;
  inline typed::aff<Anonymous> at(int pos) const;
  inline typed::aff<Domain> get_at(int pos) const = delete;
  inline typed::basic_set<> bind(const typed::multi_id<Domain> &tuple) const;
  inline typed::multi_aff<Domain> bind_domain(const typed::multi_id<> &tuple) const = delete;
  inline typed::multi_aff<Domain> bind_domain_wrapped_domain(const typed::multi_id<> &tuple) const = delete;
  inline typed::pw_multi_aff<Domain> coalesce() const;
  inline typed::multi_val<Domain> constant_multi_val() const;
  inline typed::multi_val<Domain> get_constant_multi_val() const = delete;
  inline typed::set<> domain() const;
  inline typed::multi_aff<Domain> domain_reverse() const = delete;
  inline typed::pw_multi_aff<Domain> drop_unused_params() const;
  inline typed::pw_multi_aff<Domain> extract_pw_multi_aff(const typed::space<Domain> &space) const;
  inline typed::multi_aff<Domain> floor() const;
  inline typed::multi_aff<Domain> gist(const typed::set<> &context) const;
  inline typed::union_pw_multi_aff<Domain> gist(const typed::union_set<> &context) const;
  inline typed::multi_aff<Domain> gist(const typed::basic_set<> &context) const;
  inline typed::multi_aff<Domain> gist(const typed::point<> &context) const;
  inline typed::multi_aff<Domain> gist_params(const typed::set<> &context) const;
  inline typed::multi_aff<Domain> gist_params(const typed::basic_set<> &context) const;
  inline typed::multi_aff<Domain> gist_params(const typed::point<> &context) const;
  inline typed::multi_aff<Domain, Domain> identity() const;
  template <typename Arg1>
  inline typed::multi_aff<Arg1, Domain> insert_domain(const typed::space<Arg1> &domain) const;
  inline typed::pw_multi_aff<Domain> intersect_domain(const typed::set<> &set) const = delete;
  inline typed::union_pw_multi_aff<Domain> intersect_domain(const typed::space<> &space) const = delete;
  inline typed::union_pw_multi_aff<Domain> intersect_domain(const typed::union_set<> &uset) const = delete;
  inline typed::union_pw_multi_aff<Domain> intersect_domain_wrapped_domain(const typed::union_set<> &uset) const = delete;
  inline typed::pw_multi_aff<Domain> intersect_params(const typed::set<> &set) const;
  inline typed::aff_list<Anonymous> list() const;
  inline typed::aff_list<Domain> get_list() const = delete;
  inline typed::multi_pw_aff<Domain> max(const typed::multi_pw_aff<Domain> &multi2) const;
  inline typed::multi_val<Domain> max_multi_val() const;
  inline typed::multi_pw_aff<Domain> min(const typed::multi_pw_aff<Domain> &multi2) const;
  inline typed::multi_val<Domain> min_multi_val() const;
  inline typed::multi_aff<Domain> neg() const;
  inline typed::pw_multi_aff<Domain> preimage_domain_wrapped_domain(const typed::pw_multi_aff<> &pma2) const = delete;
  inline typed::union_pw_multi_aff<Domain> preimage_domain_wrapped_domain(const typed::union_pw_multi_aff<> &upma2) const = delete;
  template <typename Range>
  inline typed::multi_aff<pair<Domain, Range>> product(const typed::multi_aff<Range> &multi2) const;
  template <typename Range>
  inline typed::multi_pw_aff<pair<Domain, Range>> product(const typed::multi_pw_aff<Range> &multi2) const;
  template <typename Range>
  inline typed::pw_multi_aff<pair<Domain, Range>> product(const typed::pw_multi_aff<Range> &pma2) const;
  inline typed::multi_aff<pair<Domain, Anonymous>> product(const typed::aff<Anonymous> &multi2) const;
  inline typed::multi_aff<Domain> pullback(const typed::multi_aff<> &ma2) const = delete;
  inline typed::multi_pw_aff<Domain> pullback(const typed::multi_pw_aff<> &mpa2) const = delete;
  inline typed::pw_multi_aff<Domain> pullback(const typed::pw_multi_aff<> &pma2) const = delete;
  inline typed::union_pw_multi_aff<Domain> pullback(const typed::union_pw_multi_aff<> &upma2) const = delete;
  inline typed::multi_aff<Domain> pullback(const typed::aff<> &ma2) const = delete;
  inline typed::pw_multi_aff_list<Domain> pw_multi_aff_list() const;
  inline typed::pw_multi_aff<Domain> range_factor_domain() const = delete;
  inline typed::pw_multi_aff<Domain> range_factor_range() const = delete;
  inline typed::multi_aff<Domain> range_product(const typed::multi_aff<> &multi2) const = delete;
  inline typed::multi_pw_aff<Domain> range_product(const typed::multi_pw_aff<> &multi2) const = delete;
  inline typed::multi_union_pw_aff<Domain> range_product(const typed::multi_union_pw_aff<> &multi2) const = delete;
  inline typed::pw_multi_aff<Domain> range_product(const typed::pw_multi_aff<> &pma2) const = delete;
  inline typed::union_pw_multi_aff<Domain> range_product(const typed::union_pw_multi_aff<> &upma2) const = delete;
  inline typed::multi_aff<Domain> range_product(const typed::aff<> &multi2) const = delete;
  inline typed::id<Domain> get_range_tuple_id() const = delete;
  inline typed::multi_aff<Domain> scale(const typed::multi_val<Domain> &mv) const;
  inline typed::multi_aff<Domain> scale(const typed::val<Domain> &v) const;
  inline typed::multi_aff<Domain> scale(long v) const;
  inline typed::multi_aff<Domain> scale_down(const typed::multi_val<Domain> &mv) const;
  inline typed::multi_aff<Domain> scale_down(const typed::val<Domain> &v) const;
  inline typed::multi_aff<Domain> scale_down(long v) const;
  inline typed::multi_aff<Domain> set_at(int pos, const typed::aff<Anonymous> &el) const;
  inline typed::multi_pw_aff<Domain> set_at(int pos, const typed::pw_aff<Anonymous> &el) const;
  inline typed::multi_union_pw_aff<Domain> set_at(int pos, const typed::union_pw_aff<Anonymous> &el) const;
  template <typename Domain2>
  inline typed::multi_aff<Domain2> set_range_tuple(const typed::id<Anonymous> &id) const;
  template <typename Domain2>
  inline typed::multi_aff<Domain2> set_range_tuple(const std::string &id) const;
  inline typed::space<Domain> space() const;
  inline typed::space<Domain> get_space() const = delete;
  inline typed::multi_aff<Domain> sub(const typed::multi_aff<Domain> &multi2) const;
  inline typed::multi_pw_aff<Domain> sub(const typed::multi_pw_aff<Domain> &multi2) const;
  inline typed::multi_union_pw_aff<Domain> sub(const typed::multi_union_pw_aff<Domain> &multi2) const;
  inline typed::pw_multi_aff<Domain> sub(const typed::pw_multi_aff<Domain> &pma2) const;
  inline typed::union_pw_multi_aff<Domain> sub(const typed::union_pw_multi_aff<Domain> &upma2) const;
  inline typed::multi_aff<Domain> sub(const typed::aff<Domain> &multi2) const;
  inline typed::pw_multi_aff<Domain> subtract_domain(const typed::set<> &set) const = delete;
  inline typed::union_pw_multi_aff<Domain> subtract_domain(const typed::space<> &space) const = delete;
  inline typed::union_pw_multi_aff<Domain> subtract_domain(const typed::union_set<> &uset) const = delete;
  inline typed::multi_pw_aff<Domain> to_multi_pw_aff() const;
  inline typed::multi_union_pw_aff<Domain> to_multi_union_pw_aff() const;
  inline typed::pw_multi_aff<Domain> to_pw_multi_aff() const;
  inline typed::union_pw_multi_aff<Domain> to_union_pw_multi_aff() const;
  template <typename Arg1>
  inline typed::multi_aff<Arg1, Domain> unbind_params_insert_domain(const typed::multi_id<Arg1> &domain) const;
  inline typed::multi_pw_aff<Domain> union_add(const typed::multi_pw_aff<Domain> &mpa2) const;
  inline typed::multi_union_pw_aff<Domain> union_add(const typed::multi_union_pw_aff<Domain> &mupa2) const;
  inline typed::pw_multi_aff<Domain> union_add(const typed::pw_multi_aff<Domain> &pma2) const;
  inline typed::union_pw_multi_aff<Domain> union_add(const typed::union_pw_multi_aff<Domain> &upma2) const;
};

template <typename Domain, typename Range>
struct multi_aff<Domain, Range> : public isl::multi_aff {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  multi_aff() = default;
  template <typename Arg1, typename Arg2,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{} &&
              std::is_base_of<Range, Arg2>{},
            bool>::type = true>
  multi_aff(const multi_aff<Arg1, Arg2> &obj) : isl::multi_aff(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::multi_aff>{}, bool>::type = true>
  multi_aff(const base &obj) : isl::multi_aff(obj) {}
 public:
  static multi_aff from(const isl::multi_aff &obj) {
    return multi_aff(obj);
  }
  inline /* implicit */ multi_aff(const typed::aff<Domain, Range> &aff);
  inline explicit multi_aff(const typed::space<Domain, Range> &space, const typed::aff_list<Domain, Anonymous> &list);
  inline explicit multi_aff(const isl::ctx &ctx, const std::string &str);
  inline typed::multi_aff<Domain, Range> add(const typed::multi_aff<Domain, Range> &multi2) const;
  inline typed::multi_pw_aff<Domain, Range> add(const typed::multi_pw_aff<Domain, Range> &multi2) const;
  inline typed::multi_union_pw_aff<Domain, Range> add(const typed::multi_union_pw_aff<Domain, Range> &multi2) const;
  inline typed::pw_multi_aff<Domain, Range> add(const typed::pw_multi_aff<Domain, Range> &pma2) const;
  inline typed::union_pw_multi_aff<Domain, Range> add(const typed::union_pw_multi_aff<Domain, Range> &upma2) const;
  inline typed::multi_aff<Domain, Range> add(const typed::aff<Domain, Range> &multi2) const;
  inline typed::multi_aff<Domain, Range> add_constant(const typed::multi_val<Range> &mv) const;
  inline typed::multi_aff<Domain, Range> add_constant(const typed::val<Range> &v) const;
  inline typed::multi_aff<Domain, Range> add_constant(long v) const;
  template <typename Range2>
  inline typed::union_pw_multi_aff<Domain, Range2> apply(const typed::union_pw_multi_aff<Range, Range2> &upma2) const;
  inline typed::map<Domain, Range> as_map() const;
  inline typed::multi_aff<Domain, Range> as_multi_aff() const;
  inline typed::multi_union_pw_aff<Domain, Range> as_multi_union_pw_aff() const;
  inline typed::pw_multi_aff<Domain, Range> as_pw_multi_aff() const;
  inline typed::set<Domain, Range> as_set() const = delete;
  inline typed::union_map<Domain, Range> as_union_map() const;
  inline typed::aff<Domain, Anonymous> at(int pos) const;
  inline typed::aff<Domain, Range> get_at(int pos) const = delete;
  inline typed::basic_set<Domain> bind(const typed::multi_id<Range> &tuple) const;
  inline typed::multi_aff<Range> bind_domain(const typed::multi_id<Domain> &tuple) const;
  inline typed::multi_aff<Domain, Range> bind_domain_wrapped_domain(const typed::multi_id<> &tuple) const = delete;
  inline typed::pw_multi_aff<Domain, Range> coalesce() const;
  inline typed::multi_val<Range> constant_multi_val() const;
  inline typed::multi_val<Domain, Range> get_constant_multi_val() const = delete;
  inline typed::set<Domain> domain() const;
  inline typed::multi_aff<Domain, Range> domain_reverse() const = delete;
  inline typed::pw_multi_aff<Domain, Range> drop_unused_params() const;
  inline typed::pw_multi_aff<Domain, Range> extract_pw_multi_aff(const typed::space<Domain, Range> &space) const;
  inline typed::multi_aff<Domain, Range> floor() const;
  inline typed::multi_aff<Domain, Range> gist(const typed::set<Domain> &context) const;
  inline typed::union_pw_multi_aff<Domain, Range> gist(const typed::union_set<Domain> &context) const;
  inline typed::multi_aff<Domain, Range> gist(const typed::basic_set<Domain> &context) const;
  inline typed::multi_aff<Domain, Range> gist(const typed::point<Domain> &context) const;
  inline typed::multi_aff<Domain, Range> gist_params(const typed::set<> &context) const;
  inline typed::multi_aff<Domain, Range> gist_params(const typed::basic_set<> &context) const;
  inline typed::multi_aff<Domain, Range> gist_params(const typed::point<> &context) const;
  inline typed::multi_aff<Domain, Range> identity() const;
  inline typed::multi_aff<Domain, Range> insert_domain(const typed::space<> &domain) const = delete;
  inline typed::pw_multi_aff<Domain, Range> intersect_domain(const typed::set<Domain> &set) const;
  inline typed::union_pw_multi_aff<Domain, Range> intersect_domain(const typed::space<Domain> &space) const;
  inline typed::union_pw_multi_aff<Domain, Range> intersect_domain(const typed::union_set<Domain> &uset) const;
  inline typed::union_pw_multi_aff<Domain, Range> intersect_domain_wrapped_domain(const typed::union_set<> &uset) const = delete;
  inline typed::pw_multi_aff<Domain, Range> intersect_params(const typed::set<> &set) const;
  inline typed::aff_list<Domain, Anonymous> list() const;
  inline typed::aff_list<Domain, Range> get_list() const = delete;
  inline typed::multi_pw_aff<Domain, Range> max(const typed::multi_pw_aff<Domain, Range> &multi2) const;
  inline typed::multi_val<Range> max_multi_val() const;
  inline typed::multi_pw_aff<Domain, Range> min(const typed::multi_pw_aff<Domain, Range> &multi2) const;
  inline typed::multi_val<Range> min_multi_val() const;
  inline typed::multi_aff<Domain, Range> neg() const;
  inline typed::pw_multi_aff<Domain, Range> preimage_domain_wrapped_domain(const typed::pw_multi_aff<> &pma2) const = delete;
  inline typed::union_pw_multi_aff<Domain, Range> preimage_domain_wrapped_domain(const typed::union_pw_multi_aff<> &upma2) const = delete;
  template <typename Domain2, typename Range2>
  inline typed::multi_aff<pair<Domain, Domain2>, pair<Range, Range2>> product(const typed::multi_aff<Domain2, Range2> &multi2) const;
  template <typename Domain2, typename Range2>
  inline typed::multi_pw_aff<pair<Domain, Domain2>, pair<Range, Range2>> product(const typed::multi_pw_aff<Domain2, Range2> &multi2) const;
  template <typename Domain2, typename Range2>
  inline typed::pw_multi_aff<pair<Domain, Domain2>, pair<Range, Range2>> product(const typed::pw_multi_aff<Domain2, Range2> &pma2) const;
  template <typename Domain2>
  inline typed::multi_aff<pair<Domain, Domain2>, pair<Range, Anonymous>> product(const typed::aff<Domain2, Anonymous> &multi2) const;
  template <typename Domain2>
  inline typed::multi_aff<Domain2, Range> pullback(const typed::multi_aff<Domain2, Domain> &ma2) const;
  inline typed::multi_aff<Range> pullback(const typed::multi_aff<Domain> &ma2) const;
  template <typename Domain2>
  inline typed::multi_pw_aff<Domain2, Range> pullback(const typed::multi_pw_aff<Domain2, Domain> &mpa2) const;
  inline typed::multi_pw_aff<Range> pullback(const typed::multi_pw_aff<Domain> &mpa2) const;
  template <typename Domain2>
  inline typed::pw_multi_aff<Domain2, Range> pullback(const typed::pw_multi_aff<Domain2, Domain> &pma2) const;
  inline typed::pw_multi_aff<Range> pullback(const typed::pw_multi_aff<Domain> &pma2) const;
  template <typename Domain2>
  inline typed::union_pw_multi_aff<Domain2, Range> pullback(const typed::union_pw_multi_aff<Domain2, Domain> &upma2) const;
  inline typed::union_pw_multi_aff<Range> pullback(const typed::union_pw_multi_aff<Domain> &upma2) const;
  template <typename Domain2>
  inline typed::multi_aff<Domain2, Range> pullback(const typed::aff<Domain2, Domain> &ma2) const;
  inline typed::multi_aff<Range> pullback(const typed::aff<Domain> &ma2) const;
  inline typed::pw_multi_aff_list<Domain, Range> pw_multi_aff_list() const;
  inline typed::pw_multi_aff<Domain, Range> range_factor_domain() const = delete;
  inline typed::pw_multi_aff<Domain, Range> range_factor_range() const = delete;
  template <typename Range2>
  inline typed::multi_aff<Domain, pair<Range, Range2>> range_product(const typed::multi_aff<Domain, Range2> &multi2) const;
  template <typename Range2>
  inline typed::multi_pw_aff<Domain, pair<Range, Range2>> range_product(const typed::multi_pw_aff<Domain, Range2> &multi2) const;
  template <typename Range2>
  inline typed::multi_union_pw_aff<Domain, pair<Range, Range2>> range_product(const typed::multi_union_pw_aff<Domain, Range2> &multi2) const;
  template <typename Range2>
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> range_product(const typed::pw_multi_aff<Domain, Range2> &pma2) const;
  template <typename Range2>
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> range_product(const typed::union_pw_multi_aff<Domain, Range2> &upma2) const;
  inline typed::multi_aff<Domain, pair<Range, Anonymous>> range_product(const typed::aff<Domain, Anonymous> &multi2) const;
  inline typed::id<Domain, Range> get_range_tuple_id() const = delete;
  inline typed::multi_aff<Domain, Range> scale(const typed::multi_val<Range> &mv) const;
  inline typed::multi_aff<Domain, Range> scale(const typed::val<Range> &v) const;
  inline typed::multi_aff<Domain, Range> scale(long v) const;
  inline typed::multi_aff<Domain, Range> scale_down(const typed::multi_val<Range> &mv) const;
  inline typed::multi_aff<Domain, Range> scale_down(const typed::val<Range> &v) const;
  inline typed::multi_aff<Domain, Range> scale_down(long v) const;
  inline typed::multi_aff<Domain, Range> set_at(int pos, const typed::aff<Domain, Anonymous> &el) const;
  inline typed::multi_pw_aff<Domain, Range> set_at(int pos, const typed::pw_aff<Domain, Anonymous> &el) const;
  inline typed::multi_union_pw_aff<Domain, Range> set_at(int pos, const typed::union_pw_aff<Domain, Anonymous> &el) const;
  template <typename Range2>
  inline typed::multi_aff<Domain, Range2> set_range_tuple(const typed::id<Anonymous> &id) const;
  template <typename Range2>
  inline typed::multi_aff<Domain, Range2> set_range_tuple(const std::string &id) const;
  inline typed::space<Domain, Range> space() const;
  inline typed::space<Domain, Range> get_space() const = delete;
  inline typed::multi_aff<Domain, Range> sub(const typed::multi_aff<Domain, Range> &multi2) const;
  inline typed::multi_pw_aff<Domain, Range> sub(const typed::multi_pw_aff<Domain, Range> &multi2) const;
  inline typed::multi_union_pw_aff<Domain, Range> sub(const typed::multi_union_pw_aff<Domain, Range> &multi2) const;
  inline typed::pw_multi_aff<Domain, Range> sub(const typed::pw_multi_aff<Domain, Range> &pma2) const;
  inline typed::union_pw_multi_aff<Domain, Range> sub(const typed::union_pw_multi_aff<Domain, Range> &upma2) const;
  inline typed::multi_aff<Domain, Range> sub(const typed::aff<Domain, Range> &multi2) const;
  inline typed::pw_multi_aff<Domain, Range> subtract_domain(const typed::set<Domain> &set) const;
  inline typed::union_pw_multi_aff<Domain, Range> subtract_domain(const typed::space<Domain> &space) const;
  inline typed::union_pw_multi_aff<Domain, Range> subtract_domain(const typed::union_set<Domain> &uset) const;
  inline typed::multi_pw_aff<Domain, Range> to_multi_pw_aff() const;
  inline typed::multi_union_pw_aff<Domain, Range> to_multi_union_pw_aff() const;
  inline typed::pw_multi_aff<Domain, Range> to_pw_multi_aff() const;
  inline typed::union_pw_multi_aff<Domain, Range> to_union_pw_multi_aff() const;
  inline typed::multi_aff<Domain, Range> unbind_params_insert_domain(const typed::multi_id<> &domain) const = delete;
  inline typed::multi_pw_aff<Domain, Range> union_add(const typed::multi_pw_aff<Domain, Range> &mpa2) const;
  inline typed::multi_union_pw_aff<Domain, Range> union_add(const typed::multi_union_pw_aff<Domain, Range> &mupa2) const;
  inline typed::pw_multi_aff<Domain, Range> union_add(const typed::pw_multi_aff<Domain, Range> &pma2) const;
  inline typed::union_pw_multi_aff<Domain, Range> union_add(const typed::union_pw_multi_aff<Domain, Range> &upma2) const;
};

template <typename Domain2, typename Range2, typename Range>
struct multi_aff<pair<Domain2, Range2>, Range> : public isl::multi_aff {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  multi_aff() = default;
  template <typename Arg1, typename Arg2, typename Arg3,
            typename std::enable_if<
              std::is_base_of<Domain2, Arg1>{} &&
              std::is_base_of<Range2, Arg2>{} &&
              std::is_base_of<Range, Arg3>{},
            bool>::type = true>
  multi_aff(const multi_aff<pair<Arg1, Arg2>, Arg3> &obj) : isl::multi_aff(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::multi_aff>{}, bool>::type = true>
  multi_aff(const base &obj) : isl::multi_aff(obj) {}
 public:
  static multi_aff from(const isl::multi_aff &obj) {
    return multi_aff(obj);
  }
  inline /* implicit */ multi_aff(const typed::aff<pair<Domain2, Range2>, Range> &aff);
  inline explicit multi_aff(const typed::space<pair<Domain2, Range2>, Range> &space, const typed::aff_list<pair<Domain2, Range2>, Anonymous> &list);
  inline explicit multi_aff(const isl::ctx &ctx, const std::string &str);
  inline typed::multi_aff<pair<Domain2, Range2>, Range> add(const typed::multi_aff<pair<Domain2, Range2>, Range> &multi2) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> add(const typed::multi_pw_aff<pair<Domain2, Range2>, Range> &multi2) const;
  inline typed::multi_union_pw_aff<pair<Domain2, Range2>, Range> add(const typed::multi_union_pw_aff<pair<Domain2, Range2>, Range> &multi2) const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Range> add(const typed::pw_multi_aff<pair<Domain2, Range2>, Range> &pma2) const;
  inline typed::union_pw_multi_aff<pair<Domain2, Range2>, Range> add(const typed::union_pw_multi_aff<pair<Domain2, Range2>, Range> &upma2) const;
  inline typed::multi_aff<pair<Domain2, Range2>, Range> add(const typed::aff<pair<Domain2, Range2>, Range> &multi2) const;
  inline typed::multi_aff<pair<Domain2, Range2>, Range> add_constant(const typed::multi_val<Range> &mv) const;
  inline typed::multi_aff<pair<Domain2, Range2>, Range> add_constant(const typed::val<Range> &v) const;
  inline typed::multi_aff<pair<Domain2, Range2>, Range> add_constant(long v) const;
  template <typename Arg2>
  inline typed::union_pw_multi_aff<pair<Domain2, Range2>, Arg2> apply(const typed::union_pw_multi_aff<Range, Arg2> &upma2) const;
  inline typed::map<pair<Domain2, Range2>, Range> as_map() const;
  inline typed::multi_aff<pair<Domain2, Range2>, Range> as_multi_aff() const;
  inline typed::multi_union_pw_aff<pair<Domain2, Range2>, Range> as_multi_union_pw_aff() const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Range> as_pw_multi_aff() const;
  inline typed::set<pair<Domain2, Range2>, Range> as_set() const = delete;
  inline typed::union_map<pair<Domain2, Range2>, Range> as_union_map() const;
  inline typed::aff<pair<Domain2, Range2>, Anonymous> at(int pos) const;
  inline typed::aff<pair<Domain2, Range2>, Range> get_at(int pos) const = delete;
  inline typed::basic_set<pair<Domain2, Range2>> bind(const typed::multi_id<Range> &tuple) const;
  inline typed::multi_aff<Range> bind_domain(const typed::multi_id<pair<Domain2, Range2>> &tuple) const;
  inline typed::multi_aff<Range2, Range> bind_domain_wrapped_domain(const typed::multi_id<Domain2> &tuple) const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Range> coalesce() const;
  inline typed::multi_val<Range> constant_multi_val() const;
  inline typed::multi_val<pair<Domain2, Range2>, Range> get_constant_multi_val() const = delete;
  inline typed::set<pair<Domain2, Range2>> domain() const;
  inline typed::multi_aff<pair<Range2, Domain2>, Range> domain_reverse() const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Range> drop_unused_params() const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Range> extract_pw_multi_aff(const typed::space<pair<Domain2, Range2>, Range> &space) const;
  inline typed::multi_aff<pair<Domain2, Range2>, Range> floor() const;
  inline typed::multi_aff<pair<Domain2, Range2>, Range> gist(const typed::set<pair<Domain2, Range2>> &context) const;
  inline typed::union_pw_multi_aff<pair<Domain2, Range2>, Range> gist(const typed::union_set<pair<Domain2, Range2>> &context) const;
  inline typed::multi_aff<pair<Domain2, Range2>, Range> gist(const typed::basic_set<pair<Domain2, Range2>> &context) const;
  inline typed::multi_aff<pair<Domain2, Range2>, Range> gist(const typed::point<pair<Domain2, Range2>> &context) const;
  inline typed::multi_aff<pair<Domain2, Range2>, Range> gist_params(const typed::set<> &context) const;
  inline typed::multi_aff<pair<Domain2, Range2>, Range> gist_params(const typed::basic_set<> &context) const;
  inline typed::multi_aff<pair<Domain2, Range2>, Range> gist_params(const typed::point<> &context) const;
  inline typed::multi_aff<pair<Domain2, Range2>, Range> identity() const;
  inline typed::multi_aff<pair<Domain2, Range2>, Range> insert_domain(const typed::space<> &domain) const = delete;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Range> intersect_domain(const typed::set<pair<Domain2, Range2>> &set) const;
  inline typed::union_pw_multi_aff<pair<Domain2, Range2>, Range> intersect_domain(const typed::space<pair<Domain2, Range2>> &space) const;
  inline typed::union_pw_multi_aff<pair<Domain2, Range2>, Range> intersect_domain(const typed::union_set<pair<Domain2, Range2>> &uset) const;
  inline typed::union_pw_multi_aff<pair<Domain2, Range2>, Range> intersect_domain_wrapped_domain(const typed::union_set<Domain2> &uset) const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Range> intersect_params(const typed::set<> &set) const;
  inline typed::aff_list<pair<Domain2, Range2>, Anonymous> list() const;
  inline typed::aff_list<pair<Domain2, Range2>, Range> get_list() const = delete;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> max(const typed::multi_pw_aff<pair<Domain2, Range2>, Range> &multi2) const;
  inline typed::multi_val<Range> max_multi_val() const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> min(const typed::multi_pw_aff<pair<Domain2, Range2>, Range> &multi2) const;
  inline typed::multi_val<Range> min_multi_val() const;
  inline typed::multi_aff<pair<Domain2, Range2>, Range> neg() const;
  template <typename Domain3>
  inline typed::pw_multi_aff<pair<Domain3, Range2>, Range> preimage_domain_wrapped_domain(const typed::pw_multi_aff<Domain3, Domain2> &pma2) const;
  template <typename Domain3>
  inline typed::union_pw_multi_aff<pair<Domain3, Range2>, Range> preimage_domain_wrapped_domain(const typed::union_pw_multi_aff<Domain3, Domain2> &upma2) const;
  template <typename Arg2, typename Arg3>
  inline typed::multi_aff<pair<pair<Domain2, Range2>, Arg2>, pair<Range, Arg3>> product(const typed::multi_aff<Arg2, Arg3> &multi2) const;
  template <typename Arg2, typename Arg3>
  inline typed::multi_pw_aff<pair<pair<Domain2, Range2>, Arg2>, pair<Range, Arg3>> product(const typed::multi_pw_aff<Arg2, Arg3> &multi2) const;
  template <typename Arg2, typename Arg3>
  inline typed::pw_multi_aff<pair<pair<Domain2, Range2>, Arg2>, pair<Range, Arg3>> product(const typed::pw_multi_aff<Arg2, Arg3> &pma2) const;
  template <typename Arg2>
  inline typed::multi_aff<pair<pair<Domain2, Range2>, Arg2>, pair<Range, Anonymous>> product(const typed::aff<Arg2, Anonymous> &multi2) const;
  template <typename Arg2>
  inline typed::multi_aff<Arg2, Range> pullback(const typed::multi_aff<Arg2, pair<Domain2, Range2>> &ma2) const;
  inline typed::multi_aff<Range> pullback(const typed::multi_aff<pair<Domain2, Range2>> &ma2) const;
  template <typename Arg2>
  inline typed::multi_pw_aff<Arg2, Range> pullback(const typed::multi_pw_aff<Arg2, pair<Domain2, Range2>> &mpa2) const;
  inline typed::multi_pw_aff<Range> pullback(const typed::multi_pw_aff<pair<Domain2, Range2>> &mpa2) const;
  template <typename Arg2>
  inline typed::pw_multi_aff<Arg2, Range> pullback(const typed::pw_multi_aff<Arg2, pair<Domain2, Range2>> &pma2) const;
  inline typed::pw_multi_aff<Range> pullback(const typed::pw_multi_aff<pair<Domain2, Range2>> &pma2) const;
  template <typename Arg2>
  inline typed::union_pw_multi_aff<Arg2, Range> pullback(const typed::union_pw_multi_aff<Arg2, pair<Domain2, Range2>> &upma2) const;
  inline typed::union_pw_multi_aff<Range> pullback(const typed::union_pw_multi_aff<pair<Domain2, Range2>> &upma2) const;
  template <typename Arg2>
  inline typed::multi_aff<Arg2, Range> pullback(const typed::aff<Arg2, pair<Domain2, Range2>> &ma2) const;
  inline typed::multi_aff<Range> pullback(const typed::aff<pair<Domain2, Range2>> &ma2) const;
  inline typed::pw_multi_aff_list<pair<Domain2, Range2>, Range> pw_multi_aff_list() const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Range> range_factor_domain() const = delete;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Range> range_factor_range() const = delete;
  template <typename Arg2>
  inline typed::multi_aff<pair<Domain2, Range2>, pair<Range, Arg2>> range_product(const typed::multi_aff<pair<Domain2, Range2>, Arg2> &multi2) const;
  template <typename Arg2>
  inline typed::multi_pw_aff<pair<Domain2, Range2>, pair<Range, Arg2>> range_product(const typed::multi_pw_aff<pair<Domain2, Range2>, Arg2> &multi2) const;
  template <typename Arg2>
  inline typed::multi_union_pw_aff<pair<Domain2, Range2>, pair<Range, Arg2>> range_product(const typed::multi_union_pw_aff<pair<Domain2, Range2>, Arg2> &multi2) const;
  template <typename Arg2>
  inline typed::pw_multi_aff<pair<Domain2, Range2>, pair<Range, Arg2>> range_product(const typed::pw_multi_aff<pair<Domain2, Range2>, Arg2> &pma2) const;
  template <typename Arg2>
  inline typed::union_pw_multi_aff<pair<Domain2, Range2>, pair<Range, Arg2>> range_product(const typed::union_pw_multi_aff<pair<Domain2, Range2>, Arg2> &upma2) const;
  inline typed::multi_aff<pair<Domain2, Range2>, pair<Range, Anonymous>> range_product(const typed::aff<pair<Domain2, Range2>, Anonymous> &multi2) const;
  inline typed::id<pair<Domain2, Range2>, Range> get_range_tuple_id() const = delete;
  inline typed::multi_aff<pair<Domain2, Range2>, Range> scale(const typed::multi_val<Range> &mv) const;
  inline typed::multi_aff<pair<Domain2, Range2>, Range> scale(const typed::val<Range> &v) const;
  inline typed::multi_aff<pair<Domain2, Range2>, Range> scale(long v) const;
  inline typed::multi_aff<pair<Domain2, Range2>, Range> scale_down(const typed::multi_val<Range> &mv) const;
  inline typed::multi_aff<pair<Domain2, Range2>, Range> scale_down(const typed::val<Range> &v) const;
  inline typed::multi_aff<pair<Domain2, Range2>, Range> scale_down(long v) const;
  inline typed::multi_aff<pair<Domain2, Range2>, Range> set_at(int pos, const typed::aff<pair<Domain2, Range2>, Anonymous> &el) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> set_at(int pos, const typed::pw_aff<pair<Domain2, Range2>, Anonymous> &el) const;
  inline typed::multi_union_pw_aff<pair<Domain2, Range2>, Range> set_at(int pos, const typed::union_pw_aff<pair<Domain2, Range2>, Anonymous> &el) const;
  template <typename Arg1>
  inline typed::multi_aff<pair<Domain2, Range2>, Arg1> set_range_tuple(const typed::id<Anonymous> &id) const;
  template <typename Arg1>
  inline typed::multi_aff<pair<Domain2, Range2>, Arg1> set_range_tuple(const std::string &id) const;
  inline typed::space<pair<Domain2, Range2>, Range> space() const;
  inline typed::space<pair<Domain2, Range2>, Range> get_space() const = delete;
  inline typed::multi_aff<pair<Domain2, Range2>, Range> sub(const typed::multi_aff<pair<Domain2, Range2>, Range> &multi2) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> sub(const typed::multi_pw_aff<pair<Domain2, Range2>, Range> &multi2) const;
  inline typed::multi_union_pw_aff<pair<Domain2, Range2>, Range> sub(const typed::multi_union_pw_aff<pair<Domain2, Range2>, Range> &multi2) const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Range> sub(const typed::pw_multi_aff<pair<Domain2, Range2>, Range> &pma2) const;
  inline typed::union_pw_multi_aff<pair<Domain2, Range2>, Range> sub(const typed::union_pw_multi_aff<pair<Domain2, Range2>, Range> &upma2) const;
  inline typed::multi_aff<pair<Domain2, Range2>, Range> sub(const typed::aff<pair<Domain2, Range2>, Range> &multi2) const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Range> subtract_domain(const typed::set<pair<Domain2, Range2>> &set) const;
  inline typed::union_pw_multi_aff<pair<Domain2, Range2>, Range> subtract_domain(const typed::space<pair<Domain2, Range2>> &space) const;
  inline typed::union_pw_multi_aff<pair<Domain2, Range2>, Range> subtract_domain(const typed::union_set<pair<Domain2, Range2>> &uset) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> to_multi_pw_aff() const;
  inline typed::multi_union_pw_aff<pair<Domain2, Range2>, Range> to_multi_union_pw_aff() const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Range> to_pw_multi_aff() const;
  inline typed::union_pw_multi_aff<pair<Domain2, Range2>, Range> to_union_pw_multi_aff() const;
  inline typed::multi_aff<pair<Domain2, Range2>, Range> unbind_params_insert_domain(const typed::multi_id<> &domain) const = delete;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> union_add(const typed::multi_pw_aff<pair<Domain2, Range2>, Range> &mpa2) const;
  inline typed::multi_union_pw_aff<pair<Domain2, Range2>, Range> union_add(const typed::multi_union_pw_aff<pair<Domain2, Range2>, Range> &mupa2) const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Range> union_add(const typed::pw_multi_aff<pair<Domain2, Range2>, Range> &pma2) const;
  inline typed::union_pw_multi_aff<pair<Domain2, Range2>, Range> union_add(const typed::union_pw_multi_aff<pair<Domain2, Range2>, Range> &upma2) const;
};

template <typename Domain, typename Range, typename Range2>
struct multi_aff<Domain, pair<Range, Range2>> : public isl::multi_aff {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  multi_aff() = default;
  template <typename Arg1, typename Arg2, typename Arg3,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{} &&
              std::is_base_of<Range, Arg2>{} &&
              std::is_base_of<Range2, Arg3>{},
            bool>::type = true>
  multi_aff(const multi_aff<Arg1, pair<Arg2, Arg3>> &obj) : isl::multi_aff(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::multi_aff>{}, bool>::type = true>
  multi_aff(const base &obj) : isl::multi_aff(obj) {}
 public:
  static multi_aff from(const isl::multi_aff &obj) {
    return multi_aff(obj);
  }
  inline /* implicit */ multi_aff(const typed::aff<Domain, pair<Range, Range2>> &aff);
  inline explicit multi_aff(const typed::space<Domain, pair<Range, Range2>> &space, const typed::aff_list<Domain, Anonymous> &list);
  inline explicit multi_aff(const isl::ctx &ctx, const std::string &str);
  inline typed::multi_aff<Domain, pair<Range, Range2>> add(const typed::multi_aff<Domain, pair<Range, Range2>> &multi2) const;
  inline typed::multi_pw_aff<Domain, pair<Range, Range2>> add(const typed::multi_pw_aff<Domain, pair<Range, Range2>> &multi2) const;
  inline typed::multi_union_pw_aff<Domain, pair<Range, Range2>> add(const typed::multi_union_pw_aff<Domain, pair<Range, Range2>> &multi2) const;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> add(const typed::pw_multi_aff<Domain, pair<Range, Range2>> &pma2) const;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> add(const typed::union_pw_multi_aff<Domain, pair<Range, Range2>> &upma2) const;
  inline typed::multi_aff<Domain, pair<Range, Range2>> add(const typed::aff<Domain, pair<Range, Range2>> &multi2) const;
  inline typed::multi_aff<Domain, pair<Range, Range2>> add_constant(const typed::multi_val<pair<Range, Range2>> &mv) const;
  inline typed::multi_aff<Domain, pair<Range, Range2>> add_constant(const typed::val<pair<Range, Range2>> &v) const;
  inline typed::multi_aff<Domain, pair<Range, Range2>> add_constant(long v) const;
  template <typename Arg3>
  inline typed::union_pw_multi_aff<Domain, Arg3> apply(const typed::union_pw_multi_aff<pair<Range, Range2>, Arg3> &upma2) const;
  inline typed::map<Domain, pair<Range, Range2>> as_map() const;
  inline typed::multi_aff<Domain, pair<Range, Range2>> as_multi_aff() const;
  inline typed::multi_union_pw_aff<Domain, pair<Range, Range2>> as_multi_union_pw_aff() const;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> as_pw_multi_aff() const;
  inline typed::set<Domain, pair<Range, Range2>> as_set() const = delete;
  inline typed::union_map<Domain, pair<Range, Range2>> as_union_map() const;
  inline typed::aff<Domain, Anonymous> at(int pos) const;
  inline typed::aff<Domain, pair<Range, Range2>> get_at(int pos) const = delete;
  inline typed::basic_set<Domain> bind(const typed::multi_id<pair<Range, Range2>> &tuple) const;
  inline typed::multi_aff<pair<Range, Range2>> bind_domain(const typed::multi_id<Domain> &tuple) const;
  inline typed::multi_aff<Domain, pair<Range, Range2>> bind_domain_wrapped_domain(const typed::multi_id<> &tuple) const = delete;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> coalesce() const;
  inline typed::multi_val<pair<Range, Range2>> constant_multi_val() const;
  inline typed::multi_val<Domain, pair<Range, Range2>> get_constant_multi_val() const = delete;
  inline typed::set<Domain> domain() const;
  inline typed::multi_aff<Domain, pair<Range, Range2>> domain_reverse() const = delete;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> drop_unused_params() const;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> extract_pw_multi_aff(const typed::space<Domain, pair<Range, Range2>> &space) const;
  inline typed::multi_aff<Domain, pair<Range, Range2>> floor() const;
  inline typed::multi_aff<Domain, pair<Range, Range2>> gist(const typed::set<Domain> &context) const;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> gist(const typed::union_set<Domain> &context) const;
  inline typed::multi_aff<Domain, pair<Range, Range2>> gist(const typed::basic_set<Domain> &context) const;
  inline typed::multi_aff<Domain, pair<Range, Range2>> gist(const typed::point<Domain> &context) const;
  inline typed::multi_aff<Domain, pair<Range, Range2>> gist_params(const typed::set<> &context) const;
  inline typed::multi_aff<Domain, pair<Range, Range2>> gist_params(const typed::basic_set<> &context) const;
  inline typed::multi_aff<Domain, pair<Range, Range2>> gist_params(const typed::point<> &context) const;
  inline typed::multi_aff<Domain, pair<Range, Range2>> identity() const;
  inline typed::multi_aff<Domain, pair<Range, Range2>> insert_domain(const typed::space<> &domain) const = delete;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> intersect_domain(const typed::set<Domain> &set) const;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> intersect_domain(const typed::space<Domain> &space) const;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> intersect_domain(const typed::union_set<Domain> &uset) const;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> intersect_domain_wrapped_domain(const typed::union_set<> &uset) const = delete;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> intersect_params(const typed::set<> &set) const;
  inline typed::aff_list<Domain, Anonymous> list() const;
  inline typed::aff_list<Domain, pair<Range, Range2>> get_list() const = delete;
  inline typed::multi_pw_aff<Domain, pair<Range, Range2>> max(const typed::multi_pw_aff<Domain, pair<Range, Range2>> &multi2) const;
  inline typed::multi_val<pair<Range, Range2>> max_multi_val() const;
  inline typed::multi_pw_aff<Domain, pair<Range, Range2>> min(const typed::multi_pw_aff<Domain, pair<Range, Range2>> &multi2) const;
  inline typed::multi_val<pair<Range, Range2>> min_multi_val() const;
  inline typed::multi_aff<Domain, pair<Range, Range2>> neg() const;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> preimage_domain_wrapped_domain(const typed::pw_multi_aff<> &pma2) const = delete;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> preimage_domain_wrapped_domain(const typed::union_pw_multi_aff<> &upma2) const = delete;
  template <typename Domain2, typename Arg3>
  inline typed::multi_aff<pair<Domain, Domain2>, pair<pair<Range, Range2>, Arg3>> product(const typed::multi_aff<Domain2, Arg3> &multi2) const;
  template <typename Domain2, typename Arg3>
  inline typed::multi_pw_aff<pair<Domain, Domain2>, pair<pair<Range, Range2>, Arg3>> product(const typed::multi_pw_aff<Domain2, Arg3> &multi2) const;
  template <typename Domain2, typename Arg3>
  inline typed::pw_multi_aff<pair<Domain, Domain2>, pair<pair<Range, Range2>, Arg3>> product(const typed::pw_multi_aff<Domain2, Arg3> &pma2) const;
  template <typename Domain2>
  inline typed::multi_aff<pair<Domain, Domain2>, pair<pair<Range, Range2>, Anonymous>> product(const typed::aff<Domain2, Anonymous> &multi2) const;
  template <typename Domain2>
  inline typed::multi_aff<Domain2, pair<Range, Range2>> pullback(const typed::multi_aff<Domain2, Domain> &ma2) const;
  inline typed::multi_aff<pair<Range, Range2>> pullback(const typed::multi_aff<Domain> &ma2) const;
  template <typename Domain2>
  inline typed::multi_pw_aff<Domain2, pair<Range, Range2>> pullback(const typed::multi_pw_aff<Domain2, Domain> &mpa2) const;
  inline typed::multi_pw_aff<pair<Range, Range2>> pullback(const typed::multi_pw_aff<Domain> &mpa2) const;
  template <typename Domain2>
  inline typed::pw_multi_aff<Domain2, pair<Range, Range2>> pullback(const typed::pw_multi_aff<Domain2, Domain> &pma2) const;
  inline typed::pw_multi_aff<pair<Range, Range2>> pullback(const typed::pw_multi_aff<Domain> &pma2) const;
  template <typename Domain2>
  inline typed::union_pw_multi_aff<Domain2, pair<Range, Range2>> pullback(const typed::union_pw_multi_aff<Domain2, Domain> &upma2) const;
  inline typed::union_pw_multi_aff<pair<Range, Range2>> pullback(const typed::union_pw_multi_aff<Domain> &upma2) const;
  template <typename Domain2>
  inline typed::multi_aff<Domain2, pair<Range, Range2>> pullback(const typed::aff<Domain2, Domain> &ma2) const;
  inline typed::multi_aff<pair<Range, Range2>> pullback(const typed::aff<Domain> &ma2) const;
  inline typed::pw_multi_aff_list<Domain, pair<Range, Range2>> pw_multi_aff_list() const;
  inline typed::pw_multi_aff<Domain, Range> range_factor_domain() const;
  inline typed::pw_multi_aff<Domain, Range2> range_factor_range() const;
  template <typename Arg3>
  inline typed::multi_aff<Domain, pair<pair<Range, Range2>, Arg3>> range_product(const typed::multi_aff<Domain, Arg3> &multi2) const;
  template <typename Arg3>
  inline typed::multi_pw_aff<Domain, pair<pair<Range, Range2>, Arg3>> range_product(const typed::multi_pw_aff<Domain, Arg3> &multi2) const;
  template <typename Arg3>
  inline typed::multi_union_pw_aff<Domain, pair<pair<Range, Range2>, Arg3>> range_product(const typed::multi_union_pw_aff<Domain, Arg3> &multi2) const;
  template <typename Arg3>
  inline typed::pw_multi_aff<Domain, pair<pair<Range, Range2>, Arg3>> range_product(const typed::pw_multi_aff<Domain, Arg3> &pma2) const;
  template <typename Arg3>
  inline typed::union_pw_multi_aff<Domain, pair<pair<Range, Range2>, Arg3>> range_product(const typed::union_pw_multi_aff<Domain, Arg3> &upma2) const;
  inline typed::multi_aff<Domain, pair<pair<Range, Range2>, Anonymous>> range_product(const typed::aff<Domain, Anonymous> &multi2) const;
  inline typed::id<Domain, pair<Range, Range2>> get_range_tuple_id() const = delete;
  inline typed::multi_aff<Domain, pair<Range, Range2>> scale(const typed::multi_val<pair<Range, Range2>> &mv) const;
  inline typed::multi_aff<Domain, pair<Range, Range2>> scale(const typed::val<pair<Range, Range2>> &v) const;
  inline typed::multi_aff<Domain, pair<Range, Range2>> scale(long v) const;
  inline typed::multi_aff<Domain, pair<Range, Range2>> scale_down(const typed::multi_val<pair<Range, Range2>> &mv) const;
  inline typed::multi_aff<Domain, pair<Range, Range2>> scale_down(const typed::val<pair<Range, Range2>> &v) const;
  inline typed::multi_aff<Domain, pair<Range, Range2>> scale_down(long v) const;
  inline typed::multi_aff<Domain, pair<Range, Range2>> set_at(int pos, const typed::aff<Domain, Anonymous> &el) const;
  inline typed::multi_pw_aff<Domain, pair<Range, Range2>> set_at(int pos, const typed::pw_aff<Domain, Anonymous> &el) const;
  inline typed::multi_union_pw_aff<Domain, pair<Range, Range2>> set_at(int pos, const typed::union_pw_aff<Domain, Anonymous> &el) const;
  inline typed::multi_aff<Domain, pair<Range, Range2>> set_range_tuple(const typed::id<> &id) const = delete;
  inline typed::multi_aff<Domain, pair<Range, Range2>> set_range_tuple(const std::string &id) const = delete;
  inline typed::space<Domain, pair<Range, Range2>> space() const;
  inline typed::space<Domain, pair<Range, Range2>> get_space() const = delete;
  inline typed::multi_aff<Domain, pair<Range, Range2>> sub(const typed::multi_aff<Domain, pair<Range, Range2>> &multi2) const;
  inline typed::multi_pw_aff<Domain, pair<Range, Range2>> sub(const typed::multi_pw_aff<Domain, pair<Range, Range2>> &multi2) const;
  inline typed::multi_union_pw_aff<Domain, pair<Range, Range2>> sub(const typed::multi_union_pw_aff<Domain, pair<Range, Range2>> &multi2) const;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> sub(const typed::pw_multi_aff<Domain, pair<Range, Range2>> &pma2) const;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> sub(const typed::union_pw_multi_aff<Domain, pair<Range, Range2>> &upma2) const;
  inline typed::multi_aff<Domain, pair<Range, Range2>> sub(const typed::aff<Domain, pair<Range, Range2>> &multi2) const;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> subtract_domain(const typed::set<Domain> &set) const;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> subtract_domain(const typed::space<Domain> &space) const;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> subtract_domain(const typed::union_set<Domain> &uset) const;
  inline typed::multi_pw_aff<Domain, pair<Range, Range2>> to_multi_pw_aff() const;
  inline typed::multi_union_pw_aff<Domain, pair<Range, Range2>> to_multi_union_pw_aff() const;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> to_pw_multi_aff() const;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> to_union_pw_multi_aff() const;
  inline typed::multi_aff<Domain, pair<Range, Range2>> unbind_params_insert_domain(const typed::multi_id<> &domain) const = delete;
  inline typed::multi_pw_aff<Domain, pair<Range, Range2>> union_add(const typed::multi_pw_aff<Domain, pair<Range, Range2>> &mpa2) const;
  inline typed::multi_union_pw_aff<Domain, pair<Range, Range2>> union_add(const typed::multi_union_pw_aff<Domain, pair<Range, Range2>> &mupa2) const;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> union_add(const typed::pw_multi_aff<Domain, pair<Range, Range2>> &pma2) const;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> union_add(const typed::union_pw_multi_aff<Domain, pair<Range, Range2>> &upma2) const;
};

template <typename T1, typename T2, typename Range, typename Range2>
struct multi_aff<pair<T1, T2>, pair<Range, Range2>> : public isl::multi_aff {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  multi_aff() = default;
  template <typename Arg1, typename Arg2, typename Arg3, typename Arg4,
            typename std::enable_if<
              std::is_base_of<T1, Arg1>{} &&
              std::is_base_of<T2, Arg2>{} &&
              std::is_base_of<Range, Arg3>{} &&
              std::is_base_of<Range2, Arg4>{},
            bool>::type = true>
  multi_aff(const multi_aff<pair<Arg1, Arg2>, pair<Arg3, Arg4>> &obj) : isl::multi_aff(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::multi_aff>{}, bool>::type = true>
  multi_aff(const base &obj) : isl::multi_aff(obj) {}
 public:
  static multi_aff from(const isl::multi_aff &obj) {
    return multi_aff(obj);
  }
  inline /* implicit */ multi_aff(const typed::aff<pair<T1, T2>, pair<Range, Range2>> &aff);
  inline explicit multi_aff(const typed::space<pair<T1, T2>, pair<Range, Range2>> &space, const typed::aff_list<pair<T1, T2>, Anonymous> &list);
  inline explicit multi_aff(const isl::ctx &ctx, const std::string &str);
  inline typed::multi_aff<pair<T1, T2>, pair<Range, Range2>> add(const typed::multi_aff<pair<T1, T2>, pair<Range, Range2>> &multi2) const;
  inline typed::multi_pw_aff<pair<T1, T2>, pair<Range, Range2>> add(const typed::multi_pw_aff<pair<T1, T2>, pair<Range, Range2>> &multi2) const;
  inline typed::multi_union_pw_aff<pair<T1, T2>, pair<Range, Range2>> add(const typed::multi_union_pw_aff<pair<T1, T2>, pair<Range, Range2>> &multi2) const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> add(const typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> &pma2) const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> add(const typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> &upma2) const;
  inline typed::multi_aff<pair<T1, T2>, pair<Range, Range2>> add(const typed::aff<pair<T1, T2>, pair<Range, Range2>> &multi2) const;
  inline typed::multi_aff<pair<T1, T2>, pair<Range, Range2>> add_constant(const typed::multi_val<pair<Range, Range2>> &mv) const;
  inline typed::multi_aff<pair<T1, T2>, pair<Range, Range2>> add_constant(const typed::val<pair<Range, Range2>> &v) const;
  inline typed::multi_aff<pair<T1, T2>, pair<Range, Range2>> add_constant(long v) const;
  template <typename Arg2>
  inline typed::union_pw_multi_aff<pair<T1, T2>, Arg2> apply(const typed::union_pw_multi_aff<pair<Range, Range2>, Arg2> &upma2) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> as_map() const;
  inline typed::multi_aff<pair<T1, T2>, pair<Range, Range2>> as_multi_aff() const;
  inline typed::multi_union_pw_aff<pair<T1, T2>, pair<Range, Range2>> as_multi_union_pw_aff() const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> as_pw_multi_aff() const;
  inline typed::set<pair<T1, T2>, pair<Range, Range2>> as_set() const = delete;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> as_union_map() const;
  inline typed::aff<pair<T1, T2>, Anonymous> at(int pos) const;
  inline typed::aff<pair<T1, T2>, pair<Range, Range2>> get_at(int pos) const = delete;
  inline typed::basic_set<pair<T1, T2>> bind(const typed::multi_id<pair<Range, Range2>> &tuple) const;
  inline typed::multi_aff<pair<Range, Range2>> bind_domain(const typed::multi_id<pair<T1, T2>> &tuple) const;
  inline typed::multi_aff<T2, pair<Range, Range2>> bind_domain_wrapped_domain(const typed::multi_id<T1> &tuple) const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> coalesce() const;
  inline typed::multi_val<pair<Range, Range2>> constant_multi_val() const;
  inline typed::multi_val<pair<T1, T2>, pair<Range, Range2>> get_constant_multi_val() const = delete;
  inline typed::set<pair<T1, T2>> domain() const;
  inline typed::multi_aff<pair<T2, T1>, pair<Range, Range2>> domain_reverse() const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> drop_unused_params() const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> extract_pw_multi_aff(const typed::space<pair<T1, T2>, pair<Range, Range2>> &space) const;
  inline typed::multi_aff<pair<T1, T2>, pair<Range, Range2>> floor() const;
  inline typed::multi_aff<pair<T1, T2>, pair<Range, Range2>> gist(const typed::set<pair<T1, T2>> &context) const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> gist(const typed::union_set<pair<T1, T2>> &context) const;
  inline typed::multi_aff<pair<T1, T2>, pair<Range, Range2>> gist(const typed::basic_set<pair<T1, T2>> &context) const;
  inline typed::multi_aff<pair<T1, T2>, pair<Range, Range2>> gist(const typed::point<pair<T1, T2>> &context) const;
  inline typed::multi_aff<pair<T1, T2>, pair<Range, Range2>> gist_params(const typed::set<> &context) const;
  inline typed::multi_aff<pair<T1, T2>, pair<Range, Range2>> gist_params(const typed::basic_set<> &context) const;
  inline typed::multi_aff<pair<T1, T2>, pair<Range, Range2>> gist_params(const typed::point<> &context) const;
  inline typed::multi_aff<pair<T1, T2>, pair<Range, Range2>> identity() const;
  inline typed::multi_aff<pair<T1, T2>, pair<Range, Range2>> insert_domain(const typed::space<> &domain) const = delete;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> intersect_domain(const typed::set<pair<T1, T2>> &set) const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> intersect_domain(const typed::space<pair<T1, T2>> &space) const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> intersect_domain(const typed::union_set<pair<T1, T2>> &uset) const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> intersect_domain_wrapped_domain(const typed::union_set<T1> &uset) const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> intersect_params(const typed::set<> &set) const;
  inline typed::aff_list<pair<T1, T2>, Anonymous> list() const;
  inline typed::aff_list<pair<T1, T2>, pair<Range, Range2>> get_list() const = delete;
  inline typed::multi_pw_aff<pair<T1, T2>, pair<Range, Range2>> max(const typed::multi_pw_aff<pair<T1, T2>, pair<Range, Range2>> &multi2) const;
  inline typed::multi_val<pair<Range, Range2>> max_multi_val() const;
  inline typed::multi_pw_aff<pair<T1, T2>, pair<Range, Range2>> min(const typed::multi_pw_aff<pair<T1, T2>, pair<Range, Range2>> &multi2) const;
  inline typed::multi_val<pair<Range, Range2>> min_multi_val() const;
  inline typed::multi_aff<pair<T1, T2>, pair<Range, Range2>> neg() const;
  template <typename Domain3>
  inline typed::pw_multi_aff<pair<Domain3, T2>, pair<Range, Range2>> preimage_domain_wrapped_domain(const typed::pw_multi_aff<Domain3, T1> &pma2) const;
  template <typename Domain3>
  inline typed::union_pw_multi_aff<pair<Domain3, T2>, pair<Range, Range2>> preimage_domain_wrapped_domain(const typed::union_pw_multi_aff<Domain3, T1> &upma2) const;
  template <typename Domain2, typename Arg2>
  inline typed::multi_aff<pair<pair<T1, T2>, Domain2>, pair<pair<Range, Range2>, Arg2>> product(const typed::multi_aff<Domain2, Arg2> &multi2) const;
  template <typename Domain2, typename Arg2>
  inline typed::multi_pw_aff<pair<pair<T1, T2>, Domain2>, pair<pair<Range, Range2>, Arg2>> product(const typed::multi_pw_aff<Domain2, Arg2> &multi2) const;
  template <typename Domain2, typename Arg2>
  inline typed::pw_multi_aff<pair<pair<T1, T2>, Domain2>, pair<pair<Range, Range2>, Arg2>> product(const typed::pw_multi_aff<Domain2, Arg2> &pma2) const;
  template <typename Domain2>
  inline typed::multi_aff<pair<pair<T1, T2>, Domain2>, pair<pair<Range, Range2>, Anonymous>> product(const typed::aff<Domain2, Anonymous> &multi2) const;
  template <typename Domain2>
  inline typed::multi_aff<Domain2, pair<Range, Range2>> pullback(const typed::multi_aff<Domain2, pair<T1, T2>> &ma2) const;
  inline typed::multi_aff<pair<Range, Range2>> pullback(const typed::multi_aff<pair<T1, T2>> &ma2) const;
  template <typename Domain2>
  inline typed::multi_pw_aff<Domain2, pair<Range, Range2>> pullback(const typed::multi_pw_aff<Domain2, pair<T1, T2>> &mpa2) const;
  inline typed::multi_pw_aff<pair<Range, Range2>> pullback(const typed::multi_pw_aff<pair<T1, T2>> &mpa2) const;
  template <typename Domain2>
  inline typed::pw_multi_aff<Domain2, pair<Range, Range2>> pullback(const typed::pw_multi_aff<Domain2, pair<T1, T2>> &pma2) const;
  inline typed::pw_multi_aff<pair<Range, Range2>> pullback(const typed::pw_multi_aff<pair<T1, T2>> &pma2) const;
  template <typename Domain2>
  inline typed::union_pw_multi_aff<Domain2, pair<Range, Range2>> pullback(const typed::union_pw_multi_aff<Domain2, pair<T1, T2>> &upma2) const;
  inline typed::union_pw_multi_aff<pair<Range, Range2>> pullback(const typed::union_pw_multi_aff<pair<T1, T2>> &upma2) const;
  template <typename Domain2>
  inline typed::multi_aff<Domain2, pair<Range, Range2>> pullback(const typed::aff<Domain2, pair<T1, T2>> &ma2) const;
  inline typed::multi_aff<pair<Range, Range2>> pullback(const typed::aff<pair<T1, T2>> &ma2) const;
  inline typed::pw_multi_aff_list<pair<T1, T2>, pair<Range, Range2>> pw_multi_aff_list() const;
  inline typed::pw_multi_aff<pair<T1, T2>, Range> range_factor_domain() const;
  inline typed::pw_multi_aff<pair<T1, T2>, Range2> range_factor_range() const;
  template <typename Arg2>
  inline typed::multi_aff<pair<T1, T2>, pair<pair<Range, Range2>, Arg2>> range_product(const typed::multi_aff<pair<T1, T2>, Arg2> &multi2) const;
  template <typename Arg2>
  inline typed::multi_pw_aff<pair<T1, T2>, pair<pair<Range, Range2>, Arg2>> range_product(const typed::multi_pw_aff<pair<T1, T2>, Arg2> &multi2) const;
  template <typename Arg2>
  inline typed::multi_union_pw_aff<pair<T1, T2>, pair<pair<Range, Range2>, Arg2>> range_product(const typed::multi_union_pw_aff<pair<T1, T2>, Arg2> &multi2) const;
  template <typename Arg2>
  inline typed::pw_multi_aff<pair<T1, T2>, pair<pair<Range, Range2>, Arg2>> range_product(const typed::pw_multi_aff<pair<T1, T2>, Arg2> &pma2) const;
  template <typename Arg2>
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<pair<Range, Range2>, Arg2>> range_product(const typed::union_pw_multi_aff<pair<T1, T2>, Arg2> &upma2) const;
  inline typed::multi_aff<pair<T1, T2>, pair<pair<Range, Range2>, Anonymous>> range_product(const typed::aff<pair<T1, T2>, Anonymous> &multi2) const;
  inline typed::id<pair<T1, T2>, pair<Range, Range2>> get_range_tuple_id() const = delete;
  inline typed::multi_aff<pair<T1, T2>, pair<Range, Range2>> scale(const typed::multi_val<pair<Range, Range2>> &mv) const;
  inline typed::multi_aff<pair<T1, T2>, pair<Range, Range2>> scale(const typed::val<pair<Range, Range2>> &v) const;
  inline typed::multi_aff<pair<T1, T2>, pair<Range, Range2>> scale(long v) const;
  inline typed::multi_aff<pair<T1, T2>, pair<Range, Range2>> scale_down(const typed::multi_val<pair<Range, Range2>> &mv) const;
  inline typed::multi_aff<pair<T1, T2>, pair<Range, Range2>> scale_down(const typed::val<pair<Range, Range2>> &v) const;
  inline typed::multi_aff<pair<T1, T2>, pair<Range, Range2>> scale_down(long v) const;
  inline typed::multi_aff<pair<T1, T2>, pair<Range, Range2>> set_at(int pos, const typed::aff<pair<T1, T2>, Anonymous> &el) const;
  inline typed::multi_pw_aff<pair<T1, T2>, pair<Range, Range2>> set_at(int pos, const typed::pw_aff<pair<T1, T2>, Anonymous> &el) const;
  inline typed::multi_union_pw_aff<pair<T1, T2>, pair<Range, Range2>> set_at(int pos, const typed::union_pw_aff<pair<T1, T2>, Anonymous> &el) const;
  inline typed::multi_aff<pair<T1, T2>, pair<Range, Range2>> set_range_tuple(const typed::id<> &id) const = delete;
  inline typed::multi_aff<pair<T1, T2>, pair<Range, Range2>> set_range_tuple(const std::string &id) const = delete;
  inline typed::space<pair<T1, T2>, pair<Range, Range2>> space() const;
  inline typed::space<pair<T1, T2>, pair<Range, Range2>> get_space() const = delete;
  inline typed::multi_aff<pair<T1, T2>, pair<Range, Range2>> sub(const typed::multi_aff<pair<T1, T2>, pair<Range, Range2>> &multi2) const;
  inline typed::multi_pw_aff<pair<T1, T2>, pair<Range, Range2>> sub(const typed::multi_pw_aff<pair<T1, T2>, pair<Range, Range2>> &multi2) const;
  inline typed::multi_union_pw_aff<pair<T1, T2>, pair<Range, Range2>> sub(const typed::multi_union_pw_aff<pair<T1, T2>, pair<Range, Range2>> &multi2) const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> sub(const typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> &pma2) const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> sub(const typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> &upma2) const;
  inline typed::multi_aff<pair<T1, T2>, pair<Range, Range2>> sub(const typed::aff<pair<T1, T2>, pair<Range, Range2>> &multi2) const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> subtract_domain(const typed::set<pair<T1, T2>> &set) const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> subtract_domain(const typed::space<pair<T1, T2>> &space) const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> subtract_domain(const typed::union_set<pair<T1, T2>> &uset) const;
  inline typed::multi_pw_aff<pair<T1, T2>, pair<Range, Range2>> to_multi_pw_aff() const;
  inline typed::multi_union_pw_aff<pair<T1, T2>, pair<Range, Range2>> to_multi_union_pw_aff() const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> to_pw_multi_aff() const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> to_union_pw_multi_aff() const;
  inline typed::multi_aff<pair<T1, T2>, pair<Range, Range2>> unbind_params_insert_domain(const typed::multi_id<> &domain) const = delete;
  inline typed::multi_pw_aff<pair<T1, T2>, pair<Range, Range2>> union_add(const typed::multi_pw_aff<pair<T1, T2>, pair<Range, Range2>> &mpa2) const;
  inline typed::multi_union_pw_aff<pair<T1, T2>, pair<Range, Range2>> union_add(const typed::multi_union_pw_aff<pair<T1, T2>, pair<Range, Range2>> &mupa2) const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> union_add(const typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> &pma2) const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> union_add(const typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> &upma2) const;
};

template <typename Domain>
struct multi_id<Domain> : public isl::multi_id {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  multi_id() = default;
  template <typename Arg1,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{},
            bool>::type = true>
  multi_id(const multi_id<Arg1> &obj) : isl::multi_id(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::multi_id>{}, bool>::type = true>
  multi_id(const base &obj) : isl::multi_id(obj) {}
 public:
  static multi_id from(const isl::multi_id &obj) {
    return multi_id(obj);
  }
  inline explicit multi_id(const typed::space<Domain> &space, const typed::id_list<Anonymous> &list);
  inline explicit multi_id(const isl::ctx &ctx, const std::string &str);
  inline typed::id<Anonymous> at(int pos) const;
  inline typed::id<Domain> get_at(int pos) const = delete;
  inline typed::id_list<Anonymous> list() const;
  inline typed::id_list<Domain> get_list() const = delete;
  inline typed::multi_id<Domain> range_product(const typed::multi_id<> &multi2) const = delete;
  inline typed::multi_id<Domain> set_at(int pos, const typed::id<Anonymous> &el) const;
  inline typed::multi_id<Domain> set_at(int pos, const std::string &el) const;
  inline typed::space<Domain> space() const;
  inline typed::space<Domain> get_space() const = delete;
};

template <typename Domain>
struct multi_pw_aff<Domain> : public isl::multi_pw_aff {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  multi_pw_aff() = default;
  template <typename Arg1,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{},
            bool>::type = true>
  multi_pw_aff(const multi_pw_aff<Arg1> &obj) : isl::multi_pw_aff(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::multi_pw_aff>{}, bool>::type = true>
  multi_pw_aff(const base &obj) : isl::multi_pw_aff(obj) {}
 public:
  static multi_pw_aff from(const isl::multi_pw_aff &obj) {
    return multi_pw_aff(obj);
  }
  inline /* implicit */ multi_pw_aff(const typed::aff<Domain> &aff);
  inline /* implicit */ multi_pw_aff(const typed::multi_aff<Domain> &ma);
  inline /* implicit */ multi_pw_aff(const typed::pw_aff<Domain> &pa);
  inline explicit multi_pw_aff(const typed::space<Domain> &space, const typed::pw_aff_list<Anonymous> &list);
  inline /* implicit */ multi_pw_aff(const typed::pw_multi_aff<Domain> &pma);
  inline explicit multi_pw_aff(const isl::ctx &ctx, const std::string &str);
  inline typed::multi_pw_aff<Domain> add(const typed::multi_pw_aff<Domain> &multi2) const;
  inline typed::multi_union_pw_aff<Domain> add(const typed::multi_union_pw_aff<Domain> &multi2) const;
  inline typed::multi_pw_aff<Domain> add(const typed::aff<Domain> &multi2) const;
  inline typed::multi_pw_aff<Domain> add(const typed::multi_aff<Domain> &multi2) const;
  inline typed::multi_pw_aff<Domain> add(const typed::pw_aff<Domain> &multi2) const;
  inline typed::multi_pw_aff<Domain> add(const typed::pw_multi_aff<Domain> &multi2) const;
  inline typed::multi_pw_aff<Domain> add_constant(const typed::multi_val<Domain> &mv) const;
  inline typed::multi_pw_aff<Domain> add_constant(const typed::val<Domain> &v) const;
  inline typed::multi_pw_aff<Domain> add_constant(long v) const;
  inline typed::map<Domain> as_map() const = delete;
  inline typed::multi_aff<Domain> as_multi_aff() const;
  inline typed::set<Domain> as_set() const;
  inline typed::pw_aff<Anonymous> at(int pos) const;
  inline typed::pw_aff<Domain> get_at(int pos) const = delete;
  inline typed::set<> bind(const typed::multi_id<Domain> &tuple) const;
  inline typed::multi_pw_aff<Domain> bind_domain(const typed::multi_id<> &tuple) const = delete;
  inline typed::multi_pw_aff<Domain> bind_domain_wrapped_domain(const typed::multi_id<> &tuple) const = delete;
  inline typed::multi_pw_aff<Domain> coalesce() const;
  inline typed::set<> domain() const;
  inline typed::multi_pw_aff<Domain> domain_reverse() const = delete;
  inline typed::multi_pw_aff<Domain> gist(const typed::set<> &set) const;
  inline typed::multi_union_pw_aff<Domain> gist(const typed::union_set<> &context) const;
  inline typed::multi_pw_aff<Domain> gist(const typed::basic_set<> &set) const;
  inline typed::multi_pw_aff<Domain> gist(const typed::point<> &set) const;
  inline typed::multi_pw_aff<Domain> gist_params(const typed::set<> &set) const;
  inline typed::multi_pw_aff<Domain> gist_params(const typed::basic_set<> &set) const;
  inline typed::multi_pw_aff<Domain> gist_params(const typed::point<> &set) const;
  inline typed::multi_pw_aff<Domain, Domain> identity() const;
  template <typename Arg1>
  inline typed::multi_pw_aff<Arg1, Domain> insert_domain(const typed::space<Arg1> &domain) const;
  inline typed::multi_pw_aff<Domain> intersect_domain(const typed::set<> &domain) const = delete;
  inline typed::multi_union_pw_aff<Domain> intersect_domain(const typed::union_set<> &uset) const = delete;
  inline typed::multi_pw_aff<Domain> intersect_domain(const typed::basic_set<> &domain) const = delete;
  inline typed::multi_pw_aff<Domain> intersect_domain(const typed::point<> &domain) const = delete;
  inline typed::multi_pw_aff<Domain> intersect_params(const typed::set<> &set) const;
  inline typed::multi_pw_aff<Domain> intersect_params(const typed::basic_set<> &set) const;
  inline typed::multi_pw_aff<Domain> intersect_params(const typed::point<> &set) const;
  inline typed::pw_aff_list<Anonymous> list() const;
  inline typed::pw_aff_list<Domain> get_list() const = delete;
  inline typed::multi_pw_aff<Domain> max(const typed::multi_pw_aff<Domain> &multi2) const;
  inline typed::multi_pw_aff<Domain> max(const typed::aff<Domain> &multi2) const;
  inline typed::multi_pw_aff<Domain> max(const typed::multi_aff<Domain> &multi2) const;
  inline typed::multi_pw_aff<Domain> max(const typed::pw_aff<Domain> &multi2) const;
  inline typed::multi_pw_aff<Domain> max(const typed::pw_multi_aff<Domain> &multi2) const;
  inline typed::multi_val<Domain> max_multi_val() const;
  inline typed::multi_pw_aff<Domain> min(const typed::multi_pw_aff<Domain> &multi2) const;
  inline typed::multi_pw_aff<Domain> min(const typed::aff<Domain> &multi2) const;
  inline typed::multi_pw_aff<Domain> min(const typed::multi_aff<Domain> &multi2) const;
  inline typed::multi_pw_aff<Domain> min(const typed::pw_aff<Domain> &multi2) const;
  inline typed::multi_pw_aff<Domain> min(const typed::pw_multi_aff<Domain> &multi2) const;
  inline typed::multi_val<Domain> min_multi_val() const;
  inline typed::multi_pw_aff<Domain> neg() const;
  template <typename Range>
  inline typed::multi_pw_aff<pair<Domain, Range>> product(const typed::multi_pw_aff<Range> &multi2) const;
  inline typed::multi_pw_aff<pair<Domain, Anonymous>> product(const typed::aff<Anonymous> &multi2) const;
  template <typename Range>
  inline typed::multi_pw_aff<pair<Domain, Range>> product(const typed::multi_aff<Range> &multi2) const;
  inline typed::multi_pw_aff<pair<Domain, Anonymous>> product(const typed::pw_aff<Anonymous> &multi2) const;
  template <typename Range>
  inline typed::multi_pw_aff<pair<Domain, Range>> product(const typed::pw_multi_aff<Range> &multi2) const;
  inline typed::multi_pw_aff<Domain> pullback(const typed::multi_aff<> &ma) const = delete;
  inline typed::multi_pw_aff<Domain> pullback(const typed::multi_pw_aff<> &mpa2) const = delete;
  inline typed::multi_pw_aff<Domain> pullback(const typed::pw_multi_aff<> &pma) const = delete;
  inline typed::multi_union_pw_aff<Domain> pullback(const typed::union_pw_multi_aff<> &upma) const = delete;
  inline typed::multi_pw_aff<Domain> range_product(const typed::multi_pw_aff<> &multi2) const = delete;
  inline typed::multi_union_pw_aff<Domain> range_product(const typed::multi_union_pw_aff<> &multi2) const = delete;
  inline typed::multi_pw_aff<Domain> range_product(const typed::aff<> &multi2) const = delete;
  inline typed::multi_pw_aff<Domain> range_product(const typed::multi_aff<> &multi2) const = delete;
  inline typed::multi_pw_aff<Domain> range_product(const typed::pw_aff<> &multi2) const = delete;
  inline typed::multi_pw_aff<Domain> range_product(const typed::pw_multi_aff<> &multi2) const = delete;
  inline typed::id<Domain> get_range_tuple_id() const = delete;
  inline typed::multi_pw_aff<Domain> scale(const typed::multi_val<Domain> &mv) const;
  inline typed::multi_pw_aff<Domain> scale(const typed::val<Domain> &v) const;
  inline typed::multi_pw_aff<Domain> scale(long v) const;
  inline typed::multi_pw_aff<Domain> scale_down(const typed::multi_val<Domain> &mv) const;
  inline typed::multi_pw_aff<Domain> scale_down(const typed::val<Domain> &v) const;
  inline typed::multi_pw_aff<Domain> scale_down(long v) const;
  inline typed::multi_pw_aff<Domain> set_at(int pos, const typed::pw_aff<Anonymous> &el) const;
  inline typed::multi_union_pw_aff<Domain> set_at(int pos, const typed::union_pw_aff<Anonymous> &el) const;
  template <typename Domain2>
  inline typed::multi_pw_aff<Domain2> set_range_tuple(const typed::id<Anonymous> &id) const;
  template <typename Domain2>
  inline typed::multi_pw_aff<Domain2> set_range_tuple(const std::string &id) const;
  inline typed::space<Domain> space() const;
  inline typed::space<Domain> get_space() const = delete;
  inline typed::multi_pw_aff<Domain> sub(const typed::multi_pw_aff<Domain> &multi2) const;
  inline typed::multi_union_pw_aff<Domain> sub(const typed::multi_union_pw_aff<Domain> &multi2) const;
  inline typed::multi_pw_aff<Domain> sub(const typed::aff<Domain> &multi2) const;
  inline typed::multi_pw_aff<Domain> sub(const typed::multi_aff<Domain> &multi2) const;
  inline typed::multi_pw_aff<Domain> sub(const typed::pw_aff<Domain> &multi2) const;
  inline typed::multi_pw_aff<Domain> sub(const typed::pw_multi_aff<Domain> &multi2) const;
  template <typename Arg1>
  inline typed::multi_pw_aff<Arg1, Domain> unbind_params_insert_domain(const typed::multi_id<Arg1> &domain) const;
  inline typed::multi_pw_aff<Domain> union_add(const typed::multi_pw_aff<Domain> &mpa2) const;
  inline typed::multi_union_pw_aff<Domain> union_add(const typed::multi_union_pw_aff<Domain> &mupa2) const;
  inline typed::multi_pw_aff<Domain> union_add(const typed::aff<Domain> &mpa2) const;
  inline typed::multi_pw_aff<Domain> union_add(const typed::multi_aff<Domain> &mpa2) const;
  inline typed::multi_pw_aff<Domain> union_add(const typed::pw_aff<Domain> &mpa2) const;
  inline typed::multi_pw_aff<Domain> union_add(const typed::pw_multi_aff<Domain> &mpa2) const;
};

template <typename Domain, typename Range>
struct multi_pw_aff<Domain, Range> : public isl::multi_pw_aff {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  multi_pw_aff() = default;
  template <typename Arg1, typename Arg2,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{} &&
              std::is_base_of<Range, Arg2>{},
            bool>::type = true>
  multi_pw_aff(const multi_pw_aff<Arg1, Arg2> &obj) : isl::multi_pw_aff(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::multi_pw_aff>{}, bool>::type = true>
  multi_pw_aff(const base &obj) : isl::multi_pw_aff(obj) {}
 public:
  static multi_pw_aff from(const isl::multi_pw_aff &obj) {
    return multi_pw_aff(obj);
  }
  inline /* implicit */ multi_pw_aff(const typed::aff<Domain, Range> &aff);
  inline /* implicit */ multi_pw_aff(const typed::multi_aff<Domain, Range> &ma);
  inline /* implicit */ multi_pw_aff(const typed::pw_aff<Domain, Range> &pa);
  inline explicit multi_pw_aff(const typed::space<Domain, Range> &space, const typed::pw_aff_list<Domain, Anonymous> &list);
  inline /* implicit */ multi_pw_aff(const typed::pw_multi_aff<Domain, Range> &pma);
  inline explicit multi_pw_aff(const isl::ctx &ctx, const std::string &str);
  inline typed::multi_pw_aff<Domain, Range> add(const typed::multi_pw_aff<Domain, Range> &multi2) const;
  inline typed::multi_union_pw_aff<Domain, Range> add(const typed::multi_union_pw_aff<Domain, Range> &multi2) const;
  inline typed::multi_pw_aff<Domain, Range> add(const typed::aff<Domain, Range> &multi2) const;
  inline typed::multi_pw_aff<Domain, Range> add(const typed::multi_aff<Domain, Range> &multi2) const;
  inline typed::multi_pw_aff<Domain, Range> add(const typed::pw_aff<Domain, Range> &multi2) const;
  inline typed::multi_pw_aff<Domain, Range> add(const typed::pw_multi_aff<Domain, Range> &multi2) const;
  inline typed::multi_pw_aff<Domain, Range> add_constant(const typed::multi_val<Range> &mv) const;
  inline typed::multi_pw_aff<Domain, Range> add_constant(const typed::val<Range> &v) const;
  inline typed::multi_pw_aff<Domain, Range> add_constant(long v) const;
  inline typed::map<Domain, Range> as_map() const;
  inline typed::multi_aff<Domain, Range> as_multi_aff() const;
  inline typed::set<Domain, Range> as_set() const = delete;
  inline typed::pw_aff<Domain, Anonymous> at(int pos) const;
  inline typed::pw_aff<Domain, Range> get_at(int pos) const = delete;
  inline typed::set<Domain> bind(const typed::multi_id<Range> &tuple) const;
  inline typed::multi_pw_aff<Range> bind_domain(const typed::multi_id<Domain> &tuple) const;
  inline typed::multi_pw_aff<Domain, Range> bind_domain_wrapped_domain(const typed::multi_id<> &tuple) const = delete;
  inline typed::multi_pw_aff<Domain, Range> coalesce() const;
  inline typed::set<Domain> domain() const;
  inline typed::multi_pw_aff<Domain, Range> domain_reverse() const = delete;
  inline typed::multi_pw_aff<Domain, Range> gist(const typed::set<Domain> &set) const;
  inline typed::multi_union_pw_aff<Domain, Range> gist(const typed::union_set<Domain> &context) const;
  inline typed::multi_pw_aff<Domain, Range> gist(const typed::basic_set<Domain> &set) const;
  inline typed::multi_pw_aff<Domain, Range> gist(const typed::point<Domain> &set) const;
  inline typed::multi_pw_aff<Domain, Range> gist_params(const typed::set<> &set) const;
  inline typed::multi_pw_aff<Domain, Range> gist_params(const typed::basic_set<> &set) const;
  inline typed::multi_pw_aff<Domain, Range> gist_params(const typed::point<> &set) const;
  inline typed::multi_pw_aff<Domain, Range> identity() const;
  inline typed::multi_pw_aff<Domain, Range> insert_domain(const typed::space<> &domain) const = delete;
  inline typed::multi_pw_aff<Domain, Range> intersect_domain(const typed::set<Domain> &domain) const;
  inline typed::multi_union_pw_aff<Domain, Range> intersect_domain(const typed::union_set<Domain> &uset) const;
  inline typed::multi_pw_aff<Domain, Range> intersect_domain(const typed::basic_set<Domain> &domain) const;
  inline typed::multi_pw_aff<Domain, Range> intersect_domain(const typed::point<Domain> &domain) const;
  inline typed::multi_pw_aff<Domain, Range> intersect_params(const typed::set<> &set) const;
  inline typed::multi_pw_aff<Domain, Range> intersect_params(const typed::basic_set<> &set) const;
  inline typed::multi_pw_aff<Domain, Range> intersect_params(const typed::point<> &set) const;
  inline typed::pw_aff_list<Domain, Anonymous> list() const;
  inline typed::pw_aff_list<Domain, Range> get_list() const = delete;
  inline typed::multi_pw_aff<Domain, Range> max(const typed::multi_pw_aff<Domain, Range> &multi2) const;
  inline typed::multi_pw_aff<Domain, Range> max(const typed::aff<Domain, Range> &multi2) const;
  inline typed::multi_pw_aff<Domain, Range> max(const typed::multi_aff<Domain, Range> &multi2) const;
  inline typed::multi_pw_aff<Domain, Range> max(const typed::pw_aff<Domain, Range> &multi2) const;
  inline typed::multi_pw_aff<Domain, Range> max(const typed::pw_multi_aff<Domain, Range> &multi2) const;
  inline typed::multi_val<Range> max_multi_val() const;
  inline typed::multi_pw_aff<Domain, Range> min(const typed::multi_pw_aff<Domain, Range> &multi2) const;
  inline typed::multi_pw_aff<Domain, Range> min(const typed::aff<Domain, Range> &multi2) const;
  inline typed::multi_pw_aff<Domain, Range> min(const typed::multi_aff<Domain, Range> &multi2) const;
  inline typed::multi_pw_aff<Domain, Range> min(const typed::pw_aff<Domain, Range> &multi2) const;
  inline typed::multi_pw_aff<Domain, Range> min(const typed::pw_multi_aff<Domain, Range> &multi2) const;
  inline typed::multi_val<Range> min_multi_val() const;
  inline typed::multi_pw_aff<Domain, Range> neg() const;
  template <typename Domain2, typename Range2>
  inline typed::multi_pw_aff<pair<Domain, Domain2>, pair<Range, Range2>> product(const typed::multi_pw_aff<Domain2, Range2> &multi2) const;
  template <typename Domain2>
  inline typed::multi_pw_aff<pair<Domain, Domain2>, pair<Range, Anonymous>> product(const typed::aff<Domain2, Anonymous> &multi2) const;
  template <typename Domain2, typename Range2>
  inline typed::multi_pw_aff<pair<Domain, Domain2>, pair<Range, Range2>> product(const typed::multi_aff<Domain2, Range2> &multi2) const;
  template <typename Domain2>
  inline typed::multi_pw_aff<pair<Domain, Domain2>, pair<Range, Anonymous>> product(const typed::pw_aff<Domain2, Anonymous> &multi2) const;
  template <typename Domain2, typename Range2>
  inline typed::multi_pw_aff<pair<Domain, Domain2>, pair<Range, Range2>> product(const typed::pw_multi_aff<Domain2, Range2> &multi2) const;
  template <typename Domain2>
  inline typed::multi_pw_aff<Domain2, Range> pullback(const typed::multi_aff<Domain2, Domain> &ma) const;
  inline typed::multi_pw_aff<Range> pullback(const typed::multi_aff<Domain> &ma) const;
  template <typename Domain2>
  inline typed::multi_pw_aff<Domain2, Range> pullback(const typed::multi_pw_aff<Domain2, Domain> &mpa2) const;
  inline typed::multi_pw_aff<Range> pullback(const typed::multi_pw_aff<Domain> &mpa2) const;
  template <typename Domain2>
  inline typed::multi_pw_aff<Domain2, Range> pullback(const typed::pw_multi_aff<Domain2, Domain> &pma) const;
  inline typed::multi_pw_aff<Range> pullback(const typed::pw_multi_aff<Domain> &pma) const;
  template <typename Domain2>
  inline typed::multi_union_pw_aff<Domain2, Range> pullback(const typed::union_pw_multi_aff<Domain2, Domain> &upma) const;
  inline typed::multi_union_pw_aff<Range> pullback(const typed::union_pw_multi_aff<Domain> &upma) const;
  template <typename Range2>
  inline typed::multi_pw_aff<Domain, pair<Range, Range2>> range_product(const typed::multi_pw_aff<Domain, Range2> &multi2) const;
  template <typename Range2>
  inline typed::multi_union_pw_aff<Domain, pair<Range, Range2>> range_product(const typed::multi_union_pw_aff<Domain, Range2> &multi2) const;
  inline typed::multi_pw_aff<Domain, pair<Range, Anonymous>> range_product(const typed::aff<Domain, Anonymous> &multi2) const;
  template <typename Range2>
  inline typed::multi_pw_aff<Domain, pair<Range, Range2>> range_product(const typed::multi_aff<Domain, Range2> &multi2) const;
  inline typed::multi_pw_aff<Domain, pair<Range, Anonymous>> range_product(const typed::pw_aff<Domain, Anonymous> &multi2) const;
  template <typename Range2>
  inline typed::multi_pw_aff<Domain, pair<Range, Range2>> range_product(const typed::pw_multi_aff<Domain, Range2> &multi2) const;
  inline typed::id<Domain, Range> get_range_tuple_id() const = delete;
  inline typed::multi_pw_aff<Domain, Range> scale(const typed::multi_val<Range> &mv) const;
  inline typed::multi_pw_aff<Domain, Range> scale(const typed::val<Range> &v) const;
  inline typed::multi_pw_aff<Domain, Range> scale(long v) const;
  inline typed::multi_pw_aff<Domain, Range> scale_down(const typed::multi_val<Range> &mv) const;
  inline typed::multi_pw_aff<Domain, Range> scale_down(const typed::val<Range> &v) const;
  inline typed::multi_pw_aff<Domain, Range> scale_down(long v) const;
  inline typed::multi_pw_aff<Domain, Range> set_at(int pos, const typed::pw_aff<Domain, Anonymous> &el) const;
  inline typed::multi_union_pw_aff<Domain, Range> set_at(int pos, const typed::union_pw_aff<Domain, Anonymous> &el) const;
  template <typename Range2>
  inline typed::multi_pw_aff<Domain, Range2> set_range_tuple(const typed::id<Anonymous> &id) const;
  template <typename Range2>
  inline typed::multi_pw_aff<Domain, Range2> set_range_tuple(const std::string &id) const;
  inline typed::space<Domain, Range> space() const;
  inline typed::space<Domain, Range> get_space() const = delete;
  inline typed::multi_pw_aff<Domain, Range> sub(const typed::multi_pw_aff<Domain, Range> &multi2) const;
  inline typed::multi_union_pw_aff<Domain, Range> sub(const typed::multi_union_pw_aff<Domain, Range> &multi2) const;
  inline typed::multi_pw_aff<Domain, Range> sub(const typed::aff<Domain, Range> &multi2) const;
  inline typed::multi_pw_aff<Domain, Range> sub(const typed::multi_aff<Domain, Range> &multi2) const;
  inline typed::multi_pw_aff<Domain, Range> sub(const typed::pw_aff<Domain, Range> &multi2) const;
  inline typed::multi_pw_aff<Domain, Range> sub(const typed::pw_multi_aff<Domain, Range> &multi2) const;
  inline typed::multi_pw_aff<Domain, Range> unbind_params_insert_domain(const typed::multi_id<> &domain) const = delete;
  inline typed::multi_pw_aff<Domain, Range> union_add(const typed::multi_pw_aff<Domain, Range> &mpa2) const;
  inline typed::multi_union_pw_aff<Domain, Range> union_add(const typed::multi_union_pw_aff<Domain, Range> &mupa2) const;
  inline typed::multi_pw_aff<Domain, Range> union_add(const typed::aff<Domain, Range> &mpa2) const;
  inline typed::multi_pw_aff<Domain, Range> union_add(const typed::multi_aff<Domain, Range> &mpa2) const;
  inline typed::multi_pw_aff<Domain, Range> union_add(const typed::pw_aff<Domain, Range> &mpa2) const;
  inline typed::multi_pw_aff<Domain, Range> union_add(const typed::pw_multi_aff<Domain, Range> &mpa2) const;
};

template <typename Domain2, typename Range2, typename Range>
struct multi_pw_aff<pair<Domain2, Range2>, Range> : public isl::multi_pw_aff {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  multi_pw_aff() = default;
  template <typename Arg1, typename Arg2, typename Arg3,
            typename std::enable_if<
              std::is_base_of<Domain2, Arg1>{} &&
              std::is_base_of<Range2, Arg2>{} &&
              std::is_base_of<Range, Arg3>{},
            bool>::type = true>
  multi_pw_aff(const multi_pw_aff<pair<Arg1, Arg2>, Arg3> &obj) : isl::multi_pw_aff(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::multi_pw_aff>{}, bool>::type = true>
  multi_pw_aff(const base &obj) : isl::multi_pw_aff(obj) {}
 public:
  static multi_pw_aff from(const isl::multi_pw_aff &obj) {
    return multi_pw_aff(obj);
  }
  inline /* implicit */ multi_pw_aff(const typed::aff<pair<Domain2, Range2>, Range> &aff);
  inline /* implicit */ multi_pw_aff(const typed::multi_aff<pair<Domain2, Range2>, Range> &ma);
  inline /* implicit */ multi_pw_aff(const typed::pw_aff<pair<Domain2, Range2>, Range> &pa);
  inline explicit multi_pw_aff(const typed::space<pair<Domain2, Range2>, Range> &space, const typed::pw_aff_list<pair<Domain2, Range2>, Anonymous> &list);
  inline /* implicit */ multi_pw_aff(const typed::pw_multi_aff<pair<Domain2, Range2>, Range> &pma);
  inline explicit multi_pw_aff(const isl::ctx &ctx, const std::string &str);
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> add(const typed::multi_pw_aff<pair<Domain2, Range2>, Range> &multi2) const;
  inline typed::multi_union_pw_aff<pair<Domain2, Range2>, Range> add(const typed::multi_union_pw_aff<pair<Domain2, Range2>, Range> &multi2) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> add(const typed::aff<pair<Domain2, Range2>, Range> &multi2) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> add(const typed::multi_aff<pair<Domain2, Range2>, Range> &multi2) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> add(const typed::pw_aff<pair<Domain2, Range2>, Range> &multi2) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> add(const typed::pw_multi_aff<pair<Domain2, Range2>, Range> &multi2) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> add_constant(const typed::multi_val<Range> &mv) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> add_constant(const typed::val<Range> &v) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> add_constant(long v) const;
  inline typed::map<pair<Domain2, Range2>, Range> as_map() const;
  inline typed::multi_aff<pair<Domain2, Range2>, Range> as_multi_aff() const;
  inline typed::set<pair<Domain2, Range2>, Range> as_set() const = delete;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> at(int pos) const;
  inline typed::pw_aff<pair<Domain2, Range2>, Range> get_at(int pos) const = delete;
  inline typed::set<pair<Domain2, Range2>> bind(const typed::multi_id<Range> &tuple) const;
  inline typed::multi_pw_aff<Range> bind_domain(const typed::multi_id<pair<Domain2, Range2>> &tuple) const;
  inline typed::multi_pw_aff<Range2, Range> bind_domain_wrapped_domain(const typed::multi_id<Domain2> &tuple) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> coalesce() const;
  inline typed::set<pair<Domain2, Range2>> domain() const;
  inline typed::multi_pw_aff<pair<Range2, Domain2>, Range> domain_reverse() const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> gist(const typed::set<pair<Domain2, Range2>> &set) const;
  inline typed::multi_union_pw_aff<pair<Domain2, Range2>, Range> gist(const typed::union_set<pair<Domain2, Range2>> &context) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> gist(const typed::basic_set<pair<Domain2, Range2>> &set) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> gist(const typed::point<pair<Domain2, Range2>> &set) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> gist_params(const typed::set<> &set) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> gist_params(const typed::basic_set<> &set) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> gist_params(const typed::point<> &set) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> identity() const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> insert_domain(const typed::space<> &domain) const = delete;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> intersect_domain(const typed::set<pair<Domain2, Range2>> &domain) const;
  inline typed::multi_union_pw_aff<pair<Domain2, Range2>, Range> intersect_domain(const typed::union_set<pair<Domain2, Range2>> &uset) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> intersect_domain(const typed::basic_set<pair<Domain2, Range2>> &domain) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> intersect_domain(const typed::point<pair<Domain2, Range2>> &domain) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> intersect_params(const typed::set<> &set) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> intersect_params(const typed::basic_set<> &set) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> intersect_params(const typed::point<> &set) const;
  inline typed::pw_aff_list<pair<Domain2, Range2>, Anonymous> list() const;
  inline typed::pw_aff_list<pair<Domain2, Range2>, Range> get_list() const = delete;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> max(const typed::multi_pw_aff<pair<Domain2, Range2>, Range> &multi2) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> max(const typed::aff<pair<Domain2, Range2>, Range> &multi2) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> max(const typed::multi_aff<pair<Domain2, Range2>, Range> &multi2) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> max(const typed::pw_aff<pair<Domain2, Range2>, Range> &multi2) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> max(const typed::pw_multi_aff<pair<Domain2, Range2>, Range> &multi2) const;
  inline typed::multi_val<Range> max_multi_val() const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> min(const typed::multi_pw_aff<pair<Domain2, Range2>, Range> &multi2) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> min(const typed::aff<pair<Domain2, Range2>, Range> &multi2) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> min(const typed::multi_aff<pair<Domain2, Range2>, Range> &multi2) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> min(const typed::pw_aff<pair<Domain2, Range2>, Range> &multi2) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> min(const typed::pw_multi_aff<pair<Domain2, Range2>, Range> &multi2) const;
  inline typed::multi_val<Range> min_multi_val() const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> neg() const;
  template <typename Arg2, typename Arg3>
  inline typed::multi_pw_aff<pair<pair<Domain2, Range2>, Arg2>, pair<Range, Arg3>> product(const typed::multi_pw_aff<Arg2, Arg3> &multi2) const;
  template <typename Arg2>
  inline typed::multi_pw_aff<pair<pair<Domain2, Range2>, Arg2>, pair<Range, Anonymous>> product(const typed::aff<Arg2, Anonymous> &multi2) const;
  template <typename Arg2, typename Arg3>
  inline typed::multi_pw_aff<pair<pair<Domain2, Range2>, Arg2>, pair<Range, Arg3>> product(const typed::multi_aff<Arg2, Arg3> &multi2) const;
  template <typename Arg2>
  inline typed::multi_pw_aff<pair<pair<Domain2, Range2>, Arg2>, pair<Range, Anonymous>> product(const typed::pw_aff<Arg2, Anonymous> &multi2) const;
  template <typename Arg2, typename Arg3>
  inline typed::multi_pw_aff<pair<pair<Domain2, Range2>, Arg2>, pair<Range, Arg3>> product(const typed::pw_multi_aff<Arg2, Arg3> &multi2) const;
  template <typename Arg2>
  inline typed::multi_pw_aff<Arg2, Range> pullback(const typed::multi_aff<Arg2, pair<Domain2, Range2>> &ma) const;
  inline typed::multi_pw_aff<Range> pullback(const typed::multi_aff<pair<Domain2, Range2>> &ma) const;
  template <typename Arg2>
  inline typed::multi_pw_aff<Arg2, Range> pullback(const typed::multi_pw_aff<Arg2, pair<Domain2, Range2>> &mpa2) const;
  inline typed::multi_pw_aff<Range> pullback(const typed::multi_pw_aff<pair<Domain2, Range2>> &mpa2) const;
  template <typename Arg2>
  inline typed::multi_pw_aff<Arg2, Range> pullback(const typed::pw_multi_aff<Arg2, pair<Domain2, Range2>> &pma) const;
  inline typed::multi_pw_aff<Range> pullback(const typed::pw_multi_aff<pair<Domain2, Range2>> &pma) const;
  template <typename Arg2>
  inline typed::multi_union_pw_aff<Arg2, Range> pullback(const typed::union_pw_multi_aff<Arg2, pair<Domain2, Range2>> &upma) const;
  inline typed::multi_union_pw_aff<Range> pullback(const typed::union_pw_multi_aff<pair<Domain2, Range2>> &upma) const;
  template <typename Arg2>
  inline typed::multi_pw_aff<pair<Domain2, Range2>, pair<Range, Arg2>> range_product(const typed::multi_pw_aff<pair<Domain2, Range2>, Arg2> &multi2) const;
  template <typename Arg2>
  inline typed::multi_union_pw_aff<pair<Domain2, Range2>, pair<Range, Arg2>> range_product(const typed::multi_union_pw_aff<pair<Domain2, Range2>, Arg2> &multi2) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, pair<Range, Anonymous>> range_product(const typed::aff<pair<Domain2, Range2>, Anonymous> &multi2) const;
  template <typename Arg2>
  inline typed::multi_pw_aff<pair<Domain2, Range2>, pair<Range, Arg2>> range_product(const typed::multi_aff<pair<Domain2, Range2>, Arg2> &multi2) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, pair<Range, Anonymous>> range_product(const typed::pw_aff<pair<Domain2, Range2>, Anonymous> &multi2) const;
  template <typename Arg2>
  inline typed::multi_pw_aff<pair<Domain2, Range2>, pair<Range, Arg2>> range_product(const typed::pw_multi_aff<pair<Domain2, Range2>, Arg2> &multi2) const;
  inline typed::id<pair<Domain2, Range2>, Range> get_range_tuple_id() const = delete;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> scale(const typed::multi_val<Range> &mv) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> scale(const typed::val<Range> &v) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> scale(long v) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> scale_down(const typed::multi_val<Range> &mv) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> scale_down(const typed::val<Range> &v) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> scale_down(long v) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> set_at(int pos, const typed::pw_aff<pair<Domain2, Range2>, Anonymous> &el) const;
  inline typed::multi_union_pw_aff<pair<Domain2, Range2>, Range> set_at(int pos, const typed::union_pw_aff<pair<Domain2, Range2>, Anonymous> &el) const;
  template <typename Arg1>
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Arg1> set_range_tuple(const typed::id<Anonymous> &id) const;
  template <typename Arg1>
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Arg1> set_range_tuple(const std::string &id) const;
  inline typed::space<pair<Domain2, Range2>, Range> space() const;
  inline typed::space<pair<Domain2, Range2>, Range> get_space() const = delete;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> sub(const typed::multi_pw_aff<pair<Domain2, Range2>, Range> &multi2) const;
  inline typed::multi_union_pw_aff<pair<Domain2, Range2>, Range> sub(const typed::multi_union_pw_aff<pair<Domain2, Range2>, Range> &multi2) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> sub(const typed::aff<pair<Domain2, Range2>, Range> &multi2) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> sub(const typed::multi_aff<pair<Domain2, Range2>, Range> &multi2) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> sub(const typed::pw_aff<pair<Domain2, Range2>, Range> &multi2) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> sub(const typed::pw_multi_aff<pair<Domain2, Range2>, Range> &multi2) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> unbind_params_insert_domain(const typed::multi_id<> &domain) const = delete;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> union_add(const typed::multi_pw_aff<pair<Domain2, Range2>, Range> &mpa2) const;
  inline typed::multi_union_pw_aff<pair<Domain2, Range2>, Range> union_add(const typed::multi_union_pw_aff<pair<Domain2, Range2>, Range> &mupa2) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> union_add(const typed::aff<pair<Domain2, Range2>, Range> &mpa2) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> union_add(const typed::multi_aff<pair<Domain2, Range2>, Range> &mpa2) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> union_add(const typed::pw_aff<pair<Domain2, Range2>, Range> &mpa2) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> union_add(const typed::pw_multi_aff<pair<Domain2, Range2>, Range> &mpa2) const;
};

template <typename Domain>
struct multi_union_pw_aff<Domain> : public isl::multi_union_pw_aff {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  multi_union_pw_aff() = default;
  template <typename Arg1,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{},
            bool>::type = true>
  multi_union_pw_aff(const multi_union_pw_aff<Arg1> &obj) : isl::multi_union_pw_aff(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::multi_union_pw_aff>{}, bool>::type = true>
  multi_union_pw_aff(const base &obj) : isl::multi_union_pw_aff(obj) {}
 public:
  static multi_union_pw_aff from(const isl::multi_union_pw_aff &obj) {
    return multi_union_pw_aff(obj);
  }
  inline /* implicit */ multi_union_pw_aff(const typed::multi_pw_aff<Domain> &mpa);
  inline /* implicit */ multi_union_pw_aff(const typed::union_pw_aff<Domain> &upa);
  inline explicit multi_union_pw_aff(const typed::space<Domain> &space, const typed::union_pw_aff_list<Anonymous> &list);
  inline explicit multi_union_pw_aff(const isl::ctx &ctx, const std::string &str);
  inline typed::multi_union_pw_aff<Domain> add(const typed::multi_union_pw_aff<Domain> &multi2) const;
  inline typed::multi_union_pw_aff<Domain> add(const typed::multi_pw_aff<Domain> &multi2) const;
  inline typed::multi_union_pw_aff<Domain> add(const typed::union_pw_aff<Domain> &multi2) const;
  inline typed::union_pw_aff<Anonymous> at(int pos) const;
  inline typed::union_pw_aff<Domain> get_at(int pos) const = delete;
  inline typed::union_set<> bind(const typed::multi_id<Domain> &tuple) const;
  inline typed::multi_union_pw_aff<Domain> coalesce() const;
  inline typed::union_set<> domain() const;
  inline typed::multi_union_pw_aff<Domain> gist(const typed::union_set<> &context) const;
  inline typed::multi_union_pw_aff<Domain> gist(const typed::basic_set<> &context) const;
  inline typed::multi_union_pw_aff<Domain> gist(const typed::point<> &context) const;
  inline typed::multi_union_pw_aff<Domain> gist(const typed::set<> &context) const;
  inline typed::multi_union_pw_aff<Domain> gist_params(const typed::set<> &context) const;
  inline typed::multi_union_pw_aff<Domain> gist_params(const typed::basic_set<> &context) const;
  inline typed::multi_union_pw_aff<Domain> gist_params(const typed::point<> &context) const;
  inline typed::multi_union_pw_aff<Domain> intersect_domain(const typed::union_set<> &uset) const = delete;
  inline typed::multi_union_pw_aff<Domain> intersect_domain(const typed::basic_set<> &uset) const = delete;
  inline typed::multi_union_pw_aff<Domain> intersect_domain(const typed::point<> &uset) const = delete;
  inline typed::multi_union_pw_aff<Domain> intersect_domain(const typed::set<> &uset) const = delete;
  inline typed::multi_union_pw_aff<Domain> intersect_params(const typed::set<> &params) const;
  inline typed::multi_union_pw_aff<Domain> intersect_params(const typed::basic_set<> &params) const;
  inline typed::multi_union_pw_aff<Domain> intersect_params(const typed::point<> &params) const;
  inline typed::union_pw_aff_list<Anonymous> list() const;
  inline typed::union_pw_aff_list<Domain> get_list() const = delete;
  inline typed::multi_union_pw_aff<Domain> neg() const;
  inline typed::multi_union_pw_aff<Domain> pullback(const typed::union_pw_multi_aff<> &upma) const = delete;
  inline typed::multi_union_pw_aff<Domain> pullback(const typed::multi_aff<> &upma) const = delete;
  inline typed::multi_union_pw_aff<Domain> pullback(const typed::pw_multi_aff<> &upma) const = delete;
  inline typed::multi_union_pw_aff<Domain> pullback(const typed::union_pw_aff<> &upma) const = delete;
  inline typed::multi_union_pw_aff<Domain> range_product(const typed::multi_union_pw_aff<> &multi2) const = delete;
  inline typed::multi_union_pw_aff<Domain> range_product(const typed::multi_pw_aff<> &multi2) const = delete;
  inline typed::multi_union_pw_aff<Domain> range_product(const typed::union_pw_aff<> &multi2) const = delete;
  inline typed::id<Domain> get_range_tuple_id() const = delete;
  inline typed::multi_union_pw_aff<Domain> scale(const typed::multi_val<Domain> &mv) const;
  inline typed::multi_union_pw_aff<Domain> scale(const typed::val<Domain> &v) const;
  inline typed::multi_union_pw_aff<Domain> scale(long v) const;
  inline typed::multi_union_pw_aff<Domain> scale_down(const typed::multi_val<Domain> &mv) const;
  inline typed::multi_union_pw_aff<Domain> scale_down(const typed::val<Domain> &v) const;
  inline typed::multi_union_pw_aff<Domain> scale_down(long v) const;
  inline typed::multi_union_pw_aff<Domain> set_at(int pos, const typed::union_pw_aff<Anonymous> &el) const;
  template <typename Domain2>
  inline typed::multi_union_pw_aff<Domain2> set_range_tuple(const typed::id<Anonymous> &id) const;
  template <typename Domain2>
  inline typed::multi_union_pw_aff<Domain2> set_range_tuple(const std::string &id) const;
  inline typed::space<Domain> space() const;
  inline typed::space<Domain> get_space() const = delete;
  inline typed::multi_union_pw_aff<Domain> sub(const typed::multi_union_pw_aff<Domain> &multi2) const;
  inline typed::multi_union_pw_aff<Domain> sub(const typed::multi_pw_aff<Domain> &multi2) const;
  inline typed::multi_union_pw_aff<Domain> sub(const typed::union_pw_aff<Domain> &multi2) const;
  inline typed::multi_union_pw_aff<Domain> union_add(const typed::multi_union_pw_aff<Domain> &mupa2) const;
  inline typed::multi_union_pw_aff<Domain> union_add(const typed::multi_pw_aff<Domain> &mupa2) const;
  inline typed::multi_union_pw_aff<Domain> union_add(const typed::union_pw_aff<Domain> &mupa2) const;
};

template <typename Domain, typename Range>
struct multi_union_pw_aff<Domain, Range> : public isl::multi_union_pw_aff {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  multi_union_pw_aff() = default;
  template <typename Arg1, typename Arg2,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{} &&
              std::is_base_of<Range, Arg2>{},
            bool>::type = true>
  multi_union_pw_aff(const multi_union_pw_aff<Arg1, Arg2> &obj) : isl::multi_union_pw_aff(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::multi_union_pw_aff>{}, bool>::type = true>
  multi_union_pw_aff(const base &obj) : isl::multi_union_pw_aff(obj) {}
 public:
  static multi_union_pw_aff from(const isl::multi_union_pw_aff &obj) {
    return multi_union_pw_aff(obj);
  }
  inline /* implicit */ multi_union_pw_aff(const typed::multi_pw_aff<Domain, Range> &mpa);
  inline /* implicit */ multi_union_pw_aff(const typed::union_pw_aff<Domain, Range> &upa);
  inline explicit multi_union_pw_aff(const typed::space<Domain, Range> &space, const typed::union_pw_aff_list<Domain, Anonymous> &list);
  inline explicit multi_union_pw_aff(const isl::ctx &ctx, const std::string &str);
  inline typed::multi_union_pw_aff<Domain, Range> add(const typed::multi_union_pw_aff<Domain, Range> &multi2) const;
  inline typed::multi_union_pw_aff<Domain, Range> add(const typed::multi_pw_aff<Domain, Range> &multi2) const;
  inline typed::multi_union_pw_aff<Domain, Range> add(const typed::union_pw_aff<Domain, Range> &multi2) const;
  inline typed::union_pw_aff<Domain, Anonymous> at(int pos) const;
  inline typed::union_pw_aff<Domain, Range> get_at(int pos) const = delete;
  inline typed::union_set<Domain> bind(const typed::multi_id<Range> &tuple) const;
  inline typed::multi_union_pw_aff<Domain, Range> coalesce() const;
  inline typed::union_set<Domain> domain() const;
  inline typed::multi_union_pw_aff<Domain, Range> gist(const typed::union_set<Domain> &context) const;
  inline typed::multi_union_pw_aff<Domain, Range> gist(const typed::basic_set<Domain> &context) const;
  inline typed::multi_union_pw_aff<Domain, Range> gist(const typed::point<Domain> &context) const;
  inline typed::multi_union_pw_aff<Domain, Range> gist(const typed::set<Domain> &context) const;
  inline typed::multi_union_pw_aff<Domain, Range> gist_params(const typed::set<> &context) const;
  inline typed::multi_union_pw_aff<Domain, Range> gist_params(const typed::basic_set<> &context) const;
  inline typed::multi_union_pw_aff<Domain, Range> gist_params(const typed::point<> &context) const;
  inline typed::multi_union_pw_aff<Domain, Range> intersect_domain(const typed::union_set<Domain> &uset) const;
  inline typed::multi_union_pw_aff<Domain, Range> intersect_domain(const typed::basic_set<Domain> &uset) const;
  inline typed::multi_union_pw_aff<Domain, Range> intersect_domain(const typed::point<Domain> &uset) const;
  inline typed::multi_union_pw_aff<Domain, Range> intersect_domain(const typed::set<Domain> &uset) const;
  inline typed::multi_union_pw_aff<Domain, Range> intersect_params(const typed::set<> &params) const;
  inline typed::multi_union_pw_aff<Domain, Range> intersect_params(const typed::basic_set<> &params) const;
  inline typed::multi_union_pw_aff<Domain, Range> intersect_params(const typed::point<> &params) const;
  inline typed::union_pw_aff_list<Domain, Anonymous> list() const;
  inline typed::union_pw_aff_list<Domain, Range> get_list() const = delete;
  inline typed::multi_union_pw_aff<Domain, Range> neg() const;
  template <typename Domain2>
  inline typed::multi_union_pw_aff<Domain2, Range> pullback(const typed::union_pw_multi_aff<Domain2, Domain> &upma) const;
  inline typed::multi_union_pw_aff<Range> pullback(const typed::union_pw_multi_aff<Domain> &upma) const;
  template <typename Domain2>
  inline typed::multi_union_pw_aff<Domain2, Range> pullback(const typed::multi_aff<Domain2, Domain> &upma) const;
  inline typed::multi_union_pw_aff<Range> pullback(const typed::multi_aff<Domain> &upma) const;
  template <typename Domain2>
  inline typed::multi_union_pw_aff<Domain2, Range> pullback(const typed::pw_multi_aff<Domain2, Domain> &upma) const;
  inline typed::multi_union_pw_aff<Range> pullback(const typed::pw_multi_aff<Domain> &upma) const;
  template <typename Domain2>
  inline typed::multi_union_pw_aff<Domain2, Range> pullback(const typed::union_pw_aff<Domain2, Domain> &upma) const;
  inline typed::multi_union_pw_aff<Range> pullback(const typed::union_pw_aff<Domain> &upma) const;
  template <typename Range2>
  inline typed::multi_union_pw_aff<Domain, pair<Range, Range2>> range_product(const typed::multi_union_pw_aff<Domain, Range2> &multi2) const;
  template <typename Range2>
  inline typed::multi_union_pw_aff<Domain, pair<Range, Range2>> range_product(const typed::multi_pw_aff<Domain, Range2> &multi2) const;
  inline typed::multi_union_pw_aff<Domain, pair<Range, Anonymous>> range_product(const typed::union_pw_aff<Domain, Anonymous> &multi2) const;
  inline typed::id<Domain, Range> get_range_tuple_id() const = delete;
  inline typed::multi_union_pw_aff<Domain, Range> scale(const typed::multi_val<Range> &mv) const;
  inline typed::multi_union_pw_aff<Domain, Range> scale(const typed::val<Range> &v) const;
  inline typed::multi_union_pw_aff<Domain, Range> scale(long v) const;
  inline typed::multi_union_pw_aff<Domain, Range> scale_down(const typed::multi_val<Range> &mv) const;
  inline typed::multi_union_pw_aff<Domain, Range> scale_down(const typed::val<Range> &v) const;
  inline typed::multi_union_pw_aff<Domain, Range> scale_down(long v) const;
  inline typed::multi_union_pw_aff<Domain, Range> set_at(int pos, const typed::union_pw_aff<Domain, Anonymous> &el) const;
  template <typename Range2>
  inline typed::multi_union_pw_aff<Domain, Range2> set_range_tuple(const typed::id<Anonymous> &id) const;
  template <typename Range2>
  inline typed::multi_union_pw_aff<Domain, Range2> set_range_tuple(const std::string &id) const;
  inline typed::space<Range> space() const;
  inline typed::space<Domain, Range> get_space() const = delete;
  inline typed::multi_union_pw_aff<Domain, Range> sub(const typed::multi_union_pw_aff<Domain, Range> &multi2) const;
  inline typed::multi_union_pw_aff<Domain, Range> sub(const typed::multi_pw_aff<Domain, Range> &multi2) const;
  inline typed::multi_union_pw_aff<Domain, Range> sub(const typed::union_pw_aff<Domain, Range> &multi2) const;
  inline typed::multi_union_pw_aff<Domain, Range> union_add(const typed::multi_union_pw_aff<Domain, Range> &mupa2) const;
  inline typed::multi_union_pw_aff<Domain, Range> union_add(const typed::multi_pw_aff<Domain, Range> &mupa2) const;
  inline typed::multi_union_pw_aff<Domain, Range> union_add(const typed::union_pw_aff<Domain, Range> &mupa2) const;
};

template <typename Domain>
struct multi_val<Domain> : public isl::multi_val {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  multi_val() = default;
  template <typename Arg1,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{},
            bool>::type = true>
  multi_val(const multi_val<Arg1> &obj) : isl::multi_val(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::multi_val>{}, bool>::type = true>
  multi_val(const base &obj) : isl::multi_val(obj) {}
 public:
  static multi_val from(const isl::multi_val &obj) {
    return multi_val(obj);
  }
  inline explicit multi_val(const typed::space<Domain> &space, const typed::val_list<Anonymous> &list);
  inline explicit multi_val(const isl::ctx &ctx, const std::string &str);
  inline typed::multi_val<Domain> add(const typed::multi_val<Domain> &multi2) const;
  inline typed::multi_val<Domain> add(const typed::val<Domain> &v) const;
  inline typed::multi_val<Domain> add(long v) const;
  inline typed::val<Anonymous> at(int pos) const;
  inline typed::val<Domain> get_at(int pos) const = delete;
  inline typed::val_list<Anonymous> list() const;
  inline typed::val_list<Domain> get_list() const = delete;
  inline typed::multi_val<Domain> max(const typed::multi_val<Domain> &multi2) const;
  inline typed::multi_val<Domain> min(const typed::multi_val<Domain> &multi2) const;
  inline typed::multi_val<Domain> neg() const;
  template <typename Range>
  inline typed::multi_val<pair<Domain, Range>> product(const typed::multi_val<Range> &multi2) const;
  inline typed::multi_val<Domain> range_product(const typed::multi_val<> &multi2) const = delete;
  inline typed::id<Domain> get_range_tuple_id() const = delete;
  inline typed::multi_val<Domain> scale(const typed::multi_val<Domain> &mv) const;
  inline typed::multi_val<Domain> scale(const typed::val<Domain> &v) const;
  inline typed::multi_val<Domain> scale(long v) const;
  inline typed::multi_val<Domain> scale_down(const typed::multi_val<Domain> &mv) const;
  inline typed::multi_val<Domain> scale_down(const typed::val<Domain> &v) const;
  inline typed::multi_val<Domain> scale_down(long v) const;
  inline typed::multi_val<Domain> set_at(int pos, const typed::val<Anonymous> &el) const;
  inline typed::multi_val<Domain> set_at(int pos, long el) const;
  template <typename Domain2>
  inline typed::multi_val<Domain2> set_range_tuple(const typed::id<Anonymous> &id) const;
  template <typename Domain2>
  inline typed::multi_val<Domain2> set_range_tuple(const std::string &id) const;
  inline typed::space<Domain> space() const;
  inline typed::space<Domain> get_space() const = delete;
  inline typed::multi_val<Domain> sub(const typed::multi_val<Domain> &multi2) const;
};

template <>
struct point<> : public isl::point {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  point() = default;
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::point>{}, bool>::type = true>
  point(const base &obj) : isl::point(obj) {}
 public:
  static point from(const isl::point &obj) {
    return point(obj);
  }
  inline typed::basic_set<> apply(const typed::basic_map<> &bmap) const = delete;
  inline typed::set<> apply(const typed::map<> &map) const = delete;
  inline typed::union_set<> apply(const typed::union_map<> &umap) const = delete;
  inline typed::pw_multi_aff<> as_pw_multi_aff() const = delete;
  inline typed::set<> as_set() const = delete;
  inline typed::set<> bind(const typed::multi_id<> &tuple) const = delete;
  inline typed::set<> coalesce() const;
  inline typed::basic_set<> detect_equalities() const;
  inline typed::set<> drop_unused_params() const;
  inline bool every_set(const std::function<bool(typed::set<>)> &test) const;
  inline typed::set<> extract_set(const typed::space<> &space) const;
  inline void foreach_basic_set(const std::function<void(typed::basic_set<>)> &fn) const;
  inline void foreach_point(const std::function<void(typed::point<>)> &fn) const;
  inline void foreach_set(const std::function<void(typed::set<>)> &fn) const;
  inline typed::basic_set<> gist(const typed::basic_set<> &context) const;
  inline typed::set<> gist(const typed::set<> &context) const;
  inline typed::union_set<> gist(const typed::union_set<> &context) const;
  inline typed::set<> gist_params(const typed::set<> &context) const = delete;
  inline typed::map<> identity() const = delete;
  inline typed::pw_aff<Anonymous> indicator_function() const;
  inline typed::map<> insert_domain(const typed::space<> &domain) const = delete;
  inline typed::basic_set<> intersect(const typed::basic_set<> &bset2) const;
  inline typed::set<> intersect(const typed::set<> &set2) const;
  inline typed::union_set<> intersect(const typed::union_set<> &uset2) const;
  inline typed::basic_set<> intersect_params(const typed::basic_set<> &bset2) const = delete;
  inline typed::set<> intersect_params(const typed::set<> &params) const = delete;
  inline typed::fixed_box<> lattice_tile() const = delete;
  inline typed::set<> lexmax() const = delete;
  inline typed::pw_multi_aff<> lexmax_pw_multi_aff() const = delete;
  inline typed::set<> lexmin() const = delete;
  inline typed::pw_multi_aff<> lexmin_pw_multi_aff() const = delete;
  inline typed::set<> lower_bound(const typed::multi_pw_aff<> &lower) const = delete;
  inline typed::set<> lower_bound(const typed::multi_val<> &lower) const = delete;
  inline typed::multi_pw_aff<> max_multi_pw_aff() const = delete;
  inline typed::val<> max_val(const typed::aff<> &obj) const = delete;
  inline typed::multi_pw_aff<> min_multi_pw_aff() const = delete;
  inline typed::val<> min_val(const typed::aff<> &obj) const = delete;
  inline typed::multi_val<> multi_val() const = delete;
  inline typed::multi_val<> get_multi_val() const = delete;
  inline typed::pw_aff<Anonymous> param_pw_aff_on_domain(const typed::id<Anonymous> &id) const;
  inline typed::pw_aff<Anonymous> param_pw_aff_on_domain(const std::string &id) const;
  inline typed::basic_set<> params() const = delete;
  inline typed::multi_val<> plain_multi_val_if_fixed() const = delete;
  inline typed::set<> preimage(const typed::multi_aff<> &ma) const = delete;
  inline typed::set<> preimage(const typed::multi_pw_aff<> &mpa) const = delete;
  inline typed::set<> preimage(const typed::pw_multi_aff<> &pma) const = delete;
  inline typed::union_set<> preimage(const typed::union_pw_multi_aff<> &upma) const = delete;
  inline typed::set<> product(const typed::set<> &set2) const = delete;
  inline typed::set<> project_out_all_params() const;
  inline typed::set<> project_out_param(const typed::id<Anonymous> &id) const;
  inline typed::set<> project_out_param(const std::string &id) const;
  inline typed::set<> project_out_param(const typed::id_list<Anonymous> &list) const;
  inline typed::pw_aff<Anonymous> pw_aff_on_domain(const typed::val<Anonymous> &v) const;
  inline typed::pw_aff<Anonymous> pw_aff_on_domain(long v) const;
  template <typename Domain>
  inline typed::pw_multi_aff<Domain> pw_multi_aff_on_domain(const typed::multi_val<Domain> &mv) const;
  inline typed::set_list<> set_list() const;
  inline typed::fixed_box<> simple_fixed_box_hull() const = delete;
  inline typed::space<> space() const;
  inline typed::set<> subtract(const typed::set<> &set2) const;
  inline typed::union_set<> subtract(const typed::union_set<> &uset2) const;
  inline typed::set<> to_set() const;
  inline typed::union_set<> to_union_set() const;
  inline typed::map<> translation() const = delete;
  template <typename Domain>
  inline typed::set<Domain> unbind_params(const typed::multi_id<Domain> &tuple) const;
  inline typed::map<> unbind_params_insert_domain(const typed::multi_id<> &domain) const = delete;
  inline typed::set<> unite(const typed::basic_set<> &bset2) const;
  inline typed::set<> unite(const typed::set<> &set2) const;
  inline typed::union_set<> unite(const typed::union_set<> &uset2) const;
  inline typed::map<> unwrap() const = delete;
  inline typed::set<> upper_bound(const typed::multi_pw_aff<> &upper) const = delete;
  inline typed::set<> upper_bound(const typed::multi_val<> &upper) const = delete;
  inline typed::set<> wrapped_reverse() const = delete;
};

template <typename Domain>
struct point<Domain> : public isl::point {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  point() = default;
  template <typename Arg1,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{},
            bool>::type = true>
  point(const point<Arg1> &obj) : isl::point(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::point>{}, bool>::type = true>
  point(const base &obj) : isl::point(obj) {}
 public:
  static point from(const isl::point &obj) {
    return point(obj);
  }
  template <typename Range>
  inline typed::basic_set<Range> apply(const typed::basic_map<Domain, Range> &bmap) const;
  template <typename Range>
  inline typed::set<Range> apply(const typed::map<Domain, Range> &map) const;
  template <typename Range>
  inline typed::union_set<Range> apply(const typed::union_map<Domain, Range> &umap) const;
  inline typed::pw_multi_aff<Domain> as_pw_multi_aff() const;
  inline typed::set<Domain> as_set() const;
  inline typed::set<> bind(const typed::multi_id<Domain> &tuple) const;
  inline typed::set<Domain> coalesce() const;
  inline typed::basic_set<Domain> detect_equalities() const;
  inline typed::set<Domain> drop_unused_params() const;
  inline bool every_set(const std::function<bool(typed::set<Domain>)> &test) const;
  inline typed::set<Domain> extract_set(const typed::space<Domain> &space) const;
  inline void foreach_basic_set(const std::function<void(typed::basic_set<Domain>)> &fn) const;
  inline void foreach_point(const std::function<void(typed::point<Domain>)> &fn) const;
  inline void foreach_set(const std::function<void(typed::set<Domain>)> &fn) const;
  inline typed::basic_set<Domain> gist(const typed::basic_set<Domain> &context) const;
  inline typed::set<Domain> gist(const typed::set<Domain> &context) const;
  inline typed::union_set<Domain> gist(const typed::union_set<Domain> &context) const;
  inline typed::set<Domain> gist_params(const typed::set<> &context) const;
  inline typed::map<Domain, Domain> identity() const;
  inline typed::pw_aff<Domain, Anonymous> indicator_function() const;
  template <typename Arg1>
  inline typed::map<Arg1, Domain> insert_domain(const typed::space<Arg1> &domain) const;
  inline typed::basic_set<Domain> intersect(const typed::basic_set<Domain> &bset2) const;
  inline typed::set<Domain> intersect(const typed::set<Domain> &set2) const;
  inline typed::union_set<Domain> intersect(const typed::union_set<Domain> &uset2) const;
  inline typed::basic_set<Domain> intersect_params(const typed::basic_set<> &bset2) const;
  inline typed::set<Domain> intersect_params(const typed::set<> &params) const;
  inline typed::fixed_box<Domain> lattice_tile() const;
  inline typed::set<Domain> lexmax() const;
  inline typed::pw_multi_aff<Domain> lexmax_pw_multi_aff() const;
  inline typed::set<Domain> lexmin() const;
  inline typed::pw_multi_aff<Domain> lexmin_pw_multi_aff() const;
  inline typed::set<Domain> lower_bound(const typed::multi_pw_aff<Domain> &lower) const;
  inline typed::set<Domain> lower_bound(const typed::multi_val<Domain> &lower) const;
  inline typed::multi_pw_aff<Domain> max_multi_pw_aff() const;
  inline typed::val<Domain> max_val(const typed::aff<> &obj) const = delete;
  inline typed::multi_pw_aff<Domain> min_multi_pw_aff() const;
  inline typed::val<Domain> min_val(const typed::aff<> &obj) const = delete;
  inline typed::multi_val<Domain> multi_val() const;
  inline typed::multi_val<Domain> get_multi_val() const = delete;
  inline typed::pw_aff<Domain, Anonymous> param_pw_aff_on_domain(const typed::id<Anonymous> &id) const;
  inline typed::pw_aff<Domain, Anonymous> param_pw_aff_on_domain(const std::string &id) const;
  inline typed::basic_set<> params() const;
  inline typed::multi_val<Domain> plain_multi_val_if_fixed() const;
  template <typename Domain2>
  inline typed::set<Domain2> preimage(const typed::multi_aff<Domain2, Domain> &ma) const;
  template <typename Domain2>
  inline typed::set<Domain2> preimage(const typed::multi_pw_aff<Domain2, Domain> &mpa) const;
  template <typename Domain2>
  inline typed::set<Domain2> preimage(const typed::pw_multi_aff<Domain2, Domain> &pma) const;
  template <typename Domain2>
  inline typed::union_set<Domain2> preimage(const typed::union_pw_multi_aff<Domain2, Domain> &upma) const;
  template <typename Range>
  inline typed::set<pair<Domain, Range>> product(const typed::set<Range> &set2) const;
  inline typed::set<Domain> project_out_all_params() const;
  inline typed::set<Domain> project_out_param(const typed::id<Anonymous> &id) const;
  inline typed::set<Domain> project_out_param(const std::string &id) const;
  inline typed::set<Domain> project_out_param(const typed::id_list<Anonymous> &list) const;
  inline typed::pw_aff<Domain, Anonymous> pw_aff_on_domain(const typed::val<Anonymous> &v) const;
  inline typed::pw_aff<Domain, Anonymous> pw_aff_on_domain(long v) const;
  template <typename Range>
  inline typed::pw_multi_aff<Domain, Range> pw_multi_aff_on_domain(const typed::multi_val<Range> &mv) const;
  inline typed::set_list<Domain> set_list() const;
  inline typed::fixed_box<Domain> simple_fixed_box_hull() const;
  inline typed::space<Domain> space() const;
  inline typed::set<Domain> subtract(const typed::set<Domain> &set2) const;
  inline typed::union_set<Domain> subtract(const typed::union_set<Domain> &uset2) const;
  inline typed::set<Domain> to_set() const;
  inline typed::union_set<Domain> to_union_set() const;
  inline typed::map<Domain, Domain> translation() const;
  inline typed::set<Domain> unbind_params(const typed::multi_id<> &tuple) const = delete;
  template <typename Arg1>
  inline typed::map<Arg1, Domain> unbind_params_insert_domain(const typed::multi_id<Arg1> &domain) const;
  inline typed::set<Domain> unite(const typed::basic_set<Domain> &bset2) const;
  inline typed::set<Domain> unite(const typed::set<Domain> &set2) const;
  inline typed::union_set<Domain> unite(const typed::union_set<Domain> &uset2) const;
  inline typed::map<Domain> unwrap() const = delete;
  inline typed::set<Domain> upper_bound(const typed::multi_pw_aff<Domain> &upper) const;
  inline typed::set<Domain> upper_bound(const typed::multi_val<Domain> &upper) const;
  inline typed::set<Domain> wrapped_reverse() const = delete;
};

template <typename Domain, typename Range>
struct point<pair<Domain, Range>> : public isl::point {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  point() = default;
  template <typename Arg1, typename Arg2,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{} &&
              std::is_base_of<Range, Arg2>{},
            bool>::type = true>
  point(const point<pair<Arg1, Arg2>> &obj) : isl::point(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::point>{}, bool>::type = true>
  point(const base &obj) : isl::point(obj) {}
 public:
  static point from(const isl::point &obj) {
    return point(obj);
  }
  template <typename Arg2>
  inline typed::basic_set<Arg2> apply(const typed::basic_map<pair<Domain, Range>, Arg2> &bmap) const;
  template <typename Arg2>
  inline typed::set<Arg2> apply(const typed::map<pair<Domain, Range>, Arg2> &map) const;
  template <typename Arg2>
  inline typed::union_set<Arg2> apply(const typed::union_map<pair<Domain, Range>, Arg2> &umap) const;
  inline typed::pw_multi_aff<pair<Domain, Range>> as_pw_multi_aff() const;
  inline typed::set<pair<Domain, Range>> as_set() const;
  inline typed::set<> bind(const typed::multi_id<pair<Domain, Range>> &tuple) const;
  inline typed::set<pair<Domain, Range>> coalesce() const;
  inline typed::basic_set<pair<Domain, Range>> detect_equalities() const;
  inline typed::set<pair<Domain, Range>> drop_unused_params() const;
  inline bool every_set(const std::function<bool(typed::set<pair<Domain, Range>>)> &test) const;
  inline typed::set<pair<Domain, Range>> extract_set(const typed::space<pair<Domain, Range>> &space) const;
  inline void foreach_basic_set(const std::function<void(typed::basic_set<pair<Domain, Range>>)> &fn) const;
  inline void foreach_point(const std::function<void(typed::point<pair<Domain, Range>>)> &fn) const;
  inline void foreach_set(const std::function<void(typed::set<pair<Domain, Range>>)> &fn) const;
  inline typed::basic_set<pair<Domain, Range>> gist(const typed::basic_set<pair<Domain, Range>> &context) const;
  inline typed::set<pair<Domain, Range>> gist(const typed::set<pair<Domain, Range>> &context) const;
  inline typed::union_set<pair<Domain, Range>> gist(const typed::union_set<pair<Domain, Range>> &context) const;
  inline typed::set<pair<Domain, Range>> gist_params(const typed::set<> &context) const;
  inline typed::map<pair<Domain, Range>, pair<Domain, Range>> identity() const;
  inline typed::pw_aff<pair<Domain, Range>, Anonymous> indicator_function() const;
  template <typename Arg2>
  inline typed::map<Arg2, pair<Domain, Range>> insert_domain(const typed::space<Arg2> &domain) const;
  inline typed::basic_set<pair<Domain, Range>> intersect(const typed::basic_set<pair<Domain, Range>> &bset2) const;
  inline typed::set<pair<Domain, Range>> intersect(const typed::set<pair<Domain, Range>> &set2) const;
  inline typed::union_set<pair<Domain, Range>> intersect(const typed::union_set<pair<Domain, Range>> &uset2) const;
  inline typed::basic_set<pair<Domain, Range>> intersect_params(const typed::basic_set<> &bset2) const;
  inline typed::set<pair<Domain, Range>> intersect_params(const typed::set<> &params) const;
  inline typed::fixed_box<pair<Domain, Range>> lattice_tile() const;
  inline typed::set<pair<Domain, Range>> lexmax() const;
  inline typed::pw_multi_aff<pair<Domain, Range>> lexmax_pw_multi_aff() const;
  inline typed::set<pair<Domain, Range>> lexmin() const;
  inline typed::pw_multi_aff<pair<Domain, Range>> lexmin_pw_multi_aff() const;
  inline typed::set<pair<Domain, Range>> lower_bound(const typed::multi_pw_aff<pair<Domain, Range>> &lower) const;
  inline typed::set<pair<Domain, Range>> lower_bound(const typed::multi_val<pair<Domain, Range>> &lower) const;
  inline typed::multi_pw_aff<pair<Domain, Range>> max_multi_pw_aff() const;
  inline typed::val<pair<Domain, Range>> max_val(const typed::aff<> &obj) const = delete;
  inline typed::multi_pw_aff<pair<Domain, Range>> min_multi_pw_aff() const;
  inline typed::val<pair<Domain, Range>> min_val(const typed::aff<> &obj) const = delete;
  inline typed::multi_val<pair<Domain, Range>> multi_val() const;
  inline typed::multi_val<pair<Domain, Range>> get_multi_val() const = delete;
  inline typed::pw_aff<pair<Domain, Range>, Anonymous> param_pw_aff_on_domain(const typed::id<Anonymous> &id) const;
  inline typed::pw_aff<pair<Domain, Range>, Anonymous> param_pw_aff_on_domain(const std::string &id) const;
  inline typed::basic_set<> params() const;
  inline typed::multi_val<pair<Domain, Range>> plain_multi_val_if_fixed() const;
  template <typename Domain2>
  inline typed::set<Domain2> preimage(const typed::multi_aff<Domain2, pair<Domain, Range>> &ma) const;
  template <typename Domain2>
  inline typed::set<Domain2> preimage(const typed::multi_pw_aff<Domain2, pair<Domain, Range>> &mpa) const;
  template <typename Domain2>
  inline typed::set<Domain2> preimage(const typed::pw_multi_aff<Domain2, pair<Domain, Range>> &pma) const;
  template <typename Domain2>
  inline typed::union_set<Domain2> preimage(const typed::union_pw_multi_aff<Domain2, pair<Domain, Range>> &upma) const;
  template <typename Arg2>
  inline typed::set<pair<pair<Domain, Range>, Arg2>> product(const typed::set<Arg2> &set2) const;
  inline typed::set<pair<Domain, Range>> project_out_all_params() const;
  inline typed::set<pair<Domain, Range>> project_out_param(const typed::id<Anonymous> &id) const;
  inline typed::set<pair<Domain, Range>> project_out_param(const std::string &id) const;
  inline typed::set<pair<Domain, Range>> project_out_param(const typed::id_list<Anonymous> &list) const;
  inline typed::pw_aff<pair<Domain, Range>, Anonymous> pw_aff_on_domain(const typed::val<Anonymous> &v) const;
  inline typed::pw_aff<pair<Domain, Range>, Anonymous> pw_aff_on_domain(long v) const;
  template <typename Arg2>
  inline typed::pw_multi_aff<pair<Domain, Range>, Arg2> pw_multi_aff_on_domain(const typed::multi_val<Arg2> &mv) const;
  inline typed::set_list<pair<Domain, Range>> set_list() const;
  inline typed::fixed_box<pair<Domain, Range>> simple_fixed_box_hull() const;
  inline typed::space<pair<Domain, Range>> space() const;
  inline typed::set<pair<Domain, Range>> subtract(const typed::set<pair<Domain, Range>> &set2) const;
  inline typed::union_set<pair<Domain, Range>> subtract(const typed::union_set<pair<Domain, Range>> &uset2) const;
  inline typed::set<pair<Domain, Range>> to_set() const;
  inline typed::union_set<pair<Domain, Range>> to_union_set() const;
  inline typed::map<pair<Domain, Range>, pair<Domain, Range>> translation() const;
  inline typed::set<pair<Domain, Range>> unbind_params(const typed::multi_id<> &tuple) const = delete;
  template <typename Arg2>
  inline typed::map<Arg2, pair<Domain, Range>> unbind_params_insert_domain(const typed::multi_id<Arg2> &domain) const;
  inline typed::set<pair<Domain, Range>> unite(const typed::basic_set<pair<Domain, Range>> &bset2) const;
  inline typed::set<pair<Domain, Range>> unite(const typed::set<pair<Domain, Range>> &set2) const;
  inline typed::union_set<pair<Domain, Range>> unite(const typed::union_set<pair<Domain, Range>> &uset2) const;
  inline typed::map<Domain, Range> unwrap() const;
  inline typed::set<pair<Domain, Range>> upper_bound(const typed::multi_pw_aff<pair<Domain, Range>> &upper) const;
  inline typed::set<pair<Domain, Range>> upper_bound(const typed::multi_val<pair<Domain, Range>> &upper) const;
  inline typed::set<pair<Range, Domain>> wrapped_reverse() const;
};

template <>
struct pw_aff<Anonymous> : public isl::pw_aff {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  pw_aff() = default;
  pw_aff(const isl::pw_aff &obj) : isl::pw_aff(obj) {}
  static pw_aff from(const isl::pw_aff &obj) {
    return pw_aff(obj);
  }
  inline /* implicit */ pw_aff(const typed::aff<Anonymous> &aff);
  inline explicit pw_aff(const isl::ctx &ctx, const std::string &str);
  inline typed::multi_pw_aff<Anonymous> add(const typed::multi_pw_aff<Anonymous> &multi2) const;
  inline typed::multi_union_pw_aff<Anonymous> add(const typed::multi_union_pw_aff<Anonymous> &multi2) const;
  inline typed::pw_aff<Anonymous> add(const typed::pw_aff<Anonymous> &pwaff2) const;
  inline typed::pw_multi_aff<Anonymous> add(const typed::pw_multi_aff<Anonymous> &pma2) const;
  inline typed::union_pw_aff<Anonymous> add(const typed::union_pw_aff<Anonymous> &upa2) const;
  inline typed::union_pw_multi_aff<Anonymous> add(const typed::union_pw_multi_aff<Anonymous> &upma2) const;
  inline typed::pw_aff<Anonymous> add(const typed::aff<Anonymous> &pwaff2) const;
  inline typed::pw_aff<Anonymous> add_constant(const typed::val<Anonymous> &v) const;
  inline typed::pw_aff<Anonymous> add_constant(long v) const;
  inline typed::pw_multi_aff<Anonymous> add_constant(const typed::multi_val<Anonymous> &mv) const;
  template <typename Range>
  inline typed::union_pw_multi_aff<Range> apply(const typed::union_pw_multi_aff<Anonymous, Range> &upma2) const;
  inline typed::aff<Anonymous> as_aff() const;
  inline typed::map<Anonymous> as_map() const = delete;
  inline typed::multi_aff<Anonymous> as_multi_aff() const;
  inline typed::multi_union_pw_aff<Anonymous> as_multi_union_pw_aff() const;
  inline typed::pw_multi_aff<Anonymous> as_pw_multi_aff() const;
  inline typed::set<Anonymous> as_set() const;
  inline typed::union_map<Anonymous> as_union_map() const = delete;
  inline typed::pw_aff<Anonymous> at(int pos) const;
  inline typed::set<> bind(const typed::multi_id<Anonymous> &tuple) const;
  inline typed::set<> bind(const typed::id<Anonymous> &id) const;
  inline typed::set<> bind(const std::string &id) const;
  inline typed::pw_aff<Anonymous> bind_domain(const typed::multi_id<> &tuple) const = delete;
  inline typed::pw_aff<Anonymous> bind_domain_wrapped_domain(const typed::multi_id<> &tuple) const = delete;
  inline typed::pw_aff<Anonymous> ceil() const;
  inline typed::pw_aff<Anonymous> coalesce() const;
  inline typed::pw_aff<Anonymous> cond(const typed::pw_aff<Anonymous> &pwaff_true, const typed::pw_aff<Anonymous> &pwaff_false) const;
  inline typed::set<> domain() const;
  inline typed::pw_aff<Anonymous> domain_reverse() const = delete;
  inline typed::pw_aff<Anonymous> drop_unused_params() const;
  inline typed::pw_multi_aff<Anonymous> extract_pw_multi_aff(const typed::space<Anonymous> &space) const;
  inline typed::pw_aff<Anonymous> floor() const;
  inline typed::set<Anonymous> ge_set(const typed::pw_aff<> &pwaff2) const = delete;
  inline typed::set<Anonymous> ge_set(const typed::aff<> &pwaff2) const = delete;
  inline typed::pw_aff<Anonymous> gist(const typed::set<> &context) const;
  inline typed::union_pw_aff<Anonymous> gist(const typed::union_set<> &context) const;
  inline typed::pw_aff<Anonymous> gist(const typed::basic_set<> &context) const;
  inline typed::pw_aff<Anonymous> gist(const typed::point<> &context) const;
  inline typed::pw_aff<Anonymous> gist_params(const typed::set<> &context) const;
  inline typed::pw_aff<Anonymous> gist_params(const typed::basic_set<> &context) const;
  inline typed::pw_aff<Anonymous> gist_params(const typed::point<> &context) const;
  inline typed::set<Anonymous> gt_set(const typed::pw_aff<> &pwaff2) const = delete;
  inline typed::set<Anonymous> gt_set(const typed::aff<> &pwaff2) const = delete;
  inline typed::multi_pw_aff<Anonymous, Anonymous> identity() const;
  template <typename Domain>
  inline typed::pw_aff<Domain, Anonymous> insert_domain(const typed::space<Domain> &domain) const;
  inline typed::pw_aff<Anonymous> intersect_domain(const typed::set<> &set) const = delete;
  inline typed::union_pw_aff<Anonymous> intersect_domain(const typed::space<> &space) const = delete;
  inline typed::union_pw_aff<Anonymous> intersect_domain(const typed::union_set<> &uset) const = delete;
  inline typed::pw_aff<Anonymous> intersect_domain(const typed::basic_set<> &set) const = delete;
  inline typed::pw_aff<Anonymous> intersect_domain(const typed::point<> &set) const = delete;
  inline typed::union_pw_aff<Anonymous> intersect_domain_wrapped_domain(const typed::union_set<> &uset) const = delete;
  inline typed::pw_aff<Anonymous> intersect_params(const typed::set<> &set) const;
  inline typed::pw_aff<Anonymous> intersect_params(const typed::basic_set<> &set) const;
  inline typed::pw_aff<Anonymous> intersect_params(const typed::point<> &set) const;
  inline typed::set<Anonymous> le_set(const typed::pw_aff<> &pwaff2) const = delete;
  inline typed::set<Anonymous> le_set(const typed::aff<> &pwaff2) const = delete;
  inline typed::pw_aff_list<Anonymous> list() const;
  inline typed::set<Anonymous> lt_set(const typed::pw_aff<> &pwaff2) const = delete;
  inline typed::set<Anonymous> lt_set(const typed::aff<> &pwaff2) const = delete;
  inline typed::multi_pw_aff<Anonymous> max(const typed::multi_pw_aff<Anonymous> &multi2) const;
  inline typed::pw_aff<Anonymous> max(const typed::pw_aff<Anonymous> &pwaff2) const;
  inline typed::pw_aff<Anonymous> max(const typed::aff<Anonymous> &pwaff2) const;
  inline typed::multi_val<Anonymous> max_multi_val() const;
  inline typed::val<Anonymous> max_val() const;
  inline typed::multi_pw_aff<Anonymous> min(const typed::multi_pw_aff<Anonymous> &multi2) const;
  inline typed::pw_aff<Anonymous> min(const typed::pw_aff<Anonymous> &pwaff2) const;
  inline typed::pw_aff<Anonymous> min(const typed::aff<Anonymous> &pwaff2) const;
  inline typed::multi_val<Anonymous> min_multi_val() const;
  inline typed::val<Anonymous> min_val() const;
  inline typed::pw_aff<Anonymous> mod(const typed::val<Anonymous> &mod) const;
  inline typed::pw_aff<Anonymous> mod(long mod) const;
  inline typed::pw_aff<Anonymous> neg() const;
  inline typed::set<> params() const;
  inline typed::pw_multi_aff<Anonymous> preimage_domain_wrapped_domain(const typed::pw_multi_aff<> &pma2) const = delete;
  inline typed::union_pw_multi_aff<Anonymous> preimage_domain_wrapped_domain(const typed::union_pw_multi_aff<> &upma2) const = delete;
  template <typename Range>
  inline typed::multi_pw_aff<pair<Anonymous, Range>> product(const typed::multi_pw_aff<Range> &multi2) const;
  template <typename Range>
  inline typed::pw_multi_aff<pair<Anonymous, Range>> product(const typed::pw_multi_aff<Range> &pma2) const;
  inline typed::pw_aff<Anonymous> pullback(const typed::multi_aff<> &ma) const = delete;
  inline typed::pw_aff<Anonymous> pullback(const typed::multi_pw_aff<> &mpa) const = delete;
  inline typed::pw_aff<Anonymous> pullback(const typed::pw_multi_aff<> &pma) const = delete;
  inline typed::union_pw_aff<Anonymous> pullback(const typed::union_pw_multi_aff<> &upma) const = delete;
  inline typed::pw_multi_aff_list<Anonymous> pw_multi_aff_list() const;
  inline typed::pw_multi_aff<Anonymous> range_factor_domain() const = delete;
  inline typed::pw_multi_aff<Anonymous> range_factor_range() const = delete;
  inline typed::multi_pw_aff<Anonymous> range_product(const typed::multi_pw_aff<> &multi2) const = delete;
  inline typed::multi_union_pw_aff<Anonymous> range_product(const typed::multi_union_pw_aff<> &multi2) const = delete;
  inline typed::pw_multi_aff<Anonymous> range_product(const typed::pw_multi_aff<> &pma2) const = delete;
  inline typed::union_pw_multi_aff<Anonymous> range_product(const typed::union_pw_multi_aff<> &upma2) const = delete;
  inline typed::pw_aff<Anonymous> scale(const typed::val<Anonymous> &v) const;
  inline typed::pw_aff<Anonymous> scale(long v) const;
  inline typed::pw_multi_aff<Anonymous> scale(const typed::multi_val<Anonymous> &mv) const;
  inline typed::pw_aff<Anonymous> scale_down(const typed::val<Anonymous> &f) const;
  inline typed::pw_aff<Anonymous> scale_down(long f) const;
  inline typed::pw_multi_aff<Anonymous> scale_down(const typed::multi_val<Anonymous> &mv) const;
  inline typed::multi_pw_aff<Anonymous> set_at(int pos, const typed::pw_aff<Anonymous> &el) const;
  inline typed::multi_union_pw_aff<Anonymous> set_at(int pos, const typed::union_pw_aff<Anonymous> &el) const;
  template <typename Domain2>
  inline typed::pw_multi_aff<Domain2> set_range_tuple(const typed::id<Anonymous> &id) const;
  template <typename Domain2>
  inline typed::pw_multi_aff<Domain2> set_range_tuple(const std::string &id) const;
  inline typed::space<Anonymous> space() const;
  inline typed::space<Anonymous> get_space() const = delete;
  inline typed::multi_pw_aff<Anonymous> sub(const typed::multi_pw_aff<Anonymous> &multi2) const;
  inline typed::multi_union_pw_aff<Anonymous> sub(const typed::multi_union_pw_aff<Anonymous> &multi2) const;
  inline typed::pw_aff<Anonymous> sub(const typed::pw_aff<Anonymous> &pwaff2) const;
  inline typed::pw_multi_aff<Anonymous> sub(const typed::pw_multi_aff<Anonymous> &pma2) const;
  inline typed::union_pw_aff<Anonymous> sub(const typed::union_pw_aff<Anonymous> &upa2) const;
  inline typed::union_pw_multi_aff<Anonymous> sub(const typed::union_pw_multi_aff<Anonymous> &upma2) const;
  inline typed::pw_aff<Anonymous> sub(const typed::aff<Anonymous> &pwaff2) const;
  inline typed::pw_aff<Anonymous> subtract_domain(const typed::set<> &set) const = delete;
  inline typed::union_pw_aff<Anonymous> subtract_domain(const typed::space<> &space) const = delete;
  inline typed::union_pw_aff<Anonymous> subtract_domain(const typed::union_set<> &uset) const = delete;
  inline typed::pw_aff<Anonymous> subtract_domain(const typed::basic_set<> &set) const = delete;
  inline typed::pw_aff<Anonymous> subtract_domain(const typed::point<> &set) const = delete;
  inline typed::multi_pw_aff<Anonymous> to_multi_pw_aff() const;
  inline typed::union_pw_aff<Anonymous> to_union_pw_aff() const;
  inline typed::union_pw_multi_aff<Anonymous> to_union_pw_multi_aff() const;
  template <typename Domain>
  inline typed::multi_pw_aff<Domain, Anonymous> unbind_params_insert_domain(const typed::multi_id<Domain> &domain) const;
  inline typed::multi_pw_aff<Anonymous> union_add(const typed::multi_pw_aff<Anonymous> &mpa2) const;
  inline typed::multi_union_pw_aff<Anonymous> union_add(const typed::multi_union_pw_aff<Anonymous> &mupa2) const;
  inline typed::pw_aff<Anonymous> union_add(const typed::pw_aff<Anonymous> &pwaff2) const;
  inline typed::pw_multi_aff<Anonymous> union_add(const typed::pw_multi_aff<Anonymous> &pma2) const;
  inline typed::union_pw_aff<Anonymous> union_add(const typed::union_pw_aff<Anonymous> &upa2) const;
  inline typed::union_pw_multi_aff<Anonymous> union_add(const typed::union_pw_multi_aff<Anonymous> &upma2) const;
  inline typed::pw_aff<Anonymous> union_add(const typed::aff<Anonymous> &pwaff2) const;
};

template <typename Domain>
struct pw_aff<Domain, Anonymous> : public isl::pw_aff {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  pw_aff() = default;
  template <typename Arg1,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{},
            bool>::type = true>
  pw_aff(const pw_aff<Arg1, Anonymous> &obj) : isl::pw_aff(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::pw_aff>{}, bool>::type = true>
  pw_aff(const base &obj) : isl::pw_aff(obj) {}
 public:
  static pw_aff from(const isl::pw_aff &obj) {
    return pw_aff(obj);
  }
  inline /* implicit */ pw_aff(const typed::aff<Domain, Anonymous> &aff);
  inline explicit pw_aff(const isl::ctx &ctx, const std::string &str);
  inline typed::multi_pw_aff<Domain, Anonymous> add(const typed::multi_pw_aff<Domain, Anonymous> &multi2) const;
  inline typed::multi_union_pw_aff<Domain, Anonymous> add(const typed::multi_union_pw_aff<Domain, Anonymous> &multi2) const;
  inline typed::pw_aff<Domain, Anonymous> add(const typed::pw_aff<Domain, Anonymous> &pwaff2) const;
  inline typed::pw_multi_aff<Domain, Anonymous> add(const typed::pw_multi_aff<Domain, Anonymous> &pma2) const;
  inline typed::union_pw_aff<Domain, Anonymous> add(const typed::union_pw_aff<Domain, Anonymous> &upa2) const;
  inline typed::union_pw_multi_aff<Domain, Anonymous> add(const typed::union_pw_multi_aff<Domain, Anonymous> &upma2) const;
  inline typed::pw_aff<Domain, Anonymous> add(const typed::aff<Domain, Anonymous> &pwaff2) const;
  inline typed::pw_aff<Domain, Anonymous> add_constant(const typed::val<Anonymous> &v) const;
  inline typed::pw_aff<Domain, Anonymous> add_constant(long v) const;
  inline typed::pw_multi_aff<Domain, Anonymous> add_constant(const typed::multi_val<Anonymous> &mv) const;
  template <typename Range2>
  inline typed::union_pw_multi_aff<Domain, Range2> apply(const typed::union_pw_multi_aff<Anonymous, Range2> &upma2) const;
  inline typed::aff<Domain, Anonymous> as_aff() const;
  inline typed::map<Domain, Anonymous> as_map() const;
  inline typed::multi_aff<Domain, Anonymous> as_multi_aff() const;
  inline typed::multi_union_pw_aff<Domain, Anonymous> as_multi_union_pw_aff() const;
  inline typed::pw_multi_aff<Domain, Anonymous> as_pw_multi_aff() const;
  inline typed::set<Domain, Anonymous> as_set() const = delete;
  inline typed::union_map<Domain, Anonymous> as_union_map() const;
  inline typed::pw_aff<Domain, Anonymous> at(int pos) const;
  inline typed::set<Domain> bind(const typed::multi_id<Anonymous> &tuple) const;
  inline typed::set<Domain> bind(const typed::id<Anonymous> &id) const;
  inline typed::set<Domain> bind(const std::string &id) const;
  inline typed::pw_aff<Anonymous> bind_domain(const typed::multi_id<Domain> &tuple) const;
  inline typed::pw_aff<Domain, Anonymous> bind_domain_wrapped_domain(const typed::multi_id<> &tuple) const = delete;
  inline typed::pw_aff<Domain, Anonymous> ceil() const;
  inline typed::pw_aff<Domain, Anonymous> coalesce() const;
  inline typed::pw_aff<Domain, Anonymous> cond(const typed::pw_aff<Domain, Anonymous> &pwaff_true, const typed::pw_aff<Domain, Anonymous> &pwaff_false) const;
  inline typed::set<Domain> domain() const;
  inline typed::pw_aff<Domain, Anonymous> domain_reverse() const = delete;
  inline typed::pw_aff<Domain, Anonymous> drop_unused_params() const;
  inline typed::pw_multi_aff<Domain, Anonymous> extract_pw_multi_aff(const typed::space<Domain, Anonymous> &space) const;
  inline typed::pw_aff<Domain, Anonymous> floor() const;
  inline typed::set<Domain> ge_set(const typed::pw_aff<Domain, Anonymous> &pwaff2) const;
  inline typed::set<Domain> ge_set(const typed::aff<Domain, Anonymous> &pwaff2) const;
  inline typed::pw_aff<Domain, Anonymous> gist(const typed::set<Domain> &context) const;
  inline typed::union_pw_aff<Domain, Anonymous> gist(const typed::union_set<Domain> &context) const;
  inline typed::pw_aff<Domain, Anonymous> gist(const typed::basic_set<Domain> &context) const;
  inline typed::pw_aff<Domain, Anonymous> gist(const typed::point<Domain> &context) const;
  inline typed::pw_aff<Domain, Anonymous> gist_params(const typed::set<> &context) const;
  inline typed::pw_aff<Domain, Anonymous> gist_params(const typed::basic_set<> &context) const;
  inline typed::pw_aff<Domain, Anonymous> gist_params(const typed::point<> &context) const;
  inline typed::set<Domain> gt_set(const typed::pw_aff<Domain, Anonymous> &pwaff2) const;
  inline typed::set<Domain> gt_set(const typed::aff<Domain, Anonymous> &pwaff2) const;
  inline typed::multi_pw_aff<Domain, Anonymous> identity() const;
  inline typed::pw_aff<Domain, Anonymous> insert_domain(const typed::space<> &domain) const = delete;
  inline typed::pw_aff<Domain, Anonymous> intersect_domain(const typed::set<Domain> &set) const;
  inline typed::union_pw_aff<Domain, Anonymous> intersect_domain(const typed::space<Domain> &space) const;
  inline typed::union_pw_aff<Domain, Anonymous> intersect_domain(const typed::union_set<Domain> &uset) const;
  inline typed::pw_aff<Domain, Anonymous> intersect_domain(const typed::basic_set<Domain> &set) const;
  inline typed::pw_aff<Domain, Anonymous> intersect_domain(const typed::point<Domain> &set) const;
  inline typed::union_pw_aff<Domain, Anonymous> intersect_domain_wrapped_domain(const typed::union_set<> &uset) const = delete;
  inline typed::pw_aff<Domain, Anonymous> intersect_params(const typed::set<> &set) const;
  inline typed::pw_aff<Domain, Anonymous> intersect_params(const typed::basic_set<> &set) const;
  inline typed::pw_aff<Domain, Anonymous> intersect_params(const typed::point<> &set) const;
  inline typed::set<Domain> le_set(const typed::pw_aff<Domain, Anonymous> &pwaff2) const;
  inline typed::set<Domain> le_set(const typed::aff<Domain, Anonymous> &pwaff2) const;
  inline typed::pw_aff_list<Domain, Anonymous> list() const;
  inline typed::set<Domain> lt_set(const typed::pw_aff<Domain, Anonymous> &pwaff2) const;
  inline typed::set<Domain> lt_set(const typed::aff<Domain, Anonymous> &pwaff2) const;
  inline typed::multi_pw_aff<Domain, Anonymous> max(const typed::multi_pw_aff<Domain, Anonymous> &multi2) const;
  inline typed::pw_aff<Domain, Anonymous> max(const typed::pw_aff<Domain, Anonymous> &pwaff2) const;
  inline typed::pw_aff<Domain, Anonymous> max(const typed::aff<Domain, Anonymous> &pwaff2) const;
  inline typed::multi_val<Anonymous> max_multi_val() const;
  inline typed::val<Anonymous> max_val() const;
  inline typed::multi_pw_aff<Domain, Anonymous> min(const typed::multi_pw_aff<Domain, Anonymous> &multi2) const;
  inline typed::pw_aff<Domain, Anonymous> min(const typed::pw_aff<Domain, Anonymous> &pwaff2) const;
  inline typed::pw_aff<Domain, Anonymous> min(const typed::aff<Domain, Anonymous> &pwaff2) const;
  inline typed::multi_val<Anonymous> min_multi_val() const;
  inline typed::val<Anonymous> min_val() const;
  inline typed::pw_aff<Domain, Anonymous> mod(const typed::val<Anonymous> &mod) const;
  inline typed::pw_aff<Domain, Anonymous> mod(long mod) const;
  inline typed::pw_aff<Domain, Anonymous> neg() const;
  inline typed::set<> params() const;
  inline typed::pw_multi_aff<Domain, Anonymous> preimage_domain_wrapped_domain(const typed::pw_multi_aff<> &pma2) const = delete;
  inline typed::union_pw_multi_aff<Domain, Anonymous> preimage_domain_wrapped_domain(const typed::union_pw_multi_aff<> &upma2) const = delete;
  template <typename Domain2, typename Range2>
  inline typed::multi_pw_aff<pair<Domain, Domain2>, pair<Anonymous, Range2>> product(const typed::multi_pw_aff<Domain2, Range2> &multi2) const;
  template <typename Domain2, typename Range2>
  inline typed::pw_multi_aff<pair<Domain, Domain2>, pair<Anonymous, Range2>> product(const typed::pw_multi_aff<Domain2, Range2> &pma2) const;
  template <typename Domain2>
  inline typed::pw_aff<Domain2, Anonymous> pullback(const typed::multi_aff<Domain2, Domain> &ma) const;
  inline typed::pw_aff<Anonymous> pullback(const typed::multi_aff<Domain> &ma) const;
  template <typename Domain2>
  inline typed::pw_aff<Domain2, Anonymous> pullback(const typed::multi_pw_aff<Domain2, Domain> &mpa) const;
  inline typed::pw_aff<Anonymous> pullback(const typed::multi_pw_aff<Domain> &mpa) const;
  template <typename Domain2>
  inline typed::pw_aff<Domain2, Anonymous> pullback(const typed::pw_multi_aff<Domain2, Domain> &pma) const;
  inline typed::pw_aff<Anonymous> pullback(const typed::pw_multi_aff<Domain> &pma) const;
  template <typename Domain2>
  inline typed::union_pw_aff<Domain2, Anonymous> pullback(const typed::union_pw_multi_aff<Domain2, Domain> &upma) const;
  inline typed::union_pw_aff<Anonymous> pullback(const typed::union_pw_multi_aff<Domain> &upma) const;
  inline typed::pw_multi_aff_list<Domain, Anonymous> pw_multi_aff_list() const;
  inline typed::pw_multi_aff<Domain, Anonymous> range_factor_domain() const = delete;
  inline typed::pw_multi_aff<Domain, Anonymous> range_factor_range() const = delete;
  template <typename Range2>
  inline typed::multi_pw_aff<Domain, pair<Anonymous, Range2>> range_product(const typed::multi_pw_aff<Domain, Range2> &multi2) const;
  template <typename Range2>
  inline typed::multi_union_pw_aff<Domain, pair<Anonymous, Range2>> range_product(const typed::multi_union_pw_aff<Domain, Range2> &multi2) const;
  template <typename Range2>
  inline typed::pw_multi_aff<Domain, pair<Anonymous, Range2>> range_product(const typed::pw_multi_aff<Domain, Range2> &pma2) const;
  template <typename Range2>
  inline typed::union_pw_multi_aff<Domain, pair<Anonymous, Range2>> range_product(const typed::union_pw_multi_aff<Domain, Range2> &upma2) const;
  inline typed::pw_aff<Domain, Anonymous> scale(const typed::val<Anonymous> &v) const;
  inline typed::pw_aff<Domain, Anonymous> scale(long v) const;
  inline typed::pw_multi_aff<Domain, Anonymous> scale(const typed::multi_val<Anonymous> &mv) const;
  inline typed::pw_aff<Domain, Anonymous> scale_down(const typed::val<Anonymous> &f) const;
  inline typed::pw_aff<Domain, Anonymous> scale_down(long f) const;
  inline typed::pw_multi_aff<Domain, Anonymous> scale_down(const typed::multi_val<Anonymous> &mv) const;
  inline typed::multi_pw_aff<Domain, Anonymous> set_at(int pos, const typed::pw_aff<Domain, Anonymous> &el) const;
  inline typed::multi_union_pw_aff<Domain, Anonymous> set_at(int pos, const typed::union_pw_aff<Domain, Anonymous> &el) const;
  template <typename Range2>
  inline typed::pw_multi_aff<Domain, Range2> set_range_tuple(const typed::id<Anonymous> &id) const;
  template <typename Range2>
  inline typed::pw_multi_aff<Domain, Range2> set_range_tuple(const std::string &id) const;
  inline typed::space<Domain, Anonymous> space() const;
  inline typed::space<Domain, Anonymous> get_space() const = delete;
  inline typed::multi_pw_aff<Domain, Anonymous> sub(const typed::multi_pw_aff<Domain, Anonymous> &multi2) const;
  inline typed::multi_union_pw_aff<Domain, Anonymous> sub(const typed::multi_union_pw_aff<Domain, Anonymous> &multi2) const;
  inline typed::pw_aff<Domain, Anonymous> sub(const typed::pw_aff<Domain, Anonymous> &pwaff2) const;
  inline typed::pw_multi_aff<Domain, Anonymous> sub(const typed::pw_multi_aff<Domain, Anonymous> &pma2) const;
  inline typed::union_pw_aff<Domain, Anonymous> sub(const typed::union_pw_aff<Domain, Anonymous> &upa2) const;
  inline typed::union_pw_multi_aff<Domain, Anonymous> sub(const typed::union_pw_multi_aff<Domain, Anonymous> &upma2) const;
  inline typed::pw_aff<Domain, Anonymous> sub(const typed::aff<Domain, Anonymous> &pwaff2) const;
  inline typed::pw_aff<Domain, Anonymous> subtract_domain(const typed::set<Domain> &set) const;
  inline typed::union_pw_aff<Domain, Anonymous> subtract_domain(const typed::space<Domain> &space) const;
  inline typed::union_pw_aff<Domain, Anonymous> subtract_domain(const typed::union_set<Domain> &uset) const;
  inline typed::pw_aff<Domain, Anonymous> subtract_domain(const typed::basic_set<Domain> &set) const;
  inline typed::pw_aff<Domain, Anonymous> subtract_domain(const typed::point<Domain> &set) const;
  inline typed::multi_pw_aff<Domain, Anonymous> to_multi_pw_aff() const;
  inline typed::union_pw_aff<Domain, Anonymous> to_union_pw_aff() const;
  inline typed::union_pw_multi_aff<Domain, Anonymous> to_union_pw_multi_aff() const;
  inline typed::multi_pw_aff<Domain, Anonymous> unbind_params_insert_domain(const typed::multi_id<> &domain) const = delete;
  inline typed::multi_pw_aff<Domain, Anonymous> union_add(const typed::multi_pw_aff<Domain, Anonymous> &mpa2) const;
  inline typed::multi_union_pw_aff<Domain, Anonymous> union_add(const typed::multi_union_pw_aff<Domain, Anonymous> &mupa2) const;
  inline typed::pw_aff<Domain, Anonymous> union_add(const typed::pw_aff<Domain, Anonymous> &pwaff2) const;
  inline typed::pw_multi_aff<Domain, Anonymous> union_add(const typed::pw_multi_aff<Domain, Anonymous> &pma2) const;
  inline typed::union_pw_aff<Domain, Anonymous> union_add(const typed::union_pw_aff<Domain, Anonymous> &upa2) const;
  inline typed::union_pw_multi_aff<Domain, Anonymous> union_add(const typed::union_pw_multi_aff<Domain, Anonymous> &upma2) const;
  inline typed::pw_aff<Domain, Anonymous> union_add(const typed::aff<Domain, Anonymous> &pwaff2) const;
};

template <typename Domain2, typename Range2>
struct pw_aff<pair<Domain2, Range2>, Anonymous> : public isl::pw_aff {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  pw_aff() = default;
  template <typename Arg1, typename Arg2,
            typename std::enable_if<
              std::is_base_of<Domain2, Arg1>{} &&
              std::is_base_of<Range2, Arg2>{},
            bool>::type = true>
  pw_aff(const pw_aff<pair<Arg1, Arg2>, Anonymous> &obj) : isl::pw_aff(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::pw_aff>{}, bool>::type = true>
  pw_aff(const base &obj) : isl::pw_aff(obj) {}
 public:
  static pw_aff from(const isl::pw_aff &obj) {
    return pw_aff(obj);
  }
  inline /* implicit */ pw_aff(const typed::aff<pair<Domain2, Range2>, Anonymous> &aff);
  inline explicit pw_aff(const isl::ctx &ctx, const std::string &str);
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Anonymous> add(const typed::multi_pw_aff<pair<Domain2, Range2>, Anonymous> &multi2) const;
  inline typed::multi_union_pw_aff<pair<Domain2, Range2>, Anonymous> add(const typed::multi_union_pw_aff<pair<Domain2, Range2>, Anonymous> &multi2) const;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> add(const typed::pw_aff<pair<Domain2, Range2>, Anonymous> &pwaff2) const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Anonymous> add(const typed::pw_multi_aff<pair<Domain2, Range2>, Anonymous> &pma2) const;
  inline typed::union_pw_aff<pair<Domain2, Range2>, Anonymous> add(const typed::union_pw_aff<pair<Domain2, Range2>, Anonymous> &upa2) const;
  inline typed::union_pw_multi_aff<pair<Domain2, Range2>, Anonymous> add(const typed::union_pw_multi_aff<pair<Domain2, Range2>, Anonymous> &upma2) const;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> add(const typed::aff<pair<Domain2, Range2>, Anonymous> &pwaff2) const;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> add_constant(const typed::val<Anonymous> &v) const;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> add_constant(long v) const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Anonymous> add_constant(const typed::multi_val<Anonymous> &mv) const;
  template <typename Arg1>
  inline typed::union_pw_multi_aff<pair<Domain2, Range2>, Arg1> apply(const typed::union_pw_multi_aff<Anonymous, Arg1> &upma2) const;
  inline typed::aff<pair<Domain2, Range2>, Anonymous> as_aff() const;
  inline typed::map<pair<Domain2, Range2>, Anonymous> as_map() const;
  inline typed::multi_aff<pair<Domain2, Range2>, Anonymous> as_multi_aff() const;
  inline typed::multi_union_pw_aff<pair<Domain2, Range2>, Anonymous> as_multi_union_pw_aff() const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Anonymous> as_pw_multi_aff() const;
  inline typed::set<pair<Domain2, Range2>, Anonymous> as_set() const = delete;
  inline typed::union_map<pair<Domain2, Range2>, Anonymous> as_union_map() const;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> at(int pos) const;
  inline typed::set<pair<Domain2, Range2>> bind(const typed::multi_id<Anonymous> &tuple) const;
  inline typed::set<pair<Domain2, Range2>> bind(const typed::id<Anonymous> &id) const;
  inline typed::set<pair<Domain2, Range2>> bind(const std::string &id) const;
  inline typed::pw_aff<Anonymous> bind_domain(const typed::multi_id<pair<Domain2, Range2>> &tuple) const;
  inline typed::pw_aff<Range2, Anonymous> bind_domain_wrapped_domain(const typed::multi_id<Domain2> &tuple) const;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> ceil() const;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> coalesce() const;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> cond(const typed::pw_aff<pair<Domain2, Range2>, Anonymous> &pwaff_true, const typed::pw_aff<pair<Domain2, Range2>, Anonymous> &pwaff_false) const;
  inline typed::set<pair<Domain2, Range2>> domain() const;
  inline typed::pw_aff<pair<Range2, Domain2>, Anonymous> domain_reverse() const;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> drop_unused_params() const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Anonymous> extract_pw_multi_aff(const typed::space<pair<Domain2, Range2>, Anonymous> &space) const;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> floor() const;
  inline typed::set<pair<Domain2, Range2>> ge_set(const typed::pw_aff<pair<Domain2, Range2>, Anonymous> &pwaff2) const;
  inline typed::set<pair<Domain2, Range2>> ge_set(const typed::aff<pair<Domain2, Range2>, Anonymous> &pwaff2) const;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> gist(const typed::set<pair<Domain2, Range2>> &context) const;
  inline typed::union_pw_aff<pair<Domain2, Range2>, Anonymous> gist(const typed::union_set<pair<Domain2, Range2>> &context) const;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> gist(const typed::basic_set<pair<Domain2, Range2>> &context) const;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> gist(const typed::point<pair<Domain2, Range2>> &context) const;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> gist_params(const typed::set<> &context) const;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> gist_params(const typed::basic_set<> &context) const;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> gist_params(const typed::point<> &context) const;
  inline typed::set<pair<Domain2, Range2>> gt_set(const typed::pw_aff<pair<Domain2, Range2>, Anonymous> &pwaff2) const;
  inline typed::set<pair<Domain2, Range2>> gt_set(const typed::aff<pair<Domain2, Range2>, Anonymous> &pwaff2) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Anonymous> identity() const;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> insert_domain(const typed::space<> &domain) const = delete;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> intersect_domain(const typed::set<pair<Domain2, Range2>> &set) const;
  inline typed::union_pw_aff<pair<Domain2, Range2>, Anonymous> intersect_domain(const typed::space<pair<Domain2, Range2>> &space) const;
  inline typed::union_pw_aff<pair<Domain2, Range2>, Anonymous> intersect_domain(const typed::union_set<pair<Domain2, Range2>> &uset) const;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> intersect_domain(const typed::basic_set<pair<Domain2, Range2>> &set) const;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> intersect_domain(const typed::point<pair<Domain2, Range2>> &set) const;
  inline typed::union_pw_aff<pair<Domain2, Range2>, Anonymous> intersect_domain_wrapped_domain(const typed::union_set<Domain2> &uset) const;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> intersect_params(const typed::set<> &set) const;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> intersect_params(const typed::basic_set<> &set) const;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> intersect_params(const typed::point<> &set) const;
  inline typed::set<pair<Domain2, Range2>> le_set(const typed::pw_aff<pair<Domain2, Range2>, Anonymous> &pwaff2) const;
  inline typed::set<pair<Domain2, Range2>> le_set(const typed::aff<pair<Domain2, Range2>, Anonymous> &pwaff2) const;
  inline typed::pw_aff_list<pair<Domain2, Range2>, Anonymous> list() const;
  inline typed::set<pair<Domain2, Range2>> lt_set(const typed::pw_aff<pair<Domain2, Range2>, Anonymous> &pwaff2) const;
  inline typed::set<pair<Domain2, Range2>> lt_set(const typed::aff<pair<Domain2, Range2>, Anonymous> &pwaff2) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Anonymous> max(const typed::multi_pw_aff<pair<Domain2, Range2>, Anonymous> &multi2) const;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> max(const typed::pw_aff<pair<Domain2, Range2>, Anonymous> &pwaff2) const;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> max(const typed::aff<pair<Domain2, Range2>, Anonymous> &pwaff2) const;
  inline typed::multi_val<Anonymous> max_multi_val() const;
  inline typed::val<Anonymous> max_val() const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Anonymous> min(const typed::multi_pw_aff<pair<Domain2, Range2>, Anonymous> &multi2) const;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> min(const typed::pw_aff<pair<Domain2, Range2>, Anonymous> &pwaff2) const;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> min(const typed::aff<pair<Domain2, Range2>, Anonymous> &pwaff2) const;
  inline typed::multi_val<Anonymous> min_multi_val() const;
  inline typed::val<Anonymous> min_val() const;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> mod(const typed::val<Anonymous> &mod) const;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> mod(long mod) const;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> neg() const;
  inline typed::set<> params() const;
  template <typename Domain3>
  inline typed::pw_multi_aff<pair<Domain3, Range2>, Anonymous> preimage_domain_wrapped_domain(const typed::pw_multi_aff<Domain3, Domain2> &pma2) const;
  template <typename Domain3>
  inline typed::union_pw_multi_aff<pair<Domain3, Range2>, Anonymous> preimage_domain_wrapped_domain(const typed::union_pw_multi_aff<Domain3, Domain2> &upma2) const;
  template <typename Arg1, typename Arg2>
  inline typed::multi_pw_aff<pair<pair<Domain2, Range2>, Arg1>, pair<Anonymous, Arg2>> product(const typed::multi_pw_aff<Arg1, Arg2> &multi2) const;
  template <typename Arg1, typename Arg2>
  inline typed::pw_multi_aff<pair<pair<Domain2, Range2>, Arg1>, pair<Anonymous, Arg2>> product(const typed::pw_multi_aff<Arg1, Arg2> &pma2) const;
  template <typename Arg1>
  inline typed::pw_aff<Arg1, Anonymous> pullback(const typed::multi_aff<Arg1, pair<Domain2, Range2>> &ma) const;
  inline typed::pw_aff<Anonymous> pullback(const typed::multi_aff<pair<Domain2, Range2>> &ma) const;
  template <typename Arg1>
  inline typed::pw_aff<Arg1, Anonymous> pullback(const typed::multi_pw_aff<Arg1, pair<Domain2, Range2>> &mpa) const;
  inline typed::pw_aff<Anonymous> pullback(const typed::multi_pw_aff<pair<Domain2, Range2>> &mpa) const;
  template <typename Arg1>
  inline typed::pw_aff<Arg1, Anonymous> pullback(const typed::pw_multi_aff<Arg1, pair<Domain2, Range2>> &pma) const;
  inline typed::pw_aff<Anonymous> pullback(const typed::pw_multi_aff<pair<Domain2, Range2>> &pma) const;
  template <typename Arg1>
  inline typed::union_pw_aff<Arg1, Anonymous> pullback(const typed::union_pw_multi_aff<Arg1, pair<Domain2, Range2>> &upma) const;
  inline typed::union_pw_aff<Anonymous> pullback(const typed::union_pw_multi_aff<pair<Domain2, Range2>> &upma) const;
  inline typed::pw_multi_aff_list<pair<Domain2, Range2>, Anonymous> pw_multi_aff_list() const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Anonymous> range_factor_domain() const = delete;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Anonymous> range_factor_range() const = delete;
  template <typename Arg1>
  inline typed::multi_pw_aff<pair<Domain2, Range2>, pair<Anonymous, Arg1>> range_product(const typed::multi_pw_aff<pair<Domain2, Range2>, Arg1> &multi2) const;
  template <typename Arg1>
  inline typed::multi_union_pw_aff<pair<Domain2, Range2>, pair<Anonymous, Arg1>> range_product(const typed::multi_union_pw_aff<pair<Domain2, Range2>, Arg1> &multi2) const;
  template <typename Arg1>
  inline typed::pw_multi_aff<pair<Domain2, Range2>, pair<Anonymous, Arg1>> range_product(const typed::pw_multi_aff<pair<Domain2, Range2>, Arg1> &pma2) const;
  template <typename Arg1>
  inline typed::union_pw_multi_aff<pair<Domain2, Range2>, pair<Anonymous, Arg1>> range_product(const typed::union_pw_multi_aff<pair<Domain2, Range2>, Arg1> &upma2) const;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> scale(const typed::val<Anonymous> &v) const;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> scale(long v) const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Anonymous> scale(const typed::multi_val<Anonymous> &mv) const;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> scale_down(const typed::val<Anonymous> &f) const;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> scale_down(long f) const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Anonymous> scale_down(const typed::multi_val<Anonymous> &mv) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Anonymous> set_at(int pos, const typed::pw_aff<pair<Domain2, Range2>, Anonymous> &el) const;
  inline typed::multi_union_pw_aff<pair<Domain2, Range2>, Anonymous> set_at(int pos, const typed::union_pw_aff<pair<Domain2, Range2>, Anonymous> &el) const;
  template <typename Arg1>
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Arg1> set_range_tuple(const typed::id<Anonymous> &id) const;
  template <typename Arg1>
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Arg1> set_range_tuple(const std::string &id) const;
  inline typed::space<pair<Domain2, Range2>, Anonymous> space() const;
  inline typed::space<pair<Domain2, Range2>, Anonymous> get_space() const = delete;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Anonymous> sub(const typed::multi_pw_aff<pair<Domain2, Range2>, Anonymous> &multi2) const;
  inline typed::multi_union_pw_aff<pair<Domain2, Range2>, Anonymous> sub(const typed::multi_union_pw_aff<pair<Domain2, Range2>, Anonymous> &multi2) const;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> sub(const typed::pw_aff<pair<Domain2, Range2>, Anonymous> &pwaff2) const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Anonymous> sub(const typed::pw_multi_aff<pair<Domain2, Range2>, Anonymous> &pma2) const;
  inline typed::union_pw_aff<pair<Domain2, Range2>, Anonymous> sub(const typed::union_pw_aff<pair<Domain2, Range2>, Anonymous> &upa2) const;
  inline typed::union_pw_multi_aff<pair<Domain2, Range2>, Anonymous> sub(const typed::union_pw_multi_aff<pair<Domain2, Range2>, Anonymous> &upma2) const;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> sub(const typed::aff<pair<Domain2, Range2>, Anonymous> &pwaff2) const;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> subtract_domain(const typed::set<pair<Domain2, Range2>> &set) const;
  inline typed::union_pw_aff<pair<Domain2, Range2>, Anonymous> subtract_domain(const typed::space<pair<Domain2, Range2>> &space) const;
  inline typed::union_pw_aff<pair<Domain2, Range2>, Anonymous> subtract_domain(const typed::union_set<pair<Domain2, Range2>> &uset) const;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> subtract_domain(const typed::basic_set<pair<Domain2, Range2>> &set) const;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> subtract_domain(const typed::point<pair<Domain2, Range2>> &set) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Anonymous> to_multi_pw_aff() const;
  inline typed::union_pw_aff<pair<Domain2, Range2>, Anonymous> to_union_pw_aff() const;
  inline typed::union_pw_multi_aff<pair<Domain2, Range2>, Anonymous> to_union_pw_multi_aff() const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Anonymous> unbind_params_insert_domain(const typed::multi_id<> &domain) const = delete;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Anonymous> union_add(const typed::multi_pw_aff<pair<Domain2, Range2>, Anonymous> &mpa2) const;
  inline typed::multi_union_pw_aff<pair<Domain2, Range2>, Anonymous> union_add(const typed::multi_union_pw_aff<pair<Domain2, Range2>, Anonymous> &mupa2) const;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> union_add(const typed::pw_aff<pair<Domain2, Range2>, Anonymous> &pwaff2) const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Anonymous> union_add(const typed::pw_multi_aff<pair<Domain2, Range2>, Anonymous> &pma2) const;
  inline typed::union_pw_aff<pair<Domain2, Range2>, Anonymous> union_add(const typed::union_pw_aff<pair<Domain2, Range2>, Anonymous> &upa2) const;
  inline typed::union_pw_multi_aff<pair<Domain2, Range2>, Anonymous> union_add(const typed::union_pw_multi_aff<pair<Domain2, Range2>, Anonymous> &upma2) const;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> union_add(const typed::aff<pair<Domain2, Range2>, Anonymous> &pwaff2) const;
};

template <>
struct pw_aff_list<Anonymous> : public isl::pw_aff_list {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  pw_aff_list() = default;
  pw_aff_list(const isl::pw_aff_list &obj) : isl::pw_aff_list(obj) {}
  static pw_aff_list from(const isl::pw_aff_list &obj) {
    return pw_aff_list(obj);
  }
  inline explicit pw_aff_list(const isl::ctx &ctx, int n);
  inline explicit pw_aff_list(const typed::pw_aff<Anonymous> &el);
  inline explicit pw_aff_list(const isl::ctx &ctx, const std::string &str);
  inline typed::pw_aff_list<Anonymous> add(const typed::pw_aff<Anonymous> &el) const;
  inline typed::pw_aff_list<Anonymous> add(const typed::aff<Anonymous> &el) const;
  inline typed::pw_aff<Anonymous> at(int index) const;
  inline typed::pw_aff<Anonymous> get_at(int index) const = delete;
  inline typed::pw_aff_list<Anonymous> drop(unsigned int first, unsigned int n) const;
  inline void foreach(const std::function<void(typed::pw_aff<Anonymous>)> &fn) const;
  inline void foreach_scc(const std::function<bool(typed::pw_aff<Anonymous>, typed::pw_aff<Anonymous>)> &follows, const std::function<void(typed::pw_aff_list<Anonymous>)> &fn) const;
  inline typed::pw_aff_list<Anonymous> set_at(int index, const typed::pw_aff<Anonymous> &el) const;
};

template <typename Domain>
struct pw_aff_list<Domain, Anonymous> : public isl::pw_aff_list {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  pw_aff_list() = default;
  template <typename Arg1,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{},
            bool>::type = true>
  pw_aff_list(const pw_aff_list<Arg1, Anonymous> &obj) : isl::pw_aff_list(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::pw_aff_list>{}, bool>::type = true>
  pw_aff_list(const base &obj) : isl::pw_aff_list(obj) {}
 public:
  static pw_aff_list from(const isl::pw_aff_list &obj) {
    return pw_aff_list(obj);
  }
  inline explicit pw_aff_list(const isl::ctx &ctx, int n);
  inline explicit pw_aff_list(const typed::pw_aff<Domain, Anonymous> &el);
  inline explicit pw_aff_list(const isl::ctx &ctx, const std::string &str);
  inline typed::pw_aff_list<Domain, Anonymous> add(const typed::pw_aff<Domain, Anonymous> &el) const;
  inline typed::pw_aff_list<Domain, Anonymous> add(const typed::aff<Domain, Anonymous> &el) const;
  inline typed::pw_aff<Domain, Anonymous> at(int index) const;
  inline typed::pw_aff<Domain, Anonymous> get_at(int index) const = delete;
  inline typed::pw_aff_list<Domain, Anonymous> drop(unsigned int first, unsigned int n) const;
  inline void foreach(const std::function<void(typed::pw_aff<Domain, Anonymous>)> &fn) const;
  inline void foreach_scc(const std::function<bool(typed::pw_aff<Domain, Anonymous>, typed::pw_aff<Domain, Anonymous>)> &follows, const std::function<void(typed::pw_aff_list<Domain, Anonymous>)> &fn) const;
  inline typed::pw_aff_list<Domain, Anonymous> set_at(int index, const typed::pw_aff<Domain, Anonymous> &el) const;
};

template <typename Domain>
struct pw_multi_aff<Domain> : public isl::pw_multi_aff {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  pw_multi_aff() = default;
  template <typename Arg1,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{},
            bool>::type = true>
  pw_multi_aff(const pw_multi_aff<Arg1> &obj) : isl::pw_multi_aff(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::pw_multi_aff>{}, bool>::type = true>
  pw_multi_aff(const base &obj) : isl::pw_multi_aff(obj) {}
 public:
  static pw_multi_aff from(const isl::pw_multi_aff &obj) {
    return pw_multi_aff(obj);
  }
  inline /* implicit */ pw_multi_aff(const typed::multi_aff<Domain> &ma);
  inline /* implicit */ pw_multi_aff(const typed::pw_aff<Domain> &pa);
  inline explicit pw_multi_aff(const isl::ctx &ctx, const std::string &str);
  inline typed::multi_pw_aff<Domain> add(const typed::multi_pw_aff<Domain> &multi2) const;
  inline typed::multi_union_pw_aff<Domain> add(const typed::multi_union_pw_aff<Domain> &multi2) const;
  inline typed::pw_multi_aff<Domain> add(const typed::pw_multi_aff<Domain> &pma2) const;
  inline typed::union_pw_multi_aff<Domain> add(const typed::union_pw_multi_aff<Domain> &upma2) const;
  inline typed::pw_multi_aff<Domain> add(const typed::multi_aff<Domain> &pma2) const;
  inline typed::pw_multi_aff<Domain> add(const typed::pw_aff<Domain> &pma2) const;
  inline typed::pw_multi_aff<Domain> add_constant(const typed::multi_val<Domain> &mv) const;
  inline typed::pw_multi_aff<Domain> add_constant(const typed::val<Domain> &v) const;
  inline typed::pw_multi_aff<Domain> add_constant(long v) const;
  template <typename Range>
  inline typed::union_pw_multi_aff<Range> apply(const typed::union_pw_multi_aff<Domain, Range> &upma2) const;
  inline typed::map<Domain> as_map() const = delete;
  inline typed::multi_aff<Domain> as_multi_aff() const;
  inline typed::multi_union_pw_aff<Domain> as_multi_union_pw_aff() const;
  inline typed::pw_multi_aff<Domain> as_pw_multi_aff() const;
  inline typed::set<Domain> as_set() const;
  inline typed::union_map<Domain> as_union_map() const = delete;
  inline typed::pw_aff<Anonymous> at(int pos) const;
  inline typed::pw_aff<Domain> get_at(int pos) const = delete;
  inline typed::set<> bind(const typed::multi_id<Domain> &tuple) const;
  inline typed::pw_multi_aff<Domain> bind_domain(const typed::multi_id<> &tuple) const = delete;
  inline typed::pw_multi_aff<Domain> bind_domain_wrapped_domain(const typed::multi_id<> &tuple) const = delete;
  inline typed::pw_multi_aff<Domain> coalesce() const;
  inline typed::set<> domain() const;
  inline typed::pw_multi_aff<Domain> domain_reverse() const = delete;
  inline typed::pw_multi_aff<Domain> drop_unused_params() const;
  inline typed::pw_multi_aff<Domain> extract_pw_multi_aff(const typed::space<Domain> &space) const;
  inline typed::pw_multi_aff<Domain> gist(const typed::set<> &set) const;
  inline typed::union_pw_multi_aff<Domain> gist(const typed::union_set<> &context) const;
  inline typed::pw_multi_aff<Domain> gist(const typed::basic_set<> &set) const;
  inline typed::pw_multi_aff<Domain> gist(const typed::point<> &set) const;
  inline typed::pw_multi_aff<Domain> gist_params(const typed::set<> &set) const;
  inline typed::pw_multi_aff<Domain> gist_params(const typed::basic_set<> &set) const;
  inline typed::pw_multi_aff<Domain> gist_params(const typed::point<> &set) const;
  inline typed::multi_pw_aff<Domain, Domain> identity() const;
  template <typename Arg1>
  inline typed::pw_multi_aff<Arg1, Domain> insert_domain(const typed::space<Arg1> &domain) const;
  inline typed::pw_multi_aff<Domain> intersect_domain(const typed::set<> &set) const = delete;
  inline typed::union_pw_multi_aff<Domain> intersect_domain(const typed::space<> &space) const = delete;
  inline typed::union_pw_multi_aff<Domain> intersect_domain(const typed::union_set<> &uset) const = delete;
  inline typed::pw_multi_aff<Domain> intersect_domain(const typed::basic_set<> &set) const = delete;
  inline typed::pw_multi_aff<Domain> intersect_domain(const typed::point<> &set) const = delete;
  inline typed::union_pw_multi_aff<Domain> intersect_domain_wrapped_domain(const typed::union_set<> &uset) const = delete;
  inline typed::pw_multi_aff<Domain> intersect_params(const typed::set<> &set) const;
  inline typed::pw_multi_aff<Domain> intersect_params(const typed::basic_set<> &set) const;
  inline typed::pw_multi_aff<Domain> intersect_params(const typed::point<> &set) const;
  inline typed::pw_aff_list<Anonymous> list() const;
  inline typed::multi_pw_aff<Domain> max(const typed::multi_pw_aff<Domain> &multi2) const;
  inline typed::multi_val<Domain> max_multi_val() const;
  inline typed::multi_pw_aff<Domain> min(const typed::multi_pw_aff<Domain> &multi2) const;
  inline typed::multi_val<Domain> min_multi_val() const;
  inline typed::multi_pw_aff<Domain> neg() const;
  inline typed::pw_multi_aff<Domain> preimage_domain_wrapped_domain(const typed::pw_multi_aff<> &pma2) const = delete;
  inline typed::union_pw_multi_aff<Domain> preimage_domain_wrapped_domain(const typed::union_pw_multi_aff<> &upma2) const = delete;
  inline typed::pw_multi_aff<Domain> preimage_domain_wrapped_domain(const typed::multi_aff<> &pma2) const = delete;
  inline typed::pw_multi_aff<Domain> preimage_domain_wrapped_domain(const typed::pw_aff<> &pma2) const = delete;
  template <typename Range>
  inline typed::multi_pw_aff<pair<Domain, Range>> product(const typed::multi_pw_aff<Range> &multi2) const;
  template <typename Range>
  inline typed::pw_multi_aff<pair<Domain, Range>> product(const typed::pw_multi_aff<Range> &pma2) const;
  template <typename Range>
  inline typed::pw_multi_aff<pair<Domain, Range>> product(const typed::multi_aff<Range> &pma2) const;
  inline typed::pw_multi_aff<pair<Domain, Anonymous>> product(const typed::pw_aff<Anonymous> &pma2) const;
  inline typed::multi_pw_aff<Domain> pullback(const typed::multi_pw_aff<> &mpa2) const = delete;
  inline typed::pw_multi_aff<Domain> pullback(const typed::multi_aff<> &ma) const = delete;
  inline typed::pw_multi_aff<Domain> pullback(const typed::pw_multi_aff<> &pma2) const = delete;
  inline typed::union_pw_multi_aff<Domain> pullback(const typed::union_pw_multi_aff<> &upma2) const = delete;
  inline typed::pw_multi_aff_list<Domain> pw_multi_aff_list() const;
  inline typed::pw_multi_aff<Domain> range_factor_domain() const = delete;
  inline typed::pw_multi_aff<Domain> range_factor_range() const = delete;
  inline typed::multi_pw_aff<Domain> range_product(const typed::multi_pw_aff<> &multi2) const = delete;
  inline typed::multi_union_pw_aff<Domain> range_product(const typed::multi_union_pw_aff<> &multi2) const = delete;
  inline typed::pw_multi_aff<Domain> range_product(const typed::pw_multi_aff<> &pma2) const = delete;
  inline typed::union_pw_multi_aff<Domain> range_product(const typed::union_pw_multi_aff<> &upma2) const = delete;
  inline typed::pw_multi_aff<Domain> range_product(const typed::multi_aff<> &pma2) const = delete;
  inline typed::pw_multi_aff<Domain> range_product(const typed::pw_aff<> &pma2) const = delete;
  inline typed::id<Domain> get_range_tuple_id() const = delete;
  inline typed::pw_multi_aff<Domain> scale(const typed::multi_val<Domain> &mv) const;
  inline typed::pw_multi_aff<Domain> scale(const typed::val<Domain> &v) const;
  inline typed::pw_multi_aff<Domain> scale(long v) const;
  inline typed::pw_multi_aff<Domain> scale_down(const typed::multi_val<Domain> &mv) const;
  inline typed::pw_multi_aff<Domain> scale_down(const typed::val<Domain> &v) const;
  inline typed::pw_multi_aff<Domain> scale_down(long v) const;
  inline typed::multi_pw_aff<Domain> set_at(int pos, const typed::pw_aff<Anonymous> &el) const;
  inline typed::multi_union_pw_aff<Domain> set_at(int pos, const typed::union_pw_aff<Anonymous> &el) const;
  template <typename Domain2>
  inline typed::pw_multi_aff<Domain2> set_range_tuple(const typed::id<Anonymous> &id) const;
  template <typename Domain2>
  inline typed::pw_multi_aff<Domain2> set_range_tuple(const std::string &id) const;
  inline typed::space<Domain> space() const;
  inline typed::space<Domain> get_space() const = delete;
  inline typed::multi_pw_aff<Domain> sub(const typed::multi_pw_aff<Domain> &multi2) const;
  inline typed::multi_union_pw_aff<Domain> sub(const typed::multi_union_pw_aff<Domain> &multi2) const;
  inline typed::pw_multi_aff<Domain> sub(const typed::pw_multi_aff<Domain> &pma2) const;
  inline typed::union_pw_multi_aff<Domain> sub(const typed::union_pw_multi_aff<Domain> &upma2) const;
  inline typed::pw_multi_aff<Domain> sub(const typed::multi_aff<Domain> &pma2) const;
  inline typed::pw_multi_aff<Domain> sub(const typed::pw_aff<Domain> &pma2) const;
  inline typed::pw_multi_aff<Domain> subtract_domain(const typed::set<> &set) const = delete;
  inline typed::union_pw_multi_aff<Domain> subtract_domain(const typed::space<> &space) const = delete;
  inline typed::union_pw_multi_aff<Domain> subtract_domain(const typed::union_set<> &uset) const = delete;
  inline typed::pw_multi_aff<Domain> subtract_domain(const typed::basic_set<> &set) const = delete;
  inline typed::pw_multi_aff<Domain> subtract_domain(const typed::point<> &set) const = delete;
  inline typed::multi_pw_aff<Domain> to_multi_pw_aff() const;
  inline typed::union_pw_multi_aff<Domain> to_union_pw_multi_aff() const;
  template <typename Arg1>
  inline typed::multi_pw_aff<Arg1, Domain> unbind_params_insert_domain(const typed::multi_id<Arg1> &domain) const;
  inline typed::multi_pw_aff<Domain> union_add(const typed::multi_pw_aff<Domain> &mpa2) const;
  inline typed::multi_union_pw_aff<Domain> union_add(const typed::multi_union_pw_aff<Domain> &mupa2) const;
  inline typed::pw_multi_aff<Domain> union_add(const typed::pw_multi_aff<Domain> &pma2) const;
  inline typed::union_pw_multi_aff<Domain> union_add(const typed::union_pw_multi_aff<Domain> &upma2) const;
  inline typed::pw_multi_aff<Domain> union_add(const typed::multi_aff<Domain> &pma2) const;
  inline typed::pw_multi_aff<Domain> union_add(const typed::pw_aff<Domain> &pma2) const;
};

template <typename Domain, typename Range>
struct pw_multi_aff<Domain, Range> : public isl::pw_multi_aff {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  pw_multi_aff() = default;
  template <typename Arg1, typename Arg2,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{} &&
              std::is_base_of<Range, Arg2>{},
            bool>::type = true>
  pw_multi_aff(const pw_multi_aff<Arg1, Arg2> &obj) : isl::pw_multi_aff(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::pw_multi_aff>{}, bool>::type = true>
  pw_multi_aff(const base &obj) : isl::pw_multi_aff(obj) {}
 public:
  static pw_multi_aff from(const isl::pw_multi_aff &obj) {
    return pw_multi_aff(obj);
  }
  inline /* implicit */ pw_multi_aff(const typed::multi_aff<Domain, Range> &ma);
  inline /* implicit */ pw_multi_aff(const typed::pw_aff<Domain, Range> &pa);
  inline explicit pw_multi_aff(const isl::ctx &ctx, const std::string &str);
  inline typed::multi_pw_aff<Domain, Range> add(const typed::multi_pw_aff<Domain, Range> &multi2) const;
  inline typed::multi_union_pw_aff<Domain, Range> add(const typed::multi_union_pw_aff<Domain, Range> &multi2) const;
  inline typed::pw_multi_aff<Domain, Range> add(const typed::pw_multi_aff<Domain, Range> &pma2) const;
  inline typed::union_pw_multi_aff<Domain, Range> add(const typed::union_pw_multi_aff<Domain, Range> &upma2) const;
  inline typed::pw_multi_aff<Domain, Range> add(const typed::multi_aff<Domain, Range> &pma2) const;
  inline typed::pw_multi_aff<Domain, Range> add(const typed::pw_aff<Domain, Range> &pma2) const;
  inline typed::pw_multi_aff<Domain, Range> add_constant(const typed::multi_val<Range> &mv) const;
  inline typed::pw_multi_aff<Domain, Range> add_constant(const typed::val<Range> &v) const;
  inline typed::pw_multi_aff<Domain, Range> add_constant(long v) const;
  template <typename Range2>
  inline typed::union_pw_multi_aff<Domain, Range2> apply(const typed::union_pw_multi_aff<Range, Range2> &upma2) const;
  inline typed::map<Domain, Range> as_map() const;
  inline typed::multi_aff<Domain, Range> as_multi_aff() const;
  inline typed::multi_union_pw_aff<Domain, Range> as_multi_union_pw_aff() const;
  inline typed::pw_multi_aff<Domain, Range> as_pw_multi_aff() const;
  inline typed::set<Domain, Range> as_set() const = delete;
  inline typed::union_map<Domain, Range> as_union_map() const;
  inline typed::pw_aff<Domain, Anonymous> at(int pos) const;
  inline typed::pw_aff<Domain, Range> get_at(int pos) const = delete;
  inline typed::set<Domain> bind(const typed::multi_id<Range> &tuple) const;
  inline typed::pw_multi_aff<Range> bind_domain(const typed::multi_id<Domain> &tuple) const;
  inline typed::pw_multi_aff<Domain, Range> bind_domain_wrapped_domain(const typed::multi_id<> &tuple) const = delete;
  inline typed::pw_multi_aff<Domain, Range> coalesce() const;
  inline typed::set<Domain> domain() const;
  inline typed::pw_multi_aff<Domain, Range> domain_reverse() const = delete;
  inline typed::pw_multi_aff<Domain, Range> drop_unused_params() const;
  inline typed::pw_multi_aff<Domain, Range> extract_pw_multi_aff(const typed::space<Domain, Range> &space) const;
  inline typed::pw_multi_aff<Domain, Range> gist(const typed::set<Domain> &set) const;
  inline typed::union_pw_multi_aff<Domain, Range> gist(const typed::union_set<Domain> &context) const;
  inline typed::pw_multi_aff<Domain, Range> gist(const typed::basic_set<Domain> &set) const;
  inline typed::pw_multi_aff<Domain, Range> gist(const typed::point<Domain> &set) const;
  inline typed::pw_multi_aff<Domain, Range> gist_params(const typed::set<> &set) const;
  inline typed::pw_multi_aff<Domain, Range> gist_params(const typed::basic_set<> &set) const;
  inline typed::pw_multi_aff<Domain, Range> gist_params(const typed::point<> &set) const;
  inline typed::multi_pw_aff<Domain, Range> identity() const;
  inline typed::pw_multi_aff<Domain, Range> insert_domain(const typed::space<> &domain) const = delete;
  inline typed::pw_multi_aff<Domain, Range> intersect_domain(const typed::set<Domain> &set) const;
  inline typed::union_pw_multi_aff<Domain, Range> intersect_domain(const typed::space<Domain> &space) const;
  inline typed::union_pw_multi_aff<Domain, Range> intersect_domain(const typed::union_set<Domain> &uset) const;
  inline typed::pw_multi_aff<Domain, Range> intersect_domain(const typed::basic_set<Domain> &set) const;
  inline typed::pw_multi_aff<Domain, Range> intersect_domain(const typed::point<Domain> &set) const;
  inline typed::union_pw_multi_aff<Domain, Range> intersect_domain_wrapped_domain(const typed::union_set<> &uset) const = delete;
  inline typed::pw_multi_aff<Domain, Range> intersect_params(const typed::set<> &set) const;
  inline typed::pw_multi_aff<Domain, Range> intersect_params(const typed::basic_set<> &set) const;
  inline typed::pw_multi_aff<Domain, Range> intersect_params(const typed::point<> &set) const;
  inline typed::pw_aff_list<Domain, Anonymous> list() const;
  inline typed::multi_pw_aff<Domain, Range> max(const typed::multi_pw_aff<Domain, Range> &multi2) const;
  inline typed::multi_val<Range> max_multi_val() const;
  inline typed::multi_pw_aff<Domain, Range> min(const typed::multi_pw_aff<Domain, Range> &multi2) const;
  inline typed::multi_val<Range> min_multi_val() const;
  inline typed::multi_pw_aff<Domain, Range> neg() const;
  inline typed::pw_multi_aff<Domain, Range> preimage_domain_wrapped_domain(const typed::pw_multi_aff<> &pma2) const = delete;
  inline typed::union_pw_multi_aff<Domain, Range> preimage_domain_wrapped_domain(const typed::union_pw_multi_aff<> &upma2) const = delete;
  inline typed::pw_multi_aff<Domain, Range> preimage_domain_wrapped_domain(const typed::multi_aff<> &pma2) const = delete;
  inline typed::pw_multi_aff<Domain, Range> preimage_domain_wrapped_domain(const typed::pw_aff<> &pma2) const = delete;
  template <typename Domain2, typename Range2>
  inline typed::multi_pw_aff<pair<Domain, Domain2>, pair<Range, Range2>> product(const typed::multi_pw_aff<Domain2, Range2> &multi2) const;
  template <typename Domain2, typename Range2>
  inline typed::pw_multi_aff<pair<Domain, Domain2>, pair<Range, Range2>> product(const typed::pw_multi_aff<Domain2, Range2> &pma2) const;
  template <typename Domain2, typename Range2>
  inline typed::pw_multi_aff<pair<Domain, Domain2>, pair<Range, Range2>> product(const typed::multi_aff<Domain2, Range2> &pma2) const;
  template <typename Domain2>
  inline typed::pw_multi_aff<pair<Domain, Domain2>, pair<Range, Anonymous>> product(const typed::pw_aff<Domain2, Anonymous> &pma2) const;
  template <typename Domain2>
  inline typed::multi_pw_aff<Domain2, Range> pullback(const typed::multi_pw_aff<Domain2, Domain> &mpa2) const;
  inline typed::multi_pw_aff<Range> pullback(const typed::multi_pw_aff<Domain> &mpa2) const;
  template <typename Domain2>
  inline typed::pw_multi_aff<Domain2, Range> pullback(const typed::multi_aff<Domain2, Domain> &ma) const;
  inline typed::pw_multi_aff<Range> pullback(const typed::multi_aff<Domain> &ma) const;
  template <typename Domain2>
  inline typed::pw_multi_aff<Domain2, Range> pullback(const typed::pw_multi_aff<Domain2, Domain> &pma2) const;
  inline typed::pw_multi_aff<Range> pullback(const typed::pw_multi_aff<Domain> &pma2) const;
  template <typename Domain2>
  inline typed::union_pw_multi_aff<Domain2, Range> pullback(const typed::union_pw_multi_aff<Domain2, Domain> &upma2) const;
  inline typed::union_pw_multi_aff<Range> pullback(const typed::union_pw_multi_aff<Domain> &upma2) const;
  inline typed::pw_multi_aff_list<Domain, Range> pw_multi_aff_list() const;
  inline typed::pw_multi_aff<Domain, Range> range_factor_domain() const = delete;
  inline typed::pw_multi_aff<Domain, Range> range_factor_range() const = delete;
  template <typename Range2>
  inline typed::multi_pw_aff<Domain, pair<Range, Range2>> range_product(const typed::multi_pw_aff<Domain, Range2> &multi2) const;
  template <typename Range2>
  inline typed::multi_union_pw_aff<Domain, pair<Range, Range2>> range_product(const typed::multi_union_pw_aff<Domain, Range2> &multi2) const;
  template <typename Range2>
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> range_product(const typed::pw_multi_aff<Domain, Range2> &pma2) const;
  template <typename Range2>
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> range_product(const typed::union_pw_multi_aff<Domain, Range2> &upma2) const;
  template <typename Range2>
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> range_product(const typed::multi_aff<Domain, Range2> &pma2) const;
  inline typed::pw_multi_aff<Domain, pair<Range, Anonymous>> range_product(const typed::pw_aff<Domain, Anonymous> &pma2) const;
  inline typed::id<Domain, Range> get_range_tuple_id() const = delete;
  inline typed::pw_multi_aff<Domain, Range> scale(const typed::multi_val<Range> &mv) const;
  inline typed::pw_multi_aff<Domain, Range> scale(const typed::val<Range> &v) const;
  inline typed::pw_multi_aff<Domain, Range> scale(long v) const;
  inline typed::pw_multi_aff<Domain, Range> scale_down(const typed::multi_val<Range> &mv) const;
  inline typed::pw_multi_aff<Domain, Range> scale_down(const typed::val<Range> &v) const;
  inline typed::pw_multi_aff<Domain, Range> scale_down(long v) const;
  inline typed::multi_pw_aff<Domain, Range> set_at(int pos, const typed::pw_aff<Domain, Anonymous> &el) const;
  inline typed::multi_union_pw_aff<Domain, Range> set_at(int pos, const typed::union_pw_aff<Domain, Anonymous> &el) const;
  template <typename Range2>
  inline typed::pw_multi_aff<Domain, Range2> set_range_tuple(const typed::id<Anonymous> &id) const;
  template <typename Range2>
  inline typed::pw_multi_aff<Domain, Range2> set_range_tuple(const std::string &id) const;
  inline typed::space<Domain, Range> space() const;
  inline typed::space<Domain, Range> get_space() const = delete;
  inline typed::multi_pw_aff<Domain, Range> sub(const typed::multi_pw_aff<Domain, Range> &multi2) const;
  inline typed::multi_union_pw_aff<Domain, Range> sub(const typed::multi_union_pw_aff<Domain, Range> &multi2) const;
  inline typed::pw_multi_aff<Domain, Range> sub(const typed::pw_multi_aff<Domain, Range> &pma2) const;
  inline typed::union_pw_multi_aff<Domain, Range> sub(const typed::union_pw_multi_aff<Domain, Range> &upma2) const;
  inline typed::pw_multi_aff<Domain, Range> sub(const typed::multi_aff<Domain, Range> &pma2) const;
  inline typed::pw_multi_aff<Domain, Range> sub(const typed::pw_aff<Domain, Range> &pma2) const;
  inline typed::pw_multi_aff<Domain, Range> subtract_domain(const typed::set<Domain> &set) const;
  inline typed::union_pw_multi_aff<Domain, Range> subtract_domain(const typed::space<Domain> &space) const;
  inline typed::union_pw_multi_aff<Domain, Range> subtract_domain(const typed::union_set<Domain> &uset) const;
  inline typed::pw_multi_aff<Domain, Range> subtract_domain(const typed::basic_set<Domain> &set) const;
  inline typed::pw_multi_aff<Domain, Range> subtract_domain(const typed::point<Domain> &set) const;
  inline typed::multi_pw_aff<Domain, Range> to_multi_pw_aff() const;
  inline typed::union_pw_multi_aff<Domain, Range> to_union_pw_multi_aff() const;
  inline typed::multi_pw_aff<Domain, Range> unbind_params_insert_domain(const typed::multi_id<> &domain) const = delete;
  inline typed::multi_pw_aff<Domain, Range> union_add(const typed::multi_pw_aff<Domain, Range> &mpa2) const;
  inline typed::multi_union_pw_aff<Domain, Range> union_add(const typed::multi_union_pw_aff<Domain, Range> &mupa2) const;
  inline typed::pw_multi_aff<Domain, Range> union_add(const typed::pw_multi_aff<Domain, Range> &pma2) const;
  inline typed::union_pw_multi_aff<Domain, Range> union_add(const typed::union_pw_multi_aff<Domain, Range> &upma2) const;
  inline typed::pw_multi_aff<Domain, Range> union_add(const typed::multi_aff<Domain, Range> &pma2) const;
  inline typed::pw_multi_aff<Domain, Range> union_add(const typed::pw_aff<Domain, Range> &pma2) const;
};

template <typename Domain2, typename Range2, typename Range>
struct pw_multi_aff<pair<Domain2, Range2>, Range> : public isl::pw_multi_aff {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  pw_multi_aff() = default;
  template <typename Arg1, typename Arg2, typename Arg3,
            typename std::enable_if<
              std::is_base_of<Domain2, Arg1>{} &&
              std::is_base_of<Range2, Arg2>{} &&
              std::is_base_of<Range, Arg3>{},
            bool>::type = true>
  pw_multi_aff(const pw_multi_aff<pair<Arg1, Arg2>, Arg3> &obj) : isl::pw_multi_aff(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::pw_multi_aff>{}, bool>::type = true>
  pw_multi_aff(const base &obj) : isl::pw_multi_aff(obj) {}
 public:
  static pw_multi_aff from(const isl::pw_multi_aff &obj) {
    return pw_multi_aff(obj);
  }
  inline /* implicit */ pw_multi_aff(const typed::multi_aff<pair<Domain2, Range2>, Range> &ma);
  inline /* implicit */ pw_multi_aff(const typed::pw_aff<pair<Domain2, Range2>, Range> &pa);
  inline explicit pw_multi_aff(const isl::ctx &ctx, const std::string &str);
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> add(const typed::multi_pw_aff<pair<Domain2, Range2>, Range> &multi2) const;
  inline typed::multi_union_pw_aff<pair<Domain2, Range2>, Range> add(const typed::multi_union_pw_aff<pair<Domain2, Range2>, Range> &multi2) const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Range> add(const typed::pw_multi_aff<pair<Domain2, Range2>, Range> &pma2) const;
  inline typed::union_pw_multi_aff<pair<Domain2, Range2>, Range> add(const typed::union_pw_multi_aff<pair<Domain2, Range2>, Range> &upma2) const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Range> add(const typed::multi_aff<pair<Domain2, Range2>, Range> &pma2) const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Range> add(const typed::pw_aff<pair<Domain2, Range2>, Range> &pma2) const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Range> add_constant(const typed::multi_val<Range> &mv) const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Range> add_constant(const typed::val<Range> &v) const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Range> add_constant(long v) const;
  template <typename Arg2>
  inline typed::union_pw_multi_aff<pair<Domain2, Range2>, Arg2> apply(const typed::union_pw_multi_aff<Range, Arg2> &upma2) const;
  inline typed::map<pair<Domain2, Range2>, Range> as_map() const;
  inline typed::multi_aff<pair<Domain2, Range2>, Range> as_multi_aff() const;
  inline typed::multi_union_pw_aff<pair<Domain2, Range2>, Range> as_multi_union_pw_aff() const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Range> as_pw_multi_aff() const;
  inline typed::set<pair<Domain2, Range2>, Range> as_set() const = delete;
  inline typed::union_map<pair<Domain2, Range2>, Range> as_union_map() const;
  inline typed::pw_aff<pair<Domain2, Range2>, Anonymous> at(int pos) const;
  inline typed::pw_aff<pair<Domain2, Range2>, Range> get_at(int pos) const = delete;
  inline typed::set<pair<Domain2, Range2>> bind(const typed::multi_id<Range> &tuple) const;
  inline typed::pw_multi_aff<Range> bind_domain(const typed::multi_id<pair<Domain2, Range2>> &tuple) const;
  inline typed::pw_multi_aff<Range2, Range> bind_domain_wrapped_domain(const typed::multi_id<Domain2> &tuple) const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Range> coalesce() const;
  inline typed::set<pair<Domain2, Range2>> domain() const;
  inline typed::pw_multi_aff<pair<Range2, Domain2>, Range> domain_reverse() const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Range> drop_unused_params() const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Range> extract_pw_multi_aff(const typed::space<pair<Domain2, Range2>, Range> &space) const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Range> gist(const typed::set<pair<Domain2, Range2>> &set) const;
  inline typed::union_pw_multi_aff<pair<Domain2, Range2>, Range> gist(const typed::union_set<pair<Domain2, Range2>> &context) const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Range> gist(const typed::basic_set<pair<Domain2, Range2>> &set) const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Range> gist(const typed::point<pair<Domain2, Range2>> &set) const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Range> gist_params(const typed::set<> &set) const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Range> gist_params(const typed::basic_set<> &set) const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Range> gist_params(const typed::point<> &set) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> identity() const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Range> insert_domain(const typed::space<> &domain) const = delete;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Range> intersect_domain(const typed::set<pair<Domain2, Range2>> &set) const;
  inline typed::union_pw_multi_aff<pair<Domain2, Range2>, Range> intersect_domain(const typed::space<pair<Domain2, Range2>> &space) const;
  inline typed::union_pw_multi_aff<pair<Domain2, Range2>, Range> intersect_domain(const typed::union_set<pair<Domain2, Range2>> &uset) const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Range> intersect_domain(const typed::basic_set<pair<Domain2, Range2>> &set) const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Range> intersect_domain(const typed::point<pair<Domain2, Range2>> &set) const;
  inline typed::union_pw_multi_aff<pair<Domain2, Range2>, Range> intersect_domain_wrapped_domain(const typed::union_set<Domain2> &uset) const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Range> intersect_params(const typed::set<> &set) const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Range> intersect_params(const typed::basic_set<> &set) const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Range> intersect_params(const typed::point<> &set) const;
  inline typed::pw_aff_list<pair<Domain2, Range2>, Anonymous> list() const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> max(const typed::multi_pw_aff<pair<Domain2, Range2>, Range> &multi2) const;
  inline typed::multi_val<Range> max_multi_val() const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> min(const typed::multi_pw_aff<pair<Domain2, Range2>, Range> &multi2) const;
  inline typed::multi_val<Range> min_multi_val() const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> neg() const;
  template <typename Domain3>
  inline typed::pw_multi_aff<pair<Domain3, Range2>, Range> preimage_domain_wrapped_domain(const typed::pw_multi_aff<Domain3, Domain2> &pma2) const;
  template <typename Domain3>
  inline typed::union_pw_multi_aff<pair<Domain3, Range2>, Range> preimage_domain_wrapped_domain(const typed::union_pw_multi_aff<Domain3, Domain2> &upma2) const;
  template <typename Domain3>
  inline typed::pw_multi_aff<pair<Domain3, Range2>, Range> preimage_domain_wrapped_domain(const typed::multi_aff<Domain3, Domain2> &pma2) const;
  template <typename Domain3>
  inline typed::pw_multi_aff<pair<Domain3, Range2>, Range> preimage_domain_wrapped_domain(const typed::pw_aff<Domain3, Domain2> &pma2) const;
  template <typename Arg2, typename Arg3>
  inline typed::multi_pw_aff<pair<pair<Domain2, Range2>, Arg2>, pair<Range, Arg3>> product(const typed::multi_pw_aff<Arg2, Arg3> &multi2) const;
  template <typename Arg2, typename Arg3>
  inline typed::pw_multi_aff<pair<pair<Domain2, Range2>, Arg2>, pair<Range, Arg3>> product(const typed::pw_multi_aff<Arg2, Arg3> &pma2) const;
  template <typename Arg2, typename Arg3>
  inline typed::pw_multi_aff<pair<pair<Domain2, Range2>, Arg2>, pair<Range, Arg3>> product(const typed::multi_aff<Arg2, Arg3> &pma2) const;
  template <typename Arg2>
  inline typed::pw_multi_aff<pair<pair<Domain2, Range2>, Arg2>, pair<Range, Anonymous>> product(const typed::pw_aff<Arg2, Anonymous> &pma2) const;
  template <typename Arg2>
  inline typed::multi_pw_aff<Arg2, Range> pullback(const typed::multi_pw_aff<Arg2, pair<Domain2, Range2>> &mpa2) const;
  inline typed::multi_pw_aff<Range> pullback(const typed::multi_pw_aff<pair<Domain2, Range2>> &mpa2) const;
  template <typename Arg2>
  inline typed::pw_multi_aff<Arg2, Range> pullback(const typed::multi_aff<Arg2, pair<Domain2, Range2>> &ma) const;
  inline typed::pw_multi_aff<Range> pullback(const typed::multi_aff<pair<Domain2, Range2>> &ma) const;
  template <typename Arg2>
  inline typed::pw_multi_aff<Arg2, Range> pullback(const typed::pw_multi_aff<Arg2, pair<Domain2, Range2>> &pma2) const;
  inline typed::pw_multi_aff<Range> pullback(const typed::pw_multi_aff<pair<Domain2, Range2>> &pma2) const;
  template <typename Arg2>
  inline typed::union_pw_multi_aff<Arg2, Range> pullback(const typed::union_pw_multi_aff<Arg2, pair<Domain2, Range2>> &upma2) const;
  inline typed::union_pw_multi_aff<Range> pullback(const typed::union_pw_multi_aff<pair<Domain2, Range2>> &upma2) const;
  inline typed::pw_multi_aff_list<pair<Domain2, Range2>, Range> pw_multi_aff_list() const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Range> range_factor_domain() const = delete;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Range> range_factor_range() const = delete;
  template <typename Arg2>
  inline typed::multi_pw_aff<pair<Domain2, Range2>, pair<Range, Arg2>> range_product(const typed::multi_pw_aff<pair<Domain2, Range2>, Arg2> &multi2) const;
  template <typename Arg2>
  inline typed::multi_union_pw_aff<pair<Domain2, Range2>, pair<Range, Arg2>> range_product(const typed::multi_union_pw_aff<pair<Domain2, Range2>, Arg2> &multi2) const;
  template <typename Arg2>
  inline typed::pw_multi_aff<pair<Domain2, Range2>, pair<Range, Arg2>> range_product(const typed::pw_multi_aff<pair<Domain2, Range2>, Arg2> &pma2) const;
  template <typename Arg2>
  inline typed::union_pw_multi_aff<pair<Domain2, Range2>, pair<Range, Arg2>> range_product(const typed::union_pw_multi_aff<pair<Domain2, Range2>, Arg2> &upma2) const;
  template <typename Arg2>
  inline typed::pw_multi_aff<pair<Domain2, Range2>, pair<Range, Arg2>> range_product(const typed::multi_aff<pair<Domain2, Range2>, Arg2> &pma2) const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, pair<Range, Anonymous>> range_product(const typed::pw_aff<pair<Domain2, Range2>, Anonymous> &pma2) const;
  inline typed::id<pair<Domain2, Range2>, Range> get_range_tuple_id() const = delete;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Range> scale(const typed::multi_val<Range> &mv) const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Range> scale(const typed::val<Range> &v) const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Range> scale(long v) const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Range> scale_down(const typed::multi_val<Range> &mv) const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Range> scale_down(const typed::val<Range> &v) const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Range> scale_down(long v) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> set_at(int pos, const typed::pw_aff<pair<Domain2, Range2>, Anonymous> &el) const;
  inline typed::multi_union_pw_aff<pair<Domain2, Range2>, Range> set_at(int pos, const typed::union_pw_aff<pair<Domain2, Range2>, Anonymous> &el) const;
  template <typename Arg1>
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Arg1> set_range_tuple(const typed::id<Anonymous> &id) const;
  template <typename Arg1>
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Arg1> set_range_tuple(const std::string &id) const;
  inline typed::space<pair<Domain2, Range2>, Range> space() const;
  inline typed::space<pair<Domain2, Range2>, Range> get_space() const = delete;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> sub(const typed::multi_pw_aff<pair<Domain2, Range2>, Range> &multi2) const;
  inline typed::multi_union_pw_aff<pair<Domain2, Range2>, Range> sub(const typed::multi_union_pw_aff<pair<Domain2, Range2>, Range> &multi2) const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Range> sub(const typed::pw_multi_aff<pair<Domain2, Range2>, Range> &pma2) const;
  inline typed::union_pw_multi_aff<pair<Domain2, Range2>, Range> sub(const typed::union_pw_multi_aff<pair<Domain2, Range2>, Range> &upma2) const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Range> sub(const typed::multi_aff<pair<Domain2, Range2>, Range> &pma2) const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Range> sub(const typed::pw_aff<pair<Domain2, Range2>, Range> &pma2) const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Range> subtract_domain(const typed::set<pair<Domain2, Range2>> &set) const;
  inline typed::union_pw_multi_aff<pair<Domain2, Range2>, Range> subtract_domain(const typed::space<pair<Domain2, Range2>> &space) const;
  inline typed::union_pw_multi_aff<pair<Domain2, Range2>, Range> subtract_domain(const typed::union_set<pair<Domain2, Range2>> &uset) const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Range> subtract_domain(const typed::basic_set<pair<Domain2, Range2>> &set) const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Range> subtract_domain(const typed::point<pair<Domain2, Range2>> &set) const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> to_multi_pw_aff() const;
  inline typed::union_pw_multi_aff<pair<Domain2, Range2>, Range> to_union_pw_multi_aff() const;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> unbind_params_insert_domain(const typed::multi_id<> &domain) const = delete;
  inline typed::multi_pw_aff<pair<Domain2, Range2>, Range> union_add(const typed::multi_pw_aff<pair<Domain2, Range2>, Range> &mpa2) const;
  inline typed::multi_union_pw_aff<pair<Domain2, Range2>, Range> union_add(const typed::multi_union_pw_aff<pair<Domain2, Range2>, Range> &mupa2) const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Range> union_add(const typed::pw_multi_aff<pair<Domain2, Range2>, Range> &pma2) const;
  inline typed::union_pw_multi_aff<pair<Domain2, Range2>, Range> union_add(const typed::union_pw_multi_aff<pair<Domain2, Range2>, Range> &upma2) const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Range> union_add(const typed::multi_aff<pair<Domain2, Range2>, Range> &pma2) const;
  inline typed::pw_multi_aff<pair<Domain2, Range2>, Range> union_add(const typed::pw_aff<pair<Domain2, Range2>, Range> &pma2) const;
};

template <typename Domain, typename Range, typename Range2>
struct pw_multi_aff<Domain, pair<Range, Range2>> : public isl::pw_multi_aff {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  pw_multi_aff() = default;
  template <typename Arg1, typename Arg2, typename Arg3,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{} &&
              std::is_base_of<Range, Arg2>{} &&
              std::is_base_of<Range2, Arg3>{},
            bool>::type = true>
  pw_multi_aff(const pw_multi_aff<Arg1, pair<Arg2, Arg3>> &obj) : isl::pw_multi_aff(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::pw_multi_aff>{}, bool>::type = true>
  pw_multi_aff(const base &obj) : isl::pw_multi_aff(obj) {}
 public:
  static pw_multi_aff from(const isl::pw_multi_aff &obj) {
    return pw_multi_aff(obj);
  }
  inline /* implicit */ pw_multi_aff(const typed::multi_aff<Domain, pair<Range, Range2>> &ma);
  inline /* implicit */ pw_multi_aff(const typed::pw_aff<Domain, pair<Range, Range2>> &pa);
  inline explicit pw_multi_aff(const isl::ctx &ctx, const std::string &str);
  inline typed::multi_pw_aff<Domain, pair<Range, Range2>> add(const typed::multi_pw_aff<Domain, pair<Range, Range2>> &multi2) const;
  inline typed::multi_union_pw_aff<Domain, pair<Range, Range2>> add(const typed::multi_union_pw_aff<Domain, pair<Range, Range2>> &multi2) const;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> add(const typed::pw_multi_aff<Domain, pair<Range, Range2>> &pma2) const;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> add(const typed::union_pw_multi_aff<Domain, pair<Range, Range2>> &upma2) const;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> add(const typed::multi_aff<Domain, pair<Range, Range2>> &pma2) const;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> add(const typed::pw_aff<Domain, pair<Range, Range2>> &pma2) const;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> add_constant(const typed::multi_val<pair<Range, Range2>> &mv) const;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> add_constant(const typed::val<pair<Range, Range2>> &v) const;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> add_constant(long v) const;
  template <typename Arg3>
  inline typed::union_pw_multi_aff<Domain, Arg3> apply(const typed::union_pw_multi_aff<pair<Range, Range2>, Arg3> &upma2) const;
  inline typed::map<Domain, pair<Range, Range2>> as_map() const;
  inline typed::multi_aff<Domain, pair<Range, Range2>> as_multi_aff() const;
  inline typed::multi_union_pw_aff<Domain, pair<Range, Range2>> as_multi_union_pw_aff() const;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> as_pw_multi_aff() const;
  inline typed::set<Domain, pair<Range, Range2>> as_set() const = delete;
  inline typed::union_map<Domain, pair<Range, Range2>> as_union_map() const;
  inline typed::pw_aff<Domain, Anonymous> at(int pos) const;
  inline typed::pw_aff<Domain, pair<Range, Range2>> get_at(int pos) const = delete;
  inline typed::set<Domain> bind(const typed::multi_id<pair<Range, Range2>> &tuple) const;
  inline typed::pw_multi_aff<pair<Range, Range2>> bind_domain(const typed::multi_id<Domain> &tuple) const;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> bind_domain_wrapped_domain(const typed::multi_id<> &tuple) const = delete;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> coalesce() const;
  inline typed::set<Domain> domain() const;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> domain_reverse() const = delete;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> drop_unused_params() const;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> extract_pw_multi_aff(const typed::space<Domain, pair<Range, Range2>> &space) const;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> gist(const typed::set<Domain> &set) const;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> gist(const typed::union_set<Domain> &context) const;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> gist(const typed::basic_set<Domain> &set) const;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> gist(const typed::point<Domain> &set) const;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> gist_params(const typed::set<> &set) const;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> gist_params(const typed::basic_set<> &set) const;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> gist_params(const typed::point<> &set) const;
  inline typed::multi_pw_aff<Domain, pair<Range, Range2>> identity() const;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> insert_domain(const typed::space<> &domain) const = delete;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> intersect_domain(const typed::set<Domain> &set) const;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> intersect_domain(const typed::space<Domain> &space) const;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> intersect_domain(const typed::union_set<Domain> &uset) const;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> intersect_domain(const typed::basic_set<Domain> &set) const;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> intersect_domain(const typed::point<Domain> &set) const;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> intersect_domain_wrapped_domain(const typed::union_set<> &uset) const = delete;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> intersect_params(const typed::set<> &set) const;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> intersect_params(const typed::basic_set<> &set) const;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> intersect_params(const typed::point<> &set) const;
  inline typed::pw_aff_list<Domain, Anonymous> list() const;
  inline typed::multi_pw_aff<Domain, pair<Range, Range2>> max(const typed::multi_pw_aff<Domain, pair<Range, Range2>> &multi2) const;
  inline typed::multi_val<pair<Range, Range2>> max_multi_val() const;
  inline typed::multi_pw_aff<Domain, pair<Range, Range2>> min(const typed::multi_pw_aff<Domain, pair<Range, Range2>> &multi2) const;
  inline typed::multi_val<pair<Range, Range2>> min_multi_val() const;
  inline typed::multi_pw_aff<Domain, pair<Range, Range2>> neg() const;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> preimage_domain_wrapped_domain(const typed::pw_multi_aff<> &pma2) const = delete;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> preimage_domain_wrapped_domain(const typed::union_pw_multi_aff<> &upma2) const = delete;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> preimage_domain_wrapped_domain(const typed::multi_aff<> &pma2) const = delete;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> preimage_domain_wrapped_domain(const typed::pw_aff<> &pma2) const = delete;
  template <typename Domain2, typename Arg3>
  inline typed::multi_pw_aff<pair<Domain, Domain2>, pair<pair<Range, Range2>, Arg3>> product(const typed::multi_pw_aff<Domain2, Arg3> &multi2) const;
  template <typename Domain2, typename Arg3>
  inline typed::pw_multi_aff<pair<Domain, Domain2>, pair<pair<Range, Range2>, Arg3>> product(const typed::pw_multi_aff<Domain2, Arg3> &pma2) const;
  template <typename Domain2, typename Arg3>
  inline typed::pw_multi_aff<pair<Domain, Domain2>, pair<pair<Range, Range2>, Arg3>> product(const typed::multi_aff<Domain2, Arg3> &pma2) const;
  template <typename Domain2>
  inline typed::pw_multi_aff<pair<Domain, Domain2>, pair<pair<Range, Range2>, Anonymous>> product(const typed::pw_aff<Domain2, Anonymous> &pma2) const;
  template <typename Domain2>
  inline typed::multi_pw_aff<Domain2, pair<Range, Range2>> pullback(const typed::multi_pw_aff<Domain2, Domain> &mpa2) const;
  inline typed::multi_pw_aff<pair<Range, Range2>> pullback(const typed::multi_pw_aff<Domain> &mpa2) const;
  template <typename Domain2>
  inline typed::pw_multi_aff<Domain2, pair<Range, Range2>> pullback(const typed::multi_aff<Domain2, Domain> &ma) const;
  inline typed::pw_multi_aff<pair<Range, Range2>> pullback(const typed::multi_aff<Domain> &ma) const;
  template <typename Domain2>
  inline typed::pw_multi_aff<Domain2, pair<Range, Range2>> pullback(const typed::pw_multi_aff<Domain2, Domain> &pma2) const;
  inline typed::pw_multi_aff<pair<Range, Range2>> pullback(const typed::pw_multi_aff<Domain> &pma2) const;
  template <typename Domain2>
  inline typed::union_pw_multi_aff<Domain2, pair<Range, Range2>> pullback(const typed::union_pw_multi_aff<Domain2, Domain> &upma2) const;
  inline typed::union_pw_multi_aff<pair<Range, Range2>> pullback(const typed::union_pw_multi_aff<Domain> &upma2) const;
  inline typed::pw_multi_aff_list<Domain, pair<Range, Range2>> pw_multi_aff_list() const;
  inline typed::pw_multi_aff<Domain, Range> range_factor_domain() const;
  inline typed::pw_multi_aff<Domain, Range2> range_factor_range() const;
  template <typename Arg3>
  inline typed::multi_pw_aff<Domain, pair<pair<Range, Range2>, Arg3>> range_product(const typed::multi_pw_aff<Domain, Arg3> &multi2) const;
  template <typename Arg3>
  inline typed::multi_union_pw_aff<Domain, pair<pair<Range, Range2>, Arg3>> range_product(const typed::multi_union_pw_aff<Domain, Arg3> &multi2) const;
  template <typename Arg3>
  inline typed::pw_multi_aff<Domain, pair<pair<Range, Range2>, Arg3>> range_product(const typed::pw_multi_aff<Domain, Arg3> &pma2) const;
  template <typename Arg3>
  inline typed::union_pw_multi_aff<Domain, pair<pair<Range, Range2>, Arg3>> range_product(const typed::union_pw_multi_aff<Domain, Arg3> &upma2) const;
  template <typename Arg3>
  inline typed::pw_multi_aff<Domain, pair<pair<Range, Range2>, Arg3>> range_product(const typed::multi_aff<Domain, Arg3> &pma2) const;
  inline typed::pw_multi_aff<Domain, pair<pair<Range, Range2>, Anonymous>> range_product(const typed::pw_aff<Domain, Anonymous> &pma2) const;
  inline typed::id<Domain, pair<Range, Range2>> get_range_tuple_id() const = delete;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> scale(const typed::multi_val<pair<Range, Range2>> &mv) const;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> scale(const typed::val<pair<Range, Range2>> &v) const;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> scale(long v) const;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> scale_down(const typed::multi_val<pair<Range, Range2>> &mv) const;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> scale_down(const typed::val<pair<Range, Range2>> &v) const;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> scale_down(long v) const;
  inline typed::multi_pw_aff<Domain, pair<Range, Range2>> set_at(int pos, const typed::pw_aff<Domain, Anonymous> &el) const;
  inline typed::multi_union_pw_aff<Domain, pair<Range, Range2>> set_at(int pos, const typed::union_pw_aff<Domain, Anonymous> &el) const;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> set_range_tuple(const typed::id<> &id) const = delete;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> set_range_tuple(const std::string &id) const = delete;
  inline typed::space<Domain, pair<Range, Range2>> space() const;
  inline typed::space<Domain, pair<Range, Range2>> get_space() const = delete;
  inline typed::multi_pw_aff<Domain, pair<Range, Range2>> sub(const typed::multi_pw_aff<Domain, pair<Range, Range2>> &multi2) const;
  inline typed::multi_union_pw_aff<Domain, pair<Range, Range2>> sub(const typed::multi_union_pw_aff<Domain, pair<Range, Range2>> &multi2) const;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> sub(const typed::pw_multi_aff<Domain, pair<Range, Range2>> &pma2) const;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> sub(const typed::union_pw_multi_aff<Domain, pair<Range, Range2>> &upma2) const;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> sub(const typed::multi_aff<Domain, pair<Range, Range2>> &pma2) const;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> sub(const typed::pw_aff<Domain, pair<Range, Range2>> &pma2) const;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> subtract_domain(const typed::set<Domain> &set) const;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> subtract_domain(const typed::space<Domain> &space) const;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> subtract_domain(const typed::union_set<Domain> &uset) const;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> subtract_domain(const typed::basic_set<Domain> &set) const;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> subtract_domain(const typed::point<Domain> &set) const;
  inline typed::multi_pw_aff<Domain, pair<Range, Range2>> to_multi_pw_aff() const;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> to_union_pw_multi_aff() const;
  inline typed::multi_pw_aff<Domain, pair<Range, Range2>> unbind_params_insert_domain(const typed::multi_id<> &domain) const = delete;
  inline typed::multi_pw_aff<Domain, pair<Range, Range2>> union_add(const typed::multi_pw_aff<Domain, pair<Range, Range2>> &mpa2) const;
  inline typed::multi_union_pw_aff<Domain, pair<Range, Range2>> union_add(const typed::multi_union_pw_aff<Domain, pair<Range, Range2>> &mupa2) const;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> union_add(const typed::pw_multi_aff<Domain, pair<Range, Range2>> &pma2) const;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> union_add(const typed::union_pw_multi_aff<Domain, pair<Range, Range2>> &upma2) const;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> union_add(const typed::multi_aff<Domain, pair<Range, Range2>> &pma2) const;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> union_add(const typed::pw_aff<Domain, pair<Range, Range2>> &pma2) const;
};

template <typename T1, typename T2, typename Range, typename Range2>
struct pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> : public isl::pw_multi_aff {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  pw_multi_aff() = default;
  template <typename Arg1, typename Arg2, typename Arg3, typename Arg4,
            typename std::enable_if<
              std::is_base_of<T1, Arg1>{} &&
              std::is_base_of<T2, Arg2>{} &&
              std::is_base_of<Range, Arg3>{} &&
              std::is_base_of<Range2, Arg4>{},
            bool>::type = true>
  pw_multi_aff(const pw_multi_aff<pair<Arg1, Arg2>, pair<Arg3, Arg4>> &obj) : isl::pw_multi_aff(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::pw_multi_aff>{}, bool>::type = true>
  pw_multi_aff(const base &obj) : isl::pw_multi_aff(obj) {}
 public:
  static pw_multi_aff from(const isl::pw_multi_aff &obj) {
    return pw_multi_aff(obj);
  }
  inline /* implicit */ pw_multi_aff(const typed::multi_aff<pair<T1, T2>, pair<Range, Range2>> &ma);
  inline /* implicit */ pw_multi_aff(const typed::pw_aff<pair<T1, T2>, pair<Range, Range2>> &pa);
  inline explicit pw_multi_aff(const isl::ctx &ctx, const std::string &str);
  inline typed::multi_pw_aff<pair<T1, T2>, pair<Range, Range2>> add(const typed::multi_pw_aff<pair<T1, T2>, pair<Range, Range2>> &multi2) const;
  inline typed::multi_union_pw_aff<pair<T1, T2>, pair<Range, Range2>> add(const typed::multi_union_pw_aff<pair<T1, T2>, pair<Range, Range2>> &multi2) const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> add(const typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> &pma2) const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> add(const typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> &upma2) const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> add(const typed::multi_aff<pair<T1, T2>, pair<Range, Range2>> &pma2) const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> add(const typed::pw_aff<pair<T1, T2>, pair<Range, Range2>> &pma2) const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> add_constant(const typed::multi_val<pair<Range, Range2>> &mv) const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> add_constant(const typed::val<pair<Range, Range2>> &v) const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> add_constant(long v) const;
  template <typename Arg2>
  inline typed::union_pw_multi_aff<pair<T1, T2>, Arg2> apply(const typed::union_pw_multi_aff<pair<Range, Range2>, Arg2> &upma2) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> as_map() const;
  inline typed::multi_aff<pair<T1, T2>, pair<Range, Range2>> as_multi_aff() const;
  inline typed::multi_union_pw_aff<pair<T1, T2>, pair<Range, Range2>> as_multi_union_pw_aff() const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> as_pw_multi_aff() const;
  inline typed::set<pair<T1, T2>, pair<Range, Range2>> as_set() const = delete;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> as_union_map() const;
  inline typed::pw_aff<pair<T1, T2>, Anonymous> at(int pos) const;
  inline typed::pw_aff<pair<T1, T2>, pair<Range, Range2>> get_at(int pos) const = delete;
  inline typed::set<pair<T1, T2>> bind(const typed::multi_id<pair<Range, Range2>> &tuple) const;
  inline typed::pw_multi_aff<pair<Range, Range2>> bind_domain(const typed::multi_id<pair<T1, T2>> &tuple) const;
  inline typed::pw_multi_aff<T2, pair<Range, Range2>> bind_domain_wrapped_domain(const typed::multi_id<T1> &tuple) const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> coalesce() const;
  inline typed::set<pair<T1, T2>> domain() const;
  inline typed::pw_multi_aff<pair<T2, T1>, pair<Range, Range2>> domain_reverse() const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> drop_unused_params() const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> extract_pw_multi_aff(const typed::space<pair<T1, T2>, pair<Range, Range2>> &space) const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> gist(const typed::set<pair<T1, T2>> &set) const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> gist(const typed::union_set<pair<T1, T2>> &context) const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> gist(const typed::basic_set<pair<T1, T2>> &set) const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> gist(const typed::point<pair<T1, T2>> &set) const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> gist_params(const typed::set<> &set) const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> gist_params(const typed::basic_set<> &set) const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> gist_params(const typed::point<> &set) const;
  inline typed::multi_pw_aff<pair<T1, T2>, pair<Range, Range2>> identity() const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> insert_domain(const typed::space<> &domain) const = delete;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> intersect_domain(const typed::set<pair<T1, T2>> &set) const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> intersect_domain(const typed::space<pair<T1, T2>> &space) const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> intersect_domain(const typed::union_set<pair<T1, T2>> &uset) const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> intersect_domain(const typed::basic_set<pair<T1, T2>> &set) const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> intersect_domain(const typed::point<pair<T1, T2>> &set) const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> intersect_domain_wrapped_domain(const typed::union_set<T1> &uset) const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> intersect_params(const typed::set<> &set) const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> intersect_params(const typed::basic_set<> &set) const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> intersect_params(const typed::point<> &set) const;
  inline typed::pw_aff_list<pair<T1, T2>, Anonymous> list() const;
  inline typed::multi_pw_aff<pair<T1, T2>, pair<Range, Range2>> max(const typed::multi_pw_aff<pair<T1, T2>, pair<Range, Range2>> &multi2) const;
  inline typed::multi_val<pair<Range, Range2>> max_multi_val() const;
  inline typed::multi_pw_aff<pair<T1, T2>, pair<Range, Range2>> min(const typed::multi_pw_aff<pair<T1, T2>, pair<Range, Range2>> &multi2) const;
  inline typed::multi_val<pair<Range, Range2>> min_multi_val() const;
  inline typed::multi_pw_aff<pair<T1, T2>, pair<Range, Range2>> neg() const;
  template <typename Domain3>
  inline typed::pw_multi_aff<pair<Domain3, T2>, pair<Range, Range2>> preimage_domain_wrapped_domain(const typed::pw_multi_aff<Domain3, T1> &pma2) const;
  template <typename Domain3>
  inline typed::union_pw_multi_aff<pair<Domain3, T2>, pair<Range, Range2>> preimage_domain_wrapped_domain(const typed::union_pw_multi_aff<Domain3, T1> &upma2) const;
  template <typename Domain3>
  inline typed::pw_multi_aff<pair<Domain3, T2>, pair<Range, Range2>> preimage_domain_wrapped_domain(const typed::multi_aff<Domain3, T1> &pma2) const;
  template <typename Domain3>
  inline typed::pw_multi_aff<pair<Domain3, T2>, pair<Range, Range2>> preimage_domain_wrapped_domain(const typed::pw_aff<Domain3, T1> &pma2) const;
  template <typename Domain2, typename Arg2>
  inline typed::multi_pw_aff<pair<pair<T1, T2>, Domain2>, pair<pair<Range, Range2>, Arg2>> product(const typed::multi_pw_aff<Domain2, Arg2> &multi2) const;
  template <typename Domain2, typename Arg2>
  inline typed::pw_multi_aff<pair<pair<T1, T2>, Domain2>, pair<pair<Range, Range2>, Arg2>> product(const typed::pw_multi_aff<Domain2, Arg2> &pma2) const;
  template <typename Domain2, typename Arg2>
  inline typed::pw_multi_aff<pair<pair<T1, T2>, Domain2>, pair<pair<Range, Range2>, Arg2>> product(const typed::multi_aff<Domain2, Arg2> &pma2) const;
  template <typename Domain2>
  inline typed::pw_multi_aff<pair<pair<T1, T2>, Domain2>, pair<pair<Range, Range2>, Anonymous>> product(const typed::pw_aff<Domain2, Anonymous> &pma2) const;
  template <typename Domain2>
  inline typed::multi_pw_aff<Domain2, pair<Range, Range2>> pullback(const typed::multi_pw_aff<Domain2, pair<T1, T2>> &mpa2) const;
  inline typed::multi_pw_aff<pair<Range, Range2>> pullback(const typed::multi_pw_aff<pair<T1, T2>> &mpa2) const;
  template <typename Domain2>
  inline typed::pw_multi_aff<Domain2, pair<Range, Range2>> pullback(const typed::multi_aff<Domain2, pair<T1, T2>> &ma) const;
  inline typed::pw_multi_aff<pair<Range, Range2>> pullback(const typed::multi_aff<pair<T1, T2>> &ma) const;
  template <typename Domain2>
  inline typed::pw_multi_aff<Domain2, pair<Range, Range2>> pullback(const typed::pw_multi_aff<Domain2, pair<T1, T2>> &pma2) const;
  inline typed::pw_multi_aff<pair<Range, Range2>> pullback(const typed::pw_multi_aff<pair<T1, T2>> &pma2) const;
  template <typename Domain2>
  inline typed::union_pw_multi_aff<Domain2, pair<Range, Range2>> pullback(const typed::union_pw_multi_aff<Domain2, pair<T1, T2>> &upma2) const;
  inline typed::union_pw_multi_aff<pair<Range, Range2>> pullback(const typed::union_pw_multi_aff<pair<T1, T2>> &upma2) const;
  inline typed::pw_multi_aff_list<pair<T1, T2>, pair<Range, Range2>> pw_multi_aff_list() const;
  inline typed::pw_multi_aff<pair<T1, T2>, Range> range_factor_domain() const;
  inline typed::pw_multi_aff<pair<T1, T2>, Range2> range_factor_range() const;
  template <typename Arg2>
  inline typed::multi_pw_aff<pair<T1, T2>, pair<pair<Range, Range2>, Arg2>> range_product(const typed::multi_pw_aff<pair<T1, T2>, Arg2> &multi2) const;
  template <typename Arg2>
  inline typed::multi_union_pw_aff<pair<T1, T2>, pair<pair<Range, Range2>, Arg2>> range_product(const typed::multi_union_pw_aff<pair<T1, T2>, Arg2> &multi2) const;
  template <typename Arg2>
  inline typed::pw_multi_aff<pair<T1, T2>, pair<pair<Range, Range2>, Arg2>> range_product(const typed::pw_multi_aff<pair<T1, T2>, Arg2> &pma2) const;
  template <typename Arg2>
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<pair<Range, Range2>, Arg2>> range_product(const typed::union_pw_multi_aff<pair<T1, T2>, Arg2> &upma2) const;
  template <typename Arg2>
  inline typed::pw_multi_aff<pair<T1, T2>, pair<pair<Range, Range2>, Arg2>> range_product(const typed::multi_aff<pair<T1, T2>, Arg2> &pma2) const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<pair<Range, Range2>, Anonymous>> range_product(const typed::pw_aff<pair<T1, T2>, Anonymous> &pma2) const;
  inline typed::id<pair<T1, T2>, pair<Range, Range2>> get_range_tuple_id() const = delete;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> scale(const typed::multi_val<pair<Range, Range2>> &mv) const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> scale(const typed::val<pair<Range, Range2>> &v) const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> scale(long v) const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> scale_down(const typed::multi_val<pair<Range, Range2>> &mv) const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> scale_down(const typed::val<pair<Range, Range2>> &v) const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> scale_down(long v) const;
  inline typed::multi_pw_aff<pair<T1, T2>, pair<Range, Range2>> set_at(int pos, const typed::pw_aff<pair<T1, T2>, Anonymous> &el) const;
  inline typed::multi_union_pw_aff<pair<T1, T2>, pair<Range, Range2>> set_at(int pos, const typed::union_pw_aff<pair<T1, T2>, Anonymous> &el) const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> set_range_tuple(const typed::id<> &id) const = delete;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> set_range_tuple(const std::string &id) const = delete;
  inline typed::space<pair<T1, T2>, pair<Range, Range2>> space() const;
  inline typed::space<pair<T1, T2>, pair<Range, Range2>> get_space() const = delete;
  inline typed::multi_pw_aff<pair<T1, T2>, pair<Range, Range2>> sub(const typed::multi_pw_aff<pair<T1, T2>, pair<Range, Range2>> &multi2) const;
  inline typed::multi_union_pw_aff<pair<T1, T2>, pair<Range, Range2>> sub(const typed::multi_union_pw_aff<pair<T1, T2>, pair<Range, Range2>> &multi2) const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> sub(const typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> &pma2) const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> sub(const typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> &upma2) const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> sub(const typed::multi_aff<pair<T1, T2>, pair<Range, Range2>> &pma2) const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> sub(const typed::pw_aff<pair<T1, T2>, pair<Range, Range2>> &pma2) const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> subtract_domain(const typed::set<pair<T1, T2>> &set) const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> subtract_domain(const typed::space<pair<T1, T2>> &space) const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> subtract_domain(const typed::union_set<pair<T1, T2>> &uset) const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> subtract_domain(const typed::basic_set<pair<T1, T2>> &set) const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> subtract_domain(const typed::point<pair<T1, T2>> &set) const;
  inline typed::multi_pw_aff<pair<T1, T2>, pair<Range, Range2>> to_multi_pw_aff() const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> to_union_pw_multi_aff() const;
  inline typed::multi_pw_aff<pair<T1, T2>, pair<Range, Range2>> unbind_params_insert_domain(const typed::multi_id<> &domain) const = delete;
  inline typed::multi_pw_aff<pair<T1, T2>, pair<Range, Range2>> union_add(const typed::multi_pw_aff<pair<T1, T2>, pair<Range, Range2>> &mpa2) const;
  inline typed::multi_union_pw_aff<pair<T1, T2>, pair<Range, Range2>> union_add(const typed::multi_union_pw_aff<pair<T1, T2>, pair<Range, Range2>> &mupa2) const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> union_add(const typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> &pma2) const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> union_add(const typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> &upma2) const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> union_add(const typed::multi_aff<pair<T1, T2>, pair<Range, Range2>> &pma2) const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> union_add(const typed::pw_aff<pair<T1, T2>, pair<Range, Range2>> &pma2) const;
};

template <typename Domain>
struct pw_multi_aff_list<Domain> : public isl::pw_multi_aff_list {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  pw_multi_aff_list() = default;
  template <typename Arg1,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{},
            bool>::type = true>
  pw_multi_aff_list(const pw_multi_aff_list<Arg1> &obj) : isl::pw_multi_aff_list(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::pw_multi_aff_list>{}, bool>::type = true>
  pw_multi_aff_list(const base &obj) : isl::pw_multi_aff_list(obj) {}
 public:
  static pw_multi_aff_list from(const isl::pw_multi_aff_list &obj) {
    return pw_multi_aff_list(obj);
  }
  inline explicit pw_multi_aff_list(const isl::ctx &ctx, int n);
  inline explicit pw_multi_aff_list(const typed::pw_multi_aff<Domain> &el);
  inline explicit pw_multi_aff_list(const isl::ctx &ctx, const std::string &str);
  inline typed::pw_multi_aff_list<Domain> add(const typed::pw_multi_aff<Domain> &el) const;
  inline typed::pw_multi_aff_list<Domain> add(const typed::multi_aff<Domain> &el) const;
  inline typed::pw_multi_aff_list<Domain> add(const typed::pw_aff<Domain> &el) const;
  inline typed::pw_multi_aff<Domain> at(int index) const;
  inline typed::pw_multi_aff<Domain> get_at(int index) const = delete;
  inline typed::pw_multi_aff_list<Domain> drop(unsigned int first, unsigned int n) const;
  inline void foreach(const std::function<void(typed::pw_multi_aff<Domain>)> &fn) const;
  inline void foreach_scc(const std::function<bool(typed::pw_multi_aff<Domain>, typed::pw_multi_aff<Domain>)> &follows, const std::function<void(typed::pw_multi_aff_list<Domain>)> &fn) const;
  inline typed::pw_multi_aff_list<Domain> set_at(int index, const typed::pw_multi_aff<Anonymous> &el) const;
};

template <typename Domain, typename Range>
struct pw_multi_aff_list<Domain, Range> : public isl::pw_multi_aff_list {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  pw_multi_aff_list() = default;
  template <typename Arg1, typename Arg2,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{} &&
              std::is_base_of<Range, Arg2>{},
            bool>::type = true>
  pw_multi_aff_list(const pw_multi_aff_list<Arg1, Arg2> &obj) : isl::pw_multi_aff_list(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::pw_multi_aff_list>{}, bool>::type = true>
  pw_multi_aff_list(const base &obj) : isl::pw_multi_aff_list(obj) {}
 public:
  static pw_multi_aff_list from(const isl::pw_multi_aff_list &obj) {
    return pw_multi_aff_list(obj);
  }
  inline explicit pw_multi_aff_list(const isl::ctx &ctx, int n);
  inline explicit pw_multi_aff_list(const typed::pw_multi_aff<Domain, Range> &el);
  inline explicit pw_multi_aff_list(const isl::ctx &ctx, const std::string &str);
  inline typed::pw_multi_aff_list<Domain, Range> add(const typed::pw_multi_aff<Domain, Range> &el) const;
  inline typed::pw_multi_aff_list<Domain, Range> add(const typed::multi_aff<Domain, Range> &el) const;
  inline typed::pw_multi_aff_list<Domain, Range> add(const typed::pw_aff<Domain, Range> &el) const;
  inline typed::pw_multi_aff<Domain, Range> at(int index) const;
  inline typed::pw_multi_aff<Domain, Range> get_at(int index) const = delete;
  inline typed::pw_multi_aff_list<Domain, Range> drop(unsigned int first, unsigned int n) const;
  inline void foreach(const std::function<void(typed::pw_multi_aff<Domain, Range>)> &fn) const;
  inline void foreach_scc(const std::function<bool(typed::pw_multi_aff<Domain, Range>, typed::pw_multi_aff<Domain, Range>)> &follows, const std::function<void(typed::pw_multi_aff_list<Domain, Range>)> &fn) const;
  inline typed::pw_multi_aff_list<Domain, Range> set_at(int index, const typed::pw_multi_aff<Domain, Anonymous> &el) const;
};

template <>
struct set<> : public isl::set {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  set() = default;
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::set>{}, bool>::type = true>
  set(const base &obj) : isl::set(obj) {}
 public:
  static set from(const isl::set &obj) {
    return set(obj);
  }
  inline /* implicit */ set(const typed::basic_set<> &bset);
  inline /* implicit */ set(const typed::point<> &pnt);
  inline explicit set(const isl::ctx &ctx, const std::string &str);
  inline typed::set<> apply(const typed::map<> &map) const = delete;
  inline typed::union_set<> apply(const typed::union_map<> &umap) const = delete;
  inline typed::set<> apply(const typed::basic_map<> &map) const = delete;
  inline typed::pw_multi_aff<> as_pw_multi_aff() const = delete;
  inline typed::set<> as_set() const = delete;
  inline typed::set<> bind(const typed::multi_id<> &tuple) const = delete;
  inline typed::set<> coalesce() const;
  inline typed::set<> detect_equalities() const;
  inline typed::set<> drop_unused_params() const;
  inline bool every_set(const std::function<bool(typed::set<>)> &test) const;
  inline typed::set<> extract_set(const typed::space<> &space) const;
  inline void foreach_basic_set(const std::function<void(typed::basic_set<>)> &fn) const;
  inline void foreach_point(const std::function<void(typed::point<>)> &fn) const;
  inline void foreach_set(const std::function<void(typed::set<>)> &fn) const;
  inline typed::set<> gist(const typed::set<> &context) const;
  inline typed::union_set<> gist(const typed::union_set<> &context) const;
  inline typed::set<> gist(const typed::basic_set<> &context) const;
  inline typed::set<> gist(const typed::point<> &context) const;
  inline typed::set<> gist_params(const typed::set<> &context) const = delete;
  inline typed::set<> gist_params(const typed::basic_set<> &context) const = delete;
  inline typed::set<> gist_params(const typed::point<> &context) const = delete;
  inline typed::map<> identity() const = delete;
  inline typed::pw_aff<Anonymous> indicator_function() const;
  inline typed::map<> insert_domain(const typed::space<> &domain) const = delete;
  inline typed::set<> intersect(const typed::set<> &set2) const;
  inline typed::union_set<> intersect(const typed::union_set<> &uset2) const;
  inline typed::set<> intersect(const typed::basic_set<> &set2) const;
  inline typed::set<> intersect(const typed::point<> &set2) const;
  inline typed::set<> intersect_params(const typed::set<> &params) const = delete;
  inline typed::set<> intersect_params(const typed::basic_set<> &params) const = delete;
  inline typed::set<> intersect_params(const typed::point<> &params) const = delete;
  inline typed::fixed_box<> lattice_tile() const = delete;
  inline typed::fixed_box<> get_lattice_tile() const = delete;
  inline typed::set<> lexmax() const = delete;
  inline typed::pw_multi_aff<> lexmax_pw_multi_aff() const = delete;
  inline typed::set<> lexmin() const = delete;
  inline typed::pw_multi_aff<> lexmin_pw_multi_aff() const = delete;
  inline typed::set<> lower_bound(const typed::multi_pw_aff<> &lower) const = delete;
  inline typed::set<> lower_bound(const typed::multi_val<> &lower) const = delete;
  inline typed::multi_pw_aff<> max_multi_pw_aff() const = delete;
  inline typed::val<> max_val(const typed::aff<> &obj) const = delete;
  inline typed::multi_pw_aff<> min_multi_pw_aff() const = delete;
  inline typed::val<> min_val(const typed::aff<> &obj) const = delete;
  inline typed::pw_aff<Anonymous> param_pw_aff_on_domain(const typed::id<Anonymous> &id) const;
  inline typed::pw_aff<Anonymous> param_pw_aff_on_domain(const std::string &id) const;
  inline typed::set<> params() const = delete;
  inline typed::multi_val<> plain_multi_val_if_fixed() const = delete;
  inline typed::multi_val<> get_plain_multi_val_if_fixed() const = delete;
  inline typed::set<> preimage(const typed::multi_aff<> &ma) const = delete;
  inline typed::set<> preimage(const typed::multi_pw_aff<> &mpa) const = delete;
  inline typed::set<> preimage(const typed::pw_multi_aff<> &pma) const = delete;
  inline typed::union_set<> preimage(const typed::union_pw_multi_aff<> &upma) const = delete;
  inline typed::set<> product(const typed::set<> &set2) const = delete;
  inline typed::set<> product(const typed::basic_set<> &set2) const = delete;
  inline typed::set<> product(const typed::point<> &set2) const = delete;
  inline typed::set<> project_out_all_params() const;
  inline typed::set<> project_out_param(const typed::id<Anonymous> &id) const;
  inline typed::set<> project_out_param(const std::string &id) const;
  inline typed::set<> project_out_param(const typed::id_list<Anonymous> &list) const;
  inline typed::pw_aff<Anonymous> pw_aff_on_domain(const typed::val<Anonymous> &v) const;
  inline typed::pw_aff<Anonymous> pw_aff_on_domain(long v) const;
  template <typename Domain>
  inline typed::pw_multi_aff<Domain> pw_multi_aff_on_domain(const typed::multi_val<Domain> &mv) const;
  inline typed::set_list<> set_list() const;
  inline typed::fixed_box<> simple_fixed_box_hull() const = delete;
  inline typed::fixed_box<> get_simple_fixed_box_hull() const = delete;
  inline typed::space<> space() const;
  inline typed::space<> get_space() const = delete;
  inline typed::val<> get_stride(int pos) const = delete;
  inline typed::set<> subtract(const typed::set<> &set2) const;
  inline typed::union_set<> subtract(const typed::union_set<> &uset2) const;
  inline typed::set<> subtract(const typed::basic_set<> &set2) const;
  inline typed::set<> subtract(const typed::point<> &set2) const;
  inline typed::union_set<> to_union_set() const;
  inline typed::map<> translation() const = delete;
  template <typename Domain>
  inline typed::set<Domain> unbind_params(const typed::multi_id<Domain> &tuple) const;
  inline typed::map<> unbind_params_insert_domain(const typed::multi_id<> &domain) const = delete;
  inline typed::set<> unite(const typed::set<> &set2) const;
  inline typed::union_set<> unite(const typed::union_set<> &uset2) const;
  inline typed::set<> unite(const typed::basic_set<> &set2) const;
  inline typed::set<> unite(const typed::point<> &set2) const;
  static inline typed::set<> universe(const typed::space<> &space);
  inline typed::map<> unwrap() const = delete;
  inline typed::set<> upper_bound(const typed::multi_pw_aff<> &upper) const = delete;
  inline typed::set<> upper_bound(const typed::multi_val<> &upper) const = delete;
  inline typed::set<> wrapped_reverse() const = delete;
};

template <typename Domain>
struct set<Domain> : public isl::set {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  set() = default;
  template <typename Arg1,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{},
            bool>::type = true>
  set(const set<Arg1> &obj) : isl::set(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::set>{}, bool>::type = true>
  set(const base &obj) : isl::set(obj) {}
 public:
  static set from(const isl::set &obj) {
    return set(obj);
  }
  inline /* implicit */ set(const typed::basic_set<Domain> &bset);
  inline /* implicit */ set(const typed::point<Domain> &pnt);
  inline explicit set(const isl::ctx &ctx, const std::string &str);
  template <typename Range>
  inline typed::set<Range> apply(const typed::map<Domain, Range> &map) const;
  template <typename Range>
  inline typed::union_set<Range> apply(const typed::union_map<Domain, Range> &umap) const;
  template <typename Range>
  inline typed::set<Range> apply(const typed::basic_map<Domain, Range> &map) const;
  inline typed::pw_multi_aff<Domain> as_pw_multi_aff() const;
  inline typed::set<Domain> as_set() const;
  inline typed::set<> bind(const typed::multi_id<Domain> &tuple) const;
  inline typed::set<Domain> coalesce() const;
  inline typed::set<Domain> detect_equalities() const;
  inline typed::set<Domain> drop_unused_params() const;
  inline bool every_set(const std::function<bool(typed::set<Domain>)> &test) const;
  inline typed::set<Domain> extract_set(const typed::space<Domain> &space) const;
  inline void foreach_basic_set(const std::function<void(typed::basic_set<Domain>)> &fn) const;
  inline void foreach_point(const std::function<void(typed::point<Domain>)> &fn) const;
  inline void foreach_set(const std::function<void(typed::set<Domain>)> &fn) const;
  inline typed::set<Domain> gist(const typed::set<Domain> &context) const;
  inline typed::union_set<Domain> gist(const typed::union_set<Domain> &context) const;
  inline typed::set<Domain> gist(const typed::basic_set<Domain> &context) const;
  inline typed::set<Domain> gist(const typed::point<Domain> &context) const;
  inline typed::set<Domain> gist_params(const typed::set<> &context) const;
  inline typed::set<Domain> gist_params(const typed::basic_set<> &context) const;
  inline typed::set<Domain> gist_params(const typed::point<> &context) const;
  inline typed::map<Domain, Domain> identity() const;
  inline typed::pw_aff<Domain, Anonymous> indicator_function() const;
  template <typename Arg1>
  inline typed::map<Arg1, Domain> insert_domain(const typed::space<Arg1> &domain) const;
  inline typed::set<Domain> intersect(const typed::set<Domain> &set2) const;
  inline typed::union_set<Domain> intersect(const typed::union_set<Domain> &uset2) const;
  inline typed::set<Domain> intersect(const typed::basic_set<Domain> &set2) const;
  inline typed::set<Domain> intersect(const typed::point<Domain> &set2) const;
  inline typed::set<Domain> intersect_params(const typed::set<> &params) const;
  inline typed::set<Domain> intersect_params(const typed::basic_set<> &params) const;
  inline typed::set<Domain> intersect_params(const typed::point<> &params) const;
  inline typed::fixed_box<Domain> lattice_tile() const;
  inline typed::fixed_box<Domain> get_lattice_tile() const = delete;
  inline typed::set<Domain> lexmax() const;
  inline typed::pw_multi_aff<Domain> lexmax_pw_multi_aff() const;
  inline typed::set<Domain> lexmin() const;
  inline typed::pw_multi_aff<Domain> lexmin_pw_multi_aff() const;
  inline typed::set<Domain> lower_bound(const typed::multi_pw_aff<Domain> &lower) const;
  inline typed::set<Domain> lower_bound(const typed::multi_val<Domain> &lower) const;
  inline typed::multi_pw_aff<Domain> max_multi_pw_aff() const;
  inline typed::val<Domain> max_val(const typed::aff<> &obj) const = delete;
  inline typed::multi_pw_aff<Domain> min_multi_pw_aff() const;
  inline typed::val<Domain> min_val(const typed::aff<> &obj) const = delete;
  inline typed::pw_aff<Domain, Anonymous> param_pw_aff_on_domain(const typed::id<Anonymous> &id) const;
  inline typed::pw_aff<Domain, Anonymous> param_pw_aff_on_domain(const std::string &id) const;
  inline typed::set<> params() const;
  inline typed::multi_val<Domain> plain_multi_val_if_fixed() const;
  inline typed::multi_val<Domain> get_plain_multi_val_if_fixed() const = delete;
  template <typename Domain2>
  inline typed::set<Domain2> preimage(const typed::multi_aff<Domain2, Domain> &ma) const;
  template <typename Domain2>
  inline typed::set<Domain2> preimage(const typed::multi_pw_aff<Domain2, Domain> &mpa) const;
  template <typename Domain2>
  inline typed::set<Domain2> preimage(const typed::pw_multi_aff<Domain2, Domain> &pma) const;
  template <typename Domain2>
  inline typed::union_set<Domain2> preimage(const typed::union_pw_multi_aff<Domain2, Domain> &upma) const;
  template <typename Range>
  inline typed::set<pair<Domain, Range>> product(const typed::set<Range> &set2) const;
  template <typename Range>
  inline typed::set<pair<Domain, Range>> product(const typed::basic_set<Range> &set2) const;
  template <typename Range>
  inline typed::set<pair<Domain, Range>> product(const typed::point<Range> &set2) const;
  inline typed::set<Domain> project_out_all_params() const;
  inline typed::set<Domain> project_out_param(const typed::id<Anonymous> &id) const;
  inline typed::set<Domain> project_out_param(const std::string &id) const;
  inline typed::set<Domain> project_out_param(const typed::id_list<Anonymous> &list) const;
  inline typed::pw_aff<Domain, Anonymous> pw_aff_on_domain(const typed::val<Anonymous> &v) const;
  inline typed::pw_aff<Domain, Anonymous> pw_aff_on_domain(long v) const;
  template <typename Range>
  inline typed::pw_multi_aff<Domain, Range> pw_multi_aff_on_domain(const typed::multi_val<Range> &mv) const;
  inline typed::set_list<Domain> set_list() const;
  inline typed::fixed_box<Domain> simple_fixed_box_hull() const;
  inline typed::fixed_box<Domain> get_simple_fixed_box_hull() const = delete;
  inline typed::space<Domain> space() const;
  inline typed::space<Domain> get_space() const = delete;
  inline typed::val<Domain> get_stride(int pos) const = delete;
  inline typed::set<Domain> subtract(const typed::set<Domain> &set2) const;
  inline typed::union_set<Domain> subtract(const typed::union_set<Domain> &uset2) const;
  inline typed::set<Domain> subtract(const typed::basic_set<Domain> &set2) const;
  inline typed::set<Domain> subtract(const typed::point<Domain> &set2) const;
  inline typed::union_set<Domain> to_union_set() const;
  inline typed::map<Domain, Domain> translation() const;
  inline typed::set<Domain> unbind_params(const typed::multi_id<> &tuple) const = delete;
  template <typename Arg1>
  inline typed::map<Arg1, Domain> unbind_params_insert_domain(const typed::multi_id<Arg1> &domain) const;
  inline typed::set<Domain> unite(const typed::set<Domain> &set2) const;
  inline typed::union_set<Domain> unite(const typed::union_set<Domain> &uset2) const;
  inline typed::set<Domain> unite(const typed::basic_set<Domain> &set2) const;
  inline typed::set<Domain> unite(const typed::point<Domain> &set2) const;
  static inline typed::set<Domain> universe(const typed::space<Domain> &space);
  inline typed::map<Domain> unwrap() const = delete;
  inline typed::set<Domain> upper_bound(const typed::multi_pw_aff<Domain> &upper) const;
  inline typed::set<Domain> upper_bound(const typed::multi_val<Domain> &upper) const;
  inline typed::set<Domain> wrapped_reverse() const = delete;
};

template <typename Domain, typename Range>
struct set<pair<Domain, Range>> : public isl::set {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  set() = default;
  template <typename Arg1, typename Arg2,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{} &&
              std::is_base_of<Range, Arg2>{},
            bool>::type = true>
  set(const set<pair<Arg1, Arg2>> &obj) : isl::set(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::set>{}, bool>::type = true>
  set(const base &obj) : isl::set(obj) {}
 public:
  static set from(const isl::set &obj) {
    return set(obj);
  }
  inline /* implicit */ set(const typed::basic_set<pair<Domain, Range>> &bset);
  inline /* implicit */ set(const typed::point<pair<Domain, Range>> &pnt);
  inline explicit set(const isl::ctx &ctx, const std::string &str);
  template <typename Arg2>
  inline typed::set<Arg2> apply(const typed::map<pair<Domain, Range>, Arg2> &map) const;
  template <typename Arg2>
  inline typed::union_set<Arg2> apply(const typed::union_map<pair<Domain, Range>, Arg2> &umap) const;
  template <typename Arg2>
  inline typed::set<Arg2> apply(const typed::basic_map<pair<Domain, Range>, Arg2> &map) const;
  inline typed::pw_multi_aff<pair<Domain, Range>> as_pw_multi_aff() const;
  inline typed::set<pair<Domain, Range>> as_set() const;
  inline typed::set<> bind(const typed::multi_id<pair<Domain, Range>> &tuple) const;
  inline typed::set<pair<Domain, Range>> coalesce() const;
  inline typed::set<pair<Domain, Range>> detect_equalities() const;
  inline typed::set<pair<Domain, Range>> drop_unused_params() const;
  inline bool every_set(const std::function<bool(typed::set<pair<Domain, Range>>)> &test) const;
  inline typed::set<pair<Domain, Range>> extract_set(const typed::space<pair<Domain, Range>> &space) const;
  inline void foreach_basic_set(const std::function<void(typed::basic_set<pair<Domain, Range>>)> &fn) const;
  inline void foreach_point(const std::function<void(typed::point<pair<Domain, Range>>)> &fn) const;
  inline void foreach_set(const std::function<void(typed::set<pair<Domain, Range>>)> &fn) const;
  inline typed::set<pair<Domain, Range>> gist(const typed::set<pair<Domain, Range>> &context) const;
  inline typed::union_set<pair<Domain, Range>> gist(const typed::union_set<pair<Domain, Range>> &context) const;
  inline typed::set<pair<Domain, Range>> gist(const typed::basic_set<pair<Domain, Range>> &context) const;
  inline typed::set<pair<Domain, Range>> gist(const typed::point<pair<Domain, Range>> &context) const;
  inline typed::set<pair<Domain, Range>> gist_params(const typed::set<> &context) const;
  inline typed::set<pair<Domain, Range>> gist_params(const typed::basic_set<> &context) const;
  inline typed::set<pair<Domain, Range>> gist_params(const typed::point<> &context) const;
  inline typed::map<pair<Domain, Range>, pair<Domain, Range>> identity() const;
  inline typed::pw_aff<pair<Domain, Range>, Anonymous> indicator_function() const;
  template <typename Arg2>
  inline typed::map<Arg2, pair<Domain, Range>> insert_domain(const typed::space<Arg2> &domain) const;
  inline typed::set<pair<Domain, Range>> intersect(const typed::set<pair<Domain, Range>> &set2) const;
  inline typed::union_set<pair<Domain, Range>> intersect(const typed::union_set<pair<Domain, Range>> &uset2) const;
  inline typed::set<pair<Domain, Range>> intersect(const typed::basic_set<pair<Domain, Range>> &set2) const;
  inline typed::set<pair<Domain, Range>> intersect(const typed::point<pair<Domain, Range>> &set2) const;
  inline typed::set<pair<Domain, Range>> intersect_params(const typed::set<> &params) const;
  inline typed::set<pair<Domain, Range>> intersect_params(const typed::basic_set<> &params) const;
  inline typed::set<pair<Domain, Range>> intersect_params(const typed::point<> &params) const;
  inline typed::fixed_box<pair<Domain, Range>> lattice_tile() const;
  inline typed::fixed_box<pair<Domain, Range>> get_lattice_tile() const = delete;
  inline typed::set<pair<Domain, Range>> lexmax() const;
  inline typed::pw_multi_aff<pair<Domain, Range>> lexmax_pw_multi_aff() const;
  inline typed::set<pair<Domain, Range>> lexmin() const;
  inline typed::pw_multi_aff<pair<Domain, Range>> lexmin_pw_multi_aff() const;
  inline typed::set<pair<Domain, Range>> lower_bound(const typed::multi_pw_aff<pair<Domain, Range>> &lower) const;
  inline typed::set<pair<Domain, Range>> lower_bound(const typed::multi_val<pair<Domain, Range>> &lower) const;
  inline typed::multi_pw_aff<pair<Domain, Range>> max_multi_pw_aff() const;
  inline typed::val<pair<Domain, Range>> max_val(const typed::aff<> &obj) const = delete;
  inline typed::multi_pw_aff<pair<Domain, Range>> min_multi_pw_aff() const;
  inline typed::val<pair<Domain, Range>> min_val(const typed::aff<> &obj) const = delete;
  inline typed::pw_aff<pair<Domain, Range>, Anonymous> param_pw_aff_on_domain(const typed::id<Anonymous> &id) const;
  inline typed::pw_aff<pair<Domain, Range>, Anonymous> param_pw_aff_on_domain(const std::string &id) const;
  inline typed::set<> params() const;
  inline typed::multi_val<pair<Domain, Range>> plain_multi_val_if_fixed() const;
  inline typed::multi_val<pair<Domain, Range>> get_plain_multi_val_if_fixed() const = delete;
  template <typename Domain2>
  inline typed::set<Domain2> preimage(const typed::multi_aff<Domain2, pair<Domain, Range>> &ma) const;
  template <typename Domain2>
  inline typed::set<Domain2> preimage(const typed::multi_pw_aff<Domain2, pair<Domain, Range>> &mpa) const;
  template <typename Domain2>
  inline typed::set<Domain2> preimage(const typed::pw_multi_aff<Domain2, pair<Domain, Range>> &pma) const;
  template <typename Domain2>
  inline typed::union_set<Domain2> preimage(const typed::union_pw_multi_aff<Domain2, pair<Domain, Range>> &upma) const;
  template <typename Arg2>
  inline typed::set<pair<pair<Domain, Range>, Arg2>> product(const typed::set<Arg2> &set2) const;
  template <typename Arg2>
  inline typed::set<pair<pair<Domain, Range>, Arg2>> product(const typed::basic_set<Arg2> &set2) const;
  template <typename Arg2>
  inline typed::set<pair<pair<Domain, Range>, Arg2>> product(const typed::point<Arg2> &set2) const;
  inline typed::set<pair<Domain, Range>> project_out_all_params() const;
  inline typed::set<pair<Domain, Range>> project_out_param(const typed::id<Anonymous> &id) const;
  inline typed::set<pair<Domain, Range>> project_out_param(const std::string &id) const;
  inline typed::set<pair<Domain, Range>> project_out_param(const typed::id_list<Anonymous> &list) const;
  inline typed::pw_aff<pair<Domain, Range>, Anonymous> pw_aff_on_domain(const typed::val<Anonymous> &v) const;
  inline typed::pw_aff<pair<Domain, Range>, Anonymous> pw_aff_on_domain(long v) const;
  template <typename Arg2>
  inline typed::pw_multi_aff<pair<Domain, Range>, Arg2> pw_multi_aff_on_domain(const typed::multi_val<Arg2> &mv) const;
  inline typed::set_list<pair<Domain, Range>> set_list() const;
  inline typed::fixed_box<pair<Domain, Range>> simple_fixed_box_hull() const;
  inline typed::fixed_box<pair<Domain, Range>> get_simple_fixed_box_hull() const = delete;
  inline typed::space<pair<Domain, Range>> space() const;
  inline typed::space<pair<Domain, Range>> get_space() const = delete;
  inline typed::val<pair<Domain, Range>> get_stride(int pos) const = delete;
  inline typed::set<pair<Domain, Range>> subtract(const typed::set<pair<Domain, Range>> &set2) const;
  inline typed::union_set<pair<Domain, Range>> subtract(const typed::union_set<pair<Domain, Range>> &uset2) const;
  inline typed::set<pair<Domain, Range>> subtract(const typed::basic_set<pair<Domain, Range>> &set2) const;
  inline typed::set<pair<Domain, Range>> subtract(const typed::point<pair<Domain, Range>> &set2) const;
  inline typed::union_set<pair<Domain, Range>> to_union_set() const;
  inline typed::map<pair<Domain, Range>, pair<Domain, Range>> translation() const;
  inline typed::set<pair<Domain, Range>> unbind_params(const typed::multi_id<> &tuple) const = delete;
  template <typename Arg2>
  inline typed::map<Arg2, pair<Domain, Range>> unbind_params_insert_domain(const typed::multi_id<Arg2> &domain) const;
  inline typed::set<pair<Domain, Range>> unite(const typed::set<pair<Domain, Range>> &set2) const;
  inline typed::union_set<pair<Domain, Range>> unite(const typed::union_set<pair<Domain, Range>> &uset2) const;
  inline typed::set<pair<Domain, Range>> unite(const typed::basic_set<pair<Domain, Range>> &set2) const;
  inline typed::set<pair<Domain, Range>> unite(const typed::point<pair<Domain, Range>> &set2) const;
  static inline typed::set<pair<Domain, Range>> universe(const typed::space<pair<Domain, Range>> &space);
  inline typed::map<Domain, Range> unwrap() const;
  inline typed::set<pair<Domain, Range>> upper_bound(const typed::multi_pw_aff<pair<Domain, Range>> &upper) const;
  inline typed::set<pair<Domain, Range>> upper_bound(const typed::multi_val<pair<Domain, Range>> &upper) const;
  inline typed::set<pair<Range, Domain>> wrapped_reverse() const;
};

template <>
struct set_list<> : public isl::set_list {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  set_list() = default;
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::set_list>{}, bool>::type = true>
  set_list(const base &obj) : isl::set_list(obj) {}
 public:
  static set_list from(const isl::set_list &obj) {
    return set_list(obj);
  }
  inline explicit set_list(const isl::ctx &ctx, int n);
  inline explicit set_list(const typed::set<> &el);
  inline explicit set_list(const isl::ctx &ctx, const std::string &str);
  inline typed::set_list<> add(const typed::set<> &el) const;
  inline typed::set_list<> add(const typed::basic_set<> &el) const;
  inline typed::set_list<> add(const typed::point<> &el) const;
  inline typed::set<> at(int index) const = delete;
  inline typed::set<> get_at(int index) const = delete;
  inline typed::set_list<> drop(unsigned int first, unsigned int n) const;
  inline void foreach(const std::function<void(typed::set<>)> &fn) const;
  inline void foreach_scc(const std::function<bool(typed::set<>, typed::set<>)> &follows, const std::function<void(typed::set_list<>)> &fn) const;
  inline typed::set_list<> set_at(int index, const typed::set<> &el) const = delete;
};

template <typename Domain>
struct set_list<Domain> : public isl::set_list {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  set_list() = default;
  template <typename Arg1,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{},
            bool>::type = true>
  set_list(const set_list<Arg1> &obj) : isl::set_list(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::set_list>{}, bool>::type = true>
  set_list(const base &obj) : isl::set_list(obj) {}
 public:
  static set_list from(const isl::set_list &obj) {
    return set_list(obj);
  }
  inline explicit set_list(const isl::ctx &ctx, int n);
  inline explicit set_list(const typed::set<Domain> &el);
  inline explicit set_list(const isl::ctx &ctx, const std::string &str);
  inline typed::set_list<Domain> add(const typed::set<Domain> &el) const;
  inline typed::set_list<Domain> add(const typed::basic_set<Domain> &el) const;
  inline typed::set_list<Domain> add(const typed::point<Domain> &el) const;
  inline typed::set<Domain> at(int index) const;
  inline typed::set<Domain> get_at(int index) const = delete;
  inline typed::set_list<Domain> drop(unsigned int first, unsigned int n) const;
  inline void foreach(const std::function<void(typed::set<Domain>)> &fn) const;
  inline void foreach_scc(const std::function<bool(typed::set<Domain>, typed::set<Domain>)> &follows, const std::function<void(typed::set_list<Domain>)> &fn) const;
  inline typed::set_list<Domain> set_at(int index, const typed::set<Anonymous> &el) const;
};

template <>
struct space<> : public isl::space {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  space() = default;
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::space>{}, bool>::type = true>
  space(const base &obj) : isl::space(obj) {}
 public:
  static space from(const isl::space &obj) {
    return space(obj);
  }
  inline explicit space(const isl::ctx &ctx, const std::string &str);
  template <typename Domain>
  inline typed::space<Domain> add_named_tuple(const typed::id<Anonymous> &tuple_id, unsigned int dim) const;
  template <typename Domain>
  inline typed::space<Domain> add_named_tuple(const std::string &tuple_id, unsigned int dim) const;
  inline typed::space<> add_param(const typed::id<Anonymous> &id) const;
  inline typed::space<> add_param(const std::string &id) const;
  template <typename Domain>
  inline typed::space<Domain> add_unnamed_tuple(unsigned int dim) const;
  inline typed::space<> curry() const = delete;
  inline typed::space<> domain() const = delete;
  inline typed::multi_aff<> domain_map_multi_aff() const = delete;
  inline typed::pw_multi_aff<> domain_map_pw_multi_aff() const = delete;
  inline typed::space<> domain_reverse() const = delete;
  inline typed::id<> get_domain_tuple_id() const = delete;
  inline typed::space<> drop_all_params() const;
  inline typed::space<> flatten_domain() const = delete;
  inline typed::space<> flatten_range() const = delete;
  inline typed::multi_aff<> identity_multi_aff_on_domain() const = delete;
  inline typed::multi_pw_aff<> identity_multi_pw_aff_on_domain() const = delete;
  inline typed::pw_multi_aff<> identity_pw_multi_aff_on_domain() const = delete;
  inline typed::space<> map_from_set() const = delete;
  inline typed::multi_aff<> multi_aff(const typed::aff_list<> &list) const = delete;
  template <typename Domain>
  inline typed::multi_aff<Domain> multi_aff_on_domain(const typed::multi_val<Domain> &mv) const;
  inline typed::multi_id<> multi_id(const typed::id_list<> &list) const = delete;
  inline typed::multi_pw_aff<> multi_pw_aff(const typed::pw_aff_list<> &list) const = delete;
  inline typed::multi_union_pw_aff<> multi_union_pw_aff(const typed::union_pw_aff_list<> &list) const = delete;
  inline typed::multi_val<> multi_val(const typed::val_list<> &list) const = delete;
  inline typed::aff<Anonymous> param_aff_on_domain(const typed::id<Anonymous> &id) const;
  inline typed::aff<Anonymous> param_aff_on_domain(const std::string &id) const;
  inline typed::space<> params() const = delete;
  inline typed::space<> product(const typed::space<> &right) const = delete;
  inline typed::space<> range() const = delete;
  inline typed::multi_aff<> range_map_multi_aff() const = delete;
  inline typed::pw_multi_aff<> range_map_pw_multi_aff() const = delete;
  inline typed::space<> range_reverse() const = delete;
  inline typed::id<> get_range_tuple_id() const = delete;
  inline typed::space<> reverse() const = delete;
  inline typed::space<> set_domain_tuple(const typed::id<> &id) const = delete;
  inline typed::space<> set_domain_tuple(const std::string &id) const = delete;
  inline typed::space<> set_range_tuple(const typed::id<> &id) const = delete;
  inline typed::space<> set_range_tuple(const std::string &id) const = delete;
  inline typed::space<> uncurry() const = delete;
  static inline typed::space<> unit(const isl::ctx &ctx);
  inline typed::map<> universe_map() const = delete;
  inline typed::set<> universe_set() const;
  inline typed::space<> unwrap() const = delete;
  inline typed::space<> wrap() const = delete;
  inline typed::space<> wrapped_reverse() const = delete;
  inline typed::aff<> zero_aff_on_domain() const = delete;
  inline typed::multi_aff<> zero_multi_aff() const = delete;
  inline typed::multi_pw_aff<> zero_multi_pw_aff() const = delete;
  inline typed::multi_union_pw_aff<> zero_multi_union_pw_aff() const = delete;
  inline typed::multi_val<> zero_multi_val() const = delete;
};

template <typename Domain>
struct space<Domain> : public isl::space {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  space() = default;
  template <typename Arg1,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{},
            bool>::type = true>
  space(const space<Arg1> &obj) : isl::space(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::space>{}, bool>::type = true>
  space(const base &obj) : isl::space(obj) {}
 public:
  static space from(const isl::space &obj) {
    return space(obj);
  }
  inline explicit space(const isl::ctx &ctx, const std::string &str);
  template <typename Range>
  inline typed::space<Domain, Range> add_named_tuple(const typed::id<Anonymous> &tuple_id, unsigned int dim) const;
  template <typename Range>
  inline typed::space<Domain, Range> add_named_tuple(const std::string &tuple_id, unsigned int dim) const;
  inline typed::space<Domain> add_param(const typed::id<Anonymous> &id) const;
  inline typed::space<Domain> add_param(const std::string &id) const;
  template <typename Range>
  inline typed::space<Domain, Range> add_unnamed_tuple(unsigned int dim) const;
  inline typed::space<Domain> curry() const = delete;
  inline typed::space<> domain() const;
  inline typed::multi_aff<Domain> domain_map_multi_aff() const = delete;
  inline typed::pw_multi_aff<Domain> domain_map_pw_multi_aff() const = delete;
  inline typed::space<Domain> domain_reverse() const = delete;
  inline typed::id<Domain> get_domain_tuple_id() const = delete;
  inline typed::space<Domain> drop_all_params() const;
  inline typed::space<Domain> flatten_domain() const = delete;
  inline typed::space<Domain> flatten_range() const = delete;
  inline typed::multi_aff<Domain, Domain> identity_multi_aff_on_domain() const;
  inline typed::multi_pw_aff<Domain, Domain> identity_multi_pw_aff_on_domain() const;
  inline typed::pw_multi_aff<Domain, Domain> identity_pw_multi_aff_on_domain() const;
  inline typed::space<Domain, Domain> map_from_set() const;
  inline typed::multi_aff<Domain> multi_aff(const typed::aff_list<Anonymous> &list) const;
  template <typename Range>
  inline typed::multi_aff<Domain, Range> multi_aff_on_domain(const typed::multi_val<Range> &mv) const;
  inline typed::multi_id<Domain> multi_id(const typed::id_list<Anonymous> &list) const;
  inline typed::multi_pw_aff<Domain> multi_pw_aff(const typed::pw_aff_list<Anonymous> &list) const;
  inline typed::multi_union_pw_aff<Domain> multi_union_pw_aff(const typed::union_pw_aff_list<Anonymous> &list) const;
  template <typename Arg1>
  inline typed::multi_union_pw_aff<Arg1, Domain> multi_union_pw_aff(const typed::union_pw_aff_list<Arg1, Anonymous> &list) const;
  inline typed::multi_val<Domain> multi_val(const typed::val_list<Anonymous> &list) const;
  inline typed::aff<Domain, Anonymous> param_aff_on_domain(const typed::id<Anonymous> &id) const;
  inline typed::aff<Domain, Anonymous> param_aff_on_domain(const std::string &id) const;
  inline typed::space<> params() const;
  template <typename Range>
  inline typed::space<pair<Domain, Range>> product(const typed::space<Range> &right) const;
  inline typed::space<Domain> range() const = delete;
  inline typed::multi_aff<Domain> range_map_multi_aff() const = delete;
  inline typed::pw_multi_aff<Domain> range_map_pw_multi_aff() const = delete;
  inline typed::space<Domain> range_reverse() const = delete;
  inline typed::id<Domain> get_range_tuple_id() const = delete;
  inline typed::space<Domain> reverse() const = delete;
  inline typed::space<Domain> set_domain_tuple(const typed::id<> &id) const = delete;
  inline typed::space<Domain> set_domain_tuple(const std::string &id) const = delete;
  template <typename Domain2>
  inline typed::space<Domain2> set_range_tuple(const typed::id<Anonymous> &id) const;
  template <typename Domain2>
  inline typed::space<Domain2> set_range_tuple(const std::string &id) const;
  inline typed::space<Domain> uncurry() const = delete;
  static inline typed::space<Domain> unit(const isl::ctx &ctx) = delete;
  inline typed::map<Domain> universe_map() const = delete;
  inline typed::set<Domain> universe_set() const;
  inline typed::space<Domain> unwrap() const = delete;
  inline typed::space<Domain> wrap() const = delete;
  inline typed::space<Domain> wrapped_reverse() const = delete;
  inline typed::aff<Domain, Anonymous> zero_aff_on_domain() const;
  inline typed::multi_aff<Domain> zero_multi_aff() const;
  inline typed::multi_pw_aff<Domain> zero_multi_pw_aff() const;
  inline typed::multi_union_pw_aff<Domain> zero_multi_union_pw_aff() const;
  inline typed::multi_val<Domain> zero_multi_val() const;
};

template <typename Domain, typename Range>
struct space<Domain, Range> : public isl::space {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  space() = default;
  template <typename Arg1, typename Arg2,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{} &&
              std::is_base_of<Range, Arg2>{},
            bool>::type = true>
  space(const space<Arg1, Arg2> &obj) : isl::space(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::space>{}, bool>::type = true>
  space(const base &obj) : isl::space(obj) {}
 public:
  static space from(const isl::space &obj) {
    return space(obj);
  }
  inline explicit space(const isl::ctx &ctx, const std::string &str);
  inline typed::space<Domain, Range> add_named_tuple(const typed::id<> &tuple_id, unsigned int dim) const = delete;
  inline typed::space<Domain, Range> add_named_tuple(const std::string &tuple_id, unsigned int dim) const = delete;
  inline typed::space<Domain, Range> add_param(const typed::id<Anonymous> &id) const;
  inline typed::space<Domain, Range> add_param(const std::string &id) const;
  inline typed::space<Domain, Range> add_unnamed_tuple(unsigned int dim) const = delete;
  inline typed::space<Domain, Range> curry() const = delete;
  inline typed::space<Domain> domain() const;
  inline typed::multi_aff<pair<Domain, Range>, Domain> domain_map_multi_aff() const;
  inline typed::pw_multi_aff<pair<Domain, Range>, Domain> domain_map_pw_multi_aff() const;
  inline typed::space<Domain, Range> domain_reverse() const = delete;
  inline typed::id<Domain, Range> get_domain_tuple_id() const = delete;
  inline typed::space<Domain, Range> drop_all_params() const;
  inline typed::space<Domain, Range> flatten_domain() const = delete;
  inline typed::space<Domain, Range> flatten_range() const = delete;
  inline typed::multi_aff<Domain, Range> identity_multi_aff_on_domain() const = delete;
  inline typed::multi_pw_aff<Domain, Range> identity_multi_pw_aff_on_domain() const = delete;
  inline typed::pw_multi_aff<Domain, Range> identity_pw_multi_aff_on_domain() const = delete;
  inline typed::space<Domain, Range> map_from_set() const = delete;
  inline typed::multi_aff<Domain, Range> multi_aff(const typed::aff_list<Domain, Anonymous> &list) const;
  inline typed::multi_aff<Domain, Range> multi_aff_on_domain(const typed::multi_val<> &mv) const = delete;
  inline typed::multi_id<Domain, Range> multi_id(const typed::id_list<> &list) const = delete;
  inline typed::multi_pw_aff<Domain, Range> multi_pw_aff(const typed::pw_aff_list<Domain, Anonymous> &list) const;
  inline typed::multi_union_pw_aff<Domain, Range> multi_union_pw_aff(const typed::union_pw_aff_list<> &list) const = delete;
  inline typed::multi_val<Domain, Range> multi_val(const typed::val_list<> &list) const = delete;
  inline typed::aff<Domain, Range> param_aff_on_domain(const typed::id<> &id) const = delete;
  inline typed::aff<Domain, Range> param_aff_on_domain(const std::string &id) const = delete;
  inline typed::space<> params() const;
  template <typename Domain2, typename Range2>
  inline typed::space<pair<Domain, Domain2>, pair<Range, Range2>> product(const typed::space<Domain2, Range2> &right) const;
  inline typed::space<Range> range() const;
  inline typed::multi_aff<pair<Domain, Range>, Range> range_map_multi_aff() const;
  inline typed::pw_multi_aff<pair<Domain, Range>, Range> range_map_pw_multi_aff() const;
  inline typed::space<Domain, Range> range_reverse() const = delete;
  inline typed::id<Domain, Range> get_range_tuple_id() const = delete;
  inline typed::space<Range, Domain> reverse() const;
  template <typename Domain2>
  inline typed::space<Domain2, Range> set_domain_tuple(const typed::id<Anonymous> &id) const;
  template <typename Domain2>
  inline typed::space<Domain2, Range> set_domain_tuple(const std::string &id) const;
  template <typename Range2>
  inline typed::space<Domain, Range2> set_range_tuple(const typed::id<Anonymous> &id) const;
  template <typename Range2>
  inline typed::space<Domain, Range2> set_range_tuple(const std::string &id) const;
  inline typed::space<Domain, Range> uncurry() const = delete;
  static inline typed::space<Domain, Range> unit(const isl::ctx &ctx) = delete;
  inline typed::map<Domain, Range> universe_map() const;
  inline typed::set<Domain, Range> universe_set() const = delete;
  inline typed::space<Domain, Range> unwrap() const = delete;
  inline typed::space<pair<Domain, Range>> wrap() const;
  inline typed::space<Domain, Range> wrapped_reverse() const = delete;
  inline typed::aff<Domain, Range> zero_aff_on_domain() const = delete;
  inline typed::multi_aff<Domain, Range> zero_multi_aff() const;
  inline typed::multi_pw_aff<Domain, Range> zero_multi_pw_aff() const;
  inline typed::multi_union_pw_aff<Domain, Range> zero_multi_union_pw_aff() const;
  inline typed::multi_val<Domain, Range> zero_multi_val() const = delete;
};

template <typename Domain, typename Range>
struct space<pair<Domain, Range>> : public isl::space {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  space() = default;
  template <typename Arg1, typename Arg2,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{} &&
              std::is_base_of<Range, Arg2>{},
            bool>::type = true>
  space(const space<pair<Arg1, Arg2>> &obj) : isl::space(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::space>{}, bool>::type = true>
  space(const base &obj) : isl::space(obj) {}
 public:
  static space from(const isl::space &obj) {
    return space(obj);
  }
  inline explicit space(const isl::ctx &ctx, const std::string &str);
  template <typename Arg2>
  inline typed::space<pair<Domain, Range>, Arg2> add_named_tuple(const typed::id<Anonymous> &tuple_id, unsigned int dim) const;
  template <typename Arg2>
  inline typed::space<pair<Domain, Range>, Arg2> add_named_tuple(const std::string &tuple_id, unsigned int dim) const;
  inline typed::space<pair<Domain, Range>> add_param(const typed::id<Anonymous> &id) const;
  inline typed::space<pair<Domain, Range>> add_param(const std::string &id) const;
  template <typename Arg2>
  inline typed::space<pair<Domain, Range>, Arg2> add_unnamed_tuple(unsigned int dim) const;
  inline typed::space<pair<Domain, Range>> curry() const = delete;
  inline typed::space<> domain() const;
  inline typed::multi_aff<pair<Domain, Range>> domain_map_multi_aff() const = delete;
  inline typed::pw_multi_aff<pair<Domain, Range>> domain_map_pw_multi_aff() const = delete;
  inline typed::space<pair<Domain, Range>> domain_reverse() const = delete;
  inline typed::id<pair<Domain, Range>> get_domain_tuple_id() const = delete;
  inline typed::space<pair<Domain, Range>> drop_all_params() const;
  inline typed::space<pair<Domain, Range>> flatten_domain() const = delete;
  inline typed::space<pair<Domain, Range>> flatten_range() const = delete;
  inline typed::multi_aff<pair<Domain, Range>, pair<Domain, Range>> identity_multi_aff_on_domain() const;
  inline typed::multi_pw_aff<pair<Domain, Range>, pair<Domain, Range>> identity_multi_pw_aff_on_domain() const;
  inline typed::pw_multi_aff<pair<Domain, Range>, pair<Domain, Range>> identity_pw_multi_aff_on_domain() const;
  inline typed::space<pair<Domain, Range>, pair<Domain, Range>> map_from_set() const;
  inline typed::multi_aff<pair<Domain, Range>> multi_aff(const typed::aff_list<Anonymous> &list) const;
  template <typename Arg2>
  inline typed::multi_aff<pair<Domain, Range>, Arg2> multi_aff_on_domain(const typed::multi_val<Arg2> &mv) const;
  inline typed::multi_id<pair<Domain, Range>> multi_id(const typed::id_list<Anonymous> &list) const;
  inline typed::multi_pw_aff<pair<Domain, Range>> multi_pw_aff(const typed::pw_aff_list<Anonymous> &list) const;
  inline typed::multi_union_pw_aff<pair<Domain, Range>> multi_union_pw_aff(const typed::union_pw_aff_list<Anonymous> &list) const;
  template <typename Arg2>
  inline typed::multi_union_pw_aff<Arg2, pair<Domain, Range>> multi_union_pw_aff(const typed::union_pw_aff_list<Arg2, Anonymous> &list) const;
  inline typed::multi_val<pair<Domain, Range>> multi_val(const typed::val_list<Anonymous> &list) const;
  inline typed::aff<pair<Domain, Range>, Anonymous> param_aff_on_domain(const typed::id<Anonymous> &id) const;
  inline typed::aff<pair<Domain, Range>, Anonymous> param_aff_on_domain(const std::string &id) const;
  inline typed::space<> params() const;
  template <typename Arg2>
  inline typed::space<pair<pair<Domain, Range>, Arg2>> product(const typed::space<Arg2> &right) const;
  inline typed::space<pair<Domain, Range>> range() const = delete;
  inline typed::multi_aff<pair<Domain, Range>> range_map_multi_aff() const = delete;
  inline typed::pw_multi_aff<pair<Domain, Range>> range_map_pw_multi_aff() const = delete;
  inline typed::space<pair<Domain, Range>> range_reverse() const = delete;
  inline typed::id<pair<Domain, Range>> get_range_tuple_id() const = delete;
  inline typed::space<pair<Domain, Range>> reverse() const = delete;
  inline typed::space<pair<Domain, Range>> set_domain_tuple(const typed::id<> &id) const = delete;
  inline typed::space<pair<Domain, Range>> set_domain_tuple(const std::string &id) const = delete;
  inline typed::space<pair<Domain, Range>> set_range_tuple(const typed::id<> &id) const = delete;
  inline typed::space<pair<Domain, Range>> set_range_tuple(const std::string &id) const = delete;
  inline typed::space<pair<Domain, Range>> uncurry() const = delete;
  static inline typed::space<pair<Domain, Range>> unit(const isl::ctx &ctx) = delete;
  inline typed::map<pair<Domain, Range>> universe_map() const = delete;
  inline typed::set<pair<Domain, Range>> universe_set() const;
  inline typed::space<Domain, Range> unwrap() const;
  inline typed::space<pair<Domain, Range>> wrap() const = delete;
  inline typed::space<pair<Range, Domain>> wrapped_reverse() const;
  inline typed::aff<pair<Domain, Range>, Anonymous> zero_aff_on_domain() const;
  inline typed::multi_aff<pair<Domain, Range>> zero_multi_aff() const;
  inline typed::multi_pw_aff<pair<Domain, Range>> zero_multi_pw_aff() const;
  inline typed::multi_union_pw_aff<pair<Domain, Range>> zero_multi_union_pw_aff() const;
  inline typed::multi_val<pair<Domain, Range>> zero_multi_val() const;
};

template <typename Domain, typename Range, typename Range2>
struct space<pair<Domain, Range>, Range2> : public isl::space {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  space() = default;
  template <typename Arg1, typename Arg2, typename Arg3,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{} &&
              std::is_base_of<Range, Arg2>{} &&
              std::is_base_of<Range2, Arg3>{},
            bool>::type = true>
  space(const space<pair<Arg1, Arg2>, Arg3> &obj) : isl::space(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::space>{}, bool>::type = true>
  space(const base &obj) : isl::space(obj) {}
 public:
  static space from(const isl::space &obj) {
    return space(obj);
  }
  inline explicit space(const isl::ctx &ctx, const std::string &str);
  inline typed::space<pair<Domain, Range>, Range2> add_named_tuple(const typed::id<> &tuple_id, unsigned int dim) const = delete;
  inline typed::space<pair<Domain, Range>, Range2> add_named_tuple(const std::string &tuple_id, unsigned int dim) const = delete;
  inline typed::space<pair<Domain, Range>, Range2> add_param(const typed::id<Anonymous> &id) const;
  inline typed::space<pair<Domain, Range>, Range2> add_param(const std::string &id) const;
  inline typed::space<pair<Domain, Range>, Range2> add_unnamed_tuple(unsigned int dim) const = delete;
  inline typed::space<Domain, pair<Range, Range2>> curry() const;
  inline typed::space<pair<Domain, Range>> domain() const;
  inline typed::multi_aff<pair<pair<Domain, Range>, Range2>, pair<Domain, Range>> domain_map_multi_aff() const;
  inline typed::pw_multi_aff<pair<pair<Domain, Range>, Range2>, pair<Domain, Range>> domain_map_pw_multi_aff() const;
  inline typed::space<pair<Range, Domain>, Range2> domain_reverse() const;
  inline typed::id<pair<Domain, Range>, Range2> get_domain_tuple_id() const = delete;
  inline typed::space<pair<Domain, Range>, Range2> drop_all_params() const;
  inline typed::space<Anonymous, Range2> flatten_domain() const;
  inline typed::space<pair<Domain, Range>, Range2> flatten_range() const = delete;
  inline typed::multi_aff<pair<Domain, Range>, Range2> identity_multi_aff_on_domain() const = delete;
  inline typed::multi_pw_aff<pair<Domain, Range>, Range2> identity_multi_pw_aff_on_domain() const = delete;
  inline typed::pw_multi_aff<pair<Domain, Range>, Range2> identity_pw_multi_aff_on_domain() const = delete;
  inline typed::space<pair<Domain, Range>, Range2> map_from_set() const = delete;
  inline typed::multi_aff<pair<Domain, Range>, Range2> multi_aff(const typed::aff_list<pair<Domain, Range>, Anonymous> &list) const;
  inline typed::multi_aff<pair<Domain, Range>, Range2> multi_aff_on_domain(const typed::multi_val<> &mv) const = delete;
  inline typed::multi_id<pair<Domain, Range>, Range2> multi_id(const typed::id_list<> &list) const = delete;
  inline typed::multi_pw_aff<pair<Domain, Range>, Range2> multi_pw_aff(const typed::pw_aff_list<pair<Domain, Range>, Anonymous> &list) const;
  inline typed::multi_union_pw_aff<pair<Domain, Range>, Range2> multi_union_pw_aff(const typed::union_pw_aff_list<> &list) const = delete;
  inline typed::multi_val<pair<Domain, Range>, Range2> multi_val(const typed::val_list<> &list) const = delete;
  inline typed::aff<pair<Domain, Range>, Range2> param_aff_on_domain(const typed::id<> &id) const = delete;
  inline typed::aff<pair<Domain, Range>, Range2> param_aff_on_domain(const std::string &id) const = delete;
  inline typed::space<> params() const;
  template <typename Domain2, typename Arg3>
  inline typed::space<pair<pair<Domain, Range>, Domain2>, pair<Range2, Arg3>> product(const typed::space<Domain2, Arg3> &right) const;
  inline typed::space<Range2> range() const;
  inline typed::multi_aff<pair<pair<Domain, Range>, Range2>, Range2> range_map_multi_aff() const;
  inline typed::pw_multi_aff<pair<pair<Domain, Range>, Range2>, Range2> range_map_pw_multi_aff() const;
  inline typed::space<pair<Domain, Range>, Range2> range_reverse() const = delete;
  inline typed::id<pair<Domain, Range>, Range2> get_range_tuple_id() const = delete;
  inline typed::space<Range2, pair<Domain, Range>> reverse() const;
  inline typed::space<pair<Domain, Range>, Range2> set_domain_tuple(const typed::id<> &id) const = delete;
  inline typed::space<pair<Domain, Range>, Range2> set_domain_tuple(const std::string &id) const = delete;
  template <typename Arg2>
  inline typed::space<pair<Domain, Range>, Arg2> set_range_tuple(const typed::id<Anonymous> &id) const;
  template <typename Arg2>
  inline typed::space<pair<Domain, Range>, Arg2> set_range_tuple(const std::string &id) const;
  inline typed::space<pair<Domain, Range>, Range2> uncurry() const = delete;
  static inline typed::space<pair<Domain, Range>, Range2> unit(const isl::ctx &ctx) = delete;
  inline typed::map<pair<Domain, Range>, Range2> universe_map() const;
  inline typed::set<pair<Domain, Range>, Range2> universe_set() const = delete;
  inline typed::space<pair<Domain, Range>, Range2> unwrap() const = delete;
  inline typed::space<pair<pair<Domain, Range>, Range2>> wrap() const;
  inline typed::space<pair<Domain, Range>, Range2> wrapped_reverse() const = delete;
  inline typed::aff<pair<Domain, Range>, Range2> zero_aff_on_domain() const = delete;
  inline typed::multi_aff<pair<Domain, Range>, Range2> zero_multi_aff() const;
  inline typed::multi_pw_aff<pair<Domain, Range>, Range2> zero_multi_pw_aff() const;
  inline typed::multi_union_pw_aff<pair<Domain, Range>, Range2> zero_multi_union_pw_aff() const;
  inline typed::multi_val<pair<Domain, Range>, Range2> zero_multi_val() const = delete;
};

template <typename Domain, typename Range, typename Range2>
struct space<Domain, pair<Range, Range2>> : public isl::space {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  space() = default;
  template <typename Arg1, typename Arg2, typename Arg3,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{} &&
              std::is_base_of<Range, Arg2>{} &&
              std::is_base_of<Range2, Arg3>{},
            bool>::type = true>
  space(const space<Arg1, pair<Arg2, Arg3>> &obj) : isl::space(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::space>{}, bool>::type = true>
  space(const base &obj) : isl::space(obj) {}
 public:
  static space from(const isl::space &obj) {
    return space(obj);
  }
  inline explicit space(const isl::ctx &ctx, const std::string &str);
  inline typed::space<Domain, pair<Range, Range2>> add_named_tuple(const typed::id<> &tuple_id, unsigned int dim) const = delete;
  inline typed::space<Domain, pair<Range, Range2>> add_named_tuple(const std::string &tuple_id, unsigned int dim) const = delete;
  inline typed::space<Domain, pair<Range, Range2>> add_param(const typed::id<Anonymous> &id) const;
  inline typed::space<Domain, pair<Range, Range2>> add_param(const std::string &id) const;
  inline typed::space<Domain, pair<Range, Range2>> add_unnamed_tuple(unsigned int dim) const = delete;
  inline typed::space<Domain, pair<Range, Range2>> curry() const = delete;
  inline typed::space<Domain> domain() const;
  inline typed::multi_aff<pair<Domain, pair<Range, Range2>>, Domain> domain_map_multi_aff() const;
  inline typed::pw_multi_aff<pair<Domain, pair<Range, Range2>>, Domain> domain_map_pw_multi_aff() const;
  inline typed::space<Domain, pair<Range, Range2>> domain_reverse() const = delete;
  inline typed::id<Domain, pair<Range, Range2>> get_domain_tuple_id() const = delete;
  inline typed::space<Domain, pair<Range, Range2>> drop_all_params() const;
  inline typed::space<Domain, pair<Range, Range2>> flatten_domain() const = delete;
  inline typed::space<Domain, Anonymous> flatten_range() const;
  inline typed::multi_aff<Domain, pair<Range, Range2>> identity_multi_aff_on_domain() const = delete;
  inline typed::multi_pw_aff<Domain, pair<Range, Range2>> identity_multi_pw_aff_on_domain() const = delete;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> identity_pw_multi_aff_on_domain() const = delete;
  inline typed::space<Domain, pair<Range, Range2>> map_from_set() const = delete;
  inline typed::multi_aff<Domain, pair<Range, Range2>> multi_aff(const typed::aff_list<Domain, Anonymous> &list) const;
  inline typed::multi_aff<Domain, pair<Range, Range2>> multi_aff_on_domain(const typed::multi_val<> &mv) const = delete;
  inline typed::multi_id<Domain, pair<Range, Range2>> multi_id(const typed::id_list<> &list) const = delete;
  inline typed::multi_pw_aff<Domain, pair<Range, Range2>> multi_pw_aff(const typed::pw_aff_list<Domain, Anonymous> &list) const;
  inline typed::multi_union_pw_aff<Domain, pair<Range, Range2>> multi_union_pw_aff(const typed::union_pw_aff_list<> &list) const = delete;
  inline typed::multi_val<Domain, pair<Range, Range2>> multi_val(const typed::val_list<> &list) const = delete;
  inline typed::aff<Domain, pair<Range, Range2>> param_aff_on_domain(const typed::id<> &id) const = delete;
  inline typed::aff<Domain, pair<Range, Range2>> param_aff_on_domain(const std::string &id) const = delete;
  inline typed::space<> params() const;
  template <typename Domain2, typename Arg3>
  inline typed::space<pair<Domain, Domain2>, pair<pair<Range, Range2>, Arg3>> product(const typed::space<Domain2, Arg3> &right) const;
  inline typed::space<pair<Range, Range2>> range() const;
  inline typed::multi_aff<pair<Domain, pair<Range, Range2>>, pair<Range, Range2>> range_map_multi_aff() const;
  inline typed::pw_multi_aff<pair<Domain, pair<Range, Range2>>, pair<Range, Range2>> range_map_pw_multi_aff() const;
  inline typed::space<Domain, pair<Range2, Range>> range_reverse() const;
  inline typed::id<Domain, pair<Range, Range2>> get_range_tuple_id() const = delete;
  inline typed::space<pair<Range, Range2>, Domain> reverse() const;
  template <typename Domain2>
  inline typed::space<Domain2, pair<Range, Range2>> set_domain_tuple(const typed::id<Anonymous> &id) const;
  template <typename Domain2>
  inline typed::space<Domain2, pair<Range, Range2>> set_domain_tuple(const std::string &id) const;
  inline typed::space<Domain, pair<Range, Range2>> set_range_tuple(const typed::id<> &id) const = delete;
  inline typed::space<Domain, pair<Range, Range2>> set_range_tuple(const std::string &id) const = delete;
  inline typed::space<pair<Domain, Range>, Range2> uncurry() const;
  static inline typed::space<Domain, pair<Range, Range2>> unit(const isl::ctx &ctx) = delete;
  inline typed::map<Domain, pair<Range, Range2>> universe_map() const;
  inline typed::set<Domain, pair<Range, Range2>> universe_set() const = delete;
  inline typed::space<Domain, pair<Range, Range2>> unwrap() const = delete;
  inline typed::space<pair<Domain, pair<Range, Range2>>> wrap() const;
  inline typed::space<Domain, pair<Range, Range2>> wrapped_reverse() const = delete;
  inline typed::aff<Domain, pair<Range, Range2>> zero_aff_on_domain() const = delete;
  inline typed::multi_aff<Domain, pair<Range, Range2>> zero_multi_aff() const;
  inline typed::multi_pw_aff<Domain, pair<Range, Range2>> zero_multi_pw_aff() const;
  inline typed::multi_union_pw_aff<Domain, pair<Range, Range2>> zero_multi_union_pw_aff() const;
  inline typed::multi_val<Domain, pair<Range, Range2>> zero_multi_val() const = delete;
};

template <typename T1, typename T2, typename Range, typename Range2>
struct space<pair<T1, T2>, pair<Range, Range2>> : public isl::space {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  space() = default;
  template <typename Arg1, typename Arg2, typename Arg3, typename Arg4,
            typename std::enable_if<
              std::is_base_of<T1, Arg1>{} &&
              std::is_base_of<T2, Arg2>{} &&
              std::is_base_of<Range, Arg3>{} &&
              std::is_base_of<Range2, Arg4>{},
            bool>::type = true>
  space(const space<pair<Arg1, Arg2>, pair<Arg3, Arg4>> &obj) : isl::space(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::space>{}, bool>::type = true>
  space(const base &obj) : isl::space(obj) {}
 public:
  static space from(const isl::space &obj) {
    return space(obj);
  }
  inline explicit space(const isl::ctx &ctx, const std::string &str);
  inline typed::space<pair<T1, T2>, pair<Range, Range2>> add_named_tuple(const typed::id<> &tuple_id, unsigned int dim) const = delete;
  inline typed::space<pair<T1, T2>, pair<Range, Range2>> add_named_tuple(const std::string &tuple_id, unsigned int dim) const = delete;
  inline typed::space<pair<T1, T2>, pair<Range, Range2>> add_param(const typed::id<Anonymous> &id) const;
  inline typed::space<pair<T1, T2>, pair<Range, Range2>> add_param(const std::string &id) const;
  inline typed::space<pair<T1, T2>, pair<Range, Range2>> add_unnamed_tuple(unsigned int dim) const = delete;
  inline typed::space<T1, pair<T2, pair<Range, Range2>>> curry() const;
  inline typed::space<pair<T1, T2>> domain() const;
  inline typed::multi_aff<pair<pair<T1, T2>, pair<Range, Range2>>, pair<T1, T2>> domain_map_multi_aff() const;
  inline typed::pw_multi_aff<pair<pair<T1, T2>, pair<Range, Range2>>, pair<T1, T2>> domain_map_pw_multi_aff() const;
  inline typed::space<pair<T2, T1>, pair<Range, Range2>> domain_reverse() const;
  inline typed::id<pair<T1, T2>, pair<Range, Range2>> get_domain_tuple_id() const = delete;
  inline typed::space<pair<T1, T2>, pair<Range, Range2>> drop_all_params() const;
  inline typed::space<Anonymous, pair<Range, Range2>> flatten_domain() const;
  inline typed::space<pair<T1, T2>, Anonymous> flatten_range() const;
  inline typed::multi_aff<pair<T1, T2>, pair<Range, Range2>> identity_multi_aff_on_domain() const = delete;
  inline typed::multi_pw_aff<pair<T1, T2>, pair<Range, Range2>> identity_multi_pw_aff_on_domain() const = delete;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> identity_pw_multi_aff_on_domain() const = delete;
  inline typed::space<pair<T1, T2>, pair<Range, Range2>> map_from_set() const = delete;
  inline typed::multi_aff<pair<T1, T2>, pair<Range, Range2>> multi_aff(const typed::aff_list<pair<T1, T2>, Anonymous> &list) const;
  inline typed::multi_aff<pair<T1, T2>, pair<Range, Range2>> multi_aff_on_domain(const typed::multi_val<> &mv) const = delete;
  inline typed::multi_id<pair<T1, T2>, pair<Range, Range2>> multi_id(const typed::id_list<> &list) const = delete;
  inline typed::multi_pw_aff<pair<T1, T2>, pair<Range, Range2>> multi_pw_aff(const typed::pw_aff_list<pair<T1, T2>, Anonymous> &list) const;
  inline typed::multi_union_pw_aff<pair<T1, T2>, pair<Range, Range2>> multi_union_pw_aff(const typed::union_pw_aff_list<> &list) const = delete;
  inline typed::multi_val<pair<T1, T2>, pair<Range, Range2>> multi_val(const typed::val_list<> &list) const = delete;
  inline typed::aff<pair<T1, T2>, pair<Range, Range2>> param_aff_on_domain(const typed::id<> &id) const = delete;
  inline typed::aff<pair<T1, T2>, pair<Range, Range2>> param_aff_on_domain(const std::string &id) const = delete;
  inline typed::space<> params() const;
  template <typename Domain2, typename Arg2>
  inline typed::space<pair<pair<T1, T2>, Domain2>, pair<pair<Range, Range2>, Arg2>> product(const typed::space<Domain2, Arg2> &right) const;
  inline typed::space<pair<Range, Range2>> range() const;
  inline typed::multi_aff<pair<pair<T1, T2>, pair<Range, Range2>>, pair<Range, Range2>> range_map_multi_aff() const;
  inline typed::pw_multi_aff<pair<pair<T1, T2>, pair<Range, Range2>>, pair<Range, Range2>> range_map_pw_multi_aff() const;
  inline typed::space<pair<T1, T2>, pair<Range2, Range>> range_reverse() const;
  inline typed::id<pair<T1, T2>, pair<Range, Range2>> get_range_tuple_id() const = delete;
  inline typed::space<pair<Range, Range2>, pair<T1, T2>> reverse() const;
  inline typed::space<pair<T1, T2>, pair<Range, Range2>> set_domain_tuple(const typed::id<> &id) const = delete;
  inline typed::space<pair<T1, T2>, pair<Range, Range2>> set_domain_tuple(const std::string &id) const = delete;
  inline typed::space<pair<T1, T2>, pair<Range, Range2>> set_range_tuple(const typed::id<> &id) const = delete;
  inline typed::space<pair<T1, T2>, pair<Range, Range2>> set_range_tuple(const std::string &id) const = delete;
  inline typed::space<pair<pair<T1, T2>, Range>, Range2> uncurry() const;
  static inline typed::space<pair<T1, T2>, pair<Range, Range2>> unit(const isl::ctx &ctx) = delete;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> universe_map() const;
  inline typed::set<pair<T1, T2>, pair<Range, Range2>> universe_set() const = delete;
  inline typed::space<pair<T1, T2>, pair<Range, Range2>> unwrap() const = delete;
  inline typed::space<pair<pair<T1, T2>, pair<Range, Range2>>> wrap() const;
  inline typed::space<pair<T1, T2>, pair<Range, Range2>> wrapped_reverse() const = delete;
  inline typed::aff<pair<T1, T2>, pair<Range, Range2>> zero_aff_on_domain() const = delete;
  inline typed::multi_aff<pair<T1, T2>, pair<Range, Range2>> zero_multi_aff() const;
  inline typed::multi_pw_aff<pair<T1, T2>, pair<Range, Range2>> zero_multi_pw_aff() const;
  inline typed::multi_union_pw_aff<pair<T1, T2>, pair<Range, Range2>> zero_multi_union_pw_aff() const;
  inline typed::multi_val<pair<T1, T2>, pair<Range, Range2>> zero_multi_val() const = delete;
};

template <typename Domain, typename Range>
struct union_map<Domain, Range> : public isl::union_map {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  union_map() = default;
  template <typename Arg1, typename Arg2,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{} &&
              std::is_base_of<Range, Arg2>{},
            bool>::type = true>
  union_map(const union_map<Arg1, Arg2> &obj) : isl::union_map(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::union_map>{}, bool>::type = true>
  union_map(const base &obj) : isl::union_map(obj) {}
 public:
  static union_map from(const isl::union_map &obj) {
    return union_map(obj);
  }
  inline /* implicit */ union_map(const typed::basic_map<Domain, Range> &bmap);
  inline /* implicit */ union_map(const typed::map<Domain, Range> &map);
  inline explicit union_map(const isl::ctx &ctx, const std::string &str);
  template <typename Domain2>
  inline typed::union_map<Domain2, Range> apply_domain(const typed::union_map<Domain, Domain2> &umap2) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, Range> apply_domain(const typed::basic_map<Domain, Domain2> &umap2) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, Range> apply_domain(const typed::map<Domain, Domain2> &umap2) const;
  template <typename Range2>
  inline typed::union_map<Domain, Range2> apply_range(const typed::union_map<Range, Range2> &umap2) const;
  template <typename Range2>
  inline typed::union_map<Domain, Range2> apply_range(const typed::basic_map<Range, Range2> &umap2) const;
  template <typename Range2>
  inline typed::union_map<Domain, Range2> apply_range(const typed::map<Range, Range2> &umap2) const;
  inline typed::map<Domain, Range> as_map() const;
  inline typed::multi_union_pw_aff<Domain, Range> as_multi_union_pw_aff() const;
  inline typed::union_pw_multi_aff<Domain, Range> as_union_pw_multi_aff() const;
  inline typed::union_set<Domain> bind_range(const typed::multi_id<Range> &tuple) const;
  inline typed::union_map<Domain, Range> coalesce() const;
  inline typed::union_map<Domain, Range> curry() const = delete;
  inline typed::union_set<Domain, Range> deltas() const = delete;
  inline typed::union_map<Domain, Range> detect_equalities() const;
  inline typed::union_set<Domain> domain() const;
  inline typed::union_map<Domain, Range> domain_factor_domain() const = delete;
  inline typed::union_map<Domain, Range> domain_factor_range() const = delete;
  inline typed::union_map<pair<Domain, Range>, Domain> domain_map() const;
  inline typed::union_pw_multi_aff<pair<Domain, Range>, Domain> domain_map_union_pw_multi_aff() const;
  template <typename Domain2>
  inline typed::union_map<pair<Domain, Domain2>, Range> domain_product(const typed::union_map<Domain2, Range> &umap2) const;
  template <typename Domain2>
  inline typed::union_map<pair<Domain, Domain2>, Range> domain_product(const typed::basic_map<Domain2, Range> &umap2) const;
  template <typename Domain2>
  inline typed::union_map<pair<Domain, Domain2>, Range> domain_product(const typed::map<Domain2, Range> &umap2) const;
  inline typed::union_map<Domain, Range> domain_reverse() const = delete;
  inline typed::union_map<Domain, Range> drop_unused_params() const;
  static inline typed::union_map<Domain, Range> empty(const isl::ctx &ctx);
  inline typed::union_map<Domain, Range> eq_at(const typed::multi_union_pw_aff<> &mupa) const = delete;
  inline typed::union_map<Domain, Range> eq_at(const typed::multi_pw_aff<> &mupa) const = delete;
  inline typed::union_map<Domain, Range> eq_at(const typed::union_pw_aff<> &mupa) const = delete;
  inline bool every_map(const std::function<bool(typed::map<Domain, Range>)> &test) const;
  inline typed::map<Domain, Range> extract_map(const typed::space<Domain, Range> &space) const;
  inline void foreach_map(const std::function<void(typed::map<Domain, Range>)> &fn) const;
  inline typed::union_map<Domain, Range> gist(const typed::union_map<Domain, Range> &context) const;
  inline typed::union_map<Domain, Range> gist(const typed::basic_map<Domain, Range> &context) const;
  inline typed::union_map<Domain, Range> gist(const typed::map<Domain, Range> &context) const;
  inline typed::union_map<Domain, Range> gist_domain(const typed::union_set<Domain> &uset) const;
  inline typed::union_map<Domain, Range> gist_domain(const typed::basic_set<Domain> &uset) const;
  inline typed::union_map<Domain, Range> gist_domain(const typed::point<Domain> &uset) const;
  inline typed::union_map<Domain, Range> gist_domain(const typed::set<Domain> &uset) const;
  inline typed::union_map<Domain, Range> gist_params(const typed::set<> &set) const;
  inline typed::union_map<Domain, Range> gist_params(const typed::basic_set<> &set) const;
  inline typed::union_map<Domain, Range> gist_params(const typed::point<> &set) const;
  inline typed::union_map<Domain, Range> intersect(const typed::union_map<Domain, Range> &umap2) const;
  inline typed::union_map<Domain, Range> intersect(const typed::basic_map<Domain, Range> &umap2) const;
  inline typed::union_map<Domain, Range> intersect(const typed::map<Domain, Range> &umap2) const;
  inline typed::union_map<Domain, Range> intersect_domain(const typed::space<Domain> &space) const;
  inline typed::union_map<Domain, Range> intersect_domain(const typed::union_set<Domain> &uset) const;
  inline typed::union_map<Domain, Range> intersect_domain_wrapped_domain(const typed::union_set<> &domain) const = delete;
  inline typed::union_map<Domain, Range> intersect_domain_wrapped_domain(const typed::basic_set<> &domain) const = delete;
  inline typed::union_map<Domain, Range> intersect_domain_wrapped_domain(const typed::point<> &domain) const = delete;
  inline typed::union_map<Domain, Range> intersect_domain_wrapped_domain(const typed::set<> &domain) const = delete;
  inline typed::union_map<Domain, Range> intersect_params(const typed::set<> &set) const;
  inline typed::union_map<Domain, Range> intersect_params(const typed::basic_set<> &set) const;
  inline typed::union_map<Domain, Range> intersect_params(const typed::point<> &set) const;
  inline typed::union_map<Domain, Range> intersect_range(const typed::space<Range> &space) const;
  inline typed::union_map<Domain, Range> intersect_range(const typed::union_set<Range> &uset) const;
  inline typed::union_map<Domain, Range> intersect_range_wrapped_domain(const typed::union_set<> &domain) const = delete;
  inline typed::union_map<Domain, Range> intersect_range_wrapped_domain(const typed::basic_set<> &domain) const = delete;
  inline typed::union_map<Domain, Range> intersect_range_wrapped_domain(const typed::point<> &domain) const = delete;
  inline typed::union_map<Domain, Range> intersect_range_wrapped_domain(const typed::set<> &domain) const = delete;
  inline typed::union_map<Domain, Range> lexmax() const;
  inline typed::union_map<Domain, Range> lexmin() const;
  inline typed::map_list<Domain, Range> map_list() const;
  inline typed::map_list<Domain, Range> get_map_list() const = delete;
  inline typed::set<> params() const;
  template <typename Domain2>
  inline typed::union_map<Domain2, Range> preimage_domain(const typed::multi_aff<Domain2, Domain> &ma) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, Range> preimage_domain(const typed::multi_pw_aff<Domain2, Domain> &mpa) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, Range> preimage_domain(const typed::pw_multi_aff<Domain2, Domain> &pma) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, Range> preimage_domain(const typed::union_pw_multi_aff<Domain2, Domain> &upma) const;
  template <typename Range2>
  inline typed::union_map<Domain, Range2> preimage_range(const typed::multi_aff<Range2, Range> &ma) const;
  template <typename Range2>
  inline typed::union_map<Domain, Range2> preimage_range(const typed::pw_multi_aff<Range2, Range> &pma) const;
  template <typename Range2>
  inline typed::union_map<Domain, Range2> preimage_range(const typed::union_pw_multi_aff<Range2, Range> &upma) const;
  template <typename Domain2, typename Range2>
  inline typed::union_map<pair<Domain, Domain2>, pair<Range, Range2>> product(const typed::union_map<Domain2, Range2> &umap2) const;
  template <typename Domain2, typename Range2>
  inline typed::union_map<pair<Domain, Domain2>, pair<Range, Range2>> product(const typed::basic_map<Domain2, Range2> &umap2) const;
  template <typename Domain2, typename Range2>
  inline typed::union_map<pair<Domain, Domain2>, pair<Range, Range2>> product(const typed::map<Domain2, Range2> &umap2) const;
  inline typed::union_map<Domain, Range> project_out_all_params() const;
  inline typed::union_map<Domain, Range> project_out_param(const typed::id<Anonymous> &id) const;
  inline typed::union_map<Domain, Range> project_out_param(const std::string &id) const;
  inline typed::union_map<Domain, Range> project_out_param(const typed::id_list<Anonymous> &list) const;
  inline typed::union_set<Range> range() const;
  inline typed::union_map<Domain, Range> range_factor_domain() const = delete;
  inline typed::union_map<Domain, Range> range_factor_range() const = delete;
  inline typed::union_map<pair<Domain, Range>, Range> range_map() const;
  template <typename Range2>
  inline typed::union_map<Domain, pair<Range, Range2>> range_product(const typed::union_map<Domain, Range2> &umap2) const;
  template <typename Range2>
  inline typed::union_map<Domain, pair<Range, Range2>> range_product(const typed::basic_map<Domain, Range2> &umap2) const;
  template <typename Range2>
  inline typed::union_map<Domain, pair<Range, Range2>> range_product(const typed::map<Domain, Range2> &umap2) const;
  inline typed::union_map<Domain, Range> range_reverse() const = delete;
  inline typed::union_map<Range, Domain> reverse() const;
  inline typed::space<> space() const;
  inline typed::space<Domain, Range> get_space() const = delete;
  inline typed::union_map<Domain, Range> subtract(const typed::union_map<Domain, Range> &umap2) const;
  inline typed::union_map<Domain, Range> subtract(const typed::basic_map<Domain, Range> &umap2) const;
  inline typed::union_map<Domain, Range> subtract(const typed::map<Domain, Range> &umap2) const;
  inline typed::union_map<Domain, Range> subtract_domain(const typed::union_set<Domain> &dom) const;
  inline typed::union_map<Domain, Range> subtract_domain(const typed::basic_set<Domain> &dom) const;
  inline typed::union_map<Domain, Range> subtract_domain(const typed::point<Domain> &dom) const;
  inline typed::union_map<Domain, Range> subtract_domain(const typed::set<Domain> &dom) const;
  inline typed::union_map<Domain, Range> subtract_range(const typed::union_set<Range> &dom) const;
  inline typed::union_map<Domain, Range> subtract_range(const typed::basic_set<Range> &dom) const;
  inline typed::union_map<Domain, Range> subtract_range(const typed::point<Range> &dom) const;
  inline typed::union_map<Domain, Range> subtract_range(const typed::set<Range> &dom) const;
  inline typed::union_map<Domain, Range> uncurry() const = delete;
  inline typed::union_map<Domain, Range> unite(const typed::union_map<Domain, Range> &umap2) const;
  inline typed::union_map<Domain, Range> unite(const typed::basic_map<Domain, Range> &umap2) const;
  inline typed::union_map<Domain, Range> unite(const typed::map<Domain, Range> &umap2) const;
  inline typed::union_map<Domain, Range> universe() const;
  inline typed::union_set<pair<Domain, Range>> wrap() const;
};

template <typename Domain, typename Range, typename Range2>
struct union_map<pair<Domain, Range>, Range2> : public isl::union_map {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  union_map() = default;
  template <typename Arg1, typename Arg2, typename Arg3,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{} &&
              std::is_base_of<Range, Arg2>{} &&
              std::is_base_of<Range2, Arg3>{},
            bool>::type = true>
  union_map(const union_map<pair<Arg1, Arg2>, Arg3> &obj) : isl::union_map(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::union_map>{}, bool>::type = true>
  union_map(const base &obj) : isl::union_map(obj) {}
 public:
  static union_map from(const isl::union_map &obj) {
    return union_map(obj);
  }
  inline /* implicit */ union_map(const typed::basic_map<pair<Domain, Range>, Range2> &bmap);
  inline /* implicit */ union_map(const typed::map<pair<Domain, Range>, Range2> &map);
  inline explicit union_map(const isl::ctx &ctx, const std::string &str);
  template <typename Domain2>
  inline typed::union_map<Domain2, Range2> apply_domain(const typed::union_map<pair<Domain, Range>, Domain2> &umap2) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, Range2> apply_domain(const typed::basic_map<pair<Domain, Range>, Domain2> &umap2) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, Range2> apply_domain(const typed::map<pair<Domain, Range>, Domain2> &umap2) const;
  template <typename Arg3>
  inline typed::union_map<pair<Domain, Range>, Arg3> apply_range(const typed::union_map<Range2, Arg3> &umap2) const;
  template <typename Arg3>
  inline typed::union_map<pair<Domain, Range>, Arg3> apply_range(const typed::basic_map<Range2, Arg3> &umap2) const;
  template <typename Arg3>
  inline typed::union_map<pair<Domain, Range>, Arg3> apply_range(const typed::map<Range2, Arg3> &umap2) const;
  inline typed::map<pair<Domain, Range>, Range2> as_map() const;
  inline typed::multi_union_pw_aff<pair<Domain, Range>, Range2> as_multi_union_pw_aff() const;
  inline typed::union_pw_multi_aff<pair<Domain, Range>, Range2> as_union_pw_multi_aff() const;
  inline typed::union_set<pair<Domain, Range>> bind_range(const typed::multi_id<Range2> &tuple) const;
  inline typed::union_map<pair<Domain, Range>, Range2> coalesce() const;
  inline typed::union_map<Domain, pair<Range, Range2>> curry() const;
  inline typed::union_set<pair<Domain, Range>, Range2> deltas() const = delete;
  inline typed::union_map<pair<Domain, Range>, Range2> detect_equalities() const;
  inline typed::union_set<pair<Domain, Range>> domain() const;
  inline typed::union_map<Domain, Range2> domain_factor_domain() const;
  inline typed::union_map<Range, Range2> domain_factor_range() const;
  inline typed::union_map<pair<pair<Domain, Range>, Range2>, pair<Domain, Range>> domain_map() const;
  inline typed::union_pw_multi_aff<pair<pair<Domain, Range>, Range2>, pair<Domain, Range>> domain_map_union_pw_multi_aff() const;
  template <typename Domain2>
  inline typed::union_map<pair<pair<Domain, Range>, Domain2>, Range2> domain_product(const typed::union_map<Domain2, Range2> &umap2) const;
  template <typename Domain2>
  inline typed::union_map<pair<pair<Domain, Range>, Domain2>, Range2> domain_product(const typed::basic_map<Domain2, Range2> &umap2) const;
  template <typename Domain2>
  inline typed::union_map<pair<pair<Domain, Range>, Domain2>, Range2> domain_product(const typed::map<Domain2, Range2> &umap2) const;
  inline typed::union_map<pair<Range, Domain>, Range2> domain_reverse() const;
  inline typed::union_map<pair<Domain, Range>, Range2> drop_unused_params() const;
  static inline typed::union_map<pair<Domain, Range>, Range2> empty(const isl::ctx &ctx);
  inline typed::union_map<pair<Domain, Range>, Range2> eq_at(const typed::multi_union_pw_aff<> &mupa) const = delete;
  inline typed::union_map<pair<Domain, Range>, Range2> eq_at(const typed::multi_pw_aff<> &mupa) const = delete;
  inline typed::union_map<pair<Domain, Range>, Range2> eq_at(const typed::union_pw_aff<> &mupa) const = delete;
  inline bool every_map(const std::function<bool(typed::map<pair<Domain, Range>, Range2>)> &test) const;
  inline typed::map<pair<Domain, Range>, Range2> extract_map(const typed::space<pair<Domain, Range>, Range2> &space) const;
  inline void foreach_map(const std::function<void(typed::map<pair<Domain, Range>, Range2>)> &fn) const;
  inline typed::union_map<pair<Domain, Range>, Range2> gist(const typed::union_map<pair<Domain, Range>, Range2> &context) const;
  inline typed::union_map<pair<Domain, Range>, Range2> gist(const typed::basic_map<pair<Domain, Range>, Range2> &context) const;
  inline typed::union_map<pair<Domain, Range>, Range2> gist(const typed::map<pair<Domain, Range>, Range2> &context) const;
  inline typed::union_map<pair<Domain, Range>, Range2> gist_domain(const typed::union_set<pair<Domain, Range>> &uset) const;
  inline typed::union_map<pair<Domain, Range>, Range2> gist_domain(const typed::basic_set<pair<Domain, Range>> &uset) const;
  inline typed::union_map<pair<Domain, Range>, Range2> gist_domain(const typed::point<pair<Domain, Range>> &uset) const;
  inline typed::union_map<pair<Domain, Range>, Range2> gist_domain(const typed::set<pair<Domain, Range>> &uset) const;
  inline typed::union_map<pair<Domain, Range>, Range2> gist_params(const typed::set<> &set) const;
  inline typed::union_map<pair<Domain, Range>, Range2> gist_params(const typed::basic_set<> &set) const;
  inline typed::union_map<pair<Domain, Range>, Range2> gist_params(const typed::point<> &set) const;
  inline typed::union_map<pair<Domain, Range>, Range2> intersect(const typed::union_map<pair<Domain, Range>, Range2> &umap2) const;
  inline typed::union_map<pair<Domain, Range>, Range2> intersect(const typed::basic_map<pair<Domain, Range>, Range2> &umap2) const;
  inline typed::union_map<pair<Domain, Range>, Range2> intersect(const typed::map<pair<Domain, Range>, Range2> &umap2) const;
  inline typed::union_map<pair<Domain, Range>, Range2> intersect_domain(const typed::space<pair<Domain, Range>> &space) const;
  inline typed::union_map<pair<Domain, Range>, Range2> intersect_domain(const typed::union_set<pair<Domain, Range>> &uset) const;
  inline typed::union_map<pair<Domain, Range>, Range2> intersect_domain_wrapped_domain(const typed::union_set<Domain> &domain) const;
  inline typed::union_map<pair<Domain, Range>, Range2> intersect_domain_wrapped_domain(const typed::basic_set<Domain> &domain) const;
  inline typed::union_map<pair<Domain, Range>, Range2> intersect_domain_wrapped_domain(const typed::point<Domain> &domain) const;
  inline typed::union_map<pair<Domain, Range>, Range2> intersect_domain_wrapped_domain(const typed::set<Domain> &domain) const;
  inline typed::union_map<pair<Domain, Range>, Range2> intersect_params(const typed::set<> &set) const;
  inline typed::union_map<pair<Domain, Range>, Range2> intersect_params(const typed::basic_set<> &set) const;
  inline typed::union_map<pair<Domain, Range>, Range2> intersect_params(const typed::point<> &set) const;
  inline typed::union_map<pair<Domain, Range>, Range2> intersect_range(const typed::space<Range2> &space) const;
  inline typed::union_map<pair<Domain, Range>, Range2> intersect_range(const typed::union_set<Range2> &uset) const;
  inline typed::union_map<pair<Domain, Range>, Range2> intersect_range_wrapped_domain(const typed::union_set<> &domain) const = delete;
  inline typed::union_map<pair<Domain, Range>, Range2> intersect_range_wrapped_domain(const typed::basic_set<> &domain) const = delete;
  inline typed::union_map<pair<Domain, Range>, Range2> intersect_range_wrapped_domain(const typed::point<> &domain) const = delete;
  inline typed::union_map<pair<Domain, Range>, Range2> intersect_range_wrapped_domain(const typed::set<> &domain) const = delete;
  inline typed::union_map<pair<Domain, Range>, Range2> lexmax() const;
  inline typed::union_map<pair<Domain, Range>, Range2> lexmin() const;
  inline typed::map_list<pair<Domain, Range>, Range2> map_list() const;
  inline typed::map_list<pair<Domain, Range>, Range2> get_map_list() const = delete;
  inline typed::set<> params() const;
  template <typename Domain2>
  inline typed::union_map<Domain2, Range2> preimage_domain(const typed::multi_aff<Domain2, pair<Domain, Range>> &ma) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, Range2> preimage_domain(const typed::multi_pw_aff<Domain2, pair<Domain, Range>> &mpa) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, Range2> preimage_domain(const typed::pw_multi_aff<Domain2, pair<Domain, Range>> &pma) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, Range2> preimage_domain(const typed::union_pw_multi_aff<Domain2, pair<Domain, Range>> &upma) const;
  template <typename Arg3>
  inline typed::union_map<pair<Domain, Range>, Arg3> preimage_range(const typed::multi_aff<Arg3, Range2> &ma) const;
  template <typename Arg3>
  inline typed::union_map<pair<Domain, Range>, Arg3> preimage_range(const typed::pw_multi_aff<Arg3, Range2> &pma) const;
  template <typename Arg3>
  inline typed::union_map<pair<Domain, Range>, Arg3> preimage_range(const typed::union_pw_multi_aff<Arg3, Range2> &upma) const;
  template <typename Domain2, typename Arg3>
  inline typed::union_map<pair<pair<Domain, Range>, Domain2>, pair<Range2, Arg3>> product(const typed::union_map<Domain2, Arg3> &umap2) const;
  template <typename Domain2, typename Arg3>
  inline typed::union_map<pair<pair<Domain, Range>, Domain2>, pair<Range2, Arg3>> product(const typed::basic_map<Domain2, Arg3> &umap2) const;
  template <typename Domain2, typename Arg3>
  inline typed::union_map<pair<pair<Domain, Range>, Domain2>, pair<Range2, Arg3>> product(const typed::map<Domain2, Arg3> &umap2) const;
  inline typed::union_map<pair<Domain, Range>, Range2> project_out_all_params() const;
  inline typed::union_map<pair<Domain, Range>, Range2> project_out_param(const typed::id<Anonymous> &id) const;
  inline typed::union_map<pair<Domain, Range>, Range2> project_out_param(const std::string &id) const;
  inline typed::union_map<pair<Domain, Range>, Range2> project_out_param(const typed::id_list<Anonymous> &list) const;
  inline typed::union_set<Range2> range() const;
  inline typed::union_map<pair<Domain, Range>, Range2> range_factor_domain() const = delete;
  inline typed::union_map<pair<Domain, Range>, Range2> range_factor_range() const = delete;
  inline typed::union_map<pair<pair<Domain, Range>, Range2>, Range2> range_map() const;
  template <typename Arg3>
  inline typed::union_map<pair<Domain, Range>, pair<Range2, Arg3>> range_product(const typed::union_map<pair<Domain, Range>, Arg3> &umap2) const;
  template <typename Arg3>
  inline typed::union_map<pair<Domain, Range>, pair<Range2, Arg3>> range_product(const typed::basic_map<pair<Domain, Range>, Arg3> &umap2) const;
  template <typename Arg3>
  inline typed::union_map<pair<Domain, Range>, pair<Range2, Arg3>> range_product(const typed::map<pair<Domain, Range>, Arg3> &umap2) const;
  inline typed::union_map<pair<Domain, Range>, Range2> range_reverse() const = delete;
  inline typed::union_map<Range2, pair<Domain, Range>> reverse() const;
  inline typed::space<> space() const;
  inline typed::space<pair<Domain, Range>, Range2> get_space() const = delete;
  inline typed::union_map<pair<Domain, Range>, Range2> subtract(const typed::union_map<pair<Domain, Range>, Range2> &umap2) const;
  inline typed::union_map<pair<Domain, Range>, Range2> subtract(const typed::basic_map<pair<Domain, Range>, Range2> &umap2) const;
  inline typed::union_map<pair<Domain, Range>, Range2> subtract(const typed::map<pair<Domain, Range>, Range2> &umap2) const;
  inline typed::union_map<pair<Domain, Range>, Range2> subtract_domain(const typed::union_set<pair<Domain, Range>> &dom) const;
  inline typed::union_map<pair<Domain, Range>, Range2> subtract_domain(const typed::basic_set<pair<Domain, Range>> &dom) const;
  inline typed::union_map<pair<Domain, Range>, Range2> subtract_domain(const typed::point<pair<Domain, Range>> &dom) const;
  inline typed::union_map<pair<Domain, Range>, Range2> subtract_domain(const typed::set<pair<Domain, Range>> &dom) const;
  inline typed::union_map<pair<Domain, Range>, Range2> subtract_range(const typed::union_set<Range2> &dom) const;
  inline typed::union_map<pair<Domain, Range>, Range2> subtract_range(const typed::basic_set<Range2> &dom) const;
  inline typed::union_map<pair<Domain, Range>, Range2> subtract_range(const typed::point<Range2> &dom) const;
  inline typed::union_map<pair<Domain, Range>, Range2> subtract_range(const typed::set<Range2> &dom) const;
  inline typed::union_map<pair<Domain, Range>, Range2> uncurry() const = delete;
  inline typed::union_map<pair<Domain, Range>, Range2> unite(const typed::union_map<pair<Domain, Range>, Range2> &umap2) const;
  inline typed::union_map<pair<Domain, Range>, Range2> unite(const typed::basic_map<pair<Domain, Range>, Range2> &umap2) const;
  inline typed::union_map<pair<Domain, Range>, Range2> unite(const typed::map<pair<Domain, Range>, Range2> &umap2) const;
  inline typed::union_map<pair<Domain, Range>, Range2> universe() const;
  inline typed::union_set<pair<pair<Domain, Range>, Range2>> wrap() const;
};

template <typename Domain>
struct union_map<Domain, Domain> : public isl::union_map {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  union_map() = default;
  template <typename Arg1,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{},
            bool>::type = true>
  union_map(const union_map<Arg1, Arg1> &obj) : isl::union_map(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::union_map>{}, bool>::type = true>
  union_map(const base &obj) : isl::union_map(obj) {}
 public:
  static union_map from(const isl::union_map &obj) {
    return union_map(obj);
  }
  inline /* implicit */ union_map(const typed::basic_map<Domain, Domain> &bmap);
  inline /* implicit */ union_map(const typed::map<Domain, Domain> &map);
  inline explicit union_map(const isl::ctx &ctx, const std::string &str);
  template <typename Domain2>
  inline typed::union_map<Domain2, Domain> apply_domain(const typed::union_map<Domain, Domain2> &umap2) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, Domain> apply_domain(const typed::basic_map<Domain, Domain2> &umap2) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, Domain> apply_domain(const typed::map<Domain, Domain2> &umap2) const;
  template <typename Range2>
  inline typed::union_map<Domain, Range2> apply_range(const typed::union_map<Domain, Range2> &umap2) const;
  template <typename Range2>
  inline typed::union_map<Domain, Range2> apply_range(const typed::basic_map<Domain, Range2> &umap2) const;
  template <typename Range2>
  inline typed::union_map<Domain, Range2> apply_range(const typed::map<Domain, Range2> &umap2) const;
  inline typed::map<Domain, Domain> as_map() const;
  inline typed::multi_union_pw_aff<Domain, Domain> as_multi_union_pw_aff() const;
  inline typed::union_pw_multi_aff<Domain, Domain> as_union_pw_multi_aff() const;
  inline typed::union_set<Domain> bind_range(const typed::multi_id<Domain> &tuple) const;
  inline typed::union_map<Domain, Domain> coalesce() const;
  inline typed::union_map<Domain, Domain> curry() const = delete;
  inline typed::union_set<Domain> deltas() const;
  inline typed::union_map<Domain, Domain> detect_equalities() const;
  inline typed::union_set<Domain> domain() const;
  inline typed::union_map<Domain, Domain> domain_factor_domain() const = delete;
  inline typed::union_map<Domain, Domain> domain_factor_range() const = delete;
  inline typed::union_map<pair<Domain, Domain>, Domain> domain_map() const;
  inline typed::union_pw_multi_aff<pair<Domain, Domain>, Domain> domain_map_union_pw_multi_aff() const;
  template <typename Domain2>
  inline typed::union_map<pair<Domain, Domain2>, Domain> domain_product(const typed::union_map<Domain2, Domain> &umap2) const;
  template <typename Domain2>
  inline typed::union_map<pair<Domain, Domain2>, Domain> domain_product(const typed::basic_map<Domain2, Domain> &umap2) const;
  template <typename Domain2>
  inline typed::union_map<pair<Domain, Domain2>, Domain> domain_product(const typed::map<Domain2, Domain> &umap2) const;
  inline typed::union_map<Domain, Domain> domain_reverse() const = delete;
  inline typed::union_map<Domain, Domain> drop_unused_params() const;
  static inline typed::union_map<Domain, Domain> empty(const isl::ctx &ctx);
  template <typename Range>
  inline typed::union_map<Domain, Domain> eq_at(const typed::multi_union_pw_aff<Domain, Range> &mupa) const;
  template <typename Range>
  inline typed::union_map<Domain, Domain> eq_at(const typed::multi_pw_aff<Domain, Range> &mupa) const;
  inline typed::union_map<Domain, Domain> eq_at(const typed::union_pw_aff<Domain, Anonymous> &mupa) const;
  inline bool every_map(const std::function<bool(typed::map<Domain, Domain>)> &test) const;
  inline typed::map<Domain, Domain> extract_map(const typed::space<Domain, Domain> &space) const;
  inline void foreach_map(const std::function<void(typed::map<Domain, Domain>)> &fn) const;
  inline typed::union_map<Domain, Domain> gist(const typed::union_map<Domain, Domain> &context) const;
  inline typed::union_map<Domain, Domain> gist(const typed::basic_map<Domain, Domain> &context) const;
  inline typed::union_map<Domain, Domain> gist(const typed::map<Domain, Domain> &context) const;
  inline typed::union_map<Domain, Domain> gist_domain(const typed::union_set<Domain> &uset) const;
  inline typed::union_map<Domain, Domain> gist_domain(const typed::basic_set<Domain> &uset) const;
  inline typed::union_map<Domain, Domain> gist_domain(const typed::point<Domain> &uset) const;
  inline typed::union_map<Domain, Domain> gist_domain(const typed::set<Domain> &uset) const;
  inline typed::union_map<Domain, Domain> gist_params(const typed::set<> &set) const;
  inline typed::union_map<Domain, Domain> gist_params(const typed::basic_set<> &set) const;
  inline typed::union_map<Domain, Domain> gist_params(const typed::point<> &set) const;
  inline typed::union_map<Domain, Domain> intersect(const typed::union_map<Domain, Domain> &umap2) const;
  inline typed::union_map<Domain, Domain> intersect(const typed::basic_map<Domain, Domain> &umap2) const;
  inline typed::union_map<Domain, Domain> intersect(const typed::map<Domain, Domain> &umap2) const;
  inline typed::union_map<Domain, Domain> intersect_domain(const typed::space<Domain> &space) const;
  inline typed::union_map<Domain, Domain> intersect_domain(const typed::union_set<Domain> &uset) const;
  inline typed::union_map<Domain, Domain> intersect_domain_wrapped_domain(const typed::union_set<> &domain) const = delete;
  inline typed::union_map<Domain, Domain> intersect_domain_wrapped_domain(const typed::basic_set<> &domain) const = delete;
  inline typed::union_map<Domain, Domain> intersect_domain_wrapped_domain(const typed::point<> &domain) const = delete;
  inline typed::union_map<Domain, Domain> intersect_domain_wrapped_domain(const typed::set<> &domain) const = delete;
  inline typed::union_map<Domain, Domain> intersect_params(const typed::set<> &set) const;
  inline typed::union_map<Domain, Domain> intersect_params(const typed::basic_set<> &set) const;
  inline typed::union_map<Domain, Domain> intersect_params(const typed::point<> &set) const;
  inline typed::union_map<Domain, Domain> intersect_range(const typed::space<Domain> &space) const;
  inline typed::union_map<Domain, Domain> intersect_range(const typed::union_set<Domain> &uset) const;
  inline typed::union_map<Domain, Domain> intersect_range_wrapped_domain(const typed::union_set<> &domain) const = delete;
  inline typed::union_map<Domain, Domain> intersect_range_wrapped_domain(const typed::basic_set<> &domain) const = delete;
  inline typed::union_map<Domain, Domain> intersect_range_wrapped_domain(const typed::point<> &domain) const = delete;
  inline typed::union_map<Domain, Domain> intersect_range_wrapped_domain(const typed::set<> &domain) const = delete;
  inline typed::union_map<Domain, Domain> lexmax() const;
  inline typed::union_map<Domain, Domain> lexmin() const;
  inline typed::map_list<Domain, Domain> map_list() const;
  inline typed::map_list<Domain, Domain> get_map_list() const = delete;
  inline typed::set<> params() const;
  template <typename Domain2>
  inline typed::union_map<Domain2, Domain> preimage_domain(const typed::multi_aff<Domain2, Domain> &ma) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, Domain> preimage_domain(const typed::multi_pw_aff<Domain2, Domain> &mpa) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, Domain> preimage_domain(const typed::pw_multi_aff<Domain2, Domain> &pma) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, Domain> preimage_domain(const typed::union_pw_multi_aff<Domain2, Domain> &upma) const;
  template <typename Range2>
  inline typed::union_map<Domain, Range2> preimage_range(const typed::multi_aff<Range2, Domain> &ma) const;
  template <typename Range2>
  inline typed::union_map<Domain, Range2> preimage_range(const typed::pw_multi_aff<Range2, Domain> &pma) const;
  template <typename Range2>
  inline typed::union_map<Domain, Range2> preimage_range(const typed::union_pw_multi_aff<Range2, Domain> &upma) const;
  template <typename Domain2, typename Range2>
  inline typed::union_map<pair<Domain, Domain2>, pair<Domain, Range2>> product(const typed::union_map<Domain2, Range2> &umap2) const;
  template <typename Domain2, typename Range2>
  inline typed::union_map<pair<Domain, Domain2>, pair<Domain, Range2>> product(const typed::basic_map<Domain2, Range2> &umap2) const;
  template <typename Domain2, typename Range2>
  inline typed::union_map<pair<Domain, Domain2>, pair<Domain, Range2>> product(const typed::map<Domain2, Range2> &umap2) const;
  inline typed::union_map<Domain, Domain> project_out_all_params() const;
  inline typed::union_map<Domain, Domain> project_out_param(const typed::id<Anonymous> &id) const;
  inline typed::union_map<Domain, Domain> project_out_param(const std::string &id) const;
  inline typed::union_map<Domain, Domain> project_out_param(const typed::id_list<Anonymous> &list) const;
  inline typed::union_set<Domain> range() const;
  inline typed::union_map<Domain, Domain> range_factor_domain() const = delete;
  inline typed::union_map<Domain, Domain> range_factor_range() const = delete;
  inline typed::union_map<pair<Domain, Domain>, Domain> range_map() const;
  template <typename Range2>
  inline typed::union_map<Domain, pair<Domain, Range2>> range_product(const typed::union_map<Domain, Range2> &umap2) const;
  template <typename Range2>
  inline typed::union_map<Domain, pair<Domain, Range2>> range_product(const typed::basic_map<Domain, Range2> &umap2) const;
  template <typename Range2>
  inline typed::union_map<Domain, pair<Domain, Range2>> range_product(const typed::map<Domain, Range2> &umap2) const;
  inline typed::union_map<Domain, Domain> range_reverse() const = delete;
  inline typed::union_map<Domain, Domain> reverse() const;
  inline typed::space<> space() const;
  inline typed::space<Domain, Domain> get_space() const = delete;
  inline typed::union_map<Domain, Domain> subtract(const typed::union_map<Domain, Domain> &umap2) const;
  inline typed::union_map<Domain, Domain> subtract(const typed::basic_map<Domain, Domain> &umap2) const;
  inline typed::union_map<Domain, Domain> subtract(const typed::map<Domain, Domain> &umap2) const;
  inline typed::union_map<Domain, Domain> subtract_domain(const typed::union_set<Domain> &dom) const;
  inline typed::union_map<Domain, Domain> subtract_domain(const typed::basic_set<Domain> &dom) const;
  inline typed::union_map<Domain, Domain> subtract_domain(const typed::point<Domain> &dom) const;
  inline typed::union_map<Domain, Domain> subtract_domain(const typed::set<Domain> &dom) const;
  inline typed::union_map<Domain, Domain> subtract_range(const typed::union_set<Domain> &dom) const;
  inline typed::union_map<Domain, Domain> subtract_range(const typed::basic_set<Domain> &dom) const;
  inline typed::union_map<Domain, Domain> subtract_range(const typed::point<Domain> &dom) const;
  inline typed::union_map<Domain, Domain> subtract_range(const typed::set<Domain> &dom) const;
  inline typed::union_map<Domain, Domain> uncurry() const = delete;
  inline typed::union_map<Domain, Domain> unite(const typed::union_map<Domain, Domain> &umap2) const;
  inline typed::union_map<Domain, Domain> unite(const typed::basic_map<Domain, Domain> &umap2) const;
  inline typed::union_map<Domain, Domain> unite(const typed::map<Domain, Domain> &umap2) const;
  inline typed::union_map<Domain, Domain> universe() const;
  inline typed::union_set<pair<Domain, Domain>> wrap() const;
};

template <typename Domain, typename Range, typename Range2>
struct union_map<Domain, pair<Range, Range2>> : public isl::union_map {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  union_map() = default;
  template <typename Arg1, typename Arg2, typename Arg3,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{} &&
              std::is_base_of<Range, Arg2>{} &&
              std::is_base_of<Range2, Arg3>{},
            bool>::type = true>
  union_map(const union_map<Arg1, pair<Arg2, Arg3>> &obj) : isl::union_map(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::union_map>{}, bool>::type = true>
  union_map(const base &obj) : isl::union_map(obj) {}
 public:
  static union_map from(const isl::union_map &obj) {
    return union_map(obj);
  }
  inline /* implicit */ union_map(const typed::basic_map<Domain, pair<Range, Range2>> &bmap);
  inline /* implicit */ union_map(const typed::map<Domain, pair<Range, Range2>> &map);
  inline explicit union_map(const isl::ctx &ctx, const std::string &str);
  template <typename Domain2>
  inline typed::union_map<Domain2, pair<Range, Range2>> apply_domain(const typed::union_map<Domain, Domain2> &umap2) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, pair<Range, Range2>> apply_domain(const typed::basic_map<Domain, Domain2> &umap2) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, pair<Range, Range2>> apply_domain(const typed::map<Domain, Domain2> &umap2) const;
  template <typename Arg3>
  inline typed::union_map<Domain, Arg3> apply_range(const typed::union_map<pair<Range, Range2>, Arg3> &umap2) const;
  template <typename Arg3>
  inline typed::union_map<Domain, Arg3> apply_range(const typed::basic_map<pair<Range, Range2>, Arg3> &umap2) const;
  template <typename Arg3>
  inline typed::union_map<Domain, Arg3> apply_range(const typed::map<pair<Range, Range2>, Arg3> &umap2) const;
  inline typed::map<Domain, pair<Range, Range2>> as_map() const;
  inline typed::multi_union_pw_aff<Domain, pair<Range, Range2>> as_multi_union_pw_aff() const;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> as_union_pw_multi_aff() const;
  inline typed::union_set<Domain> bind_range(const typed::multi_id<pair<Range, Range2>> &tuple) const;
  inline typed::union_map<Domain, pair<Range, Range2>> coalesce() const;
  inline typed::union_map<Domain, pair<Range, Range2>> curry() const = delete;
  inline typed::union_set<Domain, pair<Range, Range2>> deltas() const = delete;
  inline typed::union_map<Domain, pair<Range, Range2>> detect_equalities() const;
  inline typed::union_set<Domain> domain() const;
  inline typed::union_map<Domain, pair<Range, Range2>> domain_factor_domain() const = delete;
  inline typed::union_map<Domain, pair<Range, Range2>> domain_factor_range() const = delete;
  inline typed::union_map<pair<Domain, pair<Range, Range2>>, Domain> domain_map() const;
  inline typed::union_pw_multi_aff<pair<Domain, pair<Range, Range2>>, Domain> domain_map_union_pw_multi_aff() const;
  template <typename Domain2>
  inline typed::union_map<pair<Domain, Domain2>, pair<Range, Range2>> domain_product(const typed::union_map<Domain2, pair<Range, Range2>> &umap2) const;
  template <typename Domain2>
  inline typed::union_map<pair<Domain, Domain2>, pair<Range, Range2>> domain_product(const typed::basic_map<Domain2, pair<Range, Range2>> &umap2) const;
  template <typename Domain2>
  inline typed::union_map<pair<Domain, Domain2>, pair<Range, Range2>> domain_product(const typed::map<Domain2, pair<Range, Range2>> &umap2) const;
  inline typed::union_map<Domain, pair<Range, Range2>> domain_reverse() const = delete;
  inline typed::union_map<Domain, pair<Range, Range2>> drop_unused_params() const;
  static inline typed::union_map<Domain, pair<Range, Range2>> empty(const isl::ctx &ctx);
  inline typed::union_map<Domain, pair<Range, Range2>> eq_at(const typed::multi_union_pw_aff<> &mupa) const = delete;
  inline typed::union_map<Domain, pair<Range, Range2>> eq_at(const typed::multi_pw_aff<> &mupa) const = delete;
  inline typed::union_map<Domain, pair<Range, Range2>> eq_at(const typed::union_pw_aff<> &mupa) const = delete;
  inline bool every_map(const std::function<bool(typed::map<Domain, pair<Range, Range2>>)> &test) const;
  inline typed::map<Domain, pair<Range, Range2>> extract_map(const typed::space<Domain, pair<Range, Range2>> &space) const;
  inline void foreach_map(const std::function<void(typed::map<Domain, pair<Range, Range2>>)> &fn) const;
  inline typed::union_map<Domain, pair<Range, Range2>> gist(const typed::union_map<Domain, pair<Range, Range2>> &context) const;
  inline typed::union_map<Domain, pair<Range, Range2>> gist(const typed::basic_map<Domain, pair<Range, Range2>> &context) const;
  inline typed::union_map<Domain, pair<Range, Range2>> gist(const typed::map<Domain, pair<Range, Range2>> &context) const;
  inline typed::union_map<Domain, pair<Range, Range2>> gist_domain(const typed::union_set<Domain> &uset) const;
  inline typed::union_map<Domain, pair<Range, Range2>> gist_domain(const typed::basic_set<Domain> &uset) const;
  inline typed::union_map<Domain, pair<Range, Range2>> gist_domain(const typed::point<Domain> &uset) const;
  inline typed::union_map<Domain, pair<Range, Range2>> gist_domain(const typed::set<Domain> &uset) const;
  inline typed::union_map<Domain, pair<Range, Range2>> gist_params(const typed::set<> &set) const;
  inline typed::union_map<Domain, pair<Range, Range2>> gist_params(const typed::basic_set<> &set) const;
  inline typed::union_map<Domain, pair<Range, Range2>> gist_params(const typed::point<> &set) const;
  inline typed::union_map<Domain, pair<Range, Range2>> intersect(const typed::union_map<Domain, pair<Range, Range2>> &umap2) const;
  inline typed::union_map<Domain, pair<Range, Range2>> intersect(const typed::basic_map<Domain, pair<Range, Range2>> &umap2) const;
  inline typed::union_map<Domain, pair<Range, Range2>> intersect(const typed::map<Domain, pair<Range, Range2>> &umap2) const;
  inline typed::union_map<Domain, pair<Range, Range2>> intersect_domain(const typed::space<Domain> &space) const;
  inline typed::union_map<Domain, pair<Range, Range2>> intersect_domain(const typed::union_set<Domain> &uset) const;
  inline typed::union_map<Domain, pair<Range, Range2>> intersect_domain_wrapped_domain(const typed::union_set<> &domain) const = delete;
  inline typed::union_map<Domain, pair<Range, Range2>> intersect_domain_wrapped_domain(const typed::basic_set<> &domain) const = delete;
  inline typed::union_map<Domain, pair<Range, Range2>> intersect_domain_wrapped_domain(const typed::point<> &domain) const = delete;
  inline typed::union_map<Domain, pair<Range, Range2>> intersect_domain_wrapped_domain(const typed::set<> &domain) const = delete;
  inline typed::union_map<Domain, pair<Range, Range2>> intersect_params(const typed::set<> &set) const;
  inline typed::union_map<Domain, pair<Range, Range2>> intersect_params(const typed::basic_set<> &set) const;
  inline typed::union_map<Domain, pair<Range, Range2>> intersect_params(const typed::point<> &set) const;
  inline typed::union_map<Domain, pair<Range, Range2>> intersect_range(const typed::space<pair<Range, Range2>> &space) const;
  inline typed::union_map<Domain, pair<Range, Range2>> intersect_range(const typed::union_set<pair<Range, Range2>> &uset) const;
  inline typed::union_map<Domain, pair<Range, Range2>> intersect_range_wrapped_domain(const typed::union_set<Range> &domain) const;
  inline typed::union_map<Domain, pair<Range, Range2>> intersect_range_wrapped_domain(const typed::basic_set<Range> &domain) const;
  inline typed::union_map<Domain, pair<Range, Range2>> intersect_range_wrapped_domain(const typed::point<Range> &domain) const;
  inline typed::union_map<Domain, pair<Range, Range2>> intersect_range_wrapped_domain(const typed::set<Range> &domain) const;
  inline typed::union_map<Domain, pair<Range, Range2>> lexmax() const;
  inline typed::union_map<Domain, pair<Range, Range2>> lexmin() const;
  inline typed::map_list<Domain, pair<Range, Range2>> map_list() const;
  inline typed::map_list<Domain, pair<Range, Range2>> get_map_list() const = delete;
  inline typed::set<> params() const;
  template <typename Domain2>
  inline typed::union_map<Domain2, pair<Range, Range2>> preimage_domain(const typed::multi_aff<Domain2, Domain> &ma) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, pair<Range, Range2>> preimage_domain(const typed::multi_pw_aff<Domain2, Domain> &mpa) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, pair<Range, Range2>> preimage_domain(const typed::pw_multi_aff<Domain2, Domain> &pma) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, pair<Range, Range2>> preimage_domain(const typed::union_pw_multi_aff<Domain2, Domain> &upma) const;
  template <typename Arg3>
  inline typed::union_map<Domain, Arg3> preimage_range(const typed::multi_aff<Arg3, pair<Range, Range2>> &ma) const;
  template <typename Arg3>
  inline typed::union_map<Domain, Arg3> preimage_range(const typed::pw_multi_aff<Arg3, pair<Range, Range2>> &pma) const;
  template <typename Arg3>
  inline typed::union_map<Domain, Arg3> preimage_range(const typed::union_pw_multi_aff<Arg3, pair<Range, Range2>> &upma) const;
  template <typename Domain2, typename Arg3>
  inline typed::union_map<pair<Domain, Domain2>, pair<pair<Range, Range2>, Arg3>> product(const typed::union_map<Domain2, Arg3> &umap2) const;
  template <typename Domain2, typename Arg3>
  inline typed::union_map<pair<Domain, Domain2>, pair<pair<Range, Range2>, Arg3>> product(const typed::basic_map<Domain2, Arg3> &umap2) const;
  template <typename Domain2, typename Arg3>
  inline typed::union_map<pair<Domain, Domain2>, pair<pair<Range, Range2>, Arg3>> product(const typed::map<Domain2, Arg3> &umap2) const;
  inline typed::union_map<Domain, pair<Range, Range2>> project_out_all_params() const;
  inline typed::union_map<Domain, pair<Range, Range2>> project_out_param(const typed::id<Anonymous> &id) const;
  inline typed::union_map<Domain, pair<Range, Range2>> project_out_param(const std::string &id) const;
  inline typed::union_map<Domain, pair<Range, Range2>> project_out_param(const typed::id_list<Anonymous> &list) const;
  inline typed::union_set<pair<Range, Range2>> range() const;
  inline typed::union_map<Domain, Range> range_factor_domain() const;
  inline typed::union_map<Domain, Range2> range_factor_range() const;
  inline typed::union_map<pair<Domain, pair<Range, Range2>>, pair<Range, Range2>> range_map() const;
  template <typename Arg3>
  inline typed::union_map<Domain, pair<pair<Range, Range2>, Arg3>> range_product(const typed::union_map<Domain, Arg3> &umap2) const;
  template <typename Arg3>
  inline typed::union_map<Domain, pair<pair<Range, Range2>, Arg3>> range_product(const typed::basic_map<Domain, Arg3> &umap2) const;
  template <typename Arg3>
  inline typed::union_map<Domain, pair<pair<Range, Range2>, Arg3>> range_product(const typed::map<Domain, Arg3> &umap2) const;
  inline typed::union_map<Domain, pair<Range2, Range>> range_reverse() const;
  inline typed::union_map<pair<Range, Range2>, Domain> reverse() const;
  inline typed::space<> space() const;
  inline typed::space<Domain, pair<Range, Range2>> get_space() const = delete;
  inline typed::union_map<Domain, pair<Range, Range2>> subtract(const typed::union_map<Domain, pair<Range, Range2>> &umap2) const;
  inline typed::union_map<Domain, pair<Range, Range2>> subtract(const typed::basic_map<Domain, pair<Range, Range2>> &umap2) const;
  inline typed::union_map<Domain, pair<Range, Range2>> subtract(const typed::map<Domain, pair<Range, Range2>> &umap2) const;
  inline typed::union_map<Domain, pair<Range, Range2>> subtract_domain(const typed::union_set<Domain> &dom) const;
  inline typed::union_map<Domain, pair<Range, Range2>> subtract_domain(const typed::basic_set<Domain> &dom) const;
  inline typed::union_map<Domain, pair<Range, Range2>> subtract_domain(const typed::point<Domain> &dom) const;
  inline typed::union_map<Domain, pair<Range, Range2>> subtract_domain(const typed::set<Domain> &dom) const;
  inline typed::union_map<Domain, pair<Range, Range2>> subtract_range(const typed::union_set<pair<Range, Range2>> &dom) const;
  inline typed::union_map<Domain, pair<Range, Range2>> subtract_range(const typed::basic_set<pair<Range, Range2>> &dom) const;
  inline typed::union_map<Domain, pair<Range, Range2>> subtract_range(const typed::point<pair<Range, Range2>> &dom) const;
  inline typed::union_map<Domain, pair<Range, Range2>> subtract_range(const typed::set<pair<Range, Range2>> &dom) const;
  inline typed::union_map<pair<Domain, Range>, Range2> uncurry() const;
  inline typed::union_map<Domain, pair<Range, Range2>> unite(const typed::union_map<Domain, pair<Range, Range2>> &umap2) const;
  inline typed::union_map<Domain, pair<Range, Range2>> unite(const typed::basic_map<Domain, pair<Range, Range2>> &umap2) const;
  inline typed::union_map<Domain, pair<Range, Range2>> unite(const typed::map<Domain, pair<Range, Range2>> &umap2) const;
  inline typed::union_map<Domain, pair<Range, Range2>> universe() const;
  inline typed::union_set<pair<Domain, pair<Range, Range2>>> wrap() const;
};

template <typename T1, typename T2>
struct union_map<pair<T1, T2>, pair<T1, T2>> : public isl::union_map {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  union_map() = default;
  template <typename Arg1, typename Arg2,
            typename std::enable_if<
              std::is_base_of<T1, Arg1>{} &&
              std::is_base_of<T2, Arg2>{},
            bool>::type = true>
  union_map(const union_map<pair<Arg1, Arg2>, pair<Arg1, Arg2>> &obj) : isl::union_map(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::union_map>{}, bool>::type = true>
  union_map(const base &obj) : isl::union_map(obj) {}
 public:
  static union_map from(const isl::union_map &obj) {
    return union_map(obj);
  }
  inline /* implicit */ union_map(const typed::basic_map<pair<T1, T2>, pair<T1, T2>> &bmap);
  inline /* implicit */ union_map(const typed::map<pair<T1, T2>, pair<T1, T2>> &map);
  inline explicit union_map(const isl::ctx &ctx, const std::string &str);
  template <typename Domain2>
  inline typed::union_map<Domain2, pair<T1, T2>> apply_domain(const typed::union_map<pair<T1, T2>, Domain2> &umap2) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, pair<T1, T2>> apply_domain(const typed::basic_map<pair<T1, T2>, Domain2> &umap2) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, pair<T1, T2>> apply_domain(const typed::map<pair<T1, T2>, Domain2> &umap2) const;
  template <typename Range2>
  inline typed::union_map<pair<T1, T2>, Range2> apply_range(const typed::union_map<pair<T1, T2>, Range2> &umap2) const;
  template <typename Range2>
  inline typed::union_map<pair<T1, T2>, Range2> apply_range(const typed::basic_map<pair<T1, T2>, Range2> &umap2) const;
  template <typename Range2>
  inline typed::union_map<pair<T1, T2>, Range2> apply_range(const typed::map<pair<T1, T2>, Range2> &umap2) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> as_map() const;
  inline typed::multi_union_pw_aff<pair<T1, T2>, pair<T1, T2>> as_multi_union_pw_aff() const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<T1, T2>> as_union_pw_multi_aff() const;
  inline typed::union_set<pair<T1, T2>> bind_range(const typed::multi_id<pair<T1, T2>> &tuple) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> coalesce() const;
  inline typed::union_map<T1, pair<T2, pair<T1, T2>>> curry() const;
  inline typed::union_set<pair<T1, T2>> deltas() const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> detect_equalities() const;
  inline typed::union_set<pair<T1, T2>> domain() const;
  inline typed::union_map<T1, pair<T1, T2>> domain_factor_domain() const;
  inline typed::union_map<T2, pair<T1, T2>> domain_factor_range() const;
  inline typed::union_map<pair<pair<T1, T2>, pair<T1, T2>>, pair<T1, T2>> domain_map() const;
  inline typed::union_pw_multi_aff<pair<pair<T1, T2>, pair<T1, T2>>, pair<T1, T2>> domain_map_union_pw_multi_aff() const;
  template <typename Domain2>
  inline typed::union_map<pair<pair<T1, T2>, Domain2>, pair<T1, T2>> domain_product(const typed::union_map<Domain2, pair<T1, T2>> &umap2) const;
  template <typename Domain2>
  inline typed::union_map<pair<pair<T1, T2>, Domain2>, pair<T1, T2>> domain_product(const typed::basic_map<Domain2, pair<T1, T2>> &umap2) const;
  template <typename Domain2>
  inline typed::union_map<pair<pair<T1, T2>, Domain2>, pair<T1, T2>> domain_product(const typed::map<Domain2, pair<T1, T2>> &umap2) const;
  inline typed::union_map<pair<T2, T1>, pair<T1, T2>> domain_reverse() const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> drop_unused_params() const;
  static inline typed::union_map<pair<T1, T2>, pair<T1, T2>> empty(const isl::ctx &ctx);
  template <typename Range>
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> eq_at(const typed::multi_union_pw_aff<pair<T1, T2>, Range> &mupa) const;
  template <typename Range>
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> eq_at(const typed::multi_pw_aff<pair<T1, T2>, Range> &mupa) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> eq_at(const typed::union_pw_aff<pair<T1, T2>, Anonymous> &mupa) const;
  inline bool every_map(const std::function<bool(typed::map<pair<T1, T2>, pair<T1, T2>>)> &test) const;
  inline typed::map<pair<T1, T2>, pair<T1, T2>> extract_map(const typed::space<pair<T1, T2>, pair<T1, T2>> &space) const;
  inline void foreach_map(const std::function<void(typed::map<pair<T1, T2>, pair<T1, T2>>)> &fn) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> gist(const typed::union_map<pair<T1, T2>, pair<T1, T2>> &context) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> gist(const typed::basic_map<pair<T1, T2>, pair<T1, T2>> &context) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> gist(const typed::map<pair<T1, T2>, pair<T1, T2>> &context) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> gist_domain(const typed::union_set<pair<T1, T2>> &uset) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> gist_domain(const typed::basic_set<pair<T1, T2>> &uset) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> gist_domain(const typed::point<pair<T1, T2>> &uset) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> gist_domain(const typed::set<pair<T1, T2>> &uset) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> gist_params(const typed::set<> &set) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> gist_params(const typed::basic_set<> &set) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> gist_params(const typed::point<> &set) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> intersect(const typed::union_map<pair<T1, T2>, pair<T1, T2>> &umap2) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> intersect(const typed::basic_map<pair<T1, T2>, pair<T1, T2>> &umap2) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> intersect(const typed::map<pair<T1, T2>, pair<T1, T2>> &umap2) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> intersect_domain(const typed::space<pair<T1, T2>> &space) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> intersect_domain(const typed::union_set<pair<T1, T2>> &uset) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> intersect_domain_wrapped_domain(const typed::union_set<T1> &domain) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> intersect_domain_wrapped_domain(const typed::basic_set<T1> &domain) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> intersect_domain_wrapped_domain(const typed::point<T1> &domain) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> intersect_domain_wrapped_domain(const typed::set<T1> &domain) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> intersect_params(const typed::set<> &set) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> intersect_params(const typed::basic_set<> &set) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> intersect_params(const typed::point<> &set) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> intersect_range(const typed::space<pair<T1, T2>> &space) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> intersect_range(const typed::union_set<pair<T1, T2>> &uset) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> intersect_range_wrapped_domain(const typed::union_set<T1> &domain) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> intersect_range_wrapped_domain(const typed::basic_set<T1> &domain) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> intersect_range_wrapped_domain(const typed::point<T1> &domain) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> intersect_range_wrapped_domain(const typed::set<T1> &domain) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> lexmax() const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> lexmin() const;
  inline typed::map_list<pair<T1, T2>, pair<T1, T2>> map_list() const;
  inline typed::map_list<pair<T1, T2>, pair<T1, T2>> get_map_list() const = delete;
  inline typed::set<> params() const;
  template <typename Domain2>
  inline typed::union_map<Domain2, pair<T1, T2>> preimage_domain(const typed::multi_aff<Domain2, pair<T1, T2>> &ma) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, pair<T1, T2>> preimage_domain(const typed::multi_pw_aff<Domain2, pair<T1, T2>> &mpa) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, pair<T1, T2>> preimage_domain(const typed::pw_multi_aff<Domain2, pair<T1, T2>> &pma) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, pair<T1, T2>> preimage_domain(const typed::union_pw_multi_aff<Domain2, pair<T1, T2>> &upma) const;
  template <typename Range2>
  inline typed::union_map<pair<T1, T2>, Range2> preimage_range(const typed::multi_aff<Range2, pair<T1, T2>> &ma) const;
  template <typename Range2>
  inline typed::union_map<pair<T1, T2>, Range2> preimage_range(const typed::pw_multi_aff<Range2, pair<T1, T2>> &pma) const;
  template <typename Range2>
  inline typed::union_map<pair<T1, T2>, Range2> preimage_range(const typed::union_pw_multi_aff<Range2, pair<T1, T2>> &upma) const;
  template <typename Domain2, typename Range2>
  inline typed::union_map<pair<pair<T1, T2>, Domain2>, pair<pair<T1, T2>, Range2>> product(const typed::union_map<Domain2, Range2> &umap2) const;
  template <typename Domain2, typename Range2>
  inline typed::union_map<pair<pair<T1, T2>, Domain2>, pair<pair<T1, T2>, Range2>> product(const typed::basic_map<Domain2, Range2> &umap2) const;
  template <typename Domain2, typename Range2>
  inline typed::union_map<pair<pair<T1, T2>, Domain2>, pair<pair<T1, T2>, Range2>> product(const typed::map<Domain2, Range2> &umap2) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> project_out_all_params() const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> project_out_param(const typed::id<Anonymous> &id) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> project_out_param(const std::string &id) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> project_out_param(const typed::id_list<Anonymous> &list) const;
  inline typed::union_set<pair<T1, T2>> range() const;
  inline typed::union_map<pair<T1, T2>, T1> range_factor_domain() const;
  inline typed::union_map<pair<T1, T2>, T2> range_factor_range() const;
  inline typed::union_map<pair<pair<T1, T2>, pair<T1, T2>>, pair<T1, T2>> range_map() const;
  template <typename Range2>
  inline typed::union_map<pair<T1, T2>, pair<pair<T1, T2>, Range2>> range_product(const typed::union_map<pair<T1, T2>, Range2> &umap2) const;
  template <typename Range2>
  inline typed::union_map<pair<T1, T2>, pair<pair<T1, T2>, Range2>> range_product(const typed::basic_map<pair<T1, T2>, Range2> &umap2) const;
  template <typename Range2>
  inline typed::union_map<pair<T1, T2>, pair<pair<T1, T2>, Range2>> range_product(const typed::map<pair<T1, T2>, Range2> &umap2) const;
  inline typed::union_map<pair<T1, T2>, pair<T2, T1>> range_reverse() const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> reverse() const;
  inline typed::space<> space() const;
  inline typed::space<pair<T1, T2>, pair<T1, T2>> get_space() const = delete;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> subtract(const typed::union_map<pair<T1, T2>, pair<T1, T2>> &umap2) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> subtract(const typed::basic_map<pair<T1, T2>, pair<T1, T2>> &umap2) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> subtract(const typed::map<pair<T1, T2>, pair<T1, T2>> &umap2) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> subtract_domain(const typed::union_set<pair<T1, T2>> &dom) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> subtract_domain(const typed::basic_set<pair<T1, T2>> &dom) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> subtract_domain(const typed::point<pair<T1, T2>> &dom) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> subtract_domain(const typed::set<pair<T1, T2>> &dom) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> subtract_range(const typed::union_set<pair<T1, T2>> &dom) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> subtract_range(const typed::basic_set<pair<T1, T2>> &dom) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> subtract_range(const typed::point<pair<T1, T2>> &dom) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> subtract_range(const typed::set<pair<T1, T2>> &dom) const;
  inline typed::union_map<pair<pair<T1, T2>, T1>, T2> uncurry() const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> unite(const typed::union_map<pair<T1, T2>, pair<T1, T2>> &umap2) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> unite(const typed::basic_map<pair<T1, T2>, pair<T1, T2>> &umap2) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> unite(const typed::map<pair<T1, T2>, pair<T1, T2>> &umap2) const;
  inline typed::union_map<pair<T1, T2>, pair<T1, T2>> universe() const;
  inline typed::union_set<pair<pair<T1, T2>, pair<T1, T2>>> wrap() const;
};

template <typename T1, typename T2, typename Range, typename Range2>
struct union_map<pair<T1, T2>, pair<Range, Range2>> : public isl::union_map {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  union_map() = default;
  template <typename Arg1, typename Arg2, typename Arg3, typename Arg4,
            typename std::enable_if<
              std::is_base_of<T1, Arg1>{} &&
              std::is_base_of<T2, Arg2>{} &&
              std::is_base_of<Range, Arg3>{} &&
              std::is_base_of<Range2, Arg4>{},
            bool>::type = true>
  union_map(const union_map<pair<Arg1, Arg2>, pair<Arg3, Arg4>> &obj) : isl::union_map(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::union_map>{}, bool>::type = true>
  union_map(const base &obj) : isl::union_map(obj) {}
 public:
  static union_map from(const isl::union_map &obj) {
    return union_map(obj);
  }
  inline /* implicit */ union_map(const typed::basic_map<pair<T1, T2>, pair<Range, Range2>> &bmap);
  inline /* implicit */ union_map(const typed::map<pair<T1, T2>, pair<Range, Range2>> &map);
  inline explicit union_map(const isl::ctx &ctx, const std::string &str);
  template <typename Domain2>
  inline typed::union_map<Domain2, pair<Range, Range2>> apply_domain(const typed::union_map<pair<T1, T2>, Domain2> &umap2) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, pair<Range, Range2>> apply_domain(const typed::basic_map<pair<T1, T2>, Domain2> &umap2) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, pair<Range, Range2>> apply_domain(const typed::map<pair<T1, T2>, Domain2> &umap2) const;
  template <typename Arg2>
  inline typed::union_map<pair<T1, T2>, Arg2> apply_range(const typed::union_map<pair<Range, Range2>, Arg2> &umap2) const;
  template <typename Arg2>
  inline typed::union_map<pair<T1, T2>, Arg2> apply_range(const typed::basic_map<pair<Range, Range2>, Arg2> &umap2) const;
  template <typename Arg2>
  inline typed::union_map<pair<T1, T2>, Arg2> apply_range(const typed::map<pair<Range, Range2>, Arg2> &umap2) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> as_map() const;
  inline typed::multi_union_pw_aff<pair<T1, T2>, pair<Range, Range2>> as_multi_union_pw_aff() const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> as_union_pw_multi_aff() const;
  inline typed::union_set<pair<T1, T2>> bind_range(const typed::multi_id<pair<Range, Range2>> &tuple) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> coalesce() const;
  inline typed::union_map<T1, pair<T2, pair<Range, Range2>>> curry() const;
  inline typed::union_set<pair<T1, T2>, pair<Range, Range2>> deltas() const = delete;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> detect_equalities() const;
  inline typed::union_set<pair<T1, T2>> domain() const;
  inline typed::union_map<T1, pair<Range, Range2>> domain_factor_domain() const;
  inline typed::union_map<T2, pair<Range, Range2>> domain_factor_range() const;
  inline typed::union_map<pair<pair<T1, T2>, pair<Range, Range2>>, pair<T1, T2>> domain_map() const;
  inline typed::union_pw_multi_aff<pair<pair<T1, T2>, pair<Range, Range2>>, pair<T1, T2>> domain_map_union_pw_multi_aff() const;
  template <typename Domain2>
  inline typed::union_map<pair<pair<T1, T2>, Domain2>, pair<Range, Range2>> domain_product(const typed::union_map<Domain2, pair<Range, Range2>> &umap2) const;
  template <typename Domain2>
  inline typed::union_map<pair<pair<T1, T2>, Domain2>, pair<Range, Range2>> domain_product(const typed::basic_map<Domain2, pair<Range, Range2>> &umap2) const;
  template <typename Domain2>
  inline typed::union_map<pair<pair<T1, T2>, Domain2>, pair<Range, Range2>> domain_product(const typed::map<Domain2, pair<Range, Range2>> &umap2) const;
  inline typed::union_map<pair<T2, T1>, pair<Range, Range2>> domain_reverse() const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> drop_unused_params() const;
  static inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> empty(const isl::ctx &ctx);
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> eq_at(const typed::multi_union_pw_aff<> &mupa) const = delete;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> eq_at(const typed::multi_pw_aff<> &mupa) const = delete;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> eq_at(const typed::union_pw_aff<> &mupa) const = delete;
  inline bool every_map(const std::function<bool(typed::map<pair<T1, T2>, pair<Range, Range2>>)> &test) const;
  inline typed::map<pair<T1, T2>, pair<Range, Range2>> extract_map(const typed::space<pair<T1, T2>, pair<Range, Range2>> &space) const;
  inline void foreach_map(const std::function<void(typed::map<pair<T1, T2>, pair<Range, Range2>>)> &fn) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> gist(const typed::union_map<pair<T1, T2>, pair<Range, Range2>> &context) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> gist(const typed::basic_map<pair<T1, T2>, pair<Range, Range2>> &context) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> gist(const typed::map<pair<T1, T2>, pair<Range, Range2>> &context) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> gist_domain(const typed::union_set<pair<T1, T2>> &uset) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> gist_domain(const typed::basic_set<pair<T1, T2>> &uset) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> gist_domain(const typed::point<pair<T1, T2>> &uset) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> gist_domain(const typed::set<pair<T1, T2>> &uset) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> gist_params(const typed::set<> &set) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> gist_params(const typed::basic_set<> &set) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> gist_params(const typed::point<> &set) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> intersect(const typed::union_map<pair<T1, T2>, pair<Range, Range2>> &umap2) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> intersect(const typed::basic_map<pair<T1, T2>, pair<Range, Range2>> &umap2) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> intersect(const typed::map<pair<T1, T2>, pair<Range, Range2>> &umap2) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> intersect_domain(const typed::space<pair<T1, T2>> &space) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> intersect_domain(const typed::union_set<pair<T1, T2>> &uset) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> intersect_domain_wrapped_domain(const typed::union_set<T1> &domain) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> intersect_domain_wrapped_domain(const typed::basic_set<T1> &domain) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> intersect_domain_wrapped_domain(const typed::point<T1> &domain) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> intersect_domain_wrapped_domain(const typed::set<T1> &domain) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> intersect_params(const typed::set<> &set) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> intersect_params(const typed::basic_set<> &set) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> intersect_params(const typed::point<> &set) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> intersect_range(const typed::space<pair<Range, Range2>> &space) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> intersect_range(const typed::union_set<pair<Range, Range2>> &uset) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> intersect_range_wrapped_domain(const typed::union_set<Range> &domain) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> intersect_range_wrapped_domain(const typed::basic_set<Range> &domain) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> intersect_range_wrapped_domain(const typed::point<Range> &domain) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> intersect_range_wrapped_domain(const typed::set<Range> &domain) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> lexmax() const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> lexmin() const;
  inline typed::map_list<pair<T1, T2>, pair<Range, Range2>> map_list() const;
  inline typed::map_list<pair<T1, T2>, pair<Range, Range2>> get_map_list() const = delete;
  inline typed::set<> params() const;
  template <typename Domain2>
  inline typed::union_map<Domain2, pair<Range, Range2>> preimage_domain(const typed::multi_aff<Domain2, pair<T1, T2>> &ma) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, pair<Range, Range2>> preimage_domain(const typed::multi_pw_aff<Domain2, pair<T1, T2>> &mpa) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, pair<Range, Range2>> preimage_domain(const typed::pw_multi_aff<Domain2, pair<T1, T2>> &pma) const;
  template <typename Domain2>
  inline typed::union_map<Domain2, pair<Range, Range2>> preimage_domain(const typed::union_pw_multi_aff<Domain2, pair<T1, T2>> &upma) const;
  template <typename Arg2>
  inline typed::union_map<pair<T1, T2>, Arg2> preimage_range(const typed::multi_aff<Arg2, pair<Range, Range2>> &ma) const;
  template <typename Arg2>
  inline typed::union_map<pair<T1, T2>, Arg2> preimage_range(const typed::pw_multi_aff<Arg2, pair<Range, Range2>> &pma) const;
  template <typename Arg2>
  inline typed::union_map<pair<T1, T2>, Arg2> preimage_range(const typed::union_pw_multi_aff<Arg2, pair<Range, Range2>> &upma) const;
  template <typename Domain2, typename Arg2>
  inline typed::union_map<pair<pair<T1, T2>, Domain2>, pair<pair<Range, Range2>, Arg2>> product(const typed::union_map<Domain2, Arg2> &umap2) const;
  template <typename Domain2, typename Arg2>
  inline typed::union_map<pair<pair<T1, T2>, Domain2>, pair<pair<Range, Range2>, Arg2>> product(const typed::basic_map<Domain2, Arg2> &umap2) const;
  template <typename Domain2, typename Arg2>
  inline typed::union_map<pair<pair<T1, T2>, Domain2>, pair<pair<Range, Range2>, Arg2>> product(const typed::map<Domain2, Arg2> &umap2) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> project_out_all_params() const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> project_out_param(const typed::id<Anonymous> &id) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> project_out_param(const std::string &id) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> project_out_param(const typed::id_list<Anonymous> &list) const;
  inline typed::union_set<pair<Range, Range2>> range() const;
  inline typed::union_map<pair<T1, T2>, Range> range_factor_domain() const;
  inline typed::union_map<pair<T1, T2>, Range2> range_factor_range() const;
  inline typed::union_map<pair<pair<T1, T2>, pair<Range, Range2>>, pair<Range, Range2>> range_map() const;
  template <typename Arg2>
  inline typed::union_map<pair<T1, T2>, pair<pair<Range, Range2>, Arg2>> range_product(const typed::union_map<pair<T1, T2>, Arg2> &umap2) const;
  template <typename Arg2>
  inline typed::union_map<pair<T1, T2>, pair<pair<Range, Range2>, Arg2>> range_product(const typed::basic_map<pair<T1, T2>, Arg2> &umap2) const;
  template <typename Arg2>
  inline typed::union_map<pair<T1, T2>, pair<pair<Range, Range2>, Arg2>> range_product(const typed::map<pair<T1, T2>, Arg2> &umap2) const;
  inline typed::union_map<pair<T1, T2>, pair<Range2, Range>> range_reverse() const;
  inline typed::union_map<pair<Range, Range2>, pair<T1, T2>> reverse() const;
  inline typed::space<> space() const;
  inline typed::space<pair<T1, T2>, pair<Range, Range2>> get_space() const = delete;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> subtract(const typed::union_map<pair<T1, T2>, pair<Range, Range2>> &umap2) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> subtract(const typed::basic_map<pair<T1, T2>, pair<Range, Range2>> &umap2) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> subtract(const typed::map<pair<T1, T2>, pair<Range, Range2>> &umap2) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> subtract_domain(const typed::union_set<pair<T1, T2>> &dom) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> subtract_domain(const typed::basic_set<pair<T1, T2>> &dom) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> subtract_domain(const typed::point<pair<T1, T2>> &dom) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> subtract_domain(const typed::set<pair<T1, T2>> &dom) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> subtract_range(const typed::union_set<pair<Range, Range2>> &dom) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> subtract_range(const typed::basic_set<pair<Range, Range2>> &dom) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> subtract_range(const typed::point<pair<Range, Range2>> &dom) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> subtract_range(const typed::set<pair<Range, Range2>> &dom) const;
  inline typed::union_map<pair<pair<T1, T2>, Range>, Range2> uncurry() const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> unite(const typed::union_map<pair<T1, T2>, pair<Range, Range2>> &umap2) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> unite(const typed::basic_map<pair<T1, T2>, pair<Range, Range2>> &umap2) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> unite(const typed::map<pair<T1, T2>, pair<Range, Range2>> &umap2) const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> universe() const;
  inline typed::union_set<pair<pair<T1, T2>, pair<Range, Range2>>> wrap() const;
};

template <>
struct union_pw_aff<Anonymous> : public isl::union_pw_aff {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  union_pw_aff() = default;
  union_pw_aff(const isl::union_pw_aff &obj) : isl::union_pw_aff(obj) {}
  static union_pw_aff from(const isl::union_pw_aff &obj) {
    return union_pw_aff(obj);
  }
  inline /* implicit */ union_pw_aff(const typed::aff<Anonymous> &aff);
  inline /* implicit */ union_pw_aff(const typed::pw_aff<Anonymous> &pa);
  inline explicit union_pw_aff(const isl::ctx &ctx, const std::string &str);
  inline typed::multi_union_pw_aff<Anonymous> add(const typed::multi_union_pw_aff<Anonymous> &multi2) const;
  inline typed::union_pw_aff<Anonymous> add(const typed::union_pw_aff<Anonymous> &upa2) const;
  inline typed::union_pw_multi_aff<Anonymous> add(const typed::union_pw_multi_aff<Anonymous> &upma2) const;
  inline typed::union_pw_aff<Anonymous> add(const typed::aff<Anonymous> &upa2) const;
  inline typed::union_pw_aff<Anonymous> add(const typed::pw_aff<Anonymous> &upa2) const;
  template <typename Range>
  inline typed::union_pw_multi_aff<Range> apply(const typed::union_pw_multi_aff<Anonymous, Range> &upma2) const;
  inline typed::multi_union_pw_aff<Anonymous> as_multi_union_pw_aff() const;
  inline typed::pw_multi_aff<Anonymous> as_pw_multi_aff() const;
  inline typed::union_map<Anonymous> as_union_map() const = delete;
  inline typed::union_pw_aff<Anonymous> at(int pos) const;
  inline typed::union_set<> bind(const typed::multi_id<Anonymous> &tuple) const;
  inline typed::union_set<> bind(const typed::id<Anonymous> &id) const;
  inline typed::union_set<> bind(const std::string &id) const;
  inline typed::union_pw_aff<Anonymous> coalesce() const;
  inline typed::union_set<> domain() const;
  inline typed::union_pw_aff<Anonymous> drop_unused_params() const;
  inline typed::pw_multi_aff<Anonymous> extract_pw_multi_aff(const typed::space<Anonymous> &space) const;
  inline typed::union_pw_aff<Anonymous> gist(const typed::union_set<> &context) const;
  inline typed::union_pw_aff<Anonymous> gist(const typed::basic_set<> &context) const;
  inline typed::union_pw_aff<Anonymous> gist(const typed::point<> &context) const;
  inline typed::union_pw_aff<Anonymous> gist(const typed::set<> &context) const;
  inline typed::multi_union_pw_aff<Anonymous> gist_params(const typed::set<> &context) const;
  inline typed::union_pw_aff<Anonymous> intersect_domain(const typed::space<> &space) const = delete;
  inline typed::union_pw_aff<Anonymous> intersect_domain(const typed::union_set<> &uset) const = delete;
  inline typed::union_pw_aff<Anonymous> intersect_domain_wrapped_domain(const typed::union_set<> &uset) const = delete;
  inline typed::union_pw_aff<Anonymous> intersect_domain_wrapped_domain(const typed::basic_set<> &uset) const = delete;
  inline typed::union_pw_aff<Anonymous> intersect_domain_wrapped_domain(const typed::point<> &uset) const = delete;
  inline typed::union_pw_aff<Anonymous> intersect_domain_wrapped_domain(const typed::set<> &uset) const = delete;
  inline typed::union_pw_aff<Anonymous> intersect_params(const typed::set<> &set) const;
  inline typed::union_pw_aff<Anonymous> intersect_params(const typed::basic_set<> &set) const;
  inline typed::union_pw_aff<Anonymous> intersect_params(const typed::point<> &set) const;
  inline typed::union_pw_aff_list<Anonymous> list() const;
  inline typed::multi_union_pw_aff<Anonymous> neg() const;
  inline typed::union_pw_multi_aff<Anonymous> preimage_domain_wrapped_domain(const typed::union_pw_multi_aff<> &upma2) const = delete;
  inline typed::union_pw_aff<Anonymous> pullback(const typed::union_pw_multi_aff<> &upma) const = delete;
  inline typed::union_pw_aff<Anonymous> pullback(const typed::multi_aff<> &upma) const = delete;
  inline typed::union_pw_aff<Anonymous> pullback(const typed::pw_multi_aff<> &upma) const = delete;
  inline typed::union_pw_aff<Anonymous> pullback(const typed::union_pw_aff<> &upma) const = delete;
  inline typed::pw_multi_aff_list<Anonymous> pw_multi_aff_list() const;
  inline typed::union_pw_multi_aff<Anonymous> range_factor_domain() const = delete;
  inline typed::union_pw_multi_aff<Anonymous> range_factor_range() const = delete;
  inline typed::multi_union_pw_aff<Anonymous> range_product(const typed::multi_union_pw_aff<> &multi2) const = delete;
  inline typed::union_pw_multi_aff<Anonymous> range_product(const typed::union_pw_multi_aff<> &upma2) const = delete;
  inline typed::multi_union_pw_aff<Anonymous> scale(const typed::multi_val<Anonymous> &mv) const;
  inline typed::multi_union_pw_aff<Anonymous> scale(const typed::val<Anonymous> &v) const;
  inline typed::multi_union_pw_aff<Anonymous> scale(long v) const;
  inline typed::multi_union_pw_aff<Anonymous> scale_down(const typed::multi_val<Anonymous> &mv) const;
  inline typed::multi_union_pw_aff<Anonymous> scale_down(const typed::val<Anonymous> &v) const;
  inline typed::multi_union_pw_aff<Anonymous> scale_down(long v) const;
  inline typed::multi_union_pw_aff<Anonymous> set_at(int pos, const typed::union_pw_aff<Anonymous> &el) const;
  template <typename Domain2>
  inline typed::multi_union_pw_aff<Domain2> set_range_tuple(const typed::id<Anonymous> &id) const;
  template <typename Domain2>
  inline typed::multi_union_pw_aff<Domain2> set_range_tuple(const std::string &id) const;
  inline typed::space<> space() const;
  inline typed::space<Anonymous> get_space() const = delete;
  inline typed::multi_union_pw_aff<Anonymous> sub(const typed::multi_union_pw_aff<Anonymous> &multi2) const;
  inline typed::union_pw_aff<Anonymous> sub(const typed::union_pw_aff<Anonymous> &upa2) const;
  inline typed::union_pw_multi_aff<Anonymous> sub(const typed::union_pw_multi_aff<Anonymous> &upma2) const;
  inline typed::union_pw_aff<Anonymous> sub(const typed::aff<Anonymous> &upa2) const;
  inline typed::union_pw_aff<Anonymous> sub(const typed::pw_aff<Anonymous> &upa2) const;
  inline typed::union_pw_aff<Anonymous> subtract_domain(const typed::space<> &space) const = delete;
  inline typed::union_pw_aff<Anonymous> subtract_domain(const typed::union_set<> &uset) const = delete;
  inline typed::multi_union_pw_aff<Anonymous> union_add(const typed::multi_union_pw_aff<Anonymous> &mupa2) const;
  inline typed::union_pw_aff<Anonymous> union_add(const typed::union_pw_aff<Anonymous> &upa2) const;
  inline typed::union_pw_multi_aff<Anonymous> union_add(const typed::union_pw_multi_aff<Anonymous> &upma2) const;
  inline typed::union_pw_aff<Anonymous> union_add(const typed::aff<Anonymous> &upa2) const;
  inline typed::union_pw_aff<Anonymous> union_add(const typed::pw_aff<Anonymous> &upa2) const;
};

template <typename Domain>
struct union_pw_aff<Domain, Anonymous> : public isl::union_pw_aff {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  union_pw_aff() = default;
  template <typename Arg1,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{},
            bool>::type = true>
  union_pw_aff(const union_pw_aff<Arg1, Anonymous> &obj) : isl::union_pw_aff(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::union_pw_aff>{}, bool>::type = true>
  union_pw_aff(const base &obj) : isl::union_pw_aff(obj) {}
 public:
  static union_pw_aff from(const isl::union_pw_aff &obj) {
    return union_pw_aff(obj);
  }
  inline /* implicit */ union_pw_aff(const typed::aff<Domain, Anonymous> &aff);
  inline /* implicit */ union_pw_aff(const typed::pw_aff<Domain, Anonymous> &pa);
  inline explicit union_pw_aff(const isl::ctx &ctx, const std::string &str);
  inline typed::multi_union_pw_aff<Domain, Anonymous> add(const typed::multi_union_pw_aff<Domain, Anonymous> &multi2) const;
  inline typed::union_pw_aff<Domain, Anonymous> add(const typed::union_pw_aff<Domain, Anonymous> &upa2) const;
  inline typed::union_pw_multi_aff<Domain, Anonymous> add(const typed::union_pw_multi_aff<Domain, Anonymous> &upma2) const;
  inline typed::union_pw_aff<Domain, Anonymous> add(const typed::aff<Domain, Anonymous> &upa2) const;
  inline typed::union_pw_aff<Domain, Anonymous> add(const typed::pw_aff<Domain, Anonymous> &upa2) const;
  template <typename Range2>
  inline typed::union_pw_multi_aff<Domain, Range2> apply(const typed::union_pw_multi_aff<Anonymous, Range2> &upma2) const;
  inline typed::multi_union_pw_aff<Domain, Anonymous> as_multi_union_pw_aff() const;
  inline typed::pw_multi_aff<Domain, Anonymous> as_pw_multi_aff() const;
  inline typed::union_map<Domain, Anonymous> as_union_map() const;
  inline typed::union_pw_aff<Domain, Anonymous> at(int pos) const;
  inline typed::union_set<Domain> bind(const typed::multi_id<Anonymous> &tuple) const;
  inline typed::union_set<Domain> bind(const typed::id<Anonymous> &id) const;
  inline typed::union_set<Domain> bind(const std::string &id) const;
  inline typed::union_pw_aff<Domain, Anonymous> coalesce() const;
  inline typed::union_set<Domain> domain() const;
  inline typed::union_pw_aff<Domain, Anonymous> drop_unused_params() const;
  inline typed::pw_multi_aff<Domain, Anonymous> extract_pw_multi_aff(const typed::space<Domain, Anonymous> &space) const;
  inline typed::union_pw_aff<Domain, Anonymous> gist(const typed::union_set<Domain> &context) const;
  inline typed::union_pw_aff<Domain, Anonymous> gist(const typed::basic_set<Domain> &context) const;
  inline typed::union_pw_aff<Domain, Anonymous> gist(const typed::point<Domain> &context) const;
  inline typed::union_pw_aff<Domain, Anonymous> gist(const typed::set<Domain> &context) const;
  inline typed::multi_union_pw_aff<Domain, Anonymous> gist_params(const typed::set<> &context) const;
  inline typed::union_pw_aff<Domain, Anonymous> intersect_domain(const typed::space<Domain> &space) const;
  inline typed::union_pw_aff<Domain, Anonymous> intersect_domain(const typed::union_set<Domain> &uset) const;
  inline typed::union_pw_aff<Domain, Anonymous> intersect_domain_wrapped_domain(const typed::union_set<> &uset) const = delete;
  inline typed::union_pw_aff<Domain, Anonymous> intersect_domain_wrapped_domain(const typed::basic_set<> &uset) const = delete;
  inline typed::union_pw_aff<Domain, Anonymous> intersect_domain_wrapped_domain(const typed::point<> &uset) const = delete;
  inline typed::union_pw_aff<Domain, Anonymous> intersect_domain_wrapped_domain(const typed::set<> &uset) const = delete;
  inline typed::union_pw_aff<Domain, Anonymous> intersect_params(const typed::set<> &set) const;
  inline typed::union_pw_aff<Domain, Anonymous> intersect_params(const typed::basic_set<> &set) const;
  inline typed::union_pw_aff<Domain, Anonymous> intersect_params(const typed::point<> &set) const;
  inline typed::union_pw_aff_list<Domain, Anonymous> list() const;
  inline typed::multi_union_pw_aff<Domain, Anonymous> neg() const;
  inline typed::union_pw_multi_aff<Domain, Anonymous> preimage_domain_wrapped_domain(const typed::union_pw_multi_aff<> &upma2) const = delete;
  template <typename Domain2>
  inline typed::union_pw_aff<Domain2, Anonymous> pullback(const typed::union_pw_multi_aff<Domain2, Domain> &upma) const;
  inline typed::union_pw_aff<Anonymous> pullback(const typed::union_pw_multi_aff<Domain> &upma) const;
  template <typename Domain2>
  inline typed::union_pw_aff<Domain2, Anonymous> pullback(const typed::multi_aff<Domain2, Domain> &upma) const;
  inline typed::union_pw_aff<Anonymous> pullback(const typed::multi_aff<Domain> &upma) const;
  template <typename Domain2>
  inline typed::union_pw_aff<Domain2, Anonymous> pullback(const typed::pw_multi_aff<Domain2, Domain> &upma) const;
  inline typed::union_pw_aff<Anonymous> pullback(const typed::pw_multi_aff<Domain> &upma) const;
  template <typename Domain2>
  inline typed::union_pw_aff<Domain2, Anonymous> pullback(const typed::union_pw_aff<Domain2, Domain> &upma) const;
  inline typed::union_pw_aff<Anonymous> pullback(const typed::union_pw_aff<Domain> &upma) const;
  inline typed::pw_multi_aff_list<Domain, Anonymous> pw_multi_aff_list() const;
  inline typed::union_pw_multi_aff<Domain, Anonymous> range_factor_domain() const = delete;
  inline typed::union_pw_multi_aff<Domain, Anonymous> range_factor_range() const = delete;
  template <typename Range2>
  inline typed::multi_union_pw_aff<Domain, pair<Anonymous, Range2>> range_product(const typed::multi_union_pw_aff<Domain, Range2> &multi2) const;
  template <typename Range2>
  inline typed::union_pw_multi_aff<Domain, pair<Anonymous, Range2>> range_product(const typed::union_pw_multi_aff<Domain, Range2> &upma2) const;
  inline typed::multi_union_pw_aff<Domain, Anonymous> scale(const typed::multi_val<Anonymous> &mv) const;
  inline typed::multi_union_pw_aff<Domain, Anonymous> scale(const typed::val<Anonymous> &v) const;
  inline typed::multi_union_pw_aff<Domain, Anonymous> scale(long v) const;
  inline typed::multi_union_pw_aff<Domain, Anonymous> scale_down(const typed::multi_val<Anonymous> &mv) const;
  inline typed::multi_union_pw_aff<Domain, Anonymous> scale_down(const typed::val<Anonymous> &v) const;
  inline typed::multi_union_pw_aff<Domain, Anonymous> scale_down(long v) const;
  inline typed::multi_union_pw_aff<Domain, Anonymous> set_at(int pos, const typed::union_pw_aff<Domain, Anonymous> &el) const;
  template <typename Range2>
  inline typed::multi_union_pw_aff<Domain, Range2> set_range_tuple(const typed::id<Anonymous> &id) const;
  template <typename Range2>
  inline typed::multi_union_pw_aff<Domain, Range2> set_range_tuple(const std::string &id) const;
  inline typed::space<> space() const;
  inline typed::space<Domain, Anonymous> get_space() const = delete;
  inline typed::multi_union_pw_aff<Domain, Anonymous> sub(const typed::multi_union_pw_aff<Domain, Anonymous> &multi2) const;
  inline typed::union_pw_aff<Domain, Anonymous> sub(const typed::union_pw_aff<Domain, Anonymous> &upa2) const;
  inline typed::union_pw_multi_aff<Domain, Anonymous> sub(const typed::union_pw_multi_aff<Domain, Anonymous> &upma2) const;
  inline typed::union_pw_aff<Domain, Anonymous> sub(const typed::aff<Domain, Anonymous> &upa2) const;
  inline typed::union_pw_aff<Domain, Anonymous> sub(const typed::pw_aff<Domain, Anonymous> &upa2) const;
  inline typed::union_pw_aff<Domain, Anonymous> subtract_domain(const typed::space<Domain> &space) const;
  inline typed::union_pw_aff<Domain, Anonymous> subtract_domain(const typed::union_set<Domain> &uset) const;
  inline typed::multi_union_pw_aff<Domain, Anonymous> union_add(const typed::multi_union_pw_aff<Domain, Anonymous> &mupa2) const;
  inline typed::union_pw_aff<Domain, Anonymous> union_add(const typed::union_pw_aff<Domain, Anonymous> &upa2) const;
  inline typed::union_pw_multi_aff<Domain, Anonymous> union_add(const typed::union_pw_multi_aff<Domain, Anonymous> &upma2) const;
  inline typed::union_pw_aff<Domain, Anonymous> union_add(const typed::aff<Domain, Anonymous> &upa2) const;
  inline typed::union_pw_aff<Domain, Anonymous> union_add(const typed::pw_aff<Domain, Anonymous> &upa2) const;
};

template <typename Domain, typename Domain2>
struct union_pw_aff<pair<Domain, Domain2>, Anonymous> : public isl::union_pw_aff {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  union_pw_aff() = default;
  template <typename Arg1, typename Arg2,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{} &&
              std::is_base_of<Domain2, Arg2>{},
            bool>::type = true>
  union_pw_aff(const union_pw_aff<pair<Arg1, Arg2>, Anonymous> &obj) : isl::union_pw_aff(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::union_pw_aff>{}, bool>::type = true>
  union_pw_aff(const base &obj) : isl::union_pw_aff(obj) {}
 public:
  static union_pw_aff from(const isl::union_pw_aff &obj) {
    return union_pw_aff(obj);
  }
  inline /* implicit */ union_pw_aff(const typed::aff<pair<Domain, Domain2>, Anonymous> &aff);
  inline /* implicit */ union_pw_aff(const typed::pw_aff<pair<Domain, Domain2>, Anonymous> &pa);
  inline explicit union_pw_aff(const isl::ctx &ctx, const std::string &str);
  inline typed::multi_union_pw_aff<pair<Domain, Domain2>, Anonymous> add(const typed::multi_union_pw_aff<pair<Domain, Domain2>, Anonymous> &multi2) const;
  inline typed::union_pw_aff<pair<Domain, Domain2>, Anonymous> add(const typed::union_pw_aff<pair<Domain, Domain2>, Anonymous> &upa2) const;
  inline typed::union_pw_multi_aff<pair<Domain, Domain2>, Anonymous> add(const typed::union_pw_multi_aff<pair<Domain, Domain2>, Anonymous> &upma2) const;
  inline typed::union_pw_aff<pair<Domain, Domain2>, Anonymous> add(const typed::aff<pair<Domain, Domain2>, Anonymous> &upa2) const;
  inline typed::union_pw_aff<pair<Domain, Domain2>, Anonymous> add(const typed::pw_aff<pair<Domain, Domain2>, Anonymous> &upa2) const;
  template <typename Range2>
  inline typed::union_pw_multi_aff<pair<Domain, Domain2>, Range2> apply(const typed::union_pw_multi_aff<Anonymous, Range2> &upma2) const;
  inline typed::multi_union_pw_aff<pair<Domain, Domain2>, Anonymous> as_multi_union_pw_aff() const;
  inline typed::pw_multi_aff<pair<Domain, Domain2>, Anonymous> as_pw_multi_aff() const;
  inline typed::union_map<pair<Domain, Domain2>, Anonymous> as_union_map() const;
  inline typed::union_pw_aff<pair<Domain, Domain2>, Anonymous> at(int pos) const;
  inline typed::union_set<pair<Domain, Domain2>> bind(const typed::multi_id<Anonymous> &tuple) const;
  inline typed::union_set<pair<Domain, Domain2>> bind(const typed::id<Anonymous> &id) const;
  inline typed::union_set<pair<Domain, Domain2>> bind(const std::string &id) const;
  inline typed::union_pw_aff<pair<Domain, Domain2>, Anonymous> coalesce() const;
  inline typed::union_set<pair<Domain, Domain2>> domain() const;
  inline typed::union_pw_aff<pair<Domain, Domain2>, Anonymous> drop_unused_params() const;
  inline typed::pw_multi_aff<pair<Domain, Domain2>, Anonymous> extract_pw_multi_aff(const typed::space<pair<Domain, Domain2>, Anonymous> &space) const;
  inline typed::union_pw_aff<pair<Domain, Domain2>, Anonymous> gist(const typed::union_set<pair<Domain, Domain2>> &context) const;
  inline typed::union_pw_aff<pair<Domain, Domain2>, Anonymous> gist(const typed::basic_set<pair<Domain, Domain2>> &context) const;
  inline typed::union_pw_aff<pair<Domain, Domain2>, Anonymous> gist(const typed::point<pair<Domain, Domain2>> &context) const;
  inline typed::union_pw_aff<pair<Domain, Domain2>, Anonymous> gist(const typed::set<pair<Domain, Domain2>> &context) const;
  inline typed::multi_union_pw_aff<pair<Domain, Domain2>, Anonymous> gist_params(const typed::set<> &context) const;
  inline typed::union_pw_aff<pair<Domain, Domain2>, Anonymous> intersect_domain(const typed::space<pair<Domain, Domain2>> &space) const;
  inline typed::union_pw_aff<pair<Domain, Domain2>, Anonymous> intersect_domain(const typed::union_set<pair<Domain, Domain2>> &uset) const;
  inline typed::union_pw_aff<pair<Domain, Domain2>, Anonymous> intersect_domain_wrapped_domain(const typed::union_set<Domain> &uset) const;
  inline typed::union_pw_aff<pair<Domain, Domain2>, Anonymous> intersect_domain_wrapped_domain(const typed::basic_set<Domain> &uset) const;
  inline typed::union_pw_aff<pair<Domain, Domain2>, Anonymous> intersect_domain_wrapped_domain(const typed::point<Domain> &uset) const;
  inline typed::union_pw_aff<pair<Domain, Domain2>, Anonymous> intersect_domain_wrapped_domain(const typed::set<Domain> &uset) const;
  inline typed::union_pw_aff<pair<Domain, Domain2>, Anonymous> intersect_params(const typed::set<> &set) const;
  inline typed::union_pw_aff<pair<Domain, Domain2>, Anonymous> intersect_params(const typed::basic_set<> &set) const;
  inline typed::union_pw_aff<pair<Domain, Domain2>, Anonymous> intersect_params(const typed::point<> &set) const;
  inline typed::union_pw_aff_list<pair<Domain, Domain2>, Anonymous> list() const;
  inline typed::multi_union_pw_aff<pair<Domain, Domain2>, Anonymous> neg() const;
  template <typename Domain3>
  inline typed::union_pw_multi_aff<pair<Domain3, Domain2>, Anonymous> preimage_domain_wrapped_domain(const typed::union_pw_multi_aff<Domain3, Domain> &upma2) const;
  template <typename Arg2>
  inline typed::union_pw_aff<Arg2, Anonymous> pullback(const typed::union_pw_multi_aff<Arg2, pair<Domain, Domain2>> &upma) const;
  inline typed::union_pw_aff<Anonymous> pullback(const typed::union_pw_multi_aff<pair<Domain, Domain2>> &upma) const;
  template <typename Arg2>
  inline typed::union_pw_aff<Arg2, Anonymous> pullback(const typed::multi_aff<Arg2, pair<Domain, Domain2>> &upma) const;
  inline typed::union_pw_aff<Anonymous> pullback(const typed::multi_aff<pair<Domain, Domain2>> &upma) const;
  template <typename Arg2>
  inline typed::union_pw_aff<Arg2, Anonymous> pullback(const typed::pw_multi_aff<Arg2, pair<Domain, Domain2>> &upma) const;
  inline typed::union_pw_aff<Anonymous> pullback(const typed::pw_multi_aff<pair<Domain, Domain2>> &upma) const;
  template <typename Arg2>
  inline typed::union_pw_aff<Arg2, Anonymous> pullback(const typed::union_pw_aff<Arg2, pair<Domain, Domain2>> &upma) const;
  inline typed::union_pw_aff<Anonymous> pullback(const typed::union_pw_aff<pair<Domain, Domain2>> &upma) const;
  inline typed::pw_multi_aff_list<pair<Domain, Domain2>, Anonymous> pw_multi_aff_list() const;
  inline typed::union_pw_multi_aff<pair<Domain, Domain2>, Anonymous> range_factor_domain() const = delete;
  inline typed::union_pw_multi_aff<pair<Domain, Domain2>, Anonymous> range_factor_range() const = delete;
  template <typename Range2>
  inline typed::multi_union_pw_aff<pair<Domain, Domain2>, pair<Anonymous, Range2>> range_product(const typed::multi_union_pw_aff<pair<Domain, Domain2>, Range2> &multi2) const;
  template <typename Range2>
  inline typed::union_pw_multi_aff<pair<Domain, Domain2>, pair<Anonymous, Range2>> range_product(const typed::union_pw_multi_aff<pair<Domain, Domain2>, Range2> &upma2) const;
  inline typed::multi_union_pw_aff<pair<Domain, Domain2>, Anonymous> scale(const typed::multi_val<Anonymous> &mv) const;
  inline typed::multi_union_pw_aff<pair<Domain, Domain2>, Anonymous> scale(const typed::val<Anonymous> &v) const;
  inline typed::multi_union_pw_aff<pair<Domain, Domain2>, Anonymous> scale(long v) const;
  inline typed::multi_union_pw_aff<pair<Domain, Domain2>, Anonymous> scale_down(const typed::multi_val<Anonymous> &mv) const;
  inline typed::multi_union_pw_aff<pair<Domain, Domain2>, Anonymous> scale_down(const typed::val<Anonymous> &v) const;
  inline typed::multi_union_pw_aff<pair<Domain, Domain2>, Anonymous> scale_down(long v) const;
  inline typed::multi_union_pw_aff<pair<Domain, Domain2>, Anonymous> set_at(int pos, const typed::union_pw_aff<pair<Domain, Domain2>, Anonymous> &el) const;
  template <typename Range2>
  inline typed::multi_union_pw_aff<pair<Domain, Domain2>, Range2> set_range_tuple(const typed::id<Anonymous> &id) const;
  template <typename Range2>
  inline typed::multi_union_pw_aff<pair<Domain, Domain2>, Range2> set_range_tuple(const std::string &id) const;
  inline typed::space<> space() const;
  inline typed::space<pair<Domain, Domain2>, Anonymous> get_space() const = delete;
  inline typed::multi_union_pw_aff<pair<Domain, Domain2>, Anonymous> sub(const typed::multi_union_pw_aff<pair<Domain, Domain2>, Anonymous> &multi2) const;
  inline typed::union_pw_aff<pair<Domain, Domain2>, Anonymous> sub(const typed::union_pw_aff<pair<Domain, Domain2>, Anonymous> &upa2) const;
  inline typed::union_pw_multi_aff<pair<Domain, Domain2>, Anonymous> sub(const typed::union_pw_multi_aff<pair<Domain, Domain2>, Anonymous> &upma2) const;
  inline typed::union_pw_aff<pair<Domain, Domain2>, Anonymous> sub(const typed::aff<pair<Domain, Domain2>, Anonymous> &upa2) const;
  inline typed::union_pw_aff<pair<Domain, Domain2>, Anonymous> sub(const typed::pw_aff<pair<Domain, Domain2>, Anonymous> &upa2) const;
  inline typed::union_pw_aff<pair<Domain, Domain2>, Anonymous> subtract_domain(const typed::space<pair<Domain, Domain2>> &space) const;
  inline typed::union_pw_aff<pair<Domain, Domain2>, Anonymous> subtract_domain(const typed::union_set<pair<Domain, Domain2>> &uset) const;
  inline typed::multi_union_pw_aff<pair<Domain, Domain2>, Anonymous> union_add(const typed::multi_union_pw_aff<pair<Domain, Domain2>, Anonymous> &mupa2) const;
  inline typed::union_pw_aff<pair<Domain, Domain2>, Anonymous> union_add(const typed::union_pw_aff<pair<Domain, Domain2>, Anonymous> &upa2) const;
  inline typed::union_pw_multi_aff<pair<Domain, Domain2>, Anonymous> union_add(const typed::union_pw_multi_aff<pair<Domain, Domain2>, Anonymous> &upma2) const;
  inline typed::union_pw_aff<pair<Domain, Domain2>, Anonymous> union_add(const typed::aff<pair<Domain, Domain2>, Anonymous> &upa2) const;
  inline typed::union_pw_aff<pair<Domain, Domain2>, Anonymous> union_add(const typed::pw_aff<pair<Domain, Domain2>, Anonymous> &upa2) const;
};

template <>
struct union_pw_aff_list<Anonymous> : public isl::union_pw_aff_list {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  union_pw_aff_list() = default;
  union_pw_aff_list(const isl::union_pw_aff_list &obj) : isl::union_pw_aff_list(obj) {}
  static union_pw_aff_list from(const isl::union_pw_aff_list &obj) {
    return union_pw_aff_list(obj);
  }
  inline explicit union_pw_aff_list(const isl::ctx &ctx, int n);
  inline explicit union_pw_aff_list(const typed::union_pw_aff<Anonymous> &el);
  inline explicit union_pw_aff_list(const isl::ctx &ctx, const std::string &str);
  inline typed::union_pw_aff_list<Anonymous> add(const typed::union_pw_aff<Anonymous> &el) const;
  inline typed::union_pw_aff_list<Anonymous> add(const typed::aff<Anonymous> &el) const;
  inline typed::union_pw_aff_list<Anonymous> add(const typed::pw_aff<Anonymous> &el) const;
  inline typed::union_pw_aff<Anonymous> at(int index) const;
  inline typed::union_pw_aff<Anonymous> get_at(int index) const = delete;
  inline typed::union_pw_aff_list<Anonymous> drop(unsigned int first, unsigned int n) const;
  inline void foreach(const std::function<void(typed::union_pw_aff<Anonymous>)> &fn) const;
  inline void foreach_scc(const std::function<bool(typed::union_pw_aff<Anonymous>, typed::union_pw_aff<Anonymous>)> &follows, const std::function<void(typed::union_pw_aff_list<Anonymous>)> &fn) const;
  inline typed::union_pw_aff_list<Anonymous> set_at(int index, const typed::union_pw_aff<Anonymous> &el) const;
};

template <typename Domain>
struct union_pw_aff_list<Domain, Anonymous> : public isl::union_pw_aff_list {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  union_pw_aff_list() = default;
  template <typename Arg1,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{},
            bool>::type = true>
  union_pw_aff_list(const union_pw_aff_list<Arg1, Anonymous> &obj) : isl::union_pw_aff_list(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::union_pw_aff_list>{}, bool>::type = true>
  union_pw_aff_list(const base &obj) : isl::union_pw_aff_list(obj) {}
 public:
  static union_pw_aff_list from(const isl::union_pw_aff_list &obj) {
    return union_pw_aff_list(obj);
  }
  inline explicit union_pw_aff_list(const isl::ctx &ctx, int n);
  inline explicit union_pw_aff_list(const typed::union_pw_aff<Domain, Anonymous> &el);
  inline explicit union_pw_aff_list(const isl::ctx &ctx, const std::string &str);
  inline typed::union_pw_aff_list<Domain, Anonymous> add(const typed::union_pw_aff<Domain, Anonymous> &el) const;
  inline typed::union_pw_aff_list<Domain, Anonymous> add(const typed::aff<Domain, Anonymous> &el) const;
  inline typed::union_pw_aff_list<Domain, Anonymous> add(const typed::pw_aff<Domain, Anonymous> &el) const;
  inline typed::union_pw_aff<Domain, Anonymous> at(int index) const;
  inline typed::union_pw_aff<Domain, Anonymous> get_at(int index) const = delete;
  inline typed::union_pw_aff_list<Domain, Anonymous> drop(unsigned int first, unsigned int n) const;
  inline void foreach(const std::function<void(typed::union_pw_aff<Domain, Anonymous>)> &fn) const;
  inline void foreach_scc(const std::function<bool(typed::union_pw_aff<Domain, Anonymous>, typed::union_pw_aff<Domain, Anonymous>)> &follows, const std::function<void(typed::union_pw_aff_list<Domain, Anonymous>)> &fn) const;
  inline typed::union_pw_aff_list<Domain, Anonymous> set_at(int index, const typed::union_pw_aff<Domain, Anonymous> &el) const;
};

template <typename Domain>
struct union_pw_multi_aff<Domain> : public isl::union_pw_multi_aff {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  union_pw_multi_aff() = default;
  template <typename Arg1,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{},
            bool>::type = true>
  union_pw_multi_aff(const union_pw_multi_aff<Arg1> &obj) : isl::union_pw_multi_aff(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::union_pw_multi_aff>{}, bool>::type = true>
  union_pw_multi_aff(const base &obj) : isl::union_pw_multi_aff(obj) {}
 public:
  static union_pw_multi_aff from(const isl::union_pw_multi_aff &obj) {
    return union_pw_multi_aff(obj);
  }
  inline /* implicit */ union_pw_multi_aff(const typed::multi_aff<Domain> &ma);
  inline /* implicit */ union_pw_multi_aff(const typed::pw_multi_aff<Domain> &pma);
  inline /* implicit */ union_pw_multi_aff(const typed::union_pw_aff<Domain> &upa);
  inline explicit union_pw_multi_aff(const isl::ctx &ctx, const std::string &str);
  inline typed::union_pw_multi_aff<Domain> add(const typed::union_pw_multi_aff<Domain> &upma2) const;
  inline typed::union_pw_multi_aff<Domain> add(const typed::multi_aff<Domain> &upma2) const;
  inline typed::union_pw_multi_aff<Domain> add(const typed::pw_multi_aff<Domain> &upma2) const;
  inline typed::union_pw_multi_aff<Domain> add(const typed::union_pw_aff<Domain> &upma2) const;
  template <typename Range>
  inline typed::union_pw_multi_aff<Range> apply(const typed::union_pw_multi_aff<Domain, Range> &upma2) const;
  template <typename Range>
  inline typed::union_pw_multi_aff<Range> apply(const typed::multi_aff<Domain, Range> &upma2) const;
  template <typename Range>
  inline typed::union_pw_multi_aff<Range> apply(const typed::pw_multi_aff<Domain, Range> &upma2) const;
  inline typed::union_pw_multi_aff<Anonymous> apply(const typed::union_pw_aff<Domain, Anonymous> &upma2) const;
  inline typed::multi_union_pw_aff<Domain> as_multi_union_pw_aff() const;
  inline typed::pw_multi_aff<Domain> as_pw_multi_aff() const;
  inline typed::union_map<Domain> as_union_map() const = delete;
  inline typed::union_pw_multi_aff<Domain> coalesce() const;
  inline typed::union_set<> domain() const;
  inline typed::union_pw_multi_aff<Domain> drop_unused_params() const;
  static inline typed::union_pw_multi_aff<Domain> empty(const isl::ctx &ctx);
  inline typed::pw_multi_aff<Domain> extract_pw_multi_aff(const typed::space<Domain> &space) const;
  inline typed::union_pw_multi_aff<Domain> gist(const typed::union_set<> &context) const;
  inline typed::union_pw_multi_aff<Domain> gist(const typed::basic_set<> &context) const;
  inline typed::union_pw_multi_aff<Domain> gist(const typed::point<> &context) const;
  inline typed::union_pw_multi_aff<Domain> gist(const typed::set<> &context) const;
  inline typed::union_pw_multi_aff<Domain> intersect_domain(const typed::space<> &space) const = delete;
  inline typed::union_pw_multi_aff<Domain> intersect_domain(const typed::union_set<> &uset) const = delete;
  inline typed::union_pw_multi_aff<Domain> intersect_domain_wrapped_domain(const typed::union_set<> &uset) const = delete;
  inline typed::union_pw_multi_aff<Domain> intersect_domain_wrapped_domain(const typed::basic_set<> &uset) const = delete;
  inline typed::union_pw_multi_aff<Domain> intersect_domain_wrapped_domain(const typed::point<> &uset) const = delete;
  inline typed::union_pw_multi_aff<Domain> intersect_domain_wrapped_domain(const typed::set<> &uset) const = delete;
  inline typed::union_pw_multi_aff<Domain> intersect_params(const typed::set<> &set) const;
  inline typed::union_pw_multi_aff<Domain> intersect_params(const typed::basic_set<> &set) const;
  inline typed::union_pw_multi_aff<Domain> intersect_params(const typed::point<> &set) const;
  inline typed::union_pw_multi_aff<Domain> preimage_domain_wrapped_domain(const typed::union_pw_multi_aff<> &upma2) const = delete;
  inline typed::union_pw_multi_aff<Domain> preimage_domain_wrapped_domain(const typed::multi_aff<> &upma2) const = delete;
  inline typed::union_pw_multi_aff<Domain> preimage_domain_wrapped_domain(const typed::pw_multi_aff<> &upma2) const = delete;
  inline typed::union_pw_multi_aff<Domain> preimage_domain_wrapped_domain(const typed::union_pw_aff<> &upma2) const = delete;
  inline typed::union_pw_multi_aff<Domain> pullback(const typed::union_pw_multi_aff<> &upma2) const = delete;
  inline typed::union_pw_multi_aff<Domain> pullback(const typed::multi_aff<> &upma2) const = delete;
  inline typed::union_pw_multi_aff<Domain> pullback(const typed::pw_multi_aff<> &upma2) const = delete;
  inline typed::union_pw_multi_aff<Domain> pullback(const typed::union_pw_aff<> &upma2) const = delete;
  inline typed::pw_multi_aff_list<Domain> pw_multi_aff_list() const;
  inline typed::pw_multi_aff_list<Domain> get_pw_multi_aff_list() const = delete;
  inline typed::union_pw_multi_aff<Domain> range_factor_domain() const = delete;
  inline typed::union_pw_multi_aff<Domain> range_factor_range() const = delete;
  inline typed::union_pw_multi_aff<Domain> range_product(const typed::union_pw_multi_aff<> &upma2) const = delete;
  inline typed::union_pw_multi_aff<Domain> range_product(const typed::multi_aff<> &upma2) const = delete;
  inline typed::union_pw_multi_aff<Domain> range_product(const typed::pw_multi_aff<> &upma2) const = delete;
  inline typed::union_pw_multi_aff<Domain> range_product(const typed::union_pw_aff<> &upma2) const = delete;
  inline typed::space<> space() const;
  inline typed::space<Domain> get_space() const = delete;
  inline typed::union_pw_multi_aff<Domain> sub(const typed::union_pw_multi_aff<Domain> &upma2) const;
  inline typed::union_pw_multi_aff<Domain> sub(const typed::multi_aff<Domain> &upma2) const;
  inline typed::union_pw_multi_aff<Domain> sub(const typed::pw_multi_aff<Domain> &upma2) const;
  inline typed::union_pw_multi_aff<Domain> sub(const typed::union_pw_aff<Domain> &upma2) const;
  inline typed::union_pw_multi_aff<Domain> subtract_domain(const typed::space<> &space) const = delete;
  inline typed::union_pw_multi_aff<Domain> subtract_domain(const typed::union_set<> &uset) const = delete;
  inline typed::union_pw_multi_aff<Domain> union_add(const typed::union_pw_multi_aff<Domain> &upma2) const;
  inline typed::union_pw_multi_aff<Domain> union_add(const typed::multi_aff<Domain> &upma2) const;
  inline typed::union_pw_multi_aff<Domain> union_add(const typed::pw_multi_aff<Domain> &upma2) const;
  inline typed::union_pw_multi_aff<Domain> union_add(const typed::union_pw_aff<Domain> &upma2) const;
};

template <typename Domain, typename Range>
struct union_pw_multi_aff<Domain, Range> : public isl::union_pw_multi_aff {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  union_pw_multi_aff() = default;
  template <typename Arg1, typename Arg2,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{} &&
              std::is_base_of<Range, Arg2>{},
            bool>::type = true>
  union_pw_multi_aff(const union_pw_multi_aff<Arg1, Arg2> &obj) : isl::union_pw_multi_aff(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::union_pw_multi_aff>{}, bool>::type = true>
  union_pw_multi_aff(const base &obj) : isl::union_pw_multi_aff(obj) {}
 public:
  static union_pw_multi_aff from(const isl::union_pw_multi_aff &obj) {
    return union_pw_multi_aff(obj);
  }
  inline /* implicit */ union_pw_multi_aff(const typed::multi_aff<Domain, Range> &ma);
  inline /* implicit */ union_pw_multi_aff(const typed::pw_multi_aff<Domain, Range> &pma);
  inline /* implicit */ union_pw_multi_aff(const typed::union_pw_aff<Domain, Range> &upa);
  inline explicit union_pw_multi_aff(const isl::ctx &ctx, const std::string &str);
  inline typed::union_pw_multi_aff<Domain, Range> add(const typed::union_pw_multi_aff<Domain, Range> &upma2) const;
  inline typed::union_pw_multi_aff<Domain, Range> add(const typed::multi_aff<Domain, Range> &upma2) const;
  inline typed::union_pw_multi_aff<Domain, Range> add(const typed::pw_multi_aff<Domain, Range> &upma2) const;
  inline typed::union_pw_multi_aff<Domain, Range> add(const typed::union_pw_aff<Domain, Range> &upma2) const;
  template <typename Range2>
  inline typed::union_pw_multi_aff<Domain, Range2> apply(const typed::union_pw_multi_aff<Range, Range2> &upma2) const;
  template <typename Range2>
  inline typed::union_pw_multi_aff<Domain, Range2> apply(const typed::multi_aff<Range, Range2> &upma2) const;
  template <typename Range2>
  inline typed::union_pw_multi_aff<Domain, Range2> apply(const typed::pw_multi_aff<Range, Range2> &upma2) const;
  inline typed::union_pw_multi_aff<Domain, Anonymous> apply(const typed::union_pw_aff<Range, Anonymous> &upma2) const;
  inline typed::multi_union_pw_aff<Domain, Range> as_multi_union_pw_aff() const;
  inline typed::pw_multi_aff<Domain, Range> as_pw_multi_aff() const;
  inline typed::union_map<Domain, Range> as_union_map() const;
  inline typed::union_pw_multi_aff<Domain, Range> coalesce() const;
  inline typed::union_set<Domain> domain() const;
  inline typed::union_pw_multi_aff<Domain, Range> drop_unused_params() const;
  static inline typed::union_pw_multi_aff<Domain, Range> empty(const isl::ctx &ctx);
  inline typed::pw_multi_aff<Domain, Range> extract_pw_multi_aff(const typed::space<Domain, Range> &space) const;
  inline typed::union_pw_multi_aff<Domain, Range> gist(const typed::union_set<Domain> &context) const;
  inline typed::union_pw_multi_aff<Domain, Range> gist(const typed::basic_set<Domain> &context) const;
  inline typed::union_pw_multi_aff<Domain, Range> gist(const typed::point<Domain> &context) const;
  inline typed::union_pw_multi_aff<Domain, Range> gist(const typed::set<Domain> &context) const;
  inline typed::union_pw_multi_aff<Domain, Range> intersect_domain(const typed::space<Domain> &space) const;
  inline typed::union_pw_multi_aff<Domain, Range> intersect_domain(const typed::union_set<Domain> &uset) const;
  inline typed::union_pw_multi_aff<Domain, Range> intersect_domain_wrapped_domain(const typed::union_set<> &uset) const = delete;
  inline typed::union_pw_multi_aff<Domain, Range> intersect_domain_wrapped_domain(const typed::basic_set<> &uset) const = delete;
  inline typed::union_pw_multi_aff<Domain, Range> intersect_domain_wrapped_domain(const typed::point<> &uset) const = delete;
  inline typed::union_pw_multi_aff<Domain, Range> intersect_domain_wrapped_domain(const typed::set<> &uset) const = delete;
  inline typed::union_pw_multi_aff<Domain, Range> intersect_params(const typed::set<> &set) const;
  inline typed::union_pw_multi_aff<Domain, Range> intersect_params(const typed::basic_set<> &set) const;
  inline typed::union_pw_multi_aff<Domain, Range> intersect_params(const typed::point<> &set) const;
  inline typed::union_pw_multi_aff<Domain, Range> preimage_domain_wrapped_domain(const typed::union_pw_multi_aff<> &upma2) const = delete;
  inline typed::union_pw_multi_aff<Domain, Range> preimage_domain_wrapped_domain(const typed::multi_aff<> &upma2) const = delete;
  inline typed::union_pw_multi_aff<Domain, Range> preimage_domain_wrapped_domain(const typed::pw_multi_aff<> &upma2) const = delete;
  inline typed::union_pw_multi_aff<Domain, Range> preimage_domain_wrapped_domain(const typed::union_pw_aff<> &upma2) const = delete;
  template <typename Domain2>
  inline typed::union_pw_multi_aff<Domain2, Range> pullback(const typed::union_pw_multi_aff<Domain2, Domain> &upma2) const;
  inline typed::union_pw_multi_aff<Range> pullback(const typed::union_pw_multi_aff<Domain> &upma2) const;
  template <typename Domain2>
  inline typed::union_pw_multi_aff<Domain2, Range> pullback(const typed::multi_aff<Domain2, Domain> &upma2) const;
  inline typed::union_pw_multi_aff<Range> pullback(const typed::multi_aff<Domain> &upma2) const;
  template <typename Domain2>
  inline typed::union_pw_multi_aff<Domain2, Range> pullback(const typed::pw_multi_aff<Domain2, Domain> &upma2) const;
  inline typed::union_pw_multi_aff<Range> pullback(const typed::pw_multi_aff<Domain> &upma2) const;
  template <typename Domain2>
  inline typed::union_pw_multi_aff<Domain2, Range> pullback(const typed::union_pw_aff<Domain2, Domain> &upma2) const;
  inline typed::union_pw_multi_aff<Range> pullback(const typed::union_pw_aff<Domain> &upma2) const;
  inline typed::pw_multi_aff_list<Domain, Range> pw_multi_aff_list() const;
  inline typed::pw_multi_aff_list<Domain, Range> get_pw_multi_aff_list() const = delete;
  inline typed::union_pw_multi_aff<Domain, Range> range_factor_domain() const = delete;
  inline typed::union_pw_multi_aff<Domain, Range> range_factor_range() const = delete;
  template <typename Range2>
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> range_product(const typed::union_pw_multi_aff<Domain, Range2> &upma2) const;
  template <typename Range2>
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> range_product(const typed::multi_aff<Domain, Range2> &upma2) const;
  template <typename Range2>
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> range_product(const typed::pw_multi_aff<Domain, Range2> &upma2) const;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Anonymous>> range_product(const typed::union_pw_aff<Domain, Anonymous> &upma2) const;
  inline typed::space<> space() const;
  inline typed::space<Domain, Range> get_space() const = delete;
  inline typed::union_pw_multi_aff<Domain, Range> sub(const typed::union_pw_multi_aff<Domain, Range> &upma2) const;
  inline typed::union_pw_multi_aff<Domain, Range> sub(const typed::multi_aff<Domain, Range> &upma2) const;
  inline typed::union_pw_multi_aff<Domain, Range> sub(const typed::pw_multi_aff<Domain, Range> &upma2) const;
  inline typed::union_pw_multi_aff<Domain, Range> sub(const typed::union_pw_aff<Domain, Range> &upma2) const;
  inline typed::union_pw_multi_aff<Domain, Range> subtract_domain(const typed::space<Domain> &space) const;
  inline typed::union_pw_multi_aff<Domain, Range> subtract_domain(const typed::union_set<Domain> &uset) const;
  inline typed::union_pw_multi_aff<Domain, Range> union_add(const typed::union_pw_multi_aff<Domain, Range> &upma2) const;
  inline typed::union_pw_multi_aff<Domain, Range> union_add(const typed::multi_aff<Domain, Range> &upma2) const;
  inline typed::union_pw_multi_aff<Domain, Range> union_add(const typed::pw_multi_aff<Domain, Range> &upma2) const;
  inline typed::union_pw_multi_aff<Domain, Range> union_add(const typed::union_pw_aff<Domain, Range> &upma2) const;
};

template <typename Domain, typename Domain2, typename Range>
struct union_pw_multi_aff<pair<Domain, Domain2>, Range> : public isl::union_pw_multi_aff {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  union_pw_multi_aff() = default;
  template <typename Arg1, typename Arg2, typename Arg3,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{} &&
              std::is_base_of<Domain2, Arg2>{} &&
              std::is_base_of<Range, Arg3>{},
            bool>::type = true>
  union_pw_multi_aff(const union_pw_multi_aff<pair<Arg1, Arg2>, Arg3> &obj) : isl::union_pw_multi_aff(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::union_pw_multi_aff>{}, bool>::type = true>
  union_pw_multi_aff(const base &obj) : isl::union_pw_multi_aff(obj) {}
 public:
  static union_pw_multi_aff from(const isl::union_pw_multi_aff &obj) {
    return union_pw_multi_aff(obj);
  }
  inline /* implicit */ union_pw_multi_aff(const typed::multi_aff<pair<Domain, Domain2>, Range> &ma);
  inline /* implicit */ union_pw_multi_aff(const typed::pw_multi_aff<pair<Domain, Domain2>, Range> &pma);
  inline /* implicit */ union_pw_multi_aff(const typed::union_pw_aff<pair<Domain, Domain2>, Range> &upa);
  inline explicit union_pw_multi_aff(const isl::ctx &ctx, const std::string &str);
  inline typed::union_pw_multi_aff<pair<Domain, Domain2>, Range> add(const typed::union_pw_multi_aff<pair<Domain, Domain2>, Range> &upma2) const;
  inline typed::union_pw_multi_aff<pair<Domain, Domain2>, Range> add(const typed::multi_aff<pair<Domain, Domain2>, Range> &upma2) const;
  inline typed::union_pw_multi_aff<pair<Domain, Domain2>, Range> add(const typed::pw_multi_aff<pair<Domain, Domain2>, Range> &upma2) const;
  inline typed::union_pw_multi_aff<pair<Domain, Domain2>, Range> add(const typed::union_pw_aff<pair<Domain, Domain2>, Range> &upma2) const;
  template <typename Range2>
  inline typed::union_pw_multi_aff<pair<Domain, Domain2>, Range2> apply(const typed::union_pw_multi_aff<Range, Range2> &upma2) const;
  template <typename Range2>
  inline typed::union_pw_multi_aff<pair<Domain, Domain2>, Range2> apply(const typed::multi_aff<Range, Range2> &upma2) const;
  template <typename Range2>
  inline typed::union_pw_multi_aff<pair<Domain, Domain2>, Range2> apply(const typed::pw_multi_aff<Range, Range2> &upma2) const;
  inline typed::union_pw_multi_aff<pair<Domain, Domain2>, Anonymous> apply(const typed::union_pw_aff<Range, Anonymous> &upma2) const;
  inline typed::multi_union_pw_aff<pair<Domain, Domain2>, Range> as_multi_union_pw_aff() const;
  inline typed::pw_multi_aff<pair<Domain, Domain2>, Range> as_pw_multi_aff() const;
  inline typed::union_map<pair<Domain, Domain2>, Range> as_union_map() const;
  inline typed::union_pw_multi_aff<pair<Domain, Domain2>, Range> coalesce() const;
  inline typed::union_set<pair<Domain, Domain2>> domain() const;
  inline typed::union_pw_multi_aff<pair<Domain, Domain2>, Range> drop_unused_params() const;
  static inline typed::union_pw_multi_aff<pair<Domain, Domain2>, Range> empty(const isl::ctx &ctx);
  inline typed::pw_multi_aff<pair<Domain, Domain2>, Range> extract_pw_multi_aff(const typed::space<pair<Domain, Domain2>, Range> &space) const;
  inline typed::union_pw_multi_aff<pair<Domain, Domain2>, Range> gist(const typed::union_set<pair<Domain, Domain2>> &context) const;
  inline typed::union_pw_multi_aff<pair<Domain, Domain2>, Range> gist(const typed::basic_set<pair<Domain, Domain2>> &context) const;
  inline typed::union_pw_multi_aff<pair<Domain, Domain2>, Range> gist(const typed::point<pair<Domain, Domain2>> &context) const;
  inline typed::union_pw_multi_aff<pair<Domain, Domain2>, Range> gist(const typed::set<pair<Domain, Domain2>> &context) const;
  inline typed::union_pw_multi_aff<pair<Domain, Domain2>, Range> intersect_domain(const typed::space<pair<Domain, Domain2>> &space) const;
  inline typed::union_pw_multi_aff<pair<Domain, Domain2>, Range> intersect_domain(const typed::union_set<pair<Domain, Domain2>> &uset) const;
  inline typed::union_pw_multi_aff<pair<Domain, Domain2>, Range> intersect_domain_wrapped_domain(const typed::union_set<Domain> &uset) const;
  inline typed::union_pw_multi_aff<pair<Domain, Domain2>, Range> intersect_domain_wrapped_domain(const typed::basic_set<Domain> &uset) const;
  inline typed::union_pw_multi_aff<pair<Domain, Domain2>, Range> intersect_domain_wrapped_domain(const typed::point<Domain> &uset) const;
  inline typed::union_pw_multi_aff<pair<Domain, Domain2>, Range> intersect_domain_wrapped_domain(const typed::set<Domain> &uset) const;
  inline typed::union_pw_multi_aff<pair<Domain, Domain2>, Range> intersect_params(const typed::set<> &set) const;
  inline typed::union_pw_multi_aff<pair<Domain, Domain2>, Range> intersect_params(const typed::basic_set<> &set) const;
  inline typed::union_pw_multi_aff<pair<Domain, Domain2>, Range> intersect_params(const typed::point<> &set) const;
  template <typename Domain3>
  inline typed::union_pw_multi_aff<pair<Domain3, Domain2>, Range> preimage_domain_wrapped_domain(const typed::union_pw_multi_aff<Domain3, Domain> &upma2) const;
  template <typename Domain3>
  inline typed::union_pw_multi_aff<pair<Domain3, Domain2>, Range> preimage_domain_wrapped_domain(const typed::multi_aff<Domain3, Domain> &upma2) const;
  template <typename Domain3>
  inline typed::union_pw_multi_aff<pair<Domain3, Domain2>, Range> preimage_domain_wrapped_domain(const typed::pw_multi_aff<Domain3, Domain> &upma2) const;
  template <typename Domain3>
  inline typed::union_pw_multi_aff<pair<Domain3, Domain2>, Range> preimage_domain_wrapped_domain(const typed::union_pw_aff<Domain3, Domain> &upma2) const;
  template <typename Arg3>
  inline typed::union_pw_multi_aff<Arg3, Range> pullback(const typed::union_pw_multi_aff<Arg3, pair<Domain, Domain2>> &upma2) const;
  inline typed::union_pw_multi_aff<Range> pullback(const typed::union_pw_multi_aff<pair<Domain, Domain2>> &upma2) const;
  template <typename Arg3>
  inline typed::union_pw_multi_aff<Arg3, Range> pullback(const typed::multi_aff<Arg3, pair<Domain, Domain2>> &upma2) const;
  inline typed::union_pw_multi_aff<Range> pullback(const typed::multi_aff<pair<Domain, Domain2>> &upma2) const;
  template <typename Arg3>
  inline typed::union_pw_multi_aff<Arg3, Range> pullback(const typed::pw_multi_aff<Arg3, pair<Domain, Domain2>> &upma2) const;
  inline typed::union_pw_multi_aff<Range> pullback(const typed::pw_multi_aff<pair<Domain, Domain2>> &upma2) const;
  template <typename Arg3>
  inline typed::union_pw_multi_aff<Arg3, Range> pullback(const typed::union_pw_aff<Arg3, pair<Domain, Domain2>> &upma2) const;
  inline typed::union_pw_multi_aff<Range> pullback(const typed::union_pw_aff<pair<Domain, Domain2>> &upma2) const;
  inline typed::pw_multi_aff_list<pair<Domain, Domain2>, Range> pw_multi_aff_list() const;
  inline typed::pw_multi_aff_list<pair<Domain, Domain2>, Range> get_pw_multi_aff_list() const = delete;
  inline typed::union_pw_multi_aff<pair<Domain, Domain2>, Range> range_factor_domain() const = delete;
  inline typed::union_pw_multi_aff<pair<Domain, Domain2>, Range> range_factor_range() const = delete;
  template <typename Range2>
  inline typed::union_pw_multi_aff<pair<Domain, Domain2>, pair<Range, Range2>> range_product(const typed::union_pw_multi_aff<pair<Domain, Domain2>, Range2> &upma2) const;
  template <typename Range2>
  inline typed::union_pw_multi_aff<pair<Domain, Domain2>, pair<Range, Range2>> range_product(const typed::multi_aff<pair<Domain, Domain2>, Range2> &upma2) const;
  template <typename Range2>
  inline typed::union_pw_multi_aff<pair<Domain, Domain2>, pair<Range, Range2>> range_product(const typed::pw_multi_aff<pair<Domain, Domain2>, Range2> &upma2) const;
  inline typed::union_pw_multi_aff<pair<Domain, Domain2>, pair<Range, Anonymous>> range_product(const typed::union_pw_aff<pair<Domain, Domain2>, Anonymous> &upma2) const;
  inline typed::space<> space() const;
  inline typed::space<pair<Domain, Domain2>, Range> get_space() const = delete;
  inline typed::union_pw_multi_aff<pair<Domain, Domain2>, Range> sub(const typed::union_pw_multi_aff<pair<Domain, Domain2>, Range> &upma2) const;
  inline typed::union_pw_multi_aff<pair<Domain, Domain2>, Range> sub(const typed::multi_aff<pair<Domain, Domain2>, Range> &upma2) const;
  inline typed::union_pw_multi_aff<pair<Domain, Domain2>, Range> sub(const typed::pw_multi_aff<pair<Domain, Domain2>, Range> &upma2) const;
  inline typed::union_pw_multi_aff<pair<Domain, Domain2>, Range> sub(const typed::union_pw_aff<pair<Domain, Domain2>, Range> &upma2) const;
  inline typed::union_pw_multi_aff<pair<Domain, Domain2>, Range> subtract_domain(const typed::space<pair<Domain, Domain2>> &space) const;
  inline typed::union_pw_multi_aff<pair<Domain, Domain2>, Range> subtract_domain(const typed::union_set<pair<Domain, Domain2>> &uset) const;
  inline typed::union_pw_multi_aff<pair<Domain, Domain2>, Range> union_add(const typed::union_pw_multi_aff<pair<Domain, Domain2>, Range> &upma2) const;
  inline typed::union_pw_multi_aff<pair<Domain, Domain2>, Range> union_add(const typed::multi_aff<pair<Domain, Domain2>, Range> &upma2) const;
  inline typed::union_pw_multi_aff<pair<Domain, Domain2>, Range> union_add(const typed::pw_multi_aff<pair<Domain, Domain2>, Range> &upma2) const;
  inline typed::union_pw_multi_aff<pair<Domain, Domain2>, Range> union_add(const typed::union_pw_aff<pair<Domain, Domain2>, Range> &upma2) const;
};

template <typename Domain, typename Range, typename Range2>
struct union_pw_multi_aff<Domain, pair<Range, Range2>> : public isl::union_pw_multi_aff {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  union_pw_multi_aff() = default;
  template <typename Arg1, typename Arg2, typename Arg3,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{} &&
              std::is_base_of<Range, Arg2>{} &&
              std::is_base_of<Range2, Arg3>{},
            bool>::type = true>
  union_pw_multi_aff(const union_pw_multi_aff<Arg1, pair<Arg2, Arg3>> &obj) : isl::union_pw_multi_aff(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::union_pw_multi_aff>{}, bool>::type = true>
  union_pw_multi_aff(const base &obj) : isl::union_pw_multi_aff(obj) {}
 public:
  static union_pw_multi_aff from(const isl::union_pw_multi_aff &obj) {
    return union_pw_multi_aff(obj);
  }
  inline /* implicit */ union_pw_multi_aff(const typed::multi_aff<Domain, pair<Range, Range2>> &ma);
  inline /* implicit */ union_pw_multi_aff(const typed::pw_multi_aff<Domain, pair<Range, Range2>> &pma);
  inline /* implicit */ union_pw_multi_aff(const typed::union_pw_aff<Domain, pair<Range, Range2>> &upa);
  inline explicit union_pw_multi_aff(const isl::ctx &ctx, const std::string &str);
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> add(const typed::union_pw_multi_aff<Domain, pair<Range, Range2>> &upma2) const;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> add(const typed::multi_aff<Domain, pair<Range, Range2>> &upma2) const;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> add(const typed::pw_multi_aff<Domain, pair<Range, Range2>> &upma2) const;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> add(const typed::union_pw_aff<Domain, pair<Range, Range2>> &upma2) const;
  template <typename Arg3>
  inline typed::union_pw_multi_aff<Domain, Arg3> apply(const typed::union_pw_multi_aff<pair<Range, Range2>, Arg3> &upma2) const;
  template <typename Arg3>
  inline typed::union_pw_multi_aff<Domain, Arg3> apply(const typed::multi_aff<pair<Range, Range2>, Arg3> &upma2) const;
  template <typename Arg3>
  inline typed::union_pw_multi_aff<Domain, Arg3> apply(const typed::pw_multi_aff<pair<Range, Range2>, Arg3> &upma2) const;
  inline typed::union_pw_multi_aff<Domain, Anonymous> apply(const typed::union_pw_aff<pair<Range, Range2>, Anonymous> &upma2) const;
  inline typed::multi_union_pw_aff<Domain, pair<Range, Range2>> as_multi_union_pw_aff() const;
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> as_pw_multi_aff() const;
  inline typed::union_map<Domain, pair<Range, Range2>> as_union_map() const;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> coalesce() const;
  inline typed::union_set<Domain> domain() const;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> drop_unused_params() const;
  static inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> empty(const isl::ctx &ctx);
  inline typed::pw_multi_aff<Domain, pair<Range, Range2>> extract_pw_multi_aff(const typed::space<Domain, pair<Range, Range2>> &space) const;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> gist(const typed::union_set<Domain> &context) const;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> gist(const typed::basic_set<Domain> &context) const;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> gist(const typed::point<Domain> &context) const;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> gist(const typed::set<Domain> &context) const;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> intersect_domain(const typed::space<Domain> &space) const;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> intersect_domain(const typed::union_set<Domain> &uset) const;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> intersect_domain_wrapped_domain(const typed::union_set<> &uset) const = delete;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> intersect_domain_wrapped_domain(const typed::basic_set<> &uset) const = delete;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> intersect_domain_wrapped_domain(const typed::point<> &uset) const = delete;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> intersect_domain_wrapped_domain(const typed::set<> &uset) const = delete;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> intersect_params(const typed::set<> &set) const;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> intersect_params(const typed::basic_set<> &set) const;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> intersect_params(const typed::point<> &set) const;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> preimage_domain_wrapped_domain(const typed::union_pw_multi_aff<> &upma2) const = delete;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> preimage_domain_wrapped_domain(const typed::multi_aff<> &upma2) const = delete;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> preimage_domain_wrapped_domain(const typed::pw_multi_aff<> &upma2) const = delete;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> preimage_domain_wrapped_domain(const typed::union_pw_aff<> &upma2) const = delete;
  template <typename Domain2>
  inline typed::union_pw_multi_aff<Domain2, pair<Range, Range2>> pullback(const typed::union_pw_multi_aff<Domain2, Domain> &upma2) const;
  inline typed::union_pw_multi_aff<pair<Range, Range2>> pullback(const typed::union_pw_multi_aff<Domain> &upma2) const;
  template <typename Domain2>
  inline typed::union_pw_multi_aff<Domain2, pair<Range, Range2>> pullback(const typed::multi_aff<Domain2, Domain> &upma2) const;
  inline typed::union_pw_multi_aff<pair<Range, Range2>> pullback(const typed::multi_aff<Domain> &upma2) const;
  template <typename Domain2>
  inline typed::union_pw_multi_aff<Domain2, pair<Range, Range2>> pullback(const typed::pw_multi_aff<Domain2, Domain> &upma2) const;
  inline typed::union_pw_multi_aff<pair<Range, Range2>> pullback(const typed::pw_multi_aff<Domain> &upma2) const;
  template <typename Domain2>
  inline typed::union_pw_multi_aff<Domain2, pair<Range, Range2>> pullback(const typed::union_pw_aff<Domain2, Domain> &upma2) const;
  inline typed::union_pw_multi_aff<pair<Range, Range2>> pullback(const typed::union_pw_aff<Domain> &upma2) const;
  inline typed::pw_multi_aff_list<Domain, pair<Range, Range2>> pw_multi_aff_list() const;
  inline typed::pw_multi_aff_list<Domain, pair<Range, Range2>> get_pw_multi_aff_list() const = delete;
  inline typed::union_pw_multi_aff<Domain, Range> range_factor_domain() const;
  inline typed::union_pw_multi_aff<Domain, Range2> range_factor_range() const;
  template <typename Arg3>
  inline typed::union_pw_multi_aff<Domain, pair<pair<Range, Range2>, Arg3>> range_product(const typed::union_pw_multi_aff<Domain, Arg3> &upma2) const;
  template <typename Arg3>
  inline typed::union_pw_multi_aff<Domain, pair<pair<Range, Range2>, Arg3>> range_product(const typed::multi_aff<Domain, Arg3> &upma2) const;
  template <typename Arg3>
  inline typed::union_pw_multi_aff<Domain, pair<pair<Range, Range2>, Arg3>> range_product(const typed::pw_multi_aff<Domain, Arg3> &upma2) const;
  inline typed::union_pw_multi_aff<Domain, pair<pair<Range, Range2>, Anonymous>> range_product(const typed::union_pw_aff<Domain, Anonymous> &upma2) const;
  inline typed::space<> space() const;
  inline typed::space<Domain, pair<Range, Range2>> get_space() const = delete;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> sub(const typed::union_pw_multi_aff<Domain, pair<Range, Range2>> &upma2) const;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> sub(const typed::multi_aff<Domain, pair<Range, Range2>> &upma2) const;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> sub(const typed::pw_multi_aff<Domain, pair<Range, Range2>> &upma2) const;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> sub(const typed::union_pw_aff<Domain, pair<Range, Range2>> &upma2) const;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> subtract_domain(const typed::space<Domain> &space) const;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> subtract_domain(const typed::union_set<Domain> &uset) const;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> union_add(const typed::union_pw_multi_aff<Domain, pair<Range, Range2>> &upma2) const;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> union_add(const typed::multi_aff<Domain, pair<Range, Range2>> &upma2) const;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> union_add(const typed::pw_multi_aff<Domain, pair<Range, Range2>> &upma2) const;
  inline typed::union_pw_multi_aff<Domain, pair<Range, Range2>> union_add(const typed::union_pw_aff<Domain, pair<Range, Range2>> &upma2) const;
};

template <typename T1, typename T2, typename Range, typename Range2>
struct union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> : public isl::union_pw_multi_aff {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  union_pw_multi_aff() = default;
  template <typename Arg1, typename Arg2, typename Arg3, typename Arg4,
            typename std::enable_if<
              std::is_base_of<T1, Arg1>{} &&
              std::is_base_of<T2, Arg2>{} &&
              std::is_base_of<Range, Arg3>{} &&
              std::is_base_of<Range2, Arg4>{},
            bool>::type = true>
  union_pw_multi_aff(const union_pw_multi_aff<pair<Arg1, Arg2>, pair<Arg3, Arg4>> &obj) : isl::union_pw_multi_aff(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::union_pw_multi_aff>{}, bool>::type = true>
  union_pw_multi_aff(const base &obj) : isl::union_pw_multi_aff(obj) {}
 public:
  static union_pw_multi_aff from(const isl::union_pw_multi_aff &obj) {
    return union_pw_multi_aff(obj);
  }
  inline /* implicit */ union_pw_multi_aff(const typed::multi_aff<pair<T1, T2>, pair<Range, Range2>> &ma);
  inline /* implicit */ union_pw_multi_aff(const typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> &pma);
  inline /* implicit */ union_pw_multi_aff(const typed::union_pw_aff<pair<T1, T2>, pair<Range, Range2>> &upa);
  inline explicit union_pw_multi_aff(const isl::ctx &ctx, const std::string &str);
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> add(const typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> &upma2) const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> add(const typed::multi_aff<pair<T1, T2>, pair<Range, Range2>> &upma2) const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> add(const typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> &upma2) const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> add(const typed::union_pw_aff<pair<T1, T2>, pair<Range, Range2>> &upma2) const;
  template <typename Arg2>
  inline typed::union_pw_multi_aff<pair<T1, T2>, Arg2> apply(const typed::union_pw_multi_aff<pair<Range, Range2>, Arg2> &upma2) const;
  template <typename Arg2>
  inline typed::union_pw_multi_aff<pair<T1, T2>, Arg2> apply(const typed::multi_aff<pair<Range, Range2>, Arg2> &upma2) const;
  template <typename Arg2>
  inline typed::union_pw_multi_aff<pair<T1, T2>, Arg2> apply(const typed::pw_multi_aff<pair<Range, Range2>, Arg2> &upma2) const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, Anonymous> apply(const typed::union_pw_aff<pair<Range, Range2>, Anonymous> &upma2) const;
  inline typed::multi_union_pw_aff<pair<T1, T2>, pair<Range, Range2>> as_multi_union_pw_aff() const;
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> as_pw_multi_aff() const;
  inline typed::union_map<pair<T1, T2>, pair<Range, Range2>> as_union_map() const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> coalesce() const;
  inline typed::union_set<pair<T1, T2>> domain() const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> drop_unused_params() const;
  static inline typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> empty(const isl::ctx &ctx);
  inline typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> extract_pw_multi_aff(const typed::space<pair<T1, T2>, pair<Range, Range2>> &space) const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> gist(const typed::union_set<pair<T1, T2>> &context) const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> gist(const typed::basic_set<pair<T1, T2>> &context) const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> gist(const typed::point<pair<T1, T2>> &context) const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> gist(const typed::set<pair<T1, T2>> &context) const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> intersect_domain(const typed::space<pair<T1, T2>> &space) const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> intersect_domain(const typed::union_set<pair<T1, T2>> &uset) const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> intersect_domain_wrapped_domain(const typed::union_set<T1> &uset) const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> intersect_domain_wrapped_domain(const typed::basic_set<T1> &uset) const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> intersect_domain_wrapped_domain(const typed::point<T1> &uset) const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> intersect_domain_wrapped_domain(const typed::set<T1> &uset) const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> intersect_params(const typed::set<> &set) const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> intersect_params(const typed::basic_set<> &set) const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> intersect_params(const typed::point<> &set) const;
  template <typename Domain3>
  inline typed::union_pw_multi_aff<pair<Domain3, T2>, pair<Range, Range2>> preimage_domain_wrapped_domain(const typed::union_pw_multi_aff<Domain3, T1> &upma2) const;
  template <typename Domain3>
  inline typed::union_pw_multi_aff<pair<Domain3, T2>, pair<Range, Range2>> preimage_domain_wrapped_domain(const typed::multi_aff<Domain3, T1> &upma2) const;
  template <typename Domain3>
  inline typed::union_pw_multi_aff<pair<Domain3, T2>, pair<Range, Range2>> preimage_domain_wrapped_domain(const typed::pw_multi_aff<Domain3, T1> &upma2) const;
  template <typename Domain3>
  inline typed::union_pw_multi_aff<pair<Domain3, T2>, pair<Range, Range2>> preimage_domain_wrapped_domain(const typed::union_pw_aff<Domain3, T1> &upma2) const;
  template <typename Domain2>
  inline typed::union_pw_multi_aff<Domain2, pair<Range, Range2>> pullback(const typed::union_pw_multi_aff<Domain2, pair<T1, T2>> &upma2) const;
  inline typed::union_pw_multi_aff<pair<Range, Range2>> pullback(const typed::union_pw_multi_aff<pair<T1, T2>> &upma2) const;
  template <typename Domain2>
  inline typed::union_pw_multi_aff<Domain2, pair<Range, Range2>> pullback(const typed::multi_aff<Domain2, pair<T1, T2>> &upma2) const;
  inline typed::union_pw_multi_aff<pair<Range, Range2>> pullback(const typed::multi_aff<pair<T1, T2>> &upma2) const;
  template <typename Domain2>
  inline typed::union_pw_multi_aff<Domain2, pair<Range, Range2>> pullback(const typed::pw_multi_aff<Domain2, pair<T1, T2>> &upma2) const;
  inline typed::union_pw_multi_aff<pair<Range, Range2>> pullback(const typed::pw_multi_aff<pair<T1, T2>> &upma2) const;
  template <typename Domain2>
  inline typed::union_pw_multi_aff<Domain2, pair<Range, Range2>> pullback(const typed::union_pw_aff<Domain2, pair<T1, T2>> &upma2) const;
  inline typed::union_pw_multi_aff<pair<Range, Range2>> pullback(const typed::union_pw_aff<pair<T1, T2>> &upma2) const;
  inline typed::pw_multi_aff_list<pair<T1, T2>, pair<Range, Range2>> pw_multi_aff_list() const;
  inline typed::pw_multi_aff_list<pair<T1, T2>, pair<Range, Range2>> get_pw_multi_aff_list() const = delete;
  inline typed::union_pw_multi_aff<pair<T1, T2>, Range> range_factor_domain() const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, Range2> range_factor_range() const;
  template <typename Arg2>
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<pair<Range, Range2>, Arg2>> range_product(const typed::union_pw_multi_aff<pair<T1, T2>, Arg2> &upma2) const;
  template <typename Arg2>
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<pair<Range, Range2>, Arg2>> range_product(const typed::multi_aff<pair<T1, T2>, Arg2> &upma2) const;
  template <typename Arg2>
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<pair<Range, Range2>, Arg2>> range_product(const typed::pw_multi_aff<pair<T1, T2>, Arg2> &upma2) const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<pair<Range, Range2>, Anonymous>> range_product(const typed::union_pw_aff<pair<T1, T2>, Anonymous> &upma2) const;
  inline typed::space<> space() const;
  inline typed::space<pair<T1, T2>, pair<Range, Range2>> get_space() const = delete;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> sub(const typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> &upma2) const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> sub(const typed::multi_aff<pair<T1, T2>, pair<Range, Range2>> &upma2) const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> sub(const typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> &upma2) const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> sub(const typed::union_pw_aff<pair<T1, T2>, pair<Range, Range2>> &upma2) const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> subtract_domain(const typed::space<pair<T1, T2>> &space) const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> subtract_domain(const typed::union_set<pair<T1, T2>> &uset) const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> union_add(const typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> &upma2) const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> union_add(const typed::multi_aff<pair<T1, T2>, pair<Range, Range2>> &upma2) const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> union_add(const typed::pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> &upma2) const;
  inline typed::union_pw_multi_aff<pair<T1, T2>, pair<Range, Range2>> union_add(const typed::union_pw_aff<pair<T1, T2>, pair<Range, Range2>> &upma2) const;
};

template <>
struct union_set<> : public isl::union_set {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  union_set() = default;
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::union_set>{}, bool>::type = true>
  union_set(const base &obj) : isl::union_set(obj) {}
 public:
  static union_set from(const isl::union_set &obj) {
    return union_set(obj);
  }
  inline /* implicit */ union_set(const typed::basic_set<> &bset);
  inline /* implicit */ union_set(const typed::point<> &pnt);
  inline /* implicit */ union_set(const typed::set<> &set);
  inline explicit union_set(const isl::ctx &ctx, const std::string &str);
  inline typed::union_set<> apply(const typed::union_map<> &umap) const = delete;
  inline typed::union_set<> apply(const typed::basic_map<> &umap) const = delete;
  inline typed::union_set<> apply(const typed::map<> &umap) const = delete;
  inline typed::set<> as_set() const = delete;
  inline typed::union_set<> coalesce() const;
  inline typed::union_set<> detect_equalities() const;
  inline typed::union_set<> drop_unused_params() const;
  static inline typed::union_set<> empty(const isl::ctx &ctx);
  inline bool every_set(const std::function<bool(typed::set<>)> &test) const;
  inline typed::set<> extract_set(const typed::space<> &space) const;
  inline void foreach_point(const std::function<void(typed::point<>)> &fn) const;
  inline void foreach_set(const std::function<void(typed::set<>)> &fn) const;
  inline typed::union_set<> gist(const typed::union_set<> &context) const;
  inline typed::union_set<> gist(const typed::basic_set<> &context) const;
  inline typed::union_set<> gist(const typed::point<> &context) const;
  inline typed::union_set<> gist(const typed::set<> &context) const;
  inline typed::union_set<> gist_params(const typed::set<> &set) const = delete;
  inline typed::union_set<> gist_params(const typed::basic_set<> &set) const = delete;
  inline typed::union_set<> gist_params(const typed::point<> &set) const = delete;
  inline typed::union_map<> identity() const = delete;
  inline typed::union_set<> intersect(const typed::union_set<> &uset2) const;
  inline typed::union_set<> intersect(const typed::basic_set<> &uset2) const;
  inline typed::union_set<> intersect(const typed::point<> &uset2) const;
  inline typed::union_set<> intersect(const typed::set<> &uset2) const;
  inline typed::union_set<> intersect_params(const typed::set<> &set) const = delete;
  inline typed::union_set<> intersect_params(const typed::basic_set<> &set) const = delete;
  inline typed::union_set<> intersect_params(const typed::point<> &set) const = delete;
  inline typed::union_set<> lexmax() const = delete;
  inline typed::union_set<> lexmin() const = delete;
  inline typed::set<> params() const = delete;
  inline typed::union_set<> preimage(const typed::multi_aff<> &ma) const = delete;
  inline typed::union_set<> preimage(const typed::pw_multi_aff<> &pma) const = delete;
  inline typed::union_set<> preimage(const typed::union_pw_multi_aff<> &upma) const = delete;
  inline typed::union_set<> project_out_all_params() const;
  inline typed::set_list<> set_list() const;
  inline typed::set_list<> get_set_list() const = delete;
  inline typed::space<> space() const;
  inline typed::space<> get_space() const = delete;
  inline typed::union_set<> subtract(const typed::union_set<> &uset2) const;
  inline typed::union_set<> subtract(const typed::basic_set<> &uset2) const;
  inline typed::union_set<> subtract(const typed::point<> &uset2) const;
  inline typed::union_set<> subtract(const typed::set<> &uset2) const;
  inline typed::union_set<> unite(const typed::union_set<> &uset2) const;
  inline typed::union_set<> unite(const typed::basic_set<> &uset2) const;
  inline typed::union_set<> unite(const typed::point<> &uset2) const;
  inline typed::union_set<> unite(const typed::set<> &uset2) const;
  inline typed::union_set<> universe() const;
  inline typed::union_map<> unwrap() const = delete;
};

template <typename Domain>
struct union_set<Domain> : public isl::union_set {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  union_set() = default;
  template <typename Arg1,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{},
            bool>::type = true>
  union_set(const union_set<Arg1> &obj) : isl::union_set(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::union_set>{}, bool>::type = true>
  union_set(const base &obj) : isl::union_set(obj) {}
 public:
  static union_set from(const isl::union_set &obj) {
    return union_set(obj);
  }
  inline /* implicit */ union_set(const typed::basic_set<Domain> &bset);
  inline /* implicit */ union_set(const typed::point<Domain> &pnt);
  inline /* implicit */ union_set(const typed::set<Domain> &set);
  inline explicit union_set(const isl::ctx &ctx, const std::string &str);
  template <typename Range>
  inline typed::union_set<Range> apply(const typed::union_map<Domain, Range> &umap) const;
  template <typename Range>
  inline typed::union_set<Range> apply(const typed::basic_map<Domain, Range> &umap) const;
  template <typename Range>
  inline typed::union_set<Range> apply(const typed::map<Domain, Range> &umap) const;
  inline typed::set<Domain> as_set() const;
  inline typed::union_set<Domain> coalesce() const;
  inline typed::union_set<Domain> detect_equalities() const;
  inline typed::union_set<Domain> drop_unused_params() const;
  static inline typed::union_set<Domain> empty(const isl::ctx &ctx);
  inline bool every_set(const std::function<bool(typed::set<Domain>)> &test) const;
  inline typed::set<Domain> extract_set(const typed::space<Domain> &space) const;
  inline void foreach_point(const std::function<void(typed::point<Domain>)> &fn) const;
  inline void foreach_set(const std::function<void(typed::set<Domain>)> &fn) const;
  inline typed::union_set<Domain> gist(const typed::union_set<Domain> &context) const;
  inline typed::union_set<Domain> gist(const typed::basic_set<Domain> &context) const;
  inline typed::union_set<Domain> gist(const typed::point<Domain> &context) const;
  inline typed::union_set<Domain> gist(const typed::set<Domain> &context) const;
  inline typed::union_set<Domain> gist_params(const typed::set<> &set) const;
  inline typed::union_set<Domain> gist_params(const typed::basic_set<> &set) const;
  inline typed::union_set<Domain> gist_params(const typed::point<> &set) const;
  inline typed::union_map<Domain, Domain> identity() const;
  inline typed::union_set<Domain> intersect(const typed::union_set<Domain> &uset2) const;
  inline typed::union_set<Domain> intersect(const typed::basic_set<Domain> &uset2) const;
  inline typed::union_set<Domain> intersect(const typed::point<Domain> &uset2) const;
  inline typed::union_set<Domain> intersect(const typed::set<Domain> &uset2) const;
  inline typed::union_set<Domain> intersect_params(const typed::set<> &set) const;
  inline typed::union_set<Domain> intersect_params(const typed::basic_set<> &set) const;
  inline typed::union_set<Domain> intersect_params(const typed::point<> &set) const;
  inline typed::union_set<Domain> lexmax() const;
  inline typed::union_set<Domain> lexmin() const;
  inline typed::set<> params() const;
  template <typename Domain2>
  inline typed::union_set<Domain2> preimage(const typed::multi_aff<Domain2, Domain> &ma) const;
  template <typename Domain2>
  inline typed::union_set<Domain2> preimage(const typed::pw_multi_aff<Domain2, Domain> &pma) const;
  template <typename Domain2>
  inline typed::union_set<Domain2> preimage(const typed::union_pw_multi_aff<Domain2, Domain> &upma) const;
  inline typed::union_set<Domain> project_out_all_params() const;
  inline typed::set_list<Domain> set_list() const;
  inline typed::set_list<Domain> get_set_list() const = delete;
  inline typed::space<> space() const;
  inline typed::space<Domain> get_space() const = delete;
  inline typed::union_set<Domain> subtract(const typed::union_set<Domain> &uset2) const;
  inline typed::union_set<Domain> subtract(const typed::basic_set<Domain> &uset2) const;
  inline typed::union_set<Domain> subtract(const typed::point<Domain> &uset2) const;
  inline typed::union_set<Domain> subtract(const typed::set<Domain> &uset2) const;
  inline typed::union_set<Domain> unite(const typed::union_set<Domain> &uset2) const;
  inline typed::union_set<Domain> unite(const typed::basic_set<Domain> &uset2) const;
  inline typed::union_set<Domain> unite(const typed::point<Domain> &uset2) const;
  inline typed::union_set<Domain> unite(const typed::set<Domain> &uset2) const;
  inline typed::union_set<Domain> universe() const;
  inline typed::union_map<Domain> unwrap() const = delete;
};

template <typename Domain, typename Range>
struct union_set<pair<Domain, Range>> : public isl::union_set {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  union_set() = default;
  template <typename Arg1, typename Arg2,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{} &&
              std::is_base_of<Range, Arg2>{},
            bool>::type = true>
  union_set(const union_set<pair<Arg1, Arg2>> &obj) : isl::union_set(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::union_set>{}, bool>::type = true>
  union_set(const base &obj) : isl::union_set(obj) {}
 public:
  static union_set from(const isl::union_set &obj) {
    return union_set(obj);
  }
  inline /* implicit */ union_set(const typed::basic_set<pair<Domain, Range>> &bset);
  inline /* implicit */ union_set(const typed::point<pair<Domain, Range>> &pnt);
  inline /* implicit */ union_set(const typed::set<pair<Domain, Range>> &set);
  inline explicit union_set(const isl::ctx &ctx, const std::string &str);
  template <typename Arg2>
  inline typed::union_set<Arg2> apply(const typed::union_map<pair<Domain, Range>, Arg2> &umap) const;
  template <typename Arg2>
  inline typed::union_set<Arg2> apply(const typed::basic_map<pair<Domain, Range>, Arg2> &umap) const;
  template <typename Arg2>
  inline typed::union_set<Arg2> apply(const typed::map<pair<Domain, Range>, Arg2> &umap) const;
  inline typed::set<pair<Domain, Range>> as_set() const;
  inline typed::union_set<pair<Domain, Range>> coalesce() const;
  inline typed::union_set<pair<Domain, Range>> detect_equalities() const;
  inline typed::union_set<pair<Domain, Range>> drop_unused_params() const;
  static inline typed::union_set<pair<Domain, Range>> empty(const isl::ctx &ctx);
  inline bool every_set(const std::function<bool(typed::set<pair<Domain, Range>>)> &test) const;
  inline typed::set<pair<Domain, Range>> extract_set(const typed::space<pair<Domain, Range>> &space) const;
  inline void foreach_point(const std::function<void(typed::point<pair<Domain, Range>>)> &fn) const;
  inline void foreach_set(const std::function<void(typed::set<pair<Domain, Range>>)> &fn) const;
  inline typed::union_set<pair<Domain, Range>> gist(const typed::union_set<pair<Domain, Range>> &context) const;
  inline typed::union_set<pair<Domain, Range>> gist(const typed::basic_set<pair<Domain, Range>> &context) const;
  inline typed::union_set<pair<Domain, Range>> gist(const typed::point<pair<Domain, Range>> &context) const;
  inline typed::union_set<pair<Domain, Range>> gist(const typed::set<pair<Domain, Range>> &context) const;
  inline typed::union_set<pair<Domain, Range>> gist_params(const typed::set<> &set) const;
  inline typed::union_set<pair<Domain, Range>> gist_params(const typed::basic_set<> &set) const;
  inline typed::union_set<pair<Domain, Range>> gist_params(const typed::point<> &set) const;
  inline typed::union_map<pair<Domain, Range>, pair<Domain, Range>> identity() const;
  inline typed::union_set<pair<Domain, Range>> intersect(const typed::union_set<pair<Domain, Range>> &uset2) const;
  inline typed::union_set<pair<Domain, Range>> intersect(const typed::basic_set<pair<Domain, Range>> &uset2) const;
  inline typed::union_set<pair<Domain, Range>> intersect(const typed::point<pair<Domain, Range>> &uset2) const;
  inline typed::union_set<pair<Domain, Range>> intersect(const typed::set<pair<Domain, Range>> &uset2) const;
  inline typed::union_set<pair<Domain, Range>> intersect_params(const typed::set<> &set) const;
  inline typed::union_set<pair<Domain, Range>> intersect_params(const typed::basic_set<> &set) const;
  inline typed::union_set<pair<Domain, Range>> intersect_params(const typed::point<> &set) const;
  inline typed::union_set<pair<Domain, Range>> lexmax() const;
  inline typed::union_set<pair<Domain, Range>> lexmin() const;
  inline typed::set<> params() const;
  template <typename Domain2>
  inline typed::union_set<Domain2> preimage(const typed::multi_aff<Domain2, pair<Domain, Range>> &ma) const;
  template <typename Domain2>
  inline typed::union_set<Domain2> preimage(const typed::pw_multi_aff<Domain2, pair<Domain, Range>> &pma) const;
  template <typename Domain2>
  inline typed::union_set<Domain2> preimage(const typed::union_pw_multi_aff<Domain2, pair<Domain, Range>> &upma) const;
  inline typed::union_set<pair<Domain, Range>> project_out_all_params() const;
  inline typed::set_list<pair<Domain, Range>> set_list() const;
  inline typed::set_list<pair<Domain, Range>> get_set_list() const = delete;
  inline typed::space<> space() const;
  inline typed::space<pair<Domain, Range>> get_space() const = delete;
  inline typed::union_set<pair<Domain, Range>> subtract(const typed::union_set<pair<Domain, Range>> &uset2) const;
  inline typed::union_set<pair<Domain, Range>> subtract(const typed::basic_set<pair<Domain, Range>> &uset2) const;
  inline typed::union_set<pair<Domain, Range>> subtract(const typed::point<pair<Domain, Range>> &uset2) const;
  inline typed::union_set<pair<Domain, Range>> subtract(const typed::set<pair<Domain, Range>> &uset2) const;
  inline typed::union_set<pair<Domain, Range>> unite(const typed::union_set<pair<Domain, Range>> &uset2) const;
  inline typed::union_set<pair<Domain, Range>> unite(const typed::basic_set<pair<Domain, Range>> &uset2) const;
  inline typed::union_set<pair<Domain, Range>> unite(const typed::point<pair<Domain, Range>> &uset2) const;
  inline typed::union_set<pair<Domain, Range>> unite(const typed::set<pair<Domain, Range>> &uset2) const;
  inline typed::union_set<pair<Domain, Range>> universe() const;
  inline typed::union_map<Domain, Range> unwrap() const;
};

template <>
struct union_set_list<> : public isl::union_set_list {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  union_set_list() = default;
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::union_set_list>{}, bool>::type = true>
  union_set_list(const base &obj) : isl::union_set_list(obj) {}
 public:
  static union_set_list from(const isl::union_set_list &obj) {
    return union_set_list(obj);
  }
  inline explicit union_set_list(const isl::ctx &ctx, int n);
  inline explicit union_set_list(const typed::union_set<> &el);
  inline explicit union_set_list(const isl::ctx &ctx, const std::string &str);
  inline typed::union_set_list<> add(const typed::union_set<> &el) const;
  inline typed::union_set_list<> add(const typed::basic_set<> &el) const;
  inline typed::union_set_list<> add(const typed::point<> &el) const;
  inline typed::union_set_list<> add(const typed::set<> &el) const;
  inline typed::union_set<> at(int index) const = delete;
  inline typed::union_set<> get_at(int index) const = delete;
  inline typed::union_set_list<> drop(unsigned int first, unsigned int n) const;
  inline void foreach(const std::function<void(typed::union_set<>)> &fn) const;
  inline void foreach_scc(const std::function<bool(typed::union_set<>, typed::union_set<>)> &follows, const std::function<void(typed::union_set_list<>)> &fn) const;
  inline typed::union_set_list<> set_at(int index, const typed::union_set<> &el) const = delete;
};

template <typename Domain>
struct union_set_list<Domain> : public isl::union_set_list {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  union_set_list() = default;
  template <typename Arg1,
            typename std::enable_if<
              std::is_base_of<Domain, Arg1>{},
            bool>::type = true>
  union_set_list(const union_set_list<Arg1> &obj) : isl::union_set_list(obj) {}
 private:
  template <typename base,
            typename std::enable_if<
              std::is_same<base, isl::union_set_list>{}, bool>::type = true>
  union_set_list(const base &obj) : isl::union_set_list(obj) {}
 public:
  static union_set_list from(const isl::union_set_list &obj) {
    return union_set_list(obj);
  }
  inline explicit union_set_list(const isl::ctx &ctx, int n);
  inline explicit union_set_list(const typed::union_set<Domain> &el);
  inline explicit union_set_list(const isl::ctx &ctx, const std::string &str);
  inline typed::union_set_list<Domain> add(const typed::union_set<Domain> &el) const;
  inline typed::union_set_list<Domain> add(const typed::basic_set<Domain> &el) const;
  inline typed::union_set_list<Domain> add(const typed::point<Domain> &el) const;
  inline typed::union_set_list<Domain> add(const typed::set<Domain> &el) const;
  inline typed::union_set<Domain> at(int index) const;
  inline typed::union_set<Domain> get_at(int index) const = delete;
  inline typed::union_set_list<Domain> drop(unsigned int first, unsigned int n) const;
  inline void foreach(const std::function<void(typed::union_set<Domain>)> &fn) const;
  inline void foreach_scc(const std::function<bool(typed::union_set<Domain>, typed::union_set<Domain>)> &follows, const std::function<void(typed::union_set_list<Domain>)> &fn) const;
  inline typed::union_set_list<Domain> set_at(int index, const typed::union_set<Anonymous> &el) const;
};

template <>
struct val<Anonymous> : public isl::val {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  val() = default;
  val(const isl::val &obj) : isl::val(obj) {}
  static val from(const isl::val &obj) {
    return val(obj);
  }
  inline explicit val(const isl::ctx &ctx, long i);
  inline explicit val(const isl::ctx &ctx, const std::string &str);
  inline typed::val<Anonymous> add(const typed::val<Anonymous> &v2) const;
  inline typed::val<Anonymous> add(long v2) const;
  inline typed::val<Anonymous> ceil() const;
  inline long get_den_si() const = delete;
  inline typed::val<Anonymous> floor() const;
  inline typed::val<Anonymous> max(const typed::val<Anonymous> &v2) const;
  inline typed::val<Anonymous> max(long v2) const;
  inline typed::val<Anonymous> min(const typed::val<Anonymous> &v2) const;
  inline typed::val<Anonymous> min(long v2) const;
  inline typed::val<Anonymous> mod(const typed::val<Anonymous> &v2) const;
  inline typed::val<Anonymous> mod(long v2) const;
  inline typed::val<Anonymous> neg() const;
  inline long get_num_si() const = delete;
  inline typed::val<Anonymous> sub(const typed::val<Anonymous> &v2) const;
  inline typed::val<Anonymous> sub(long v2) const;
};

template <>
struct val_list<Anonymous> : public isl::val_list {
  template <typename...>
  friend struct aff;
  template <typename...>
  friend struct aff_list;
  template <typename...>
  friend struct basic_map;
  template <typename...>
  friend struct basic_set;
  template <typename...>
  friend struct fixed_box;
  template <typename...>
  friend struct id;
  template <typename...>
  friend struct id_list;
  template <typename...>
  friend struct map;
  template <typename...>
  friend struct map_list;
  template <typename...>
  friend struct multi_aff;
  template <typename...>
  friend struct multi_id;
  template <typename...>
  friend struct multi_pw_aff;
  template <typename...>
  friend struct multi_union_pw_aff;
  template <typename...>
  friend struct multi_val;
  template <typename...>
  friend struct point;
  template <typename...>
  friend struct pw_aff;
  template <typename...>
  friend struct pw_aff_list;
  template <typename...>
  friend struct pw_multi_aff;
  template <typename...>
  friend struct pw_multi_aff_list;
  template <typename...>
  friend struct set;
  template <typename...>
  friend struct set_list;
  template <typename...>
  friend struct space;
  template <typename...>
  friend struct union_map;
  template <typename...>
  friend struct union_pw_aff;
  template <typename...>
  friend struct union_pw_aff_list;
  template <typename...>
  friend struct union_pw_multi_aff;
  template <typename...>
  friend struct union_set;
  template <typename...>
  friend struct union_set_list;
  template <typename...>
  friend struct val;
  template <typename...>
  friend struct val_list;

  val_list() = default;
  val_list(const isl::val_list &obj) : isl::val_list(obj) {}
  static val_list from(const isl::val_list &obj) {
    return val_list(obj);
  }
  inline explicit val_list(const isl::ctx &ctx, int n);
  inline explicit val_list(const typed::val<Anonymous> &el);
  inline explicit val_list(const isl::ctx &ctx, const std::string &str);
  inline typed::val_list<Anonymous> add(const typed::val<Anonymous> &el) const;
  inline typed::val_list<Anonymous> add(long el) const;
  inline typed::val<Anonymous> at(int index) const;
  inline typed::val<Anonymous> get_at(int index) const = delete;
  inline typed::val_list<Anonymous> drop(unsigned int first, unsigned int n) const;
  inline void foreach(const std::function<void(typed::val<Anonymous>)> &fn) const;
  inline void foreach_scc(const std::function<bool(typed::val<Anonymous>, typed::val<Anonymous>)> &follows, const std::function<void(typed::val_list<Anonymous>)> &fn) const;
  inline typed::val_list<Anonymous> set_at(int index, const typed::val<Anonymous> &el) const;
  inline typed::val_list<Anonymous> set_at(int index, long el) const;
};

typed::aff<Anonymous>::aff(const isl::ctx &ctx, const std::string &str)
  : isl::aff(ctx, str)
{
}

typed::aff<Anonymous> typed::aff<Anonymous>::add(const typed::aff<Anonymous> &aff2) const
{
  auto res = isl::aff::add(aff2);
  return typed::aff<Anonymous>(res);
}

typed::multi_aff<Anonymous> typed::aff<Anonymous>::add(const typed::multi_aff<Anonymous> &multi2) const
{
  auto res = isl::aff::add(multi2);
  return typed::multi_aff<Anonymous>(res);
}

typed::multi_pw_aff<Anonymous> typed::aff<Anonymous>::add(const typed::multi_pw_aff<Anonymous> &multi2) const
{
  auto res = isl::aff::add(multi2);
  return typed::multi_pw_aff<Anonymous>(res);
}

typed::multi_union_pw_aff<Anonymous> typed::aff<Anonymous>::add(const typed::multi_union_pw_aff<Anonymous> &multi2) const
{
  auto res = isl::aff::add(multi2);
  return typed::multi_union_pw_aff<Anonymous>(res);
}

typed::pw_aff<Anonymous> typed::aff<Anonymous>::add(const typed::pw_aff<Anonymous> &pwaff2) const
{
  auto res = isl::aff::add(pwaff2);
  return typed::pw_aff<Anonymous>(res);
}

typed::pw_multi_aff<Anonymous> typed::aff<Anonymous>::add(const typed::pw_multi_aff<Anonymous> &pma2) const
{
  auto res = isl::aff::add(pma2);
  return typed::pw_multi_aff<Anonymous>(res);
}

typed::union_pw_aff<Anonymous> typed::aff<Anonymous>::add(const typed::union_pw_aff<Anonymous> &upa2) const
{
  auto res = isl::aff::add(upa2);
  return typed::union_pw_aff<Anonymous>(res);
}

typed::union_pw_multi_aff<Anonymous> typed::aff<Anonymous>::add(const typed::union_pw_multi_aff<Anonymous> &upma2) const
{
  auto res = isl::aff::add(upma2);
  return typed::union_pw_multi_aff<Anonymous>(res);
}

typed::aff<Anonymous> typed::aff<Anonymous>::add_constant(const typed::val<Anonymous> &v) const
{
  auto res = isl::aff::add_constant(v);
  return typed::aff<Anonymous>(res);
}

typed::aff<Anonymous> typed::aff<Anonymous>::add_constant(long v) const
{
  auto res = isl::aff::add_constant(v);
  return typed::aff<Anonymous>(res);
}

typed::multi_aff<Anonymous> typed::aff<Anonymous>::add_constant(const typed::multi_val<Anonymous> &mv) const
{
  auto res = isl::aff::add_constant(mv);
  return typed::multi_aff<Anonymous>(res);
}

template <typename Range>
typed::union_pw_multi_aff<Range> typed::aff<Anonymous>::apply(const typed::union_pw_multi_aff<Anonymous, Range> &upma2) const
{
  auto res = isl::aff::apply(upma2);
  return typed::union_pw_multi_aff<Range>(res);
}

typed::aff<Anonymous> typed::aff<Anonymous>::as_aff() const
{
  auto res = isl::aff::as_aff();
  return typed::aff<Anonymous>(res);
}

typed::multi_aff<Anonymous> typed::aff<Anonymous>::as_multi_aff() const
{
  auto res = isl::aff::as_multi_aff();
  return typed::multi_aff<Anonymous>(res);
}

typed::multi_union_pw_aff<Anonymous> typed::aff<Anonymous>::as_multi_union_pw_aff() const
{
  auto res = isl::aff::as_multi_union_pw_aff();
  return typed::multi_union_pw_aff<Anonymous>(res);
}

typed::pw_multi_aff<Anonymous> typed::aff<Anonymous>::as_pw_multi_aff() const
{
  auto res = isl::aff::as_pw_multi_aff();
  return typed::pw_multi_aff<Anonymous>(res);
}

typed::set<Anonymous> typed::aff<Anonymous>::as_set() const
{
  auto res = isl::aff::as_set();
  return typed::set<Anonymous>(res);
}

typed::aff<Anonymous> typed::aff<Anonymous>::at(int pos) const
{
  auto res = isl::aff::at(pos);
  return typed::aff<Anonymous>(res);
}

typed::basic_set<> typed::aff<Anonymous>::bind(const typed::id<Anonymous> &id) const
{
  auto res = isl::aff::bind(id);
  return typed::basic_set<>(res);
}

typed::basic_set<> typed::aff<Anonymous>::bind(const std::string &id) const
{
  auto res = isl::aff::bind(id);
  return typed::basic_set<>(res);
}

typed::basic_set<> typed::aff<Anonymous>::bind(const typed::multi_id<Anonymous> &tuple) const
{
  auto res = isl::aff::bind(tuple);
  return typed::basic_set<>(res);
}

typed::aff<Anonymous> typed::aff<Anonymous>::ceil() const
{
  auto res = isl::aff::ceil();
  return typed::aff<Anonymous>(res);
}

typed::pw_aff<Anonymous> typed::aff<Anonymous>::coalesce() const
{
  auto res = isl::aff::coalesce();
  return typed::pw_aff<Anonymous>(res);
}

typed::pw_aff<Anonymous> typed::aff<Anonymous>::cond(const typed::pw_aff<Anonymous> &pwaff_true, const typed::pw_aff<Anonymous> &pwaff_false) const
{
  auto res = isl::aff::cond(pwaff_true, pwaff_false);
  return typed::pw_aff<Anonymous>(res);
}

typed::multi_val<Anonymous> typed::aff<Anonymous>::constant_multi_val() const
{
  auto res = isl::aff::constant_multi_val();
  return typed::multi_val<Anonymous>(res);
}

typed::val<Anonymous> typed::aff<Anonymous>::constant_val() const
{
  auto res = isl::aff::constant_val();
  return typed::val<Anonymous>(res);
}

typed::set<> typed::aff<Anonymous>::domain() const
{
  auto res = isl::aff::domain();
  return typed::set<>(res);
}

typed::pw_aff<Anonymous> typed::aff<Anonymous>::drop_unused_params() const
{
  auto res = isl::aff::drop_unused_params();
  return typed::pw_aff<Anonymous>(res);
}

typed::pw_multi_aff<Anonymous> typed::aff<Anonymous>::extract_pw_multi_aff(const typed::space<Anonymous> &space) const
{
  auto res = isl::aff::extract_pw_multi_aff(space);
  return typed::pw_multi_aff<Anonymous>(res);
}

typed::aff<Anonymous> typed::aff<Anonymous>::floor() const
{
  auto res = isl::aff::floor();
  return typed::aff<Anonymous>(res);
}

typed::aff<Anonymous> typed::aff<Anonymous>::gist(const typed::set<> &context) const
{
  auto res = isl::aff::gist(context);
  return typed::aff<Anonymous>(res);
}

typed::union_pw_aff<Anonymous> typed::aff<Anonymous>::gist(const typed::union_set<> &context) const
{
  auto res = isl::aff::gist(context);
  return typed::union_pw_aff<Anonymous>(res);
}

typed::aff<Anonymous> typed::aff<Anonymous>::gist(const typed::basic_set<> &context) const
{
  auto res = isl::aff::gist(context);
  return typed::aff<Anonymous>(res);
}

typed::aff<Anonymous> typed::aff<Anonymous>::gist(const typed::point<> &context) const
{
  auto res = isl::aff::gist(context);
  return typed::aff<Anonymous>(res);
}

typed::aff<Anonymous> typed::aff<Anonymous>::gist_params(const typed::set<> &context) const
{
  auto res = isl::aff::gist_params(context);
  return typed::aff<Anonymous>(res);
}

typed::aff<Anonymous> typed::aff<Anonymous>::gist_params(const typed::basic_set<> &context) const
{
  auto res = isl::aff::gist_params(context);
  return typed::aff<Anonymous>(res);
}

typed::aff<Anonymous> typed::aff<Anonymous>::gist_params(const typed::point<> &context) const
{
  auto res = isl::aff::gist_params(context);
  return typed::aff<Anonymous>(res);
}

typed::multi_aff<Anonymous, Anonymous> typed::aff<Anonymous>::identity() const
{
  auto res = isl::aff::identity();
  return typed::multi_aff<Anonymous, Anonymous>(res);
}

template <typename Domain>
typed::pw_aff<Domain, Anonymous> typed::aff<Anonymous>::insert_domain(const typed::space<Domain> &domain) const
{
  auto res = isl::aff::insert_domain(domain);
  return typed::pw_aff<Domain, Anonymous>(res);
}

typed::pw_aff<Anonymous> typed::aff<Anonymous>::intersect_params(const typed::set<> &set) const
{
  auto res = isl::aff::intersect_params(set);
  return typed::pw_aff<Anonymous>(res);
}

typed::aff_list<Anonymous> typed::aff<Anonymous>::list() const
{
  auto res = isl::aff::list();
  return typed::aff_list<Anonymous>(res);
}

typed::multi_pw_aff<Anonymous> typed::aff<Anonymous>::max(const typed::multi_pw_aff<Anonymous> &multi2) const
{
  auto res = isl::aff::max(multi2);
  return typed::multi_pw_aff<Anonymous>(res);
}

typed::pw_aff<Anonymous> typed::aff<Anonymous>::max(const typed::pw_aff<Anonymous> &pwaff2) const
{
  auto res = isl::aff::max(pwaff2);
  return typed::pw_aff<Anonymous>(res);
}

typed::multi_val<Anonymous> typed::aff<Anonymous>::max_multi_val() const
{
  auto res = isl::aff::max_multi_val();
  return typed::multi_val<Anonymous>(res);
}

typed::val<Anonymous> typed::aff<Anonymous>::max_val() const
{
  auto res = isl::aff::max_val();
  return typed::val<Anonymous>(res);
}

typed::multi_pw_aff<Anonymous> typed::aff<Anonymous>::min(const typed::multi_pw_aff<Anonymous> &multi2) const
{
  auto res = isl::aff::min(multi2);
  return typed::multi_pw_aff<Anonymous>(res);
}

typed::pw_aff<Anonymous> typed::aff<Anonymous>::min(const typed::pw_aff<Anonymous> &pwaff2) const
{
  auto res = isl::aff::min(pwaff2);
  return typed::pw_aff<Anonymous>(res);
}

typed::multi_val<Anonymous> typed::aff<Anonymous>::min_multi_val() const
{
  auto res = isl::aff::min_multi_val();
  return typed::multi_val<Anonymous>(res);
}

typed::val<Anonymous> typed::aff<Anonymous>::min_val() const
{
  auto res = isl::aff::min_val();
  return typed::val<Anonymous>(res);
}

typed::aff<Anonymous> typed::aff<Anonymous>::mod(const typed::val<Anonymous> &mod) const
{
  auto res = isl::aff::mod(mod);
  return typed::aff<Anonymous>(res);
}

typed::aff<Anonymous> typed::aff<Anonymous>::mod(long mod) const
{
  auto res = isl::aff::mod(mod);
  return typed::aff<Anonymous>(res);
}

typed::aff<Anonymous> typed::aff<Anonymous>::neg() const
{
  auto res = isl::aff::neg();
  return typed::aff<Anonymous>(res);
}

typed::set<> typed::aff<Anonymous>::params() const
{
  auto res = isl::aff::params();
  return typed::set<>(res);
}

template <typename Range>
typed::multi_aff<pair<Anonymous, Range>> typed::aff<Anonymous>::product(const typed::multi_aff<Range> &multi2) const
{
  auto res = isl::aff::product(multi2);
  return typed::multi_aff<pair<Anonymous, Range>>(res);
}

template <typename Range>
typed::multi_pw_aff<pair<Anonymous, Range>> typed::aff<Anonymous>::product(const typed::multi_pw_aff<Range> &multi2) const
{
  auto res = isl::aff::product(multi2);
  return typed::multi_pw_aff<pair<Anonymous, Range>>(res);
}

template <typename Range>
typed::pw_multi_aff<pair<Anonymous, Range>> typed::aff<Anonymous>::product(const typed::pw_multi_aff<Range> &pma2) const
{
  auto res = isl::aff::product(pma2);
  return typed::pw_multi_aff<pair<Anonymous, Range>>(res);
}

typed::pw_multi_aff_list<Anonymous> typed::aff<Anonymous>::pw_multi_aff_list() const
{
  auto res = isl::aff::pw_multi_aff_list();
  return typed::pw_multi_aff_list<Anonymous>(res);
}

typed::aff<Anonymous> typed::aff<Anonymous>::scale(const typed::val<Anonymous> &v) const
{
  auto res = isl::aff::scale(v);
  return typed::aff<Anonymous>(res);
}

typed::aff<Anonymous> typed::aff<Anonymous>::scale(long v) const
{
  auto res = isl::aff::scale(v);
  return typed::aff<Anonymous>(res);
}

typed::multi_aff<Anonymous> typed::aff<Anonymous>::scale(const typed::multi_val<Anonymous> &mv) const
{
  auto res = isl::aff::scale(mv);
  return typed::multi_aff<Anonymous>(res);
}

typed::aff<Anonymous> typed::aff<Anonymous>::scale_down(const typed::val<Anonymous> &v) const
{
  auto res = isl::aff::scale_down(v);
  return typed::aff<Anonymous>(res);
}

typed::aff<Anonymous> typed::aff<Anonymous>::scale_down(long v) const
{
  auto res = isl::aff::scale_down(v);
  return typed::aff<Anonymous>(res);
}

typed::multi_aff<Anonymous> typed::aff<Anonymous>::scale_down(const typed::multi_val<Anonymous> &mv) const
{
  auto res = isl::aff::scale_down(mv);
  return typed::multi_aff<Anonymous>(res);
}

typed::multi_aff<Anonymous> typed::aff<Anonymous>::set_at(int pos, const typed::aff<Anonymous> &el) const
{
  auto res = isl::aff::set_at(pos, el);
  return typed::multi_aff<Anonymous>(res);
}

typed::multi_pw_aff<Anonymous> typed::aff<Anonymous>::set_at(int pos, const typed::pw_aff<Anonymous> &el) const
{
  auto res = isl::aff::set_at(pos, el);
  return typed::multi_pw_aff<Anonymous>(res);
}

typed::multi_union_pw_aff<Anonymous> typed::aff<Anonymous>::set_at(int pos, const typed::union_pw_aff<Anonymous> &el) const
{
  auto res = isl::aff::set_at(pos, el);
  return typed::multi_union_pw_aff<Anonymous>(res);
}

template <typename Domain2>
typed::multi_aff<Domain2> typed::aff<Anonymous>::set_range_tuple(const typed::id<Anonymous> &id) const
{
  auto res = isl::aff::set_range_tuple(id);
  return typed::multi_aff<Domain2>(res);
}

template <typename Domain2>
typed::multi_aff<Domain2> typed::aff<Anonymous>::set_range_tuple(const std::string &id) const
{
  auto res = isl::aff::set_range_tuple(id);
  return typed::multi_aff<Domain2>(res);
}

typed::space<Anonymous> typed::aff<Anonymous>::space() const
{
  auto res = isl::aff::space();
  return typed::space<Anonymous>(res);
}

typed::aff<Anonymous> typed::aff<Anonymous>::sub(const typed::aff<Anonymous> &aff2) const
{
  auto res = isl::aff::sub(aff2);
  return typed::aff<Anonymous>(res);
}

typed::multi_aff<Anonymous> typed::aff<Anonymous>::sub(const typed::multi_aff<Anonymous> &multi2) const
{
  auto res = isl::aff::sub(multi2);
  return typed::multi_aff<Anonymous>(res);
}

typed::multi_pw_aff<Anonymous> typed::aff<Anonymous>::sub(const typed::multi_pw_aff<Anonymous> &multi2) const
{
  auto res = isl::aff::sub(multi2);
  return typed::multi_pw_aff<Anonymous>(res);
}

typed::multi_union_pw_aff<Anonymous> typed::aff<Anonymous>::sub(const typed::multi_union_pw_aff<Anonymous> &multi2) const
{
  auto res = isl::aff::sub(multi2);
  return typed::multi_union_pw_aff<Anonymous>(res);
}

typed::pw_aff<Anonymous> typed::aff<Anonymous>::sub(const typed::pw_aff<Anonymous> &pwaff2) const
{
  auto res = isl::aff::sub(pwaff2);
  return typed::pw_aff<Anonymous>(res);
}

typed::pw_multi_aff<Anonymous> typed::aff<Anonymous>::sub(const typed::pw_multi_aff<Anonymous> &pma2) const
{
  auto res = isl::aff::sub(pma2);
  return typed::pw_multi_aff<Anonymous>(res);
}

typed::union_pw_aff<Anonymous> typed::aff<Anonymous>::sub(const typed::union_pw_aff<Anonymous> &upa2) const
{
  auto res = isl::aff::sub(upa2);
  return typed::union_pw_aff<Anonymous>(res);
}

typed::union_pw_multi_aff<Anonymous> typed::aff<Anonymous>::sub(const typed::union_pw_multi_aff<Anonymous> &upma2) const
{
  auto res = isl::aff::sub(upma2);
  return typed::union_pw_multi_aff<Anonymous>(res);
}

typed::multi_pw_aff<Anonymous> typed::aff<Anonymous>::to_multi_pw_aff() const
{
  auto res = isl::aff::to_multi_pw_aff();
  return typed::multi_pw_aff<Anonymous>(res);
}

typed::multi_union_pw_aff<Anonymous> typed::aff<Anonymous>::to_multi_union_pw_aff() const
{
  auto res = isl::aff::to_multi_union_pw_aff();
  return typed::multi_union_pw_aff<Anonymous>(res);
}

typed::pw_multi_aff<Anonymous> typed::aff<Anonymous>::to_pw_multi_aff() const
{
  auto res = isl::aff::to_pw_multi_aff();
  return typed::pw_multi_aff<Anonymous>(res);
}

typed::union_pw_aff<Anonymous> typed::aff<Anonymous>::to_union_pw_aff() const
{
  auto res = isl::aff::to_union_pw_aff();
  return typed::union_pw_aff<Anonymous>(res);
}

typed::union_pw_multi_aff<Anonymous> typed::aff<Anonymous>::to_union_pw_multi_aff() const
{
  auto res = isl::aff::to_union_pw_multi_aff();
  return typed::union_pw_multi_aff<Anonymous>(res);
}

template <typename Domain>
typed::aff<Domain, Anonymous> typed::aff<Anonymous>::unbind_params_insert_domain(const typed::multi_id<Domain> &domain) const
{
  auto res = isl::aff::unbind_params_insert_domain(domain);
  return typed::aff<Domain, Anonymous>(res);
}

typed::multi_pw_aff<Anonymous> typed::aff<Anonymous>::union_add(const typed::multi_pw_aff<Anonymous> &mpa2) const
{
  auto res = isl::aff::union_add(mpa2);
  return typed::multi_pw_aff<Anonymous>(res);
}

typed::multi_union_pw_aff<Anonymous> typed::aff<Anonymous>::union_add(const typed::multi_union_pw_aff<Anonymous> &mupa2) const
{
  auto res = isl::aff::union_add(mupa2);
  return typed::multi_union_pw_aff<Anonymous>(res);
}

typed::pw_aff<Anonymous> typed::aff<Anonymous>::union_add(const typed::pw_aff<Anonymous> &pwaff2) const
{
  auto res = isl::aff::union_add(pwaff2);
  return typed::pw_aff<Anonymous>(res);
}

typed::pw_multi_aff<Anonymous> typed::aff<Anonymous>::union_add(const typed::pw_multi_aff<Anonymous> &pma2) const
{
  auto res = isl::aff::union_add(pma2);
  return typed::pw_multi_aff<Anonymous>(res);
}

typed::union_pw_aff<Anonymous> typed::aff<Anonymous>::union_add(const typed::union_pw_aff<Anonymous> &upa2) const
{
  auto res = isl::aff::union_add(upa2);
  return typed::union_pw_aff<Anonymous>(res);
}

typed::union_pw_multi_aff<Anonymous> typed::aff<Anonymous>::union_add(const typed::union_pw_multi_aff<Anonymous> &upma2) const
{
  auto res = isl::aff::union_add(upma2);
  return typed::union_pw_multi_aff<Anonymous>(res);
}

template <typename Domain>
typed::aff<Domain, Anonymous>::aff(const isl::ctx &ctx, const std::string &str)
  : isl::aff(ctx, str)
{
}

template <typename Domain>
typed::aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::add(const typed::aff<Domain, Anonymous> &aff2) const
{
  auto res = isl::aff::add(aff2);
  return typed::aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::multi_aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::add(const typed::multi_aff<Domain, Anonymous> &multi2) const
{
  auto res = isl::aff::add(multi2);
  return typed::multi_aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::multi_pw_aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::add(const typed::multi_pw_aff<Domain, Anonymous> &multi2) const
{
  auto res = isl::aff::add(multi2);
  return typed::multi_pw_aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::multi_union_pw_aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::add(const typed::multi_union_pw_aff<Domain, Anonymous> &multi2) const
{
  auto res = isl::aff::add(multi2);
  return typed::multi_union_pw_aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::pw_aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::add(const typed::pw_aff<Domain, Anonymous> &pwaff2) const
{
  auto res = isl::aff::add(pwaff2);
  return typed::pw_aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::pw_multi_aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::add(const typed::pw_multi_aff<Domain, Anonymous> &pma2) const
{
  auto res = isl::aff::add(pma2);
  return typed::pw_multi_aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::union_pw_aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::add(const typed::union_pw_aff<Domain, Anonymous> &upa2) const
{
  auto res = isl::aff::add(upa2);
  return typed::union_pw_aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::union_pw_multi_aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::add(const typed::union_pw_multi_aff<Domain, Anonymous> &upma2) const
{
  auto res = isl::aff::add(upma2);
  return typed::union_pw_multi_aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::add_constant(const typed::val<Anonymous> &v) const
{
  auto res = isl::aff::add_constant(v);
  return typed::aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::add_constant(long v) const
{
  auto res = isl::aff::add_constant(v);
  return typed::aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::multi_aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::add_constant(const typed::multi_val<Anonymous> &mv) const
{
  auto res = isl::aff::add_constant(mv);
  return typed::multi_aff<Domain, Anonymous>(res);
}

template <typename Domain>
template <typename Range2>
typed::union_pw_multi_aff<Domain, Range2> typed::aff<Domain, Anonymous>::apply(const typed::union_pw_multi_aff<Anonymous, Range2> &upma2) const
{
  auto res = isl::aff::apply(upma2);
  return typed::union_pw_multi_aff<Domain, Range2>(res);
}

template <typename Domain>
typed::aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::as_aff() const
{
  auto res = isl::aff::as_aff();
  return typed::aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::map<Domain, Anonymous> typed::aff<Domain, Anonymous>::as_map() const
{
  auto res = isl::aff::as_map();
  return typed::map<Domain, Anonymous>(res);
}

template <typename Domain>
typed::multi_aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::as_multi_aff() const
{
  auto res = isl::aff::as_multi_aff();
  return typed::multi_aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::multi_union_pw_aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::as_multi_union_pw_aff() const
{
  auto res = isl::aff::as_multi_union_pw_aff();
  return typed::multi_union_pw_aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::pw_multi_aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::as_pw_multi_aff() const
{
  auto res = isl::aff::as_pw_multi_aff();
  return typed::pw_multi_aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::union_map<Domain, Anonymous> typed::aff<Domain, Anonymous>::as_union_map() const
{
  auto res = isl::aff::as_union_map();
  return typed::union_map<Domain, Anonymous>(res);
}

template <typename Domain>
typed::aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::at(int pos) const
{
  auto res = isl::aff::at(pos);
  return typed::aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::basic_set<Domain> typed::aff<Domain, Anonymous>::bind(const typed::id<Anonymous> &id) const
{
  auto res = isl::aff::bind(id);
  return typed::basic_set<Domain>(res);
}

template <typename Domain>
typed::basic_set<Domain> typed::aff<Domain, Anonymous>::bind(const std::string &id) const
{
  auto res = isl::aff::bind(id);
  return typed::basic_set<Domain>(res);
}

template <typename Domain>
typed::basic_set<Domain> typed::aff<Domain, Anonymous>::bind(const typed::multi_id<Anonymous> &tuple) const
{
  auto res = isl::aff::bind(tuple);
  return typed::basic_set<Domain>(res);
}

template <typename Domain>
typed::pw_aff<Anonymous> typed::aff<Domain, Anonymous>::bind_domain(const typed::multi_id<Domain> &tuple) const
{
  auto res = isl::aff::bind_domain(tuple);
  return typed::pw_aff<Anonymous>(res);
}

template <typename Domain>
typed::aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::ceil() const
{
  auto res = isl::aff::ceil();
  return typed::aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::pw_aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::coalesce() const
{
  auto res = isl::aff::coalesce();
  return typed::pw_aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::pw_aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::cond(const typed::pw_aff<Domain, Anonymous> &pwaff_true, const typed::pw_aff<Domain, Anonymous> &pwaff_false) const
{
  auto res = isl::aff::cond(pwaff_true, pwaff_false);
  return typed::pw_aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::multi_val<Anonymous> typed::aff<Domain, Anonymous>::constant_multi_val() const
{
  auto res = isl::aff::constant_multi_val();
  return typed::multi_val<Anonymous>(res);
}

template <typename Domain>
typed::val<Anonymous> typed::aff<Domain, Anonymous>::constant_val() const
{
  auto res = isl::aff::constant_val();
  return typed::val<Anonymous>(res);
}

template <typename Domain>
typed::set<Domain> typed::aff<Domain, Anonymous>::domain() const
{
  auto res = isl::aff::domain();
  return typed::set<Domain>(res);
}

template <typename Domain>
typed::pw_aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::drop_unused_params() const
{
  auto res = isl::aff::drop_unused_params();
  return typed::pw_aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::pw_multi_aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::extract_pw_multi_aff(const typed::space<Domain, Anonymous> &space) const
{
  auto res = isl::aff::extract_pw_multi_aff(space);
  return typed::pw_multi_aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::floor() const
{
  auto res = isl::aff::floor();
  return typed::aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::set<Domain> typed::aff<Domain, Anonymous>::ge_set(const typed::aff<Domain, Anonymous> &aff2) const
{
  auto res = isl::aff::ge_set(aff2);
  return typed::set<Domain>(res);
}

template <typename Domain>
typed::set<Domain> typed::aff<Domain, Anonymous>::ge_set(const typed::pw_aff<Domain, Anonymous> &pwaff2) const
{
  auto res = isl::aff::ge_set(pwaff2);
  return typed::set<Domain>(res);
}

template <typename Domain>
typed::aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::gist(const typed::set<Domain> &context) const
{
  auto res = isl::aff::gist(context);
  return typed::aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::union_pw_aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::gist(const typed::union_set<Domain> &context) const
{
  auto res = isl::aff::gist(context);
  return typed::union_pw_aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::gist(const typed::basic_set<Domain> &context) const
{
  auto res = isl::aff::gist(context);
  return typed::aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::gist(const typed::point<Domain> &context) const
{
  auto res = isl::aff::gist(context);
  return typed::aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::gist_params(const typed::set<> &context) const
{
  auto res = isl::aff::gist_params(context);
  return typed::aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::gist_params(const typed::basic_set<> &context) const
{
  auto res = isl::aff::gist_params(context);
  return typed::aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::gist_params(const typed::point<> &context) const
{
  auto res = isl::aff::gist_params(context);
  return typed::aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::set<Domain> typed::aff<Domain, Anonymous>::gt_set(const typed::aff<Domain, Anonymous> &aff2) const
{
  auto res = isl::aff::gt_set(aff2);
  return typed::set<Domain>(res);
}

template <typename Domain>
typed::set<Domain> typed::aff<Domain, Anonymous>::gt_set(const typed::pw_aff<Domain, Anonymous> &pwaff2) const
{
  auto res = isl::aff::gt_set(pwaff2);
  return typed::set<Domain>(res);
}

template <typename Domain>
typed::multi_aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::identity() const
{
  auto res = isl::aff::identity();
  return typed::multi_aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::pw_aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::intersect_domain(const typed::set<Domain> &set) const
{
  auto res = isl::aff::intersect_domain(set);
  return typed::pw_aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::union_pw_aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::intersect_domain(const typed::space<Domain> &space) const
{
  auto res = isl::aff::intersect_domain(space);
  return typed::union_pw_aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::union_pw_aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::intersect_domain(const typed::union_set<Domain> &uset) const
{
  auto res = isl::aff::intersect_domain(uset);
  return typed::union_pw_aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::pw_aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::intersect_params(const typed::set<> &set) const
{
  auto res = isl::aff::intersect_params(set);
  return typed::pw_aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::set<Domain> typed::aff<Domain, Anonymous>::le_set(const typed::aff<Domain, Anonymous> &aff2) const
{
  auto res = isl::aff::le_set(aff2);
  return typed::set<Domain>(res);
}

template <typename Domain>
typed::set<Domain> typed::aff<Domain, Anonymous>::le_set(const typed::pw_aff<Domain, Anonymous> &pwaff2) const
{
  auto res = isl::aff::le_set(pwaff2);
  return typed::set<Domain>(res);
}

template <typename Domain>
typed::aff_list<Domain, Anonymous> typed::aff<Domain, Anonymous>::list() const
{
  auto res = isl::aff::list();
  return typed::aff_list<Domain, Anonymous>(res);
}

template <typename Domain>
typed::set<Domain> typed::aff<Domain, Anonymous>::lt_set(const typed::aff<Domain, Anonymous> &aff2) const
{
  auto res = isl::aff::lt_set(aff2);
  return typed::set<Domain>(res);
}

template <typename Domain>
typed::set<Domain> typed::aff<Domain, Anonymous>::lt_set(const typed::pw_aff<Domain, Anonymous> &pwaff2) const
{
  auto res = isl::aff::lt_set(pwaff2);
  return typed::set<Domain>(res);
}

template <typename Domain>
typed::multi_pw_aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::max(const typed::multi_pw_aff<Domain, Anonymous> &multi2) const
{
  auto res = isl::aff::max(multi2);
  return typed::multi_pw_aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::pw_aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::max(const typed::pw_aff<Domain, Anonymous> &pwaff2) const
{
  auto res = isl::aff::max(pwaff2);
  return typed::pw_aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::multi_val<Anonymous> typed::aff<Domain, Anonymous>::max_multi_val() const
{
  auto res = isl::aff::max_multi_val();
  return typed::multi_val<Anonymous>(res);
}

template <typename Domain>
typed::val<Anonymous> typed::aff<Domain, Anonymous>::max_val() const
{
  auto res = isl::aff::max_val();
  return typed::val<Anonymous>(res);
}

template <typename Domain>
typed::multi_pw_aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::min(const typed::multi_pw_aff<Domain, Anonymous> &multi2) const
{
  auto res = isl::aff::min(multi2);
  return typed::multi_pw_aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::pw_aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::min(const typed::pw_aff<Domain, Anonymous> &pwaff2) const
{
  auto res = isl::aff::min(pwaff2);
  return typed::pw_aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::multi_val<Anonymous> typed::aff<Domain, Anonymous>::min_multi_val() const
{
  auto res = isl::aff::min_multi_val();
  return typed::multi_val<Anonymous>(res);
}

template <typename Domain>
typed::val<Anonymous> typed::aff<Domain, Anonymous>::min_val() const
{
  auto res = isl::aff::min_val();
  return typed::val<Anonymous>(res);
}

template <typename Domain>
typed::aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::mod(const typed::val<Anonymous> &mod) const
{
  auto res = isl::aff::mod(mod);
  return typed::aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::mod(long mod) const
{
  auto res = isl::aff::mod(mod);
  return typed::aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::neg() const
{
  auto res = isl::aff::neg();
  return typed::aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::set<> typed::aff<Domain, Anonymous>::params() const
{
  auto res = isl::aff::params();
  return typed::set<>(res);
}

template <typename Domain>
template <typename Domain2, typename Range2>
typed::multi_aff<pair<Domain, Domain2>, pair<Anonymous, Range2>> typed::aff<Domain, Anonymous>::product(const typed::multi_aff<Domain2, Range2> &multi2) const
{
  auto res = isl::aff::product(multi2);
  return typed::multi_aff<pair<Domain, Domain2>, pair<Anonymous, Range2>>(res);
}

template <typename Domain>
template <typename Domain2, typename Range2>
typed::multi_pw_aff<pair<Domain, Domain2>, pair<Anonymous, Range2>> typed::aff<Domain, Anonymous>::product(const typed::multi_pw_aff<Domain2, Range2> &multi2) const
{
  auto res = isl::aff::product(multi2);
  return typed::multi_pw_aff<pair<Domain, Domain2>, pair<Anonymous, Range2>>(res);
}

template <typename Domain>
template <typename Domain2, typename Range2>
typed::pw_multi_aff<pair<Domain, Domain2>, pair<Anonymous, Range2>> typed::aff<Domain, Anonymous>::product(const typed::pw_multi_aff<Domain2, Range2> &pma2) const
{
  auto res = isl::aff::product(pma2);
  return typed::pw_multi_aff<pair<Domain, Domain2>, pair<Anonymous, Range2>>(res);
}

template <typename Domain>
template <typename Domain2>
typed::aff<Domain2, Anonymous> typed::aff<Domain, Anonymous>::pullback(const typed::multi_aff<Domain2, Domain> &ma) const
{
  auto res = isl::aff::pullback(ma);
  return typed::aff<Domain2, Anonymous>(res);
}

template <typename Domain>
typed::aff<Anonymous> typed::aff<Domain, Anonymous>::pullback(const typed::multi_aff<Domain> &ma) const
{
  auto res = isl::aff::pullback(ma);
  return typed::aff<Anonymous>(res);
}

template <typename Domain>
template <typename Domain2>
typed::pw_aff<Domain2, Anonymous> typed::aff<Domain, Anonymous>::pullback(const typed::multi_pw_aff<Domain2, Domain> &mpa) const
{
  auto res = isl::aff::pullback(mpa);
  return typed::pw_aff<Domain2, Anonymous>(res);
}

template <typename Domain>
typed::pw_aff<Anonymous> typed::aff<Domain, Anonymous>::pullback(const typed::multi_pw_aff<Domain> &mpa) const
{
  auto res = isl::aff::pullback(mpa);
  return typed::pw_aff<Anonymous>(res);
}

template <typename Domain>
template <typename Domain2>
typed::pw_aff<Domain2, Anonymous> typed::aff<Domain, Anonymous>::pullback(const typed::pw_multi_aff<Domain2, Domain> &pma) const
{
  auto res = isl::aff::pullback(pma);
  return typed::pw_aff<Domain2, Anonymous>(res);
}

template <typename Domain>
typed::pw_aff<Anonymous> typed::aff<Domain, Anonymous>::pullback(const typed::pw_multi_aff<Domain> &pma) const
{
  auto res = isl::aff::pullback(pma);
  return typed::pw_aff<Anonymous>(res);
}

template <typename Domain>
template <typename Domain2>
typed::union_pw_aff<Domain2, Anonymous> typed::aff<Domain, Anonymous>::pullback(const typed::union_pw_multi_aff<Domain2, Domain> &upma) const
{
  auto res = isl::aff::pullback(upma);
  return typed::union_pw_aff<Domain2, Anonymous>(res);
}

template <typename Domain>
typed::union_pw_aff<Anonymous> typed::aff<Domain, Anonymous>::pullback(const typed::union_pw_multi_aff<Domain> &upma) const
{
  auto res = isl::aff::pullback(upma);
  return typed::union_pw_aff<Anonymous>(res);
}

template <typename Domain>
template <typename Domain2>
typed::aff<Domain2, Anonymous> typed::aff<Domain, Anonymous>::pullback(const typed::aff<Domain2, Domain> &ma) const
{
  auto res = isl::aff::pullback(ma);
  return typed::aff<Domain2, Anonymous>(res);
}

template <typename Domain>
typed::aff<Anonymous> typed::aff<Domain, Anonymous>::pullback(const typed::aff<Domain> &ma) const
{
  auto res = isl::aff::pullback(ma);
  return typed::aff<Anonymous>(res);
}

template <typename Domain>
typed::pw_multi_aff_list<Domain, Anonymous> typed::aff<Domain, Anonymous>::pw_multi_aff_list() const
{
  auto res = isl::aff::pw_multi_aff_list();
  return typed::pw_multi_aff_list<Domain, Anonymous>(res);
}

template <typename Domain>
template <typename Range2>
typed::multi_aff<Domain, pair<Anonymous, Range2>> typed::aff<Domain, Anonymous>::range_product(const typed::multi_aff<Domain, Range2> &multi2) const
{
  auto res = isl::aff::range_product(multi2);
  return typed::multi_aff<Domain, pair<Anonymous, Range2>>(res);
}

template <typename Domain>
template <typename Range2>
typed::multi_pw_aff<Domain, pair<Anonymous, Range2>> typed::aff<Domain, Anonymous>::range_product(const typed::multi_pw_aff<Domain, Range2> &multi2) const
{
  auto res = isl::aff::range_product(multi2);
  return typed::multi_pw_aff<Domain, pair<Anonymous, Range2>>(res);
}

template <typename Domain>
template <typename Range2>
typed::multi_union_pw_aff<Domain, pair<Anonymous, Range2>> typed::aff<Domain, Anonymous>::range_product(const typed::multi_union_pw_aff<Domain, Range2> &multi2) const
{
  auto res = isl::aff::range_product(multi2);
  return typed::multi_union_pw_aff<Domain, pair<Anonymous, Range2>>(res);
}

template <typename Domain>
template <typename Range2>
typed::pw_multi_aff<Domain, pair<Anonymous, Range2>> typed::aff<Domain, Anonymous>::range_product(const typed::pw_multi_aff<Domain, Range2> &pma2) const
{
  auto res = isl::aff::range_product(pma2);
  return typed::pw_multi_aff<Domain, pair<Anonymous, Range2>>(res);
}

template <typename Domain>
template <typename Range2>
typed::union_pw_multi_aff<Domain, pair<Anonymous, Range2>> typed::aff<Domain, Anonymous>::range_product(const typed::union_pw_multi_aff<Domain, Range2> &upma2) const
{
  auto res = isl::aff::range_product(upma2);
  return typed::union_pw_multi_aff<Domain, pair<Anonymous, Range2>>(res);
}

template <typename Domain>
typed::aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::scale(const typed::val<Anonymous> &v) const
{
  auto res = isl::aff::scale(v);
  return typed::aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::scale(long v) const
{
  auto res = isl::aff::scale(v);
  return typed::aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::multi_aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::scale(const typed::multi_val<Anonymous> &mv) const
{
  auto res = isl::aff::scale(mv);
  return typed::multi_aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::scale_down(const typed::val<Anonymous> &v) const
{
  auto res = isl::aff::scale_down(v);
  return typed::aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::scale_down(long v) const
{
  auto res = isl::aff::scale_down(v);
  return typed::aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::multi_aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::scale_down(const typed::multi_val<Anonymous> &mv) const
{
  auto res = isl::aff::scale_down(mv);
  return typed::multi_aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::multi_aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::set_at(int pos, const typed::aff<Domain, Anonymous> &el) const
{
  auto res = isl::aff::set_at(pos, el);
  return typed::multi_aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::multi_pw_aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::set_at(int pos, const typed::pw_aff<Domain, Anonymous> &el) const
{
  auto res = isl::aff::set_at(pos, el);
  return typed::multi_pw_aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::multi_union_pw_aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::set_at(int pos, const typed::union_pw_aff<Domain, Anonymous> &el) const
{
  auto res = isl::aff::set_at(pos, el);
  return typed::multi_union_pw_aff<Domain, Anonymous>(res);
}

template <typename Domain>
template <typename Range2>
typed::multi_aff<Domain, Range2> typed::aff<Domain, Anonymous>::set_range_tuple(const typed::id<Anonymous> &id) const
{
  auto res = isl::aff::set_range_tuple(id);
  return typed::multi_aff<Domain, Range2>(res);
}

template <typename Domain>
template <typename Range2>
typed::multi_aff<Domain, Range2> typed::aff<Domain, Anonymous>::set_range_tuple(const std::string &id) const
{
  auto res = isl::aff::set_range_tuple(id);
  return typed::multi_aff<Domain, Range2>(res);
}

template <typename Domain>
typed::space<Domain, Anonymous> typed::aff<Domain, Anonymous>::space() const
{
  auto res = isl::aff::space();
  return typed::space<Domain, Anonymous>(res);
}

template <typename Domain>
typed::aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::sub(const typed::aff<Domain, Anonymous> &aff2) const
{
  auto res = isl::aff::sub(aff2);
  return typed::aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::multi_aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::sub(const typed::multi_aff<Domain, Anonymous> &multi2) const
{
  auto res = isl::aff::sub(multi2);
  return typed::multi_aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::multi_pw_aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::sub(const typed::multi_pw_aff<Domain, Anonymous> &multi2) const
{
  auto res = isl::aff::sub(multi2);
  return typed::multi_pw_aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::multi_union_pw_aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::sub(const typed::multi_union_pw_aff<Domain, Anonymous> &multi2) const
{
  auto res = isl::aff::sub(multi2);
  return typed::multi_union_pw_aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::pw_aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::sub(const typed::pw_aff<Domain, Anonymous> &pwaff2) const
{
  auto res = isl::aff::sub(pwaff2);
  return typed::pw_aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::pw_multi_aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::sub(const typed::pw_multi_aff<Domain, Anonymous> &pma2) const
{
  auto res = isl::aff::sub(pma2);
  return typed::pw_multi_aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::union_pw_aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::sub(const typed::union_pw_aff<Domain, Anonymous> &upa2) const
{
  auto res = isl::aff::sub(upa2);
  return typed::union_pw_aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::union_pw_multi_aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::sub(const typed::union_pw_multi_aff<Domain, Anonymous> &upma2) const
{
  auto res = isl::aff::sub(upma2);
  return typed::union_pw_multi_aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::pw_aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::subtract_domain(const typed::set<Domain> &set) const
{
  auto res = isl::aff::subtract_domain(set);
  return typed::pw_aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::union_pw_aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::subtract_domain(const typed::space<Domain> &space) const
{
  auto res = isl::aff::subtract_domain(space);
  return typed::union_pw_aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::union_pw_aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::subtract_domain(const typed::union_set<Domain> &uset) const
{
  auto res = isl::aff::subtract_domain(uset);
  return typed::union_pw_aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::multi_pw_aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::to_multi_pw_aff() const
{
  auto res = isl::aff::to_multi_pw_aff();
  return typed::multi_pw_aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::multi_union_pw_aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::to_multi_union_pw_aff() const
{
  auto res = isl::aff::to_multi_union_pw_aff();
  return typed::multi_union_pw_aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::pw_multi_aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::to_pw_multi_aff() const
{
  auto res = isl::aff::to_pw_multi_aff();
  return typed::pw_multi_aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::union_pw_aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::to_union_pw_aff() const
{
  auto res = isl::aff::to_union_pw_aff();
  return typed::union_pw_aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::union_pw_multi_aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::to_union_pw_multi_aff() const
{
  auto res = isl::aff::to_union_pw_multi_aff();
  return typed::union_pw_multi_aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::multi_pw_aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::union_add(const typed::multi_pw_aff<Domain, Anonymous> &mpa2) const
{
  auto res = isl::aff::union_add(mpa2);
  return typed::multi_pw_aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::multi_union_pw_aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::union_add(const typed::multi_union_pw_aff<Domain, Anonymous> &mupa2) const
{
  auto res = isl::aff::union_add(mupa2);
  return typed::multi_union_pw_aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::pw_aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::union_add(const typed::pw_aff<Domain, Anonymous> &pwaff2) const
{
  auto res = isl::aff::union_add(pwaff2);
  return typed::pw_aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::pw_multi_aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::union_add(const typed::pw_multi_aff<Domain, Anonymous> &pma2) const
{
  auto res = isl::aff::union_add(pma2);
  return typed::pw_multi_aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::union_pw_aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::union_add(const typed::union_pw_aff<Domain, Anonymous> &upa2) const
{
  auto res = isl::aff::union_add(upa2);
  return typed::union_pw_aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::union_pw_multi_aff<Domain, Anonymous> typed::aff<Domain, Anonymous>::union_add(const typed::union_pw_multi_aff<Domain, Anonymous> &upma2) const
{
  auto res = isl::aff::union_add(upma2);
  return typed::union_pw_multi_aff<Domain, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::aff<pair<Domain2, Range2>, Anonymous>::aff(const isl::ctx &ctx, const std::string &str)
  : isl::aff(ctx, str)
{
}

template <typename Domain2, typename Range2>
typed::aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::add(const typed::aff<pair<Domain2, Range2>, Anonymous> &aff2) const
{
  auto res = isl::aff::add(aff2);
  return typed::aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::multi_aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::add(const typed::multi_aff<pair<Domain2, Range2>, Anonymous> &multi2) const
{
  auto res = isl::aff::add(multi2);
  return typed::multi_aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::multi_pw_aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::add(const typed::multi_pw_aff<pair<Domain2, Range2>, Anonymous> &multi2) const
{
  auto res = isl::aff::add(multi2);
  return typed::multi_pw_aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::multi_union_pw_aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::add(const typed::multi_union_pw_aff<pair<Domain2, Range2>, Anonymous> &multi2) const
{
  auto res = isl::aff::add(multi2);
  return typed::multi_union_pw_aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::pw_aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::add(const typed::pw_aff<pair<Domain2, Range2>, Anonymous> &pwaff2) const
{
  auto res = isl::aff::add(pwaff2);
  return typed::pw_aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::pw_multi_aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::add(const typed::pw_multi_aff<pair<Domain2, Range2>, Anonymous> &pma2) const
{
  auto res = isl::aff::add(pma2);
  return typed::pw_multi_aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::union_pw_aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::add(const typed::union_pw_aff<pair<Domain2, Range2>, Anonymous> &upa2) const
{
  auto res = isl::aff::add(upa2);
  return typed::union_pw_aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::union_pw_multi_aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::add(const typed::union_pw_multi_aff<pair<Domain2, Range2>, Anonymous> &upma2) const
{
  auto res = isl::aff::add(upma2);
  return typed::union_pw_multi_aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::add_constant(const typed::val<Anonymous> &v) const
{
  auto res = isl::aff::add_constant(v);
  return typed::aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::add_constant(long v) const
{
  auto res = isl::aff::add_constant(v);
  return typed::aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::multi_aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::add_constant(const typed::multi_val<Anonymous> &mv) const
{
  auto res = isl::aff::add_constant(mv);
  return typed::multi_aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
template <typename Arg1>
typed::union_pw_multi_aff<pair<Domain2, Range2>, Arg1> typed::aff<pair<Domain2, Range2>, Anonymous>::apply(const typed::union_pw_multi_aff<Anonymous, Arg1> &upma2) const
{
  auto res = isl::aff::apply(upma2);
  return typed::union_pw_multi_aff<pair<Domain2, Range2>, Arg1>(res);
}

template <typename Domain2, typename Range2>
typed::aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::as_aff() const
{
  auto res = isl::aff::as_aff();
  return typed::aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::map<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::as_map() const
{
  auto res = isl::aff::as_map();
  return typed::map<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::multi_aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::as_multi_aff() const
{
  auto res = isl::aff::as_multi_aff();
  return typed::multi_aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::multi_union_pw_aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::as_multi_union_pw_aff() const
{
  auto res = isl::aff::as_multi_union_pw_aff();
  return typed::multi_union_pw_aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::pw_multi_aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::as_pw_multi_aff() const
{
  auto res = isl::aff::as_pw_multi_aff();
  return typed::pw_multi_aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::union_map<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::as_union_map() const
{
  auto res = isl::aff::as_union_map();
  return typed::union_map<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::at(int pos) const
{
  auto res = isl::aff::at(pos);
  return typed::aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::basic_set<pair<Domain2, Range2>> typed::aff<pair<Domain2, Range2>, Anonymous>::bind(const typed::id<Anonymous> &id) const
{
  auto res = isl::aff::bind(id);
  return typed::basic_set<pair<Domain2, Range2>>(res);
}

template <typename Domain2, typename Range2>
typed::basic_set<pair<Domain2, Range2>> typed::aff<pair<Domain2, Range2>, Anonymous>::bind(const std::string &id) const
{
  auto res = isl::aff::bind(id);
  return typed::basic_set<pair<Domain2, Range2>>(res);
}

template <typename Domain2, typename Range2>
typed::basic_set<pair<Domain2, Range2>> typed::aff<pair<Domain2, Range2>, Anonymous>::bind(const typed::multi_id<Anonymous> &tuple) const
{
  auto res = isl::aff::bind(tuple);
  return typed::basic_set<pair<Domain2, Range2>>(res);
}

template <typename Domain2, typename Range2>
typed::pw_aff<Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::bind_domain(const typed::multi_id<pair<Domain2, Range2>> &tuple) const
{
  auto res = isl::aff::bind_domain(tuple);
  return typed::pw_aff<Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::pw_aff<Range2, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::bind_domain_wrapped_domain(const typed::multi_id<Domain2> &tuple) const
{
  auto res = isl::aff::bind_domain_wrapped_domain(tuple);
  return typed::pw_aff<Range2, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::ceil() const
{
  auto res = isl::aff::ceil();
  return typed::aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::pw_aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::coalesce() const
{
  auto res = isl::aff::coalesce();
  return typed::pw_aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::pw_aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::cond(const typed::pw_aff<pair<Domain2, Range2>, Anonymous> &pwaff_true, const typed::pw_aff<pair<Domain2, Range2>, Anonymous> &pwaff_false) const
{
  auto res = isl::aff::cond(pwaff_true, pwaff_false);
  return typed::pw_aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::multi_val<Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::constant_multi_val() const
{
  auto res = isl::aff::constant_multi_val();
  return typed::multi_val<Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::val<Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::constant_val() const
{
  auto res = isl::aff::constant_val();
  return typed::val<Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::set<pair<Domain2, Range2>> typed::aff<pair<Domain2, Range2>, Anonymous>::domain() const
{
  auto res = isl::aff::domain();
  return typed::set<pair<Domain2, Range2>>(res);
}

template <typename Domain2, typename Range2>
typed::aff<pair<Range2, Domain2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::domain_reverse() const
{
  auto res = isl::aff::domain_reverse();
  return typed::aff<pair<Range2, Domain2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::pw_aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::drop_unused_params() const
{
  auto res = isl::aff::drop_unused_params();
  return typed::pw_aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::pw_multi_aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::extract_pw_multi_aff(const typed::space<pair<Domain2, Range2>, Anonymous> &space) const
{
  auto res = isl::aff::extract_pw_multi_aff(space);
  return typed::pw_multi_aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::floor() const
{
  auto res = isl::aff::floor();
  return typed::aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::set<pair<Domain2, Range2>> typed::aff<pair<Domain2, Range2>, Anonymous>::ge_set(const typed::aff<pair<Domain2, Range2>, Anonymous> &aff2) const
{
  auto res = isl::aff::ge_set(aff2);
  return typed::set<pair<Domain2, Range2>>(res);
}

template <typename Domain2, typename Range2>
typed::set<pair<Domain2, Range2>> typed::aff<pair<Domain2, Range2>, Anonymous>::ge_set(const typed::pw_aff<pair<Domain2, Range2>, Anonymous> &pwaff2) const
{
  auto res = isl::aff::ge_set(pwaff2);
  return typed::set<pair<Domain2, Range2>>(res);
}

template <typename Domain2, typename Range2>
typed::aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::gist(const typed::set<pair<Domain2, Range2>> &context) const
{
  auto res = isl::aff::gist(context);
  return typed::aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::union_pw_aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::gist(const typed::union_set<pair<Domain2, Range2>> &context) const
{
  auto res = isl::aff::gist(context);
  return typed::union_pw_aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::gist(const typed::basic_set<pair<Domain2, Range2>> &context) const
{
  auto res = isl::aff::gist(context);
  return typed::aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::gist(const typed::point<pair<Domain2, Range2>> &context) const
{
  auto res = isl::aff::gist(context);
  return typed::aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::gist_params(const typed::set<> &context) const
{
  auto res = isl::aff::gist_params(context);
  return typed::aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::gist_params(const typed::basic_set<> &context) const
{
  auto res = isl::aff::gist_params(context);
  return typed::aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::gist_params(const typed::point<> &context) const
{
  auto res = isl::aff::gist_params(context);
  return typed::aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::set<pair<Domain2, Range2>> typed::aff<pair<Domain2, Range2>, Anonymous>::gt_set(const typed::aff<pair<Domain2, Range2>, Anonymous> &aff2) const
{
  auto res = isl::aff::gt_set(aff2);
  return typed::set<pair<Domain2, Range2>>(res);
}

template <typename Domain2, typename Range2>
typed::set<pair<Domain2, Range2>> typed::aff<pair<Domain2, Range2>, Anonymous>::gt_set(const typed::pw_aff<pair<Domain2, Range2>, Anonymous> &pwaff2) const
{
  auto res = isl::aff::gt_set(pwaff2);
  return typed::set<pair<Domain2, Range2>>(res);
}

template <typename Domain2, typename Range2>
typed::multi_aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::identity() const
{
  auto res = isl::aff::identity();
  return typed::multi_aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::pw_aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::intersect_domain(const typed::set<pair<Domain2, Range2>> &set) const
{
  auto res = isl::aff::intersect_domain(set);
  return typed::pw_aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::union_pw_aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::intersect_domain(const typed::space<pair<Domain2, Range2>> &space) const
{
  auto res = isl::aff::intersect_domain(space);
  return typed::union_pw_aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::union_pw_aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::intersect_domain(const typed::union_set<pair<Domain2, Range2>> &uset) const
{
  auto res = isl::aff::intersect_domain(uset);
  return typed::union_pw_aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::union_pw_aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::intersect_domain_wrapped_domain(const typed::union_set<Domain2> &uset) const
{
  auto res = isl::aff::intersect_domain_wrapped_domain(uset);
  return typed::union_pw_aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::pw_aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::intersect_params(const typed::set<> &set) const
{
  auto res = isl::aff::intersect_params(set);
  return typed::pw_aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::set<pair<Domain2, Range2>> typed::aff<pair<Domain2, Range2>, Anonymous>::le_set(const typed::aff<pair<Domain2, Range2>, Anonymous> &aff2) const
{
  auto res = isl::aff::le_set(aff2);
  return typed::set<pair<Domain2, Range2>>(res);
}

template <typename Domain2, typename Range2>
typed::set<pair<Domain2, Range2>> typed::aff<pair<Domain2, Range2>, Anonymous>::le_set(const typed::pw_aff<pair<Domain2, Range2>, Anonymous> &pwaff2) const
{
  auto res = isl::aff::le_set(pwaff2);
  return typed::set<pair<Domain2, Range2>>(res);
}

template <typename Domain2, typename Range2>
typed::aff_list<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::list() const
{
  auto res = isl::aff::list();
  return typed::aff_list<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::set<pair<Domain2, Range2>> typed::aff<pair<Domain2, Range2>, Anonymous>::lt_set(const typed::aff<pair<Domain2, Range2>, Anonymous> &aff2) const
{
  auto res = isl::aff::lt_set(aff2);
  return typed::set<pair<Domain2, Range2>>(res);
}

template <typename Domain2, typename Range2>
typed::set<pair<Domain2, Range2>> typed::aff<pair<Domain2, Range2>, Anonymous>::lt_set(const typed::pw_aff<pair<Domain2, Range2>, Anonymous> &pwaff2) const
{
  auto res = isl::aff::lt_set(pwaff2);
  return typed::set<pair<Domain2, Range2>>(res);
}

template <typename Domain2, typename Range2>
typed::multi_pw_aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::max(const typed::multi_pw_aff<pair<Domain2, Range2>, Anonymous> &multi2) const
{
  auto res = isl::aff::max(multi2);
  return typed::multi_pw_aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::pw_aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::max(const typed::pw_aff<pair<Domain2, Range2>, Anonymous> &pwaff2) const
{
  auto res = isl::aff::max(pwaff2);
  return typed::pw_aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::multi_val<Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::max_multi_val() const
{
  auto res = isl::aff::max_multi_val();
  return typed::multi_val<Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::val<Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::max_val() const
{
  auto res = isl::aff::max_val();
  return typed::val<Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::multi_pw_aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::min(const typed::multi_pw_aff<pair<Domain2, Range2>, Anonymous> &multi2) const
{
  auto res = isl::aff::min(multi2);
  return typed::multi_pw_aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::pw_aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::min(const typed::pw_aff<pair<Domain2, Range2>, Anonymous> &pwaff2) const
{
  auto res = isl::aff::min(pwaff2);
  return typed::pw_aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::multi_val<Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::min_multi_val() const
{
  auto res = isl::aff::min_multi_val();
  return typed::multi_val<Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::val<Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::min_val() const
{
  auto res = isl::aff::min_val();
  return typed::val<Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::mod(const typed::val<Anonymous> &mod) const
{
  auto res = isl::aff::mod(mod);
  return typed::aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::mod(long mod) const
{
  auto res = isl::aff::mod(mod);
  return typed::aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::neg() const
{
  auto res = isl::aff::neg();
  return typed::aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::set<> typed::aff<pair<Domain2, Range2>, Anonymous>::params() const
{
  auto res = isl::aff::params();
  return typed::set<>(res);
}

template <typename Domain2, typename Range2>
template <typename Domain3>
typed::pw_multi_aff<pair<Domain3, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::preimage_domain_wrapped_domain(const typed::pw_multi_aff<Domain3, Domain2> &pma2) const
{
  auto res = isl::aff::preimage_domain_wrapped_domain(pma2);
  return typed::pw_multi_aff<pair<Domain3, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
template <typename Domain3>
typed::union_pw_multi_aff<pair<Domain3, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::preimage_domain_wrapped_domain(const typed::union_pw_multi_aff<Domain3, Domain2> &upma2) const
{
  auto res = isl::aff::preimage_domain_wrapped_domain(upma2);
  return typed::union_pw_multi_aff<pair<Domain3, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
template <typename Arg1, typename Arg2>
typed::multi_aff<pair<pair<Domain2, Range2>, Arg1>, pair<Anonymous, Arg2>> typed::aff<pair<Domain2, Range2>, Anonymous>::product(const typed::multi_aff<Arg1, Arg2> &multi2) const
{
  auto res = isl::aff::product(multi2);
  return typed::multi_aff<pair<pair<Domain2, Range2>, Arg1>, pair<Anonymous, Arg2>>(res);
}

template <typename Domain2, typename Range2>
template <typename Arg1, typename Arg2>
typed::multi_pw_aff<pair<pair<Domain2, Range2>, Arg1>, pair<Anonymous, Arg2>> typed::aff<pair<Domain2, Range2>, Anonymous>::product(const typed::multi_pw_aff<Arg1, Arg2> &multi2) const
{
  auto res = isl::aff::product(multi2);
  return typed::multi_pw_aff<pair<pair<Domain2, Range2>, Arg1>, pair<Anonymous, Arg2>>(res);
}

template <typename Domain2, typename Range2>
template <typename Arg1, typename Arg2>
typed::pw_multi_aff<pair<pair<Domain2, Range2>, Arg1>, pair<Anonymous, Arg2>> typed::aff<pair<Domain2, Range2>, Anonymous>::product(const typed::pw_multi_aff<Arg1, Arg2> &pma2) const
{
  auto res = isl::aff::product(pma2);
  return typed::pw_multi_aff<pair<pair<Domain2, Range2>, Arg1>, pair<Anonymous, Arg2>>(res);
}

template <typename Domain2, typename Range2>
template <typename Arg1>
typed::aff<Arg1, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::pullback(const typed::multi_aff<Arg1, pair<Domain2, Range2>> &ma) const
{
  auto res = isl::aff::pullback(ma);
  return typed::aff<Arg1, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::aff<Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::pullback(const typed::multi_aff<pair<Domain2, Range2>> &ma) const
{
  auto res = isl::aff::pullback(ma);
  return typed::aff<Anonymous>(res);
}

template <typename Domain2, typename Range2>
template <typename Arg1>
typed::pw_aff<Arg1, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::pullback(const typed::multi_pw_aff<Arg1, pair<Domain2, Range2>> &mpa) const
{
  auto res = isl::aff::pullback(mpa);
  return typed::pw_aff<Arg1, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::pw_aff<Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::pullback(const typed::multi_pw_aff<pair<Domain2, Range2>> &mpa) const
{
  auto res = isl::aff::pullback(mpa);
  return typed::pw_aff<Anonymous>(res);
}

template <typename Domain2, typename Range2>
template <typename Arg1>
typed::pw_aff<Arg1, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::pullback(const typed::pw_multi_aff<Arg1, pair<Domain2, Range2>> &pma) const
{
  auto res = isl::aff::pullback(pma);
  return typed::pw_aff<Arg1, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::pw_aff<Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::pullback(const typed::pw_multi_aff<pair<Domain2, Range2>> &pma) const
{
  auto res = isl::aff::pullback(pma);
  return typed::pw_aff<Anonymous>(res);
}

template <typename Domain2, typename Range2>
template <typename Arg1>
typed::union_pw_aff<Arg1, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::pullback(const typed::union_pw_multi_aff<Arg1, pair<Domain2, Range2>> &upma) const
{
  auto res = isl::aff::pullback(upma);
  return typed::union_pw_aff<Arg1, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::union_pw_aff<Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::pullback(const typed::union_pw_multi_aff<pair<Domain2, Range2>> &upma) const
{
  auto res = isl::aff::pullback(upma);
  return typed::union_pw_aff<Anonymous>(res);
}

template <typename Domain2, typename Range2>
template <typename Arg1>
typed::aff<Arg1, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::pullback(const typed::aff<Arg1, pair<Domain2, Range2>> &ma) const
{
  auto res = isl::aff::pullback(ma);
  return typed::aff<Arg1, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::aff<Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::pullback(const typed::aff<pair<Domain2, Range2>> &ma) const
{
  auto res = isl::aff::pullback(ma);
  return typed::aff<Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::pw_multi_aff_list<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::pw_multi_aff_list() const
{
  auto res = isl::aff::pw_multi_aff_list();
  return typed::pw_multi_aff_list<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
template <typename Arg1>
typed::multi_aff<pair<Domain2, Range2>, pair<Anonymous, Arg1>> typed::aff<pair<Domain2, Range2>, Anonymous>::range_product(const typed::multi_aff<pair<Domain2, Range2>, Arg1> &multi2) const
{
  auto res = isl::aff::range_product(multi2);
  return typed::multi_aff<pair<Domain2, Range2>, pair<Anonymous, Arg1>>(res);
}

template <typename Domain2, typename Range2>
template <typename Arg1>
typed::multi_pw_aff<pair<Domain2, Range2>, pair<Anonymous, Arg1>> typed::aff<pair<Domain2, Range2>, Anonymous>::range_product(const typed::multi_pw_aff<pair<Domain2, Range2>, Arg1> &multi2) const
{
  auto res = isl::aff::range_product(multi2);
  return typed::multi_pw_aff<pair<Domain2, Range2>, pair<Anonymous, Arg1>>(res);
}

template <typename Domain2, typename Range2>
template <typename Arg1>
typed::multi_union_pw_aff<pair<Domain2, Range2>, pair<Anonymous, Arg1>> typed::aff<pair<Domain2, Range2>, Anonymous>::range_product(const typed::multi_union_pw_aff<pair<Domain2, Range2>, Arg1> &multi2) const
{
  auto res = isl::aff::range_product(multi2);
  return typed::multi_union_pw_aff<pair<Domain2, Range2>, pair<Anonymous, Arg1>>(res);
}

template <typename Domain2, typename Range2>
template <typename Arg1>
typed::pw_multi_aff<pair<Domain2, Range2>, pair<Anonymous, Arg1>> typed::aff<pair<Domain2, Range2>, Anonymous>::range_product(const typed::pw_multi_aff<pair<Domain2, Range2>, Arg1> &pma2) const
{
  auto res = isl::aff::range_product(pma2);
  return typed::pw_multi_aff<pair<Domain2, Range2>, pair<Anonymous, Arg1>>(res);
}

template <typename Domain2, typename Range2>
template <typename Arg1>
typed::union_pw_multi_aff<pair<Domain2, Range2>, pair<Anonymous, Arg1>> typed::aff<pair<Domain2, Range2>, Anonymous>::range_product(const typed::union_pw_multi_aff<pair<Domain2, Range2>, Arg1> &upma2) const
{
  auto res = isl::aff::range_product(upma2);
  return typed::union_pw_multi_aff<pair<Domain2, Range2>, pair<Anonymous, Arg1>>(res);
}

template <typename Domain2, typename Range2>
typed::aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::scale(const typed::val<Anonymous> &v) const
{
  auto res = isl::aff::scale(v);
  return typed::aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::scale(long v) const
{
  auto res = isl::aff::scale(v);
  return typed::aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::multi_aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::scale(const typed::multi_val<Anonymous> &mv) const
{
  auto res = isl::aff::scale(mv);
  return typed::multi_aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::scale_down(const typed::val<Anonymous> &v) const
{
  auto res = isl::aff::scale_down(v);
  return typed::aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::scale_down(long v) const
{
  auto res = isl::aff::scale_down(v);
  return typed::aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::multi_aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::scale_down(const typed::multi_val<Anonymous> &mv) const
{
  auto res = isl::aff::scale_down(mv);
  return typed::multi_aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::multi_aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::set_at(int pos, const typed::aff<pair<Domain2, Range2>, Anonymous> &el) const
{
  auto res = isl::aff::set_at(pos, el);
  return typed::multi_aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::multi_pw_aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::set_at(int pos, const typed::pw_aff<pair<Domain2, Range2>, Anonymous> &el) const
{
  auto res = isl::aff::set_at(pos, el);
  return typed::multi_pw_aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::multi_union_pw_aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::set_at(int pos, const typed::union_pw_aff<pair<Domain2, Range2>, Anonymous> &el) const
{
  auto res = isl::aff::set_at(pos, el);
  return typed::multi_union_pw_aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
template <typename Arg1>
typed::multi_aff<pair<Domain2, Range2>, Arg1> typed::aff<pair<Domain2, Range2>, Anonymous>::set_range_tuple(const typed::id<Anonymous> &id) const
{
  auto res = isl::aff::set_range_tuple(id);
  return typed::multi_aff<pair<Domain2, Range2>, Arg1>(res);
}

template <typename Domain2, typename Range2>
template <typename Arg1>
typed::multi_aff<pair<Domain2, Range2>, Arg1> typed::aff<pair<Domain2, Range2>, Anonymous>::set_range_tuple(const std::string &id) const
{
  auto res = isl::aff::set_range_tuple(id);
  return typed::multi_aff<pair<Domain2, Range2>, Arg1>(res);
}

template <typename Domain2, typename Range2>
typed::space<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::space() const
{
  auto res = isl::aff::space();
  return typed::space<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::sub(const typed::aff<pair<Domain2, Range2>, Anonymous> &aff2) const
{
  auto res = isl::aff::sub(aff2);
  return typed::aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::multi_aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::sub(const typed::multi_aff<pair<Domain2, Range2>, Anonymous> &multi2) const
{
  auto res = isl::aff::sub(multi2);
  return typed::multi_aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::multi_pw_aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::sub(const typed::multi_pw_aff<pair<Domain2, Range2>, Anonymous> &multi2) const
{
  auto res = isl::aff::sub(multi2);
  return typed::multi_pw_aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::multi_union_pw_aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::sub(const typed::multi_union_pw_aff<pair<Domain2, Range2>, Anonymous> &multi2) const
{
  auto res = isl::aff::sub(multi2);
  return typed::multi_union_pw_aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::pw_aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::sub(const typed::pw_aff<pair<Domain2, Range2>, Anonymous> &pwaff2) const
{
  auto res = isl::aff::sub(pwaff2);
  return typed::pw_aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::pw_multi_aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::sub(const typed::pw_multi_aff<pair<Domain2, Range2>, Anonymous> &pma2) const
{
  auto res = isl::aff::sub(pma2);
  return typed::pw_multi_aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::union_pw_aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::sub(const typed::union_pw_aff<pair<Domain2, Range2>, Anonymous> &upa2) const
{
  auto res = isl::aff::sub(upa2);
  return typed::union_pw_aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::union_pw_multi_aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::sub(const typed::union_pw_multi_aff<pair<Domain2, Range2>, Anonymous> &upma2) const
{
  auto res = isl::aff::sub(upma2);
  return typed::union_pw_multi_aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::pw_aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::subtract_domain(const typed::set<pair<Domain2, Range2>> &set) const
{
  auto res = isl::aff::subtract_domain(set);
  return typed::pw_aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::union_pw_aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::subtract_domain(const typed::space<pair<Domain2, Range2>> &space) const
{
  auto res = isl::aff::subtract_domain(space);
  return typed::union_pw_aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::union_pw_aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::subtract_domain(const typed::union_set<pair<Domain2, Range2>> &uset) const
{
  auto res = isl::aff::subtract_domain(uset);
  return typed::union_pw_aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::multi_pw_aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::to_multi_pw_aff() const
{
  auto res = isl::aff::to_multi_pw_aff();
  return typed::multi_pw_aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::multi_union_pw_aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::to_multi_union_pw_aff() const
{
  auto res = isl::aff::to_multi_union_pw_aff();
  return typed::multi_union_pw_aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::pw_multi_aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::to_pw_multi_aff() const
{
  auto res = isl::aff::to_pw_multi_aff();
  return typed::pw_multi_aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::union_pw_aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::to_union_pw_aff() const
{
  auto res = isl::aff::to_union_pw_aff();
  return typed::union_pw_aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::union_pw_multi_aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::to_union_pw_multi_aff() const
{
  auto res = isl::aff::to_union_pw_multi_aff();
  return typed::union_pw_multi_aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::multi_pw_aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::union_add(const typed::multi_pw_aff<pair<Domain2, Range2>, Anonymous> &mpa2) const
{
  auto res = isl::aff::union_add(mpa2);
  return typed::multi_pw_aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::multi_union_pw_aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::union_add(const typed::multi_union_pw_aff<pair<Domain2, Range2>, Anonymous> &mupa2) const
{
  auto res = isl::aff::union_add(mupa2);
  return typed::multi_union_pw_aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::pw_aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::union_add(const typed::pw_aff<pair<Domain2, Range2>, Anonymous> &pwaff2) const
{
  auto res = isl::aff::union_add(pwaff2);
  return typed::pw_aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::pw_multi_aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::union_add(const typed::pw_multi_aff<pair<Domain2, Range2>, Anonymous> &pma2) const
{
  auto res = isl::aff::union_add(pma2);
  return typed::pw_multi_aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::union_pw_aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::union_add(const typed::union_pw_aff<pair<Domain2, Range2>, Anonymous> &upa2) const
{
  auto res = isl::aff::union_add(upa2);
  return typed::union_pw_aff<pair<Domain2, Range2>, Anonymous>(res);
}

template <typename Domain2, typename Range2>
typed::union_pw_multi_aff<pair<Domain2, Range2>, Anonymous> typed::aff<pair<Domain2, Range2>, Anonymous>::union_add(const typed::union_pw_multi_aff<pair<Domain2, Range2>, Anonymous> &upma2) const
{
  auto res = isl::aff::union_add(upma2);
  return typed::union_pw_multi_aff<pair<Domain2, Range2>, Anonymous>(res);
}

typed::aff_list<Anonymous>::aff_list(const isl::ctx &ctx, int n)
  : isl::aff_list(ctx, n)
{
}

typed::aff_list<Anonymous>::aff_list(const typed::aff<Anonymous> &el)
  : isl::aff_list(el)
{
}

typed::aff_list<Anonymous>::aff_list(const isl::ctx &ctx, const std::string &str)
  : isl::aff_list(ctx, str)
{
}

typed::aff_list<Anonymous> typed::aff_list<Anonymous>::add(const typed::aff<Anonymous> &el) const
{
  auto res = isl::aff_list::add(el);
  return typed::aff_list<Anonymous>(res);
}

typed::aff<Anonymous> typed::aff_list<Anonymous>::at(int index) const
{
  auto res = isl::aff_list::at(index);
  return typed::aff<Anonymous>(res);
}

typed::aff_list<Anonymous> typed::aff_list<Anonymous>::drop(unsigned int first, unsigned int n) const
{
  auto res = isl::aff_list::drop(first, n);
  return typed::aff_list<Anonymous>(res);
}

void typed::aff_list<Anonymous>::foreach(const std::function<void(typed::aff<Anonymous>)> &fn) const
{
  auto lambda_fn = [&] (isl::aff arg0) {
    return fn(typed::aff<Anonymous>(arg0));
  };
  return isl::aff_list::foreach(lambda_fn);
}

void typed::aff_list<Anonymous>::foreach_scc(const std::function<bool(typed::aff<Anonymous>, typed::aff<Anonymous>)> &follows, const std::function<void(typed::aff_list<Anonymous>)> &fn) const
{
  auto lambda_follows = [&] (isl::aff arg0, isl::aff arg1) {
    return follows(typed::aff<Anonymous>(arg0), typed::aff<Anonymous>(arg1));
  };
  auto lambda_fn = [&] (isl::aff_list arg0) {
    return fn(typed::aff_list<Anonymous>(arg0));
  };
  return isl::aff_list::foreach_scc(lambda_follows, lambda_fn);
}

typed::aff_list<Anonymous> typed::aff_list<Anonymous>::set_at(int index, const typed::aff<Anonymous> &el) const
{
  auto res = isl::aff_list::set_at(index, el);
  return typed::aff_list<Anonymous>(res);
}

template <typename Domain>
typed::aff_list<Domain, Anonymous>::aff_list(const isl::ctx &ctx, int n)
  : isl::aff_list(ctx, n)
{
}

template <typename Domain>
typed::aff_list<Domain, Anonymous>::aff_list(const typed::aff<Domain, Anonymous> &el)
  : isl::aff_list(el)
{
}

template <typename Domain>
typed::aff_list<Domain, Anonymous>::aff_list(const isl::ctx &ctx, const std::string &str)
  : isl::aff_list(ctx, str)
{
}

template <typename Domain>
typed::aff_list<Domain, Anonymous> typed::aff_list<Domain, Anonymous>::add(const typed::aff<Domain, Anonymous> &el) const
{
  auto res = isl::aff_list::add(el);
  return typed::aff_list<Domain, Anonymous>(res);
}

template <typename Domain>
typed::aff<Domain, Anonymous> typed::aff_list<Domain, Anonymous>::at(int index) const
{
  auto res = isl::aff_list::at(index);
  return typed::aff<Domain, Anonymous>(res);
}

template <typename Domain>
typed::aff_list<Domain, Anonymous> typed::aff_list<Domain, Anonymous>::drop(unsigned int first, unsigned int n) const
{
  auto res = isl::aff_list::drop(first, n);
  return typed::aff_list<Domain, Anonymous>(res);
}

template <typename Domain>
void typed::aff_list<Domain, Anonymous>::foreach(const std::function<void(typed::aff<Domain, Anonymous>)> &fn) const
{
  auto lambda_fn = [&] (isl::aff arg0) {
    return fn(typed::aff<Domain, Anonymous>(arg0));
  };
  return isl::aff_list::foreach(lambda_fn);
}

template <typename Domain>
void typed::aff_list<Domain, Anonymous>::foreach_scc(const std::function<bool(typed::aff<Domain, Anonymous>, typed::aff<Domain, Anonymous>)> &follows, const std::function<void(typed::aff_list<Domain, Anonymous>)> &fn) const
{
  auto lambda_follows = [&] (isl::aff arg0, isl::aff arg1) {
    return follows(typed::aff<Domain, Anonymous>(arg0), typed::aff<Domain, Anonymous>(arg1));
  };
  auto lambda_fn = [&] (isl::aff_list arg0) {
    return fn(typed::aff_list<Domain, Anonymous>(arg0));
  };
  return isl::aff_list::foreach_scc(lambda_follows, lambda_fn);
}

template <typename Domain>
typed::aff_list<Domain, Anonymous> typed::aff_list<Domain, Anonymous>::set_at(int index, const typed::aff<Domain, Anonymous> &el) const
{
  auto res = isl::aff_list::set_at(index, el);
  return typed::aff_list<Domain, Anonymous>(res);
}

template <typename Domain, typename Range>
typed::basic_map<Domain, Range>::basic_map(const isl::ctx &ctx, const std::string &str)
  : isl::basic_map(ctx, str)
{
}

template <typename Domain, typename Range>
template <typename Domain2>
typed::basic_map<Domain2, Range> typed::basic_map<Domain, Range>::apply_domain(const typed::basic_map<Domain, Domain2> &bmap2) const
{
  auto res = isl::basic_map::apply_domain(bmap2);
  return typed::basic_map<Domain2, Range>(res);
}

template <typename Domain, typename Range>
template <typename Domain2>
typed::map<Domain2, Range> typed::basic_map<Domain, Range>::apply_domain(const typed::map<Domain, Domain2> &map2) const
{
  auto res = isl::basic_map::apply_domain(map2);
  return typed::map<Domain2, Range>(res);
}

template <typename Domain, typename Range>
template <typename Domain2>
typed::union_map<Domain2, Range> typed::basic_map<Domain, Range>::apply_domain(const typed::union_map<Domain, Domain2> &umap2) const
{
  auto res = isl::basic_map::apply_domain(umap2);
  return typed::union_map<Domain2, Range>(res);
}

template <typename Domain, typename Range>
template <typename Range2>
typed::basic_map<Domain, Range2> typed::basic_map<Domain, Range>::apply_range(const typed::basic_map<Range, Range2> &bmap2) const
{
  auto res = isl::basic_map::apply_range(bmap2);
  return typed::basic_map<Domain, Range2>(res);
}

template <typename Domain, typename Range>
template <typename Range2>
typed::map<Domain, Range2> typed::basic_map<Domain, Range>::apply_range(const typed::map<Range, Range2> &map2) const
{
  auto res = isl::basic_map::apply_range(map2);
  return typed::map<Domain, Range2>(res);
}

template <typename Domain, typename Range>
template <typename Range2>
typed::union_map<Domain, Range2> typed::basic_map<Domain, Range>::apply_range(const typed::union_map<Range, Range2> &umap2) const
{
  auto res = isl::basic_map::apply_range(umap2);
  return typed::union_map<Domain, Range2>(res);
}

template <typename Domain, typename Range>
typed::map<Domain, Range> typed::basic_map<Domain, Range>::as_map() const
{
  auto res = isl::basic_map::as_map();
  return typed::map<Domain, Range>(res);
}

template <typename Domain, typename Range>
typed::multi_union_pw_aff<Domain, Range> typed::basic_map<Domain, Range>::as_multi_union_pw_aff() const
{
  auto res = isl::basic_map::as_multi_union_pw_aff();
  return typed::multi_union_pw_aff<Domain, Range>(res);
}

template <typename Domain, typename Range>
typed::pw_multi_aff<Domain, Range> typed::basic_map<Domain, Range>::as_pw_multi_aff() const
{
  auto res = isl::basic_map::as_pw_multi_aff();
  return typed::pw_multi_aff<Domain, Range>(res);
}

template <typename Domain, typename Range>
typed::union_pw_multi_aff<Domain, Range> typed::basic_map<Domain, Range>::as_union_pw_multi_aff() const
{
  auto res = isl::basic_map::as_union_pw_multi_aff();
  return typed::union_pw_multi_aff<Domain, Range>(res);
}

template <typename Domain, typename Range>
typed::set<Range> typed::basic_map<Domain, Range>::bind_domain(const typed::multi_id<Domain> &tuple) const
{
  auto res = isl::basic_map::bind_domain(tuple);
  return typed::set<Range>(res);
}

template <typename Domain, typename Range>
typed::set<Domain> typed::basic_map<Domain, Range>::bind_range(const typed::multi_id<Range> &tuple) const
{
  auto res = isl::basic_map::bind_range(tuple);
  return typed::set<Domain>(res);
}

template <typename Domain, typename Range>
typed::map<Domain, Range> typed::basic_map<Domain, Range>::coalesce() const
{
  auto res = isl::basic_map::coalesce();
  return typed::map<Domain, Range>(res);
}

template <typename Domain, typename Range>
typed::basic_map<Domain, Range> typed::basic_map<Domain, Range>::detect_equalities() const
{
  auto res = isl::basic_map::detect_equalities();
  return typed::basic_map<Domain, Range>(res);
}

template <typename Domain, typename Range>
typed::set<Domain> typed::basic_map<Domain, Range>::domain() const
{
  auto res = isl::basic_map::domain();
  return typed::set<Domain>(res);
}

template <typename Domain, typename Range>
typed::union_map<pair<Domain, Range>, Domain> typed::basic_map<Domain, Range>::domain_map() const
{
  auto res = isl::basic_map::domain_map();
  return typed::union_map<pair<Domain, Range>, Domain>(res);
}

template <typename Domain, typename Range>
typed::union_pw_multi_aff<pair<Domain, Range>, Domain> typed::basic_map<Domain, Range>::domain_map_union_pw_multi_aff() const
{
  auto res = isl::basic_map::domain_map_union_pw_multi_aff();
  return typed::union_pw_multi_aff<pair<Domain, Range>, Domain>(res);
}

template <typename Domain, typename Range>
template <typename Domain2>
typed::map<pair<Domain, Domain2>, Range> typed::basic_map<Domain, Range>::domain_product(const typed::map<Domain2, Range> &map2) const
{
  auto res = isl::basic_map::domain_product(map2);
  return typed::map<pair<Domain, Domain2>, Range>(res);
}

template <typename Domain, typename Range>
template <typename Domain2>
typed::union_map<pair<Domain, Domain2>, Range> typed::basic_map<Domain, Range>::domain_product(const typed::union_map<Domain2, Range> &umap2) const
{
  auto res = isl::basic_map::domain_product(umap2);
  return typed::union_map<pair<Domain, Domain2>, Range>(res);
}

template <typename Domain, typename Range>
typed::map<Domain, Range> typed::basic_map<Domain, Range>::drop_unused_params() const
{
  auto res = isl::basic_map::drop_unused_params();
  return typed::map<Domain, Range>(res);
}

template <typename Domain, typename Range>
bool typed::basic_map<Domain, Range>::every_map(const std::function<bool(typed::map<Domain, Range>)> &test) const
{
  auto lambda_test = [&] (isl::map arg0) {
    return test(typed::map<Domain, Range>(arg0));
  };
  return isl::basic_map::every_map(lambda_test);
}

template <typename Domain, typename Range>
typed::map<Domain, Range> typed::basic_map<Domain, Range>::extract_map(const typed::space<Domain, Range> &space) const
{
  auto res = isl::basic_map::extract_map(space);
  return typed::map<Domain, Range>(res);
}

template <typename Domain, typename Range>
void typed::basic_map<Domain, Range>::foreach_basic_map(const std::function<void(typed::basic_map<Domain, Range>)> &fn) const
{
  auto lambda_fn = [&] (isl::basic_map arg0) {
    return fn(typed::basic_map<Domain, Range>(arg0));
  };
  return isl::basic_map::foreach_basic_map(lambda_fn);
}

template <typename Domain, typename Range>
void typed::basic_map<Domain, Range>::foreach_map(const std::function<void(typed::map<Domain, Range>)> &fn) const
{
  auto lambda_fn = [&] (isl::map arg0) {
    return fn(typed::map<Domain, Range>(arg0));
  };
  return isl::basic_map::foreach_map(lambda_fn);
}

template <typename Domain, typename Range>
typed::basic_map<Domain, Range> typed::basic_map<Domain, Range>::gist(const typed::basic_map<Domain, Range> &context) const
{
  auto res = isl::basic_map::gist(context);
  return typed::basic_map<Domain, Range>(res);
}

template <typename Domain, typename Range>
typed::map<Domain, Range> typed::basic_map<Domain, Range>::gist(const typed::map<Domain, Range> &context) const
{
  auto res = isl::basic_map::gist(context);
  return typed::map<Domain, Range>(res);
}

template <typename Domain, typename Range>
typed::union_map<Domain, Range> typed::basic_map<Domain, Range>::gist(const typed::union_map<Domain, Range> &context) const
{
  auto res = isl::basic_map::gist(context);
  return typed::union_map<Domain, Range>(res);
}

template <typename Domain, typename Range>
typed::map<Domain, Range> typed::basic_map<Domain, Range>::gist_domain(const typed::set<Domain> &context) const
{
  auto res = isl::basic_map::gist_domain(context);
  return typed::map<Domain, Range>(res);
}

template <typename Domain, typename Range>
typed::union_map<Domain, Range> typed::basic_map<Domain, Range>::gist_domain(const typed::union_set<Domain> &uset) const
{
  auto res = isl::basic_map::gist_domain(uset);
  return typed::union_map<Domain, Range>(res);
}

template <typename Domain, typename Range>
typed::map<Domain, Range> typed::basic_map<Domain, Range>::gist_params(const typed::set<> &context) const
{
  auto res = isl::basic_map::gist_params(context);
  return typed::map<Domain, Range>(res);
}

template <typename Domain, typename Range>
typed::basic_map<Domain, Range> typed::basic_map<Domain, Range>::intersect(const typed::basic_map<Domain, Range> &bmap2) const
{
  auto res = isl::basic_map::intersect(bmap2);
  return typed::basic_map<Domain, Range>(res);
}

template <typename Domain, typename Range>
typed::map<Domain, Range> typed::basic_map<Domain, Range>::intersect(const typed::map<Domain, Range> &map2) const
{
  auto res = isl::basic_map::intersect(map2);
  return typed::map<Domain, Range>(res);
}

template <typename Domain, typename Range>
typed::union_map<Domain, Range> typed::basic_map<Domain, Range>::intersect(const typed::union_map<Domain, Range> &umap2) const
{
  auto res = isl::basic_map::intersect(umap2);
  return typed::union_map<Domain, Range>(res);
}

template <typename Domain, typename Range>
typed::basic_map<Domain, Range> typed::basic_map<Domain, Range>::intersect_domain(const typed::basic_set<Domain> &bset) const
{
  auto res = isl::basic_map::intersect_domain(bset);
  return typed::basic_map<Domain, Range>(res);
}

template <typename Domain, typename Range>
typed::map<Domain, Range> typed::basic_map<Domain, Range>::intersect_domain(const typed::set<Domain> &set) const
{
  auto res = isl::basic_map::intersect_domain(set);
  return typed::map<Domain, Range>(res);
}

template <typename Domain, typename Range>
typed::union_map<Domain, Range> typed::basic_map<Domain, Range>::intersect_domain(const typed::space<Domain> &space) const
{
  auto res = isl::basic_map::intersect_domain(space);
  return typed::union_map<Domain, Range>(res);
}

template <typename Domain, typename Range>
typed::union_map<Domain, Range> typed::basic_map<Domain, Range>::intersect_domain(const typed::union_set<Domain> &uset) const
{
  auto res = isl::basic_map::intersect_domain(uset);
  return typed::union_map<Domain, Range>(res);
}

template <typename Domain, typename Range>
typed::basic_map<Domain, Range> typed::basic_map<Domain, Range>::intersect_domain(const typed::point<Domain> &bset) const
{
  auto res = isl::basic_map::intersect_domain(bset);
  return typed::basic_map<Domain, Range>(res);
}

template <typename Domain, typename Range>
typed::map<Domain, Range> typed::basic_map<Domain, Range>::intersect_params(const typed::set<> &params) const
{
  auto res = isl::basic_map::intersect_params(params);
  return typed::map<Domain, Range>(res);
}

template <typename Domain, typename Range>
typed::basic_map<Domain, Range> typed::basic_map<Domain, Range>::intersect_range(const typed::basic_set<Range> &bset) const
{
  auto res = isl::basic_map::intersect_range(bset);
  return typed::basic_map<Domain, Range>(res);
}

template <typename Domain, typename Range>
typed::map<Domain, Range> typed::basic_map<Domain, Range>::intersect_range(const typed::set<Range> &set) const
{
  auto res = isl::basic_map::intersect_range(set);
  return typed::map<Domain, Range>(res);
}

template <typename Domain, typename Range>
typed::union_map<Domain, Range> typed::basic_map<Domain, Range>::intersect_range(const typed::space<Range> &space) const
{
  auto res = isl::basic_map::intersect_range(space);
  return typed::union_map<Domain, Range>(res);
}

template <typename Domain, typename Range>
typed::union_map<Domain, Range> typed::basic_map<Domain, Range>::intersect_range(const typed::union_set<Range> &uset) const
{
  auto res = isl::basic_map::intersect_range(uset);
  return typed::union_map<Domain, Range>(res);
}

template <typename Domain, typename Range>
typed::basic_map<Domain, Range> typed::basic_map<Domain, Range>::intersect_range(const typed::point<Range> &bset) const
{
  auto res = isl::basic_map::intersect_range(bset);
  return typed::basic_map<Domain, Range>(res);
}

template <typename Domain, typename Range>
typed::map<Domain, Range> typed::basic_map<Domain, Range>::lexmax() const
{
  auto res = isl::basic_map::lexmax();
  return typed::map<Domain, Range>(res);
}

template <typename Domain, typename Range>
typed::pw_multi_aff<Domain, Range> typed::basic_map<Domain, Range>::lexmax_pw_multi_aff() const
{
  auto res = isl::basic_map::lexmax_pw_multi_aff();
  return typed::pw_multi_aff<Domain, Range>(res);
}

template <typename Domain, typename Range>
typed::map<Domain, Range> typed::basic_map<Domain, Range>::lexmin() const
{
  auto res = isl::basic_map::lexmin();
  return typed::map<Domain, Range>(res);
}

template <typename Domain, typename Range>
typed::pw_multi_aff<Domain, Range> typed::basic_map<Domain, Range>::lexmin_pw_multi_aff() const
{
  auto res = isl::basic_map::lexmin_pw_multi_aff();
  return typed::pw_multi_aff<Domain, Range>(res);
}

template <typename Domain, typename Range>
typed::map<Domain, Range> typed::basic_map<Domain, Range>::lower_bound(const typed::multi_pw_aff<Domain, Range> &lower) const
{
  auto res = isl::basic_map::lower_bound(lower);
  return typed::map<Domain, Range>(res);
}

template <typename Domain, typename Range>
typed::map_list<Domain, Range> typed::basic_map<Domain, Range>::map_list() const
{
  auto res = isl::basic_map::map_list();
  return typed::map_list<Domain, Range>(res);
}

template <typename Domain, typename Range>
typed::multi_pw_aff<Domain, Range> typed::basic_map<Domain, Range>::max_multi_pw_aff() const
{
  auto res = isl::basic_map::max_multi_pw_aff();
  return typed::multi_pw_aff<Domain, Range>(res);
}

template <typename Domain, typename Range>
typed::multi_pw_aff<Domain, Range> typed::basic_map<Domain, Range>::min_multi_pw_aff() const
{
  auto res = isl::basic_map::min_multi_pw_aff();
  return typed::multi_pw_aff<Domain, Range>(res);
}

template <typename Domain, typename Range>
typed::set<> typed::basic_map<Domain, Range>::params() const
{
  auto res = isl::basic_map::params();
  return typed::set<>(res);
}

template <typename Domain, typename Range>
template <typename Domain2>
typed::map<Domain2, Range> typed::basic_map<Domain, Range>::preimage_domain(const typed::multi_aff<Domain2, Domain> &ma) const
{
  auto res = isl::basic_map::preimage_domain(ma);
  return typed::map<Domain2, Range>(res);
}

template <typename Domain, typename Range>
template <typename Domain2>
typed::map<Domain2, Range> typed::basic_map<Domain, Range>::preimage_domain(const typed::multi_pw_aff<Domain2, Domain> &mpa) const
{
  auto res = isl::basic_map::preimage_domain(mpa);
  return typed::map<Domain2, Range>(res);
}

template <typename Domain, typename Range>
template <typename Domain2>
typed::map<Domain2, Range> typed::basic_map<Domain, Range>::preimage_domain(const typed::pw_multi_aff<Domain2, Domain> &pma) const
{
  auto res = isl::basic_map::preimage_domain(pma);
  return typed::map<Domain2, Range>(res);
}

template <typename Domain, typename Range>
template <typename Domain2>
typed::union_map<Domain2, Range> typed::basic_map<Domain, Range>::preimage_domain(const typed::union_pw_multi_aff<Domain2, Domain> &upma) const
{
  auto res = isl::basic_map::preimage_domain(upma);
  return typed::union_map<Domain2, Range>(res);
}

template <typename Domain, typename Range>
template <typename Range2>
typed::map<Domain, Range2> typed::basic_map<Domain, Range>::preimage_range(const typed::multi_aff<Range2, Range> &ma) const
{
  auto res = isl::basic_map::preimage_range(ma);
  return typed::map<Domain, Range2>(res);
}

template <typename Domain, typename Range>
template <typename Range2>
typed::map<Domain, Range2> typed::basic_map<Domain, Range>::preimage_range(const typed::pw_multi_aff<Range2, Range> &pma) const
{
  auto res = isl::basic_map::preimage_range(pma);
  return typed::map<Domain, Range2>(res);
}

template <typename Domain, typename Range>
template <typename Range2>
typed::union_map<Domain, Range2> typed::basic_map<Domain, Range>::preimage_range(const typed::union_pw_multi_aff<Range2, Range> &upma) const
{
  auto res = isl::basic_map::preimage_range(upma);
  return typed::union_map<Domain, Range2>(res);
}

template <typename Domain, typename Range>
template <typename Domain2, typename Range2>
typed::map<pair<Domain, Domain2>, pair<Range, Range2>> typed::basic_map<Domain, Range>::product(const typed::map<Domain2, Range2> &map2) const
{
  auto res = isl::basic_map::product(map2);
  return typed::map<pair<Domain, Domain2>, pair<Range, Range2>>(res);
}

template <typename Domain, typename Range>
template <typename Domain2, typename Range2>
typed::union_map<pair<Domain, Domain2>, pair<Range, Range2>> typed::basic_map<Domain, Range>::product(const typed::union_map<Domain2, Range2> &umap2) const
{
  auto res = isl::basic_map::product(umap2);
  return typed::union_map<pair<Domain, Domain2>, pair<Range, Range2>>(res);
}

template <typename Domain, typename Range>
typed::map<Domain, Range> typed::basic_map<Domain, Range>::project_out_all_params() const
{
  auto res = isl::basic_map::project_out_all_params();
  return typed::map<Domain, Range>(res);
}

template <typename Domain, typename Range>
typed::map<Domain, Range> typed::basic_map<Domain, Range>::project_out_param(const typed::id<Anonymous> &id) const
{
  auto res = isl::basic_map::project_out_param(id);
  return typed::map<Domain, Range>(res);
}

template <typename Domain, typename Range>
typed::map<Domain, Range> typed::basic_map<Domain, Range>::project_out_param(const std::string &id) const
{
  auto res = isl::basic_map::project_out_param(id);
  return typed::map<Domain, Range>(res);
}

template <typename Domain, typename Range>
typed::map<Domain, Range> typed::basic_map<Domain, Range>::project_out_param(const typed::id_list<Anonymous> &list) const
{
  auto res = isl::basic_map::project_out_param(list);
  return typed::map<Domain, Range>(res);
}

template <typename Domain, typename Range>
typed::set<Range> typed::basic_map<Domain, Range>::range() const
{
  auto res = isl::basic_map::range();
  return typed::set<Range>(res);
}

template <typename Domain, typename Range>
typed::fixed_box<Domain, Range> typed::basic_map<Domain, Range>::range_lattice_tile() const
{
  auto res = isl::basic_map::range_lattice_tile();
  return typed::fixed_box<Domain, Range>(res);
}

template <typename Domain, typename Range>
typed::union_map<pair<Domain, Range>, Range> typed::basic_map<Domain, Range>::range_map() const
{
  auto res = isl::basic_map::range_map();
  return typed::union_map<pair<Domain, Range>, Range>(res);
}

template <typename Domain, typename Range>
template <typename Range2>
typed::map<Domain, pair<Range, Range2>> typed::basic_map<Domain, Range>::range_product(const typed::map<Domain, Range2> &map2) const
{
  auto res = isl::basic_map::range_product(map2);
  return typed::map<Domain, pair<Range, Range2>>(res);
}

template <typename Domain, typename Range>
template <typename Range2>
typed::union_map<Domain, pair<Range, Range2>> typed::basic_map<Domain, Range>::range_product(const typed::union_map<Domain, Range2> &umap2) const
{
  auto res = isl::basic_map::range_product(umap2);
  return typed::union_map<Domain, pair<Range, Range2>>(res);
}

template <typename Domain, typename Range>
typed::fixed_box<Domain, Range> typed::basic_map<Domain, Range>::range_simple_fixed_box_hull() const
{
  auto res = isl::basic_map::range_simple_fixed_box_hull();
  return typed::fixed_box<Domain, Range>(res);
}

template <typename Domain, typename Range>
typed::basic_map<Range, Domain> typed::basic_map<Domain, Range>::reverse() const
{
  auto res = isl::basic_map::reverse();
  return typed::basic_map<Range, Domain>(res);
}

template <typename Domain, typename Range>
template <typename Domain2>
typed::map<Domain2, Range> typed::basic_map<Domain, Range>::set_domain_tuple(const typed::id<Anonymous> &id) const
{
  auto res = isl::basic_map::set_domain_tuple(id);
  return typed::map<Domain2, Range>(res);
}

template <typename Domain, typename Range>
template <typename Domain2>
typed::map<Domain2, Range> typed::basic_map<Domain, Range>::set_domain_tuple(const std::string &id) const
{
  auto res = isl::basic_map::set_domain_tuple(id);
  return typed::map<Domain2, Range>(res);
}

template <typename Domain, typename Range>
template <typename Range2>
typed::map<Domain, Range2> typed::basic_map<Domain, Range>::set_range_tuple(const typed::id<Anonymous> &id) const
{
  auto res = isl::basic_map::set_range_tuple(id);
  return typed::map<Domain, Range2>(res);
}

template <typename Domain, typename Range>
template <typename Range2>
typed::map<Domain, Range2> typed::basic_map<Domain, Range>::set_range_tuple(const std::string &id) const
{
  auto res = isl::basic_map::set_range_tuple(id);
  return typed::map<Domain, Range2>(res);
}

template <typename Domain, typename Range>
typed::space<Domain, Range> typed::basic_map<Domain, Range>::space() const
{
  auto res = isl::basic_map::space();
  return typed::space<Domain, Range>(res);
}

template <typename Domain, typename Range>
typed::map<Domain, Range> typed::basic_map<Domain, Range>::subtract(const typed::map<Domain, Range> &map2) const
{
  auto res = isl::basic_map::subtract(map2);
  return typed::map<Domain, Range>(res);
}

template <typename Domain, typename Range>
typed::union_map<Domain, Range> typed::basic_map<Domain, Range>::subtract(const typed::union_map<Domain, Range> &umap2) const
{
  auto res = isl::basic_map::subtract(umap2);
  return typed::union_map<Domain, Range>(res);
}

template <typename Domain, typename Range>
typed::union_map<Domain, Range> typed::basic_map<Domain, Range>::subtract_domain(const typed::union_set<Domain> &dom) const
{
  auto res = isl::basic_map::subtract_domain(dom);
  return typed::union_map<Domain, Range>(res);
}

template <typename Domain, typename Range>
typed::union_map<Domain, Range> typed::basic_map<Domain, Range>::subtract_range(const typed::union_set<Range> &dom) const
{
  auto res = isl::basic_map::subtract_range(dom);
  return typed::union_map<Domain, Range>(res);
}

template <typename Domain, typename Range>
typed::union_map<Domain, Range> typed::basic_map<Domain, Range>::to_union_map() const
{
  auto res = isl::basic_map::to_union_map();
  return typed::union_map<Domain, Range>(res);
}

template <typename Domain, typename Range>
typed::map<Domain, Range> typed::basic_map<Domain, Range>::unite(const typed::basic_map<Domain, Range> &bmap2) const
{
  auto res = isl::basic_map::unite(bmap2);
  return typed::map<Domain, Range>(res);
}

template <typename Domain, typename Range>
typed::map<Domain, Range> typed::basic_map<Domain, Range>::unite(const typed::map<Domain, Range> &map2) const
{
  auto res = isl::basic_map::unite(map2);
  return typed::map<Domain, Range>(res);
}

template <typename Domain, typename Range>
typed::union_map<Domain, Range> typed::basic_map<Domain, Range>::unite(const typed::union_map<Domain, Range> &umap2) const
{
  auto res = isl::basic_map::unite(umap2);
  return typed::union_map<Domain, Range>(res);
}

template <typename Domain, typename Range>
typed::map<Domain, Range> typed::basic_map<Domain, Range>::upper_bound(const typed::multi_pw_aff<Domain, Range> &upper) const
{
  auto res = isl::basic_map::upper_bound(upper);
  return typed::map<Domain, Range>(res);
}

template <typename Domain, typename Range>
typed::set<pair<Domain, Range>> typed::basic_map<Domain, Range>::wrap() const
{
  auto res = isl::basic_map::wrap();
  return typed::set<pair<Domain, Range>>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::basic_map<pair<Domain, Range>, Range2>::basic_map(const isl::ctx &ctx, const std::string &str)
  : isl::basic_map(ctx, str)
{
}

template <typename Domain, typename Range, typename Range2>
template <typename Domain2>
typed::basic_map<Domain2, Range2> typed::basic_map<pair<Domain, Range>, Range2>::apply_domain(const typed::basic_map<pair<Domain, Range>, Domain2> &bmap2) const
{
  auto res = isl::basic_map::apply_domain(bmap2);
  return typed::basic_map<Domain2, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
template <typename Domain2>
typed::map<Domain2, Range2> typed::basic_map<pair<Domain, Range>, Range2>::apply_domain(const typed::map<pair<Domain, Range>, Domain2> &map2) const
{
  auto res = isl::basic_map::apply_domain(map2);
  return typed::map<Domain2, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
template <typename Domain2>
typed::union_map<Domain2, Range2> typed::basic_map<pair<Domain, Range>, Range2>::apply_domain(const typed::union_map<pair<Domain, Range>, Domain2> &umap2) const
{
  auto res = isl::basic_map::apply_domain(umap2);
  return typed::union_map<Domain2, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
template <typename Arg3>
typed::basic_map<pair<Domain, Range>, Arg3> typed::basic_map<pair<Domain, Range>, Range2>::apply_range(const typed::basic_map<Range2, Arg3> &bmap2) const
{
  auto res = isl::basic_map::apply_range(bmap2);
  return typed::basic_map<pair<Domain, Range>, Arg3>(res);
}

template <typename Domain, typename Range, typename Range2>
template <typename Arg3>
typed::map<pair<Domain, Range>, Arg3> typed::basic_map<pair<Domain, Range>, Range2>::apply_range(const typed::map<Range2, Arg3> &map2) const
{
  auto res = isl::basic_map::apply_range(map2);
  return typed::map<pair<Domain, Range>, Arg3>(res);
}

template <typename Domain, typename Range, typename Range2>
template <typename Arg3>
typed::union_map<pair<Domain, Range>, Arg3> typed::basic_map<pair<Domain, Range>, Range2>::apply_range(const typed::union_map<Range2, Arg3> &umap2) const
{
  auto res = isl::basic_map::apply_range(umap2);
  return typed::union_map<pair<Domain, Range>, Arg3>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::map<pair<Domain, Range>, Range2> typed::basic_map<pair<Domain, Range>, Range2>::as_map() const
{
  auto res = isl::basic_map::as_map();
  return typed::map<pair<Domain, Range>, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::multi_union_pw_aff<pair<Domain, Range>, Range2> typed::basic_map<pair<Domain, Range>, Range2>::as_multi_union_pw_aff() const
{
  auto res = isl::basic_map::as_multi_union_pw_aff();
  return typed::multi_union_pw_aff<pair<Domain, Range>, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::pw_multi_aff<pair<Domain, Range>, Range2> typed::basic_map<pair<Domain, Range>, Range2>::as_pw_multi_aff() const
{
  auto res = isl::basic_map::as_pw_multi_aff();
  return typed::pw_multi_aff<pair<Domain, Range>, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::union_pw_multi_aff<pair<Domain, Range>, Range2> typed::basic_map<pair<Domain, Range>, Range2>::as_union_pw_multi_aff() const
{
  auto res = isl::basic_map::as_union_pw_multi_aff();
  return typed::union_pw_multi_aff<pair<Domain, Range>, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::set<Range2> typed::basic_map<pair<Domain, Range>, Range2>::bind_domain(const typed::multi_id<pair<Domain, Range>> &tuple) const
{
  auto res = isl::basic_map::bind_domain(tuple);
  return typed::set<Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::set<pair<Domain, Range>> typed::basic_map<pair<Domain, Range>, Range2>::bind_range(const typed::multi_id<Range2> &tuple) const
{
  auto res = isl::basic_map::bind_range(tuple);
  return typed::set<pair<Domain, Range>>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::map<pair<Domain, Range>, Range2> typed::basic_map<pair<Domain, Range>, Range2>::coalesce() const
{
  auto res = isl::basic_map::coalesce();
  return typed::map<pair<Domain, Range>, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::map<Domain, pair<Range, Range2>> typed::basic_map<pair<Domain, Range>, Range2>::curry() const
{
  auto res = isl::basic_map::curry();
  return typed::map<Domain, pair<Range, Range2>>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::basic_map<pair<Domain, Range>, Range2> typed::basic_map<pair<Domain, Range>, Range2>::detect_equalities() const
{
  auto res = isl::basic_map::detect_equalities();
  return typed::basic_map<pair<Domain, Range>, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::set<pair<Domain, Range>> typed::basic_map<pair<Domain, Range>, Range2>::domain() const
{
  auto res = isl::basic_map::domain();
  return typed::set<pair<Domain, Range>>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::map<Domain, Range2> typed::basic_map<pair<Domain, Range>, Range2>::domain_factor_domain() const
{
  auto res = isl::basic_map::domain_factor_domain();
  return typed::map<Domain, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::map<Range, Range2> typed::basic_map<pair<Domain, Range>, Range2>::domain_factor_range() const
{
  auto res = isl::basic_map::domain_factor_range();
  return typed::map<Range, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::union_map<pair<pair<Domain, Range>, Range2>, pair<Domain, Range>> typed::basic_map<pair<Domain, Range>, Range2>::domain_map() const
{
  auto res = isl::basic_map::domain_map();
  return typed::union_map<pair<pair<Domain, Range>, Range2>, pair<Domain, Range>>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::union_pw_multi_aff<pair<pair<Domain, Range>, Range2>, pair<Domain, Range>> typed::basic_map<pair<Domain, Range>, Range2>::domain_map_union_pw_multi_aff() const
{
  auto res = isl::basic_map::domain_map_union_pw_multi_aff();
  return typed::union_pw_multi_aff<pair<pair<Domain, Range>, Range2>, pair<Domain, Range>>(res);
}

template <typename Domain, typename Range, typename Range2>
template <typename Domain2>
typed::map<pair<pair<Domain, Range>, Domain2>, Range2> typed::basic_map<pair<Domain, Range>, Range2>::domain_product(const typed::map<Domain2, Range2> &map2) const
{
  auto res = isl::basic_map::domain_product(map2);
  return typed::map<pair<pair<Domain, Range>, Domain2>, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
template <typename Domain2>
typed::union_map<pair<pair<Domain, Range>, Domain2>, Range2> typed::basic_map<pair<Domain, Range>, Range2>::domain_product(const typed::union_map<Domain2, Range2> &umap2) const
{
  auto res = isl::basic_map::domain_product(umap2);
  return typed::union_map<pair<pair<Domain, Range>, Domain2>, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::map<pair<Range, Domain>, Range2> typed::basic_map<pair<Domain, Range>, Range2>::domain_reverse() const
{
  auto res = isl::basic_map::domain_reverse();
  return typed::map<pair<Range, Domain>, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::map<pair<Domain, Range>, Range2> typed::basic_map<pair<Domain, Range>, Range2>::drop_unused_params() const
{
  auto res = isl::basic_map::drop_unused_params();
  return typed::map<pair<Domain, Range>, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
bool typed::basic_map<pair<Domain, Range>, Range2>::every_map(const std::function<bool(typed::map<pair<Domain, Range>, Range2>)> &test) const
{
  auto lambda_test = [&] (isl::map arg0) {
    return test(typed::map<pair<Domain, Range>, Range2>(arg0));
  };
  return isl::basic_map::every_map(lambda_test);
}

template <typename Domain, typename Range, typename Range2>
typed::map<pair<Domain, Range>, Range2> typed::basic_map<pair<Domain, Range>, Range2>::extract_map(const typed::space<pair<Domain, Range>, Range2> &space) const
{
  auto res = isl::basic_map::extract_map(space);
  return typed::map<pair<Domain, Range>, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::basic_map<Anonymous, Range2> typed::basic_map<pair<Domain, Range>, Range2>::flatten_domain() const
{
  auto res = isl::basic_map::flatten_domain();
  return typed::basic_map<Anonymous, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
void typed::basic_map<pair<Domain, Range>, Range2>::foreach_basic_map(const std::function<void(typed::basic_map<pair<Domain, Range>, Range2>)> &fn) const
{
  auto lambda_fn = [&] (isl::basic_map arg0) {
    return fn(typed::basic_map<pair<Domain, Range>, Range2>(arg0));
  };
  return isl::basic_map::foreach_basic_map(lambda_fn);
}

template <typename Domain, typename Range, typename Range2>
void typed::basic_map<pair<Domain, Range>, Range2>::foreach_map(const std::function<void(typed::map<pair<Domain, Range>, Range2>)> &fn) const
{
  auto lambda_fn = [&] (isl::map arg0) {
    return fn(typed::map<pair<Domain, Range>, Range2>(arg0));
  };
  return isl::basic_map::foreach_map(lambda_fn);
}

template <typename Domain, typename Range, typename Range2>
typed::basic_map<pair<Domain, Range>, Range2> typed::basic_map<pair<Domain, Range>, Range2>::gist(const typed::basic_map<pair<Domain, Range>, Range2> &context) const
{
  auto res = isl::basic_map::gist(context);
  return typed::basic_map<pair<Domain, Range>, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::map<pair<Domain, Range>, Range2> typed::basic_map<pair<Domain, Range>, Range2>::gist(const typed::map<pair<Domain, Range>, Range2> &context) const
{
  auto res = isl::basic_map::gist(context);
  return typed::map<pair<Domain, Range>, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::union_map<pair<Domain, Range>, Range2> typed::basic_map<pair<Domain, Range>, Range2>::gist(const typed::union_map<pair<Domain, Range>, Range2> &context) const
{
  auto res = isl::basic_map::gist(context);
  return typed::union_map<pair<Domain, Range>, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::map<pair<Domain, Range>, Range2> typed::basic_map<pair<Domain, Range>, Range2>::gist_domain(const typed::set<pair<Domain, Range>> &context) const
{
  auto res = isl::basic_map::gist_domain(context);
  return typed::map<pair<Domain, Range>, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::union_map<pair<Domain, Range>, Range2> typed::basic_map<pair<Domain, Range>, Range2>::gist_domain(const typed::union_set<pair<Domain, Range>> &uset) const
{
  auto res = isl::basic_map::gist_domain(uset);
  return typed::union_map<pair<Domain, Range>, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::map<pair<Domain, Range>, Range2> typed::basic_map<pair<Domain, Range>, Range2>::gist_params(const typed::set<> &context) const
{
  auto res = isl::basic_map::gist_params(context);
  return typed::map<pair<Domain, Range>, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::basic_map<pair<Domain, Range>, Range2> typed::basic_map<pair<Domain, Range>, Range2>::intersect(const typed::basic_map<pair<Domain, Range>, Range2> &bmap2) const
{
  auto res = isl::basic_map::intersect(bmap2);
  return typed::basic_map<pair<Domain, Range>, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::map<pair<Domain, Range>, Range2> typed::basic_map<pair<Domain, Range>, Range2>::intersect(const typed::map<pair<Domain, Range>, Range2> &map2) const
{
  auto res = isl::basic_map::intersect(map2);
  return typed::map<pair<Domain, Range>, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::union_map<pair<Domain, Range>, Range2> typed::basic_map<pair<Domain, Range>, Range2>::intersect(const typed::union_map<pair<Domain, Range>, Range2> &umap2) const
{
  auto res = isl::basic_map::intersect(umap2);
  return typed::union_map<pair<Domain, Range>, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::basic_map<pair<Domain, Range>, Range2> typed::basic_map<pair<Domain, Range>, Range2>::intersect_domain(const typed::basic_set<pair<Domain, Range>> &bset) const
{
  auto res = isl::basic_map::intersect_domain(bset);
  return typed::basic_map<pair<Domain, Range>, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::map<pair<Domain, Range>, Range2> typed::basic_map<pair<Domain, Range>, Range2>::intersect_domain(const typed::set<pair<Domain, Range>> &set) const
{
  auto res = isl::basic_map::intersect_domain(set);
  return typed::map<pair<Domain, Range>, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::union_map<pair<Domain, Range>, Range2> typed::basic_map<pair<Domain, Range>, Range2>::intersect_domain(const typed::space<pair<Domain, Range>> &space) const
{
  auto res = isl::basic_map::intersect_domain(space);
  return typed::union_map<pair<Domain, Range>, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::union_map<pair<Domain, Range>, Range2> typed::basic_map<pair<Domain, Range>, Range2>::intersect_domain(const typed::union_set<pair<Domain, Range>> &uset) const
{
  auto res = isl::basic_map::intersect_domain(uset);
  return typed::union_map<pair<Domain, Range>, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::basic_map<pair<Domain, Range>, Range2> typed::basic_map<pair<Domain, Range>, Range2>::intersect_domain(const typed::point<pair<Domain, Range>> &bset) const
{
  auto res = isl::basic_map::intersect_domain(bset);
  return typed::basic_map<pair<Domain, Range>, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::map<pair<Domain, Range>, Range2> typed::basic_map<pair<Domain, Range>, Range2>::intersect_domain_wrapped_domain(const typed::set<Domain> &domain) const
{
  auto res = isl::basic_map::intersect_domain_wrapped_domain(domain);
  return typed::map<pair<Domain, Range>, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::union_map<pair<Domain, Range>, Range2> typed::basic_map<pair<Domain, Range>, Range2>::intersect_domain_wrapped_domain(const typed::union_set<Domain> &domain) const
{
  auto res = isl::basic_map::intersect_domain_wrapped_domain(domain);
  return typed::union_map<pair<Domain, Range>, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::map<pair<Domain, Range>, Range2> typed::basic_map<pair<Domain, Range>, Range2>::intersect_params(const typed::set<> &params) const
{
  auto res = isl::basic_map::intersect_params(params);
  return typed::map<pair<Domain, Range>, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::basic_map<pair<Domain, Range>, Range2> typed::basic_map<pair<Domain, Range>, Range2>::intersect_range(const typed::basic_set<Range2> &bset) const
{
  auto res = isl::basic_map::intersect_range(bset);
  return typed::basic_map<pair<Domain, Range>, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::map<pair<Domain, Range>, Range2> typed::basic_map<pair<Domain, Range>, Range2>::intersect_range(const typed::set<Range2> &set) const
{
  auto res = isl::basic_map::intersect_range(set);
  return typed::map<pair<Domain, Range>, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::union_map<pair<Domain, Range>, Range2> typed::basic_map<pair<Domain, Range>, Range2>::intersect_range(const typed::space<Range2> &space) const
{
  auto res = isl::basic_map::intersect_range(space);
  return typed::union_map<pair<Domain, Range>, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::union_map<pair<Domain, Range>, Range2> typed::basic_map<pair<Domain, Range>, Range2>::intersect_range(const typed::union_set<Range2> &uset) const
{
  auto res = isl::basic_map::intersect_range(uset);
  return typed::union_map<pair<Domain, Range>, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::basic_map<pair<Domain, Range>, Range2> typed::basic_map<pair<Domain, Range>, Range2>::intersect_range(const typed::point<Range2> &bset) const
{
  auto res = isl::basic_map::intersect_range(bset);
  return typed::basic_map<pair<Domain, Range>, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::map<pair<Domain, Range>, Range2> typed::basic_map<pair<Domain, Range>, Range2>::lexmax() const
{
  auto res = isl::basic_map::lexmax();
  return typed::map<pair<Domain, Range>, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::pw_multi_aff<pair<Domain, Range>, Range2> typed::basic_map<pair<Domain, Range>, Range2>::lexmax_pw_multi_aff() const
{
  auto res = isl::basic_map::lexmax_pw_multi_aff();
  return typed::pw_multi_aff<pair<Domain, Range>, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::map<pair<Domain, Range>, Range2> typed::basic_map<pair<Domain, Range>, Range2>::lexmin() const
{
  auto res = isl::basic_map::lexmin();
  return typed::map<pair<Domain, Range>, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::pw_multi_aff<pair<Domain, Range>, Range2> typed::basic_map<pair<Domain, Range>, Range2>::lexmin_pw_multi_aff() const
{
  auto res = isl::basic_map::lexmin_pw_multi_aff();
  return typed::pw_multi_aff<pair<Domain, Range>, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::map<pair<Domain, Range>, Range2> typed::basic_map<pair<Domain, Range>, Range2>::lower_bound(const typed::multi_pw_aff<pair<Domain, Range>, Range2> &lower) const
{
  auto res = isl::basic_map::lower_bound(lower);
  return typed::map<pair<Domain, Range>, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::map_list<pair<Domain, Range>, Range2> typed::basic_map<pair<Domain, Range>, Range2>::map_list() const
{
  auto res = isl::basic_map::map_list();
  return typed::map_list<pair<Domain, Range>, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::multi_pw_aff<pair<Domain, Range>, Range2> typed::basic_map<pair<Domain, Range>, Range2>::max_multi_pw_aff() const
{
  auto res = isl::basic_map::max_multi_pw_aff();
  return typed::multi_pw_aff<pair<Domain, Range>, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::multi_pw_aff<pair<Domain, Range>, Range2> typed::basic_map<pair<Domain, Range>, Range2>::min_multi_pw_aff() const
{
  auto res = isl::basic_map::min_multi_pw_aff();
  return typed::multi_pw_aff<pair<Domain, Range>, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::set<> typed::basic_map<pair<Domain, Range>, Range2>::params() const
{
  auto res = isl::basic_map::params();
  return typed::set<>(res);
}

template <typename Domain, typename Range, typename Range2>
template <typename Domain2>
typed::map<Domain2, Range2> typed::basic_map<pair<Domain, Range>, Range2>::preimage_domain(const typed::multi_aff<Domain2, pair<Domain, Range>> &ma) const
{
  auto res = isl::basic_map::preimage_domain(ma);
  return typed::map<Domain2, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
template <typename Domain2>
typed::map<Domain2, Range2> typed::basic_map<pair<Domain, Range>, Range2>::preimage_domain(const typed::multi_pw_aff<Domain2, pair<Domain, Range>> &mpa) const
{
  auto res = isl::basic_map::preimage_domain(mpa);
  return typed::map<Domain2, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
template <typename Domain2>
typed::map<Domain2, Range2> typed::basic_map<pair<Domain, Range>, Range2>::preimage_domain(const typed::pw_multi_aff<Domain2, pair<Domain, Range>> &pma) const
{
  auto res = isl::basic_map::preimage_domain(pma);
  return typed::map<Domain2, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
template <typename Domain2>
typed::union_map<Domain2, Range2> typed::basic_map<pair<Domain, Range>, Range2>::preimage_domain(const typed::union_pw_multi_aff<Domain2, pair<Domain, Range>> &upma) const
{
  auto res = isl::basic_map::preimage_domain(upma);
  return typed::union_map<Domain2, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
template <typename Arg3>
typed::map<pair<Domain, Range>, Arg3> typed::basic_map<pair<Domain, Range>, Range2>::preimage_range(const typed::multi_aff<Arg3, Range2> &ma) const
{
  auto res = isl::basic_map::preimage_range(ma);
  return typed::map<pair<Domain, Range>, Arg3>(res);
}

template <typename Domain, typename Range, typename Range2>
template <typename Arg3>
typed::map<pair<Domain, Range>, Arg3> typed::basic_map<pair<Domain, Range>, Range2>::preimage_range(const typed::pw_multi_aff<Arg3, Range2> &pma) const
{
  auto res = isl::basic_map::preimage_range(pma);
  return typed::map<pair<Domain, Range>, Arg3>(res);
}

template <typename Domain, typename Range, typename Range2>
template <typename Arg3>
typed::union_map<pair<Domain, Range>, Arg3> typed::basic_map<pair<Domain, Range>, Range2>::preimage_range(const typed::union_pw_multi_aff<Arg3, Range2> &upma) const
{
  auto res = isl::basic_map::preimage_range(upma);
  return typed::union_map<pair<Domain, Range>, Arg3>(res);
}

template <typename Domain, typename Range, typename Range2>
template <typename Domain2, typename Arg3>
typed::map<pair<pair<Domain, Range>, Domain2>, pair<Range2, Arg3>> typed::basic_map<pair<Domain, Range>, Range2>::product(const typed::map<Domain2, Arg3> &map2) const
{
  auto res = isl::basic_map::product(map2);
  return typed::map<pair<pair<Domain, Range>, Domain2>, pair<Range2, Arg3>>(res);
}

template <typename Domain, typename Range, typename Range2>
template <typename Domain2, typename Arg3>
typed::union_map<pair<pair<Domain, Range>, Domain2>, pair<Range2, Arg3>> typed::basic_map<pair<Domain, Range>, Range2>::product(const typed::union_map<Domain2, Arg3> &umap2) const
{
  auto res = isl::basic_map::product(umap2);
  return typed::union_map<pair<pair<Domain, Range>, Domain2>, pair<Range2, Arg3>>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::map<pair<Domain, Range>, Range2> typed::basic_map<pair<Domain, Range>, Range2>::project_out_all_params() const
{
  auto res = isl::basic_map::project_out_all_params();
  return typed::map<pair<Domain, Range>, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::map<pair<Domain, Range>, Range2> typed::basic_map<pair<Domain, Range>, Range2>::project_out_param(const typed::id<Anonymous> &id) const
{
  auto res = isl::basic_map::project_out_param(id);
  return typed::map<pair<Domain, Range>, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::map<pair<Domain, Range>, Range2> typed::basic_map<pair<Domain, Range>, Range2>::project_out_param(const std::string &id) const
{
  auto res = isl::basic_map::project_out_param(id);
  return typed::map<pair<Domain, Range>, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::map<pair<Domain, Range>, Range2> typed::basic_map<pair<Domain, Range>, Range2>::project_out_param(const typed::id_list<Anonymous> &list) const
{
  auto res = isl::basic_map::project_out_param(list);
  return typed::map<pair<Domain, Range>, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::set<Range2> typed::basic_map<pair<Domain, Range>, Range2>::range() const
{
  auto res = isl::basic_map::range();
  return typed::set<Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::fixed_box<pair<Domain, Range>, Range2> typed::basic_map<pair<Domain, Range>, Range2>::range_lattice_tile() const
{
  auto res = isl::basic_map::range_lattice_tile();
  return typed::fixed_box<pair<Domain, Range>, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::union_map<pair<pair<Domain, Range>, Range2>, Range2> typed::basic_map<pair<Domain, Range>, Range2>::range_map() const
{
  auto res = isl::basic_map::range_map();
  return typed::union_map<pair<pair<Domain, Range>, Range2>, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
template <typename Arg3>
typed::map<pair<Domain, Range>, pair<Range2, Arg3>> typed::basic_map<pair<Domain, Range>, Range2>::range_product(const typed::map<pair<Domain, Range>, Arg3> &map2) const
{
  auto res = isl::basic_map::range_product(map2);
  return typed::map<pair<Domain, Range>, pair<Range2, Arg3>>(res);
}

template <typename Domain, typename Range, typename Range2>
template <typename Arg3>
typed::union_map<pair<Domain, Range>, pair<Range2, Arg3>> typed::basic_map<pair<Domain, Range>, Range2>::range_product(const typed::union_map<pair<Domain, Range>, Arg3> &umap2) const
{
  auto res = isl::basic_map::range_product(umap2);
  return typed::union_map<pair<Domain, Range>, pair<Range2, Arg3>>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::fixed_box<pair<Domain, Range>, Range2> typed::basic_map<pair<Domain, Range>, Range2>::range_simple_fixed_box_hull() const
{
  auto res = isl::basic_map::range_simple_fixed_box_hull();
  return typed::fixed_box<pair<Domain, Range>, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::basic_map<Range2, pair<Domain, Range>> typed::basic_map<pair<Domain, Range>, Range2>::reverse() const
{
  auto res = isl::basic_map::reverse();
  return typed::basic_map<Range2, pair<Domain, Range>>(res);
}

template <typename Domain, typename Range, typename Range2>
template <typename Arg2>
typed::map<pair<Domain, Range>, Arg2> typed::basic_map<pair<Domain, Range>, Range2>::set_range_tuple(const typed::id<Anonymous> &id) const
{
  auto res = isl::basic_map::set_range_tuple(id);
  return typed::map<pair<Domain, Range>, Arg2>(res);
}

template <typename Domain, typename Range, typename Range2>
template <typename Arg2>
typed::map<pair<Domain, Range>, Arg2> typed::basic_map<pair<Domain, Range>, Range2>::set_range_tuple(const std::string &id) const
{
  auto res = isl::basic_map::set_range_tuple(id);
  return typed::map<pair<Domain, Range>, Arg2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::space<pair<Domain, Range>, Range2> typed::basic_map<pair<Domain, Range>, Range2>::space() const
{
  auto res = isl::basic_map::space();
  return typed::space<pair<Domain, Range>, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::map<pair<Domain, Range>, Range2> typed::basic_map<pair<Domain, Range>, Range2>::subtract(const typed::map<pair<Domain, Range>, Range2> &map2) const
{
  auto res = isl::basic_map::subtract(map2);
  return typed::map<pair<Domain, Range>, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::union_map<pair<Domain, Range>, Range2> typed::basic_map<pair<Domain, Range>, Range2>::subtract(const typed::union_map<pair<Domain, Range>, Range2> &umap2) const
{
  auto res = isl::basic_map::subtract(umap2);
  return typed::union_map<pair<Domain, Range>, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::union_map<pair<Domain, Range>, Range2> typed::basic_map<pair<Domain, Range>, Range2>::subtract_domain(const typed::union_set<pair<Domain, Range>> &dom) const
{
  auto res = isl::basic_map::subtract_domain(dom);
  return typed::union_map<pair<Domain, Range>, Range2>(res);
}

template <typename Domain, typename Range, typename Range2>
typed::union_map<pair<Domain, Range>, Range2> typed::basic_map<pair<Domain, Range>, Range2>::subtract_range(const typed::union_set<Range2> &do