/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio.charset;

import gnu.java.nio.charset.US_ASCII;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

abstract class ByteCharset
extends Charset {
    protected static final char NONE = '\ufffd';
    protected char[] lookupTable;

    public boolean contains(Charset cs) {
        boolean bl = false;
        if (cs instanceof US_ASCII || cs.getClass() == this.getClass()) {
            bl = true;
        }
        return bl;
    }

    char[] getLookupTable() {
        return this.lookupTable;
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    ByteCharset(String canonicalName, String[] aliases) {
        super(canonicalName, aliases);
    }

    private static final class Decoder
    extends CharsetDecoder {
        private char[] lookup;

        protected final CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
            while (in.hasRemaining()) {
                byte b = in.get();
                if (!out.hasRemaining()) {
                    in.position(in.position() - 1);
                    return CoderResult.OVERFLOW;
                }
                char c = this.lookup[b & 0xFF];
                out.put(c);
            }
            return CoderResult.UNDERFLOW;
        }

        Decoder(ByteCharset cs) {
            super(cs, 1.0f, 1.0f);
            this.lookup = cs.getLookupTable();
        }
    }

    private static final class Encoder
    extends CharsetEncoder {
        private byte[] lookup;

        protected final CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
            while (in.hasRemaining()) {
                byte b;
                char c = in.get();
                if (!out.hasRemaining()) {
                    in.position(in.position() - 1);
                    return CoderResult.OVERFLOW;
                }
                byte by = 0;
                if (c < this.lookup.length) {
                    by = this.lookup[c];
                }
                if ((b = by) != 0 || c == '\u0000') {
                    out.put(b);
                    continue;
                }
                in.position(in.position() - 1);
                return CoderResult.unmappableForLength(1);
            }
            return CoderResult.UNDERFLOW;
        }

        Encoder(ByteCharset cs) {
            super(cs, 1.0f, 1.0f);
            char c;
            char[] lookup_table = cs.getLookupTable();
            char max = '\u0000';
            int i = 0;
            while (i < lookup_table.length) {
                c = lookup_table[i];
                max = c > max && c < '\ufffd' ? c : max;
                ++i;
            }
            this.lookup = new byte[max + 1];
            i = 0;
            while (i < lookup_table.length) {
                c = lookup_table[i];
                if (c != '\u0000' && c < '\ufffd') {
                    this.lookup[c] = (byte)i;
                }
                ++i;
            }
        }
    }
}

