/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;

class VirtualMachine {
    private static int numRootThreadsCreated;

    public static native void print(boolean var0);

    public static native void print(byte var0);

    public static native void print(short var0);

    public static native void print(char var0);

    public static native void print(int var0);

    public static native void print(long var0);

    public static native void print(float var0);

    public static native void print(double var0);

    public static native void print(String var0);

    public static native void println(boolean var0);

    public static native void println(byte var0);

    public static native void println(short var0);

    public static native void println(char var0);

    public static native void println(int var0);

    public static native void println(long var0);

    public static native void println(float var0);

    public static native void println(double var0);

    public static native void println(String var0);

    private static final void exceptionDescribe(Throwable e) {
        e.printStackTrace();
    }

    private static final String exceptionDescription(Throwable e) throws IOException {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        pw.close();
        sw.close();
        return sw.toString();
    }

    private static final String exceptionTruncatedDescription(Throwable e) {
        return e.toString();
    }

    private static final void main(String[] args) throws ClassNotFoundException {
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        Class mainClass = cl.loadClass(args[0]);
        String[] newArgs = new String[args.length - 1];
        System.arraycopy(args, 1, newArgs, 0, args.length - 1);
        VirtualMachine.invokeMain(mainClass, newArgs);
    }

    private static final native void invokeMain(Class var0, String[] var1);

    private static final Class createClass(ClassLoader cl, String name) throws ClassNotFoundException {
        return cl.loadClass(name.replace('/', '.'));
    }

    private static final Class createArray(ClassLoader cl, String name) throws ClassNotFoundException {
        return cl.createArray(name.replace('/', '.'), false);
    }

    private static final Thread createRootThread(byte[] vmData) {
        Thread thread = new Thread("Main-" + ++numRootThreadsCreated, ThreadGroup.root);
        thread.vmData = vmData;
        return thread;
    }

    private static final void runThread() {
        Thread.currentThread().callRun();
    }

    private static final byte[] getSystemClassLoader() {
        return ClassLoader.getSystemClassLoader().vmData;
    }

    VirtualMachine() {
    }
}

